/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.jpc.emulator.SRDumpable;
import org.jpc.jrsr.UTFInputLineStream;

public final class SRLoader {
    private InputStream underlyingInput;
    private SRDumpable[] objects;
    private int pendingObject;
    private long lastMsgTimestamp;
    private long objectNum;
    private long extLoads;
    private long intLoads;
    private static final int INITIAL_OBJECT_CAP = 16384;
    private static final int BUFFER_MAXSIZE = 4096;
    private int bufferFill;
    private int bufferStart;
    private boolean bufferEOF;
    private byte[] buffer;
    int lastSuccess;
    int opNum;

    public SRLoader(InputStream inputStream) {
        this.underlyingInput = inputStream;
        this.objects = new SRDumpable[16384];
        this.pendingObject = -1;
        this.opNum = 0;
        this.bufferFill = 0;
        this.bufferStart = 0;
        this.bufferEOF = false;
        this.buffer = new byte[4096];
        this.lastSuccess = 0;
    }

    public void ensureBufferFill(int n) throws IOException {
        if (n > 4096) {
            throw new IllegalStateException("ensureBufferFill: The amount requested is too large.");
        }
        if (n <= this.bufferFill) {
            return;
        }
        if (this.bufferFill > 0) {
            System.arraycopy(this.buffer, this.bufferStart, this.buffer, 0, this.bufferFill);
        }
        this.bufferStart = 0;
        while (n > this.bufferFill && !this.bufferEOF) {
            int n2 = this.underlyingInput.read(this.buffer, this.bufferFill, 4096 - this.bufferFill);
            if (n2 < 0) {
                this.bufferEOF = true;
                continue;
            }
            this.bufferFill += n2;
        }
        if (this.bufferFill < n && this.bufferEOF) {
            throw new IllegalStateException("ensureBufferFill: Unexpected end of stream");
        }
    }

    private static String interpretType(byte by) {
        switch (by) {
            case 1: {
                return "boolean";
            }
            case 2: {
                return "byte";
            }
            case 3: {
                return "short";
            }
            case 4: {
                return "int";
            }
            case 5: {
                return "long";
            }
            case 20: {
                return "double";
            }
            case 6: {
                return "String";
            }
            case 7: {
                return "boolean[]";
            }
            case 8: {
                return "byte[]";
            }
            case 9: {
                return "short[]";
            }
            case 10: {
                return "int[]";
            }
            case 11: {
                return "long[]";
            }
            case 12: {
                return "double[]";
            }
            case 13: {
                return "<object>";
            }
            case 14: {
                return "<object start>";
            }
            case 15: {
                return "<object end>";
            }
            case 16: {
                return "<special object>";
            }
            case 19: {
                return "<object not present>";
            }
        }
        return "<unknown type " + (by & 0xFF) + ">";
    }

    private void expect(byte by, int n) throws IOException {
        byte by2 = this.buffer[this.bufferStart++];
        --this.bufferFill;
        if (by != by2) {
            System.err.println("Last parsed: " + SRLoader.interpretType((byte)this.lastSuccess) + ".");
            throw new IOException("Dumper/Loader fucked up, expected " + SRLoader.interpretType(by) + ", got " + SRLoader.interpretType(by2) + " in tag #" + n + ".");
        }
        this.lastSuccess = by2;
    }

    public boolean loadBoolean() throws IOException {
        this.ensureBufferFill(2);
        this.expect((byte)1, this.opNum++);
        byte by = this.buffer[this.bufferStart++];
        --this.bufferFill;
        return by != 0;
    }

    public byte loadByte() throws IOException {
        this.ensureBufferFill(2);
        this.expect((byte)2, this.opNum++);
        byte by = this.buffer[this.bufferStart++];
        --this.bufferFill;
        return by;
    }

    public short loadShort() throws IOException {
        this.ensureBufferFill(3);
        this.expect((byte)3, this.opNum++);
        return this.readShort(false);
    }

    public int loadInt() throws IOException {
        this.ensureBufferFill(5);
        this.expect((byte)4, this.opNum++);
        return this.readInt(false);
    }

    public long loadLong() throws IOException {
        this.ensureBufferFill(9);
        this.expect((byte)5, this.opNum++);
        return this.readLong(false);
    }

    public double loadDouble() throws IOException {
        this.ensureBufferFill(9);
        this.expect((byte)20, this.opNum++);
        return Double.longBitsToDouble(this.readLong(false));
    }

    public String loadString() throws IOException {
        this.ensureBufferFill(2);
        this.expect((byte)6, this.opNum++);
        byte by = this.buffer[this.bufferStart++];
        --this.bufferFill;
        if (by != 0) {
            int n = this.readShort(true) & 0xFFFF;
            StringBuffer stringBuffer = new StringBuffer(n);
            int n2 = 0;
            int n3 = 0;
            while (n2 < n) {
                int n4;
                if (n3 < n && this.bufferFill < 4096) {
                    if (n - n2 > 4096) {
                        this.ensureBufferFill(4096);
                        n3 = n2 + 4096;
                    } else {
                        this.ensureBufferFill(n - n2);
                        n3 = n;
                    }
                }
                int n5 = this.buffer[this.bufferStart++] & 0xFF;
                --this.bufferFill;
                if (n5 < 128) {
                    stringBuffer.append((char)n5);
                    ++n2;
                    continue;
                }
                if (n5 < 224) {
                    n4 = this.buffer[this.bufferStart++] & 0x3F;
                    --this.bufferFill;
                    stringBuffer.append((char)(((n5 &= 0x1F) << 6) + n4));
                    n2 += 2;
                    continue;
                }
                n4 = this.buffer[this.bufferStart++] & 0x3F;
                --this.bufferFill;
                int n6 = this.buffer[this.bufferStart++] & 0x3F;
                --this.bufferFill;
                stringBuffer.append((char)(((n5 &= 0xF) << 12) + (n4 << 6) + n6));
                n2 += 3;
            }
            return stringBuffer.toString();
        }
        return null;
    }

    private short readShort(boolean bl) throws IOException {
        if (bl) {
            this.ensureBufferFill(4);
        }
        short s = (short)((short)this.buffer[this.bufferStart++] & 0xFF);
        --this.bufferFill;
        short s2 = (short)((short)this.buffer[this.bufferStart++] & 0xFF);
        --this.bufferFill;
        return (short)((s << 8) + s2);
    }

    private int readInt(boolean bl) throws IOException {
        if (bl) {
            this.ensureBufferFill(4);
        }
        int n = this.buffer[this.bufferStart++] & 0xFF;
        --this.bufferFill;
        int n2 = this.buffer[this.bufferStart++] & 0xFF;
        --this.bufferFill;
        int n3 = this.buffer[this.bufferStart++] & 0xFF;
        --this.bufferFill;
        int n4 = this.buffer[this.bufferStart++] & 0xFF;
        --this.bufferFill;
        int n5 = n * 0x1000000 + n2 * 65536 + n3 * 256 + n4;
        return n5;
    }

    private long readLong(boolean bl) throws IOException {
        if (bl) {
            this.ensureBufferFill(8);
        }
        long l = (long)this.buffer[this.bufferStart++] & 0xFFL;
        --this.bufferFill;
        long l2 = (long)this.buffer[this.bufferStart++] & 0xFFL;
        --this.bufferFill;
        long l3 = (long)this.buffer[this.bufferStart++] & 0xFFL;
        --this.bufferFill;
        long l4 = (long)this.buffer[this.bufferStart++] & 0xFFL;
        --this.bufferFill;
        long l5 = (long)this.buffer[this.bufferStart++] & 0xFFL;
        --this.bufferFill;
        long l6 = (long)this.buffer[this.bufferStart++] & 0xFFL;
        --this.bufferFill;
        long l7 = (long)this.buffer[this.bufferStart++] & 0xFFL;
        --this.bufferFill;
        long l8 = (long)this.buffer[this.bufferStart++] & 0xFFL;
        --this.bufferFill;
        return (l * 0x1000000L + l2 * 65536L + l3 * 256L + l4 << 32) + (l5 * 0x1000000L + l6 * 65536L + l7 * 256L + l8);
    }

    public boolean[] loadArrayBoolean() throws IOException {
        this.ensureBufferFill(2);
        this.expect((byte)7, this.opNum++);
        byte by = this.buffer[this.bufferStart++];
        --this.bufferFill;
        if (by != 0) {
            boolean[] blArray = new boolean[this.readInt(true)];
            for (int i = 0; i < blArray.length; ++i) {
                if (this.bufferFill < 1) {
                    this.ensureBufferFill(1);
                }
                byte by2 = this.buffer[this.bufferStart++];
                --this.bufferFill;
                blArray[i] = by2 != 0;
            }
            return blArray;
        }
        return null;
    }

    public byte[] loadArrayByte() throws IOException {
        this.ensureBufferFill(2);
        this.expect((byte)8, this.opNum++);
        byte by = this.buffer[this.bufferStart++];
        --this.bufferFill;
        if (by != 0) {
            byte[] byArray = new byte[this.readInt(true)];
            int n = byArray.length;
            int n2 = 0;
            while (n > 0) {
                int n3 = n;
                if (n3 > 4096) {
                    n3 = 4096;
                }
                this.ensureBufferFill(n3);
                System.arraycopy(this.buffer, this.bufferStart, byArray, n2, n3);
                this.bufferStart += n3;
                this.bufferFill -= n3;
                n -= n3;
                n2 += n3;
            }
            return byArray;
        }
        return null;
    }

    public short[] loadArrayShort() throws IOException {
        this.ensureBufferFill(2);
        this.expect((byte)9, this.opNum++);
        byte by = this.buffer[this.bufferStart++];
        --this.bufferFill;
        if (by != 0) {
            short[] sArray = new short[this.readInt(true)];
            int n = sArray.length;
            int n2 = 0;
            while (n > 0) {
                int n3 = n;
                if (n3 > 2048) {
                    n3 = 2048;
                }
                this.ensureBufferFill(2 * n3);
                for (int i = 0; i < n3; ++i) {
                    sArray[n2 + i] = this.readShort(false);
                }
                n -= n3;
                n2 += n3;
            }
            return sArray;
        }
        return null;
    }

    public int[] loadArrayInt() throws IOException {
        this.ensureBufferFill(2);
        this.expect((byte)10, this.opNum++);
        byte by = this.buffer[this.bufferStart++];
        --this.bufferFill;
        if (by != 0) {
            int[] nArray = new int[this.readInt(true)];
            int n = nArray.length;
            int n2 = 0;
            while (n > 0) {
                int n3 = n;
                if (n3 > 1024) {
                    n3 = 1024;
                }
                this.ensureBufferFill(4 * n3);
                for (int i = 0; i < n3; ++i) {
                    nArray[n2 + i] = this.readInt(false);
                }
                n -= n3;
                n2 += n3;
            }
            return nArray;
        }
        return null;
    }

    public long[] loadArrayLong() throws IOException {
        this.ensureBufferFill(2);
        this.expect((byte)11, this.opNum++);
        byte by = this.buffer[this.bufferStart++];
        --this.bufferFill;
        if (by != 0) {
            long[] lArray = new long[this.readInt(true)];
            int n = lArray.length;
            int n2 = 0;
            while (n > 0) {
                int n3 = n;
                if (n3 > 512) {
                    n3 = 512;
                }
                this.ensureBufferFill(8 * n3);
                for (int i = 0; i < n3; ++i) {
                    lArray[n2 + i] = this.readLong(false);
                }
                n -= n3;
                n2 += n3;
            }
            return lArray;
        }
        return null;
    }

    public double[] loadArrayDouble() throws IOException {
        this.ensureBufferFill(2);
        this.expect((byte)12, this.opNum++);
        byte by = this.buffer[this.bufferStart++];
        --this.bufferFill;
        if (by != 0) {
            double[] dArray = new double[this.readInt(true)];
            int n = dArray.length;
            int n2 = 0;
            while (n > 0) {
                int n3 = n;
                if (n3 > 512) {
                    n3 = 512;
                }
                this.ensureBufferFill(8 * n3);
                for (int i = 0; i < n3; ++i) {
                    dArray[n2 + i] = Double.longBitsToDouble(this.readLong(false));
                }
                n -= n3;
                n2 += n3;
            }
            return dArray;
        }
        return null;
    }

    public boolean objectEndsHere() throws IOException {
        this.ensureBufferFill(1);
        return this.buffer[this.bufferStart] == 15;
    }

    public static boolean checkConstructorManifest(InputStream inputStream) throws IOException {
        UTFInputLineStream uTFInputLineStream = new UTFInputLineStream(inputStream);
        String string = uTFInputLineStream.readLine();
        while (string != null) {
            try {
                Class<?> clazz = Class.forName(string);
                if (!SRDumpable.class.isAssignableFrom(clazz)) {
                    throw new IOException("Invalid class");
                }
            }
            catch (Exception exception) {
                System.err.println("Error: Constructor manifest refers to unknown/invalid class " + string + ".");
                return false;
            }
            string = uTFInputLineStream.readLine();
        }
        return true;
    }

    private SRDumpable builtinObjectLoader(int n, Class<?> clazz) throws IOException {
        SRDumpable sRDumpable;
        Constructor<?> constructor = null;
        ++this.intLoads;
        try {
            if (constructor == null) {
                constructor = clazz.getConstructor(this.getClass());
            }
        }
        catch (Exception exception) {
            throw new IOException("<init>(SRLoader) required for object loading: " + exception);
        }
        try {
            this.pendingObject = n;
            sRDumpable = (SRDumpable)constructor.newInstance(this);
            this.endObject();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException("Can't invoke <init>(SRLoader) of \"" + clazz.getName() + "\": " + illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw new IOException("Unknown exception while invoking loader: " + throwable);
        }
        catch (InstantiationException instantiationException) {
            throw new IOException("Instatiation of class \"" + clazz.getName() + "\" failed:" + instantiationException);
        }
        if (this.objects.length <= n || this.objects[n] != sRDumpable) {
            throw new IOException("Wrong object assigned to id #" + n + ".");
        }
        return sRDumpable;
    }

    private SRDumpable loadObjectContents(int n) throws IOException {
        Class<?> clazz;
        this.ensureBufferFill(1);
        this.expect((byte)14, this.opNum++);
        String string = this.loadString();
        try {
            clazz = Class.forName(string);
        }
        catch (Exception exception) {
            throw new IOException("Unknown class \"" + string + "\" encountered:" + exception);
        }
        return this.builtinObjectLoader(n, clazz);
    }

    public void objectCreated(SRDumpable sRDumpable) {
        int n = this.pendingObject;
        this.pendingObject = -1;
        if (this.objects.length > n) {
            this.objects[n] = sRDumpable;
        } else if (2 * this.objects.length > n) {
            SRDumpable[] sRDumpableArray = new SRDumpable[2 * this.objects.length];
            System.arraycopy(this.objects, 0, sRDumpableArray, 0, this.objects.length);
            this.objects = sRDumpableArray;
            this.objects[n] = sRDumpable;
        } else {
            SRDumpable[] sRDumpableArray = new SRDumpable[n + 1];
            System.arraycopy(this.objects, 0, sRDumpableArray, 0, this.objects.length);
            this.objects = sRDumpableArray;
            this.objects[n] = sRDumpable;
        }
    }

    public SRDumpable loadObject() throws IOException {
        this.ensureBufferFill(1);
        this.expect((byte)13, this.opNum++);
        int n = this.loadInt();
        if (n < 0) {
            return null;
        }
        if (this.objects.length > n && this.objects[n] != null) {
            this.ensureBufferFill(1);
            this.expect((byte)19, this.opNum++);
            return this.objects[n];
        }
        return this.loadObjectContents(n);
    }

    public void endObject() throws IOException {
        ++this.objectNum;
        this.ensureBufferFill(1);
        this.expect((byte)15, this.opNum++);
        long l = System.currentTimeMillis();
        if (l - this.lastMsgTimestamp > 1000L) {
            System.err.println("Informational: Loaded " + this.objectNum + " objects, stream sequence number " + this.opNum + ".");
            System.err.println("Informational: Internal loads: " + this.intLoads + " external loads: " + this.extLoads + ".");
            this.lastMsgTimestamp = l;
        }
    }

    public void specialObject(SRDumpable sRDumpable) throws IOException {
        this.ensureBufferFill(1);
        this.expect((byte)16, this.opNum++);
        int n = this.loadInt();
        if (this.objects.length > n) {
            this.objects[n] = sRDumpable;
        } else if (2 * this.objects.length > n) {
            SRDumpable[] sRDumpableArray = new SRDumpable[2 * this.objects.length];
            System.arraycopy(this.objects, 0, sRDumpableArray, 0, this.objects.length);
            this.objects = sRDumpableArray;
            this.objects[n] = sRDumpable;
        } else {
            SRDumpable[] sRDumpableArray = new SRDumpable[n + 1];
            System.arraycopy(this.objects, 0, sRDumpableArray, 0, this.objects.length);
            this.objects = sRDumpableArray;
            this.objects[n] = sRDumpable;
        }
    }
}

