/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator;

import java.io.PrintStream;
import java.util.HashMap;

public class StatusDumper {
    int extraIndent = -1;
    HashMap<String, Integer> nextObjectNumber = new HashMap();
    PrintStream underlyingPrintStream;
    static final Boolean TRUE = new Boolean(true);
    static final Boolean FALSE = new Boolean(false);
    HashMap<String, Boolean> seenObjects;
    HashMap<Integer, ObjectListEntry> chainingLists;
    int objectsCount;

    public StatusDumper(PrintStream printStream) {
        this.underlyingPrintStream = printStream;
        this.seenObjects = new HashMap();
        this.chainingLists = new HashMap();
        this.objectsCount = 0;
    }

    public int dumpedObjects() {
        return this.objectsCount;
    }

    public void println(String string) {
        String string2 = "";
        for (int i = 0; i < this.extraIndent; ++i) {
            string2 = string2 + "\t";
        }
        string2 = string2 + string;
        this.underlyingPrintStream.println(string2);
    }

    public void printArray(boolean[] blArray, String string) {
        if (blArray == null) {
            this.println("\t" + string + " null");
            return;
        }
        this.println("\t" + string + ":");
        String string2 = "\t\t";
        for (int i = 0; i < blArray.length; ++i) {
            if (i % 16 == 15) {
                string2 = string2 + blArray[i] + "";
                this.println(string2);
                string2 = "\t\t";
                continue;
            }
            string2 = string2 + blArray[i] + " ";
        }
    }

    public void printArray(byte[] byArray, String string) {
        if (byArray == null) {
            this.println("\t" + string + " null");
            return;
        }
        this.println("\t" + string + ":");
        String string2 = "\t\t";
        for (int i = 0; i < byArray.length; ++i) {
            if (i % 16 == 15) {
                string2 = string2 + byArray[i] + "";
                this.println(string2);
                string2 = "\t\t";
                continue;
            }
            string2 = string2 + byArray[i] + " ";
        }
    }

    public void printArray(int[] nArray, String string) {
        if (nArray == null) {
            this.println("\t" + string + " null");
            return;
        }
        this.println("\t" + string + ":");
        String string2 = "\t\t";
        for (int i = 0; i < nArray.length; ++i) {
            if (i % 16 == 15) {
                string2 = string2 + nArray[i] + "";
                this.println(string2);
                string2 = "\t\t";
                continue;
            }
            string2 = string2 + nArray[i] + " ";
        }
    }

    public void printArray(long[] lArray, String string) {
        if (lArray == null) {
            this.println("\t" + string + " null");
            return;
        }
        this.println("\t" + string + ":");
        String string2 = "\t\t";
        for (int i = 0; i < lArray.length; ++i) {
            if (i % 16 == 15) {
                string2 = string2 + lArray[i] + "";
                this.println(string2);
                string2 = "\t\t";
                continue;
            }
            string2 = string2 + lArray[i] + " ";
        }
    }

    private void addObject(Object object, String string) {
        Integer n = new Integer(object.hashCode());
        ObjectListEntry objectListEntry = new ObjectListEntry();
        objectListEntry.object = object;
        objectListEntry.num = string;
        objectListEntry.next = null;
        if (!this.chainingLists.containsKey(n)) {
            this.chainingLists.put(n, objectListEntry);
        } else {
            objectListEntry.next = this.chainingLists.get(n);
            this.chainingLists.put(n, objectListEntry);
        }
    }

    private String lookupObject(Object object) {
        Integer n = new Integer(object.hashCode());
        if (!this.chainingLists.containsKey(n)) {
            return null;
        }
        ObjectListEntry objectListEntry = this.chainingLists.get(n);
        while (objectListEntry != null) {
            if (objectListEntry.object == object) {
                return objectListEntry.num;
            }
            objectListEntry = objectListEntry.next;
        }
        return null;
    }

    public String objectNumber(Object object) {
        boolean bl = false;
        if (object == null) {
            return "NULL";
        }
        String string = this.lookupObject(object);
        if (string == null) {
            bl = true;
        }
        if (bl) {
            String string2 = object.getClass().getName();
            if (!this.nextObjectNumber.containsKey(string2)) {
                this.nextObjectNumber.put(string2, new Integer(1));
                string = string2 + "-1";
            } else {
                int n = this.nextObjectNumber.get(string2);
                this.nextObjectNumber.put(string2, new Integer(n + 1));
                string = string2 + "-" + (n + 1);
            }
            this.addObject(object, string);
            this.seenObjects.put(string, FALSE);
        }
        return string;
    }

    public boolean dumped(Object object) {
        boolean bl = false;
        String string = this.objectNumber(object);
        bl = this.seenObjects.get(string);
        if (!bl) {
            ++this.extraIndent;
            this.seenObjects.put(string, TRUE);
            ++this.objectsCount;
            return false;
        }
        return true;
    }

    public void endObject() {
        this.println("--- END OF OBJECT ---");
        --this.extraIndent;
    }

    static class ObjectListEntry {
        public Object object;
        public String num;
        public ObjectListEntry next;

        ObjectListEntry() {
        }
    }
}

