/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.memory;

import java.io.IOException;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.SRLoader;
import org.jpc.emulator.StatusDumper;
import org.jpc.emulator.memory.LazyCodeBlockMemory;
import org.jpc.emulator.memory.codeblock.CodeBlockManager;

public class EPROMMemory
extends LazyCodeBlockMemory {
    public EPROMMemory(byte[] byArray, int n, int n2, CodeBlockManager codeBlockManager) {
        this(n2, 0, byArray, n, n2, codeBlockManager);
    }

    @Override
    public void dumpStatusPartial(StatusDumper statusDumper) {
        super.dumpStatusPartial(statusDumper);
    }

    @Override
    public void dumpStatus(StatusDumper statusDumper) {
        if (statusDumper.dumped(this)) {
            return;
        }
        statusDumper.println("#" + statusDumper.objectNumber(this) + ": EPROMMemory:");
        this.dumpStatusPartial(statusDumper);
        statusDumper.endObject();
    }

    @Override
    public void dumpSRPartial(SRDumper sRDumper) throws IOException {
        super.dumpSRPartial(sRDumper);
    }

    public EPROMMemory(SRLoader sRLoader) throws IOException {
        super(sRLoader);
    }

    public EPROMMemory(int n, int n2, byte[] byArray, int n3, int n4, CodeBlockManager codeBlockManager) {
        super(n, codeBlockManager);
        super.copyArrayIntoContents(n2, byArray, n3, Math.min(n - n2, Math.min(n4, byArray.length - n3)));
    }

    @Override
    public void setByte(int n, byte by) {
    }

    @Override
    public void setWord(int n, short s) {
    }

    @Override
    public void setDoubleWord(int n, int n2) {
        this.writeAttempted(n, 4);
    }

    @Override
    public void copyArrayIntoContents(int n, byte[] byArray, int n2, int n3) {
        this.writeAttempted(n, n3);
    }

    @Override
    public void clear() {
        this.constructCodeBlocksArray();
    }

    @Override
    public String toString() {
        return "EPROM Memory [" + this.getSize() + "]";
    }

    private void writeAttempted(int n, int n2) {
        if (n2 == 1) {
            System.err.println("Warning: Write of 1 byte attempted at address " + Integer.toHexString(n) + ".");
        } else {
            System.err.println("Warning: Write of " + n2 + " bytes attempted at address " + Integer.toHexString(n) + ".");
        }
    }
}

