/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.memory;

import java.io.IOException;
import java.util.Arrays;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.SRLoader;
import org.jpc.emulator.StatusDumper;
import org.jpc.emulator.memory.AbstractMemory;
import org.jpc.emulator.memory.codeblock.CodeBlock;
import org.jpc.emulator.memory.codeblock.CodeBlockManager;
import org.jpc.emulator.memory.codeblock.CodeBlockReplacementException;
import org.jpc.emulator.memory.codeblock.ProtectedModeCodeBlock;
import org.jpc.emulator.memory.codeblock.RealModeCodeBlock;
import org.jpc.emulator.memory.codeblock.Virtual8086ModeCodeBlock;
import org.jpc.emulator.processor.Processor;

public class LazyCodeBlockMemory
extends AbstractMemory {
    private CodeBlockManager codeBlockManager;
    private static final BlankCodeBlock PLACEHOLDER = new BlankCodeBlock();
    private RealModeCodeBlock[] realCodeBuffer;
    private ProtectedModeCodeBlock[] protectedCodeBuffer;
    private Virtual8086ModeCodeBlock[] virtual8086CodeBuffer;
    private static final int ALLOCATION_THRESHOLD = 10;
    private final int size;
    private byte[] buffer = null;
    private int nullReadCount = 0;
    private boolean fpuHackFlag;

    public void setFPUHack() {
        this.fpuHackFlag = true;
    }

    public boolean isDirty() {
        return this.buffer != null;
    }

    @Override
    public void dumpStatusPartial(StatusDumper statusDumper) {
        super.dumpStatusPartial(statusDumper);
        statusDumper.println("\tsize " + this.size + " nullReadCount " + this.nullReadCount);
        statusDumper.println("\tbuffer:");
        statusDumper.printArray(this.buffer, "buffer");
    }

    @Override
    public void dumpStatus(StatusDumper statusDumper) {
        if (statusDumper.dumped(this)) {
            return;
        }
        statusDumper.println("#" + statusDumper.objectNumber(this) + ": LazyCodeBlockMemory:");
        this.dumpStatusPartial(statusDumper);
        statusDumper.endObject();
    }

    @Override
    public void dumpSRPartial(SRDumper sRDumper) throws IOException {
        super.dumpSRPartial(sRDumper);
        sRDumper.dumpInt(this.size);
        sRDumper.dumpArray(this.buffer);
        sRDumper.dumpInt(this.nullReadCount);
        sRDumper.dumpObject(this.codeBlockManager);
        sRDumper.dumpBoolean(this.fpuHackFlag);
    }

    public LazyCodeBlockMemory(SRLoader sRLoader) throws IOException {
        super(sRLoader);
        this.size = sRLoader.loadInt();
        this.buffer = sRLoader.loadArrayByte();
        this.nullReadCount = sRLoader.loadInt();
        this.codeBlockManager = (CodeBlockManager)sRLoader.loadObject();
        this.fpuHackFlag = false;
        if (sRLoader.objectEndsHere()) {
            return;
        }
        this.fpuHackFlag = sRLoader.loadBoolean();
    }

    public LazyCodeBlockMemory(int n, CodeBlockManager codeBlockManager) {
        this.size = n;
        this.codeBlockManager = codeBlockManager;
    }

    protected void constructCodeBlocksArray() {
        this.realCodeBuffer = new RealModeCodeBlock[(int)this.getSize()];
        this.protectedCodeBuffer = new ProtectedModeCodeBlock[(int)this.getSize()];
        this.virtual8086CodeBuffer = new Virtual8086ModeCodeBlock[(int)this.getSize()];
    }

    private void constructRealCodeBlocksArray() {
        this.realCodeBuffer = new RealModeCodeBlock[(int)this.getSize()];
    }

    private void constructVirtual8086CodeBlocksArray() {
        this.virtual8086CodeBuffer = new Virtual8086ModeCodeBlock[(int)this.getSize()];
    }

    private void constructProtectedCodeBlocksArray() {
        this.protectedCodeBuffer = new ProtectedModeCodeBlock[(int)this.getSize()];
    }

    @Override
    public int executeProtected(Processor processor, int n) {
        int n2 = 0;
        int n3 = processor.getInstructionPointer();
        n = n3 & 0xFFF;
        ProtectedModeCodeBlock protectedModeCodeBlock = this.getProtectedModeCodeBlockAt(n);
        try {
            try {
                n2 += protectedModeCodeBlock.execute(processor);
            }
            catch (NullPointerException nullPointerException) {
                protectedModeCodeBlock = this.codeBlockManager.getProtectedModeCodeBlockAt(this, n, processor.cs.getDefaultSizeFlag());
                this.setProtectedCodeBlockAt(n, protectedModeCodeBlock);
                n2 += protectedModeCodeBlock.execute(processor);
            }
        }
        catch (CodeBlockReplacementException codeBlockReplacementException) {
            this.protectedCodeBuffer[n] = protectedModeCodeBlock = (ProtectedModeCodeBlock)codeBlockReplacementException.getReplacement();
            n2 += protectedModeCodeBlock.execute(processor);
        }
        return n2;
    }

    @Override
    public int executeReal(Processor processor, int n) {
        int n2 = 0;
        int n3 = processor.getInstructionPointer();
        n = n3 & 0xFFF;
        RealModeCodeBlock realModeCodeBlock = this.getRealModeCodeBlockAt(n);
        try {
            try {
                n2 += realModeCodeBlock.execute(processor);
            }
            catch (NullPointerException nullPointerException) {
                realModeCodeBlock = this.codeBlockManager.getRealModeCodeBlockAt(this, n);
                this.setRealCodeBlockAt(n, realModeCodeBlock);
                n2 += realModeCodeBlock.execute(processor);
            }
        }
        catch (CodeBlockReplacementException codeBlockReplacementException) {
            this.realCodeBuffer[n] = realModeCodeBlock = (RealModeCodeBlock)codeBlockReplacementException.getReplacement();
            n2 += realModeCodeBlock.execute(processor);
        }
        return n2;
    }

    @Override
    public int executeVirtual8086(Processor processor, int n) {
        int n2 = 0;
        int n3 = processor.getInstructionPointer();
        n = n3 & 0xFFF;
        Virtual8086ModeCodeBlock virtual8086ModeCodeBlock = this.getVirtual8086ModeCodeBlockAt(n);
        try {
            try {
                n2 += virtual8086ModeCodeBlock.execute(processor);
            }
            catch (NullPointerException nullPointerException) {
                virtual8086ModeCodeBlock = this.codeBlockManager.getVirtual8086ModeCodeBlockAt(this, n);
                this.setVirtual8086CodeBlockAt(n, virtual8086ModeCodeBlock);
                n2 += virtual8086ModeCodeBlock.execute(processor);
            }
        }
        catch (CodeBlockReplacementException codeBlockReplacementException) {
            this.virtual8086CodeBuffer[n] = virtual8086ModeCodeBlock = (Virtual8086ModeCodeBlock)codeBlockReplacementException.getReplacement();
            n2 += virtual8086ModeCodeBlock.execute(processor);
        }
        return n2;
    }

    private RealModeCodeBlock getRealModeCodeBlockAt(int n) {
        try {
            return this.realCodeBuffer[n];
        }
        catch (NullPointerException nullPointerException) {
            this.constructRealCodeBlocksArray();
            return this.realCodeBuffer[n];
        }
    }

    private ProtectedModeCodeBlock getProtectedModeCodeBlockAt(int n) {
        try {
            return this.protectedCodeBuffer[n];
        }
        catch (NullPointerException nullPointerException) {
            this.constructProtectedCodeBlocksArray();
            return this.protectedCodeBuffer[n];
        }
    }

    private Virtual8086ModeCodeBlock getVirtual8086ModeCodeBlockAt(int n) {
        try {
            return this.virtual8086CodeBuffer[n];
        }
        catch (NullPointerException nullPointerException) {
            this.constructVirtual8086CodeBlocksArray();
            return this.virtual8086CodeBuffer[n];
        }
    }

    private void removeVirtual8086CodeBlockAt(int n) {
        int n2;
        Virtual8086ModeCodeBlock virtual8086ModeCodeBlock = this.virtual8086CodeBuffer[n];
        if (virtual8086ModeCodeBlock == null || virtual8086ModeCodeBlock == PLACEHOLDER) {
            return;
        }
        this.virtual8086CodeBuffer[n] = null;
        int n3 = virtual8086ModeCodeBlock.getX86Length();
        for (n2 = n + 1; n2 < n + n3 && n2 < this.virtual8086CodeBuffer.length; ++n2) {
            if (this.virtual8086CodeBuffer[n2] != PLACEHOLDER) continue;
            this.virtual8086CodeBuffer[n2] = null;
        }
        for (n2 = Math.min(n + n3, this.virtual8086CodeBuffer.length) - 1; n2 >= 0; --n2) {
            if (this.virtual8086CodeBuffer[n2] == null) {
                if (n2 >= n) continue;
                break;
            }
            if (this.virtual8086CodeBuffer[n2] == PLACEHOLDER) continue;
            Virtual8086ModeCodeBlock virtual8086ModeCodeBlock2 = this.virtual8086CodeBuffer[n2];
            n3 = virtual8086ModeCodeBlock2.getX86Length();
            for (int i = n2 + 1; i < n2 + n3 && i < this.virtual8086CodeBuffer.length; ++i) {
                if (this.virtual8086CodeBuffer[i] != null) continue;
                this.virtual8086CodeBuffer[i] = PLACEHOLDER;
            }
        }
    }

    private void removeProtectedCodeBlockAt(int n) {
        int n2;
        ProtectedModeCodeBlock protectedModeCodeBlock = this.protectedCodeBuffer[n];
        if (protectedModeCodeBlock == null || protectedModeCodeBlock == PLACEHOLDER) {
            return;
        }
        this.protectedCodeBuffer[n] = null;
        int n3 = protectedModeCodeBlock.getX86Length();
        for (n2 = n + 1; n2 < n + n3 && n2 < this.protectedCodeBuffer.length; ++n2) {
            if (this.protectedCodeBuffer[n2] != PLACEHOLDER) continue;
            this.protectedCodeBuffer[n2] = null;
        }
        for (n2 = Math.min(n + n3, this.protectedCodeBuffer.length) - 1; n2 >= 0; --n2) {
            if (this.protectedCodeBuffer[n2] == null) {
                if (n2 >= n) continue;
                break;
            }
            if (this.protectedCodeBuffer[n2] == PLACEHOLDER) continue;
            ProtectedModeCodeBlock protectedModeCodeBlock2 = this.protectedCodeBuffer[n2];
            n3 = protectedModeCodeBlock2.getX86Length();
            for (int i = n2 + 1; i < n2 + n3 && i < this.protectedCodeBuffer.length; ++i) {
                if (this.protectedCodeBuffer[i] != null) continue;
                this.protectedCodeBuffer[i] = PLACEHOLDER;
            }
        }
    }

    private void removeRealCodeBlockAt(int n) {
        int n2;
        RealModeCodeBlock realModeCodeBlock = this.realCodeBuffer[n];
        if (realModeCodeBlock == null || realModeCodeBlock == PLACEHOLDER) {
            return;
        }
        this.realCodeBuffer[n] = null;
        int n3 = realModeCodeBlock.getX86Length();
        for (n2 = n + 1; n2 < n + n3 && n2 < this.realCodeBuffer.length; ++n2) {
            if (this.realCodeBuffer[n2] != PLACEHOLDER) continue;
            this.realCodeBuffer[n2] = null;
        }
        for (n2 = Math.min(n + n3, this.realCodeBuffer.length) - 1; n2 >= 0; --n2) {
            if (this.realCodeBuffer[n2] == null) {
                if (n2 >= n) continue;
                break;
            }
            if (this.realCodeBuffer[n2] == PLACEHOLDER) continue;
            RealModeCodeBlock realModeCodeBlock2 = this.realCodeBuffer[n2];
            n3 = realModeCodeBlock2.getX86Length();
            for (int i = n2 + 1; i < n2 + n3 && i < this.realCodeBuffer.length; ++i) {
                if (this.realCodeBuffer[i] != null) continue;
                this.realCodeBuffer[i] = PLACEHOLDER;
            }
        }
    }

    private void setVirtual8086CodeBlockAt(int n, Virtual8086ModeCodeBlock virtual8086ModeCodeBlock) {
        this.removeVirtual8086CodeBlockAt(n);
        if (virtual8086ModeCodeBlock == null) {
            return;
        }
        this.virtual8086CodeBuffer[n] = virtual8086ModeCodeBlock;
        int n2 = virtual8086ModeCodeBlock.getX86Length();
        for (int i = n + 1; i < n + n2 && i < this.virtual8086CodeBuffer.length; ++i) {
            if (this.virtual8086CodeBuffer[i] != null) continue;
            this.virtual8086CodeBuffer[i] = PLACEHOLDER;
        }
    }

    private void setProtectedCodeBlockAt(int n, ProtectedModeCodeBlock protectedModeCodeBlock) {
        this.removeProtectedCodeBlockAt(n);
        if (protectedModeCodeBlock == null) {
            return;
        }
        this.protectedCodeBuffer[n] = protectedModeCodeBlock;
        int n2 = protectedModeCodeBlock.getX86Length();
        for (int i = n + 1; i < n + n2 && i < this.protectedCodeBuffer.length; ++i) {
            if (this.protectedCodeBuffer[i] != null) continue;
            this.protectedCodeBuffer[i] = PLACEHOLDER;
        }
    }

    private void setRealCodeBlockAt(int n, RealModeCodeBlock realModeCodeBlock) {
        this.removeRealCodeBlockAt(n);
        if (realModeCodeBlock == null) {
            return;
        }
        this.realCodeBuffer[n] = realModeCodeBlock;
        int n2 = realModeCodeBlock.getX86Length();
        for (int i = n + 1; i < n + n2 && i < this.realCodeBuffer.length; ++i) {
            if (this.realCodeBuffer[i] != null) continue;
            this.realCodeBuffer[i] = PLACEHOLDER;
        }
    }

    private void regionAltered(int n, int n2) {
        CodeBlock codeBlock;
        int n3;
        if (this.realCodeBuffer != null) {
            for (n3 = n2; n3 >= 0; --n3) {
                codeBlock = this.realCodeBuffer[n3];
                if (codeBlock == null) {
                    if (n3 >= n) continue;
                    break;
                }
                if (codeBlock == PLACEHOLDER || codeBlock.handleMemoryRegionChange(n, n2)) continue;
                this.removeRealCodeBlockAt(n3);
                codeBlock.invalidate();
            }
        }
        if (this.protectedCodeBuffer != null) {
            for (n3 = n2; n3 >= 0; --n3) {
                codeBlock = this.protectedCodeBuffer[n3];
                if (codeBlock == null) {
                    if (n3 >= n) continue;
                    break;
                }
                if (codeBlock == PLACEHOLDER || codeBlock.handleMemoryRegionChange(n, n2)) continue;
                this.removeProtectedCodeBlockAt(n3);
                codeBlock.invalidate();
            }
        }
        if (this.virtual8086CodeBuffer != null) {
            for (n3 = n2; n3 >= 0; --n3) {
                codeBlock = this.virtual8086CodeBuffer[n3];
                if (codeBlock == null) {
                    if (n3 >= n) continue;
                    break;
                }
                if (codeBlock == PLACEHOLDER || codeBlock.handleMemoryRegionChange(n, n2)) continue;
                this.removeVirtual8086CodeBlockAt(n3);
                codeBlock.invalidate();
            }
        }
    }

    @Override
    public void clear() {
        this.realCodeBuffer = null;
        this.protectedCodeBuffer = null;
        this.virtual8086CodeBuffer = null;
        this.buffer = null;
    }

    public String toString() {
        return "LazyCodeBlockMemory[" + this.getSize() + "]";
    }

    public ProtectedModeCodeBlock getProtectedBlock(int n, boolean bl) {
        ProtectedModeCodeBlock protectedModeCodeBlock;
        if (this.protectedCodeBuffer == null) {
            this.allocateBuffer();
            this.protectedCodeBuffer = new ProtectedModeCodeBlock[(int)this.getSize()];
        }
        if ((protectedModeCodeBlock = this.protectedCodeBuffer[n]) != null && protectedModeCodeBlock != PLACEHOLDER) {
            return protectedModeCodeBlock;
        }
        protectedModeCodeBlock = this.codeBlockManager.getProtectedModeCodeBlockAt(this, n, bl);
        this.setProtectedCodeBlockAt(n, protectedModeCodeBlock);
        return protectedModeCodeBlock;
    }

    public Virtual8086ModeCodeBlock getVirtual8086Block(int n) {
        Virtual8086ModeCodeBlock virtual8086ModeCodeBlock;
        if (this.virtual8086CodeBuffer == null) {
            this.allocateBuffer();
            this.virtual8086CodeBuffer = new Virtual8086ModeCodeBlock[(int)this.getSize()];
        }
        if ((virtual8086ModeCodeBlock = this.virtual8086CodeBuffer[n]) != null && virtual8086ModeCodeBlock != PLACEHOLDER) {
            return virtual8086ModeCodeBlock;
        }
        virtual8086ModeCodeBlock = this.codeBlockManager.getVirtual8086ModeCodeBlockAt(this, n);
        this.setVirtual8086CodeBlockAt(n, virtual8086ModeCodeBlock);
        return virtual8086ModeCodeBlock;
    }

    public RealModeCodeBlock getRealBlock(int n) {
        RealModeCodeBlock realModeCodeBlock;
        if (this.realCodeBuffer == null) {
            this.allocateBuffer();
            this.realCodeBuffer = new RealModeCodeBlock[(int)this.getSize()];
        }
        if ((realModeCodeBlock = this.realCodeBuffer[n]) != null && realModeCodeBlock != PLACEHOLDER) {
            return realModeCodeBlock;
        }
        realModeCodeBlock = this.codeBlockManager.getRealModeCodeBlockAt(this, n);
        this.setRealCodeBlockAt(n, realModeCodeBlock);
        return realModeCodeBlock;
    }

    private final void allocateBuffer() {
        if (this.buffer == null) {
            this.buffer = new byte[this.size];
        }
    }

    @Override
    public void copyContentsIntoArray(int n, byte[] byArray, int n2, int n3) {
        try {
            System.arraycopy(this.buffer, n, byArray, n2, n3);
        }
        catch (NullPointerException nullPointerException) {
            if (++this.nullReadCount == 10) {
                this.allocateBuffer();
                System.arraycopy(this.buffer, n, byArray, n2, n3);
            }
            Arrays.fill(byArray, n2, n2 + n3, (byte)0);
        }
    }

    @Override
    public void loadInitialContents(int n, byte[] byArray, int n2, int n3) {
        try {
            System.arraycopy(byArray, n2, this.buffer, n, n3);
        }
        catch (NullPointerException nullPointerException) {
            this.allocateBuffer();
            System.arraycopy(byArray, n2, this.buffer, n, n3);
        }
    }

    @Override
    public void copyArrayIntoContents(int n, byte[] byArray, int n2, int n3) {
        try {
            System.arraycopy(byArray, n2, this.buffer, n, n3);
        }
        catch (NullPointerException nullPointerException) {
            this.allocateBuffer();
            System.arraycopy(byArray, n2, this.buffer, n, n3);
        }
        this.regionAltered(n, n + n3 - 1);
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public boolean isAllocated() {
        return this.buffer != null;
    }

    @Override
    public byte getByte(int n) {
        try {
            if (this.fpuHackFlag && n == 1040) {
                return (byte)(this.buffer[n] & 0xFD);
            }
            return this.buffer[n];
        }
        catch (NullPointerException nullPointerException) {
            if (++this.nullReadCount == 10) {
                this.allocateBuffer();
                return this.buffer[n];
            }
            return 0;
        }
    }

    @Override
    public void setByte(int n, byte by) {
        if (this.getByte(n) == by) {
            return;
        }
        try {
            this.buffer[n] = by;
        }
        catch (NullPointerException nullPointerException) {
            this.allocateBuffer();
            this.buffer[n] = by;
        }
        this.regionAltered(n, n);
    }

    @Override
    public short getWord(int n) {
        try {
            int n2 = 0xFF & this.buffer[n];
            n2 |= this.buffer[++n] << 8;
            if (this.fpuHackFlag && n == 1041) {
                n2 &= 0xFFFD;
            }
            if (this.fpuHackFlag && n == 1040) {
                n2 &= 0xFDFF;
            }
            return (short)n2;
        }
        catch (NullPointerException nullPointerException) {
            if (++this.nullReadCount == 10) {
                this.allocateBuffer();
                int n3 = 0xFF & this.buffer[n];
                return (short)(n3 |= this.buffer[++n] << 8);
            }
            return 0;
        }
    }

    @Override
    public int getDoubleWord(int n) {
        try {
            int n2 = 0xFF & this.buffer[n];
            n2 |= (0xFF & this.buffer[++n]) << 8;
            n2 |= (0xFF & this.buffer[++n]) << 16;
            n2 |= this.buffer[++n] << 24;
            if (this.fpuHackFlag && n == 1043) {
                n2 &= 0xFFFFFFFD;
            }
            if (this.fpuHackFlag && n == 1042) {
                n2 &= 0xFFFFFDFF;
            }
            if (this.fpuHackFlag && n == 1041) {
                n2 &= 0xFFFDFFFF;
            }
            if (this.fpuHackFlag && n == 1040) {
                n2 &= 0xFDFFFFFF;
            }
            return n2;
        }
        catch (NullPointerException nullPointerException) {
            if (++this.nullReadCount == 10) {
                this.allocateBuffer();
                int n3 = 0xFF & this.buffer[n];
                n3 |= (0xFF & this.buffer[++n]) << 8;
                n3 |= (0xFF & this.buffer[++n]) << 16;
                return n3 |= this.buffer[++n] << 24;
            }
            return 0;
        }
    }

    @Override
    public void setWord(int n, short s) {
        if (this.getWord(n) == s) {
            return;
        }
        try {
            this.buffer[n] = (byte)s;
            this.buffer[++n] = (byte)(s >> 8);
        }
        catch (NullPointerException nullPointerException) {
            this.allocateBuffer();
            this.buffer[n] = (byte)s;
            this.buffer[++n] = (byte)(s >> 8);
        }
        this.regionAltered(n, n + 1);
    }

    @Override
    public void setDoubleWord(int n, int n2) {
        if (this.getDoubleWord(n) == n2) {
            return;
        }
        try {
            this.buffer[n] = (byte)n2;
            this.buffer[++n] = (byte)(n2 >>= 8);
            this.buffer[++n] = (byte)(n2 >>= 8);
            this.buffer[++n] = (byte)(n2 >>= 8);
        }
        catch (NullPointerException nullPointerException) {
            this.allocateBuffer();
            this.buffer[n] = (byte)n2;
            this.buffer[++n] = (byte)(n2 >>= 8);
            this.buffer[++n] = (byte)(n2 >>= 8);
            this.buffer[++n] = (byte)(n2 >>= 8);
        }
        this.regionAltered(n, n + 3);
    }

    private static class BlankCodeBlock
    implements RealModeCodeBlock,
    ProtectedModeCodeBlock,
    Virtual8086ModeCodeBlock {
        private static final RuntimeException executeException = new NullPointerException();

        private BlankCodeBlock() {
        }

        @Override
        public int getX86Length() {
            return 0;
        }

        @Override
        public int getX86Count() {
            return 0;
        }

        @Override
        public int execute(Processor processor) {
            throw executeException;
        }

        @Override
        public void invalidate() {
        }

        @Override
        public boolean handleMemoryRegionChange(int n, int n2) {
            return false;
        }

        @Override
        public String getDisplayString() {
            return "\n\n<<Blank Block>>\n\n";
        }

        public String toString() {
            return " -- Blank --\n";
        }
    }
}

