/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.memory;

import java.io.IOException;
import java.util.Arrays;
import org.jpc.emulator.HardwareComponent;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.SRLoader;
import org.jpc.emulator.StatusDumper;
import org.jpc.emulator.memory.AddressSpace;
import org.jpc.emulator.memory.LazyCodeBlockMemory;
import org.jpc.emulator.memory.LinearAddressSpace;
import org.jpc.emulator.memory.Memory;
import org.jpc.emulator.memory.codeblock.CodeBlockManager;
import org.jpc.emulator.processor.Processor;

public final class PhysicalAddressSpace
extends AddressSpace
implements HardwareComponent {
    private static final int GATEA20_MASK = -1048577;
    private static final int GATEA20_PAGEMASK = 1048319;
    private static final int GATEA20_PAGEOFFSET = 256;
    private int sysRAMSize;
    private int quickIndexSize;
    private static final int TOP_INDEX_BITS = 10;
    private static final int BOTTOM_INDEX_BITS = 10;
    private static final int TOP_INDEX_SHIFT = 22;
    private static final int TOP_INDEX_SIZE = 1024;
    private static final int BOTTOM_INDEX_SHIFT = 12;
    private static final int BOTTOM_INDEX_SIZE = 1024;
    private static final int BOTTOM_INDEX_MASK = 1023;
    private static final Memory UNCONNECTED = new UnconnectedMemoryBlock();
    private boolean gateA20MaskState;
    private Memory[] quickNonA20MaskedIndex;
    private Memory[] quickA20MaskedIndex;
    private Memory[] quickIndex;
    private Memory[][] nonA20MaskedIndex;
    private Memory[][] a20MaskedIndex;
    private Memory[][] index;
    private LinearAddressSpace linearAddr;
    private CodeBlockManager manager = null;

    public void setFPUHack() {
        Memory memory = this.quickNonA20MaskedIndex[0];
        if (memory instanceof LazyCodeBlockMemory) {
            ((LazyCodeBlockMemory)memory).setFPUHack();
        }
    }

    public PhysicalAddressSpace(CodeBlockManager codeBlockManager, int n) {
        this.manager = codeBlockManager;
        this.sysRAMSize = n;
        this.quickIndexSize = n >>> 12;
        this.quickNonA20MaskedIndex = new Memory[this.quickIndexSize];
        PhysicalAddressSpace.clearArray(this.quickNonA20MaskedIndex, UNCONNECTED);
        this.quickA20MaskedIndex = new Memory[this.quickIndexSize];
        PhysicalAddressSpace.clearArray(this.quickA20MaskedIndex, UNCONNECTED);
        this.nonA20MaskedIndex = new Memory[1024][];
        this.a20MaskedIndex = new Memory[1024][];
        this.initialiseMemory();
        this.setGateA20State(false);
    }

    @Override
    public void dumpStatusPartial(StatusDumper statusDumper) {
        super.dumpStatusPartial(statusDumper);
        statusDumper.println("\tsysRAMSize " + this.sysRAMSize + " quickIndexSize " + this.quickIndexSize);
        statusDumper.println("\tgateA20MaskState " + this.gateA20MaskState);
        this.dumpMemoryTableStatus(statusDumper, this.quickNonA20MaskedIndex, "quickNonA20MaskedIndex");
        this.dumpMemoryTableStatus(statusDumper, this.quickA20MaskedIndex, "quickA20MaskedIndex");
        this.dumpMemoryTableStatus(statusDumper, this.quickIndex, "quickIndex");
        this.dumpMemoryDTableStatus(statusDumper, this.nonA20MaskedIndex, "nonA20MaskedIndex");
        this.dumpMemoryDTableStatus(statusDumper, this.a20MaskedIndex, "a20MaskedIndex");
        this.dumpMemoryDTableStatus(statusDumper, this.index, "index");
        statusDumper.println("\tUNCONNECTED <object #" + statusDumper.objectNumber(UNCONNECTED) + ">");
        if (UNCONNECTED != null) {
            UNCONNECTED.dumpStatus(statusDumper);
        }
        statusDumper.println("\tlinearAddr <object #" + statusDumper.objectNumber(this.linearAddr) + ">");
        if (this.linearAddr != null) {
            this.linearAddr.dumpStatus(statusDumper);
        }
    }

    @Override
    public void dumpStatus(StatusDumper statusDumper) {
        if (statusDumper.dumped(this)) {
            return;
        }
        statusDumper.println("#" + statusDumper.objectNumber(this) + ": PhysicalAddressSpace:");
        this.dumpStatusPartial(statusDumper);
        statusDumper.endObject();
    }

    public int findFirstRAMPage(int n) {
        try {
            while (true) {
                if (this.quickNonA20MaskedIndex[n].getClass() == LazyCodeBlockMemory.class) {
                    return n;
                }
                ++n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return -1;
        }
    }

    public void readRAMPage(int n, byte[] byArray) {
        this.readRAMPage(n, byArray, 0);
    }

    public void readRAMPage(int n, byte[] byArray, int n2) {
        if (n >= this.quickNonA20MaskedIndex.length) {
            Arrays.fill(byArray, n2, n2 + 4096, (byte)0);
            return;
        }
        if (this.quickNonA20MaskedIndex[n].getClass() != LazyCodeBlockMemory.class) {
            Arrays.fill(byArray, n2, n2 + 4096, (byte)0);
            return;
        }
        LazyCodeBlockMemory lazyCodeBlockMemory = (LazyCodeBlockMemory)this.quickNonA20MaskedIndex[n];
        if (!lazyCodeBlockMemory.isDirty()) {
            Arrays.fill(byArray, n2, n2 + 4096, (byte)0);
            return;
        }
        lazyCodeBlockMemory.copyContentsIntoArray(0, byArray, n2, 4096);
    }

    private void reconstructA20MaskedTables() {
        int n;
        this.a20MaskedIndex = new Memory[1024][];
        this.quickA20MaskedIndex = new Memory[this.quickIndexSize];
        PhysicalAddressSpace.clearArray(this.quickA20MaskedIndex, UNCONNECTED);
        for (n = 0; n < this.quickIndexSize; ++n) {
            this.quickA20MaskedIndex[n] = this.quickNonA20MaskedIndex[n & 0xFFEFF];
        }
        for (n = 0; n < 1024; ++n) {
            if (this.nonA20MaskedIndex[n] == null) continue;
            for (int i = 0; i < 1024; ++i) {
                Memory[] memoryArray;
                if (this.nonA20MaskedIndex[n][i] == null) continue;
                int n2 = n * 1024 + i;
                int n3 = n * 1024 + i + 256;
                if ((n2 & 0xFFEFF) != n2) continue;
                Memory[] memoryArray2 = this.a20MaskedIndex[n2 >>> 10];
                if (memoryArray2 == null) {
                    Memory[] memoryArray3 = new Memory[1024];
                    this.a20MaskedIndex[n2 >>> 10] = memoryArray3;
                    memoryArray2 = memoryArray3;
                }
                if ((memoryArray = this.a20MaskedIndex[n3 >>> 10]) == null) {
                    Memory[] memoryArray4 = new Memory[1024];
                    this.a20MaskedIndex[n3 >>> 10] = memoryArray4;
                    memoryArray = memoryArray4;
                }
                memoryArray2[n2 & 0x3FF] = this.nonA20MaskedIndex[n][i];
                memoryArray[n3 & 0x3FF] = this.nonA20MaskedIndex[n][i];
            }
        }
    }

    @Override
    public void dumpSRPartial(SRDumper sRDumper) throws IOException {
        super.dumpSRPartial(sRDumper);
        sRDumper.specialObject(UNCONNECTED);
        sRDumper.dumpInt(this.sysRAMSize);
        sRDumper.dumpInt(this.quickIndexSize);
        sRDumper.dumpBoolean(this.gateA20MaskState);
        this.dumpMemoryTableSR(sRDumper, this.quickNonA20MaskedIndex);
        this.dumpMemoryDTableSR(sRDumper, this.nonA20MaskedIndex);
        sRDumper.dumpObject(this.linearAddr);
        sRDumper.dumpObject(this.manager);
    }

    private Memory[][] loadMemoryDTableSR(SRLoader sRLoader) throws IOException {
        boolean bl = sRLoader.loadBoolean();
        if (!bl) {
            return null;
        }
        Memory[][] memoryArray = new Memory[sRLoader.loadInt()][];
        for (int i = 0; i < memoryArray.length; ++i) {
            memoryArray[i] = this.loadMemoryTableSR(sRLoader);
        }
        return memoryArray;
    }

    private Memory[] loadMemoryTableSR(SRLoader sRLoader) throws IOException {
        boolean bl = sRLoader.loadBoolean();
        if (!bl) {
            return null;
        }
        Memory[] memoryArray = new Memory[sRLoader.loadInt()];
        for (int i = 0; i < memoryArray.length; ++i) {
            memoryArray[i] = (Memory)sRLoader.loadObject();
        }
        return memoryArray;
    }

    public PhysicalAddressSpace(SRLoader sRLoader) throws IOException {
        super(sRLoader);
        sRLoader.specialObject(UNCONNECTED);
        this.sysRAMSize = sRLoader.loadInt();
        this.quickIndexSize = sRLoader.loadInt();
        this.gateA20MaskState = sRLoader.loadBoolean();
        this.quickNonA20MaskedIndex = this.loadMemoryTableSR(sRLoader);
        this.nonA20MaskedIndex = this.loadMemoryDTableSR(sRLoader);
        this.reconstructA20MaskedTables();
        if (this.gateA20MaskState) {
            this.quickIndex = this.quickNonA20MaskedIndex;
            this.index = this.nonA20MaskedIndex;
        } else {
            this.quickIndex = this.quickA20MaskedIndex;
            this.index = this.a20MaskedIndex;
        }
        this.linearAddr = (LinearAddressSpace)sRLoader.loadObject();
        this.manager = (CodeBlockManager)sRLoader.loadObject();
    }

    private void dumpMemoryDTableSR(SRDumper sRDumper, Memory[][] memoryArray) throws IOException {
        if (memoryArray == null) {
            sRDumper.dumpBoolean(false);
        } else {
            sRDumper.dumpBoolean(true);
            sRDumper.dumpInt(memoryArray.length);
            for (int i = 0; i < memoryArray.length; ++i) {
                this.dumpMemoryTableSR(sRDumper, memoryArray[i]);
            }
        }
    }

    private void dumpMemoryTableSR(SRDumper sRDumper, Memory[] memoryArray) throws IOException {
        if (memoryArray == null) {
            sRDumper.dumpBoolean(false);
        } else {
            sRDumper.dumpBoolean(true);
            sRDumper.dumpInt(memoryArray.length);
            for (int i = 0; i < memoryArray.length; ++i) {
                sRDumper.dumpObject(memoryArray[i]);
            }
        }
    }

    private void dumpMemoryTableStatus(StatusDumper statusDumper, Memory[] memoryArray, String string) {
        if (memoryArray == null) {
            statusDumper.println("\t" + string + " null");
        } else {
            for (int i = 0; i < memoryArray.length; ++i) {
                statusDumper.println("\t" + string + "[" + i + "] <object #" + statusDumper.objectNumber(memoryArray[i]) + ">");
                if (memoryArray[i] == null) continue;
                memoryArray[i].dumpStatus(statusDumper);
            }
        }
    }

    private void dumpMemoryDTableStatus(StatusDumper statusDumper, Memory[][] memoryArray, String string) {
        if (memoryArray == null) {
            statusDumper.println("\t" + string + ": null");
        } else {
            for (int i = 0; i < memoryArray.length; ++i) {
                if (memoryArray[i] != null) {
                    for (int j = 0; j < memoryArray.length; ++j) {
                        statusDumper.println("\t" + string + "[" + i + "][" + j + "] <object #" + statusDumper.objectNumber(memoryArray[i][j]) + ">");
                        if (memoryArray[i][j] == null) continue;
                        memoryArray[i][j].dumpStatus(statusDumper);
                    }
                    continue;
                }
                statusDumper.println("\t" + string + "[" + i + "] null");
            }
        }
    }

    private void initialiseMemory() {
        int n;
        for (n = 0; n < this.sysRAMSize; n += 4096) {
            this.mapMemory(n, new LazyCodeBlockMemory(4096, this.manager));
        }
        for (n = 0; n < 32; ++n) {
            this.mapMemory(851968 + n * 4096, new UnconnectedMemoryBlock());
        }
    }

    public CodeBlockManager getCodeBlockManager() {
        return this.manager;
    }

    public void setGateA20State(boolean bl) {
        this.gateA20MaskState = bl;
        if (bl) {
            this.quickIndex = this.quickNonA20MaskedIndex;
            this.index = this.nonA20MaskedIndex;
        } else {
            this.quickIndex = this.quickA20MaskedIndex;
            this.index = this.a20MaskedIndex;
        }
        if (this.linearAddr != null && this.linearAddr.isPagingEnabled()) {
            this.linearAddr.flush();
        }
    }

    public boolean getGateA20State() {
        return this.gateA20MaskState;
    }

    @Override
    protected Memory getReadMemoryBlockAt(int n) {
        return this.getMemoryBlockAt(n);
    }

    @Override
    protected Memory getWriteMemoryBlockAt(int n) {
        return this.getMemoryBlockAt(n);
    }

    @Override
    public int executeReal(Processor processor, int n) {
        return this.getReadMemoryBlockAt(n).executeReal(processor, n & 0xFFF);
    }

    @Override
    public int executeProtected(Processor processor, int n) {
        System.err.println("Critical error: Trying to run Protected mode block in physical memory.");
        throw new IllegalStateException("Cannot execute protected mode block in physical memory");
    }

    @Override
    public int executeVirtual8086(Processor processor, int n) {
        System.err.println("Critical error: Trying to run Protected mode block in physical memory.");
        throw new IllegalStateException("Cannot execute protected mode block in physical memory");
    }

    @Override
    protected void replaceBlocks(Memory memory, Memory memory2) {
        int n;
        int n2;
        for (n2 = 0; n2 < this.quickA20MaskedIndex.length; ++n2) {
            if (this.quickA20MaskedIndex[n2] != memory) continue;
            this.quickA20MaskedIndex[n2] = memory2;
        }
        for (n2 = 0; n2 < this.quickNonA20MaskedIndex.length; ++n2) {
            if (this.quickNonA20MaskedIndex[n2] != memory) continue;
            this.quickNonA20MaskedIndex[n2] = memory2;
        }
        for (Memory[] memoryArray : this.a20MaskedIndex) {
            if (memoryArray == null) continue;
            for (n = 0; n < memoryArray.length; ++n) {
                if (memoryArray[n] != memory) continue;
                memoryArray[n] = memory2;
            }
        }
        for (Memory[] memoryArray : this.nonA20MaskedIndex) {
            if (memoryArray == null) continue;
            for (n = 0; n < memoryArray.length; ++n) {
                if (memoryArray[n] != memory) continue;
                memoryArray[n] = memory2;
            }
        }
    }

    @Override
    public void clear() {
        for (Memory memory : this.quickNonA20MaskedIndex) {
            memory.clear();
        }
        for (Memory memory : this.nonA20MaskedIndex) {
            if (memory == null) continue;
            for (Memory memory2 : memory) {
                try {
                    memory2.clear();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
    }

    public void unmap(int n, int n2) {
        if (n % 4096 != 0) {
            System.err.println("Critical error: Illegal unmap request: start=" + Integer.toHexString(n) + ", length=" + Integer.toHexString(n2) + ".");
            throw new IllegalStateException("Cannot deallocate memory starting at " + Integer.toHexString(n) + "; this is not block aligned at " + 4096 + " boundaries");
        }
        if (n2 % 4096 != 0) {
            System.err.println("Critical error: Illegal unmap request: start=" + Integer.toHexString(n) + ", length=" + Integer.toHexString(n2) + ".");
            throw new IllegalStateException("Cannot deallocate memory in partial blocks. " + n2 + " is not a multiple of " + 4096);
        }
        for (int i = n; i < n + n2; i += 4096) {
            this.setMemoryBlockAt(i, UNCONNECTED);
        }
    }

    public void mapMemoryRegion(Memory memory, int n, int n2) {
        long l;
        if (memory.getSize() < (long)n2) {
            System.err.println("Critical error: Map request size exceeds mapped memory size.");
            throw new IllegalStateException("Underlying memory (length=" + memory.getSize() + ") is too short for mapping into region " + n2 + " bytes long");
        }
        if (n % 4096 != 0) {
            System.err.println("Critical error: Illegal map request: start=" + Integer.toHexString(n) + ", length=" + Integer.toHexString(n2) + ".");
            throw new IllegalStateException("Cannot map memory starting at " + Integer.toHexString(n) + "; this is not aligned to " + 4096 + " blocks");
        }
        if (n2 % 4096 != 0) {
            System.err.println("Critical error: Illegal map request: start=" + Integer.toHexString(n) + ", length=" + Integer.toHexString(n2) + ".");
            throw new IllegalStateException("Cannot map memory in partial blocks: " + n2 + " is not a multiple of " + 4096);
        }
        this.unmap(n, n2);
        for (long i = l = 0xFFFFFFFFL & (long)n; i < l + (long)n2; i += 4096L) {
            MapWrapper mapWrapper = new MapWrapper(memory, (int)(i - l));
            this.setMemoryBlockAt((int)i, mapWrapper);
        }
    }

    public void mapMemory(int n, Memory memory) {
        if (n % 4096 != 0) {
            System.err.println("Critical error: Illegal map request: start=" + Integer.toHexString(n) + ".");
            throw new IllegalStateException("Cannot allocate memory starting at " + Integer.toHexString(n) + "; this is not aligned to " + 4096 + " bytes");
        }
        if (memory.getSize() != 4096L) {
            System.err.println("Critical error: Illegal map request: Impossible underlying memory size.");
            throw new IllegalStateException("Can only allocate memory in blocks of 4096");
        }
        this.unmap(n, 4096);
        long l = 0xFFFFFFFFL & (long)n;
        this.setMemoryBlockAt((int)l, memory);
    }

    @Override
    public void reset() {
        this.clear();
        this.setGateA20State(false);
        this.linearAddr = null;
    }

    @Override
    public boolean initialised() {
        return this.linearAddr != null;
    }

    @Override
    public void acceptComponent(HardwareComponent hardwareComponent) {
        if (hardwareComponent instanceof LinearAddressSpace) {
            this.linearAddr = (LinearAddressSpace)hardwareComponent;
        }
    }

    public String toString() {
        return "Physical Address Bus";
    }

    private Memory getMemoryBlockAt(int n) {
        try {
            return this.quickIndex[n >>> 12];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            try {
                return this.index[n >>> 22][n >>> 12 & 0x3FF];
            }
            catch (NullPointerException nullPointerException) {
                return UNCONNECTED;
            }
        }
    }

    private void setMemoryBlockAt(int n, Memory memory) {
        block9: {
            try {
                int n2 = n >>> 12;
                this.quickNonA20MaskedIndex[n2] = memory;
                if ((n2 & 0xFFEFF) == n2) {
                    this.quickA20MaskedIndex[n2] = memory;
                    this.quickA20MaskedIndex[n2 | 0x100] = memory;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                try {
                    this.nonA20MaskedIndex[n >>> 22][n >>> 12 & 0x3FF] = memory;
                }
                catch (NullPointerException nullPointerException) {
                    this.nonA20MaskedIndex[n >>> 22] = new Memory[1024];
                    this.nonA20MaskedIndex[n >>> 22][n >>> 12 & 0x3FF] = memory;
                }
                if ((n & 0xFFEFFFFF) != n) break block9;
                try {
                    this.a20MaskedIndex[n >>> 22][n >>> 12 & 0x3FF] = memory;
                }
                catch (NullPointerException nullPointerException) {
                    this.a20MaskedIndex[n >>> 22] = new Memory[1024];
                    this.a20MaskedIndex[n >>> 22][n >>> 12 & 0x3FF] = memory;
                }
                int n3 = n | 0x100000;
                try {
                    this.a20MaskedIndex[n3 >>> 22][n3 >>> 12 & 0x3FF] = memory;
                }
                catch (NullPointerException nullPointerException) {
                    this.a20MaskedIndex[n3 >>> 22] = new Memory[1024];
                    this.a20MaskedIndex[n3 >>> 22][n3 >>> 12 & 0x3FF] = memory;
                }
            }
        }
    }

    @Override
    public void loadInitialContents(int n, byte[] byArray, int n2, int n3) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static final class UnconnectedMemoryBlock
    implements Memory {
        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
        }

        public UnconnectedMemoryBlock(SRLoader sRLoader) throws IOException {
            sRLoader.objectCreated(this);
        }

        public UnconnectedMemoryBlock() {
        }

        public void dumpStatusPartial(StatusDumper statusDumper) {
        }

        @Override
        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": UnconnectedMemoryBlock:");
            this.dumpStatusPartial(statusDumper);
            statusDumper.endObject();
        }

        @Override
        public boolean isAllocated() {
            return false;
        }

        @Override
        public void clear() {
        }

        @Override
        public void clear(int n, int n2) {
        }

        @Override
        public void copyContentsIntoArray(int n, byte[] byArray, int n2, int n3) {
        }

        @Override
        public void copyArrayIntoContents(int n, byte[] byArray, int n2, int n3) {
            System.err.println("Critical error: Illegal map request: Cannot load array into unconnected memory block.");
            throw new IllegalStateException("Cannot load array into unconnected memory block");
        }

        @Override
        public long getSize() {
            return 4096L;
        }

        @Override
        public byte getByte(int n) {
            return -1;
        }

        @Override
        public short getWord(int n) {
            return -1;
        }

        @Override
        public int getDoubleWord(int n) {
            return -1;
        }

        @Override
        public long getQuadWord(int n) {
            return -1L;
        }

        @Override
        public long getLowerDoubleQuadWord(int n) {
            return -1L;
        }

        @Override
        public long getUpperDoubleQuadWord(int n) {
            return -1L;
        }

        @Override
        public void setByte(int n, byte by) {
        }

        @Override
        public void setWord(int n, short s) {
        }

        @Override
        public void setDoubleWord(int n, int n2) {
        }

        @Override
        public void setQuadWord(int n, long l) {
        }

        @Override
        public void setLowerDoubleQuadWord(int n, long l) {
        }

        @Override
        public void setUpperDoubleQuadWord(int n, long l) {
        }

        @Override
        public int executeReal(Processor processor, int n) {
            System.err.println("Critical error: Can not execute in unconnected memory.");
            throw new IllegalStateException("Trying to execute in Unconnected Block @ 0x" + Integer.toHexString(n));
        }

        @Override
        public int executeProtected(Processor processor, int n) {
            System.err.println("Critical error: Can not execute in unconnected memory.");
            throw new IllegalStateException("Trying to execute in Unconnected Block @ 0x" + Integer.toHexString(n));
        }

        @Override
        public int executeVirtual8086(Processor processor, int n) {
            System.err.println("Critical error: Can not execute in unconnected memory.");
            throw new IllegalStateException("Trying to execute in Unconnected Block @ 0x" + Integer.toHexString(n));
        }

        public String toString() {
            return "Unconnected Memory";
        }

        @Override
        public void loadInitialContents(int n, byte[] byArray, int n2, int n3) {
        }
    }

    public static class MapWrapper
    implements Memory {
        private Memory memory;
        private int baseAddress;

        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
            sRDumper.dumpObject(this.memory);
            sRDumper.dumpInt(this.baseAddress);
        }

        public void dumpStatusPartial(StatusDumper statusDumper) {
            statusDumper.println("\tbaseAddress " + this.baseAddress);
            statusDumper.println("\tmemory <object #" + statusDumper.objectNumber(this.memory) + ">");
            if (this.memory != null) {
                this.memory.dumpStatus(statusDumper);
            }
        }

        @Override
        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": MapWrapper:");
            this.dumpStatusPartial(statusDumper);
            statusDumper.endObject();
        }

        public MapWrapper(SRLoader sRLoader) throws IOException {
            sRLoader.objectCreated(this);
            this.memory = (Memory)sRLoader.loadObject();
            this.baseAddress = sRLoader.loadInt();
        }

        MapWrapper(Memory memory, int n) {
            this.baseAddress = n;
            this.memory = memory;
        }

        @Override
        public long getSize() {
            return 4096L;
        }

        @Override
        public boolean isAllocated() {
            return this.memory.isAllocated();
        }

        @Override
        public void clear() {
            this.memory.clear(this.baseAddress, (int)this.getSize());
        }

        @Override
        public void clear(int n, int n2) {
            if ((long)(n + n2) > this.getSize()) {
                throw new ArrayIndexOutOfBoundsException("Attempt to clear outside of memory bounds");
            }
            n = this.baseAddress | n;
            this.memory.clear(n, n2);
        }

        @Override
        public void copyContentsIntoArray(int n, byte[] byArray, int n2, int n3) {
            n = this.baseAddress | n;
            this.memory.copyContentsIntoArray(n, byArray, n2, n3);
        }

        @Override
        public void copyArrayIntoContents(int n, byte[] byArray, int n2, int n3) {
            n = this.baseAddress | n;
            this.memory.copyArrayIntoContents(n, byArray, n2, n3);
        }

        @Override
        public byte getByte(int n) {
            n = this.baseAddress | n;
            return this.memory.getByte(n);
        }

        @Override
        public short getWord(int n) {
            n = this.baseAddress | n;
            return this.memory.getWord(n);
        }

        @Override
        public int getDoubleWord(int n) {
            n = this.baseAddress | n;
            return this.memory.getDoubleWord(n);
        }

        @Override
        public long getQuadWord(int n) {
            n = this.baseAddress | n;
            return this.memory.getQuadWord(n);
        }

        @Override
        public long getLowerDoubleQuadWord(int n) {
            n = this.baseAddress | n;
            return this.memory.getQuadWord(n);
        }

        @Override
        public long getUpperDoubleQuadWord(int n) {
            n += 8;
            n = this.baseAddress | n;
            return this.memory.getQuadWord(n);
        }

        @Override
        public void setByte(int n, byte by) {
            n = this.baseAddress | n;
            this.memory.setByte(n, by);
        }

        @Override
        public void setWord(int n, short s) {
            n = this.baseAddress | n;
            this.memory.setWord(n, s);
        }

        @Override
        public void setDoubleWord(int n, int n2) {
            n = this.baseAddress | n;
            this.memory.setDoubleWord(n, n2);
        }

        @Override
        public void setQuadWord(int n, long l) {
            n = this.baseAddress | n;
            this.memory.setQuadWord(n, l);
        }

        @Override
        public void setLowerDoubleQuadWord(int n, long l) {
            n = this.baseAddress | n;
            this.memory.setQuadWord(n, l);
        }

        @Override
        public void setUpperDoubleQuadWord(int n, long l) {
            n += 8;
            n = this.baseAddress | n;
            this.memory.setQuadWord(n, l);
        }

        @Override
        public int executeReal(Processor processor, int n) {
            n = this.baseAddress | n;
            return this.memory.executeReal(processor, n);
        }

        @Override
        public int executeProtected(Processor processor, int n) {
            System.err.println("Critical error: Trying to run Protected mode block in physical memory.");
            throw new IllegalStateException("Cannot execute protected mode block in physical memory");
        }

        @Override
        public int executeVirtual8086(Processor processor, int n) {
            System.err.println("Critical error: Trying to run Protected mode block in physical memory.");
            throw new IllegalStateException("Cannot execute protected mode block in physical memory");
        }

        public String toString() {
            return "Mapped Memory";
        }

        @Override
        public void loadInitialContents(int n, byte[] byArray, int n2, int n3) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

