/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.memory.codeblock;

import org.jpc.emulator.memory.Memory;
import org.jpc.emulator.memory.codeblock.ByteSource;

class ByteSourceWrappedMemory
implements ByteSource {
    private Memory source;
    private int offset;
    private int startingPosition;

    ByteSourceWrappedMemory() {
    }

    public void set(Memory memory, int n) {
        this.source = memory;
        this.offset = n;
        this.startingPosition = n;
    }

    public int getOffset() {
        return this.offset;
    }

    @Override
    public byte getByte() {
        return this.source.getByte(this.offset++);
    }

    @Override
    public void skip(int n) {
        if ((long)(this.offset + n) >= this.source.getSize()) {
            throw new IndexOutOfBoundsException();
        }
        this.offset += n;
    }

    @Override
    public void reset() {
        this.offset = this.startingPosition;
    }

    public String toString() {
        return "ByteSourceWrappedMemory: [" + this.source + "] @ 0x" + Integer.toHexString(this.startingPosition);
    }
}

