/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.memory.codeblock;

import org.jpc.emulator.memory.codeblock.ByteSource;
import org.jpc.emulator.memory.codeblock.CodeBlockCompiler;
import org.jpc.emulator.memory.codeblock.CodeBlockFactory;
import org.jpc.emulator.memory.codeblock.Decoder;
import org.jpc.emulator.memory.codeblock.ProtectedModeCodeBlock;
import org.jpc.emulator.memory.codeblock.RealModeCodeBlock;
import org.jpc.emulator.memory.codeblock.Virtual8086ModeCodeBlock;

class DefaultCodeBlockFactory
implements CodeBlockFactory {
    private final Decoder decoder;
    private final CodeBlockCompiler compiler;
    private final int limit;

    public DefaultCodeBlockFactory(Decoder decoder, CodeBlockCompiler codeBlockCompiler, int n) {
        this.decoder = decoder;
        this.compiler = codeBlockCompiler;
        this.limit = n;
    }

    @Override
    public RealModeCodeBlock getRealModeCodeBlock(ByteSource byteSource) {
        return this.compiler.getRealModeCodeBlock(this.decoder.decodeReal(byteSource, this.limit));
    }

    @Override
    public ProtectedModeCodeBlock getProtectedModeCodeBlock(ByteSource byteSource, boolean bl) {
        return this.compiler.getProtectedModeCodeBlock(this.decoder.decodeProtected(byteSource, bl, this.limit));
    }

    @Override
    public Virtual8086ModeCodeBlock getVirtual8086ModeCodeBlock(ByteSource byteSource) {
        return this.compiler.getVirtual8086ModeCodeBlock(this.decoder.decodeVirtual8086(byteSource, this.limit));
    }
}

