/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.memory.codeblock.optimised;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import org.jpc.emulator.memory.codeblock.optimised.MicrocodeSet;

public class OpcodeLogger {
    int[] opcodeCounts = new int[755];
    int count = 0;
    int MAX = 5000000;
    private String name;
    private static Hashtable<String, String> reflectedNameCache = new Hashtable();

    OpcodeLogger(String string) {
        this.name = string;
    }

    public boolean hasImmediate(int n) {
        return n == 3 | n == 8 | n == 13 | n == 26 | n == 27 | n == 49 | n == 168 | n == 229 | n == 255;
    }

    public void addBlock(int[] nArray) {
        boolean bl = false;
        for (int i = 0; i < nArray.length; ++i) {
            if (!bl) {
                this.addOpcode(nArray[i]);
                if (!this.hasImmediate(nArray[i])) continue;
                bl = true;
                continue;
            }
            bl = false;
        }
    }

    public void addOpcode(int n) {
        int n2 = n;
        this.opcodeCounts[n2] = this.opcodeCounts[n2] + 1;
        ++this.count;
        if (this.count >= this.MAX) {
            this.printStats();
            this.count = 0;
        }
    }

    public void printStats() {
        System.out.println("*******************************");
        System.out.println(this.name);
        for (int i = 0; i < this.opcodeCounts.length; ++i) {
            if (this.opcodeCounts[i] <= 0) continue;
            System.out.println(reflectedNameCache.get(String.valueOf(i)) + ": " + this.opcodeCounts[i]);
        }
    }

    static {
        try {
            Class<MicrocodeSet> clazz = MicrocodeSet.class;
            Field[] fieldArray = clazz.getDeclaredFields();
            int n = 0;
            for (int i = 0; i < fieldArray.length; ++i) {
                Field field = fieldArray[i];
                int n2 = field.getModifiers();
                if (!Modifier.isPublic(n2) || !Modifier.isStatic(n2) || !Modifier.isFinal(n2) || field.getType() != Integer.TYPE) continue;
                int n3 = field.getInt(null);
                ++n;
                reflectedNameCache.put(String.valueOf(n3), field.getName());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

