/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.memory.codeblock.optimised;

import java.util.HashMap;
import org.jpc.emulator.memory.codeblock.ArrayBackedInstructionSource;
import org.jpc.emulator.memory.codeblock.InstructionSource;
import org.jpc.emulator.memory.codeblock.ProtectedModeCodeBlock;
import org.jpc.emulator.memory.codeblock.optimised.OpcodeLogger;
import org.jpc.emulator.processor.Processor;
import org.jpc.emulator.processor.ProcessorException;
import org.jpc.emulator.processor.ProtectedModeSegment;
import org.jpc.emulator.processor.Segment;
import org.jpc.emulator.processor.SegmentFactory;
import org.jpc.emulator.processor.fpu64.FpuState;

public class ProtectedModeUBlock
implements ProtectedModeCodeBlock {
    private static final boolean[] parityMap = new boolean[256];
    private Processor cpu;
    private FpuState fpu;
    private int x86Count;
    protected int[] microcodes;
    protected int[] cumulativeX86Length;
    private int executeCount;
    private HashMap<Integer, Integer> haltComplained = new HashMap();
    public static OpcodeLogger opcodeCounter;
    private boolean invalidated = false;

    public ProtectedModeUBlock() {
    }

    public ProtectedModeUBlock(int[] nArray, int[] nArray2) {
        this();
        this.microcodes = nArray;
        this.cumulativeX86Length = nArray2;
        if (this.cumulativeX86Length.length == 0) {
            this.x86Count = 0;
        } else {
            int n = 1;
            for (int i = 1; i < this.cumulativeX86Length.length; ++i) {
                if (this.cumulativeX86Length[i] <= this.cumulativeX86Length[i - 1]) continue;
                ++n;
            }
            this.x86Count = n;
        }
    }

    @Override
    public int getX86Length() {
        if (this.microcodes.length == 0) {
            return 0;
        }
        return this.cumulativeX86Length[this.microcodes.length - 1];
    }

    @Override
    public int getX86Count() {
        return this.x86Count;
    }

    @Override
    public boolean handleMemoryRegionChange(int n, int n2) {
        return false;
    }

    @Override
    public void invalidate() {
        this.invalidated = true;
    }

    @Override
    public String getDisplayString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.toString()).append('\n');
        for (int i = 0; i < this.microcodes.length; ++i) {
            stringBuilder.append(i).append(": ").append(this.microcodes[i]).append('\n');
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return "Protected Mode Interpreted Block";
    }

    public InstructionSource getAsInstructionSource() {
        int[] nArray = new int[this.microcodes.length];
        int[] nArray2 = new int[this.microcodes.length];
        System.arraycopy(this.microcodes, 0, nArray, 0, nArray.length);
        System.arraycopy(this.cumulativeX86Length, 0, nArray2, 0, nArray2.length);
        return new ArrayBackedInstructionSource(nArray, nArray2);
    }

    public int[] getMicrocodes() {
        int[] nArray = new int[this.microcodes.length];
        System.arraycopy(this.microcodes, 0, nArray, 0, nArray.length);
        return nArray;
    }

    /*
     * Exception decompiling
     */
    @Override
    public int execute(Processor var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [609[UNCONDITIONALDOLOOP]], but top level block is 610[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int getInstructionLength(int n) {
        int n2 = n - 1;
        int n3 = -this.cumulativeX86Length[n2];
        for (int i = n2; i >= 0; --i) {
            if (this.cumulativeX86Length[i] == this.cumulativeX86Length[n2]) continue;
            n3 += this.cumulativeX86Length[i];
            break;
        }
        if (n3 <= 0) {
            n3 = -n3;
        }
        return n3;
    }

    private final void cmpsb_a32(Segment segment) {
        int n = this.cpu.esi;
        int n2 = this.cpu.edi;
        int n3 = 0xFF & segment.getByte(n);
        int n4 = 0xFF & this.cpu.es.getByte(n2);
        if (this.cpu.eflagsDirection) {
            --n;
            --n2;
        } else {
            ++n;
            ++n2;
        }
        this.cpu.esi = n;
        this.cpu.edi = n2;
        this.sub_o8_flags(n3 - n4, n3, n4);
    }

    private final void cmpsw_a32(Segment segment) {
        int n = this.cpu.esi;
        int n2 = this.cpu.edi;
        int n3 = 0xFFFF & segment.getWord(n);
        int n4 = 0xFFFF & this.cpu.es.getWord(n2);
        if (this.cpu.eflagsDirection) {
            n -= 2;
            n2 -= 2;
        } else {
            n += 2;
            n2 += 2;
        }
        this.cpu.esi = n;
        this.cpu.edi = n2;
        this.sub_o16_flags(n3 - n4, n3, n4);
    }

    private final void cmpsd_a32(Segment segment) {
        int n = this.cpu.esi;
        int n2 = this.cpu.edi;
        int n3 = segment.getDoubleWord(n);
        int n4 = this.cpu.es.getDoubleWord(n2);
        if (this.cpu.eflagsDirection) {
            n -= 4;
            n2 -= 4;
        } else {
            n += 4;
            n2 += 4;
        }
        this.cpu.esi = n;
        this.cpu.edi = n2;
        this.sub_o32_flags((0xFFFFFFFFL & (long)n3) - (0xFFFFFFFFL & (long)n4), n3, n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void repe_cmpsb_a16(Segment segment) {
        block7: {
            int n = 0xFFFF & this.cpu.ecx;
            int n2 = 0xFFFF & this.cpu.esi;
            int n3 = 0xFFFF & this.cpu.edi;
            boolean bl = n != 0;
            int n4 = 0;
            int n5 = 0;
            try {
                if (this.cpu.eflagsDirection) {
                    while (n != 0) {
                        n4 = 0xFF & segment.getByte(n2);
                        n5 = 0xFF & this.cpu.es.getByte(n3);
                        --n;
                        --n2;
                        --n3;
                        if (n4 == n5) continue;
                        break block7;
                    }
                    break block7;
                }
                while (n != 0) {
                    n4 = 0xFF & segment.getByte(n2);
                    n5 = 0xFF & this.cpu.es.getByte(n3);
                    --n;
                    ++n2;
                    ++n3;
                    if (n4 == n5) continue;
                    break;
                }
            }
            finally {
                this.executeCount += (this.cpu.ecx & 0xFFFF) - n;
                this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | n & 0xFFFF;
                this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n2 & 0xFFFF;
                this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n3 & 0xFFFF;
                if (bl) {
                    this.sub_o8_flags(n4 - n5, n4, n5);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void repe_cmpsb_a32(Segment segment) {
        block7: {
            int n = this.cpu.ecx;
            int n2 = this.cpu.esi;
            int n3 = this.cpu.edi;
            boolean bl = n != 0;
            int n4 = 0;
            int n5 = 0;
            try {
                if (this.cpu.eflagsDirection) {
                    while (n != 0) {
                        n4 = 0xFF & segment.getByte(n2);
                        n5 = 0xFF & this.cpu.es.getByte(n3);
                        --n;
                        --n2;
                        --n3;
                        if (n4 == n5) continue;
                        break block7;
                    }
                    break block7;
                }
                while (n != 0) {
                    n4 = 0xFF & segment.getByte(n2);
                    n5 = 0xFF & this.cpu.es.getByte(n3);
                    --n;
                    ++n2;
                    ++n3;
                    if (n4 == n5) continue;
                    break;
                }
            }
            finally {
                this.executeCount += this.cpu.ecx - n;
                this.cpu.ecx = n;
                this.cpu.esi = n2;
                this.cpu.edi = n3;
                if (bl) {
                    this.sub_o8_flags(n4 - n5, n4, n5);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void repe_cmpsw_a16(Segment segment) {
        block7: {
            int n = 0xFFFF & this.cpu.ecx;
            int n2 = 0xFFFF & this.cpu.esi;
            int n3 = 0xFFFF & this.cpu.edi;
            boolean bl = n != 0;
            int n4 = 0;
            int n5 = 0;
            try {
                if (this.cpu.eflagsDirection) {
                    while (n != 0) {
                        n4 = 0xFFFF & segment.getWord(n2);
                        n5 = 0xFFFF & this.cpu.es.getWord(n3);
                        --n;
                        n2 -= 2;
                        n3 -= 2;
                        if (n4 == n5) continue;
                        break block7;
                    }
                    break block7;
                }
                while (n != 0) {
                    n4 = 0xFFFF & segment.getWord(n2);
                    n5 = 0xFFFF & this.cpu.es.getWord(n3);
                    --n;
                    n2 += 2;
                    n3 += 2;
                    if (n4 == n5) continue;
                    break;
                }
            }
            finally {
                this.executeCount += (this.cpu.ecx & 0xFFFF) - n;
                this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | n & 0xFFFF;
                this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n2 & 0xFFFF;
                this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n3 & 0xFFFF;
                if (bl) {
                    this.sub_o16_flags(n4 - n5, n4, n5);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void repe_cmpsw_a32(Segment segment) {
        block7: {
            int n = this.cpu.ecx;
            int n2 = this.cpu.esi;
            int n3 = this.cpu.edi;
            boolean bl = n != 0;
            int n4 = 0;
            int n5 = 0;
            try {
                if (this.cpu.eflagsDirection) {
                    while (n != 0) {
                        n4 = 0xFFFF & segment.getWord(n2);
                        n5 = 0xFFFF & this.cpu.es.getWord(n3);
                        --n;
                        n2 -= 2;
                        n3 -= 2;
                        if (n4 == n5) continue;
                        break block7;
                    }
                    break block7;
                }
                while (n != 0) {
                    n4 = 0xFFFF & segment.getWord(n2);
                    n5 = 0xFFFF & this.cpu.es.getWord(n3);
                    --n;
                    n2 += 2;
                    n3 += 2;
                    if (n4 == n5) continue;
                    break;
                }
            }
            finally {
                this.executeCount += this.cpu.ecx - n;
                this.cpu.ecx = n;
                this.cpu.esi = n2;
                this.cpu.edi = n3;
                if (bl) {
                    this.sub_o16_flags(n4 - n5, n4, n5);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void repe_cmpsd_a16(Segment segment) {
        block7: {
            int n = 0xFFFF & this.cpu.ecx;
            int n2 = 0xFFFF & this.cpu.esi;
            int n3 = 0xFFFF & this.cpu.edi;
            boolean bl = n != 0;
            int n4 = 0;
            int n5 = 0;
            try {
                if (this.cpu.eflagsDirection) {
                    while (n != 0) {
                        n4 = segment.getDoubleWord(n2);
                        n5 = this.cpu.es.getDoubleWord(n3);
                        --n;
                        n2 -= 4;
                        n3 -= 4;
                        if (n4 == n5) continue;
                        break block7;
                    }
                    break block7;
                }
                while (n != 0) {
                    n4 = segment.getDoubleWord(n2);
                    n5 = this.cpu.es.getDoubleWord(n3);
                    --n;
                    n2 += 4;
                    n3 += 4;
                    if (n4 == n5) continue;
                    break;
                }
            }
            finally {
                this.executeCount += (this.cpu.ecx & 0xFFFF) - n;
                this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | n & 0xFFFF;
                this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n2 & 0xFFFF;
                this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n3 & 0xFFFF;
                if (bl) {
                    this.sub_o32_flags((0xFFFFFFFFL & (long)n4) - (0xFFFFFFFFL & (long)n5), n4, n5);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void repe_cmpsd_a32(Segment segment) {
        block7: {
            int n = this.cpu.ecx;
            int n2 = this.cpu.esi;
            int n3 = this.cpu.edi;
            boolean bl = n != 0;
            int n4 = 0;
            int n5 = 0;
            try {
                if (this.cpu.eflagsDirection) {
                    while (n != 0) {
                        n4 = segment.getDoubleWord(n2);
                        n5 = this.cpu.es.getDoubleWord(n3);
                        --n;
                        n2 -= 4;
                        n3 -= 4;
                        if (n4 == n5) continue;
                        break block7;
                    }
                    break block7;
                }
                while (n != 0) {
                    n4 = segment.getDoubleWord(n2);
                    n5 = this.cpu.es.getDoubleWord(n3);
                    --n;
                    n2 += 4;
                    n3 += 4;
                    if (n4 == n5) continue;
                    break;
                }
            }
            finally {
                this.executeCount += this.cpu.ecx - n;
                this.cpu.ecx = n;
                this.cpu.esi = n2;
                this.cpu.edi = n3;
                if (bl) {
                    this.sub_o32_flags((0xFFFFFFFFL & (long)n4) - (0xFFFFFFFFL & (long)n5), n4, n5);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void repne_cmpsb_a16(Segment segment) {
        block7: {
            int n = 0xFFFF & this.cpu.ecx;
            int n2 = 0xFFFF & this.cpu.esi;
            int n3 = 0xFFFF & this.cpu.edi;
            boolean bl = n != 0;
            int n4 = 0;
            int n5 = 0;
            try {
                if (this.cpu.eflagsDirection) {
                    while (n != 0) {
                        n4 = 0xFF & segment.getByte(n2);
                        n5 = 0xFF & this.cpu.es.getByte(n3);
                        --n;
                        --n2;
                        --n3;
                        if (n4 != n5) continue;
                        break block7;
                    }
                    break block7;
                }
                while (n != 0) {
                    n4 = 0xFF & segment.getByte(n2);
                    n5 = 0xFF & this.cpu.es.getByte(n3);
                    --n;
                    ++n2;
                    ++n3;
                    if (n4 != n5) continue;
                    break;
                }
            }
            finally {
                this.executeCount += (this.cpu.ecx & 0xFFFF) - n;
                this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | n & 0xFFFF;
                this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n2 & 0xFFFF;
                this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n3 & 0xFFFF;
                if (bl) {
                    this.sub_o8_flags(n4 - n5, n4, n5);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void repne_cmpsb_a32(Segment segment) {
        block7: {
            int n = this.cpu.ecx;
            int n2 = this.cpu.esi;
            int n3 = this.cpu.edi;
            boolean bl = n != 0;
            int n4 = 0;
            int n5 = 0;
            try {
                if (this.cpu.eflagsDirection) {
                    while (n != 0) {
                        n4 = 0xFF & segment.getByte(n2);
                        n5 = 0xFF & this.cpu.es.getByte(n3);
                        --n;
                        --n2;
                        --n3;
                        if (n4 != n5) continue;
                        break block7;
                    }
                    break block7;
                }
                while (n != 0) {
                    n4 = 0xFF & segment.getByte(n2);
                    n5 = 0xFF & this.cpu.es.getByte(n3);
                    --n;
                    ++n2;
                    ++n3;
                    if (n4 != n5) continue;
                    break;
                }
            }
            finally {
                this.executeCount += this.cpu.ecx - n;
                this.cpu.ecx = n;
                this.cpu.esi = n2;
                this.cpu.edi = n3;
                if (bl) {
                    this.sub_o8_flags(n4 - n5, n4, n5);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void repne_cmpsw_a16(Segment segment) {
        block7: {
            int n = 0xFFFF & this.cpu.ecx;
            int n2 = 0xFFFF & this.cpu.esi;
            int n3 = 0xFFFF & this.cpu.edi;
            boolean bl = n != 0;
            int n4 = 0;
            int n5 = 0;
            try {
                if (this.cpu.eflagsDirection) {
                    while (n != 0) {
                        n4 = 0xFFFF & segment.getWord(n2);
                        n5 = 0xFFFF & this.cpu.es.getWord(n3);
                        --n;
                        n2 -= 2;
                        n3 -= 2;
                        if (n4 != n5) continue;
                        break block7;
                    }
                    break block7;
                }
                while (n != 0) {
                    n4 = 0xFFFF & segment.getWord(n2);
                    n5 = 0xFFFF & this.cpu.es.getWord(n3);
                    --n;
                    n2 += 2;
                    n3 += 2;
                    if (n4 != n5) continue;
                    break;
                }
            }
            finally {
                this.executeCount += (this.cpu.ecx & 0xFFFF) - n;
                this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | n & 0xFFFF;
                this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n2 & 0xFFFF;
                this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n3 & 0xFFFF;
                if (bl) {
                    this.sub_o16_flags(n4 - n5, n4, n5);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void repne_cmpsw_a32(Segment segment) {
        block7: {
            int n = this.cpu.ecx;
            int n2 = this.cpu.esi;
            int n3 = this.cpu.edi;
            boolean bl = n != 0;
            int n4 = 0;
            int n5 = 0;
            try {
                if (this.cpu.eflagsDirection) {
                    while (n != 0) {
                        n4 = 0xFFFF & segment.getWord(n2);
                        n5 = 0xFFFF & this.cpu.es.getWord(n3);
                        --n;
                        n2 -= 2;
                        n3 -= 2;
                        if (n4 != n5) continue;
                        break block7;
                    }
                    break block7;
                }
                while (n != 0) {
                    n4 = 0xFFFF & segment.getWord(n2);
                    n5 = 0xFFFF & this.cpu.es.getWord(n3);
                    --n;
                    n2 += 2;
                    n3 += 2;
                    if (n4 != n5) continue;
                    break;
                }
            }
            finally {
                this.executeCount += this.cpu.ecx - n;
                this.cpu.ecx = n;
                this.cpu.esi = n2;
                this.cpu.edi = n3;
                if (bl) {
                    this.sub_o16_flags(n4 - n5, n4, n5);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void repne_cmpsd_a16(Segment segment) {
        block7: {
            int n = 0xFFFF & this.cpu.ecx;
            int n2 = 0xFFFF & this.cpu.esi;
            int n3 = 0xFFFF & this.cpu.edi;
            boolean bl = n != 0;
            int n4 = 0;
            int n5 = 0;
            try {
                if (this.cpu.eflagsDirection) {
                    while (n != 0) {
                        n4 = segment.getDoubleWord(n2);
                        n5 = this.cpu.es.getDoubleWord(n3);
                        --n;
                        n2 -= 4;
                        n3 -= 4;
                        if (n4 != n5) continue;
                        break block7;
                    }
                    break block7;
                }
                while (n != 0) {
                    n4 = segment.getDoubleWord(n2);
                    n5 = this.cpu.es.getDoubleWord(n3);
                    --n;
                    n2 += 4;
                    n3 += 4;
                    if (n4 != n5) continue;
                    break;
                }
            }
            finally {
                this.executeCount += (this.cpu.ecx & 0xFFFF) - n;
                this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | n & 0xFFFF;
                this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n2 & 0xFFFF;
                this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n3 & 0xFFFF;
                if (bl) {
                    this.sub_o32_flags((0xFFFFFFFFL & (long)n4) - (0xFFFFFFFFL & (long)n5), n4, n5);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void repne_cmpsd_a32(Segment segment) {
        block7: {
            int n = this.cpu.ecx;
            int n2 = this.cpu.esi;
            int n3 = this.cpu.edi;
            boolean bl = n != 0;
            int n4 = 0;
            int n5 = 0;
            try {
                if (this.cpu.eflagsDirection) {
                    while (n != 0) {
                        n4 = segment.getDoubleWord(n2);
                        n5 = this.cpu.es.getDoubleWord(n3);
                        --n;
                        n2 -= 4;
                        n3 -= 4;
                        if (n4 != n5) continue;
                        break block7;
                    }
                    break block7;
                }
                while (n != 0) {
                    n4 = this.cpu.es.getDoubleWord(n2);
                    n5 = segment.getDoubleWord(n3);
                    --n;
                    n2 += 4;
                    n3 += 4;
                    if (n4 != n5) continue;
                    break;
                }
            }
            finally {
                this.executeCount += this.cpu.ecx - n;
                this.cpu.ecx = n;
                this.cpu.esi = n2;
                this.cpu.edi = n3;
                if (bl) {
                    this.sub_o32_flags((0xFFFFFFFFL & (long)n4) - (0xFFFFFFFFL & (long)n5), n4, n5);
                }
            }
        }
    }

    private final void insb_a32(int n) {
        if (!this.checkIOPermissionsByte(n)) {
            System.err.println("Emulated: denied access to io port 0x" + Integer.toHexString(n) + " at cpl " + this.cpu.getCPL() + ".");
            throw ProcessorException.GENERAL_PROTECTION_0;
        }
        int n2 = this.cpu.edi;
        this.cpu.es.setByte(n2, (byte)this.cpu.ioports.ioPortReadByte(n));
        n2 = this.cpu.eflagsDirection ? --n2 : ++n2;
        this.cpu.edi = n2;
    }

    private final void insw_a32(int n) {
        if (!this.checkIOPermissionsShort(n)) {
            System.err.println("Emulated: denied access to io port 0x" + Integer.toHexString(n) + " at cpl " + this.cpu.getCPL() + ".");
            throw ProcessorException.GENERAL_PROTECTION_0;
        }
        int n2 = this.cpu.edi;
        this.cpu.es.setWord(n2, (short)this.cpu.ioports.ioPortReadWord(n));
        n2 = this.cpu.eflagsDirection ? (n2 -= 2) : (n2 += 2);
        this.cpu.edi = n2;
    }

    private final void insd_a32(int n) {
        if (!this.checkIOPermissionsInt(n)) {
            System.err.println("Emulated: denied access to io port 0x" + Integer.toHexString(n) + " at cpl " + this.cpu.getCPL() + ".");
            throw ProcessorException.GENERAL_PROTECTION_0;
        }
        int n2 = this.cpu.edi;
        this.cpu.es.setDoubleWord(n2, this.cpu.ioports.ioPortReadLong(n));
        n2 = this.cpu.eflagsDirection ? (n2 -= 4) : (n2 += 4);
        this.cpu.edi = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_insb_a32(int n) {
        if (!this.checkIOPermissionsByte(n)) {
            System.err.println("Emulated: denied access to io port 0x" + Integer.toHexString(n) + " at cpl " + this.cpu.getCPL() + ".");
            throw ProcessorException.GENERAL_PROTECTION_0;
        }
        int n2 = this.cpu.ecx;
        int n3 = this.cpu.edi;
        this.executeCount += n2;
        try {
            if (this.cpu.eflagsDirection) {
                while (n2 != 0) {
                    this.cpu.es.setByte(n3, (byte)this.cpu.ioports.ioPortReadByte(n));
                    --n2;
                    --n3;
                }
            } else {
                while (n2 != 0) {
                    this.cpu.es.setByte(n3, (byte)this.cpu.ioports.ioPortReadByte(n));
                    --n2;
                    ++n3;
                }
            }
        }
        finally {
            this.cpu.ecx = n2;
            this.cpu.edi = n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_insw_a32(int n) {
        if (!this.checkIOPermissionsShort(n)) {
            System.err.println("Emulated: denied access to io port 0x" + Integer.toHexString(n) + " at cpl " + this.cpu.getCPL() + ".");
            throw ProcessorException.GENERAL_PROTECTION_0;
        }
        int n2 = this.cpu.ecx;
        int n3 = this.cpu.edi;
        this.executeCount += n2;
        try {
            if (this.cpu.eflagsDirection) {
                while (n2 != 0) {
                    this.cpu.es.setWord(n3, (short)this.cpu.ioports.ioPortReadWord(n));
                    --n2;
                    n3 -= 2;
                }
            } else {
                while (n2 != 0) {
                    this.cpu.es.setWord(n3, (short)this.cpu.ioports.ioPortReadWord(n));
                    --n2;
                    n3 += 2;
                }
            }
        }
        finally {
            this.cpu.ecx = n2;
            this.cpu.edi = n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_insd_a32(int n) {
        if (!this.checkIOPermissionsShort(n)) {
            System.err.println("Emulated: denied access to io port 0x" + Integer.toHexString(n) + " at cpl " + this.cpu.getCPL() + ".");
            throw ProcessorException.GENERAL_PROTECTION_0;
        }
        int n2 = this.cpu.ecx;
        int n3 = this.cpu.edi;
        this.executeCount += n2;
        try {
            if (this.cpu.eflagsDirection) {
                while (n2 != 0) {
                    this.cpu.es.setDoubleWord(n3, this.cpu.ioports.ioPortReadLong(n));
                    --n2;
                    n3 -= 4;
                }
            } else {
                while (n2 != 0) {
                    this.cpu.es.setDoubleWord(n3, this.cpu.ioports.ioPortReadLong(n));
                    --n2;
                    n3 += 4;
                }
            }
        }
        finally {
            this.cpu.ecx = n2;
            this.cpu.edi = n3;
        }
    }

    private final void lodsb_a16(Segment segment) {
        int n = 0xFFFF & this.cpu.esi;
        this.cpu.eax = this.cpu.eax & 0xFFFFFF00 | 0xFF & segment.getByte(n);
        n = this.cpu.eflagsDirection ? --n : ++n;
        this.cpu.esi = this.cpu.esi & 0xFFFF0000 | 0xFFFF & n;
    }

    private final void lodsb_a32(Segment segment) {
        int n = this.cpu.esi;
        this.cpu.eax = this.cpu.eax & 0xFFFFFF00 | 0xFF & segment.getByte(n);
        n = this.cpu.eflagsDirection ? --n : ++n;
        this.cpu.esi = n;
    }

    private final void lodsw_a16(Segment segment) {
        int n = this.cpu.esi & 0xFFFF;
        this.cpu.eax = this.cpu.eax & 0xFFFF0000 | 0xFFFF & segment.getWord(n);
        n = this.cpu.eflagsDirection ? (n -= 2) : (n += 2);
        this.cpu.esi = this.cpu.esi & 0xFFFF0000 | 0xFFFF & n;
    }

    private final void lodsw_a32(Segment segment) {
        int n = this.cpu.esi;
        this.cpu.eax = this.cpu.eax & 0xFFFF0000 | 0xFFFF & segment.getWord(n);
        n = this.cpu.eflagsDirection ? (n -= 2) : (n += 2);
        this.cpu.esi = n;
    }

    private final void lodsd_a32(Segment segment) {
        int n = this.cpu.esi;
        this.cpu.eax = segment.getDoubleWord(n);
        n = this.cpu.eflagsDirection ? (n -= 4) : (n += 4);
        this.cpu.esi = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_lodsb_a32(Segment segment) {
        int n = this.cpu.ecx;
        int n2 = this.cpu.esi;
        int n3 = this.cpu.eax & 0xFF;
        this.executeCount += n;
        try {
            if (this.cpu.eflagsDirection) {
                while (n != 0) {
                    n3 = 0xFF & segment.getByte(n2);
                    --n;
                    --n2;
                }
            } else {
                while (n != 0) {
                    n3 = 0xFF & segment.getByte(n2);
                    --n;
                    ++n2;
                }
            }
        }
        finally {
            this.cpu.eax = this.cpu.eax & 0xFFFFFF00 | n3;
            this.cpu.ecx = n;
            this.cpu.esi = n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_lodsw_a32(Segment segment) {
        int n = this.cpu.ecx;
        int n2 = this.cpu.esi;
        int n3 = this.cpu.eax & 0xFFFF;
        this.executeCount += n;
        try {
            if (this.cpu.eflagsDirection) {
                while (n != 0) {
                    n3 = 0xFFFF & segment.getWord(n2);
                    --n;
                    n2 -= 2;
                }
            } else {
                while (n != 0) {
                    n3 = 0xFFFF & segment.getWord(n2);
                    --n;
                    n2 += 2;
                }
            }
        }
        finally {
            this.cpu.eax = this.cpu.eax & 0xFFFF0000 | n3;
            this.cpu.ecx = n;
            this.cpu.esi = n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_lodsd_a32(Segment segment) {
        int n = this.cpu.ecx;
        int n2 = this.cpu.esi;
        int n3 = this.cpu.eax;
        this.executeCount += n;
        try {
            if (this.cpu.eflagsDirection) {
                while (n != 0) {
                    n3 = segment.getDoubleWord(n2);
                    --n;
                    n2 -= 4;
                }
            } else {
                while (n != 0) {
                    n3 = segment.getDoubleWord(n2);
                    --n;
                    n2 += 4;
                }
            }
        }
        finally {
            this.cpu.eax = n3;
            this.cpu.ecx = n;
            this.cpu.esi = n2;
        }
    }

    private final void movsb_a16(Segment segment) {
        int n = this.cpu.edi & 0xFFFF;
        int n2 = this.cpu.esi & 0xFFFF;
        this.cpu.es.setByte(n, segment.getByte(n2));
        if (this.cpu.eflagsDirection) {
            --n2;
            --n;
        } else {
            ++n2;
            ++n;
        }
        this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n & 0xFFFF;
        this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n2 & 0xFFFF;
    }

    private final void movsw_a16(Segment segment) {
        int n = this.cpu.edi & 0xFFFF;
        int n2 = this.cpu.esi & 0xFFFF;
        this.cpu.es.setWord(n, segment.getWord(n2));
        if (this.cpu.eflagsDirection) {
            n2 -= 2;
            n -= 2;
        } else {
            n2 += 2;
            n += 2;
        }
        this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n & 0xFFFF;
        this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n2 & 0xFFFF;
    }

    private final void movsd_a16(Segment segment) {
        int n = this.cpu.edi & 0xFFFF;
        int n2 = this.cpu.esi & 0xFFFF;
        this.cpu.es.setDoubleWord(n, segment.getDoubleWord(n2));
        if (this.cpu.eflagsDirection) {
            n2 -= 4;
            n -= 4;
        } else {
            n2 += 4;
            n += 4;
        }
        this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n & 0xFFFF;
        this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n2 & 0xFFFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_movsb_a16(Segment segment) {
        int n = this.cpu.ecx & 0xFFFF;
        int n2 = this.cpu.edi & 0xFFFF;
        int n3 = this.cpu.esi & 0xFFFF;
        this.executeCount += n;
        try {
            if (this.cpu.eflagsDirection) {
                while (n != 0) {
                    this.cpu.es.setByte(n2 & 0xFFFF, segment.getByte(n3 & 0xFFFF));
                    --n;
                    --n3;
                    --n2;
                }
            } else {
                while (n != 0) {
                    this.cpu.es.setByte(n2 & 0xFFFF, segment.getByte(n3 & 0xFFFF));
                    --n;
                    ++n3;
                    ++n2;
                }
            }
        }
        finally {
            this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | n & 0xFFFF;
            this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n2 & 0xFFFF;
            this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n3 & 0xFFFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_movsw_a16(Segment segment) {
        int n = this.cpu.ecx & 0xFFFF;
        int n2 = this.cpu.edi & 0xFFFF;
        int n3 = this.cpu.esi & 0xFFFF;
        this.executeCount += n;
        try {
            if (this.cpu.eflagsDirection) {
                while (n != 0) {
                    this.cpu.es.setWord(n2 & 0xFFFF, segment.getWord(n3 & 0xFFFF));
                    --n;
                    n3 -= 2;
                    n2 -= 2;
                }
            } else {
                while (n != 0) {
                    this.cpu.es.setWord(n2 & 0xFFFF, segment.getWord(n3 & 0xFFFF));
                    --n;
                    n3 += 2;
                    n2 += 2;
                }
            }
        }
        finally {
            this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | n & 0xFFFF;
            this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n2 & 0xFFFF;
            this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n3 & 0xFFFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_movsd_a16(Segment segment) {
        int n = this.cpu.ecx & 0xFFFF;
        int n2 = this.cpu.edi & 0xFFFF;
        int n3 = this.cpu.esi & 0xFFFF;
        this.executeCount += n;
        try {
            if (this.cpu.eflagsDirection) {
                while (n != 0) {
                    this.cpu.es.setDoubleWord(n2 & 0xFFFF, segment.getDoubleWord(n3 & 0xFFFF));
                    --n;
                    n3 -= 4;
                    n2 -= 4;
                }
            } else {
                while (n != 0) {
                    this.cpu.es.setDoubleWord(n2 & 0xFFFF, segment.getDoubleWord(n3 & 0xFFFF));
                    --n;
                    n3 += 4;
                    n2 += 4;
                }
            }
        }
        finally {
            this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | n & 0xFFFF;
            this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n2 & 0xFFFF;
            this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n3 & 0xFFFF;
        }
    }

    private final void movsb_a32(Segment segment) {
        int n = this.cpu.edi;
        int n2 = this.cpu.esi;
        this.cpu.es.setByte(n, segment.getByte(n2));
        if (this.cpu.eflagsDirection) {
            --n2;
            --n;
        } else {
            ++n2;
            ++n;
        }
        this.cpu.edi = n;
        this.cpu.esi = n2;
    }

    private final void movsw_a32(Segment segment) {
        int n = this.cpu.edi;
        int n2 = this.cpu.esi;
        this.cpu.es.setWord(n, segment.getWord(n2));
        if (this.cpu.eflagsDirection) {
            n2 -= 2;
            n -= 2;
        } else {
            n2 += 2;
            n += 2;
        }
        this.cpu.edi = n;
        this.cpu.esi = n2;
    }

    private final void movsd_a32(Segment segment) {
        int n = this.cpu.edi;
        int n2 = this.cpu.esi;
        this.cpu.es.setDoubleWord(n, segment.getDoubleWord(n2));
        if (this.cpu.eflagsDirection) {
            n2 -= 4;
            n -= 4;
        } else {
            n2 += 4;
            n += 4;
        }
        this.cpu.edi = n;
        this.cpu.esi = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_movsb_a32(Segment segment) {
        int n = this.cpu.ecx;
        int n2 = this.cpu.edi;
        int n3 = this.cpu.esi;
        this.executeCount += n;
        try {
            if (this.cpu.eflagsDirection) {
                while (n != 0) {
                    this.cpu.es.setByte(n2, segment.getByte(n3));
                    --n;
                    --n3;
                    --n2;
                }
            } else {
                while (n != 0) {
                    this.cpu.es.setByte(n2, segment.getByte(n3));
                    --n;
                    ++n3;
                    ++n2;
                }
            }
        }
        finally {
            this.cpu.ecx = n;
            this.cpu.edi = n2;
            this.cpu.esi = n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_movsw_a32(Segment segment) {
        int n = this.cpu.ecx;
        int n2 = this.cpu.edi;
        int n3 = this.cpu.esi;
        this.executeCount += n;
        try {
            if (this.cpu.eflagsDirection) {
                while (n != 0) {
                    this.cpu.es.setWord(n2, segment.getWord(n3));
                    --n;
                    n3 -= 2;
                    n2 -= 2;
                }
            } else {
                while (n != 0) {
                    this.cpu.es.setWord(n2, segment.getWord(n3));
                    --n;
                    n3 += 2;
                    n2 += 2;
                }
            }
        }
        finally {
            this.cpu.ecx = n;
            this.cpu.edi = n2;
            this.cpu.esi = n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_movsd_a32(Segment segment) {
        int n = this.cpu.ecx;
        int n2 = this.cpu.edi;
        int n3 = this.cpu.esi;
        this.executeCount += n;
        try {
            if (this.cpu.eflagsDirection) {
                while (n != 0) {
                    this.cpu.es.setDoubleWord(n2, segment.getDoubleWord(n3));
                    --n;
                    n3 -= 4;
                    n2 -= 4;
                }
            } else {
                while (n != 0) {
                    this.cpu.es.setDoubleWord(n2, segment.getDoubleWord(n3));
                    --n;
                    n3 += 4;
                    n2 += 4;
                }
            }
        }
        finally {
            this.cpu.ecx = n;
            this.cpu.edi = n2;
            this.cpu.esi = n3;
        }
    }

    private final void outsb_a16(int n, Segment segment) {
        if (!this.checkIOPermissionsByte(n)) {
            System.err.println("Emulated: denied access to io port 0x" + Integer.toHexString(n) + " at cpl " + this.cpu.getCPL() + ".");
            throw ProcessorException.GENERAL_PROTECTION_0;
        }
        int n2 = this.cpu.esi & 0xFFFF;
        this.cpu.ioports.ioPortWriteByte(n, 0xFF & segment.getByte(n2));
        n2 = this.cpu.eflagsDirection ? --n2 : ++n2;
        this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n2 & 0xFFFF;
    }

    private final void outsw_a16(int n, Segment segment) {
        if (!this.checkIOPermissionsShort(n)) {
            System.err.println("Emulated: denied access to io port 0x" + Integer.toHexString(n) + " at cpl " + this.cpu.getCPL() + ".");
            throw ProcessorException.GENERAL_PROTECTION_0;
        }
        int n2 = this.cpu.esi & 0xFFFF;
        this.cpu.ioports.ioPortWriteWord(n, 0xFFFF & segment.getWord(n2));
        n2 = this.cpu.eflagsDirection ? (n2 -= 2) : (n2 += 2);
        this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n2 & 0xFFFF;
    }

    private final void outsd_a16(int n, Segment segment) {
        if (!this.checkIOPermissionsInt(n)) {
            System.err.println("Emulated: denied access to io port 0x" + Integer.toHexString(n) + " at cpl " + this.cpu.getCPL() + ".");
            throw ProcessorException.GENERAL_PROTECTION_0;
        }
        int n2 = this.cpu.esi & 0xFFFF;
        this.cpu.ioports.ioPortWriteLong(n, segment.getDoubleWord(n2));
        n2 = this.cpu.eflagsDirection ? (n2 -= 4) : (n2 += 4);
        this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n2 & 0xFFFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_outsb_a16(int n, Segment segment) {
        if (!this.checkIOPermissionsByte(n)) {
            System.err.println("Emulated: denied access to io port 0x" + Integer.toHexString(n) + " at cpl " + this.cpu.getCPL() + ".");
            throw ProcessorException.GENERAL_PROTECTION_0;
        }
        int n2 = this.cpu.ecx & 0xFFFF;
        int n3 = this.cpu.esi & 0xFFFF;
        this.executeCount += n2;
        try {
            if (this.cpu.eflagsDirection) {
                while (n2 != 0) {
                    this.cpu.ioports.ioPortWriteByte(n, 0xFFFF & segment.getByte(n3 & 0xFFFF));
                    --n2;
                    --n3;
                }
            } else {
                while (n2 != 0) {
                    this.cpu.ioports.ioPortWriteByte(n, 0xFFFF & segment.getByte(n3 & 0xFFFF));
                    --n2;
                    ++n3;
                }
            }
        }
        finally {
            this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | n2 & 0xFFFF;
            this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n3 & 0xFFFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_outsw_a16(int n, Segment segment) {
        if (!this.checkIOPermissionsShort(n)) {
            System.err.println("Emulated: denied access to io port 0x" + Integer.toHexString(n) + " at cpl " + this.cpu.getCPL() + ".");
            throw ProcessorException.GENERAL_PROTECTION_0;
        }
        int n2 = this.cpu.ecx & 0xFFFF;
        int n3 = this.cpu.esi & 0xFFFF;
        this.executeCount += n2;
        try {
            if (this.cpu.eflagsDirection) {
                while (n2 != 0) {
                    this.cpu.ioports.ioPortWriteWord(n, 0xFFFF & segment.getWord(n3 & 0xFFFF));
                    --n2;
                    n3 -= 2;
                }
            } else {
                while (n2 != 0) {
                    this.cpu.ioports.ioPortWriteWord(n, 0xFFFF & segment.getWord(n3 & 0xFFFF));
                    --n2;
                    n3 += 2;
                }
            }
        }
        finally {
            this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | n2 & 0xFFFF;
            this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n3 & 0xFFFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_outsd_a16(int n, Segment segment) {
        if (!this.checkIOPermissionsInt(n)) {
            System.err.println("Emulated: denied access to io port 0x" + Integer.toHexString(n) + " at cpl " + this.cpu.getCPL() + ".");
            throw ProcessorException.GENERAL_PROTECTION_0;
        }
        int n2 = this.cpu.ecx & 0xFFFF;
        int n3 = this.cpu.esi & 0xFFFF;
        this.executeCount += n2;
        try {
            if (this.cpu.eflagsDirection) {
                while (n2 != 0) {
                    this.cpu.ioports.ioPortWriteLong(n, segment.getDoubleWord(n3 & 0xFFFF));
                    --n2;
                    n3 -= 4;
                }
            } else {
                while (n2 != 0) {
                    this.cpu.ioports.ioPortWriteLong(n, segment.getDoubleWord(n3 & 0xFFFF));
                    --n2;
                    n3 += 4;
                }
            }
        }
        finally {
            this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | n2 & 0xFFFF;
            this.cpu.esi = this.cpu.esi & 0xFFFF0000 | n3 & 0xFFFF;
        }
    }

    private final void outsb_a32(int n, Segment segment) {
        if (!this.checkIOPermissionsByte(n)) {
            System.err.println("Emulated: denied access to io port 0x" + Integer.toHexString(n) + " at cpl " + this.cpu.getCPL() + ".");
            throw ProcessorException.GENERAL_PROTECTION_0;
        }
        int n2 = this.cpu.esi;
        this.cpu.ioports.ioPortWriteByte(n, 0xFF & segment.getByte(n2));
        n2 = this.cpu.eflagsDirection ? --n2 : ++n2;
        this.cpu.esi = n2;
    }

    private final void outsw_a32(int n, Segment segment) {
        if (!this.checkIOPermissionsShort(n)) {
            System.err.println("Emulated: denied access to io port 0x" + Integer.toHexString(n) + " at cpl " + this.cpu.getCPL() + ".");
            throw ProcessorException.GENERAL_PROTECTION_0;
        }
        int n2 = this.cpu.esi;
        this.cpu.ioports.ioPortWriteWord(n, 0xFFFF & segment.getWord(n2));
        n2 = this.cpu.eflagsDirection ? (n2 -= 2) : (n2 += 2);
        this.cpu.esi = n2;
    }

    private final void outsd_a32(int n, Segment segment) {
        if (!this.checkIOPermissionsInt(n)) {
            System.err.println("Emulated: denied access to io port 0x" + Integer.toHexString(n) + " at cpl " + this.cpu.getCPL() + ".");
            throw ProcessorException.GENERAL_PROTECTION_0;
        }
        int n2 = this.cpu.esi;
        this.cpu.ioports.ioPortWriteLong(n, segment.getDoubleWord(n2));
        n2 = this.cpu.eflagsDirection ? (n2 -= 4) : (n2 += 4);
        this.cpu.esi = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_outsb_a32(int n, Segment segment) {
        if (!this.checkIOPermissionsByte(n)) {
            System.err.println("Emulated: denied access to io port 0x" + Integer.toHexString(n) + " at cpl " + this.cpu.getCPL() + ".");
            throw ProcessorException.GENERAL_PROTECTION_0;
        }
        int n2 = this.cpu.ecx;
        int n3 = this.cpu.esi;
        this.executeCount += n2;
        try {
            if (this.cpu.eflagsDirection) {
                while (n2 != 0) {
                    this.cpu.ioports.ioPortWriteByte(n, 0xFFFF & segment.getByte(n3));
                    --n2;
                    --n3;
                }
            } else {
                while (n2 != 0) {
                    this.cpu.ioports.ioPortWriteByte(n, 0xFFFF & segment.getByte(n3));
                    --n2;
                    ++n3;
                }
            }
        }
        finally {
            this.cpu.ecx = n2;
            this.cpu.esi = n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_outsw_a32(int n, Segment segment) {
        if (!this.checkIOPermissionsShort(n)) {
            System.err.println("Emulated: denied access to io port 0x" + Integer.toHexString(n) + " at cpl " + this.cpu.getCPL() + ".");
            throw ProcessorException.GENERAL_PROTECTION_0;
        }
        int n2 = this.cpu.ecx;
        int n3 = this.cpu.esi;
        this.executeCount += n2;
        try {
            if (this.cpu.eflagsDirection) {
                while (n2 != 0) {
                    this.cpu.ioports.ioPortWriteWord(n, 0xFFFF & segment.getWord(n3));
                    --n2;
                    n3 -= 2;
                }
            } else {
                while (n2 != 0) {
                    this.cpu.ioports.ioPortWriteWord(n, 0xFFFF & segment.getWord(n3));
                    --n2;
                    n3 += 2;
                }
            }
        }
        finally {
            this.cpu.ecx = n2;
            this.cpu.esi = n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_outsd_a32(int n, Segment segment) {
        if (!this.checkIOPermissionsInt(n)) {
            System.err.println("Emulated: denied access to io port 0x" + Integer.toHexString(n) + " at cpl " + this.cpu.getCPL() + ".");
            throw ProcessorException.GENERAL_PROTECTION_0;
        }
        int n2 = this.cpu.ecx;
        int n3 = this.cpu.esi;
        this.executeCount += n2;
        try {
            if (this.cpu.eflagsDirection) {
                while (n2 != 0) {
                    this.cpu.ioports.ioPortWriteLong(n, segment.getDoubleWord(n3));
                    --n2;
                    n3 -= 4;
                }
            } else {
                while (n2 != 0) {
                    this.cpu.ioports.ioPortWriteLong(n, segment.getDoubleWord(n3));
                    --n2;
                    n3 += 4;
                }
            }
        }
        finally {
            this.cpu.ecx = n2;
            this.cpu.esi = n3;
        }
    }

    private final void scasb_a16(int n) {
        int n2 = 0xFFFF & this.cpu.edi;
        int n3 = 0xFF & this.cpu.es.getByte(n2);
        n2 = this.cpu.eflagsDirection ? --n2 : ++n2;
        this.cpu.edi = this.cpu.edi & 0xFFFF0000 | 0xFFFF & n2;
        this.sub_o8_flags(n - n3, n, n3);
    }

    private final void scasb_a32(int n) {
        int n2 = this.cpu.edi;
        int n3 = 0xFF & this.cpu.es.getByte(n2);
        n2 = this.cpu.eflagsDirection ? --n2 : ++n2;
        this.cpu.edi = n2;
        this.sub_o8_flags(n - n3, n, n3);
    }

    private final void scasw_a32(int n) {
        int n2 = this.cpu.edi;
        int n3 = 0xFFFF & this.cpu.es.getWord(n2);
        n2 = this.cpu.eflagsDirection ? (n2 -= 2) : (n2 += 2);
        this.cpu.edi = n2;
        this.sub_o16_flags(n - n3, n, n3);
    }

    private final void scasd_a32(int n) {
        int n2 = this.cpu.edi;
        int n3 = this.cpu.es.getDoubleWord(n2);
        n2 = this.cpu.eflagsDirection ? (n2 -= 4) : (n2 += 4);
        this.cpu.edi = n2;
        this.sub_o32_flags((0xFFFFFFFFL & (long)n) - (0xFFFFFFFFL & (long)n3), n, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void repe_scasb_a16(int n) {
        block7: {
            int n2 = 0xFFFF & this.cpu.ecx;
            int n3 = 0xFFFF & this.cpu.edi;
            boolean bl = n2 != 0;
            int n4 = 0;
            try {
                if (this.cpu.eflagsDirection) {
                    while (n2 != 0) {
                        n4 = 0xFF & this.cpu.es.getByte(n3);
                        --n2;
                        --n3;
                        if (n == n4) continue;
                        break block7;
                    }
                    break block7;
                }
                while (n2 != 0) {
                    n4 = 0xFF & this.cpu.es.getByte(n3);
                    --n2;
                    ++n3;
                    if (n == n4) continue;
                    break;
                }
            }
            finally {
                this.executeCount += (0xFFFF & this.cpu.ecx) - n2;
                this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | 0xFFFF & n2;
                this.cpu.edi = this.cpu.edi & 0xFFFF0000 | 0xFFFF & n3;
                if (bl) {
                    this.sub_o8_flags(n - n4, n, n4);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void repe_scasb_a32(int n) {
        block7: {
            int n2 = this.cpu.ecx;
            int n3 = this.cpu.edi;
            boolean bl = n2 != 0;
            int n4 = 0;
            try {
                if (this.cpu.eflagsDirection) {
                    while (n2 != 0) {
                        n4 = 0xFF & this.cpu.es.getByte(n3);
                        --n2;
                        --n3;
                        if (n == n4) continue;
                        break block7;
                    }
                    break block7;
                }
                while (n2 != 0) {
                    n4 = 0xFF & this.cpu.es.getByte(n3);
                    --n2;
                    ++n3;
                    if (n == n4) continue;
                    break;
                }
            }
            finally {
                this.executeCount += this.cpu.ecx - n2;
                this.cpu.ecx = n2;
                this.cpu.edi = n3;
                if (bl) {
                    this.sub_o8_flags(n - n4, n, n4);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void repe_scasw_a16(int n) {
        block7: {
            int n2 = 0xFFFF & this.cpu.ecx;
            int n3 = 0xFFFF & this.cpu.edi;
            boolean bl = n2 != 0;
            int n4 = 0;
            try {
                if (this.cpu.eflagsDirection) {
                    while (n2 != 0) {
                        n4 = 0xFFFF & this.cpu.es.getWord(n3);
                        --n2;
                        n3 -= 2;
                        if (n == n4) continue;
                        break block7;
                    }
                    break block7;
                }
                while (n2 != 0) {
                    n4 = 0xFFFF & this.cpu.es.getWord(n3);
                    --n2;
                    n3 += 2;
                    if (n == n4) continue;
                    break;
                }
            }
            finally {
                this.executeCount += (0xFFFF & this.cpu.ecx) - n2;
                this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | 0xFFFF & n2;
                this.cpu.edi = this.cpu.edi & 0xFFFF0000 | 0xFFFF & n3;
                if (bl) {
                    this.sub_o16_flags(n - n4, n, n4);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void repe_scasw_a32(int n) {
        block7: {
            int n2 = this.cpu.ecx;
            int n3 = this.cpu.edi;
            boolean bl = n2 != 0;
            int n4 = 0;
            try {
                if (this.cpu.eflagsDirection) {
                    while (n2 != 0) {
                        n4 = 0xFFFF & this.cpu.es.getWord(n3);
                        --n2;
                        n3 -= 2;
                        if (n == n4) continue;
                        break block7;
                    }
                    break block7;
                }
                while (n2 != 0) {
                    n4 = 0xFFFF & this.cpu.es.getWord(n3);
                    --n2;
                    n3 += 2;
                    if (n == n4) continue;
                    break;
                }
            }
            finally {
                this.executeCount += this.cpu.ecx - n2;
                this.cpu.ecx = n2;
                this.cpu.edi = n3;
                if (bl) {
                    this.sub_o16_flags(n - n4, n, n4);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void repe_scasd_a16(int n) {
        block7: {
            int n2 = 0xFFFF & this.cpu.ecx;
            int n3 = 0xFFFF & this.cpu.edi;
            boolean bl = n2 != 0;
            int n4 = 0;
            try {
                if (this.cpu.eflagsDirection) {
                    while (n2 != 0) {
                        n4 = this.cpu.es.getDoubleWord(n3);
                        --n2;
                        n3 -= 4;
                        if (n == n4) continue;
                        break block7;
                    }
                    break block7;
                }
                while (n2 != 0) {
                    n4 = this.cpu.es.getDoubleWord(n3);
                    --n2;
                    n3 += 4;
                    if (n == n4) continue;
                    break;
                }
            }
            finally {
                this.executeCount += (0xFFFF & this.cpu.ecx) - n2;
                this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | 0xFFFF & n2;
                this.cpu.edi = this.cpu.edi & 0xFFFF0000 | 0xFFFF & n3;
                if (bl) {
                    this.sub_o32_flags((0xFFFFFFFFL & (long)n) - (0xFFFFFFFFL & (long)n4), n, n4);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void repe_scasd_a32(int n) {
        block7: {
            int n2 = this.cpu.ecx;
            int n3 = this.cpu.edi;
            boolean bl = n2 != 0;
            int n4 = 0;
            try {
                if (this.cpu.eflagsDirection) {
                    while (n2 != 0) {
                        n4 = this.cpu.es.getDoubleWord(n3);
                        --n2;
                        n3 -= 4;
                        if (n == n4) continue;
                        break block7;
                    }
                    break block7;
                }
                while (n2 != 0) {
                    n4 = this.cpu.es.getDoubleWord(n3);
                    --n2;
                    n3 += 4;
                    if (n == n4) continue;
                    break;
                }
            }
            finally {
                this.executeCount += this.cpu.ecx - n2;
                this.cpu.ecx = n2;
                this.cpu.edi = n3;
                if (bl) {
                    this.sub_o32_flags((0xFFFFFFFFL & (long)n) - (0xFFFFFFFFL & (long)n4), n, n4);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void repne_scasb_a16(int n) {
        block7: {
            int n2 = 0xFFFF & this.cpu.ecx;
            int n3 = 0xFFFF & this.cpu.edi;
            boolean bl = n2 != 0;
            int n4 = 0;
            try {
                if (this.cpu.eflagsDirection) {
                    while (n2 != 0) {
                        n4 = 0xFF & this.cpu.es.getByte(n3);
                        --n2;
                        --n3;
                        if (n != n4) continue;
                        break block7;
                    }
                    break block7;
                }
                while (n2 != 0) {
                    n4 = 0xFF & this.cpu.es.getByte(n3);
                    --n2;
                    ++n3;
                    if (n != n4) continue;
                    break;
                }
            }
            finally {
                this.executeCount += (this.cpu.ecx & 0xFFFF) - n2;
                this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | 0xFFFF & n2;
                this.cpu.edi = this.cpu.edi & 0xFFFF0000 | 0xFFFF & n3;
                if (bl) {
                    this.sub_o8_flags(n - n4, n, n4);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void repne_scasb_a32(int n) {
        block7: {
            int n2 = this.cpu.ecx;
            int n3 = this.cpu.edi;
            boolean bl = n2 != 0;
            int n4 = 0;
            try {
                if (this.cpu.eflagsDirection) {
                    while (n2 != 0) {
                        n4 = 0xFF & this.cpu.es.getByte(n3);
                        --n2;
                        --n3;
                        if (n != n4) continue;
                        break block7;
                    }
                    break block7;
                }
                while (n2 != 0) {
                    n4 = 0xFF & this.cpu.es.getByte(n3);
                    --n2;
                    ++n3;
                    if (n != n4) continue;
                    break;
                }
            }
            finally {
                this.executeCount += this.cpu.ecx - n2;
                this.cpu.ecx = n2;
                this.cpu.edi = n3;
                if (bl) {
                    this.sub_o8_flags(n - n4, n, n4);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void repne_scasw_a16(int n) {
        block7: {
            int n2 = 0xFFFF & this.cpu.ecx;
            int n3 = 0xFFFF & this.cpu.edi;
            boolean bl = n2 != 0;
            int n4 = 0;
            try {
                if (this.cpu.eflagsDirection) {
                    while (n2 != 0) {
                        n4 = 0xFFFF & this.cpu.es.getWord(n3);
                        --n2;
                        n3 -= 2;
                        if (n != n4) continue;
                        break block7;
                    }
                    break block7;
                }
                while (n2 != 0) {
                    n4 = 0xFFFF & this.cpu.es.getWord(n3);
                    --n2;
                    n3 += 2;
                    if (n != n4) continue;
                    break;
                }
            }
            finally {
                this.executeCount += (0xFFFF & this.cpu.ecx) - n2;
                this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | 0xFFFF & n2;
                this.cpu.edi = this.cpu.edi & 0xFFFF0000 | 0xFFFF & n3;
                if (bl) {
                    this.sub_o16_flags(n - n4, n, n4);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void repne_scasw_a32(int n) {
        block7: {
            int n2 = this.cpu.ecx;
            int n3 = this.cpu.edi;
            boolean bl = n2 != 0;
            int n4 = 0;
            try {
                if (this.cpu.eflagsDirection) {
                    while (n2 != 0) {
                        n4 = 0xFFFF & this.cpu.es.getWord(n3);
                        --n2;
                        n3 -= 2;
                        if (n != n4) continue;
                        break block7;
                    }
                    break block7;
                }
                while (n2 != 0) {
                    n4 = 0xFFFF & this.cpu.es.getWord(n3);
                    --n2;
                    n3 += 2;
                    if (n != n4) continue;
                    break;
                }
            }
            finally {
                this.executeCount += this.cpu.ecx - n2;
                this.cpu.ecx = n2;
                this.cpu.edi = n3;
                if (bl) {
                    this.sub_o16_flags(n - n4, n, n4);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void repne_scasd_a16(int n) {
        block7: {
            int n2 = 0xFFFF & this.cpu.ecx;
            int n3 = 0xFFFF & this.cpu.edi;
            boolean bl = n2 != 0;
            int n4 = 0;
            try {
                if (this.cpu.eflagsDirection) {
                    while (n2 != 0) {
                        n4 = this.cpu.es.getDoubleWord(n3);
                        --n2;
                        n3 -= 4;
                        if (n != n4) continue;
                        break block7;
                    }
                    break block7;
                }
                while (n2 != 0) {
                    n4 = this.cpu.es.getDoubleWord(n3);
                    --n2;
                    n3 += 4;
                    if (n != n4) continue;
                    break;
                }
            }
            finally {
                this.executeCount += (0xFFFF & this.cpu.ecx) - n2;
                this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | 0xFFFF & n2;
                this.cpu.edi = this.cpu.edi & 0xFFFF0000 | 0xFFFF & n3;
                if (bl) {
                    this.sub_o32_flags((0xFFFFFFFFL & (long)n) - (0xFFFFFFFFL & (long)n4), n, n4);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void repne_scasd_a32(int n) {
        block7: {
            int n2 = this.cpu.ecx;
            int n3 = this.cpu.edi;
            boolean bl = n2 != 0;
            int n4 = 0;
            try {
                if (this.cpu.eflagsDirection) {
                    while (n2 != 0) {
                        n4 = this.cpu.es.getDoubleWord(n3);
                        --n2;
                        n3 -= 4;
                        if (n != n4) continue;
                        break block7;
                    }
                    break block7;
                }
                while (n2 != 0) {
                    n4 = this.cpu.es.getDoubleWord(n3);
                    --n2;
                    n3 += 4;
                    if (n != n4) continue;
                    break;
                }
            }
            finally {
                this.executeCount += this.cpu.ecx - n2;
                this.cpu.ecx = n2;
                this.cpu.edi = n3;
                if (bl) {
                    this.sub_o32_flags((0xFFFFFFFFL & (long)n) - (0xFFFFFFFFL & (long)n4), n, n4);
                }
            }
        }
    }

    private final void stosb_a16(int n) {
        int n2 = 0xFFFF & this.cpu.edi;
        this.cpu.es.setByte(n2, (byte)n);
        n2 = this.cpu.eflagsDirection ? --n2 : ++n2;
        this.cpu.edi = this.cpu.edi & 0xFFFF0000 | 0xFFFF & n2;
    }

    private final void stosb_a32(int n) {
        int n2 = this.cpu.edi;
        this.cpu.es.setByte(n2, (byte)n);
        n2 = this.cpu.eflagsDirection ? --n2 : ++n2;
        this.cpu.edi = n2;
    }

    private final void stosw_a16(int n) {
        int n2 = 0xFFFF & this.cpu.edi;
        this.cpu.es.setWord(n2, (short)n);
        n2 = this.cpu.eflagsDirection ? (n2 -= 2) : (n2 += 2);
        this.cpu.edi = this.cpu.edi & 0xFFFF0000 | 0xFFFF & n2;
    }

    private final void stosw_a32(int n) {
        int n2 = this.cpu.edi;
        this.cpu.es.setWord(n2, (short)n);
        n2 = this.cpu.eflagsDirection ? (n2 -= 2) : (n2 += 2);
        this.cpu.edi = n2;
    }

    private final void stosd_a16(int n) {
        int n2 = 0xFFFF & this.cpu.edi;
        this.cpu.es.setDoubleWord(n2, n);
        n2 = this.cpu.eflagsDirection ? (n2 -= 4) : (n2 += 4);
        this.cpu.edi = this.cpu.edi & 0xFFFF0000 | 0xFFFF & n2;
    }

    private final void stosd_a32(int n) {
        int n2 = this.cpu.edi;
        this.cpu.es.setDoubleWord(n2, n);
        n2 = this.cpu.eflagsDirection ? (n2 -= 4) : (n2 += 4);
        this.cpu.edi = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_stosb_a16(int n) {
        int n2;
        int n3 = 0xFFFF & this.cpu.edi;
        this.executeCount += n2;
        try {
            if (this.cpu.eflagsDirection) {
                for (n2 = 0xFFFF & this.cpu.ecx; n2 != 0; --n2) {
                    this.cpu.es.setByte(n3, (byte)n);
                    n3 = n3 - 1 & 0xFFFF;
                }
            } else {
                while (n2 != 0) {
                    this.cpu.es.setByte(n3, (byte)n);
                    --n2;
                    n3 = n3 + 1 & 0xFFFF;
                }
            }
        }
        finally {
            this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | n2;
            this.cpu.edi = this.cpu.edi & 0xFFFF0000 | n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_stosb_a32(int n) {
        int n2 = this.cpu.ecx;
        int n3 = this.cpu.edi;
        this.executeCount += n2;
        try {
            if (this.cpu.eflagsDirection) {
                while (n2 != 0) {
                    this.cpu.es.setByte(n3, (byte)n);
                    --n2;
                    --n3;
                }
            } else {
                while (n2 != 0) {
                    this.cpu.es.setByte(n3, (byte)n);
                    --n2;
                    ++n3;
                }
            }
        }
        finally {
            this.cpu.ecx = n2;
            this.cpu.edi = n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_stosw_a16(int n) {
        int n2;
        int n3 = 0xFFFF & this.cpu.edi;
        this.executeCount += n2;
        try {
            if (this.cpu.eflagsDirection) {
                for (n2 = 0xFFFF & this.cpu.ecx; n2 != 0; --n2) {
                    this.cpu.es.setWord(n3, (short)n);
                    n3 = n3 - 2 & 0xFFFF;
                }
            } else {
                while (n2 != 0) {
                    this.cpu.es.setWord(n3, (short)n);
                    --n2;
                    n3 = n3 + 2 & 0xFFFF;
                }
            }
        }
        finally {
            this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | 0xFFFF & n2;
            this.cpu.edi = this.cpu.edi & 0xFFFF0000 | 0xFFFF & n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_stosw_a32(int n) {
        int n2 = this.cpu.ecx;
        int n3 = this.cpu.edi;
        this.executeCount += n2;
        try {
            if (this.cpu.eflagsDirection) {
                while (n2 != 0) {
                    this.cpu.es.setWord(n3, (short)n);
                    --n2;
                    n3 -= 2;
                }
            } else {
                while (n2 != 0) {
                    this.cpu.es.setWord(n3, (short)n);
                    --n2;
                    n3 += 2;
                }
            }
        }
        finally {
            this.cpu.ecx = n2;
            this.cpu.edi = n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_stosd_a16(int n) {
        int n2;
        int n3 = 0xFFFF & this.cpu.edi;
        this.executeCount += n2;
        try {
            if (this.cpu.eflagsDirection) {
                for (n2 = 0xFFFF & this.cpu.ecx; n2 != 0; --n2) {
                    this.cpu.es.setDoubleWord(n3, n);
                    n3 = n3 - 4 & 0xFFFF;
                }
            } else {
                while (n2 != 0) {
                    this.cpu.es.setDoubleWord(n3, n);
                    --n2;
                    n3 = n3 + 4 & 0xFFFF;
                }
            }
        }
        finally {
            this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | 0xFFFF & n2;
            this.cpu.edi = this.cpu.edi & 0xFFFF0000 | 0xFFFF & n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rep_stosd_a32(int n) {
        int n2 = this.cpu.ecx;
        int n3 = this.cpu.edi;
        this.executeCount += n2;
        try {
            if (this.cpu.eflagsDirection) {
                while (n2 != 0) {
                    this.cpu.es.setDoubleWord(n3, n);
                    --n2;
                    n3 -= 4;
                }
            } else {
                while (n2 != 0) {
                    this.cpu.es.setDoubleWord(n3, n);
                    --n2;
                    n3 += 4;
                }
            }
        }
        finally {
            this.cpu.ecx = n2;
            this.cpu.edi = n3;
        }
    }

    private final void mul_o8(int n) {
        int n2 = this.cpu.eax & 0xFF;
        int n3 = n2 * n;
        this.cpu.eax &= 0xFFFF0000;
        this.cpu.eax |= n3 & 0xFFFF;
        this.cpu.setOverflowFlag(n3, 6);
        this.cpu.setCarryFlag(n3, 6);
    }

    private final void mul_o16(int n) {
        int n2 = this.cpu.eax & 0xFFFF;
        int n3 = n2 * n;
        this.cpu.eax = this.cpu.eax & 0xFFFF0000 | 0xFFFF & n3;
        this.cpu.edx = this.cpu.edx & 0xFFFF0000 | (n3 >>>= 16);
        this.cpu.setOverflowFlag(n3, 1);
        this.cpu.setCarryFlag(n3, 1);
    }

    private final void mul_o32(int n) {
        long l = (long)this.cpu.eax & 0xFFFFFFFFL;
        long l2 = 0xFFFFFFFFL & (long)n;
        long l3 = l * l2;
        this.cpu.eax = (int)l3;
        this.cpu.edx = (int)(l3 >>>= 32);
        this.cpu.setOverflowFlag(this.cpu.edx, 1);
        this.cpu.setCarryFlag(this.cpu.edx, 1);
    }

    private final void imula_o8(byte by) {
        byte by2 = (byte)this.cpu.eax;
        int n = by2 * by;
        this.cpu.eax = this.cpu.eax & 0xFFFF0000 | n & 0xFFFF;
        this.cpu.setOverflowFlag(n, 2);
        this.cpu.setCarryFlag(n, 2);
    }

    private final void imula_o16(short s) {
        short s2 = (short)this.cpu.eax;
        int n = s2 * s;
        this.cpu.eax = this.cpu.eax & 0xFFFF0000 | n & 0xFFFF;
        this.cpu.edx = this.cpu.edx & 0xFFFF0000 | n >>> 16;
        this.cpu.setOverflowFlag(n, 3);
        this.cpu.setCarryFlag(n, 3);
    }

    private final void imula_o32(int n) {
        long l = this.cpu.eax;
        long l2 = n;
        long l3 = l * l2;
        this.cpu.eax = (int)l3;
        this.cpu.edx = (int)(l3 >>> 32);
        this.cpu.setOverflowFlag(l3, 4);
        this.cpu.setCarryFlag(l3, 4);
    }

    private final int imul_o16(short s, short s2) {
        int n = s * s2;
        this.cpu.setOverflowFlag(n, 3);
        this.cpu.setCarryFlag(n, 3);
        return n;
    }

    private final int imul_o32(int n, int n2) {
        long l = n;
        long l2 = n2;
        long l3 = l * l2;
        this.cpu.setOverflowFlag(l3, 4);
        this.cpu.setCarryFlag(l3, 4);
        return (int)l3;
    }

    private final void div_o8(int n) {
        if (n == 0) {
            throw ProcessorException.DIVIDE_ERROR;
        }
        int n2 = this.cpu.eax & 0xFFFF;
        int n3 = n2 / n;
        if (n3 > 255) {
            throw ProcessorException.DIVIDE_ERROR;
        }
        int n4 = n2 % n << 8;
        this.cpu.eax = this.cpu.eax & 0xFFFF0000 | 0xFF & n3 | 0xFF00 & n4;
    }

    private final void div_o16(int n) {
        if (n == 0) {
            throw ProcessorException.DIVIDE_ERROR;
        }
        long l = (long)this.cpu.edx & 0xFFFFL;
        l <<= 16;
        long l2 = (l |= (long)this.cpu.eax & 0xFFFFL) / (long)n;
        if (l2 > 65535L) {
            throw ProcessorException.DIVIDE_ERROR;
        }
        long l3 = l % (long)n;
        this.cpu.eax = this.cpu.eax & 0xFFFF0000 | (int)(l2 & 0xFFFFL);
        this.cpu.edx = this.cpu.edx & 0xFFFF0000 | (int)(l3 & 0xFFFFL);
    }

    private final void div_o32(int n) {
        long l = 0xFFFFFFFFL & (long)n;
        if (l == 0L) {
            throw ProcessorException.DIVIDE_ERROR;
        }
        long l2 = this.cpu.edx;
        l2 <<= 32;
        long l3 = (l2 |= 0xFFFFFFFFL & (long)this.cpu.eax) & 1L;
        long l4 = l2 >>> 1;
        long l5 = l4 / l;
        long l6 = l4 % l;
        long l7 = l5 << 1;
        long l8 = (l6 << 1) + l3;
        l7 += l8 / l;
        l8 %= l;
        if (l7 > 0xFFFFFFFFL) {
            throw ProcessorException.DIVIDE_ERROR;
        }
        this.cpu.eax = (int)l7;
        this.cpu.edx = (int)l8;
    }

    private final void idiv_o8(byte by) {
        if (by == 0) {
            throw ProcessorException.DIVIDE_ERROR;
        }
        short s = (short)this.cpu.eax;
        int n = s / by;
        int n2 = s % by;
        if (n > 127 || n < -128) {
            throw ProcessorException.DIVIDE_ERROR;
        }
        this.cpu.eax = this.cpu.eax & 0xFFFF0000 | 0xFF & n | (0xFF & n2) << 8;
    }

    private final void idiv_o16(short s) {
        if (s == 0) {
            throw ProcessorException.DIVIDE_ERROR;
        }
        int n = this.cpu.edx << 16 | this.cpu.eax & 0xFFFF;
        int n2 = n / s;
        int n3 = n % s;
        if (n2 > Short.MAX_VALUE || n2 < Short.MIN_VALUE) {
            throw ProcessorException.DIVIDE_ERROR;
        }
        this.cpu.eax = this.cpu.eax & 0xFFFF0000 | 0xFFFF & n2;
        this.cpu.edx = this.cpu.edx & 0xFFFF0000 | 0xFFFF & n3;
    }

    private final void idiv_o32(int n) {
        if (n == 0) {
            throw ProcessorException.DIVIDE_ERROR;
        }
        long l = (0xFFFFFFFFL & (long)this.cpu.edx) << 32;
        long l2 = (l |= 0xFFFFFFFFL & (long)this.cpu.eax) / (long)n;
        if (l2 > Integer.MAX_VALUE || l2 < Integer.MIN_VALUE) {
            throw ProcessorException.DIVIDE_ERROR;
        }
        long l3 = l % (long)n;
        this.cpu.eax = (int)l2;
        this.cpu.edx = (int)l3;
    }

    private final void btc_mem(int n, Segment segment, int n2) throws ProcessorException {
        n2 += n >>> 3;
        byte by = segment.getByte(n2);
        segment.setByte(n2, (byte)(by ^ 1 << (n &= 7)));
        this.cpu.setCarryFlag(by, n, 7);
    }

    private final void bts_mem(int n, Segment segment, int n2) throws ProcessorException {
        n2 += n >>> 3;
        byte by = segment.getByte(n2);
        segment.setByte(n2, (byte)(by | 1 << (n &= 7)));
        this.cpu.setCarryFlag(by, n, 7);
    }

    private final void btr_mem(int n, Segment segment, int n2) throws ProcessorException {
        n2 += n >>> 3;
        byte by = segment.getByte(n2);
        segment.setByte(n2, (byte)(by & ~(1 << (n &= 7))));
        this.cpu.setCarryFlag(by, n, 7);
    }

    private final void bt_mem(int n, Segment segment, int n2) throws ProcessorException {
        n2 += n >>> 3;
        this.cpu.setCarryFlag(segment.getByte(n2), n &= 7, 7);
    }

    private final int bsf(int n, int n2) throws ProcessorException {
        if (n == 0) {
            this.cpu.setZeroFlag(true);
            return n2;
        }
        this.cpu.setZeroFlag(false);
        return ProtectedModeUBlock.numberOfTrailingZeros(n);
    }

    private final int bsr(int n, int n2) throws ProcessorException {
        if (n == 0) {
            this.cpu.setZeroFlag(true);
            return n2;
        }
        this.cpu.setZeroFlag(false);
        return 31 - ProtectedModeUBlock.numberOfLeadingZeros(n);
    }

    private final void aaa() {
        if ((this.cpu.eax & 0xF) > 9 || this.cpu.getAuxiliaryCarryFlag()) {
            int n = (this.cpu.eax & 0xFF) > 249 ? 256 : 0;
            this.cpu.eax = 0xFFFF0000 & this.cpu.eax | 0xF & this.cpu.eax + 6 | 0xFF00 & this.cpu.eax + 256 + n;
            this.cpu.setAuxiliaryCarryFlag(true);
            this.cpu.setCarryFlag(true);
        } else {
            this.cpu.setAuxiliaryCarryFlag(false);
            this.cpu.setCarryFlag(false);
            this.cpu.eax &= 0xFFFFFF0F;
        }
    }

    private final void aad(int n) throws ProcessorException {
        int n2 = this.cpu.eax & 0xFF;
        int n3 = this.cpu.eax >> 8 & 0xFF;
        int n4 = n3 * n;
        int n5 = n4 + n2;
        this.cpu.eax = this.cpu.eax & 0xFFFF0000 | n5 & 0xFF;
        this.bitwise_flags((byte)n5);
        this.cpu.setAuxiliaryCarryFlag(n4, n5, 2);
        this.cpu.setCarryFlag(n5, 8);
        this.cpu.setOverflowFlag(n5, n2, 13);
    }

    private final void aam(int n) throws ProcessorException {
        int n2 = 0xFF & this.cpu.eax;
        if (n == 0) {
            throw ProcessorException.DIVIDE_ERROR;
        }
        int n3 = 0xFF & n2 / n;
        int n4 = 0xFF & n2 % n;
        this.cpu.eax &= 0xFFFF0000;
        this.cpu.eax |= n4 | n3 << 8;
        this.cpu.setAuxiliaryCarryFlag(false);
        this.bitwise_flags((byte)n4);
    }

    private final void aas() {
        if ((this.cpu.eax & 0xF) > 9 || this.cpu.getAuxiliaryCarryFlag()) {
            int n = (this.cpu.eax & 0xFF) < 6 ? 256 : 0;
            this.cpu.eax = 0xFFFF0000 & this.cpu.eax | 0xF & this.cpu.eax - 6 | 0xFF00 & this.cpu.eax - 256 - n;
            this.cpu.setAuxiliaryCarryFlag(true);
            this.cpu.setCarryFlag(true);
        } else {
            this.cpu.setAuxiliaryCarryFlag(false);
            this.cpu.setCarryFlag(false);
            this.cpu.eax &= 0xFFFFFF0F;
        }
    }

    private final void daa() {
        boolean bl;
        int n = this.cpu.eax & 0xFF;
        if ((this.cpu.eax & 0xF) > 9 || this.cpu.getAuxiliaryCarryFlag()) {
            n += 6;
            this.cpu.setAuxiliaryCarryFlag(true);
        } else {
            this.cpu.setAuxiliaryCarryFlag(false);
        }
        if ((n & 0xFF) > 159 || this.cpu.getCarryFlag()) {
            n += 96;
            bl = true;
        } else {
            bl = false;
        }
        this.cpu.eax = this.cpu.eax & 0xFFFFFF00 | 0xFF & n;
        this.bitwise_flags((byte)n);
        this.cpu.setCarryFlag(bl);
    }

    private final void das() {
        boolean bl = false;
        int n = 0xFF & this.cpu.eax;
        if ((n & 0xF) > 9 || this.cpu.getAuxiliaryCarryFlag()) {
            this.cpu.setAuxiliaryCarryFlag(true);
            this.cpu.eax = this.cpu.eax & 0xFFFFFF00 | this.cpu.eax - 6 & 0xFF;
            boolean bl2 = bl = n < 6 || this.cpu.getCarryFlag();
        }
        if (n > 153 || this.cpu.getCarryFlag()) {
            this.cpu.eax = this.cpu.eax & 0xFFFFFF00 | this.cpu.eax - 96 & 0xFF;
            bl = true;
        }
        this.bitwise_flags((byte)this.cpu.eax);
        this.cpu.setCarryFlag(bl);
    }

    private final void lahf() {
        int n = 512;
        if (this.cpu.getSignFlag()) {
            n |= 0x8000;
        }
        if (this.cpu.getZeroFlag()) {
            n |= 0x4000;
        }
        if (this.cpu.getAuxiliaryCarryFlag()) {
            n |= 0x1000;
        }
        if (this.cpu.getParityFlag()) {
            n |= 0x400;
        }
        if (this.cpu.getCarryFlag()) {
            n |= 0x100;
        }
        this.cpu.eax &= 0xFFFF00FF;
        this.cpu.eax |= n;
    }

    private final void sahf() {
        int n = this.cpu.eax & 0xFF00;
        this.cpu.setCarryFlag(0 != (n & 0x100));
        this.cpu.setParityFlag(0 != (n & 0x400));
        this.cpu.setAuxiliaryCarryFlag(0 != (n & 0x1000));
        this.cpu.setZeroFlag(0 != (n & 0x4000));
        this.cpu.setSignFlag(0 != (n & 0x8000));
    }

    private final void jo_o8(byte by) {
        if (this.cpu.getOverflowFlag()) {
            this.jump_o8(by);
        }
    }

    private final void jno_o8(byte by) {
        if (!this.cpu.getOverflowFlag()) {
            this.jump_o8(by);
        }
    }

    private final void jc_o8(byte by) {
        if (this.cpu.getCarryFlag()) {
            this.jump_o8(by);
        }
    }

    private final void jnc_o8(byte by) {
        if (!this.cpu.getCarryFlag()) {
            this.jump_o8(by);
        }
    }

    private final void jz_o8(byte by) {
        if (this.cpu.getZeroFlag()) {
            this.jump_o8(by);
        }
    }

    private final void jnz_o8(byte by) {
        if (!this.cpu.getZeroFlag()) {
            this.jump_o8(by);
        }
    }

    private final void jna_o8(byte by) {
        if (this.cpu.getCarryFlag() || this.cpu.getZeroFlag()) {
            this.jump_o8(by);
        }
    }

    private final void ja_o8(byte by) {
        if (!this.cpu.getCarryFlag() && !this.cpu.getZeroFlag()) {
            this.jump_o8(by);
        }
    }

    private final void js_o8(byte by) {
        if (this.cpu.getSignFlag()) {
            this.jump_o8(by);
        }
    }

    private final void jns_o8(byte by) {
        if (!this.cpu.getSignFlag()) {
            this.jump_o8(by);
        }
    }

    private final void jp_o8(byte by) {
        if (this.cpu.getParityFlag()) {
            this.jump_o8(by);
        }
    }

    private final void jnp_o8(byte by) {
        if (!this.cpu.getParityFlag()) {
            this.jump_o8(by);
        }
    }

    private final void jl_o8(byte by) {
        if (this.cpu.getSignFlag() != this.cpu.getOverflowFlag()) {
            this.jump_o8(by);
        }
    }

    private final void jnl_o8(byte by) {
        if (this.cpu.getSignFlag() == this.cpu.getOverflowFlag()) {
            this.jump_o8(by);
        }
    }

    private final void jng_o8(byte by) {
        if (this.cpu.getZeroFlag() || this.cpu.getSignFlag() != this.cpu.getOverflowFlag()) {
            this.jump_o8(by);
        }
    }

    private final void jg_o8(byte by) {
        if (!this.cpu.getZeroFlag() && this.cpu.getSignFlag() == this.cpu.getOverflowFlag()) {
            this.jump_o8(by);
        }
    }

    private final void jo_o16(short s) {
        if (this.cpu.getOverflowFlag()) {
            this.jump_o16(s);
        }
    }

    private final void jno_o16(short s) {
        if (!this.cpu.getOverflowFlag()) {
            this.jump_o16(s);
        }
    }

    private final void jc_o16(short s) {
        if (this.cpu.getCarryFlag()) {
            this.jump_o16(s);
        }
    }

    private final void jnc_o16(short s) {
        if (!this.cpu.getCarryFlag()) {
            this.jump_o16(s);
        }
    }

    private final void jz_o16(short s) {
        if (this.cpu.getZeroFlag()) {
            this.jump_o16(s);
        }
    }

    private final void jnz_o16(short s) {
        if (!this.cpu.getZeroFlag()) {
            this.jump_o16(s);
        }
    }

    private final void jna_o16(short s) {
        if (this.cpu.getCarryFlag() || this.cpu.getZeroFlag()) {
            this.jump_o16(s);
        }
    }

    private final void ja_o16(short s) {
        if (!this.cpu.getCarryFlag() && !this.cpu.getZeroFlag()) {
            this.jump_o16(s);
        }
    }

    private final void js_o16(short s) {
        if (this.cpu.getSignFlag()) {
            this.jump_o16(s);
        }
    }

    private final void jns_o16(short s) {
        if (!this.cpu.getSignFlag()) {
            this.jump_o16(s);
        }
    }

    private final void jp_o16(short s) {
        if (this.cpu.getParityFlag()) {
            this.jump_o16(s);
        }
    }

    private final void jnp_o16(short s) {
        if (!this.cpu.getParityFlag()) {
            this.jump_o16(s);
        }
    }

    private final void jl_o16(short s) {
        if (this.cpu.getSignFlag() != this.cpu.getOverflowFlag()) {
            this.jump_o16(s);
        }
    }

    private final void jnl_o16(short s) {
        if (this.cpu.getSignFlag() == this.cpu.getOverflowFlag()) {
            this.jump_o16(s);
        }
    }

    private final void jng_o16(short s) {
        if (this.cpu.getZeroFlag() || this.cpu.getSignFlag() != this.cpu.getOverflowFlag()) {
            this.jump_o16(s);
        }
    }

    private final void jg_o16(short s) {
        if (!this.cpu.getZeroFlag() && this.cpu.getSignFlag() == this.cpu.getOverflowFlag()) {
            this.jump_o16(s);
        }
    }

    private final void jo_o32(int n) {
        if (this.cpu.getOverflowFlag()) {
            this.jump_o32(n);
        }
    }

    private final void jno_o32(int n) {
        if (!this.cpu.getOverflowFlag()) {
            this.jump_o32(n);
        }
    }

    private final void jc_o32(int n) {
        if (this.cpu.getCarryFlag()) {
            this.jump_o32(n);
        }
    }

    private final void jnc_o32(int n) {
        if (!this.cpu.getCarryFlag()) {
            this.jump_o32(n);
        }
    }

    private final void jz_o32(int n) {
        if (this.cpu.getZeroFlag()) {
            this.jump_o32(n);
        }
    }

    private final void jnz_o32(int n) {
        if (!this.cpu.getZeroFlag()) {
            this.jump_o32(n);
        }
    }

    private final void jna_o32(int n) {
        if (this.cpu.getCarryFlag() || this.cpu.getZeroFlag()) {
            this.jump_o32(n);
        }
    }

    private final void ja_o32(int n) {
        if (!this.cpu.getCarryFlag() && !this.cpu.getZeroFlag()) {
            this.jump_o32(n);
        }
    }

    private final void js_o32(int n) {
        if (this.cpu.getSignFlag()) {
            this.jump_o32(n);
        }
    }

    private final void jns_o32(int n) {
        if (!this.cpu.getSignFlag()) {
            this.jump_o32(n);
        }
    }

    private final void jp_o32(int n) {
        if (this.cpu.getParityFlag()) {
            this.jump_o32(n);
        }
    }

    private final void jnp_o32(int n) {
        if (!this.cpu.getParityFlag()) {
            this.jump_o32(n);
        }
    }

    private final void jl_o32(int n) {
        if (this.cpu.getSignFlag() != this.cpu.getOverflowFlag()) {
            this.jump_o32(n);
        }
    }

    private final void jnl_o32(int n) {
        if (this.cpu.getSignFlag() == this.cpu.getOverflowFlag()) {
            this.jump_o32(n);
        }
    }

    private final void jng_o32(int n) {
        if (this.cpu.getZeroFlag() || this.cpu.getSignFlag() != this.cpu.getOverflowFlag()) {
            this.jump_o32(n);
        }
    }

    private final void jg_o32(int n) {
        if (!this.cpu.getZeroFlag() && this.cpu.getSignFlag() == this.cpu.getOverflowFlag()) {
            this.jump_o32(n);
        }
    }

    private final void jcxz(byte by) {
        if ((this.cpu.ecx & 0xFFFF) == 0) {
            this.jump_o8(by);
        }
    }

    private final void jecxz(byte by) {
        if (this.cpu.ecx == 0) {
            this.jump_o8(by);
        }
    }

    private final void loop_cx(byte by) {
        this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | (0xFFFF & this.cpu.ecx) - 1 & 0xFFFF;
        if ((this.cpu.ecx & 0xFFFF) != 0) {
            this.jump_o8(by);
        }
    }

    private final void loop_ecx(byte by) {
        --this.cpu.ecx;
        if (this.cpu.ecx != 0) {
            this.jump_o8(by);
        }
    }

    private final void loopz_cx(byte by) {
        this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | this.cpu.ecx - 1 & 0xFFFF;
        if (this.cpu.getZeroFlag() && (this.cpu.ecx & 0xFFFF) != 0) {
            this.jump_o8(by);
        }
    }

    private final void loopz_ecx(byte by) {
        --this.cpu.ecx;
        if (this.cpu.getZeroFlag() && this.cpu.ecx != 0) {
            this.jump_o8(by);
        }
    }

    private final void loopnz_cx(byte by) {
        this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | this.cpu.ecx - 1 & 0xFFFF;
        if (!this.cpu.getZeroFlag() && (this.cpu.ecx & 0xFFFF) != 0) {
            this.jump_o8(by);
        }
    }

    private final void loopnz_ecx(byte by) {
        --this.cpu.ecx;
        if (!this.cpu.getZeroFlag() && this.cpu.ecx != 0) {
            this.jump_o8(by);
        }
    }

    private final void jump_o8(byte by) {
        if (by == 0) {
            return;
        }
        int n = this.cpu.eip + by;
        this.cpu.cs.checkAddress(n);
        this.cpu.eip = n;
    }

    private final void jump_o16(short s) {
        int n = this.cpu.eip + s & 0xFFFF;
        this.cpu.cs.checkAddress(n);
        this.cpu.eip = n;
    }

    private final void jump_o32(int n) {
        int n2 = this.cpu.eip + n;
        this.cpu.cs.checkAddress(n2);
        this.cpu.eip = n2;
    }

    private final void jump_abs(int n) {
        this.cpu.cs.checkAddress(n);
        this.cpu.eip = n;
    }

    private final void jump_far(int n, int n2) {
        Segment segment = this.cpu.getSegment(n2);
        if (segment == SegmentFactory.NULL_SEGMENT) {
            throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, 0, true);
        }
        switch (segment.getType()) {
            default: {
                System.err.println("Emulated: Invalid segment type " + segment.getType() + ".");
                throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n2, true);
            }
            case 5: {
                System.err.println("Critical error: Task gate not implemented");
                throw new IllegalStateException("Far jump through task gate is not implemented");
            }
            case 9: 
            case 11: {
                if (segment.getDPL() < this.cpu.getCPL() || segment.getDPL() < segment.getRPL()) {
                    throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n2, true);
                }
                if (!segment.isPresent()) {
                    throw new ProcessorException(ProcessorException.Type.NOT_PRESENT, n2, true);
                }
                if (segment.getLimit() < 103) {
                    throw new ProcessorException(ProcessorException.Type.TASK_SWITCH, n2, true);
                }
                if ((segment.getType() & 2) != 0) {
                    throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n2, true);
                }
                segment.getByte(0);
                this.cpu.tss.getByte(0);
                int n3 = 0xFFFF & segment.getWord(72);
                int n4 = 0xFFFF & segment.getWord(76);
                int n5 = 0xFFFF & segment.getWord(80);
                int n6 = 0xFFFF & segment.getWord(84);
                int n7 = 0xFFFF & segment.getWord(88);
                int n8 = 0xFFFF & segment.getWord(92);
                int n9 = 0xFFFF & segment.getWord(96);
                if ((n9 & 4) != 0) {
                    throw new ProcessorException(ProcessorException.Type.TASK_SWITCH, n9, true);
                }
                this.cpu.gdtr.checkAddress((n9 & 0xFFFFFFF8) + 7);
                if ((this.cpu.readSupervisorByte(this.cpu.gdtr, (n9 & 0xFFFFFFF8) + 5) & 0xE) != 2) {
                    System.err.println("Accessed LDT selector global byte 5:" + this.cpu.readSupervisorByte(this.cpu.gdtr, (n9 & 0xFFFFFFF8) + 5));
                    throw new ProcessorException(ProcessorException.Type.TASK_SWITCH, n9, true);
                }
                Segment segment2 = this.cpu.getSegment(n9);
                if ((n3 & 4) != 0) {
                    segment2.checkAddress((n3 & 0xFFFFFFF8) + 7);
                } else {
                    this.cpu.gdtr.checkAddress((n3 & 0xFFFFFFF8) + 7);
                }
                if ((n4 & 4) != 0) {
                    segment2.checkAddress((n4 & 0xFFFFFFF8) + 7);
                } else {
                    this.cpu.gdtr.checkAddress((n4 & 0xFFFFFFF8) + 7);
                }
                if ((n5 & 4) != 0) {
                    segment2.checkAddress((n5 & 0xFFFFFFF8) + 7);
                } else {
                    this.cpu.gdtr.checkAddress((n5 & 0xFFFFFFF8) + 7);
                }
                if ((n6 & 4) != 0) {
                    segment2.checkAddress((n6 & 0xFFFFFFF8) + 7);
                } else {
                    this.cpu.gdtr.checkAddress((n6 & 0xFFFFFFF8) + 7);
                }
                if ((n7 & 4) != 0) {
                    segment2.checkAddress((n7 & 0xFFFFFFF8) + 7);
                } else {
                    this.cpu.gdtr.checkAddress((n7 & 0xFFFFFFF8) + 7);
                }
                if ((n8 & 4) != 0) {
                    segment2.checkAddress((n8 & 0xFFFFFFF8) + 7);
                } else {
                    this.cpu.gdtr.checkAddress((n8 & 0xFFFFFFF8) + 7);
                }
                this.cpu.setSupervisorDoubleWord(this.cpu.gdtr, (this.cpu.tss.getSelector() & 0xFFFFFFF8) + 4, 0xFFFFFDFF & this.cpu.readSupervisorDoubleWord(this.cpu.gdtr, (this.cpu.tss.getSelector() & 0xFFFFFFF8) + 4));
                ((ProtectedModeSegment.AbstractTSS)this.cpu.tss).saveCPUState(this.cpu);
                this.cpu.setSupervisorDoubleWord(this.cpu.gdtr, (n2 & 0xFFFFFFF8) + 4, 0x200 | this.cpu.readSupervisorDoubleWord(this.cpu.gdtr, (n2 & 0xFFFFFFF8) + 4));
                this.cpu.setCR0(this.cpu.getCR0() | 8);
                this.cpu.ldtr = segment2;
                this.cpu.tss = segment;
                ((ProtectedModeSegment.AbstractTSS)this.cpu.tss).restoreCPUState(this.cpu);
                this.cpu.cs.checkAddress(this.cpu.eip);
                return;
            }
            case 12: {
                System.err.println("Critical error: Call gate not implemented");
                throw new IllegalStateException("Far jump through call gate not implemented");
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                if (segment.getRPL() != this.cpu.getCPL() || segment.getDPL() > this.cpu.getCPL()) {
                    throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n2, true);
                }
                if (!segment.isPresent()) {
                    throw new ProcessorException(ProcessorException.Type.NOT_PRESENT, n2, true);
                }
                segment.checkAddress(n);
                segment.setRPL(this.cpu.getCPL());
                this.cpu.cs = segment;
                this.cpu.eip = n;
                return;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
        }
        if (segment.getDPL() > this.cpu.getCPL()) {
            throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n2, true);
        }
        if (!segment.isPresent()) {
            throw new ProcessorException(ProcessorException.Type.NOT_PRESENT, n2, true);
        }
        segment.checkAddress(n);
        segment.setRPL(this.cpu.getCPL());
        this.cpu.cs = segment;
        this.cpu.eip = n;
    }

    private final void call_o32_a32(int n) {
        int n2 = this.cpu.eip + n;
        this.cpu.cs.checkAddress(n2);
        if (this.cpu.esp < 4 && this.cpu.esp > 0) {
            throw ProcessorException.STACK_SEGMENT_0;
        }
        this.cpu.ss.setDoubleWord(this.cpu.esp - 4, this.cpu.eip);
        this.cpu.esp -= 4;
        this.cpu.eip = n2;
    }

    private final void call_o16_a16(int n) {
        int n2 = 0xFFFF & this.cpu.eip + n;
        this.cpu.cs.checkAddress(n2);
        if ((0xFFFF & this.cpu.esp) < 2) {
            throw ProcessorException.STACK_SEGMENT_0;
        }
        this.cpu.ss.setWord(this.cpu.esp - 2 & 0xFFFF, (short)(0xFFFF & this.cpu.eip));
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp - 2 & 0xFFFF;
        this.cpu.eip = n2;
    }

    private final void call_o16_a32(int n) {
        int n2 = 0xFFFF & this.cpu.eip + n;
        this.cpu.cs.checkAddress(n2);
        if (this.cpu.esp < 2 && this.cpu.esp > 0) {
            throw ProcessorException.STACK_SEGMENT_0;
        }
        this.cpu.ss.setWord(this.cpu.esp - 2, (short)(0xFFFF & this.cpu.eip));
        this.cpu.esp -= 2;
        this.cpu.eip = n2;
    }

    private final void call_o32_a16(int n) {
        int n2 = this.cpu.eip + n;
        this.cpu.cs.checkAddress(n2);
        if ((0xFFFF & this.cpu.esp) < 4) {
            throw ProcessorException.STACK_SEGMENT_0;
        }
        this.cpu.ss.setDoubleWord(this.cpu.esp - 4 & 0xFFFF, this.cpu.eip);
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp - 4 & 0xFFFF;
        this.cpu.eip = n2;
    }

    private final void call_abs_o16_a16(int n) {
        this.cpu.cs.checkAddress(n & 0xFFFF);
        if ((this.cpu.esp & 0xFFFF) < 2) {
            throw ProcessorException.STACK_SEGMENT_0;
        }
        this.cpu.ss.setWord(this.cpu.esp - 2 & 0xFFFF, (short)(0xFFFF & this.cpu.eip));
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp - 2 & 0xFFFF;
        this.cpu.eip = n & 0xFFFF;
    }

    private final void call_abs_o16_a32(int n) {
        this.cpu.cs.checkAddress(n & 0xFFFF);
        if (this.cpu.esp < 2 && this.cpu.esp > 0) {
            throw ProcessorException.STACK_SEGMENT_0;
        }
        this.cpu.ss.setWord(this.cpu.esp - 2, (short)(0xFFFF & this.cpu.eip));
        this.cpu.esp -= 2;
        this.cpu.eip = n & 0xFFFF;
    }

    private final void call_abs_o32_a32(int n) {
        this.cpu.cs.checkAddress(n);
        if (this.cpu.esp < 4 && this.cpu.esp > 0) {
            throw ProcessorException.STACK_SEGMENT_0;
        }
        this.cpu.ss.setDoubleWord(this.cpu.esp - 4, this.cpu.eip);
        this.cpu.esp -= 4;
        this.cpu.eip = n;
    }

    private final void call_abs_o32_a16(int n) {
        this.cpu.cs.checkAddress(n);
        if ((this.cpu.esp & 0xFFFF) < 4) {
            throw ProcessorException.STACK_SEGMENT_0;
        }
        this.cpu.ss.setDoubleWord(this.cpu.esp - 4 & 0xFFFF, this.cpu.eip);
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp - 4 & 0xFFFF;
        this.cpu.eip = n;
    }

    private final void call_far_o16_a32(int n, int n2) {
        Segment segment = this.cpu.getSegment(n2);
        if (segment == SegmentFactory.NULL_SEGMENT) {
            throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, 0, true);
        }
        switch (segment.getType()) {
            default: {
                System.err.println("Emulated: Invalid segment type " + segment.getType() + ".");
                throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n2, true);
            }
            case 1: 
            case 3: {
                System.err.println("Critical error: 16-bit TSS not implemented");
                throw new IllegalStateException("O16 A32 CALL FAR to 16-bit TSS not implemented");
            }
            case 4: {
                Segment segment2;
                if (segment.getRPL() > this.cpu.getCPL() || segment.getDPL() < this.cpu.getCPL()) {
                    throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n2, true);
                }
                if (!segment.isPresent()) {
                    throw new ProcessorException(ProcessorException.Type.NOT_PRESENT, n2, true);
                }
                ProtectedModeSegment.GateSegment gateSegment = (ProtectedModeSegment.GateSegment)segment;
                int n3 = gateSegment.getTargetSegment();
                try {
                    segment2 = this.cpu.getSegment(n3);
                }
                catch (ProcessorException processorException) {
                    throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n3, true);
                }
                if (segment2 == SegmentFactory.NULL_SEGMENT) {
                    throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, 0, true);
                }
                if (segment2.getDPL() > this.cpu.getCPL()) {
                    throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n2, true);
                }
                switch (segment2.getType()) {
                    default: {
                        throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n3, true);
                    }
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: {
                        if (!segment2.isPresent()) {
                            throw new ProcessorException(ProcessorException.Type.NOT_PRESENT, n3, true);
                        }
                        if (segment2.getDPL() < this.cpu.getCPL()) {
                            System.err.println("Critical error: 16-bit call gate: jump to more privileged segment not implemented");
                            throw new IllegalStateException("O16 A32 CALL FAR to 16-bit call gate to more priviledged segment not implmented");
                        }
                        if (segment2.getDPL() == this.cpu.getCPL()) {
                            System.err.println("O16 A32 CALL FAR: 16-bit call gate to same priviledge segment not implemented");
                            throw new IllegalStateException("O16 A32 CALL FAR\u00a0to 16-bit call gate to same priviledge segment not implemented");
                        }
                        throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n3, true);
                    }
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                }
                if (!segment2.isPresent()) {
                    throw new ProcessorException(ProcessorException.Type.NOT_PRESENT, n3, true);
                }
                System.err.println("Critical error: 16-bit call gate: jump to same privilege conforming segment not implemented");
                throw new IllegalStateException("O16 A32 CALL FAR to 16-bit call gate: Jump to same privieledge conforming segment not implemented");
            }
            case 5: {
                System.err.println("Critical error: Task gate not implemented");
                throw new IllegalStateException("O16 A32 CALL FAR to task gate not implemented");
            }
            case 9: 
            case 11: {
                System.err.println("Critical error: TSS not implemented");
                throw new IllegalStateException("O16 A32 CALL FAR to TSS not implemented");
            }
            case 12: {
                System.err.println("Critical error: Call gate not implemented");
                throw new IllegalStateException("O16 A32 CALL FAR TO call gate not supported");
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                if (segment.getRPL() > this.cpu.getCPL() || segment.getDPL() != this.cpu.getCPL()) {
                    throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n2, true);
                }
                if (!segment.isPresent()) {
                    throw new ProcessorException(ProcessorException.Type.NOT_PRESENT, n2, true);
                }
                if (this.cpu.esp < 4 && this.cpu.esp > 0) {
                    throw ProcessorException.STACK_SEGMENT_0;
                }
                segment.checkAddress(n & 0xFFFF);
                this.cpu.ss.setWord(this.cpu.esp - 2, (short)(0xFFFF & this.cpu.cs.getSelector()));
                this.cpu.ss.setWord(this.cpu.esp - 4, (short)(0xFFFF & this.cpu.eip));
                this.cpu.esp -= 4;
                this.cpu.cs = segment;
                this.cpu.cs.setRPL(this.cpu.getCPL());
                this.cpu.eip = n & 0xFFFF;
                return;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
        }
        System.err.println("Critical error: Conforming code segment not implemented");
        throw new IllegalStateException("O16 A32 CALL FAR to conforming code segment not implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void call_far_o16_a16(int n, int n2) {
        if ((n2 & 0xFFFC) == 0) {
            throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, 0, true);
        }
        Segment segment = this.cpu.getSegment(n2);
        if (segment == SegmentFactory.NULL_SEGMENT) {
            throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, 0, true);
        }
        block3 : switch (segment.getType()) {
            default: {
                System.err.println("Emulated: Invalid segment type " + segment.getType() + ".");
                throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n2, true);
            }
            case 1: 
            case 3: {
                System.err.println("Critical error: 16-bit TSS not implemented");
                throw new IllegalStateException("O16 A16 CALL FAR to 16-bit TSS not implemented");
            }
            case 4: {
                Segment segment2;
                if (segment.getDPL() < segment.getRPL() || segment.getDPL() < this.cpu.getCPL()) {
                    throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n2 & 0xFFFC, true);
                }
                if (!segment.isPresent()) {
                    throw new ProcessorException(ProcessorException.Type.NOT_PRESENT, n2 & 0xFFFC, true);
                }
                ProtectedModeSegment.CallGate16Bit callGate16Bit = (ProtectedModeSegment.CallGate16Bit)segment;
                int n3 = callGate16Bit.getTargetSegment();
                if ((n3 & 0xFFFC) == 0) {
                    throw new ProcessorException(ProcessorException.Type.NOT_PRESENT, 0, true);
                }
                try {
                    segment2 = this.cpu.getSegment(n3);
                }
                catch (ProcessorException processorException) {
                    throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n3 & 0xFFFC, true);
                }
                if (segment2 == SegmentFactory.NULL_SEGMENT) {
                    throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n3 & 0xFFFC, true);
                }
                if (segment2.getDPL() > this.cpu.getCPL() || segment2.isSystem() || (segment2.getType() & 0x18) == 16) {
                    throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n3 & 0xFFFC, true);
                }
                if (!segment2.isPresent()) {
                    throw new ProcessorException(ProcessorException.Type.NOT_PRESENT, n3 & 0xFFFC, true);
                }
                switch (segment2.getType()) {
                    default: {
                        throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n3, true);
                    }
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: {
                        if (segment2.getDPL() < this.cpu.getCPL()) {
                            int n4;
                            int n5;
                            int n6 = 0;
                            int n7 = 0;
                            if ((this.cpu.tss.getType() & 8) != 0) {
                                n5 = segment2.getDPL() * 8 + 4;
                                if (n5 + 7 > this.cpu.tss.getLimit()) {
                                    throw new ProcessorException(ProcessorException.Type.TASK_SWITCH, this.cpu.tss.getSelector(), true);
                                }
                                n4 = this.cpu.linearMemory.isSupervisor();
                                try {
                                    this.cpu.linearMemory.setSupervisor(true);
                                    n6 = 0xFFFF & this.cpu.tss.getWord(n5 + 4);
                                    n7 = this.cpu.tss.getDoubleWord(n5);
                                }
                                finally {
                                    this.cpu.linearMemory.setSupervisor(n4 != 0);
                                }
                            } else {
                                n5 = segment2.getDPL() * 4 + 2;
                                if (n5 + 4 > this.cpu.tss.getLimit()) {
                                    throw new ProcessorException(ProcessorException.Type.TASK_SWITCH, this.cpu.tss.getSelector(), true);
                                }
                                n6 = 0xFFFF & this.cpu.tss.getWord(n5 + 2);
                                n7 = 0xFFFF & this.cpu.tss.getWord(n5);
                            }
                            if ((n6 & 0xFFFC) == 0) {
                                throw new ProcessorException(ProcessorException.Type.TASK_SWITCH, 0, true);
                            }
                            Segment segment3 = null;
                            try {
                                segment3 = this.cpu.getSegment(n6);
                            }
                            catch (ProcessorException processorException) {
                                throw new ProcessorException(ProcessorException.Type.TASK_SWITCH, n6, true);
                            }
                            if (segment3.getRPL() != segment2.getDPL()) {
                                throw new ProcessorException(ProcessorException.Type.TASK_SWITCH, n6 & 0xFFFC, true);
                            }
                            if (segment3.getDPL() != segment2.getDPL() || (segment3.getType() & 0x1A) != 18) {
                                throw new ProcessorException(ProcessorException.Type.TASK_SWITCH, n6 & 0xFFFC, true);
                            }
                            if (!segment3.isPresent()) {
                                throw new ProcessorException(ProcessorException.Type.NOT_PRESENT, n6 & 0xFFFC, true);
                            }
                            n4 = callGate16Bit.getParameterCount() & 0x1F;
                            if (segment3.getDefaultSizeFlag() && this.cpu.esp < 8 + 2 * n4 && this.cpu.esp > 0 || !segment3.getDefaultSizeFlag() && (this.cpu.esp & 0xFFFF) < 8 + 2 * n4) {
                                throw ProcessorException.STACK_SEGMENT_0;
                            }
                            int n8 = 0xFFFF & callGate16Bit.getTargetOffset();
                            int n9 = this.cpu.ss.getSelector();
                            Segment segment4 = this.cpu.ss;
                            int n10 = this.cpu.ss.getDefaultSizeFlag() ? this.cpu.esp : this.cpu.esp & 0xFFFF;
                            int n11 = this.cpu.cs.getSelector();
                            int n12 = this.cpu.cs.getDefaultSizeFlag() ? this.cpu.eip : this.cpu.eip & 0xFFFF;
                            this.cpu.ss = segment3;
                            this.cpu.esp = n7;
                            this.cpu.ss.setRPL(segment2.getDPL());
                            if (this.cpu.ss.getDefaultSizeFlag()) {
                                this.cpu.esp -= 2;
                                this.cpu.ss.setWord(this.cpu.esp, (short)n9);
                                this.cpu.esp -= 2;
                                this.cpu.ss.setWord(this.cpu.esp, (short)n10);
                                for (int i = 0; i < n4; ++i) {
                                    this.cpu.esp -= 2;
                                    this.cpu.ss.setWord(this.cpu.esp, segment4.getWord(n10 + 2 * n4 - 2 * i - 2));
                                }
                                this.cpu.esp -= 2;
                                this.cpu.ss.setWord(this.cpu.esp, (short)n11);
                                this.cpu.esp -= 2;
                                this.cpu.ss.setWord(this.cpu.esp, (short)n12);
                            } else {
                                this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp - 2 & 0xFFFF;
                                this.cpu.ss.setWord(this.cpu.esp & 0xFFFF, (short)n9);
                                this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp - 2 & 0xFFFF;
                                this.cpu.ss.setWord(this.cpu.esp & 0xFFFF, (short)n10);
                                for (int i = 0; i < n4; ++i) {
                                    this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp - 2 & 0xFFFF;
                                    this.cpu.ss.setWord(this.cpu.esp & 0xFFFF, segment4.getWord(n10 + 2 * n4 - 2 * i - 2 & 0xFFFF));
                                }
                                this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp - 2 & 0xFFFF;
                                this.cpu.ss.setWord(this.cpu.esp & 0xFFFF, (short)n11);
                                this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp - 2 & 0xFFFF;
                                this.cpu.ss.setWord(this.cpu.esp & 0xFFFF, (short)n12);
                            }
                            segment2.checkAddress(n8);
                            this.cpu.cs = segment2;
                            this.cpu.eip = n8;
                            this.cpu.setCPL(this.cpu.ss.getDPL());
                            this.cpu.cs.setRPL(this.cpu.getCPL());
                            break block3;
                        }
                        if (segment2.getDPL() == this.cpu.getCPL()) {
                            System.err.println("Critical error: 16-bit call gate: jump to same privilege segment not implemented");
                            throw new IllegalStateException("O16 A16 CALL FAR to 16-bit call gate same priviledge segment not implemented");
                        }
                        throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n3, true);
                    }
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                }
                System.err.println("Critical error: 16-bit call gate: jump to same privilege conforming segment not implemented");
                throw new IllegalStateException("O16 A16 CALL FAR call gate to same priviledge conforming segment not implemented");
            }
            case 5: {
                System.err.println("Critical error: Task gate not implemented");
                throw new IllegalStateException("O16 A16 CALL FAR to task gate not implemented");
            }
            case 9: 
            case 11: {
                System.err.println("Critical error: TSS not implemented");
                throw new IllegalStateException("O16 A16 CALL FAR to TSS not implemented");
            }
            case 12: {
                System.err.println("Critical error: Call gate not implemented");
                throw new IllegalStateException("O16 A16 CALL FAR to call gate not implemented");
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                if (!segment.isPresent()) {
                    throw new ProcessorException(ProcessorException.Type.NOT_PRESENT, segment.getSelector(), true);
                }
                if (this.cpu.esp < 4 && this.cpu.esp > 0) {
                    throw ProcessorException.STACK_SEGMENT_0;
                }
                segment.checkAddress(n & 0xFFFF);
                int n13 = this.cpu.ss.getDefaultSizeFlag() ? this.cpu.esp : this.cpu.esp & 0xFFFF;
                this.cpu.ss.setWord(n13 - 2, (short)(0xFFFF & this.cpu.cs.getSelector()));
                this.cpu.ss.setWord(n13 - 4, (short)(0xFFFF & this.cpu.eip));
                this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp - 4 & 0xFFFF;
                this.cpu.cs = segment;
                this.cpu.cs.setRPL(this.cpu.getCPL());
                this.cpu.eip = n & 0xFFFF;
                return;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                System.err.println("Critical error: Conforming code segment not implemented");
                throw new IllegalStateException("O16 A16 CALL FAR to conforming code segment not implemented");
            }
        }
    }

    private final void call_far_o32_a32(int n, int n2) {
        Segment segment = this.cpu.getSegment(n2);
        if (segment == SegmentFactory.NULL_SEGMENT) {
            throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, 0, true);
        }
        switch (segment.getType()) {
            default: {
                System.err.println("Emulated: Invalid segment type " + segment.getType() + ".");
                throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n2, true);
            }
            case 1: 
            case 3: {
                System.err.println("Critical error: 16-bit TSS not implemented");
                throw new IllegalStateException("O32 A32 CALL FAR to 16-bit TSS not implemented");
            }
            case 4: {
                Segment segment2;
                if (segment.getRPL() > this.cpu.getCPL() || segment.getDPL() < this.cpu.getCPL()) {
                    throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n2, true);
                }
                if (!segment.isPresent()) {
                    throw new ProcessorException(ProcessorException.Type.NOT_PRESENT, n2, true);
                }
                ProtectedModeSegment.GateSegment gateSegment = (ProtectedModeSegment.GateSegment)segment;
                int n3 = gateSegment.getTargetSegment();
                try {
                    segment2 = this.cpu.getSegment(n3);
                }
                catch (ProcessorException processorException) {
                    throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n3, true);
                }
                if (segment2 == SegmentFactory.NULL_SEGMENT) {
                    throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, 0, true);
                }
                if (segment2.getDPL() > this.cpu.getCPL()) {
                    throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n2, true);
                }
                switch (segment2.getType()) {
                    default: {
                        throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n3, true);
                    }
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: {
                        if (!segment2.isPresent()) {
                            throw new ProcessorException(ProcessorException.Type.NOT_PRESENT, n3, true);
                        }
                        if (segment2.getDPL() < this.cpu.getCPL()) {
                            System.err.println("Critical error: 16-bit call gate: jump to more privileged segment not implemented");
                            throw new IllegalStateException("O32 A32 CALL FAR to 16-bit call gate: Jump to more priviledged segment not implemented");
                        }
                        if (segment2.getDPL() == this.cpu.getCPL()) {
                            System.err.println("Critical error: 16-bit call gate: jump to same privilege segment not implemented");
                            throw new IllegalStateException("O32 A32 CALL FAR to 16-bit call gate: Jump to same-priviledge segment not implemented");
                        }
                        throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n3, true);
                    }
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                }
                if (!segment2.isPresent()) {
                    throw new ProcessorException(ProcessorException.Type.NOT_PRESENT, n3, true);
                }
                System.err.println("Critical error: 16-bit call gate: jump to same privilege conforming segment not implemented");
                throw new IllegalStateException("O32 A32 CALL FAR to 16-bit call gate: Jump to same priviledge conforming segment not implemented");
            }
            case 5: {
                System.err.println("Critical error: Task gate not implemented");
                throw new IllegalStateException("O32 A32 CALL FAR to task gate not implemented");
            }
            case 9: 
            case 11: {
                System.err.println("Critical error: TSS not implemented");
                throw new IllegalStateException("O32 A32 CALL FAR to TSS not implemented");
            }
            case 12: {
                System.err.println("Critical error: Call gate not implemented");
                throw new IllegalStateException("O32 A32 CALL FAR to call gate not implemented");
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                if (segment.getRPL() > this.cpu.getCPL() || segment.getDPL() != this.cpu.getCPL()) {
                    throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n2, true);
                }
                if (!segment.isPresent()) {
                    throw new ProcessorException(ProcessorException.Type.NOT_PRESENT, n2, true);
                }
                if (this.cpu.esp < 8 && this.cpu.esp > 0) {
                    throw ProcessorException.STACK_SEGMENT_0;
                }
                segment.checkAddress(n);
                this.cpu.ss.setDoubleWord(this.cpu.esp - 4, this.cpu.cs.getSelector());
                this.cpu.ss.setDoubleWord(this.cpu.esp - 8, this.cpu.eip);
                this.cpu.esp -= 8;
                this.cpu.cs = segment;
                this.cpu.cs.setRPL(this.cpu.getCPL());
                this.cpu.eip = n;
                return;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
        }
        System.err.println("Critical error: Conforming code segment not implemented");
        throw new IllegalStateException("O32 A32 CALL FAR to conforming code segment not implemented");
    }

    private final void call_far_o32_a16(int n, int n2) {
        Segment segment = this.cpu.getSegment(n2);
        if (segment == SegmentFactory.NULL_SEGMENT) {
            throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, 0, true);
        }
        switch (segment.getType()) {
            default: {
                System.err.println("Emulated: Invalid segment type " + segment.getType() + ".");
                throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n2, true);
            }
            case 1: 
            case 3: {
                System.err.println("Critical error: 16-bit TSS not implemented");
                throw new IllegalStateException("O32 A16 CALL FAR to 16-bit TSS not implemented");
            }
            case 4: {
                Segment segment2;
                if (segment.getRPL() > this.cpu.getCPL() || segment.getDPL() < this.cpu.getCPL()) {
                    throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n2, true);
                }
                if (!segment.isPresent()) {
                    throw new ProcessorException(ProcessorException.Type.NOT_PRESENT, n2, true);
                }
                ProtectedModeSegment.GateSegment gateSegment = (ProtectedModeSegment.GateSegment)segment;
                int n3 = gateSegment.getTargetSegment();
                try {
                    segment2 = this.cpu.getSegment(n3);
                }
                catch (ProcessorException processorException) {
                    throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n3, true);
                }
                if (segment2 == SegmentFactory.NULL_SEGMENT) {
                    throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, 0, true);
                }
                if (segment2.getDPL() > this.cpu.getCPL()) {
                    throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n2, true);
                }
                switch (segment2.getType()) {
                    default: {
                        throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n3, true);
                    }
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: {
                        if (!segment2.isPresent()) {
                            throw new ProcessorException(ProcessorException.Type.NOT_PRESENT, n3, true);
                        }
                        if (segment2.getDPL() < this.cpu.getCPL()) {
                            System.err.println("Critical error: 16-bit call gate: jump to more privileged segment not implemented");
                            throw new IllegalStateException("O32 A16 CALL FAR to 16-bit call gate: Jump to more priviledged segmment not supported");
                        }
                        if (segment2.getDPL() == this.cpu.getCPL()) {
                            System.err.println("Critical error: 16-bit call gate: jump to same privilege segment not implemented");
                            throw new IllegalStateException("O32 A16 CALL FAR to 16-bit call gate: Jump to same priviledge segmment not supported");
                        }
                        throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n3, true);
                    }
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                }
                if (!segment2.isPresent()) {
                    throw new ProcessorException(ProcessorException.Type.NOT_PRESENT, n3, true);
                }
                System.err.println("Critical error: 16-bit call gate: jump to same privilege conforming segment not implemented");
                throw new IllegalStateException("O32 A16 CALL FAR to 16-bit call gate: Jump to same priviledge conforming segment not implemented");
            }
            case 5: {
                System.err.println("Critical error: Task gate not implemented");
                throw new IllegalStateException("O32 A16 CALL FAR to task gate not implemented");
            }
            case 9: 
            case 11: {
                System.err.println("Critical error: TSS not implemented");
                throw new IllegalStateException("O32 A16 CALL FAR to TSS not implemented");
            }
            case 12: {
                System.err.println("Critical error: Call gate not implemented");
                throw new IllegalStateException("O32 A16 CALL FAR to call gate not implemented");
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                if (segment.getRPL() > this.cpu.getCPL() || segment.getDPL() != this.cpu.getCPL()) {
                    throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n2, true);
                }
                if (!segment.isPresent()) {
                    throw new ProcessorException(ProcessorException.Type.NOT_PRESENT, n2, true);
                }
                if ((this.cpu.esp & 0xFFFF) < 8) {
                    throw ProcessorException.STACK_SEGMENT_0;
                }
                segment.checkAddress(n);
                this.cpu.ss.setDoubleWord(this.cpu.esp - 4 & 0xFFFF, this.cpu.cs.getSelector());
                this.cpu.ss.setDoubleWord(this.cpu.esp - 8 & 0xFFFF, this.cpu.eip);
                this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp - 8 & 0xFFFF;
                this.cpu.cs = segment;
                this.cpu.cs.setRPL(this.cpu.getCPL());
                this.cpu.eip = n;
                return;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
        }
        System.err.println("Critical error: Conforming code segment not implemented");
        throw new IllegalStateException("O32 A16 CALL FAR to conforming segment not implemented");
    }

    private final void ret_o16_a32() {
        this.cpu.eip = this.cpu.ss.getWord(this.cpu.esp) & 0xFFFF;
        this.cpu.esp += 2;
    }

    private final void ret_o16_a16() {
        this.cpu.eip = this.cpu.ss.getWord(this.cpu.esp & 0xFFFF) & 0xFFFF;
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp + 2 & 0xFFFF;
    }

    private final void ret_o32_a32() {
        this.cpu.eip = this.cpu.ss.getDoubleWord(this.cpu.esp);
        this.cpu.esp += 4;
    }

    private final void ret_o32_a16() {
        this.cpu.eip = this.cpu.ss.getDoubleWord(0xFFFF & this.cpu.esp);
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp + 4 & 0xFFFF;
    }

    private final void ret_iw_o16_a32(short s) {
        this.ret_o16_a32();
        this.cpu.esp += s;
    }

    private final void ret_iw_o16_a16(short s) {
        this.ret_o16_a16();
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | (this.cpu.esp & 0xFFFF) + s & 0xFFFF;
    }

    private final void ret_iw_o32_a32(short s) {
        this.ret_o32_a32();
        this.cpu.esp += s;
    }

    private final void ret_iw_o32_a16(short s) {
        this.ret_o32_a16();
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | (this.cpu.esp & 0xFFFF) + s & 0xFFFF;
    }

    private final void ret_far_o16_a16(int n) {
        try {
            this.cpu.ss.checkAddress(this.cpu.esp + 3 & 0xFFFF);
        }
        catch (ProcessorException processorException) {
            throw ProcessorException.STACK_SEGMENT_0;
        }
        int n2 = 0xFFFF & this.cpu.ss.getWord(this.cpu.esp & 0xFFFF);
        int n3 = 0xFFFF & this.cpu.ss.getWord(this.cpu.esp + 2 & 0xFFFF);
        if ((n3 & 0xFFFC) == 0) {
            throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, 0, true);
        }
        Segment segment = this.cpu.getSegment(n3);
        if (segment == SegmentFactory.NULL_SEGMENT) {
            throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, 0, true);
        }
        if (segment.getRPL() < this.cpu.getCPL()) {
            System.err.println("Emulated: RPL too small in far ret: RPL=" + segment.getRPL() + ", CPL=" + this.cpu.getCPL() + ", new CS=" + Integer.toHexString(n3));
            throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n3, true);
        }
        switch (segment.getType()) {
            default: {
                throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n3, true);
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                if (!segment.isPresent()) {
                    throw new ProcessorException(ProcessorException.Type.NOT_PRESENT, n3, true);
                }
                if (segment.getRPL() > this.cpu.getCPL()) {
                    try {
                        this.cpu.ss.checkAddress(this.cpu.esp + 7 + n & 0xFFFF);
                    }
                    catch (ProcessorException processorException) {
                        throw ProcessorException.STACK_SEGMENT_0;
                    }
                    int n4 = 0xFFFF & this.cpu.ss.getWord(this.cpu.esp + 4 + n & 0xFFFF);
                    int n5 = 0xFFFF & this.cpu.ss.getWord(this.cpu.esp + 6 + n & 0xFFFF);
                    if ((n5 & 0xFFFC) == 0) {
                        throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, 0, true);
                    }
                    Segment segment2 = this.cpu.getSegment(n5);
                    if (segment2.getRPL() != segment.getRPL() || (segment2.getType() & 0x12) != 18 || segment2.getDPL() != segment.getRPL()) {
                        throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n5 & 0xFFFC, true);
                    }
                    if (!segment2.isPresent()) {
                        throw new ProcessorException(ProcessorException.Type.STACK_SEGMENT, n5 & 0xFFFC, true);
                    }
                    segment.checkAddress(n2);
                    this.cpu.eip = n2;
                    this.cpu.cs = segment;
                    this.cpu.ss = segment2;
                    this.cpu.esp = n4 + n;
                    this.cpu.setCPL(this.cpu.cs.getRPL());
                    try {
                        if (((this.cpu.es.getType() & 0x18) == 16 || (this.cpu.es.getType() & 0x1C) == 24) && this.cpu.getCPL() > this.cpu.es.getDPL()) {
                            System.err.println("Emulated: Setting ES to NULL in ret far");
                        }
                        this.cpu.es = SegmentFactory.NULL_SEGMENT;
                    }
                    catch (ProcessorException processorException) {
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (((this.cpu.ds.getType() & 0x18) == 16 || (this.cpu.ds.getType() & 0x1C) == 24) && this.cpu.getCPL() > this.cpu.ds.getDPL()) {
                            System.err.println("Emulated: Setting DS to NULL in ret far");
                        }
                        this.cpu.ds = SegmentFactory.NULL_SEGMENT;
                    }
                    catch (ProcessorException processorException) {
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (((this.cpu.fs.getType() & 0x18) == 16 || (this.cpu.fs.getType() & 0x1C) == 24) && this.cpu.getCPL() > this.cpu.fs.getDPL()) {
                            System.err.println("Emulated: Setting FS to NULL in ret far");
                        }
                        this.cpu.fs = SegmentFactory.NULL_SEGMENT;
                    }
                    catch (ProcessorException processorException) {
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (((this.cpu.gs.getType() & 0x18) == 16 || (this.cpu.gs.getType() & 0x1C) == 24) && this.cpu.getCPL() > this.cpu.gs.getDPL()) {
                            System.err.println("Emulated: Setting GS to NULL in ret far");
                        }
                        this.cpu.gs = SegmentFactory.NULL_SEGMENT;
                    }
                    catch (ProcessorException processorException) {
                    }
                    catch (Exception exception) {}
                    break;
                }
                segment.checkAddress(n2);
                this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp + 4 + n & 0xFFFF;
                this.cpu.eip = n2;
                this.cpu.cs = segment;
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                if (segment.getDPL() > segment.getRPL()) {
                    throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n3, true);
                }
                if (!segment.isPresent()) {
                    throw new ProcessorException(ProcessorException.Type.NOT_PRESENT, n3, true);
                }
                if (segment.getRPL() > this.cpu.getCPL()) {
                    System.err.println("Critical error: Conforming outer privilege level not implemented");
                    throw new IllegalStateException("O16 A16 RETF to conforiming outer priviledge level not implemented");
                }
                segment.checkAddress(n2);
                this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp + 4 + n & 0xFFFF;
                this.cpu.eip = n2;
                this.cpu.cs = segment;
            }
        }
    }

    private final void ret_far_o16_a32(int n) {
        try {
            this.cpu.ss.checkAddress(this.cpu.esp + 3);
        }
        catch (ProcessorException processorException) {
            throw ProcessorException.STACK_SEGMENT_0;
        }
        int n2 = 0xFFFF & this.cpu.ss.getWord(this.cpu.esp);
        int n3 = 0xFFFF & this.cpu.ss.getWord(this.cpu.esp + 2);
        Segment segment = this.cpu.getSegment(n3);
        if (segment == SegmentFactory.NULL_SEGMENT) {
            throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, 0, true);
        }
        switch (segment.getType()) {
            default: {
                throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n3, true);
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                if (segment.getRPL() < this.cpu.getCPL()) {
                    throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n3, true);
                }
                if (!segment.isPresent()) {
                    throw new ProcessorException(ProcessorException.Type.NOT_PRESENT, n3, true);
                }
                if (segment.getRPL() > this.cpu.getCPL()) {
                    System.err.println("Critical error: Non-conforming outer privilege level not implemented");
                    throw new IllegalStateException("O16 A32 RETF to non-conforming outer priviledge level not implemented");
                }
                segment.checkAddress(n2);
                this.cpu.esp = this.cpu.esp + 4 + n;
                this.cpu.eip = n2;
                this.cpu.cs = segment;
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                if (segment.getRPL() < this.cpu.getCPL()) {
                    throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n3, true);
                }
                if (segment.getDPL() > segment.getRPL()) {
                    throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n3, true);
                }
                if (!segment.isPresent()) {
                    throw new ProcessorException(ProcessorException.Type.NOT_PRESENT, n3, true);
                }
                if (segment.getRPL() > this.cpu.getCPL()) {
                    System.err.println("Critical error: Conforming outer privilege level not implemented");
                    throw new IllegalStateException("O16 A32 RETF to conforming outer priviledge level not implemented");
                }
                segment.checkAddress(n2 & 0xFFFF);
                this.cpu.esp = this.cpu.esp + 4 + n;
                this.cpu.eip = 0xFFFF & n2;
                this.cpu.cs = segment;
            }
        }
    }

    private final void ret_far_o32_a16(int n) {
        try {
            this.cpu.ss.checkAddress(this.cpu.esp + 7 & 0xFFFF);
        }
        catch (ProcessorException processorException) {
            throw ProcessorException.STACK_SEGMENT_0;
        }
        int n2 = this.cpu.ss.getDoubleWord(this.cpu.esp & 0xFFFF);
        int n3 = 0xFFFF & this.cpu.ss.getDoubleWord(this.cpu.esp + 4 & 0xFFFF);
        Segment segment = this.cpu.getSegment(n3);
        if (segment == SegmentFactory.NULL_SEGMENT) {
            throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, 0, true);
        }
        switch (segment.getType()) {
            default: {
                throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n3, true);
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                if (segment.getRPL() < this.cpu.getCPL()) {
                    throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n3, true);
                }
                if (!segment.isPresent()) {
                    throw new ProcessorException(ProcessorException.Type.NOT_PRESENT, n3, true);
                }
                if (segment.getRPL() > this.cpu.getCPL()) {
                    System.err.println("Critical error: Non-conforming outer privilege level not implemented");
                    throw new IllegalStateException("O32 A16 RETF to non-conforming outer privilege level not implemented");
                }
                segment.checkAddress(n2);
                this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp + 8 + n & 0xFFFF;
                this.cpu.eip = n2;
                this.cpu.cs = segment;
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                if (segment.getRPL() < this.cpu.getCPL()) {
                    throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n3, true);
                }
                if (segment.getDPL() > segment.getRPL()) {
                    throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n3, true);
                }
                if (!segment.isPresent()) {
                    throw new ProcessorException(ProcessorException.Type.NOT_PRESENT, n3, true);
                }
                if (segment.getRPL() > this.cpu.getCPL()) {
                    System.err.println("Critical error: Conforming outer privilege level not implemented");
                    throw new IllegalStateException("O32 A16 RETF to conforming outer privilege level not implemented");
                }
                segment.checkAddress(n2);
                this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp + 8 + n & 0xFFFF;
                this.cpu.eip = n2;
                this.cpu.cs = segment;
            }
        }
    }

    private final void ret_far_o32_a32(int n) {
        try {
            this.cpu.ss.checkAddress(this.cpu.esp + 7);
        }
        catch (ProcessorException processorException) {
            throw ProcessorException.STACK_SEGMENT_0;
        }
        int n2 = this.cpu.ss.getDoubleWord(this.cpu.esp);
        int n3 = 0xFFFF & this.cpu.ss.getDoubleWord(this.cpu.esp + 4);
        Segment segment = this.cpu.getSegment(n3);
        if (segment == SegmentFactory.NULL_SEGMENT) {
            throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, 0, true);
        }
        switch (segment.getType()) {
            default: {
                throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n3, true);
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                if (segment.getRPL() < this.cpu.getCPL()) {
                    throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n3, true);
                }
                if (!segment.isPresent()) {
                    throw new ProcessorException(ProcessorException.Type.NOT_PRESENT, n3, true);
                }
                if (segment.getRPL() > this.cpu.getCPL()) {
                    try {
                        this.cpu.ss.checkAddress(this.cpu.esp + 15);
                    }
                    catch (ProcessorException processorException) {
                        throw ProcessorException.STACK_SEGMENT_0;
                    }
                    int n4 = this.cpu.ss.getDoubleWord(this.cpu.esp + 8 + n);
                    int n5 = 0xFFFF & this.cpu.ss.getDoubleWord(this.cpu.esp + 12 + n);
                    Segment segment2 = this.cpu.getSegment(n5);
                    if (segment2.getRPL() != segment.getRPL() || (segment2.getType() & 0x12) != 18 || segment2.getDPL() != segment.getRPL()) {
                        throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n5, true);
                    }
                    if (!segment2.isPresent()) {
                        throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n5, true);
                    }
                    segment.checkAddress(n2);
                    this.cpu.eip = n2;
                    this.cpu.cs = segment;
                    this.cpu.ss = segment2;
                    this.cpu.esp = n4;
                    this.cpu.setCPL(this.cpu.cs.getRPL());
                    break;
                }
                segment.checkAddress(n2);
                this.cpu.esp += 8 + n;
                this.cpu.eip = n2;
                this.cpu.cs = segment;
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                if (segment.getRPL() < this.cpu.getCPL()) {
                    throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n3, true);
                }
                if (segment.getDPL() > segment.getRPL()) {
                    throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n3, true);
                }
                if (!segment.isPresent()) {
                    throw new ProcessorException(ProcessorException.Type.NOT_PRESENT, n3, true);
                }
                if (segment.getRPL() > this.cpu.getCPL()) {
                    System.err.println("Critical error: Conforming outer privilege level not implemented");
                    throw new IllegalStateException("O32 A32 RETF to conforming outer priviledge level not implemented");
                }
                segment.checkAddress(n2);
                this.cpu.esp += 8;
                this.cpu.eip = n2;
                this.cpu.cs = segment;
            }
        }
    }

    private final int iretToVirtual8086Mode16BitAddressing(int n, int n2, int n3) {
        try {
            this.cpu.ss.checkAddress(this.cpu.esp + 23 & 0xFFFF);
        }
        catch (ProcessorException processorException) {
            throw ProcessorException.STACK_SEGMENT_0;
        }
        this.cpu.cs = SegmentFactory.createVirtual8086ModeSegment(this.cpu.linearMemory, n, true);
        this.cpu.eip = n2 & 0xFFFF;
        int n4 = this.cpu.ss.getDoubleWord(this.cpu.esp & 0xFFFF);
        int n5 = 0xFFFF & this.cpu.ss.getDoubleWord(this.cpu.esp + 4 & 0xFFFF);
        this.cpu.es = SegmentFactory.createVirtual8086ModeSegment(this.cpu.linearMemory, 0xFFFF & this.cpu.ss.getDoubleWord(this.cpu.esp + 8 & 0xFFFF), false);
        this.cpu.ds = SegmentFactory.createVirtual8086ModeSegment(this.cpu.linearMemory, 0xFFFF & this.cpu.ss.getDoubleWord(this.cpu.esp + 12 & 0xFFFF), false);
        this.cpu.fs = SegmentFactory.createVirtual8086ModeSegment(this.cpu.linearMemory, 0xFFFF & this.cpu.ss.getDoubleWord(this.cpu.esp + 16 & 0xFFFF), false);
        this.cpu.gs = SegmentFactory.createVirtual8086ModeSegment(this.cpu.linearMemory, 0xFFFF & this.cpu.ss.getDoubleWord(this.cpu.esp + 20 & 0xFFFF), false);
        this.cpu.ss = SegmentFactory.createVirtual8086ModeSegment(this.cpu.linearMemory, n5, false);
        this.cpu.esp = n4;
        this.cpu.setCPL(3);
        return n3;
    }

    private final int iret32ProtectedMode16BitAddressing(int n, int n2, int n3) {
        Segment segment = this.cpu.getSegment(n);
        if (segment == SegmentFactory.NULL_SEGMENT) {
            throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, 0, true);
        }
        switch (segment.getType()) {
            default: {
                System.err.println("Emulated: Invalid segment type " + segment.getType() + ".");
                throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n, true);
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                if (segment.getRPL() < this.cpu.getCPL()) {
                    throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n, true);
                }
                if (!segment.isPresent()) {
                    throw new ProcessorException(ProcessorException.Type.NOT_PRESENT, n, true);
                }
                if (segment.getRPL() > this.cpu.getCPL()) {
                    try {
                        this.cpu.ss.checkAddress(this.cpu.esp + 7 & 0xFFFF);
                    }
                    catch (ProcessorException processorException) {
                        throw ProcessorException.STACK_SEGMENT_0;
                    }
                    int n4 = this.cpu.ss.getDoubleWord(this.cpu.esp & 0xFFFF);
                    int n5 = 0xFFFF & this.cpu.ss.getDoubleWord(this.cpu.esp + 4 & 0xFFFF);
                    Segment segment2 = this.cpu.getSegment(n5);
                    if (segment2.getRPL() != segment.getRPL() || (segment2.getType() & 0x12) != 18 || segment2.getDPL() != segment.getRPL()) {
                        throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n5, true);
                    }
                    if (!segment2.isPresent()) {
                        throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n5, true);
                    }
                    segment.checkAddress(n2);
                    this.cpu.eip = n2;
                    this.cpu.cs = segment;
                    this.cpu.ss = segment2;
                    this.cpu.esp = n4;
                    int n6 = this.cpu.getEFlags();
                    n6 &= 0xFFDAB22A;
                    n6 |= 0x254DD5 & n3;
                    if (this.cpu.getCPL() <= this.cpu.eflagsIOPrivilegeLevel) {
                        n6 &= 0xFFFFFDFF;
                        n6 |= 0x200 & n3;
                    }
                    if (this.cpu.getCPL() == 0) {
                        n6 &= 0xFFE5CFFF;
                        n6 |= 0x1A3000 & n3;
                    }
                    this.cpu.setCPL(this.cpu.cs.getRPL());
                    try {
                        if (((this.cpu.es.getType() & 0x18) == 16 || (this.cpu.es.getType() & 0x1C) == 24) && this.cpu.getCPL() > this.cpu.es.getDPL()) {
                            this.cpu.es = SegmentFactory.NULL_SEGMENT;
                        }
                    }
                    catch (ProcessorException processorException) {
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (((this.cpu.ds.getType() & 0x18) == 16 || (this.cpu.ds.getType() & 0x1C) == 24) && this.cpu.getCPL() > this.cpu.ds.getDPL()) {
                            this.cpu.ds = SegmentFactory.NULL_SEGMENT;
                        }
                    }
                    catch (ProcessorException processorException) {
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (((this.cpu.fs.getType() & 0x18) == 16 || (this.cpu.fs.getType() & 0x1C) == 24) && this.cpu.getCPL() > this.cpu.fs.getDPL()) {
                            this.cpu.fs = SegmentFactory.NULL_SEGMENT;
                        }
                    }
                    catch (ProcessorException processorException) {
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (((this.cpu.gs.getType() & 0x18) == 16 || (this.cpu.gs.getType() & 0x1C) == 24) && this.cpu.getCPL() > this.cpu.gs.getDPL()) {
                            this.cpu.gs = SegmentFactory.NULL_SEGMENT;
                        }
                    }
                    catch (ProcessorException processorException) {
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return n6;
                }
                segment.checkAddress(n2);
                this.cpu.cs = segment;
                this.cpu.eip = n2;
                int n7 = this.cpu.getEFlags();
                n7 &= 0xFFDAB22A;
                n7 |= 0x254DD5 & n3;
                if (this.cpu.getCPL() <= this.cpu.eflagsIOPrivilegeLevel) {
                    n7 &= 0xFFFFFDFF;
                    n7 |= 0x200 & n3;
                }
                if (this.cpu.getCPL() == 0) {
                    n7 &= 0xFFE5CFFF;
                    n7 |= 0x1A3000 & n3;
                }
                return n7;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
        }
        if (segment.getRPL() < this.cpu.getCPL()) {
            throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n, true);
        }
        if (segment.getDPL() > segment.getRPL()) {
            throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n, true);
        }
        if (!segment.isPresent()) {
            throw new ProcessorException(ProcessorException.Type.NOT_PRESENT, n, true);
        }
        if (segment.getRPL() > this.cpu.getCPL()) {
            System.err.println("Critical error: Conforming outer privilege level not implemented");
            throw new IllegalStateException("iret32ProtectedMode16BitAddressing to conforming outer priviledge level not implemented");
        }
        System.err.println("Critical error: Conforming same privilege level not implemented");
        throw new IllegalStateException("iret32ProtectedMode16BitAddressing to conforming same priviledge level not implemented");
    }

    private final int iret_o32_a16() {
        if (this.cpu.eflagsNestedTask) {
            return this.iretFromTask();
        }
        try {
            this.cpu.ss.checkAddress(this.cpu.esp + 11 & 0xFFFF);
        }
        catch (ProcessorException processorException) {
            throw ProcessorException.STACK_SEGMENT_0;
        }
        int n = this.cpu.ss.getDoubleWord(this.cpu.esp & 0xFFFF);
        int n2 = 0xFFFF & this.cpu.ss.getDoubleWord(this.cpu.esp + 4 & 0xFFFF);
        int n3 = this.cpu.ss.getDoubleWord(this.cpu.esp + 8 & 0xFFFF);
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp + 12 & 0xFFFF;
        if ((n3 & 0x20000) != 0 && this.cpu.getCPL() == 0) {
            return this.iretToVirtual8086Mode16BitAddressing(n2, n, n3);
        }
        return this.iret32ProtectedMode16BitAddressing(n2, n, n3);
    }

    private final int iretFromTask() {
        System.err.println("Critical error: iretFromTask().");
        throw new IllegalStateException("IRET with NT set not implemented");
    }

    private final int iretToVirtual8086Mode32BitAddressing(int n, int n2, int n3) {
        try {
            this.cpu.ss.checkAddress(this.cpu.esp + 23);
        }
        catch (ProcessorException processorException) {
            throw ProcessorException.STACK_SEGMENT_0;
        }
        if (n2 > 1048575) {
            throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, 0, true);
        }
        this.cpu.cs = SegmentFactory.createVirtual8086ModeSegment(this.cpu.linearMemory, n, true);
        this.cpu.eip = n2 & 0xFFFF;
        int n4 = this.cpu.ss.getDoubleWord(this.cpu.esp);
        int n5 = 0xFFFF & this.cpu.ss.getDoubleWord(this.cpu.esp + 4);
        this.cpu.es = SegmentFactory.createVirtual8086ModeSegment(this.cpu.linearMemory, 0xFFFF & this.cpu.ss.getDoubleWord(this.cpu.esp + 8), false);
        this.cpu.ds = SegmentFactory.createVirtual8086ModeSegment(this.cpu.linearMemory, 0xFFFF & this.cpu.ss.getDoubleWord(this.cpu.esp + 12), false);
        this.cpu.fs = SegmentFactory.createVirtual8086ModeSegment(this.cpu.linearMemory, 0xFFFF & this.cpu.ss.getDoubleWord(this.cpu.esp + 16), false);
        this.cpu.gs = SegmentFactory.createVirtual8086ModeSegment(this.cpu.linearMemory, 0xFFFF & this.cpu.ss.getDoubleWord(this.cpu.esp + 20), false);
        this.cpu.ss = SegmentFactory.createVirtual8086ModeSegment(this.cpu.linearMemory, n5, false);
        this.cpu.esp = n4;
        this.cpu.setCPL(3);
        return n3;
    }

    private final int iret32ProtectedMode32BitAddressing(int n, int n2, int n3) {
        Segment segment = this.cpu.getSegment(n);
        if (segment == SegmentFactory.NULL_SEGMENT) {
            throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, 0, true);
        }
        switch (segment.getType()) {
            default: {
                System.err.println("Emulated: Invalid segment type " + segment.getType() + ".");
                throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n, true);
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                if (segment.getRPL() < this.cpu.getCPL()) {
                    throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n, true);
                }
                if (!segment.isPresent()) {
                    throw new ProcessorException(ProcessorException.Type.NOT_PRESENT, n, true);
                }
                if (segment.getRPL() > this.cpu.getCPL()) {
                    try {
                        this.cpu.ss.checkAddress(this.cpu.esp + 7);
                    }
                    catch (ProcessorException processorException) {
                        throw ProcessorException.STACK_SEGMENT_0;
                    }
                    int n4 = this.cpu.ss.getDoubleWord(this.cpu.esp);
                    int n5 = 0xFFFF & this.cpu.ss.getDoubleWord(this.cpu.esp + 4);
                    Segment segment2 = this.cpu.getSegment(n5);
                    if (segment2.getRPL() != segment.getRPL() || (segment2.getType() & 0x12) != 18 || segment2.getDPL() != segment.getRPL()) {
                        throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n5, true);
                    }
                    if (!segment2.isPresent()) {
                        throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n5, true);
                    }
                    segment.checkAddress(n2);
                    this.cpu.eip = n2;
                    this.cpu.cs = segment;
                    this.cpu.ss = segment2;
                    this.cpu.esp = n4;
                    int n6 = this.cpu.getEFlags();
                    n6 &= 0xFFDAB22A;
                    n6 |= 0x254DD5 & n3;
                    if (this.cpu.getCPL() <= this.cpu.eflagsIOPrivilegeLevel) {
                        n6 &= 0xFFFFFDFF;
                        n6 |= 0x200 & n3;
                    }
                    if (this.cpu.getCPL() == 0) {
                        n6 &= 0xFFE5CFFF;
                        n6 |= 0x1A3000 & n3;
                    }
                    this.cpu.setCPL(this.cpu.cs.getRPL());
                    try {
                        if (((this.cpu.es.getType() & 0x18) == 16 || (this.cpu.es.getType() & 0x1C) == 24) && this.cpu.getCPL() > this.cpu.es.getDPL()) {
                            this.cpu.es = SegmentFactory.NULL_SEGMENT;
                        }
                    }
                    catch (ProcessorException processorException) {
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (((this.cpu.ds.getType() & 0x18) == 16 || (this.cpu.ds.getType() & 0x1C) == 24) && this.cpu.getCPL() > this.cpu.ds.getDPL()) {
                            this.cpu.ds = SegmentFactory.NULL_SEGMENT;
                        }
                    }
                    catch (ProcessorException processorException) {
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (((this.cpu.fs.getType() & 0x18) == 16 || (this.cpu.fs.getType() & 0x1C) == 24) && this.cpu.getCPL() > this.cpu.fs.getDPL()) {
                            this.cpu.fs = SegmentFactory.NULL_SEGMENT;
                        }
                    }
                    catch (ProcessorException processorException) {
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (((this.cpu.gs.getType() & 0x18) == 16 || (this.cpu.gs.getType() & 0x1C) == 24) && this.cpu.getCPL() > this.cpu.gs.getDPL()) {
                            this.cpu.gs = SegmentFactory.NULL_SEGMENT;
                        }
                    }
                    catch (ProcessorException processorException) {
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return n6;
                }
                segment.checkAddress(n2);
                this.cpu.cs = segment;
                this.cpu.eip = n2;
                int n7 = this.cpu.getEFlags();
                n7 &= 0xFFDAB22A;
                n7 |= 0x254DD5 & n3;
                if (this.cpu.getCPL() <= this.cpu.eflagsIOPrivilegeLevel) {
                    n7 &= 0xFFFFFDFF;
                    n7 |= 0x200 & n3;
                }
                if (this.cpu.getCPL() == 0) {
                    n7 &= 0xFFE5CFFF;
                    n7 |= 0x1A3000 & n3;
                }
                return n7;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
        }
        if (segment.getRPL() < this.cpu.getCPL()) {
            throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n, true);
        }
        if (segment.getDPL() > segment.getRPL()) {
            throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n, true);
        }
        if (!segment.isPresent()) {
            throw new ProcessorException(ProcessorException.Type.NOT_PRESENT, n, true);
        }
        if (segment.getRPL() > this.cpu.getCPL()) {
            System.err.println("Critical error: Conforming outer privilege level not implemented");
            throw new IllegalStateException("iret32ProtectedMode32BitAddressing to conforming outer privilege level not implemented");
        }
        segment.checkAddress(n2);
        this.cpu.eip = n2;
        this.cpu.cs = segment;
        this.cpu.setCarryFlag((n3 & 1) != 0);
        this.cpu.setParityFlag((n3 & 4) != 0);
        this.cpu.setAuxiliaryCarryFlag((n3 & 0x10) != 0);
        this.cpu.setZeroFlag((n3 & 0x40) != 0);
        this.cpu.setSignFlag((n3 & 0x80) != 0);
        this.cpu.eflagsTrap = (n3 & 0x100) != 0;
        this.cpu.eflagsDirection = (n3 & 0x400) != 0;
        this.cpu.setOverflowFlag((n3 & 0x800) != 0);
        this.cpu.eflagsNestedTask = (n3 & 0x4000) != 0;
        this.cpu.eflagsResume = (n3 & 0x10000) != 0;
        this.cpu.eflagsAlignmentCheck = (n3 & 0x40000) != 0;
        boolean bl = this.cpu.eflagsID = (n3 & 0x200000) != 0;
        if (this.cpu.getCPL() <= this.cpu.eflagsIOPrivilegeLevel) {
            this.cpu.eflagsInterruptEnable = (n3 & 0x200) != 0;
            this.cpu.eflagsInterruptEnableSoon = this.cpu.eflagsInterruptEnable;
        }
        if (this.cpu.getCPL() == 0) {
            this.cpu.eflagsIOPrivilegeLevel = n3 >> 12 & 3;
            this.cpu.eflagsVirtual8086Mode = (n3 & 0x20000) != 0;
            this.cpu.eflagsVirtualInterrupt = (n3 & 0x80000) != 0;
            this.cpu.eflagsVirtualInterruptPending = (n3 & 0x100000) != 0;
        }
        return n3;
    }

    private final int iret_o32_a32() {
        if (this.cpu.eflagsNestedTask) {
            return this.iretFromTask();
        }
        try {
            this.cpu.ss.checkAddress(this.cpu.esp + 11);
        }
        catch (ProcessorException processorException) {
            throw ProcessorException.STACK_SEGMENT_0;
        }
        int n = this.cpu.ss.getDoubleWord(this.cpu.esp);
        int n2 = 0xFFFF & this.cpu.ss.getDoubleWord(this.cpu.esp + 4);
        int n3 = this.cpu.ss.getDoubleWord(this.cpu.esp + 8);
        this.cpu.esp += 12;
        if ((n3 & 0x20000) != 0 && this.cpu.getCPL() == 0) {
            return this.iretToVirtual8086Mode32BitAddressing(n2, n, n3);
        }
        return this.iret32ProtectedMode32BitAddressing(n2, n, n3);
    }

    private final int iret_o16_a16() {
        if (this.cpu.eflagsNestedTask) {
            return this.iretFromTask();
        }
        try {
            this.cpu.ss.checkAddress(this.cpu.esp + 5 & 0xFFFF);
        }
        catch (ProcessorException processorException) {
            throw ProcessorException.STACK_SEGMENT_0;
        }
        int n = 0xFFFF & this.cpu.ss.getWord(this.cpu.esp & 0xFFFF);
        int n2 = 0xFFFF & this.cpu.ss.getWord(this.cpu.esp + 2 & 0xFFFF);
        int n3 = 0xFFFF & this.cpu.ss.getWord(this.cpu.esp + 4 & 0xFFFF);
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp + 6 & 0xFFFF;
        return this.iret16ProtectedMode16BitAddressing(n2, n, n3);
    }

    private final int iret_o16_a32() {
        if (this.cpu.eflagsNestedTask) {
            return this.iretFromTask();
        }
        try {
            this.cpu.ss.checkAddress(this.cpu.esp + 5);
        }
        catch (ProcessorException processorException) {
            throw ProcessorException.STACK_SEGMENT_0;
        }
        int n = 0xFFFF & this.cpu.ss.getWord(this.cpu.esp);
        int n2 = 0xFFFF & this.cpu.ss.getWord(this.cpu.esp + 4);
        int n3 = 0xFFFF & this.cpu.ss.getWord(this.cpu.esp + 8);
        this.cpu.esp += 12;
        return this.iret16ProtectedMode32BitAddressing(n2, n, n3);
    }

    private final int iret16ProtectedMode16BitAddressing(int n, int n2, int n3) {
        Segment segment = this.cpu.getSegment(n);
        if (segment == SegmentFactory.NULL_SEGMENT) {
            throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, 0, true);
        }
        switch (segment.getType()) {
            default: {
                System.err.println("Emulated: Invalid segment type " + segment.getType() + ".");
                throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n, true);
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                if (segment.getRPL() < this.cpu.getCPL()) {
                    throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n, true);
                }
                if (!segment.isPresent()) {
                    throw new ProcessorException(ProcessorException.Type.NOT_PRESENT, n, true);
                }
                if (segment.getRPL() > this.cpu.getCPL()) {
                    try {
                        this.cpu.ss.checkAddress(this.cpu.esp + 3 & 0xFFFF);
                    }
                    catch (ProcessorException processorException) {
                        throw ProcessorException.STACK_SEGMENT_0;
                    }
                    int n4 = 0xFFFF & this.cpu.ss.getWord(this.cpu.esp & 0xFFFF);
                    int n5 = 0xFFFF & this.cpu.ss.getWord(this.cpu.esp + 2 & 0xFFFF);
                    Segment segment2 = this.cpu.getSegment(n5);
                    if (segment2.getRPL() != segment.getRPL() || (segment2.getType() & 0x12) != 18 || segment2.getDPL() != segment.getRPL()) {
                        throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n5, true);
                    }
                    if (!segment2.isPresent()) {
                        throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n5, true);
                    }
                    segment.checkAddress(n2);
                    this.cpu.eip = n2;
                    this.cpu.cs = segment;
                    this.cpu.ss = segment2;
                    this.cpu.esp = n4;
                    int n6 = this.cpu.getEFlags();
                    n6 &= 0xFFFFB22A;
                    n6 |= 0x4DD5 & n3;
                    if (this.cpu.getCPL() <= this.cpu.eflagsIOPrivilegeLevel) {
                        n6 &= 0xFFFFFDFF;
                        n6 |= 0x200 & n3;
                    }
                    if (this.cpu.getCPL() == 0) {
                        n6 &= 0xFFFFCFFF;
                        n6 |= 0x3000 & n3;
                    }
                    this.cpu.setCPL(this.cpu.cs.getRPL());
                    try {
                        if (((this.cpu.es.getType() & 0x18) == 16 || (this.cpu.es.getType() & 0x1C) == 24) && this.cpu.getCPL() > this.cpu.es.getDPL()) {
                            this.cpu.es = SegmentFactory.NULL_SEGMENT;
                        }
                    }
                    catch (ProcessorException processorException) {
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (((this.cpu.ds.getType() & 0x18) == 16 || (this.cpu.ds.getType() & 0x1C) == 24) && this.cpu.getCPL() > this.cpu.ds.getDPL()) {
                            this.cpu.ds = SegmentFactory.NULL_SEGMENT;
                        }
                    }
                    catch (ProcessorException processorException) {
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (((this.cpu.fs.getType() & 0x18) == 16 || (this.cpu.fs.getType() & 0x1C) == 24) && this.cpu.getCPL() > this.cpu.fs.getDPL()) {
                            this.cpu.fs = SegmentFactory.NULL_SEGMENT;
                        }
                    }
                    catch (ProcessorException processorException) {
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (((this.cpu.gs.getType() & 0x18) == 16 || (this.cpu.gs.getType() & 0x1C) == 24) && this.cpu.getCPL() > this.cpu.gs.getDPL()) {
                            this.cpu.gs = SegmentFactory.NULL_SEGMENT;
                        }
                    }
                    catch (ProcessorException processorException) {
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return n6;
                }
                segment.checkAddress(n2);
                this.cpu.cs = segment;
                this.cpu.eip = n2;
                int n7 = this.cpu.getEFlags();
                n7 &= 0xFFFFB22A;
                n7 |= 0x4DD5 & n3;
                if (this.cpu.getCPL() <= this.cpu.eflagsIOPrivilegeLevel) {
                    n7 &= 0xFFFFFDFF;
                    n7 |= 0x200 & n3;
                }
                if (this.cpu.getCPL() == 0) {
                    n7 &= 0xFFFFCFFF;
                    n7 |= 0x3000 & n3;
                }
                return n7;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
        }
        if (segment.getRPL() < this.cpu.getCPL()) {
            throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n, true);
        }
        if (segment.getDPL() > segment.getRPL()) {
            throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n, true);
        }
        if (!segment.isPresent()) {
            throw new ProcessorException(ProcessorException.Type.NOT_PRESENT, n, true);
        }
        if (segment.getRPL() > this.cpu.getCPL()) {
            System.err.println("Critical error: Conforming outer privilege level not implemented");
            throw new IllegalStateException("iret16ProtectedMode16BitAddressing to conforming outer privilege level not implemented");
        }
        System.err.println("Critical error: Conforming same privilege level not implemented");
        throw new IllegalStateException("iret16ProtectedMode16BitAddressing to conforming same privilege level not implemented");
    }

    private final int iret16ProtectedMode32BitAddressing(int n, int n2, int n3) {
        Segment segment = this.cpu.getSegment(n);
        if (segment == SegmentFactory.NULL_SEGMENT) {
            throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, 0, true);
        }
        switch (segment.getType()) {
            default: {
                System.err.println("Emulated: Invalid segment type " + segment.getType() + ".");
                throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n, true);
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                if (segment.getRPL() < this.cpu.getCPL()) {
                    throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n, true);
                }
                if (!segment.isPresent()) {
                    throw new ProcessorException(ProcessorException.Type.NOT_PRESENT, n, true);
                }
                if (segment.getRPL() > this.cpu.getCPL()) {
                    try {
                        this.cpu.ss.checkAddress(this.cpu.esp + 3);
                    }
                    catch (ProcessorException processorException) {
                        throw ProcessorException.STACK_SEGMENT_0;
                    }
                    int n4 = 0xFFFF & this.cpu.ss.getWord(this.cpu.esp);
                    int n5 = 0xFFFF & this.cpu.ss.getWord(this.cpu.esp + 2);
                    Segment segment2 = this.cpu.getSegment(n5);
                    if (segment2.getRPL() != segment.getRPL() || (segment2.getType() & 0x12) != 18 || segment2.getDPL() != segment.getRPL()) {
                        throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n5, true);
                    }
                    if (!segment2.isPresent()) {
                        throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n5, true);
                    }
                    segment.checkAddress(n2);
                    this.cpu.eip = n2;
                    this.cpu.cs = segment;
                    this.cpu.ss = segment2;
                    this.cpu.esp = n4;
                    int n6 = this.cpu.getEFlags();
                    n6 &= 0xFFFFB22A;
                    n6 |= 0x4DD5 & n3;
                    if (this.cpu.getCPL() <= this.cpu.eflagsIOPrivilegeLevel) {
                        n6 &= 0xFFFFFDFF;
                        n6 |= 0x200 & n3;
                    }
                    if (this.cpu.getCPL() == 0) {
                        n6 &= 0xFFFFCFFF;
                        n6 |= 0x3000 & n3;
                    }
                    this.cpu.setCPL(this.cpu.cs.getRPL());
                    try {
                        if (((this.cpu.es.getType() & 0x18) == 16 || (this.cpu.es.getType() & 0x1C) == 24) && this.cpu.getCPL() > this.cpu.es.getDPL()) {
                            this.cpu.es = SegmentFactory.NULL_SEGMENT;
                        }
                    }
                    catch (ProcessorException processorException) {
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (((this.cpu.ds.getType() & 0x18) == 16 || (this.cpu.ds.getType() & 0x1C) == 24) && this.cpu.getCPL() > this.cpu.ds.getDPL()) {
                            this.cpu.ds = SegmentFactory.NULL_SEGMENT;
                        }
                    }
                    catch (ProcessorException processorException) {
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (((this.cpu.fs.getType() & 0x18) == 16 || (this.cpu.fs.getType() & 0x1C) == 24) && this.cpu.getCPL() > this.cpu.fs.getDPL()) {
                            this.cpu.fs = SegmentFactory.NULL_SEGMENT;
                        }
                    }
                    catch (ProcessorException processorException) {
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (((this.cpu.gs.getType() & 0x18) == 16 || (this.cpu.gs.getType() & 0x1C) == 24) && this.cpu.getCPL() > this.cpu.gs.getDPL()) {
                            this.cpu.gs = SegmentFactory.NULL_SEGMENT;
                        }
                    }
                    catch (ProcessorException processorException) {
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return n6;
                }
                segment.checkAddress(n2);
                this.cpu.cs = segment;
                this.cpu.eip = n2;
                int n7 = this.cpu.getEFlags();
                n7 &= 0xFFFFB22A;
                n7 |= 0x4DD5 & n3;
                if (this.cpu.getCPL() <= this.cpu.eflagsIOPrivilegeLevel) {
                    n7 &= 0xFFFFFDFF;
                    n7 |= 0x200 & n3;
                }
                if (this.cpu.getCPL() == 0) {
                    n7 &= 0xFFFFCFFF;
                    n7 |= 0x3000 & n3;
                }
                return n7;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
        }
        if (segment.getRPL() < this.cpu.getCPL()) {
            throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n, true);
        }
        if (segment.getDPL() > segment.getRPL()) {
            throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n, true);
        }
        if (!segment.isPresent()) {
            throw new ProcessorException(ProcessorException.Type.NOT_PRESENT, n, true);
        }
        if (segment.getRPL() > this.cpu.getCPL()) {
            System.err.println("Critical error: Conforming outer privilege level not implemented");
            throw new IllegalStateException("iret16ProtectedMode32BitAddressing to conforming outer privilege level not implemented");
        }
        System.err.println("Critical error: Conforming same privilege level not implemented");
        throw new IllegalStateException("iret16ProtectedMode32BitAddressing to conforming same privilege level not implemented");
    }

    private final void sysenter() {
        int n = (int)this.cpu.getMSR(372);
        if (n == 0) {
            throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, 0, true);
        }
        this.cpu.eflagsInterruptEnableSoon = false;
        this.cpu.eflagsInterruptEnable = false;
        this.cpu.eflagsResume = false;
        this.cpu.cs = SegmentFactory.createProtectedModeSegment(this.cpu.linearMemory, n & 0xFFFC, 58435744481476607L);
        this.cpu.setCPL(0);
        this.cpu.ss = SegmentFactory.createProtectedModeSegment(this.cpu.linearMemory, n + 8 & 0xFFFC, 58426948388454399L);
        this.cpu.esp = (int)this.cpu.getMSR(373);
        this.cpu.eip = (int)this.cpu.getMSR(374);
    }

    private final void sysexit(int n, int n2) {
        int n3 = (int)this.cpu.getMSR(372);
        if (n3 == 0) {
            throw ProcessorException.GENERAL_PROTECTION_0;
        }
        if (this.cpu.getCPL() != 0) {
            throw ProcessorException.GENERAL_PROTECTION_0;
        }
        this.cpu.cs = SegmentFactory.createProtectedModeSegment(this.cpu.linearMemory, n3 + 16 | 3, 58541297597743103L);
        this.cpu.setCPL(3);
        this.cpu.ss = SegmentFactory.createProtectedModeSegment(this.cpu.linearMemory, n3 + 24 | 3, 58532501504720895L);
        this.cpu.correctAlignmentChecking(this.cpu.ss);
        this.cpu.esp = n;
        this.cpu.eip = n2;
    }

    private final int in_o8(int n) {
        if (this.checkIOPermissionsByte(n)) {
            return 0xFF & this.cpu.ioports.ioPortReadByte(n);
        }
        System.err.println("Emulated: denied access to io port 0x" + Integer.toHexString(n) + " at cpl " + this.cpu.getCPL() + ".");
        throw ProcessorException.GENERAL_PROTECTION_0;
    }

    private final int in_o16(int n) {
        if (this.checkIOPermissionsShort(n)) {
            return 0xFFFF & this.cpu.ioports.ioPortReadWord(n);
        }
        System.err.println("Emulated: denied access to io port 0x" + Integer.toHexString(n) + " at cpl " + this.cpu.getCPL() + ".");
        throw ProcessorException.GENERAL_PROTECTION_0;
    }

    private final int in_o32(int n) {
        if (this.checkIOPermissionsInt(n)) {
            return this.cpu.ioports.ioPortReadLong(n);
        }
        System.err.println("Emulated: denied access to io port 0x" + Integer.toHexString(n) + " at cpl " + this.cpu.getCPL() + ".");
        throw ProcessorException.GENERAL_PROTECTION_0;
    }

    private final void out_o8(int n, int n2) {
        if (!this.checkIOPermissionsByte(n)) {
            System.err.println("Emulated: denied access to io port 0x" + Integer.toHexString(n) + " at cpl " + this.cpu.getCPL() + ".");
            throw ProcessorException.GENERAL_PROTECTION_0;
        }
        this.cpu.ioports.ioPortWriteByte(n, 0xFF & n2);
    }

    private final void out_o16(int n, int n2) {
        if (!this.checkIOPermissionsShort(n)) {
            System.err.println("Emulated: denied access to io port 0x" + Integer.toHexString(n) + " at cpl " + this.cpu.getCPL() + ".");
            throw ProcessorException.GENERAL_PROTECTION_0;
        }
        this.cpu.ioports.ioPortWriteWord(n, 0xFFFF & n2);
    }

    private final void out_o32(int n, int n2) {
        if (!this.checkIOPermissionsInt(n)) {
            System.err.println("Emulated: denied access to io port 0x" + Integer.toHexString(n) + " at cpl " + this.cpu.getCPL() + ".");
            throw ProcessorException.GENERAL_PROTECTION_0;
        }
        this.cpu.ioports.ioPortWriteLong(n, n2);
    }

    private final void enter_o16_a16(int n, int n2) {
        int n3 = 0xFFFF & this.cpu.esp;
        int n4 = 0xFFFF & this.cpu.ebp;
        if ((n2 %= 32) == 0 ? n3 < 2 + n && n3 > 0 : n3 < 2 + n + 2 * n2 && n3 > 0) {
            throw ProcessorException.STACK_SEGMENT_0;
        }
        this.cpu.ss.setWord(n3 -= 2, (short)n4);
        int n5 = n3;
        if (n2 > 0) {
            while (--n2 != 0) {
                this.cpu.ss.setWord(n3 -= 2, (short)(0xFFFF & this.cpu.ss.getWord(n4 -= 2)));
            }
            this.cpu.ss.setWord(n3 -= 2, (short)n5);
        }
        this.cpu.ebp = this.cpu.ebp & 0xFFFF0000 | 0xFFFF & n5;
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | 0xFFFF & n5 - n - 2 * n2;
    }

    private final void enter_o16_a32(int n, int n2) {
        int n3 = this.cpu.esp;
        int n4 = this.cpu.ebp;
        if ((n2 %= 32) == 0 ? n3 < 2 + n && n3 > 0 : n3 < 2 + n + 2 * n2 && n3 > 0) {
            throw ProcessorException.STACK_SEGMENT_0;
        }
        this.cpu.ss.setWord(n3 -= 2, (short)n4);
        int n5 = n3;
        if (n2 > 0) {
            int n6 = n2;
            while (--n6 != 0) {
                this.cpu.ss.setWord(n3 -= 2, this.cpu.ss.getWord(n4 -= 2));
            }
            this.cpu.ss.setWord(n3 -= 2, (short)n5);
        }
        this.cpu.ebp = n5;
        this.cpu.esp = n5 - n - 2 * n2;
    }

    private final void enter_o32_a32(int n, int n2) {
        int n3 = this.cpu.esp;
        int n4 = this.cpu.ebp;
        if ((n2 %= 32) == 0 ? n3 < 4 + n && n3 > 0 : n3 < 4 + n + 4 * n2 && n3 > 0) {
            throw ProcessorException.STACK_SEGMENT_0;
        }
        this.cpu.ss.setDoubleWord(n3 -= 4, n4);
        int n5 = n3;
        int n6 = n2;
        if (n2 != 0) {
            while (--n6 != 0) {
                this.cpu.ss.setDoubleWord(n3 -= 4, this.cpu.ss.getDoubleWord(n4 -= 4));
            }
            this.cpu.ss.setDoubleWord(n3 -= 4, n5);
        }
        this.cpu.ebp = n5;
        this.cpu.esp = n5 - n - 4 * n2;
    }

    private final void leave_o32_a16() {
        this.cpu.ss.checkAddress(this.cpu.ebp & 0xFFFF);
        int n = this.cpu.ebp & 0xFFFF;
        int n2 = this.cpu.ss.getDoubleWord(n);
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | n + 4 & 0xFFFF;
        this.cpu.ebp = n2;
    }

    private final void leave_o32_a32() {
        this.cpu.ss.checkAddress(this.cpu.ebp);
        int n = this.cpu.ebp;
        int n2 = this.cpu.ss.getDoubleWord(n);
        this.cpu.esp = n + 4;
        this.cpu.ebp = n2;
    }

    private final void leave_o16_a16() {
        this.cpu.ss.checkAddress(this.cpu.ebp & 0xFFFF);
        int n = this.cpu.ebp & 0xFFFF;
        int n2 = 0xFFFF & this.cpu.ss.getWord(n);
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | n + 2 & 0xFFFF;
        this.cpu.ebp = this.cpu.ebp & 0xFFFF0000 | n2;
    }

    private final void leave_o16_a32() {
        this.cpu.ss.checkAddress(this.cpu.ebp);
        int n = this.cpu.ebp;
        int n2 = 0xFFFF & this.cpu.ss.getWord(n);
        this.cpu.esp = n + 2;
        this.cpu.ebp = this.cpu.ebp & 0xFFFF0000 | n2;
    }

    private final void push_o32_a32(int n) {
        if (this.cpu.esp < 4 && this.cpu.esp > 0) {
            throw ProcessorException.STACK_SEGMENT_0;
        }
        this.cpu.ss.setDoubleWord(this.cpu.esp - 4, n);
        this.cpu.esp -= 4;
    }

    private final void push_o32_a16(int n) {
        if ((0xFFFF & this.cpu.esp) < 4 && (0xFFFF & this.cpu.esp) > 0) {
            throw ProcessorException.STACK_SEGMENT_0;
        }
        this.cpu.ss.setDoubleWord(this.cpu.esp - 4 & 0xFFFF, n);
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp - 4 & 0xFFFF;
    }

    private final void push_o16_a32(short s) {
        if (this.cpu.esp < 2 && this.cpu.esp > 0) {
            throw ProcessorException.STACK_SEGMENT_0;
        }
        this.cpu.ss.setWord(this.cpu.esp - 2, s);
        this.cpu.esp -= 2;
    }

    private final void push_o16_a16(short s) {
        if ((0xFFFF & this.cpu.esp) < 2 && (0xFFFF & this.cpu.esp) > 0) {
            throw ProcessorException.STACK_SEGMENT_0;
        }
        this.cpu.ss.setWord((0xFFFF & this.cpu.esp) - 2 & 0xFFFF, s);
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp - 2 & 0xFFFF;
    }

    private final void pushad_a32() {
        int n = this.cpu.esp;
        int n2 = this.cpu.esp;
        if (n < 32 && n > 0) {
            throw ProcessorException.STACK_SEGMENT_0;
        }
        this.cpu.ss.setDoubleWord(n -= 4, this.cpu.eax);
        this.cpu.ss.setDoubleWord(n -= 4, this.cpu.ecx);
        this.cpu.ss.setDoubleWord(n -= 4, this.cpu.edx);
        this.cpu.ss.setDoubleWord(n -= 4, this.cpu.ebx);
        this.cpu.ss.setDoubleWord(n -= 4, n2);
        this.cpu.ss.setDoubleWord(n -= 4, this.cpu.ebp);
        this.cpu.ss.setDoubleWord(n -= 4, this.cpu.esi);
        this.cpu.ss.setDoubleWord(n -= 4, this.cpu.edi);
        this.cpu.esp = n;
    }

    private final void pushad_a16() {
        int n = 0xFFFF & this.cpu.esp;
        int n2 = 0xFFFF & this.cpu.esp;
        if (n < 32 && n > 0) {
            throw ProcessorException.STACK_SEGMENT_0;
        }
        this.cpu.ss.setDoubleWord(n -= 4, this.cpu.eax);
        this.cpu.ss.setDoubleWord(n -= 4, this.cpu.ecx);
        this.cpu.ss.setDoubleWord(n -= 4, this.cpu.edx);
        this.cpu.ss.setDoubleWord(n -= 4, this.cpu.ebx);
        this.cpu.ss.setDoubleWord(n -= 4, n2);
        this.cpu.ss.setDoubleWord(n -= 4, this.cpu.ebp);
        this.cpu.ss.setDoubleWord(n -= 4, this.cpu.esi);
        this.cpu.ss.setDoubleWord(n -= 4, this.cpu.edi);
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | 0xFFFF & n;
    }

    private final void pusha_a32() {
        int n = this.cpu.esp;
        int n2 = this.cpu.esp;
        if (n < 16 && n > 0) {
            throw ProcessorException.STACK_SEGMENT_0;
        }
        this.cpu.ss.setWord(n -= 2, (short)(0xFFFF & this.cpu.eax));
        this.cpu.ss.setWord(n -= 2, (short)(0xFFFF & this.cpu.ecx));
        this.cpu.ss.setWord(n -= 2, (short)(0xFFFF & this.cpu.edx));
        this.cpu.ss.setWord(n -= 2, (short)(0xFFFF & this.cpu.ebx));
        this.cpu.ss.setWord(n -= 2, (short)(0xFFFF & n2));
        this.cpu.ss.setWord(n -= 2, (short)(0xFFFF & this.cpu.ebp));
        this.cpu.ss.setWord(n -= 2, (short)(0xFFFF & this.cpu.esi));
        this.cpu.ss.setWord(n -= 2, (short)(0xFFFF & this.cpu.edi));
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | n & 0xFFFF;
    }

    private final void pusha_a16() {
        int n = 0xFFFF & this.cpu.esp;
        int n2 = 0xFFFF & this.cpu.esp;
        if (n < 16 && n > 0) {
            throw ProcessorException.STACK_SEGMENT_0;
        }
        this.cpu.ss.setWord(n -= 2, (short)this.cpu.eax);
        this.cpu.ss.setWord(n -= 2, (short)this.cpu.ecx);
        this.cpu.ss.setWord(n -= 2, (short)this.cpu.edx);
        this.cpu.ss.setWord(n -= 2, (short)this.cpu.ebx);
        this.cpu.ss.setWord(n -= 2, (short)n2);
        this.cpu.ss.setWord(n -= 2, (short)this.cpu.ebp);
        this.cpu.ss.setWord(n -= 2, (short)this.cpu.esi);
        this.cpu.ss.setWord(n -= 2, (short)this.cpu.edi);
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | 0xFFFF & n;
    }

    private final void popa_a16() {
        int n = 0xFFFF & this.cpu.esp;
        int n2 = this.cpu.edi & 0xFFFF0000 | 0xFFFF & this.cpu.ss.getWord(n);
        int n3 = this.cpu.esi & 0xFFFF0000 | 0xFFFF & this.cpu.ss.getWord(n += 2);
        int n4 = this.cpu.ebp & 0xFFFF0000 | 0xFFFF & this.cpu.ss.getWord(n += 2);
        int n5 = this.cpu.ebx & 0xFFFF0000 | 0xFFFF & this.cpu.ss.getWord(n += 4);
        int n6 = this.cpu.edx & 0xFFFF0000 | 0xFFFF & this.cpu.ss.getWord(n += 2);
        int n7 = this.cpu.ecx & 0xFFFF0000 | 0xFFFF & this.cpu.ss.getWord(n += 2);
        int n8 = this.cpu.eax & 0xFFFF0000 | 0xFFFF & this.cpu.ss.getWord(n += 2);
        n += 2;
        this.cpu.edi = n2;
        this.cpu.esi = n3;
        this.cpu.ebp = n4;
        this.cpu.ebx = n5;
        this.cpu.edx = n6;
        this.cpu.ecx = n7;
        this.cpu.eax = n8;
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | n & 0xFFFF;
    }

    private final void popad_a16() {
        int n = 0xFFFF & this.cpu.esp;
        int n2 = this.cpu.ss.getDoubleWord(n);
        int n3 = this.cpu.ss.getDoubleWord(n += 4);
        int n4 = this.cpu.ss.getDoubleWord(n += 4);
        int n5 = this.cpu.ss.getDoubleWord(n += 8);
        int n6 = this.cpu.ss.getDoubleWord(n += 4);
        int n7 = this.cpu.ss.getDoubleWord(n += 4);
        int n8 = this.cpu.ss.getDoubleWord(n += 4);
        n += 4;
        this.cpu.edi = n2;
        this.cpu.esi = n3;
        this.cpu.ebp = n4;
        this.cpu.ebx = n5;
        this.cpu.edx = n6;
        this.cpu.ecx = n7;
        this.cpu.eax = n8;
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | n & 0xFFFF;
    }

    private final void popa_a32() {
        int n = this.cpu.esp;
        int n2 = this.cpu.edi & 0xFFFF0000 | 0xFFFF & this.cpu.ss.getWord(n);
        int n3 = this.cpu.esi & 0xFFFF0000 | 0xFFFF & this.cpu.ss.getWord(n += 2);
        int n4 = this.cpu.ebp & 0xFFFF0000 | 0xFFFF & this.cpu.ss.getWord(n += 2);
        int n5 = this.cpu.ebx & 0xFFFF0000 | 0xFFFF & this.cpu.ss.getWord(n += 4);
        int n6 = this.cpu.edx & 0xFFFF0000 | 0xFFFF & this.cpu.ss.getWord(n += 2);
        int n7 = this.cpu.ecx & 0xFFFF0000 | 0xFFFF & this.cpu.ss.getWord(n += 2);
        int n8 = this.cpu.eax & 0xFFFF0000 | 0xFFFF & this.cpu.ss.getWord(n += 2);
        n += 2;
        this.cpu.edi = n2;
        this.cpu.esi = n3;
        this.cpu.ebp = n4;
        this.cpu.ebx = n5;
        this.cpu.edx = n6;
        this.cpu.ecx = n7;
        this.cpu.eax = n8;
        this.cpu.esp = n;
    }

    private final void popad_a32() {
        int n = this.cpu.esp;
        int n2 = this.cpu.ss.getDoubleWord(n);
        int n3 = this.cpu.ss.getDoubleWord(n += 4);
        int n4 = this.cpu.ss.getDoubleWord(n += 4);
        int n5 = this.cpu.ss.getDoubleWord(n += 8);
        int n6 = this.cpu.ss.getDoubleWord(n += 4);
        int n7 = this.cpu.ss.getDoubleWord(n += 4);
        int n8 = this.cpu.ss.getDoubleWord(n += 4);
        n += 4;
        this.cpu.edi = n2;
        this.cpu.esi = n3;
        this.cpu.ebp = n4;
        this.cpu.ebx = n5;
        this.cpu.edx = n6;
        this.cpu.ecx = n7;
        this.cpu.eax = n8;
        this.cpu.esp = n;
    }

    private final int lar(int n, int n2) {
        if ((n & 0xFFC) == 0) {
            this.cpu.setZeroFlag(false);
            return n2;
        }
        int n3 = n & 0xFFF8;
        boolean[] blArray = new boolean[]{false, true, true, true, true, true, false, false, false, true, false, true, true, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true};
        Segment segment = (n & 4) != 0 ? this.cpu.ldtr : this.cpu.gdtr;
        if (n3 + 7 > segment.getLimit()) {
            this.cpu.setZeroFlag(false);
            return n2;
        }
        int n4 = this.cpu.readSupervisorDoubleWord(segment, n3 + 4);
        int n5 = (n4 & 0x1F00) >> 8;
        int n6 = (n4 & 0x6000) >> 13;
        int n7 = n & 3;
        int n8 = 12;
        if ((n5 & n8) != n8 && (this.cpu.getCPL() > n6 || n7 > n6) || !blArray[n5]) {
            this.cpu.setZeroFlag(false);
            return n2;
        }
        this.cpu.setZeroFlag(true);
        return n4 & 0xFFFF00;
    }

    private final int lsl(int n, int n2) {
        int n3 = n & 0xFFF8;
        boolean[] blArray = new boolean[]{false, true, true, true, true, true, false, false, false, true, false, true, true, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true};
        Segment segment = (n & 4) != 0 ? this.cpu.ldtr : this.cpu.gdtr;
        if (n3 + 8 > segment.getLimit()) {
            this.cpu.setZeroFlag(false);
            return n2;
        }
        int n4 = this.cpu.readSupervisorDoubleWord(segment, n3 + 4);
        int n5 = (n4 & 0x1F00) >> 8;
        int n6 = (n4 & 0x6000) >> 13;
        int n7 = n & 3;
        int n8 = 12;
        if ((n5 & n8) != n8 && (this.cpu.getCPL() > n6 || n7 > n6) || !blArray[n5]) {
            this.cpu.setZeroFlag(false);
            return n2;
        }
        int n9 = (n & 4) != 0 ? this.cpu.readSupervisorWord(this.cpu.ldtr, n3) : this.cpu.readSupervisorWord(this.cpu.gdtr, n3);
        int n10 = n4 & 0xF0000 | n9 & 0xFFFF;
        if ((n4 & 0x800000) != 0) {
            n10 = n10 << 12 | 0xFFF;
        }
        this.cpu.setZeroFlag(true);
        return n10;
    }

    private final Segment lldt(int n) {
        if ((n &= 0xFFFF) == 0) {
            return SegmentFactory.NULL_SEGMENT;
        }
        Segment segment = this.cpu.getSegment(n & 0xFFFFFFFB);
        if (segment.getType() != 2) {
            throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n, true);
        }
        if (!segment.isPresent()) {
            throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n, true);
        }
        return segment;
    }

    private final Segment ltr(int n) {
        if ((n & 4) != 0) {
            throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n, true);
        }
        Segment segment = this.cpu.getSegment(n);
        if (segment.getType() != 1 && segment.getType() != 9) {
            throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n, true);
        }
        if (!segment.isPresent()) {
            throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, n, true);
        }
        long l = this.cpu.readSupervisorQuadWord(this.cpu.gdtr, n & 0xFFF8) | 0x20000000000L;
        this.cpu.setSupervisorQuadWord(this.cpu.gdtr, n & 0xFFF8, l);
        return this.cpu.getSegment(n);
    }

    private final void cpuid() {
        switch (this.cpu.eax) {
            case 0: {
                this.cpu.eax = 2;
                this.cpu.ebx = 1970169159;
                this.cpu.edx = 1231384169;
                this.cpu.ecx = 1818588270;
                return;
            }
            case 1: {
                this.cpu.eax = 1587;
                this.cpu.ebx = 2048;
                this.cpu.ecx = 0;
                int n = 0;
                n |= 1;
                n |= 0x100;
                n |= 0x10;
                n |= 0x20;
                n |= 0x8000;
                n |= 8;
                n |= 0x2000;
                this.cpu.edx = n |= 0x800;
                return;
            }
        }
        this.cpu.eax = 4261377;
        this.cpu.ebx = 0;
        this.cpu.ecx = 0;
        this.cpu.edx = 0;
    }

    private final long rdtsc() {
        if (this.cpu.getCPL() == 0 || (this.cpu.getCR4() & 4) == 0) {
            return this.cpu.getClockCount();
        }
        throw ProcessorException.GENERAL_PROTECTION_0;
    }

    private final void bitwise_flags(byte by) {
        this.cpu.setOverflowFlag(false);
        this.cpu.setCarryFlag(false);
        this.cpu.setZeroFlag(by);
        this.cpu.setParityFlag(by);
        this.cpu.setSignFlag(by);
    }

    private final void bitwise_flags(short s) {
        this.cpu.setOverflowFlag(false);
        this.cpu.setCarryFlag(false);
        this.cpu.setZeroFlag(s);
        this.cpu.setParityFlag(s);
        this.cpu.setSignFlag(s);
    }

    private final void bitwise_flags(int n) {
        this.cpu.setOverflowFlag(false);
        this.cpu.setCarryFlag(false);
        this.cpu.setZeroFlag(n);
        this.cpu.setParityFlag(n);
        this.cpu.setSignFlag(n);
    }

    private final void arithmetic_flags_o8(int n, int n2, int n3) {
        this.cpu.setZeroFlag((byte)n);
        this.cpu.setParityFlag(n);
        this.cpu.setSignFlag((byte)n);
        this.cpu.setCarryFlag(n, 9);
        this.cpu.setAuxiliaryCarryFlag(n2, n3, n, 1);
    }

    private final void arithmetic_flags_o16(int n, int n2, int n3) {
        this.cpu.setZeroFlag((short)n);
        this.cpu.setParityFlag(n);
        this.cpu.setSignFlag((short)n);
        this.cpu.setCarryFlag(n, 10);
        this.cpu.setAuxiliaryCarryFlag(n2, n3, n, 1);
    }

    private final void arithmetic_flags_o32(long l, int n, int n2) {
        this.cpu.setZeroFlag((int)l);
        this.cpu.setParityFlag((int)l);
        this.cpu.setSignFlag((int)l);
        this.cpu.setCarryFlag(l, 11);
        this.cpu.setAuxiliaryCarryFlag(n, n2, (int)l, 1);
    }

    private final void add_o32_flags(long l, int n, int n2) {
        l = (0xFFFFFFFFL & (long)n) + (0xFFFFFFFFL & (long)n2);
        this.arithmetic_flags_o32(l, n, n2);
        this.cpu.setOverflowFlag((int)l, n, n2, 24);
    }

    private final void add_o16_flags(int n, int n2, int n3) {
        this.arithmetic_flags_o16(n, n2, n3);
        this.cpu.setOverflowFlag(n, n2, n3, 23);
    }

    private final void add_o8_flags(int n, int n2, int n3) {
        this.arithmetic_flags_o8(n, n2, n3);
        this.cpu.setOverflowFlag(n, n2, n3, 22);
    }

    private final void adc_o32_flags(long l, int n, int n2) {
        int n3 = this.cpu.getCarryFlag() ? 1 : 0;
        l = (0xFFFFFFFFL & (long)n) + (0xFFFFFFFFL & (long)n2) + (long)n3;
        if (this.cpu.getCarryFlag() && n2 == -1) {
            this.arithmetic_flags_o32(l, n, n2);
            this.cpu.setOverflowFlag(false);
            this.cpu.setCarryFlag(true);
        } else {
            this.cpu.setOverflowFlag((int)l, n, n2, 24);
            this.arithmetic_flags_o32(l, n, n2);
        }
    }

    private final void adc_o16_flags(int n, int n2, int n3) {
        if (this.cpu.getCarryFlag() && n3 == 65535) {
            this.arithmetic_flags_o16(n, n2, n3);
            this.cpu.setOverflowFlag(false);
            this.cpu.setCarryFlag(true);
        } else {
            this.cpu.setOverflowFlag(n, n2, n3, 23);
            this.arithmetic_flags_o16(n, n2, n3);
        }
    }

    private final void adc_o8_flags(int n, int n2, int n3) {
        if (this.cpu.getCarryFlag() && n3 == 255) {
            this.arithmetic_flags_o8(n, n2, n3);
            this.cpu.setOverflowFlag(false);
            this.cpu.setCarryFlag(true);
        } else {
            this.cpu.setOverflowFlag(n, n2, n3, 22);
            this.arithmetic_flags_o8(n, n2, n3);
        }
    }

    private final void sub_o32_flags(long l, int n, int n2) {
        l = (0xFFFFFFFFL & (long)n) - (0xFFFFFFFFL & (long)n2);
        this.arithmetic_flags_o32(l, n, n2);
        this.cpu.setOverflowFlag((int)l, n, n2, 27);
    }

    private final void sub_o16_flags(int n, int n2, int n3) {
        this.arithmetic_flags_o16(n, n2, n3);
        this.cpu.setOverflowFlag(n, n2, n3, 26);
    }

    private final void sub_o8_flags(int n, int n2, int n3) {
        this.arithmetic_flags_o8(n, n2, n3);
        this.cpu.setOverflowFlag(n, n2, n3, 25);
    }

    private final void sbb_o32_flags(long l, int n, int n2) {
        int n3 = this.cpu.getCarryFlag() ? 1 : 0;
        l = (0xFFFFFFFFL & (long)n) - ((0xFFFFFFFFL & (long)n2) + (long)n3);
        this.cpu.setOverflowFlag((int)l, n, n2, 27);
        this.arithmetic_flags_o32(l, n, n2);
    }

    private final void sbb_o16_flags(int n, int n2, int n3) {
        this.cpu.setOverflowFlag(n, n2, n3, 26);
        this.arithmetic_flags_o16(n, n2, n3);
    }

    private final void sbb_o8_flags(int n, int n2, int n3) {
        this.cpu.setOverflowFlag(n, n2, n3, 25);
        this.arithmetic_flags_o8(n, n2, n3);
    }

    private final void dec_flags(int n) {
        this.cpu.setZeroFlag(n);
        this.cpu.setParityFlag(n);
        this.cpu.setSignFlag(n);
        this.cpu.setOverflowFlag(n, 18);
        this.cpu.setAuxiliaryCarryFlag(n, 3);
    }

    private final void dec_flags(short s) {
        this.cpu.setZeroFlag(s);
        this.cpu.setParityFlag(s);
        this.cpu.setSignFlag(s);
        this.cpu.setOverflowFlag(s, 17);
        this.cpu.setAuxiliaryCarryFlag(s, 3);
    }

    private final void dec_flags(byte by) {
        this.cpu.setZeroFlag(by);
        this.cpu.setParityFlag(by);
        this.cpu.setSignFlag(by);
        this.cpu.setOverflowFlag(by, 16);
        this.cpu.setAuxiliaryCarryFlag(by, 3);
    }

    private final void inc_flags(int n) {
        this.cpu.setZeroFlag(n);
        this.cpu.setParityFlag(n);
        this.cpu.setSignFlag(n);
        this.cpu.setOverflowFlag(n, 21);
        this.cpu.setAuxiliaryCarryFlag(n, 4);
    }

    private final void inc_flags(short s) {
        this.cpu.setZeroFlag(s);
        this.cpu.setParityFlag(s);
        this.cpu.setSignFlag(s);
        this.cpu.setOverflowFlag(s, 20);
        this.cpu.setAuxiliaryCarryFlag(s, 4);
    }

    private final void inc_flags(byte by) {
        this.cpu.setZeroFlag(by);
        this.cpu.setParityFlag(by);
        this.cpu.setSignFlag(by);
        this.cpu.setOverflowFlag(by, 19);
        this.cpu.setAuxiliaryCarryFlag(by, 4);
    }

    private final void shl_flags(byte by, byte by2, int n) {
        if (n > 0) {
            this.cpu.setCarryFlag(by2, n, 12);
            if (n == 1) {
                this.cpu.setOverflowFlag(by, 8);
            }
            this.cpu.setZeroFlag(by);
            this.cpu.setParityFlag(by);
            this.cpu.setSignFlag(by);
        }
    }

    private final void shl_flags(short s, short s2, int n) {
        if (n > 0) {
            this.cpu.setCarryFlag(s2, n, 13);
            if (n == 1) {
                this.cpu.setOverflowFlag(s, 10);
            }
            this.cpu.setZeroFlag(s);
            this.cpu.setParityFlag(s);
            this.cpu.setSignFlag(s);
        }
    }

    private final void shl_flags(int n, int n2, int n3) {
        if (n3 > 0) {
            this.cpu.setCarryFlag(n2, n3, 14);
            if (n3 == 1) {
                this.cpu.setOverflowFlag(n, 12);
            }
            this.cpu.setZeroFlag(n);
            this.cpu.setParityFlag(n);
            this.cpu.setSignFlag(n);
        }
    }

    private final void shr_flags(byte by, int n, int n2) {
        if (n2 > 0) {
            this.cpu.setCarryFlag(n, n2, 15);
            if (n2 == 1) {
                this.cpu.setOverflowFlag(by, n, 13);
            }
            this.cpu.setZeroFlag(by);
            this.cpu.setParityFlag(by);
            this.cpu.setSignFlag(by);
        }
    }

    private final void shr_flags(short s, int n, int n2) {
        if (n2 > 0) {
            this.cpu.setCarryFlag(n, n2, 15);
            if (n2 == 1) {
                this.cpu.setOverflowFlag(s, n, 14);
            }
            this.cpu.setZeroFlag(s);
            this.cpu.setParityFlag(s);
            this.cpu.setSignFlag(s);
        }
    }

    private final void shr_flags(int n, int n2, int n3) {
        if (n3 > 0) {
            this.cpu.setCarryFlag(n2, n3, 15);
            if (n3 == 1) {
                this.cpu.setOverflowFlag(n, n2, 15);
            }
            this.cpu.setZeroFlag(n);
            this.cpu.setParityFlag(n);
            this.cpu.setSignFlag(n);
        }
    }

    private final void sar_flags(byte by, byte by2, int n) {
        if (n > 0) {
            this.cpu.setCarryFlag(by2, n, 15);
            if (n == 1) {
                this.cpu.setOverflowFlag(false);
            }
            this.cpu.setSignFlag(by);
            this.cpu.setZeroFlag(by);
            this.cpu.setParityFlag(by);
        }
    }

    private final void sar_flags(short s, short s2, int n) {
        if (n > 0) {
            this.cpu.setCarryFlag(s2, n, 15);
            if (n == 1) {
                this.cpu.setOverflowFlag(false);
            }
            this.cpu.setSignFlag(s);
            this.cpu.setZeroFlag(s);
            this.cpu.setParityFlag(s);
        }
    }

    private final void sar_flags(int n, int n2, int n3) {
        if (n3 > 0) {
            this.cpu.setCarryFlag(n2, n3, 15);
            if (n3 == 1) {
                this.cpu.setOverflowFlag(false);
            }
            this.cpu.setSignFlag(n);
            this.cpu.setZeroFlag(n);
            this.cpu.setParityFlag(n);
        }
    }

    private final void rol_flags(byte by, int n) {
        if (n > 0) {
            this.cpu.setCarryFlag(by, 16);
            if (n == 1) {
                this.cpu.setOverflowFlag(by, 8);
            }
        }
    }

    private final void rol_flags(short s, int n) {
        if (n > 0) {
            this.cpu.setCarryFlag(s, 16);
            if (n == 1) {
                this.cpu.setOverflowFlag(s, 10);
            }
        }
    }

    private final void rol_flags(int n, int n2) {
        if (n2 > 0) {
            this.cpu.setCarryFlag(n, 16);
            if (n2 == 1) {
                this.cpu.setOverflowFlag(n, 12);
            }
        }
    }

    private final void ror_flags(byte by, int n) {
        if (n > 0) {
            this.cpu.setCarryFlag(by, 17);
            if (n == 1) {
                this.cpu.setOverflowFlag(by, 7);
            }
        }
    }

    private final void ror_flags(short s, int n) {
        if (n > 0) {
            this.cpu.setCarryFlag(s, 18);
            if (n == 1) {
                this.cpu.setOverflowFlag(s, 9);
            }
        }
    }

    private final void ror_flags(int n, int n2) {
        if (n2 > 0) {
            this.cpu.setCarryFlag(n, 19);
            if (n2 == 1) {
                this.cpu.setOverflowFlag(n, 11);
            }
        }
    }

    private final void rcl_o8_flags(int n, int n2) {
        if (n2 > 0) {
            this.cpu.setCarryFlag(n, 20);
            if (n2 == 1) {
                this.cpu.setOverflowFlag(n, 8);
            }
        }
    }

    private final void rcl_o16_flags(int n, int n2) {
        if (n2 > 0) {
            this.cpu.setCarryFlag(n, 21);
            if (n2 == 1) {
                this.cpu.setOverflowFlag(n, 10);
            }
        }
    }

    private final void rcl_o32_flags(long l, int n) {
        if (n > 0) {
            this.cpu.setCarryFlag(l, 22);
            if (n == 1) {
                this.cpu.setOverflowFlag((int)l, 12);
            }
        }
    }

    private final void rcr_o8_flags(int n, int n2, int n3) {
        if (n2 > 0) {
            this.cpu.setCarryFlag(n, 20);
            if (n2 == 1) {
                this.cpu.setOverflowFlag(n3 > 0);
            }
        }
    }

    private final void rcr_o16_flags(int n, int n2, int n3) {
        if (n2 > 0) {
            this.cpu.setCarryFlag(n, 21);
            if (n2 == 1) {
                this.cpu.setOverflowFlag(n3 > 0);
            }
        }
    }

    private final void rcr_o32_flags(long l, int n, int n2) {
        if (n > 0) {
            this.cpu.setCarryFlag(l, 22);
            if (n == 1) {
                this.cpu.setOverflowFlag(n2 > 0);
            }
        }
    }

    private final void neg_flags(byte by) {
        this.cpu.setCarryFlag(by, 1);
        this.cpu.setOverflowFlag(by, 19);
        this.cpu.setAuxiliaryCarryFlag(by, 5);
        this.cpu.setZeroFlag(by);
        this.cpu.setParityFlag(by);
        this.cpu.setSignFlag(by);
    }

    private final void neg_flags(short s) {
        this.cpu.setCarryFlag(s, 1);
        this.cpu.setOverflowFlag(s, 20);
        this.cpu.setAuxiliaryCarryFlag(s, 5);
        this.cpu.setZeroFlag(s);
        this.cpu.setParityFlag(s);
        this.cpu.setSignFlag(s);
    }

    private final void neg_flags(int n) {
        this.cpu.setCarryFlag(n, 1);
        this.cpu.setOverflowFlag(n, 21);
        this.cpu.setAuxiliaryCarryFlag(n, 5);
        this.cpu.setZeroFlag(n);
        this.cpu.setParityFlag(n);
        this.cpu.setSignFlag(n);
    }

    private final Segment loadSegment(int n) {
        if ((n &= 0xFFFF) < 4) {
            return SegmentFactory.NULL_SEGMENT;
        }
        Segment segment = this.cpu.getSegment(n);
        if (!segment.isPresent()) {
            throw new ProcessorException(ProcessorException.Type.NOT_PRESENT, n, true);
        }
        return segment;
    }

    private final boolean checkIOPermissionsByte(int n) {
        if (this.cpu.getCPL() <= this.cpu.eflagsIOPrivilegeLevel) {
            return true;
        }
        int n2 = 0xFFFF & this.cpu.tss.getWord(102);
        try {
            byte by = this.cpu.tss.getByte(n2 + (n >>> 3));
            return (by & 1 << (n & 7)) == 0;
        }
        catch (ProcessorException processorException) {
            if (processorException.getType() == ProcessorException.Type.GENERAL_PROTECTION) {
                return false;
            }
            throw processorException;
        }
    }

    private final boolean checkIOPermissionsShort(int n) {
        if (this.cpu.getCPL() <= this.cpu.eflagsIOPrivilegeLevel) {
            return true;
        }
        int n2 = 0xFFFF & this.cpu.tss.getWord(102);
        try {
            short s = this.cpu.tss.getWord(n2 + (n >>> 3));
            return (s & 3 << (n & 7)) == 0;
        }
        catch (ProcessorException processorException) {
            if (processorException.getType() == ProcessorException.Type.GENERAL_PROTECTION) {
                return false;
            }
            throw processorException;
        }
    }

    private final boolean checkIOPermissionsInt(int n) {
        if (this.cpu.getCPL() <= this.cpu.eflagsIOPrivilegeLevel) {
            return true;
        }
        int n2 = 0xFFFF & this.cpu.tss.getWord(102);
        try {
            short s = this.cpu.tss.getWord(n2 + (n >>> 3));
            return (s & 15 << (n & 7)) == 0;
        }
        catch (ProcessorException processorException) {
            if (processorException.getType() == ProcessorException.Type.GENERAL_PROTECTION) {
                return false;
            }
            throw processorException;
        }
    }

    private static int numberOfTrailingZeros(int n) {
        if (n == 0) {
            return 32;
        }
        int n2 = 31;
        int n3 = n << 16;
        if (n3 != 0) {
            n2 -= 16;
            n = n3;
        }
        if ((n3 = n << 8) != 0) {
            n2 -= 8;
            n = n3;
        }
        if ((n3 = n << 4) != 0) {
            n2 -= 4;
            n = n3;
        }
        if ((n3 = n << 2) != 0) {
            n2 -= 2;
            n = n3;
        }
        return n2 - (n << 1 >>> 31);
    }

    private static int numberOfLeadingZeros(int n) {
        if (n == 0) {
            return 32;
        }
        int n2 = 1;
        if (n >>> 16 == 0) {
            n2 += 16;
            n <<= 16;
        }
        if (n >>> 24 == 0) {
            n2 += 8;
            n <<= 8;
        }
        if (n >>> 28 == 0) {
            n2 += 4;
            n <<= 4;
        }
        if (n >>> 30 == 0) {
            n2 += 2;
            n <<= 2;
        }
        return n2 -= n >>> 31;
    }

    private static int reverseBytes(int n) {
        return n >>> 24 | n >> 8 & 0xFF00 | n << 8 & 0xFF0000 | n << 24;
    }

    static {
        for (int i = 0; i < parityMap.length; ++i) {
            ProtectedModeUBlock.parityMap[i] = (Integer.bitCount(i) & 1) == 0;
        }
        opcodeCounter = null;
    }
}

