/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.motherboard;

import java.io.IOException;
import org.jpc.diskimages.DiskImage;
import org.jpc.diskimages.ImageMaker;
import org.jpc.emulator.AbstractHardwareComponent;
import org.jpc.emulator.HardwareComponent;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.SRLoader;
import org.jpc.emulator.StatusDumper;
import org.jpc.emulator.memory.EPROMMemory;
import org.jpc.emulator.memory.PhysicalAddressSpace;
import org.jpc.emulator.motherboard.SystemBIOS;

public abstract class Bios
extends AbstractHardwareComponent {
    private byte[] imageData;
    private boolean loaded;
    private String printPrefix;
    private final StringBuilder biosOutputBuffer = new StringBuilder();

    public Bios(byte[] byArray) {
        this(byArray, "byte_array");
    }

    @Override
    public void dumpStatusPartial(StatusDumper statusDumper) {
        super.dumpStatusPartial(statusDumper);
        statusDumper.println("\tloaded " + this.loaded);
        statusDumper.println("\tprintPrefix " + this.printPrefix);
        statusDumper.println("\timageData:");
        statusDumper.printArray(this.imageData, "imageData");
    }

    @Override
    public void dumpStatus(StatusDumper statusDumper) {
        if (statusDumper.dumped(this)) {
            return;
        }
        statusDumper.println("#" + statusDumper.objectNumber(this) + ": Bios:");
        this.dumpStatusPartial(statusDumper);
        statusDumper.endObject();
    }

    @Override
    public void dumpSRPartial(SRDumper sRDumper) throws IOException {
        super.dumpSRPartial(sRDumper);
        sRDumper.dumpBoolean(this.loaded);
        sRDumper.dumpArray(this.imageData);
        sRDumper.dumpString(this.printPrefix);
    }

    public Bios(SRLoader sRLoader) throws IOException {
        super(sRLoader);
        this.loaded = sRLoader.loadBoolean();
        this.imageData = sRLoader.loadArrayByte();
        this.printPrefix = sRLoader.loadString();
    }

    public Bios(String string) throws IOException {
        this(Bios.getBiosData(string), string.replace('/', '.'));
    }

    private Bios(byte[] byArray, String string) {
        this.imageData = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.imageData, 0, byArray.length);
        this.loaded = false;
        this.printPrefix = Bios.class.getName() + ".output" + string;
    }

    private void load(PhysicalAddressSpace physicalAddressSpace) {
        int n = this.loadAddress();
        int n2 = (n & 0xFFFFF000) + 4096;
        int n3 = (int)(0x100000000L - (long)this.imageData.length);
        EPROMMemory ePROMMemory = new EPROMMemory(4096, n & 0xFFF, this.imageData, 0, n2 - n, physicalAddressSpace.getCodeBlockManager());
        physicalAddressSpace.mapMemory(n & 0xFFFFF000, ePROMMemory);
        if (this instanceof SystemBIOS) {
            physicalAddressSpace.copyArrayIntoContents(n3, this.imageData, 0, this.imageData.length);
        }
        int n4 = n2 - n;
        int n5 = n2;
        while (n4 + 4096 <= this.imageData.length) {
            ePROMMemory = new EPROMMemory(this.imageData, n4, 4096, physicalAddressSpace.getCodeBlockManager());
            physicalAddressSpace.mapMemory(n5, ePROMMemory);
            n5 += 4096;
            n4 += 4096;
        }
        if (n4 < this.imageData.length) {
            ePROMMemory = new EPROMMemory(4096, 0, this.imageData, n4, this.imageData.length - n4, physicalAddressSpace.getCodeBlockManager());
            physicalAddressSpace.mapMemory(n5, ePROMMemory);
        }
    }

    protected abstract int loadAddress();

    @Override
    public boolean initialised() {
        return this.loaded;
    }

    @Override
    public void acceptComponent(HardwareComponent hardwareComponent) {
        if (hardwareComponent instanceof PhysicalAddressSpace && hardwareComponent.initialised()) {
            this.load((PhysicalAddressSpace)hardwareComponent);
            this.loaded = true;
        }
    }

    @Override
    public void reset() {
        this.loaded = false;
    }

    public int length() {
        return this.imageData.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void print(int n) {
        StringBuilder stringBuilder = this.biosOutputBuffer;
        synchronized (stringBuilder) {
            if (n == 10) {
                System.err.println("Emulated: BIOS output: " + this.biosOutputBuffer.toString());
                this.biosOutputBuffer.delete(0, this.biosOutputBuffer.length());
            } else {
                this.biosOutputBuffer.append((char)n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void print(String string) {
        StringBuilder stringBuilder = this.biosOutputBuffer;
        synchronized (stringBuilder) {
            int n;
            while ((n = string.indexOf(10)) >= 0) {
                this.biosOutputBuffer.append(string.substring(0, n));
                System.err.println("Emulated: BIOS output: " + this.biosOutputBuffer.toString());
                this.biosOutputBuffer.delete(0, this.biosOutputBuffer.length());
                string = string.substring(n + 1);
            }
            this.biosOutputBuffer.append(string);
        }
    }

    private static final byte[] getBiosData(String string) throws IOException {
        String string2 = DiskImage.getLibrary().searchFileName(string);
        if (string2 == null) {
            throw new IOException(string + ": No such image in Library.");
        }
        ImageMaker.ParsedImage parsedImage = new ImageMaker.ParsedImage(string2);
        if (parsedImage.typeCode != 3) {
            throw new IOException(string + ": is not a BIOS image.");
        }
        return parsedImage.rawImage;
    }
}

