/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.motherboard;

import java.io.IOException;
import org.jpc.emulator.AbstractHardwareComponent;
import org.jpc.emulator.Clock;
import org.jpc.emulator.HardwareComponent;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.SRLoader;
import org.jpc.emulator.StatusDumper;
import org.jpc.emulator.motherboard.IOPortCapable;

public class IOPortHandler
extends AbstractHardwareComponent
implements IOPortCapable {
    private static final int MAX_IOPORTS = 65536;
    private static final IOPortCapable defaultDevice = new UnconnectedIOPort();
    private IOPortCapable[] ioPortDevice;
    private Clock clock;
    public boolean SYSFLAG_IOPORTDELAY;
    private static final int IOPORT_READ_DELAY = 666;

    public IOPortHandler() {
        this.ioPortDevice = new IOPortCapable[65536];
        for (int i = 0; i < this.ioPortDevice.length; ++i) {
            this.ioPortDevice[i] = defaultDevice;
        }
    }

    @Override
    public void dumpStatusPartial(StatusDumper statusDumper) {
        super.dumpStatusPartial(statusDumper);
        statusDumper.println("\tdefaultDevice <object #" + statusDumper.objectNumber(defaultDevice) + ">");
        if (defaultDevice != null) {
            defaultDevice.dumpStatus(statusDumper);
        }
        for (int i = 0; i < this.ioPortDevice.length; ++i) {
            statusDumper.println("\tioPortDevice[" + i + "] <object #" + statusDumper.objectNumber(this.ioPortDevice[i]) + ">");
            if (this.ioPortDevice[i] == null) continue;
            this.ioPortDevice[i].dumpStatus(statusDumper);
        }
    }

    @Override
    public void dumpStatus(StatusDumper statusDumper) {
        if (statusDumper.dumped(this)) {
            return;
        }
        statusDumper.println("#" + statusDumper.objectNumber(this) + ": IOPortHandler:");
        this.dumpStatusPartial(statusDumper);
        statusDumper.endObject();
    }

    @Override
    public void dumpSRPartial(SRDumper sRDumper) throws IOException {
        super.dumpSRPartial(sRDumper);
        sRDumper.specialObject(defaultDevice);
        sRDumper.dumpInt(this.ioPortDevice.length);
        for (int i = 0; i < this.ioPortDevice.length; ++i) {
            sRDumper.dumpObject(this.ioPortDevice[i]);
        }
        sRDumper.dumpObject(this.clock);
        sRDumper.dumpBoolean(this.SYSFLAG_IOPORTDELAY);
    }

    public IOPortHandler(SRLoader sRLoader) throws IOException {
        super(sRLoader);
        sRLoader.specialObject(defaultDevice);
        this.ioPortDevice = new IOPortCapable[sRLoader.loadInt()];
        for (int i = 0; i < this.ioPortDevice.length; ++i) {
            this.ioPortDevice[i] = (IOPortCapable)sRLoader.loadObject();
        }
        this.clock = null;
        this.SYSFLAG_IOPORTDELAY = false;
        if (sRLoader.objectEndsHere()) {
            return;
        }
        this.clock = (Clock)sRLoader.loadObject();
        this.SYSFLAG_IOPORTDELAY = sRLoader.loadBoolean();
    }

    @Override
    public int ioPortReadByte(int n) {
        if (this.clock != null && this.SYSFLAG_IOPORTDELAY) {
            Clock.timePasses(this.clock, 666);
        }
        return this.ioPortDevice[n].ioPortReadByte(n);
    }

    @Override
    public int ioPortReadWord(int n) {
        if (this.clock != null && this.SYSFLAG_IOPORTDELAY) {
            Clock.timePasses(this.clock, 666);
        }
        return this.ioPortDevice[n].ioPortReadWord(n);
    }

    @Override
    public int ioPortReadLong(int n) {
        if (this.clock != null && this.SYSFLAG_IOPORTDELAY) {
            Clock.timePasses(this.clock, 666);
        }
        return this.ioPortDevice[n].ioPortReadLong(n);
    }

    @Override
    public void ioPortWriteByte(int n, int n2) {
        this.ioPortDevice[n].ioPortWriteByte(n, n2);
    }

    @Override
    public void ioPortWriteWord(int n, int n2) {
        this.ioPortDevice[n].ioPortWriteWord(n, n2);
    }

    @Override
    public void ioPortWriteLong(int n, int n2) {
        this.ioPortDevice[n].ioPortWriteLong(n, n2);
    }

    @Override
    public int[] ioPortsRequested() {
        return null;
    }

    public void registerIOPortCapable(IOPortCapable iOPortCapable) {
        int[] nArray = iOPortCapable.ioPortsRequested();
        if (nArray == null) {
            return;
        }
        for (int n : nArray) {
            if (this.ioPortDevice[n] != defaultDevice) continue;
            this.ioPortDevice[n] = iOPortCapable;
        }
    }

    public void deregisterIOPortCapable(IOPortCapable iOPortCapable) {
        int[] nArray;
        for (int n : nArray = iOPortCapable.ioPortsRequested()) {
            if (this.ioPortDevice[n] != iOPortCapable) continue;
            this.ioPortDevice[n] = defaultDevice;
        }
    }

    @Override
    public void reset() {
        this.ioPortDevice = new IOPortCapable[65536];
        for (int i = 0; i < this.ioPortDevice.length; ++i) {
            this.ioPortDevice[i] = defaultDevice;
        }
    }

    public String toString() {
        return "IOPort Bus";
    }

    @Override
    public boolean initialised() {
        return this.clock != null;
    }

    @Override
    public void acceptComponent(HardwareComponent hardwareComponent) {
        if (hardwareComponent instanceof Clock) {
            this.clock = (Clock)hardwareComponent;
        }
    }

    public static class UnconnectedIOPort
    implements IOPortCapable {
        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
        }

        public UnconnectedIOPort(SRLoader sRLoader) throws IOException {
            sRLoader.objectCreated(this);
        }

        public UnconnectedIOPort() {
        }

        @Override
        public int ioPortReadByte(int n) {
            return 255;
        }

        @Override
        public int ioPortReadWord(int n) {
            return 65535;
        }

        @Override
        public int ioPortReadLong(int n) {
            return -1;
        }

        @Override
        public void ioPortWriteByte(int n, int n2) {
        }

        @Override
        public void ioPortWriteWord(int n, int n2) {
        }

        @Override
        public void ioPortWriteLong(int n, int n2) {
        }

        @Override
        public int[] ioPortsRequested() {
            return null;
        }

        @Override
        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": UnconnectedIOPort:");
            statusDumper.endObject();
        }
    }
}

