/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.motherboard;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.jpc.diskimages.BlockDevice;
import org.jpc.emulator.AbstractHardwareComponent;
import org.jpc.emulator.Clock;
import org.jpc.emulator.DriveSet;
import org.jpc.emulator.HardwareComponent;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.SRLoader;
import org.jpc.emulator.StatusDumper;
import org.jpc.emulator.Timer;
import org.jpc.emulator.TimerResponsive;
import org.jpc.emulator.motherboard.IOPortCapable;
import org.jpc.emulator.motherboard.IOPortHandler;
import org.jpc.emulator.motherboard.InterruptController;
import org.jpc.emulator.peripheral.FloppyController;

public class RTC
extends AbstractHardwareComponent
implements IOPortCapable {
    private static final int RTC_SECONDS = 0;
    private static final int RTC_SECONDS_ALARM = 1;
    private static final int RTC_MINUTES = 2;
    private static final int RTC_MINUTES_ALARM = 3;
    private static final int RTC_HOURS = 4;
    private static final int RTC_HOURS_ALARM = 5;
    private static final int RTC_DAY_OF_WEEK = 6;
    private static final int RTC_DAY_OF_MONTH = 7;
    private static final int RTC_MONTH = 8;
    private static final int RTC_YEAR = 9;
    private static final int RTC_REG_EQUIPMENT_BYTE = 20;
    private static final int RTC_REG_IBM_CENTURY_BYTE = 50;
    private static final int RTC_REG_IBM_PS2_CENTURY_BYTE = 55;
    private static final int RTC_REG_A = 10;
    private static final int RTC_REG_B = 11;
    private static final int RTC_REG_C = 12;
    private static final int RTC_REG_D = 13;
    private static final int REG_A_UIP = 128;
    private static final int REG_B_SET = 128;
    private static final int REG_B_PIE = 64;
    private static final int REG_B_AIE = 32;
    private static final int REG_B_UIE = 16;
    private byte[] cmosData;
    private int sysRAMSize;
    private byte cmosIndex;
    private int irq;
    private Calendar currentTime;
    private boolean currentTimeInited;
    private Timer periodicTimer;
    private long nextPeriodicTime;
    private Timer secondTimer;
    private Timer delayedSecondTimer;
    private long nextSecondTime;
    private PeriodicCallback periodicCallback;
    private SecondCallback secondCallback;
    private DelayedSecondCallback delayedSecondCallback;
    private InterruptController irqDevice;
    private Clock timeSource;
    private int ioPortBase;
    private DriveSet.BootType bootType;
    private boolean ioportRegistered;
    private boolean drivesInited;
    private boolean floppiesInited;

    public RTC(int n, int n2, int n3, long l) {
        this.sysRAMSize = n3;
        this.bootType = null;
        this.ioportRegistered = false;
        this.drivesInited = false;
        this.floppiesInited = false;
        this.currentTime = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        this.currentTime.setTime(new Date(l));
        System.err.print("Informational: RTC: Initial time: ");
        System.err.print(this.currentTime.get(1) + ".");
        System.err.print(this.currentTime.get(2) + ".");
        System.err.print(this.currentTime.get(5) + " ");
        System.err.print(this.currentTime.get(11) + ":");
        System.err.print(this.currentTime.get(12) + ":");
        System.err.print(this.currentTime.get(13) + ".");
        System.err.println(this.currentTime.get(14));
        this.ioPortBase = n;
        this.irq = n2;
        this.cmosData = new byte[128];
        this.cmosData[10] = 38;
        this.cmosData[11] = -126;
        this.cmosData[12] = 0;
        this.cmosData[13] = -128;
        this.timeToMemory();
        this.periodicCallback = new PeriodicCallback(this);
        this.secondCallback = new SecondCallback(this);
        this.delayedSecondCallback = new DelayedSecondCallback(this);
    }

    @Override
    public void dumpStatusPartial(StatusDumper statusDumper) {
        super.dumpStatusPartial(statusDumper);
        statusDumper.println("\tsysRAMSize " + this.sysRAMSize + " cmosIndex " + this.cmosIndex + " irq " + this.irq);
        statusDumper.println("\tcurrentTimeInited " + this.currentTimeInited + " nextPeriodicTime " + this.nextPeriodicTime);
        statusDumper.println("\tnextSecondTime " + this.nextSecondTime + " ioPortBase " + this.ioPortBase + " bootType " + (Object)((Object)this.bootType));
        statusDumper.println("\tioportRegistered " + this.ioportRegistered + " drivesInited " + this.drivesInited);
        statusDumper.println("\tfloppiesInited " + this.floppiesInited);
        statusDumper.println("\tperiodicTimer <object #" + statusDumper.objectNumber(this.periodicTimer) + ">");
        if (this.periodicTimer != null) {
            this.periodicTimer.dumpStatus(statusDumper);
        }
        statusDumper.println("\tsecondTimer <object #" + statusDumper.objectNumber(this.secondTimer) + ">");
        if (this.secondTimer != null) {
            this.secondTimer.dumpStatus(statusDumper);
        }
        statusDumper.println("\tdelayedSecondTimer <object #" + statusDumper.objectNumber(this.delayedSecondTimer) + ">");
        if (this.delayedSecondTimer != null) {
            this.delayedSecondTimer.dumpStatus(statusDumper);
        }
        statusDumper.println("\tperiodicCallback <object #" + statusDumper.objectNumber(this.periodicCallback) + ">");
        if (this.periodicCallback != null) {
            this.periodicCallback.dumpStatus(statusDumper);
        }
        statusDumper.println("\tsecondCallback <object #" + statusDumper.objectNumber(this.secondCallback) + ">");
        if (this.secondCallback != null) {
            this.secondCallback.dumpStatus(statusDumper);
        }
        statusDumper.println("\tdelayedSecondCallback <object #" + statusDumper.objectNumber(this.delayedSecondCallback) + ">");
        if (this.delayedSecondCallback != null) {
            this.delayedSecondCallback.dumpStatus(statusDumper);
        }
        statusDumper.println("\tirqDevice <object #" + statusDumper.objectNumber(this.irqDevice) + ">");
        if (this.irqDevice != null) {
            this.irqDevice.dumpStatus(statusDumper);
        }
        statusDumper.println("\ttimeSource <object #" + statusDumper.objectNumber(this.timeSource) + ">");
        if (this.timeSource != null) {
            this.timeSource.dumpStatus(statusDumper);
        }
        statusDumper.println("\tcurrentTime:");
        statusDumper.println("\t\tyear " + this.currentTime.get(1));
        statusDumper.println("\t\tmonth " + this.currentTime.get(2));
        statusDumper.println("\t\tday " + this.currentTime.get(5));
        statusDumper.println("\t\thour " + this.currentTime.get(11));
        statusDumper.println("\t\tminute " + this.currentTime.get(12));
        statusDumper.println("\t\tsecond " + this.currentTime.get(13));
        statusDumper.println("\t\tmillisecond " + this.currentTime.get(14));
        statusDumper.println("\tcmosData:");
        statusDumper.printArray(this.cmosData, "cmosData");
    }

    @Override
    public void dumpStatus(StatusDumper statusDumper) {
        if (statusDumper.dumped(this)) {
            return;
        }
        statusDumper.println("#" + statusDumper.objectNumber(this) + ": RTC:");
        this.dumpStatusPartial(statusDumper);
        statusDumper.endObject();
    }

    @Override
    public void dumpSRPartial(SRDumper sRDumper) throws IOException {
        super.dumpSRPartial(sRDumper);
        sRDumper.dumpInt(this.sysRAMSize);
        sRDumper.dumpArray(this.cmosData);
        sRDumper.dumpByte(this.cmosIndex);
        sRDumper.dumpInt(this.irq);
        sRDumper.dumpBoolean(this.currentTime != null);
        if (this.currentTime != null) {
            sRDumper.dumpInt(this.currentTime.get(1));
            sRDumper.dumpInt(this.currentTime.get(2));
            sRDumper.dumpInt(this.currentTime.get(5));
            sRDumper.dumpInt(this.currentTime.get(11));
            sRDumper.dumpInt(this.currentTime.get(12));
            sRDumper.dumpInt(this.currentTime.get(13));
            sRDumper.dumpInt(this.currentTime.get(14));
        }
        sRDumper.dumpBoolean(this.currentTimeInited);
        sRDumper.dumpObject(this.periodicTimer);
        sRDumper.dumpLong(this.nextPeriodicTime);
        sRDumper.dumpObject(this.secondTimer);
        sRDumper.dumpObject(this.delayedSecondTimer);
        sRDumper.dumpLong(this.nextSecondTime);
        sRDumper.dumpObject(this.periodicCallback);
        sRDumper.dumpObject(this.secondCallback);
        sRDumper.dumpObject(this.delayedSecondCallback);
        sRDumper.dumpObject(this.irqDevice);
        sRDumper.dumpObject(this.timeSource);
        sRDumper.dumpInt(this.ioPortBase);
        sRDumper.dumpByte(DriveSet.BootType.toNumeric(this.bootType));
        sRDumper.dumpBoolean(this.ioportRegistered);
        sRDumper.dumpBoolean(this.drivesInited);
        sRDumper.dumpBoolean(this.floppiesInited);
    }

    public RTC(SRLoader sRLoader) throws IOException {
        super(sRLoader);
        this.sysRAMSize = sRLoader.loadInt();
        this.cmosData = sRLoader.loadArrayByte();
        this.cmosIndex = sRLoader.loadByte();
        this.irq = sRLoader.loadInt();
        boolean bl = sRLoader.loadBoolean();
        if (bl) {
            this.currentTime = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            this.currentTime.set(1, sRLoader.loadInt());
            this.currentTime.set(2, sRLoader.loadInt());
            this.currentTime.set(5, sRLoader.loadInt());
            this.currentTime.set(11, sRLoader.loadInt());
            this.currentTime.set(12, sRLoader.loadInt());
            this.currentTime.set(13, sRLoader.loadInt());
            this.currentTime.set(14, sRLoader.loadInt());
        }
        this.currentTimeInited = sRLoader.loadBoolean();
        this.periodicTimer = (Timer)sRLoader.loadObject();
        this.nextPeriodicTime = sRLoader.loadLong();
        this.secondTimer = (Timer)sRLoader.loadObject();
        this.delayedSecondTimer = (Timer)sRLoader.loadObject();
        this.nextSecondTime = sRLoader.loadLong();
        this.periodicCallback = (PeriodicCallback)sRLoader.loadObject();
        this.secondCallback = (SecondCallback)sRLoader.loadObject();
        this.delayedSecondCallback = (DelayedSecondCallback)sRLoader.loadObject();
        this.irqDevice = (InterruptController)sRLoader.loadObject();
        this.timeSource = (Clock)sRLoader.loadObject();
        this.ioPortBase = sRLoader.loadInt();
        this.bootType = DriveSet.BootType.fromNumeric(sRLoader.loadByte());
        this.ioportRegistered = sRLoader.loadBoolean();
        this.drivesInited = sRLoader.loadBoolean();
        this.floppiesInited = sRLoader.loadBoolean();
    }

    private static final long scale64(long l, int n, int n2) {
        long l2 = (0xFFFFFFFFL & l) * (long)n;
        long l3 = (l >>> 32) * (long)n;
        long l4 = 0xFFFFFFFFL & (l3 += l2 >> 32) / (long)n2;
        long l5 = 0xFFFFFFFFL & ((l3 % (long)n2 << 32) + (l2 & 0xFFFFFFFFL)) / (long)n2;
        return l4 << 32 | l5;
    }

    private void init() {
        int n = this.toBCD(this.currentTime.get(1) / 100);
        this.currentTimeInited = true;
        this.cmosData[50] = (byte)n;
        this.cmosData[55] = (byte)n;
        n = 640;
        this.cmosData[21] = (byte)n;
        this.cmosData[22] = (byte)(n >>> 8);
        int n2 = this.sysRAMSize;
        n = n2 / 1024 - 1024;
        if (n > 65535) {
            n = 65535;
        }
        this.cmosData[23] = (byte)n;
        this.cmosData[24] = (byte)(n >>> 8);
        this.cmosData[48] = (byte)n;
        this.cmosData[49] = (byte)(n >>> 8);
        n = n2 > 0x1000000 ? n2 / 65536 - 256 : 0;
        if (n > 65535) {
            n = 65535;
        }
        this.cmosData[52] = (byte)n;
        this.cmosData[53] = (byte)(n >>> 8);
        switch (this.bootType) {
            case FLOPPY: {
                this.cmosData[61] = 1;
                break;
            }
            default: {
                this.cmosData[61] = 2;
                break;
            }
            case CDROM: {
                this.cmosData[61] = 3;
            }
        }
    }

    private void cmosInitHD(DriveSet driveSet) {
        BlockDevice blockDevice = driveSet.getHardDrive(0);
        BlockDevice blockDevice2 = driveSet.getHardDrive(1);
        this.cmosData[18] = (byte)((blockDevice != null ? 240 : 0) | (blockDevice2 != null ? 15 : 0));
        if (blockDevice != null) {
            this.cmosData[25] = 47;
            this.cmosData[27] = (byte)blockDevice.getCylinders();
            this.cmosData[28] = (byte)(blockDevice.getCylinders() >>> 8);
            this.cmosData[29] = (byte)blockDevice.getHeads();
            this.cmosData[30] = -1;
            this.cmosData[31] = -1;
            this.cmosData[32] = (byte)(0xC0 | (blockDevice.getHeads() > 8 ? 8 : 0));
            this.cmosData[33] = (byte)blockDevice.getCylinders();
            this.cmosData[34] = (byte)(blockDevice.getCylinders() >>> 8);
            this.cmosData[35] = (byte)blockDevice.getSectors();
        }
        if (blockDevice2 != null) {
            this.cmosData[26] = 47;
            this.cmosData[36] = (byte)blockDevice2.getCylinders();
            this.cmosData[37] = (byte)(blockDevice2.getCylinders() >>> 8);
            this.cmosData[38] = (byte)blockDevice2.getHeads();
            this.cmosData[39] = -1;
            this.cmosData[40] = -1;
            this.cmosData[41] = (byte)(0xC0 | (blockDevice2.getHeads() > 8 ? 8 : 0));
            this.cmosData[42] = (byte)blockDevice2.getCylinders();
            this.cmosData[43] = (byte)(blockDevice2.getCylinders() >>> 8);
            this.cmosData[44] = (byte)blockDevice2.getSectors();
        }
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            if (driveSet.getHardDrive(i) == null) continue;
            int n2 = driveSet.getHardDrive(i).getCylinders() <= 1024 && driveSet.getHardDrive(i).getHeads() <= 16 && driveSet.getHardDrive(i).getSectors() <= 63 ? 0 : 1;
            n |= n2 << i * 2;
        }
        this.cmosData[57] = (byte)n;
    }

    private void cmosInitFloppy(FloppyController floppyController) {
        int n = this.cmosGetFDType(floppyController, 0) << 4 | this.cmosGetFDType(floppyController, 1);
        this.cmosData[16] = (byte)n;
        n = 71;
        this.cmosData[20] = (byte)n;
    }

    private int cmosGetFDType(FloppyController floppyController, int n) {
        return 5;
    }

    @Override
    public int[] ioPortsRequested() {
        int n = this.ioPortBase;
        return new int[]{n, n + 1};
    }

    @Override
    public int ioPortReadByte(int n) {
        return 0xFF & this.cmosIOPortRead(n);
    }

    @Override
    public int ioPortReadWord(int n) {
        return 0xFF & this.ioPortReadByte(n) | 0xFF00 & this.ioPortReadByte(n + 1) << 8;
    }

    @Override
    public int ioPortReadLong(int n) {
        return 0xFFFF & this.ioPortReadWord(n) | 0xFFFF0000 & this.ioPortReadWord(n + 2) << 16;
    }

    @Override
    public void ioPortWriteByte(int n, int n2) {
        this.cmosIOPortWrite(n, 0xFF & n2);
    }

    @Override
    public void ioPortWriteWord(int n, int n2) {
        this.ioPortWriteByte(n, n2);
        this.ioPortWriteByte(n + 1, n2 >> 8);
    }

    @Override
    public void ioPortWriteLong(int n, int n2) {
        this.ioPortWriteWord(n, n2);
        this.ioPortWriteWord(n + 2, n2 >> 16);
    }

    private void periodicUpdate() {
        this.timerUpdate(this.nextPeriodicTime);
        this.cmosData[12] = (byte)(this.cmosData[12] | 0xC0);
        this.irqDevice.setIRQ(this.irq, 1);
    }

    private void secondUpdate() {
        if ((this.cmosData[10] & 0x70) != 32) {
            this.nextSecondTime += this.timeSource.getTickRate();
            this.secondTimer.setExpiry(this.nextSecondTime);
        } else {
            this.nextSecond();
            if (0 == (this.cmosData[11] & 0x80)) {
                this.cmosData[10] = (byte)(this.cmosData[10] | 0x80);
            }
            this.delayedSecondTimer.setExpiry(this.nextSecondTime + 244141L);
        }
    }

    private void delayedSecondUpdate() {
        if (0 == (this.cmosData[11] & 0x80)) {
            this.timeToMemory();
        }
        if (!(0 == (this.cmosData[11] & 0x20) || (this.cmosData[1] & 0xC0) != 192 && this.cmosData[1] != this.currentTime.get(13) || (this.cmosData[3] & 0xC0) != 192 && this.cmosData[3] != this.currentTime.get(12) || (this.cmosData[5] & 0xC0) != 192 && this.cmosData[5] != this.currentTime.get(11))) {
            this.cmosData[12] = (byte)(this.cmosData[12] | 0xA0);
            this.irqDevice.setIRQ(this.irq, 1);
        }
        if (0 != (this.cmosData[11] & 0x10)) {
            this.cmosData[12] = (byte)(this.cmosData[12] | 0x90);
            this.irqDevice.setIRQ(this.irq, 1);
        }
        this.cmosData[10] = (byte)(this.cmosData[10] & 0xFFFFFF7F);
        this.nextSecondTime += this.timeSource.getTickRate();
        this.secondTimer.setExpiry(this.nextSecondTime);
    }

    private void timerUpdate(long l) {
        int n = this.cmosData[10] & 0xF;
        if (n != 0 && 0 != (this.cmosData[11] & 0x40)) {
            if (n <= 2) {
                n += 7;
            }
            int n2 = 1 << n - 1;
            long l2 = RTC.scale64(l, 32768, (int)this.timeSource.getTickRate());
            long l3 = (l2 & (long)(~(n2 - 1))) + (long)n2;
            this.nextPeriodicTime = RTC.scale64(l3, (int)this.timeSource.getTickRate(), 32768) + 1L;
            this.periodicTimer.setExpiry(this.nextPeriodicTime);
        } else {
            this.periodicTimer.disable();
        }
    }

    private void nextSecond() {
        this.currentTime.add(13, 1);
    }

    private void cmosIOPortWrite(int n, int n2) {
        if ((n & 1) == 0) {
            this.cmosIndex = (byte)(n2 & 0x7F);
        } else {
            switch (this.cmosIndex) {
                case 1: 
                case 3: 
                case 5: {
                    this.cmosData[this.cmosIndex] = (byte)n2;
                    break;
                }
                case 0: 
                case 2: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    this.cmosData[this.cmosIndex] = (byte)n2;
                    if (0 != (this.cmosData[11] & 0x80)) break;
                    this.memoryToTime();
                    break;
                }
                case 10: {
                    this.cmosData[10] = (byte)(n2 & 0xFFFFFF7F | this.cmosData[10] & 0x80);
                    this.timerUpdate(this.timeSource.getTime());
                    break;
                }
                case 11: {
                    if (0 != (n2 & 0x80)) {
                        this.cmosData[10] = (byte)(this.cmosData[10] & 0xFFFFFF7F);
                        n2 &= 0xFFFFFFEF;
                    } else if (0 != (this.cmosData[11] & 0x80)) {
                        this.memoryToTime();
                    }
                    this.cmosData[11] = (byte)n2;
                    this.timerUpdate(this.timeSource.getTime());
                    break;
                }
                case 12: 
                case 13: {
                    break;
                }
                default: {
                    this.cmosData[this.cmosIndex] = (byte)n2;
                }
            }
        }
    }

    private int cmosIOPortRead(int n) {
        if ((n & 1) == 0) {
            return 255;
        }
        switch (this.cmosIndex) {
            case 12: {
                byte by = this.cmosData[12];
                this.irqDevice.setIRQ(this.irq, 0);
                this.cmosData[12] = 0;
                return by;
            }
        }
        return this.cmosData[this.cmosIndex];
    }

    private void memoryToTime() {
        this.currentTime.set(13, this.fromBCD(this.cmosData[0]));
        this.currentTime.set(12, this.fromBCD(this.cmosData[2]));
        this.currentTime.set(11, this.fromBCD(this.cmosData[4] & 0x7F));
        if (0 == (this.cmosData[11] & 2) && 0 != (this.cmosData[4] & 0x80)) {
            this.currentTime.add(11, 12);
        }
        this.currentTime.set(7, this.fromBCD(this.cmosData[6]));
        this.currentTime.set(5, this.fromBCD(this.cmosData[7]));
        this.currentTime.set(2, this.fromBCD(this.cmosData[8]) - 1);
        this.currentTime.set(1, this.fromBCD(this.cmosData[9]) + 2000);
    }

    private void timeToMemory() {
        this.cmosData[0] = (byte)this.toBCD(this.currentTime.get(13));
        this.cmosData[2] = (byte)this.toBCD(this.currentTime.get(12));
        if (0 != (this.cmosData[11] & 2)) {
            this.cmosData[4] = (byte)this.toBCD(this.currentTime.get(11));
        } else {
            this.cmosData[4] = (byte)this.toBCD(this.currentTime.get(10));
            if (this.currentTime.get(9) == 1) {
                this.cmosData[4] = (byte)(this.cmosData[4] | 0x80);
            }
        }
        this.cmosData[6] = (byte)this.toBCD(this.currentTime.get(7));
        this.cmosData[7] = (byte)this.toBCD(this.currentTime.get(5));
        this.cmosData[8] = (byte)this.toBCD(this.currentTime.get(2) + 1);
        this.cmosData[9] = (byte)this.toBCD(this.currentTime.get(1) % 100);
    }

    private int toBCD(int n) {
        if (0 != (this.cmosData[11] & 4)) {
            return n;
        }
        return n / 10 << 4 | n % 10;
    }

    private int fromBCD(int n) {
        if (0 != (this.cmosData[11] & 4)) {
            return n;
        }
        return (n >> 4) * 10 + (n & 0xF);
    }

    @Override
    public boolean initialised() {
        return this.irqDevice != null && this.timeSource != null && this.ioportRegistered && this.drivesInited && this.floppiesInited && this.bootType != null;
    }

    @Override
    public void reset() {
        this.irqDevice = null;
        this.timeSource = null;
        this.ioportRegistered = false;
        this.drivesInited = false;
        this.floppiesInited = false;
        this.bootType = null;
        this.cmosData = new byte[128];
        this.cmosData[10] = 38;
        this.cmosData[11] = 2;
        this.cmosData[12] = 0;
        this.cmosData[13] = -128;
        this.periodicCallback = new PeriodicCallback(this);
        this.secondCallback = new SecondCallback(this);
        this.delayedSecondCallback = new DelayedSecondCallback(this);
    }

    @Override
    public void acceptComponent(HardwareComponent hardwareComponent) {
        if (hardwareComponent instanceof InterruptController && hardwareComponent.initialised()) {
            this.irqDevice = (InterruptController)hardwareComponent;
        }
        if (hardwareComponent instanceof Clock && hardwareComponent.initialised()) {
            this.timeSource = (Clock)hardwareComponent;
        }
        if (hardwareComponent instanceof IOPortHandler && hardwareComponent.initialised()) {
            ((IOPortHandler)hardwareComponent).registerIOPortCapable(this);
            this.ioportRegistered = true;
        }
        if (hardwareComponent instanceof DriveSet && hardwareComponent.initialised()) {
            this.cmosInitHD((DriveSet)hardwareComponent);
            this.drivesInited = true;
        }
        if (hardwareComponent instanceof FloppyController && hardwareComponent.initialised()) {
            this.cmosInitFloppy((FloppyController)hardwareComponent);
            this.floppiesInited = true;
        }
        if (hardwareComponent instanceof DriveSet) {
            this.bootType = ((DriveSet)hardwareComponent).getBootType();
        }
        if (this.initialised()) {
            this.init();
            this.periodicTimer = this.timeSource.newTimer(this.periodicCallback);
            this.secondTimer = this.timeSource.newTimer(this.secondCallback);
            this.delayedSecondTimer = this.timeSource.newTimer(this.delayedSecondCallback);
            this.nextSecondTime = this.timeSource.getTime() + 999755859L;
            this.delayedSecondTimer.setExpiry(this.nextSecondTime);
        }
    }

    public String toString() {
        return "MC146818 RealTime Clock";
    }

    public static class DelayedSecondCallback
    implements TimerResponsive {
        private RTC upperBackref;

        public DelayedSecondCallback(RTC rTC) {
            this.upperBackref = rTC;
        }

        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
            sRDumper.dumpObject(this.upperBackref);
        }

        public DelayedSecondCallback(SRLoader sRLoader) throws IOException {
            sRLoader.objectCreated(this);
            this.upperBackref = (RTC)sRLoader.loadObject();
        }

        public void dumpStatusPartial(StatusDumper statusDumper) {
            statusDumper.println("\tupperBackref <object #" + statusDumper.objectNumber(this.upperBackref) + ">");
            if (this.upperBackref != null) {
                this.upperBackref.dumpStatus(statusDumper);
            }
        }

        @Override
        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": DelayedSecondCallback:");
            this.dumpStatusPartial(statusDumper);
            statusDumper.endObject();
        }

        @Override
        public void callback() {
            this.upperBackref.delayedSecondUpdate();
        }

        @Override
        public int getTimerType() {
            return 5;
        }
    }

    public static class SecondCallback
    implements TimerResponsive {
        private RTC upperBackref;

        public SecondCallback(RTC rTC) {
            this.upperBackref = rTC;
        }

        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
            sRDumper.dumpObject(this.upperBackref);
        }

        public SecondCallback(SRLoader sRLoader) throws IOException {
            sRLoader.objectCreated(this);
            this.upperBackref = (RTC)sRLoader.loadObject();
        }

        public void dumpStatusPartial(StatusDumper statusDumper) {
            statusDumper.println("\tupperBackref <object #" + statusDumper.objectNumber(this.upperBackref) + ">");
            if (this.upperBackref != null) {
                this.upperBackref.dumpStatus(statusDumper);
            }
        }

        @Override
        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": SecondCallback:");
            this.dumpStatusPartial(statusDumper);
            statusDumper.endObject();
        }

        @Override
        public void callback() {
            this.upperBackref.secondUpdate();
        }

        @Override
        public int getTimerType() {
            return 4;
        }
    }

    public static class PeriodicCallback
    implements TimerResponsive {
        private RTC upperBackref;

        public PeriodicCallback(RTC rTC) {
            this.upperBackref = rTC;
        }

        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
            sRDumper.dumpObject(this.upperBackref);
        }

        public PeriodicCallback(SRLoader sRLoader) throws IOException {
            sRLoader.objectCreated(this);
            this.upperBackref = (RTC)sRLoader.loadObject();
        }

        public void dumpStatusPartial(StatusDumper statusDumper) {
            statusDumper.println("\tupperBackref <object #" + statusDumper.objectNumber(this.upperBackref) + ">");
            if (this.upperBackref != null) {
                this.upperBackref.dumpStatus(statusDumper);
            }
        }

        @Override
        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": PeriodicCallback:");
            this.dumpStatusPartial(statusDumper);
            statusDumper.endObject();
        }

        @Override
        public void callback() {
            this.upperBackref.periodicUpdate();
        }

        @Override
        public int getTimerType() {
            return 3;
        }
    }
}

