/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.motherboard;

import java.io.IOException;
import org.jpc.emulator.HardwareComponent;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.SRLoader;
import org.jpc.emulator.StatusDumper;
import org.jpc.emulator.motherboard.Bios;
import org.jpc.emulator.motherboard.IOPortCapable;
import org.jpc.emulator.motherboard.IOPortHandler;

public class SystemBIOS
extends Bios
implements IOPortCapable {
    private boolean ioportRegistered;

    public SystemBIOS(String string) throws IOException {
        super(string);
        this.ioportRegistered = false;
    }

    @Override
    public void dumpStatusPartial(StatusDumper statusDumper) {
        super.dumpStatusPartial(statusDumper);
        statusDumper.println("\tioportRegistered " + this.ioportRegistered);
    }

    @Override
    public void dumpStatus(StatusDumper statusDumper) {
        if (statusDumper.dumped(this)) {
            return;
        }
        statusDumper.println("#" + statusDumper.objectNumber(this) + ": SystemBIOS:");
        this.dumpStatusPartial(statusDumper);
        statusDumper.endObject();
    }

    @Override
    public void dumpSRPartial(SRDumper sRDumper) throws IOException {
        super.dumpSRPartial(sRDumper);
        sRDumper.dumpBoolean(this.ioportRegistered);
    }

    public SystemBIOS(SRLoader sRLoader) throws IOException {
        super(sRLoader);
        this.ioportRegistered = sRLoader.loadBoolean();
    }

    @Override
    public int[] ioPortsRequested() {
        return new int[]{1024, 1025, 1026, 1027, 35072};
    }

    @Override
    public void ioPortWriteByte(int n, int n2) {
        switch (n) {
            case 1026: 
            case 1027: {
                this.print(n2);
                break;
            }
            case 35072: {
                System.err.println("Emulated: attempted system shutdown");
                break;
            }
        }
    }

    @Override
    public void ioPortWriteWord(int n, int n2) {
        switch (n) {
            case 1024: 
            case 1025: {
                System.err.println("Emulated CRITICAL: panic in rombios.c at line " + n2 + ".");
            }
        }
    }

    @Override
    public int ioPortReadByte(int n) {
        return 255;
    }

    @Override
    public int ioPortReadWord(int n) {
        return 65535;
    }

    @Override
    public int ioPortReadLong(int n) {
        return -1;
    }

    @Override
    public void ioPortWriteLong(int n, int n2) {
    }

    @Override
    protected int loadAddress() {
        return 0x100000 - this.length();
    }

    @Override
    public boolean initialised() {
        return super.initialised() && this.ioportRegistered;
    }

    @Override
    public void acceptComponent(HardwareComponent hardwareComponent) {
        super.acceptComponent(hardwareComponent);
        if (hardwareComponent instanceof IOPortHandler && hardwareComponent.initialised()) {
            ((IOPortHandler)hardwareComponent).registerIOPortCapable(this);
            this.ioportRegistered = true;
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.ioportRegistered = false;
    }
}

