/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.motherboard;

import java.io.IOException;
import org.jpc.emulator.HardwareComponent;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.SRLoader;
import org.jpc.emulator.StatusDumper;
import org.jpc.emulator.motherboard.Bios;
import org.jpc.emulator.motherboard.IOPortCapable;
import org.jpc.emulator.motherboard.IOPortHandler;

public class VGABIOS
extends Bios
implements IOPortCapable {
    private boolean ioportRegistered;

    public VGABIOS(String string) throws IOException {
        super(string);
        this.ioportRegistered = false;
    }

    @Override
    public void dumpStatusPartial(StatusDumper statusDumper) {
        super.dumpStatusPartial(statusDumper);
        statusDumper.println("\tioportRegistered " + this.ioportRegistered);
    }

    @Override
    public void dumpStatus(StatusDumper statusDumper) {
        if (statusDumper.dumped(this)) {
            return;
        }
        statusDumper.println("#" + statusDumper.objectNumber(this) + ": VGABIOS:");
        this.dumpStatusPartial(statusDumper);
        statusDumper.endObject();
    }

    @Override
    public void dumpSRPartial(SRDumper sRDumper) throws IOException {
        super.dumpSRPartial(sRDumper);
        sRDumper.dumpBoolean(this.ioportRegistered);
    }

    public VGABIOS(SRLoader sRLoader) throws IOException {
        super(sRLoader);
        this.ioportRegistered = sRLoader.loadBoolean();
    }

    @Override
    public int[] ioPortsRequested() {
        return new int[]{1280, 1281, 1282, 1283};
    }

    @Override
    public void ioPortWriteByte(int n, int n2) {
        switch (n) {
            case 1280: 
            case 1283: {
                this.print(n2);
                break;
            }
        }
    }

    @Override
    public void ioPortWriteWord(int n, int n2) {
        switch (n) {
            case 1281: 
            case 1282: {
                System.err.println("Emulated CRITICAL: panic in vgabios at line " + n2 + ".");
            }
        }
    }

    @Override
    public int ioPortReadByte(int n) {
        return 255;
    }

    @Override
    public int ioPortReadWord(int n) {
        return 65535;
    }

    @Override
    public int ioPortReadLong(int n) {
        return -1;
    }

    @Override
    public void ioPortWriteLong(int n, int n2) {
    }

    @Override
    protected int loadAddress() {
        return 786432;
    }

    @Override
    public boolean initialised() {
        return super.initialised() && this.ioportRegistered;
    }

    @Override
    public void acceptComponent(HardwareComponent hardwareComponent) {
        super.acceptComponent(hardwareComponent);
        if (hardwareComponent instanceof IOPortHandler && hardwareComponent.initialised()) {
            ((IOPortHandler)hardwareComponent).registerIOPortCapable(this);
            this.ioportRegistered = true;
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.ioportRegistered = false;
    }
}

