/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.pci;

import java.io.IOException;
import org.jpc.emulator.HardwareComponent;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.SRLoader;
import org.jpc.emulator.StatusDumper;
import org.jpc.emulator.motherboard.InterruptController;
import org.jpc.emulator.pci.AbstractPCIDevice;
import org.jpc.emulator.pci.IORegion;
import org.jpc.emulator.pci.IRQBouncer;
import org.jpc.emulator.pci.PCIDevice;

public class PCIISABridge
extends AbstractPCIDevice {
    private int[][] irqLevels;
    private InterruptController irqDevice;

    @Override
    public void dumpStatusPartial(StatusDumper statusDumper) {
        super.dumpStatusPartial(statusDumper);
        statusDumper.println("\tirqDevice <object #" + statusDumper.objectNumber(this.irqDevice) + ">");
        if (this.irqDevice != null) {
            this.irqDevice.dumpStatus(statusDumper);
        }
        for (int i = 0; i < this.irqLevels.length; ++i) {
            if (this.irqLevels[i] != null) {
                for (int j = 0; j < this.irqLevels[i].length; ++j) {
                    statusDumper.println("\tirqLevels[" + i + "][" + j + "] " + this.irqLevels[i][j]);
                }
                continue;
            }
            statusDumper.println("\tirqLevels[" + i + "] null");
        }
    }

    @Override
    public void dumpStatus(StatusDumper statusDumper) {
        if (statusDumper.dumped(this)) {
            return;
        }
        statusDumper.println("#" + statusDumper.objectNumber(this) + ": PCIISABridge:");
        this.dumpStatusPartial(statusDumper);
        statusDumper.endObject();
    }

    @Override
    public void dumpSRPartial(SRDumper sRDumper) throws IOException {
        super.dumpSRPartial(sRDumper);
        sRDumper.dumpObject(this.irqDevice);
        sRDumper.dumpInt(this.irqLevels.length);
        for (int i = 0; i < this.irqLevels.length; ++i) {
            sRDumper.dumpArray(this.irqLevels[i]);
        }
    }

    public PCIISABridge(SRLoader sRLoader) throws IOException {
        super(sRLoader);
        this.irqDevice = (InterruptController)sRLoader.loadObject();
        this.irqLevels = new int[sRLoader.loadInt()][];
        for (int i = 0; i < this.irqLevels.length; ++i) {
            this.irqLevels[i] = sRLoader.loadArrayInt();
        }
    }

    public PCIISABridge() {
        this.irqLevels = new int[4][2];
        this.putConfigWord(0, (short)-32634);
        this.putConfigWord(2, (short)28672);
        this.putConfigWord(10, (short)1537);
        this.putConfigByte(14, (byte)-128);
        this.internalReset();
    }

    private void internalReset() {
        this.putConfigWord(4, (short)7);
        this.putConfigWord(6, (short)512);
        this.putConfigByte(76, (byte)77);
        this.putConfigByte(78, (byte)3);
        this.putConfigByte(79, (byte)0);
        this.putConfigByte(96, (byte)-128);
        this.putConfigByte(105, (byte)2);
        this.putConfigByte(112, (byte)-128);
        this.putConfigByte(118, (byte)12);
        this.putConfigByte(119, (byte)12);
        this.putConfigByte(120, (byte)2);
        this.putConfigByte(121, (byte)0);
        this.putConfigByte(128, (byte)0);
        this.putConfigByte(130, (byte)0);
        this.putConfigByte(160, (byte)8);
        this.putConfigByte(162, (byte)0);
        this.putConfigByte(163, (byte)0);
        this.putConfigByte(164, (byte)0);
        this.putConfigByte(165, (byte)0);
        this.putConfigByte(166, (byte)0);
        this.putConfigByte(167, (byte)0);
        this.putConfigByte(168, (byte)15);
        this.putConfigByte(170, (byte)0);
        this.putConfigByte(171, (byte)0);
        this.putConfigByte(172, (byte)0);
        this.putConfigByte(174, (byte)0);
    }

    private void setIRQ(PCIDevice pCIDevice, int n, int n2) {
        n = this.slotGetPIRQ(pCIDevice, n);
        int n3 = pCIDevice.getIRQIndex();
        int n4 = n3 & 0x1F;
        int n5 = this.irqLevels[n][n3 >> 5];
        this.irqLevels[n][n3 >> 5] = n5 & ~(1 << n4) | n2 << n4;
        byte by = this.configReadByte(96 + n);
        if (by < 16) {
            int n6 = 0;
            for (int i = 0; i < 4; ++i) {
                if (by != this.configReadByte(96 + i)) continue;
                n6 |= this.getIRQLevel(i);
            }
            this.irqDevice.setIRQ(by, n6);
        }
    }

    private int getIRQLevel(int n) {
        for (int i = 0; i < 2; ++i) {
            if (this.irqLevels[n][i] == 0) continue;
            return 1;
        }
        return 0;
    }

    IRQBouncer makeBouncer(PCIDevice pCIDevice) {
        return new DefaultIRQBouncer(this);
    }

    int slotGetPIRQ(PCIDevice pCIDevice, int n) {
        int n2 = pCIDevice.getDeviceFunctionNumber() >> 3;
        return n + n2 & 3;
    }

    @Override
    public IORegion getIORegion(int n) {
        return null;
    }

    @Override
    public IORegion[] getIORegions() {
        return null;
    }

    @Override
    public void reset() {
        this.irqDevice = null;
        this.putConfigWord(0, (short)-32634);
        this.putConfigWord(2, (short)28672);
        this.putConfigWord(10, (short)1537);
        this.putConfigByte(14, (byte)-128);
        this.internalReset();
        super.reset();
    }

    @Override
    public boolean initialised() {
        return this.irqDevice != null && super.initialised();
    }

    @Override
    public void acceptComponent(HardwareComponent hardwareComponent) {
        if (hardwareComponent instanceof InterruptController && hardwareComponent.initialised()) {
            this.irqDevice = (InterruptController)hardwareComponent;
        }
        super.acceptComponent(hardwareComponent);
    }

    public String toString() {
        return "Intel 82371SB PIIX3 PCI ISA Bridge";
    }

    public static class DefaultIRQBouncer
    implements IRQBouncer {
        private PCIISABridge upperBackref;

        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
            sRDumper.dumpObject(this.upperBackref);
        }

        public DefaultIRQBouncer(SRLoader sRLoader) throws IOException {
            sRLoader.objectCreated(this);
            this.upperBackref = (PCIISABridge)sRLoader.loadObject();
        }

        DefaultIRQBouncer(PCIISABridge pCIISABridge) {
            this.upperBackref = pCIISABridge;
        }

        public void dumpStatusPartial(StatusDumper statusDumper) {
            statusDumper.println("\tupperBackref <object #" + statusDumper.objectNumber(this.upperBackref) + ">");
            if (this.upperBackref != null) {
                this.upperBackref.dumpStatus(statusDumper);
            }
        }

        @Override
        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": DefaultIRQBouncer:");
            this.dumpStatusPartial(statusDumper);
            statusDumper.endObject();
        }

        @Override
        public void setIRQ(PCIDevice pCIDevice, int n, int n2) {
            this.upperBackref.setIRQ(pCIDevice, n, n2);
        }
    }
}

