/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.pci.peripheral;

import java.io.IOException;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.SRLoader;
import org.jpc.emulator.StatusDumper;
import org.jpc.emulator.memory.Memory;
import org.jpc.emulator.pci.IOPortIORegion;
import org.jpc.emulator.pci.peripheral.IDEChannel;

public class BMDMAIORegion
implements IOPortIORegion {
    public static final int BM_STATUS_DMAING = 1;
    private static final int BM_STATUS_INT = 4;
    private static final int BM_CMD_START = 1;
    private int baseAddress;
    private long size;
    private BMDMAIORegion next;
    private byte command;
    private byte status;
    private int address;
    private int dtpr;
    private IDEChannel.IDEState ideDevice;
    private int ideDMAFunction;
    private Memory physicalMemory;

    public void dumpStatusPartial(StatusDumper statusDumper) {
        statusDumper.println("\tbaseAddress " + this.baseAddress + " size " + this.size + " command " + this.command + " status " + this.status);
        statusDumper.println("\taddress " + this.address + " ideDMAFunction " + this.ideDMAFunction + " dtpr " + this.dtpr);
        statusDumper.println("\tnext <object #" + statusDumper.objectNumber(this.next) + ">");
        if (this.next != null) {
            this.next.dumpStatus(statusDumper);
        }
        statusDumper.println("\tphysicalMemory <object #" + statusDumper.objectNumber(this.physicalMemory) + ">");
        if (this.physicalMemory != null) {
            this.physicalMemory.dumpStatus(statusDumper);
        }
        statusDumper.println("\tideDevice <object #" + statusDumper.objectNumber(this.ideDevice) + ">");
        if (this.ideDevice != null) {
            this.ideDevice.dumpStatus(statusDumper);
        }
    }

    @Override
    public void dumpStatus(StatusDumper statusDumper) {
        if (statusDumper.dumped(this)) {
            return;
        }
        statusDumper.println("#" + statusDumper.objectNumber(this) + ": PCIHostBridge:");
        this.dumpStatusPartial(statusDumper);
        statusDumper.endObject();
    }

    @Override
    public void dumpSRPartial(SRDumper sRDumper) throws IOException {
        sRDumper.dumpInt(this.baseAddress);
        sRDumper.dumpLong(this.size);
        sRDumper.dumpObject(this.next);
        sRDumper.dumpByte(this.command);
        sRDumper.dumpByte(this.status);
        sRDumper.dumpInt(this.address);
        sRDumper.dumpInt(this.dtpr);
        sRDumper.dumpObject(this.ideDevice);
        sRDumper.dumpInt(this.ideDMAFunction);
        sRDumper.dumpObject(this.physicalMemory);
    }

    public BMDMAIORegion(SRLoader sRLoader) throws IOException {
        sRLoader.objectCreated(this);
        this.baseAddress = sRLoader.loadInt();
        this.size = sRLoader.loadLong();
        this.next = (BMDMAIORegion)sRLoader.loadObject();
        this.command = sRLoader.loadByte();
        this.status = sRLoader.loadByte();
        this.address = sRLoader.loadInt();
        this.dtpr = sRLoader.loadInt();
        this.ideDevice = (IDEChannel.IDEState)sRLoader.loadObject();
        this.ideDMAFunction = sRLoader.loadInt();
        this.physicalMemory = (Memory)sRLoader.loadObject();
    }

    public BMDMAIORegion(BMDMAIORegion bMDMAIORegion, boolean bl) {
        this.baseAddress = -1;
        this.next = bMDMAIORegion;
    }

    void setAddressSpace(Memory memory) {
        this.physicalMemory = memory;
    }

    void writeMemory(int n, byte[] byArray, int n2, int n3) {
        this.physicalMemory.copyArrayIntoContents(n, byArray, n2, n3);
    }

    void setIDEDevice(IDEChannel.IDEState iDEState) {
        this.ideDevice = iDEState;
    }

    void setDMAFunction(int n) {
        this.ideDMAFunction = n;
    }

    void setIRQ() {
        this.status = (byte)(this.status | 4);
    }

    @Override
    public int getAddress() {
        return this.baseAddress;
    }

    @Override
    public long getSize() {
        return 16L;
    }

    @Override
    public int getType() {
        return 1;
    }

    byte getStatus() {
        return this.status;
    }

    @Override
    public int getRegionNumber() {
        return 4;
    }

    public int getDtpr() {
        return this.dtpr;
    }

    public int getCommand() {
        return this.command;
    }

    @Override
    public void setAddress(int n) {
        this.baseAddress = n;
        if (this.next != null) {
            this.next.setAddress(n + 8);
        }
    }

    @Override
    public void ioPortWriteByte(int n, int n2) {
        if (n - this.baseAddress > 7) {
            this.next.ioPortWriteByte(n, n2);
        }
        switch (n - this.baseAddress) {
            case 0: {
                this.writeCommand(n2);
                return;
            }
            case 2: {
                this.writeStatus(n2);
                return;
            }
        }
    }

    @Override
    public void ioPortWriteWord(int n, int n2) {
        this.ioPortWriteByte(n, 0xFF & n2);
        this.ioPortWriteByte(n + 1, 0xFF & n2 >>> 8);
    }

    @Override
    public void ioPortWriteLong(int n, int n2) {
        if (n - this.baseAddress > 7) {
            this.next.ioPortWriteLong(n, n2);
        }
        switch (n - this.baseAddress) {
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.writeAddress(n2);
                return;
            }
        }
        this.ioPortWriteWord(n, 0xFFFF & n2);
        this.ioPortWriteWord(n + 2, n2 >>> 16);
    }

    @Override
    public int ioPortReadByte(int n) {
        if (n - this.baseAddress > 7) {
            return this.next.ioPortReadByte(n);
        }
        switch (n - this.baseAddress) {
            case 0: {
                return this.command;
            }
            case 2: {
                return this.status;
            }
        }
        return 255;
    }

    @Override
    public int ioPortReadWord(int n) {
        return this.ioPortReadByte(n) & 0xFF | 0xFF00 & this.ioPortReadByte(n + 1) << 8;
    }

    @Override
    public int ioPortReadLong(int n) {
        if (n - this.baseAddress > 7) {
            return this.next.ioPortReadLong(n);
        }
        switch (n - this.baseAddress) {
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return this.address;
            }
        }
        return this.ioPortReadWord(n) & 0xFFFF | 0xFFFF0000 & this.ioPortReadWord(n + 1) << 8;
    }

    @Override
    public int[] ioPortsRequested() {
        return new int[]{this.baseAddress, this.baseAddress + 2, this.baseAddress + 4, this.baseAddress + 5, this.baseAddress + 6, this.baseAddress + 7, this.baseAddress + 8, this.baseAddress + 10, this.baseAddress + 12, this.baseAddress + 13, this.baseAddress + 14, this.baseAddress + 15};
    }

    private void writeCommand(int n) {
        if ((n & 1) == 0) {
            this.status = (byte)(this.status & 0xFFFFFFFE);
            this.command = (byte)(n & 9);
        } else {
            this.status = (byte)(this.status | 1);
            this.command = (byte)(n & 9);
            if (this.ideDMAFunction != 0) {
                this.ideDMALoop();
            }
        }
    }

    private void writeStatus(int n) {
        this.status = (byte)(n & 0x60 | this.status & 1 | this.status & ~n & 6);
    }

    private void writeAddress(int n) {
        this.address = n & 0xFFFFFFFC;
    }

    void ideDMALoop() {
        int n = this.address;
        for (int i = 0; i < 512; ++i) {
            int n2 = this.physicalMemory.getDoubleWord(n);
            int n3 = this.physicalMemory.getDoubleWord(n + 4);
            int n4 = n3 & 0xFFFE;
            if (n4 == 0) {
                n4 = 65536;
            }
            while (n4 > 0) {
                int n5 = this.ideDevice.dmaCallback(this.ideDMAFunction, n2, n4);
                if (n5 == 0) {
                    this.status = (byte)(this.status & 0xFFFFFFFE);
                    this.status = (byte)(this.status | 4);
                    this.ideDMAFunction = 0;
                    this.ideDevice = null;
                    return;
                }
                n2 += n5;
                n4 -= n5;
            }
            if ((n3 & Integer.MIN_VALUE) != 0) break;
            n += 8;
        }
        this.status = (byte)(this.status & 0xFFFFFFFE);
        this.status = (byte)(this.status | 4);
        this.ideDMAFunction = 0;
        this.ideDevice = null;
    }
}

