/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.pci.peripheral;

import java.io.IOException;
import org.jpc.emulator.Clock;
import org.jpc.emulator.DisplayController;
import org.jpc.emulator.HardwareComponent;
import org.jpc.emulator.SRDumpable;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.SRLoader;
import org.jpc.emulator.StatusDumper;
import org.jpc.emulator.Timer;
import org.jpc.emulator.TimerResponsive;
import org.jpc.emulator.TraceTrap;
import org.jpc.emulator.VGADigitalOut;
import org.jpc.emulator.memory.Memory;
import org.jpc.emulator.memory.PhysicalAddressSpace;
import org.jpc.emulator.motherboard.IOPortCapable;
import org.jpc.emulator.motherboard.IOPortHandler;
import org.jpc.emulator.pci.AbstractPCIDevice;
import org.jpc.emulator.pci.IORegion;
import org.jpc.emulator.pci.MemoryMappedIORegion;
import org.jpc.emulator.pci.PCIBus;
import org.jpc.emulator.processor.Processor;

public class VGACard
extends AbstractPCIDevice
implements IOPortCapable,
TimerResponsive,
DisplayController {
    private static final int VGA_RAM_SIZE = 0x1000000;
    private static final int INIT_VGA_RAM_SIZE = 65536;
    private static final int PAGE_SHIFT = 12;
    private static final int[] expand4;
    private static final int[] expand2;
    private static final int[] expand4to8;
    private static final int VGA_MASTER_CLOCK_FREQ = 226575000;
    private static final int MOR_COLOR_EMULATION = 1;
    private static final int ST01_V_RETRACE = 8;
    private static final int ST01_DISP_ENABLE = 1;
    private static final int VBE_DISPI_MAX_XRES = 1600;
    private static final int VBE_DISPI_MAX_YRES = 1200;
    private static final int VBE_DISPI_INDEX_ID = 0;
    private static final int VBE_DISPI_INDEX_XRES = 1;
    private static final int VBE_DISPI_INDEX_YRES = 2;
    private static final int VBE_DISPI_INDEX_BPP = 3;
    private static final int VBE_DISPI_INDEX_ENABLE = 4;
    private static final int VBE_DISPI_INDEX_BANK = 5;
    private static final int VBE_DISPI_INDEX_VIRT_WIDTH = 6;
    private static final int VBE_DISPI_INDEX_VIRT_HEIGHT = 7;
    private static final int VBE_DISPI_INDEX_X_OFFSET = 8;
    private static final int VBE_DISPI_INDEX_Y_OFFSET = 9;
    private static final int VBE_DISPI_MEMORY_SIZE = 10;
    private static final int VBE_DISPI_INDEX_NB = 10;
    private static final int VBE_DISPI_ID0 = 45248;
    private static final int VBE_DISPI_ID1 = 45249;
    private static final int VBE_DISPI_ID2 = 45250;
    private static final int VBE_DISPI_ID3 = 45251;
    private static final int VBE_DISPI_ID4 = 45252;
    private static final int VBE_DISPI_ID5 = 45253;
    private static final int VBE_DISPI_ENABLED = 1;
    private static final int VBE_DISPI_GETCAPS = 2;
    private static final int VBE_DISPI_8BITDAC = 32;
    private static final int VBE_DISPI_NOCLEARMEM = 128;
    private static final int GMODE_TEXT = 0;
    private static final int GMODE_GRAPH = 1;
    private static final int GMODE_BLANK = 2;
    private static final int CH_ATTR_SIZE = 16000;
    private static final int GR_INDEX_SETRESET = 0;
    private static final int GR_INDEX_ENABLE_SETRESET = 1;
    private static final int GR_INDEX_COLOR_COMPARE = 2;
    private static final int GR_INDEX_DATA_ROTATE = 3;
    private static final int GR_INDEX_READ_MAP_SELECT = 4;
    private static final int GR_INDEX_GRAPHICS_MODE = 5;
    private static final int GR_INDEX_MISC = 6;
    private static final int GR_INDEX_COLOR_DONT_CARE = 7;
    private static final int GR_INDEX_BITMASK = 8;
    private static final int SR_INDEX_CLOCKING_MODE = 1;
    private static final int SR_INDEX_MAP_MASK = 2;
    private static final int SR_INDEX_CHAR_MAP_SELECT = 3;
    private static final int SR_INDEX_SEQ_MEMORY_MODE = 4;
    private static final int AR_INDEX_PALLETE_MIN = 0;
    private static final int AR_INDEX_PALLETE_MAX = 15;
    private static final int AR_INDEX_ATTR_MODE_CONTROL = 16;
    private static final int AR_INDEX_OVERSCAN_COLOR = 17;
    private static final int AR_INDEX_COLOR_PLANE_ENABLE = 18;
    private static final int AR_INDEX_HORIZ_PIXEL_PANNING = 19;
    private static final int AR_INDEX_COLOR_SELECT = 20;
    private static final int CR_INDEX_HORZ_DISPLAY_END = 1;
    private static final int CR_INDEX_VERT_TOTAL = 6;
    private static final int CR_INDEX_OVERFLOW = 7;
    private static final int CR_INDEX_PRESET_ROW_SCAN = 8;
    private static final int CR_INDEX_MAX_SCANLINE = 9;
    private static final int CR_INDEX_CURSOR_START = 10;
    private static final int CR_INDEX_CURSOR_END = 11;
    private static final int CR_INDEX_START_ADDR_HIGH = 12;
    private static final int CR_INDEX_START_ADDR_LOW = 13;
    private static final int CR_INDEX_CURSOR_LOC_HIGH = 14;
    private static final int CR_INDEX_CURSOR_LOC_LOW = 15;
    private static final int CR_INDEX_VERT_RETRACE_END = 17;
    private static final int CR_INDEX_VERT_DISPLAY_END = 18;
    private static final int CR_INDEX_OFFSET = 19;
    private static final int CR_INDEX_CRTC_MODE_CONTROL = 23;
    private static final int CR_INDEX_LINE_COMPARE = 24;
    private static final int[] sequencerRegisterMask;
    private static final int[] graphicsRegisterMask;
    private static final int[] mask16;
    private static final int[] cursorGlyph;
    private final GraphicsUpdater VGA_DRAW_LINE2;
    private final GraphicsUpdater VGA_DRAW_LINE2D2;
    private final GraphicsUpdater VGA_DRAW_LINE4;
    private final GraphicsUpdater VGA_DRAW_LINE4D2;
    private final GraphicsUpdater VGA_DRAW_LINE8D2;
    private final GraphicsUpdater VGA_DRAW_LINE8;
    private final GraphicsUpdater VGA_DRAW_LINE15;
    private final GraphicsUpdater VGA_DRAW_LINE16;
    private final GraphicsUpdater VGA_DRAW_LINE24;
    private final GraphicsUpdater VGA_DRAW_LINE32;
    private int latch;
    private int sequencerRegisterIndex;
    private int graphicsRegisterIndex;
    private int attributeRegisterIndex;
    private int crtRegisterIndex;
    private int[] sequencerRegister;
    private int[] graphicsRegister;
    private int[] attributeRegister;
    private int[] crtRegister;
    private boolean attributeRegisterFlipFlop;
    private int miscellaneousOutputRegister;
    private int featureControlRegister;
    private int st00;
    private int st01;
    private int dacReadIndex;
    private int dacWriteIndex;
    private int dacSubIndex;
    private int dacState;
    private int shiftControl;
    private int doubleScan;
    private int[] dacCache;
    private int[] palette;
    private int bankOffset;
    private int vbeIndex;
    private int[] vbeRegs;
    private int vbeStartAddress;
    private int vbeLineOffset;
    private int vbeBankMask;
    private int[] fontOffset;
    private int graphicMode;
    private int lineOffset;
    private int lineCompare;
    private int startAddress;
    private int pixelPanning;
    private int usePixelPanning;
    private int byteSkip;
    private int planeUpdated;
    private int lastCW;
    private int lastCH;
    private int lastWidth;
    private int lastHeight;
    private int lastScreenWidth;
    private int lastScreenHeight;
    private int cursorStart;
    private int cursorEnd;
    private int cursorOffset;
    private final int[] lastPalette;
    private int[] lastChar;
    private boolean updated;
    private TraceTrap traceTrap;
    private boolean ioportRegistered;
    private boolean pciRegistered;
    private boolean memoryRegistered;
    private boolean updatingScreen;
    private boolean vbeCapsMode;
    private VGARAMIORegion ioRegion;
    private VGALowMemoryRegion lowIORegion;
    private static final long TRACE_TIME = 15000000L;
    private static final long FRAME_TIME = 16666667L;
    private static final long FRAME_TIME_ALT = 16666666L;
    private static final long FRAME_ALT_MOD = 3L;
    private Clock timeSource;
    private Timer retraceTimer;
    private VGADigitalOut outputDevice;
    private boolean retracing;
    private long whenFrameStarted;
    private long nextTimerExpiryVGA;
    private long nextTimerExpiry;
    private long frameNumber;
    private boolean vgaDrawHackFlag;
    private boolean vgaScroll2HackFlag;
    public boolean SYSFLAG_VGAHRETRACE;
    public int SYSFLAG_VGATIMINGMETHOD;
    public int SYSFLAG_SVGATYPE;
    private long draw_htotal;
    private long draw_vtotal;
    private long draw_hblkstart;
    private long draw_hblkend;
    private long draw_vrstart;
    private long draw_vrend;
    private long draw_vdend;
    private boolean returningFromVretrace;
    private boolean paletteDebuggingEnabled;

    private static long vgaClockToSystemClock(long l) {
        long l2 = l / 226575000L;
        long l3 = l % 226575000L;
        long l4 = (l3 * 1000000000L + 113287500L) / 226575000L;
        return 1000000000L * l2 + l4;
    }

    private static long systemClockToVGAClock(long l) {
        long l2 = l / 1000000000L;
        long l3 = l % 1000000000L;
        long l4 = (l3 * 226575000L + 500000000L) / 1000000000L;
        return 226575000L * l2 + l4;
    }

    @Override
    public void dumpStatusPartial(StatusDumper statusDumper) {
        statusDumper.println("\tlatch " + this.latch + " sequencerRegisterIndex " + this.sequencerRegisterIndex);
        statusDumper.println("\tgraphicsRegisterIndex " + this.graphicsRegisterIndex);
        statusDumper.println("\tattributeRegisterIndex " + this.attributeRegisterIndex);
        statusDumper.println("\tcrtRegisterIndex " + this.crtRegisterIndex + " bankOffset " + this.bankOffset);
        statusDumper.println("\tattributeRegisterFlipFlop " + this.attributeRegisterFlipFlop);
        statusDumper.println("\tmiscellaneousOutputRegister " + this.miscellaneousOutputRegister);
        statusDumper.println("\tfeatureControlRegister " + this.featureControlRegister + " doubleScan " + this.doubleScan);
        statusDumper.println("\tst00 " + this.st00 + " st01 " + this.st01 + " shiftControl " + this.shiftControl);
        statusDumper.println("\tdacReadIndex " + this.dacReadIndex + " dacWriteIndex " + this.dacWriteIndex);
        statusDumper.println("\tdacSubIndex " + this.dacSubIndex + " dacState " + this.dacState);
        statusDumper.println("\tvbeIndex " + this.vbeIndex + " vbeStartAddress " + this.vbeStartAddress);
        statusDumper.println("\tvbeLineOffset " + this.vbeLineOffset + " vbeBankMask " + this.vbeBankMask);
        statusDumper.println("\tgraphicMode " + this.graphicMode + " lineOffset " + this.lineOffset);
        statusDumper.println("\tlineCompare " + this.lineCompare + " startAddress " + this.startAddress);
        statusDumper.println("\tpixelPanning " + this.pixelPanning + " byteSkip " + this.byteSkip);
        statusDumper.println("\tusePixelPanning " + this.usePixelPanning + " SYSFLAG_SVGATYPE " + this.SYSFLAG_SVGATYPE);
        statusDumper.println("\tplaneUpdated " + this.planeUpdated + " lastCW " + this.lastCW + " lastCH " + this.lastCH);
        statusDumper.println("\tlastWidth " + this.lastWidth + " lastHeight " + this.lastHeight);
        statusDumper.println("\tlastScreenWidth " + this.lastScreenWidth + " lastScreenHeight " + this.lastScreenHeight);
        statusDumper.println("\tcursorStart " + this.cursorStart + " cursorEnd " + this.cursorEnd + " updated " + this.updated);
        statusDumper.println("\tcursorOffset " + this.cursorOffset + " ioportRegistered " + this.ioportRegistered);
        statusDumper.println("\tpciRegistered " + this.pciRegistered + " memoryRegistered " + this.memoryRegistered);
        statusDumper.println("\tupdatingScreen " + this.updatingScreen + " retracing " + this.retracing);
        statusDumper.println("\twhenFrameStarted " + this.whenFrameStarted + " vbeCapsMode " + this.vbeCapsMode);
        statusDumper.println("\tnextTimerExpiry " + this.nextTimerExpiry + " frameNumber " + this.frameNumber);
        statusDumper.println("\tSYSFLAG_VGATIMINGMETHOD " + this.SYSFLAG_VGATIMINGMETHOD);
        statusDumper.println("\tnextTimerExpiryVGA " + this.nextTimerExpiryVGA);
        statusDumper.println("\tdraw_htotal " + this.draw_htotal + " draw_vtotal " + this.draw_vtotal);
        statusDumper.println("\tdraw_hblkstart " + this.draw_hblkstart + " draw_hblkend " + this.draw_hblkend);
        statusDumper.println("\tdraw_vrstart " + this.draw_vrstart + " draw_vrend " + this.draw_vrend + " draw_vdend " + this.draw_vdend);
        statusDumper.println("\tVGA_DRAW_LINE2 <object #" + statusDumper.objectNumber(this.VGA_DRAW_LINE2) + ">");
        if (this.VGA_DRAW_LINE2 != null) {
            this.VGA_DRAW_LINE2.dumpStatus(statusDumper);
        }
        statusDumper.println("\tVGA_DRAW_LINE2D2 <object #" + statusDumper.objectNumber(this.VGA_DRAW_LINE2D2) + ">");
        if (this.VGA_DRAW_LINE2D2 != null) {
            this.VGA_DRAW_LINE2D2.dumpStatus(statusDumper);
        }
        statusDumper.println("\tVGA_DRAW_LINE4 <object #" + statusDumper.objectNumber(this.VGA_DRAW_LINE4) + ">");
        if (this.VGA_DRAW_LINE4 != null) {
            this.VGA_DRAW_LINE4.dumpStatus(statusDumper);
        }
        statusDumper.println("\tVGA_DRAW_LINE4D2 <object #" + statusDumper.objectNumber(this.VGA_DRAW_LINE4D2) + ">");
        if (this.VGA_DRAW_LINE4D2 != null) {
            this.VGA_DRAW_LINE4D2.dumpStatus(statusDumper);
        }
        statusDumper.println("\tVGA_DRAW_LINE8 <object #" + statusDumper.objectNumber(this.VGA_DRAW_LINE8) + ">");
        if (this.VGA_DRAW_LINE8 != null) {
            this.VGA_DRAW_LINE8.dumpStatus(statusDumper);
        }
        statusDumper.println("\tVGA_DRAW_LINE8D2 <object #" + statusDumper.objectNumber(this.VGA_DRAW_LINE8D2) + ">");
        if (this.VGA_DRAW_LINE8D2 != null) {
            this.VGA_DRAW_LINE8D2.dumpStatus(statusDumper);
        }
        statusDumper.println("\tVGA_DRAW_LINE15 <object #" + statusDumper.objectNumber(this.VGA_DRAW_LINE15) + ">");
        if (this.VGA_DRAW_LINE15 != null) {
            this.VGA_DRAW_LINE15.dumpStatus(statusDumper);
        }
        statusDumper.println("\tVGA_DRAW_LINE16 <object #" + statusDumper.objectNumber(this.VGA_DRAW_LINE16) + ">");
        if (this.VGA_DRAW_LINE16 != null) {
            this.VGA_DRAW_LINE16.dumpStatus(statusDumper);
        }
        statusDumper.println("\tVGA_DRAW_LINE24 <object #" + statusDumper.objectNumber(this.VGA_DRAW_LINE24) + ">");
        if (this.VGA_DRAW_LINE24 != null) {
            this.VGA_DRAW_LINE24.dumpStatus(statusDumper);
        }
        statusDumper.println("\tVGA_DRAW_LINE32 <object #" + statusDumper.objectNumber(this.VGA_DRAW_LINE32) + ">");
        if (this.VGA_DRAW_LINE32 != null) {
            this.VGA_DRAW_LINE32.dumpStatus(statusDumper);
        }
        statusDumper.println("\ttraceTrap <object #" + statusDumper.objectNumber(this.traceTrap) + ">");
        if (this.traceTrap != null) {
            this.traceTrap.dumpStatus(statusDumper);
        }
        statusDumper.println("\tioRegion <object #" + statusDumper.objectNumber(this.ioRegion) + ">");
        if (this.ioRegion != null) {
            this.ioRegion.dumpStatus(statusDumper);
        }
        statusDumper.println("\tlowIORegion <object #" + statusDumper.objectNumber(this.lowIORegion) + ">");
        if (this.lowIORegion != null) {
            this.lowIORegion.dumpStatus(statusDumper);
        }
        statusDumper.println("\tretraceTimer <object #" + statusDumper.objectNumber(this.retraceTimer) + ">");
        if (this.retraceTimer != null) {
            this.retraceTimer.dumpStatus(statusDumper);
        }
        statusDumper.println("\ttimeSource <object #" + statusDumper.objectNumber(this.timeSource) + ">");
        if (this.timeSource != null) {
            this.timeSource.dumpStatus(statusDumper);
        }
        statusDumper.println("\toutputDevice <object #" + statusDumper.objectNumber(this.outputDevice) + ">");
        if (this.outputDevice != null) {
            this.outputDevice.dumpStatus(statusDumper);
        }
        statusDumper.printArray(this.sequencerRegister, "sequencerRegister");
        statusDumper.printArray(this.graphicsRegister, "graphicsRegister");
        statusDumper.printArray(this.attributeRegister, "attributeRegister");
        statusDumper.printArray(this.crtRegister, "crtRegister");
        statusDumper.printArray(this.dacCache, "dacCache");
        statusDumper.printArray(this.palette, "palette");
        statusDumper.printArray(this.vbeRegs, "vbeRegs");
        statusDumper.printArray(this.fontOffset, "fontOffset");
        statusDumper.printArray(this.lastPalette, "lastPalette");
        statusDumper.printArray(this.lastChar, "lastChar");
        statusDumper.println("\tvgaDrawHackFlag " + this.vgaDrawHackFlag);
        statusDumper.println("\tvgaScroll2HackFlag " + this.vgaScroll2HackFlag);
        statusDumper.println("\tSYSFLAG_VGAHRETRACE " + this.SYSFLAG_VGAHRETRACE);
    }

    @Override
    public void dumpStatus(StatusDumper statusDumper) {
        if (statusDumper.dumped(this)) {
            return;
        }
        statusDumper.println("#" + statusDumper.objectNumber(this) + ": VGACard:");
        this.dumpStatusPartial(statusDumper);
        statusDumper.endObject();
    }

    @Override
    public void dumpSRPartial(SRDumper sRDumper) throws IOException {
        super.dumpSRPartial(sRDumper);
        sRDumper.dumpObject(this.VGA_DRAW_LINE2);
        sRDumper.dumpObject(this.VGA_DRAW_LINE2D2);
        sRDumper.dumpObject(this.VGA_DRAW_LINE4);
        sRDumper.dumpObject(this.VGA_DRAW_LINE4D2);
        sRDumper.dumpObject(this.VGA_DRAW_LINE8);
        sRDumper.dumpObject(this.VGA_DRAW_LINE8D2);
        sRDumper.dumpObject(this.VGA_DRAW_LINE15);
        sRDumper.dumpObject(this.VGA_DRAW_LINE16);
        sRDumper.dumpObject(this.VGA_DRAW_LINE24);
        sRDumper.dumpObject(this.VGA_DRAW_LINE32);
        sRDumper.dumpInt(this.latch);
        sRDumper.dumpInt(this.sequencerRegisterIndex);
        sRDumper.dumpInt(this.graphicsRegisterIndex);
        sRDumper.dumpInt(this.attributeRegisterIndex);
        sRDumper.dumpInt(this.crtRegisterIndex);
        sRDumper.dumpArray(this.sequencerRegister);
        sRDumper.dumpArray(this.graphicsRegister);
        sRDumper.dumpArray(this.attributeRegister);
        sRDumper.dumpArray(this.crtRegister);
        sRDumper.dumpBoolean(this.attributeRegisterFlipFlop);
        sRDumper.dumpInt(this.miscellaneousOutputRegister);
        sRDumper.dumpInt(this.featureControlRegister);
        sRDumper.dumpInt(this.st00);
        sRDumper.dumpInt(this.st01);
        sRDumper.dumpInt(this.dacReadIndex);
        sRDumper.dumpInt(this.dacWriteIndex);
        sRDumper.dumpInt(this.dacSubIndex);
        sRDumper.dumpInt(this.dacState);
        sRDumper.dumpInt(this.shiftControl);
        sRDumper.dumpInt(this.doubleScan);
        sRDumper.dumpArray(this.dacCache);
        sRDumper.dumpArray(this.palette);
        sRDumper.dumpInt(this.bankOffset);
        sRDumper.dumpInt(this.vbeIndex);
        sRDumper.dumpArray(this.vbeRegs);
        sRDumper.dumpInt(this.vbeStartAddress);
        sRDumper.dumpInt(this.vbeLineOffset);
        sRDumper.dumpInt(this.vbeBankMask);
        sRDumper.dumpArray(this.fontOffset);
        sRDumper.dumpInt(this.graphicMode);
        sRDumper.dumpInt(this.lineOffset);
        sRDumper.dumpInt(this.lineCompare);
        sRDumper.dumpInt(this.startAddress);
        sRDumper.dumpInt(this.pixelPanning);
        sRDumper.dumpInt(this.byteSkip);
        sRDumper.dumpInt(this.planeUpdated);
        sRDumper.dumpInt(this.lastCW);
        sRDumper.dumpInt(this.lastCH);
        sRDumper.dumpInt(this.lastWidth);
        sRDumper.dumpInt(this.lastHeight);
        sRDumper.dumpInt(this.lastScreenWidth);
        sRDumper.dumpInt(this.lastScreenHeight);
        sRDumper.dumpInt(this.cursorStart);
        sRDumper.dumpInt(this.cursorEnd);
        sRDumper.dumpInt(this.cursorOffset);
        sRDumper.dumpArray(this.lastPalette);
        sRDumper.dumpArray(this.lastChar);
        sRDumper.dumpObject(this.traceTrap);
        sRDumper.dumpBoolean(this.ioportRegistered);
        sRDumper.dumpBoolean(this.pciRegistered);
        sRDumper.dumpBoolean(this.memoryRegistered);
        sRDumper.dumpBoolean(this.updatingScreen);
        sRDumper.dumpObject(this.ioRegion);
        sRDumper.dumpObject(this.lowIORegion);
        sRDumper.dumpObject(this.timeSource);
        sRDumper.dumpObject(this.retraceTimer);
        sRDumper.dumpBoolean(this.retracing);
        sRDumper.dumpObject(this.outputDevice);
        sRDumper.dumpLong(this.nextTimerExpiry);
        sRDumper.dumpLong(this.frameNumber);
        sRDumper.dumpBoolean(this.updated);
        sRDumper.dumpBoolean(this.vgaDrawHackFlag);
        sRDumper.dumpBoolean(this.SYSFLAG_VGAHRETRACE);
        sRDumper.dumpBoolean(this.vgaScroll2HackFlag);
        sRDumper.dumpInt(this.usePixelPanning);
        sRDumper.dumpLong(this.whenFrameStarted);
        sRDumper.dumpInt(this.SYSFLAG_VGATIMINGMETHOD);
        sRDumper.dumpLong(this.nextTimerExpiryVGA);
        sRDumper.dumpLong(this.draw_htotal);
        sRDumper.dumpLong(this.draw_vtotal);
        sRDumper.dumpLong(this.draw_hblkstart);
        sRDumper.dumpLong(this.draw_hblkend);
        sRDumper.dumpLong(this.draw_vrstart);
        sRDumper.dumpLong(this.draw_vrend);
        sRDumper.dumpLong(this.draw_vdend);
        sRDumper.dumpBoolean(this.returningFromVretrace);
        sRDumper.dumpBoolean(this.vbeCapsMode);
        sRDumper.dumpInt(this.SYSFLAG_SVGATYPE);
    }

    public VGACard(SRLoader sRLoader) throws IOException {
        super(sRLoader);
        this.VGA_DRAW_LINE2 = (GraphicsUpdater)sRLoader.loadObject();
        this.VGA_DRAW_LINE2D2 = (GraphicsUpdater)sRLoader.loadObject();
        this.VGA_DRAW_LINE4 = (GraphicsUpdater)sRLoader.loadObject();
        this.VGA_DRAW_LINE4D2 = (GraphicsUpdater)sRLoader.loadObject();
        this.VGA_DRAW_LINE8 = (GraphicsUpdater)sRLoader.loadObject();
        this.VGA_DRAW_LINE8D2 = (GraphicsUpdater)sRLoader.loadObject();
        this.VGA_DRAW_LINE15 = (GraphicsUpdater)sRLoader.loadObject();
        this.VGA_DRAW_LINE16 = (GraphicsUpdater)sRLoader.loadObject();
        this.VGA_DRAW_LINE24 = (GraphicsUpdater)sRLoader.loadObject();
        this.VGA_DRAW_LINE32 = (GraphicsUpdater)sRLoader.loadObject();
        this.latch = sRLoader.loadInt();
        this.sequencerRegisterIndex = sRLoader.loadInt();
        this.graphicsRegisterIndex = sRLoader.loadInt();
        this.attributeRegisterIndex = sRLoader.loadInt();
        this.crtRegisterIndex = sRLoader.loadInt();
        this.sequencerRegister = sRLoader.loadArrayInt();
        this.graphicsRegister = sRLoader.loadArrayInt();
        this.attributeRegister = sRLoader.loadArrayInt();
        this.crtRegister = sRLoader.loadArrayInt();
        this.attributeRegisterFlipFlop = sRLoader.loadBoolean();
        this.miscellaneousOutputRegister = sRLoader.loadInt();
        this.featureControlRegister = sRLoader.loadInt();
        this.st00 = sRLoader.loadInt();
        this.st01 = sRLoader.loadInt();
        this.dacReadIndex = sRLoader.loadInt();
        this.dacWriteIndex = sRLoader.loadInt();
        this.dacSubIndex = sRLoader.loadInt();
        this.dacState = sRLoader.loadInt();
        this.shiftControl = sRLoader.loadInt();
        this.doubleScan = sRLoader.loadInt();
        this.dacCache = sRLoader.loadArrayInt();
        this.palette = sRLoader.loadArrayInt();
        this.bankOffset = sRLoader.loadInt();
        this.vbeIndex = sRLoader.loadInt();
        this.vbeRegs = sRLoader.loadArrayInt();
        this.vbeStartAddress = sRLoader.loadInt();
        this.vbeLineOffset = sRLoader.loadInt();
        this.vbeBankMask = sRLoader.loadInt();
        this.fontOffset = sRLoader.loadArrayInt();
        this.graphicMode = sRLoader.loadInt();
        this.lineOffset = sRLoader.loadInt();
        this.lineCompare = sRLoader.loadInt();
        this.startAddress = sRLoader.loadInt();
        this.pixelPanning = sRLoader.loadInt();
        this.byteSkip = sRLoader.loadInt();
        this.planeUpdated = sRLoader.loadInt();
        this.lastCW = sRLoader.loadInt();
        this.lastCH = sRLoader.loadInt();
        this.lastWidth = sRLoader.loadInt();
        this.lastHeight = sRLoader.loadInt();
        this.lastScreenWidth = sRLoader.loadInt();
        this.lastScreenHeight = sRLoader.loadInt();
        this.cursorStart = sRLoader.loadInt();
        this.cursorEnd = sRLoader.loadInt();
        this.cursorOffset = sRLoader.loadInt();
        this.lastPalette = sRLoader.loadArrayInt();
        this.lastChar = sRLoader.loadArrayInt();
        this.traceTrap = (TraceTrap)sRLoader.loadObject();
        this.ioportRegistered = sRLoader.loadBoolean();
        this.pciRegistered = sRLoader.loadBoolean();
        this.memoryRegistered = sRLoader.loadBoolean();
        this.updatingScreen = sRLoader.loadBoolean();
        this.ioRegion = (VGARAMIORegion)sRLoader.loadObject();
        this.lowIORegion = (VGALowMemoryRegion)sRLoader.loadObject();
        this.timeSource = (Clock)sRLoader.loadObject();
        this.retraceTimer = (Timer)sRLoader.loadObject();
        this.retracing = sRLoader.loadBoolean();
        this.outputDevice = (VGADigitalOut)sRLoader.loadObject();
        this.nextTimerExpiry = sRLoader.loadLong();
        this.frameNumber = sRLoader.loadLong();
        this.updated = sRLoader.loadBoolean();
        this.vgaDrawHackFlag = false;
        this.vgaScroll2HackFlag = false;
        this.SYSFLAG_VGAHRETRACE = false;
        this.usePixelPanning = this.pixelPanning;
        this.whenFrameStarted = 0L;
        this.SYSFLAG_VGATIMINGMETHOD = 0;
        this.returningFromVretrace = false;
        if (sRLoader.objectEndsHere()) {
            return;
        }
        this.vgaDrawHackFlag = sRLoader.loadBoolean();
        if (sRLoader.objectEndsHere()) {
            return;
        }
        this.SYSFLAG_VGAHRETRACE = sRLoader.loadBoolean();
        if (sRLoader.objectEndsHere()) {
            return;
        }
        this.vgaScroll2HackFlag = sRLoader.loadBoolean();
        if (sRLoader.objectEndsHere()) {
            return;
        }
        this.usePixelPanning = sRLoader.loadInt();
        if (sRLoader.objectEndsHere()) {
            return;
        }
        this.whenFrameStarted = sRLoader.loadLong();
        this.SYSFLAG_VGATIMINGMETHOD = sRLoader.loadInt();
        this.nextTimerExpiryVGA = sRLoader.loadLong();
        this.draw_htotal = sRLoader.loadLong();
        this.draw_vtotal = sRLoader.loadLong();
        this.draw_hblkstart = sRLoader.loadLong();
        this.draw_hblkend = sRLoader.loadLong();
        this.draw_vrstart = sRLoader.loadLong();
        this.draw_vrend = sRLoader.loadLong();
        this.draw_vdend = sRLoader.loadLong();
        this.returningFromVretrace = sRLoader.loadBoolean();
        if (sRLoader.objectEndsHere()) {
            return;
        }
        this.vbeCapsMode = sRLoader.loadBoolean();
        this.SYSFLAG_SVGATYPE = sRLoader.loadInt();
    }

    public void DEBUGOPTION_VGA_palette_debugging(boolean bl) {
        this.paletteDebuggingEnabled = bl;
    }

    public void setVGADrawHack() {
        this.vgaDrawHackFlag = true;
    }

    public void setVGAScroll2Hack() {
        this.vgaScroll2HackFlag = true;
    }

    @Override
    public VGADigitalOut getOutputDevice() {
        return this.outputDevice;
    }

    public VGACard() {
        this.ioportRegistered = false;
        this.memoryRegistered = false;
        this.pciRegistered = false;
        this.retracing = false;
        this.returningFromVretrace = false;
        this.timeSource = null;
        this.retraceTimer = null;
        this.nextTimerExpiry = 15000000L;
        this.nextTimerExpiryVGA = 3398625L;
        this.whenFrameStarted = 0L;
        this.draw_vrstart = 0L;
        this.draw_vrend = 3398625L;
        this.draw_vdend = 0L;
        this.draw_vtotal = 3776250L;
        this.draw_htotal = 7100L;
        this.draw_hblkstart = 0L;
        this.draw_hblkend = 0L;
        this.frameNumber = 0L;
        this.SYSFLAG_VGATIMINGMETHOD = 0;
        this.VGA_DRAW_LINE2 = new DrawLine2(this);
        this.VGA_DRAW_LINE2D2 = new DrawLine2d2(this);
        this.VGA_DRAW_LINE4 = new DrawLine4(this);
        this.VGA_DRAW_LINE4D2 = new DrawLine4d2(this);
        this.VGA_DRAW_LINE8D2 = new DrawLine8d2(this);
        this.VGA_DRAW_LINE8 = new DrawLine8(this);
        this.VGA_DRAW_LINE15 = new DrawLine15(this);
        this.VGA_DRAW_LINE16 = new DrawLine16(this);
        this.VGA_DRAW_LINE24 = new DrawLine24(this);
        this.VGA_DRAW_LINE32 = new DrawLine32(this);
        this.assignDeviceFunctionNumber(-1);
        this.setIRQIndex(16);
        this.putConfigWord(0, (short)4660);
        this.putConfigWord(2, (short)4369);
        this.putConfigWord(10, (short)768);
        this.putConfigByte(14, (byte)0);
        this.ioRegion = new VGARAMIORegion();
        this.lowIORegion = new VGALowMemoryRegion(this);
        this.outputDevice = new VGADigitalOut();
        this.lastPalette = new int[256];
        this.internalReset();
        this.bankOffset = 0;
        this.vbeRegs[0] = 45248;
        this.vbeBankMask = 255;
        this.vbeRegs[1] = 1600;
        this.vbeRegs[2] = 1200;
        this.vbeRegs[3] = 32;
    }

    public void dirtyScreen() {
        this.outputDevice.dirtyDisplayRegion(0, 0, this.outputDevice.getWidth(), this.outputDevice.getHeight());
    }

    public void setOriginalDisplaySize() {
        this.outputDevice.resizeDisplay(this.lastScreenWidth, this.lastScreenHeight);
    }

    @Override
    public IORegion[] getIORegions() {
        return new IORegion[]{this.ioRegion};
    }

    @Override
    public IORegion getIORegion(int n) {
        if (n == 0) {
            return this.ioRegion;
        }
        return null;
    }

    @Override
    public void ioPortWriteByte(int n, int n2) {
        this.vgaIOPortWriteByte(n, n2);
    }

    @Override
    public void ioPortWriteWord(int n, int n2) {
        switch (n) {
            case 462: 
            case 65408: {
                this.vbeIOPortWriteIndex(n2);
                break;
            }
            case 463: 
            case 65409: {
                this.vbeIOPortWriteData(n2);
                break;
            }
            default: {
                this.ioPortWriteByte(n, 0xFF & n2);
                this.ioPortWriteByte(n + 1, 0xFF & n2 >>> 8);
            }
        }
    }

    @Override
    public void ioPortWriteLong(int n, int n2) {
        this.ioPortWriteWord(n, 0xFFFF & n2);
        this.ioPortWriteWord(n + 2, n2 >>> 16);
    }

    @Override
    public int ioPortReadByte(int n) {
        return this.vgaIOPortReadByte(n);
    }

    @Override
    public int ioPortReadWord(int n) {
        switch (n) {
            case 462: 
            case 65408: {
                return this.vbeIOPortReadIndex();
            }
            case 463: 
            case 65409: {
                return this.vbeIOPortReadData();
            }
        }
        int n2 = 0xFF & this.ioPortReadByte(n);
        int n3 = 0xFF & this.ioPortReadByte(n + 1);
        return n2 | n3 << 8;
    }

    @Override
    public int ioPortReadLong(int n) {
        int n2 = 0xFFFF & this.ioPortReadWord(n);
        int n3 = 0xFFFF & this.ioPortReadWord(n + 2);
        return n2 | n3 << 16;
    }

    @Override
    public int[] ioPortsRequested() {
        return new int[]{948, 949, 954, 980, 981, 986, 960, 961, 962, 963, 964, 965, 966, 967, 968, 969, 970, 971, 972, 973, 974, 975, 462, 463, 65408, 65409};
    }

    private final void vgaIOPortWriteByte(int n, int n2) {
        if (n >= 944 && n <= 959 && (this.miscellaneousOutputRegister & 1) != 0 || n >= 976 && n <= 991 && (this.miscellaneousOutputRegister & 1) == 0) {
            return;
        }
        if ((n2 & 0xFFFFFF00) != 0) {
            System.err.println("Error: VGA byte sized write data out of range???");
        }
        switch (n) {
            case 948: 
            case 980: {
                this.crtRegisterIndex = n2;
                break;
            }
            case 949: 
            case 981: {
                if (this.crtRegisterIndex <= 7 && (this.crtRegister[17] & 0x80) != 0) {
                    if (this.crtRegisterIndex == 7) {
                        this.crtRegister[7] = this.crtRegister[7] & 0xFFFFFFEF | n2 & 0x10;
                    }
                    return;
                }
                this.crtRegister[this.crtRegisterIndex] = n2;
                break;
            }
            case 954: 
            case 986: {
                this.featureControlRegister = n2 & 0x10;
                break;
            }
            case 960: {
                if (!this.attributeRegisterFlipFlop) {
                    this.attributeRegisterIndex = n2 &= 0x3F;
                } else {
                    int n3 = this.attributeRegisterIndex & 0x1F;
                    switch (n3) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: {
                            this.attributeRegister[n3] = n2 & 0x3F;
                            break;
                        }
                        case 16: {
                            this.attributeRegister[16] = n2 & 0xFFFFFFEF;
                            break;
                        }
                        case 17: {
                            this.attributeRegister[17] = n2;
                            break;
                        }
                        case 18: {
                            this.attributeRegister[18] = n2 & 0xFFFFFF3F;
                            break;
                        }
                        case 19: {
                            this.attributeRegister[19] = n2 & 0xFFFFFF0F;
                            break;
                        }
                        case 20: {
                            this.attributeRegister[20] = n2 & 0xFFFFFF0F;
                            break;
                        }
                    }
                }
                this.attributeRegisterFlipFlop = !this.attributeRegisterFlipFlop;
                break;
            }
            case 962: {
                this.miscellaneousOutputRegister = n2 & 0xFFFFFFEF;
                break;
            }
            case 964: {
                this.sequencerRegisterIndex = n2 & 7;
                break;
            }
            case 965: {
                this.sequencerRegister[this.sequencerRegisterIndex] = n2 & sequencerRegisterMask[this.sequencerRegisterIndex];
                break;
            }
            case 967: {
                this.dacReadIndex = n2;
                this.dacWriteIndex = n2 + 1 & 0xFF;
                this.dacSubIndex = 0;
                this.dacState = 3;
                if (!this.paletteDebuggingEnabled) break;
                int n4 = 0;
                for (int i = 0; i < 768; ++i) {
                    n4 += this.palette[i];
                }
                System.err.println("DAC Read Index set to " + n2 + ", total palette power = " + n4);
                break;
            }
            case 968: {
                this.dacWriteIndex = n2;
                this.dacSubIndex = 0;
                this.dacState = 0;
                if (!this.paletteDebuggingEnabled) break;
                System.err.println("DAC Write Index set to " + n2);
                break;
            }
            case 969: {
                int n5;
                this.dacCache[this.dacSubIndex] = n2;
                if (++this.dacSubIndex != 3) break;
                for (n5 = 0; n5 < 3; ++n5) {
                    this.palette[(0xFF & this.dacWriteIndex) * 3 + n5] = this.dacCache[n5];
                }
                this.dacSubIndex = 0;
                ++this.dacWriteIndex;
                if (this.paletteDebuggingEnabled && (this.dacWriteIndex & 0xFF) == 0) {
                    n5 = 0;
                    for (int i = 0; i < 768; ++i) {
                        n5 += this.palette[i];
                    }
                    System.err.println("At palette end; total palette power = " + n5);
                }
                this.dacWriteIndex &= 0xFF;
                break;
            }
            case 974: {
                this.graphicsRegisterIndex = n2 & 0xF;
                break;
            }
            case 975: {
                this.graphicsRegister[this.graphicsRegisterIndex] = n2 & graphicsRegisterMask[this.graphicsRegisterIndex];
            }
        }
    }

    private final int vgaIOPortReadByte(int n) {
        if (n >= 944 && n <= 959 && (this.miscellaneousOutputRegister & 1) != 0 || n >= 976 && n <= 991 && (this.miscellaneousOutputRegister & 1) == 0) {
            return 255;
        }
        switch (n) {
            case 960: {
                if (!this.attributeRegisterFlipFlop) {
                    return this.attributeRegisterIndex;
                }
                return 0;
            }
            case 961: {
                int n2 = this.attributeRegisterIndex & 0x1F;
                if (n2 < 21) {
                    return this.attributeRegister[n2];
                }
                return 0;
            }
            case 962: {
                return this.st00;
            }
            case 964: {
                return this.sequencerRegisterIndex;
            }
            case 965: {
                return this.sequencerRegister[this.sequencerRegisterIndex];
            }
            case 967: {
                return this.dacState;
            }
            case 968: {
                return this.dacWriteIndex;
            }
            case 969: {
                int n3 = this.palette[this.dacReadIndex * 3 + this.dacSubIndex];
                if (++this.dacSubIndex == 3) {
                    this.dacSubIndex = 0;
                    this.dacReadIndex = this.dacReadIndex + 1 & 0xFF;
                }
                return n3;
            }
            case 970: {
                return this.featureControlRegister;
            }
            case 972: {
                return this.miscellaneousOutputRegister;
            }
            case 974: {
                return this.graphicsRegisterIndex;
            }
            case 975: {
                return this.graphicsRegister[this.graphicsRegisterIndex];
            }
            case 948: 
            case 980: {
                return this.crtRegisterIndex;
            }
            case 949: 
            case 981: {
                return this.crtRegister[this.crtRegisterIndex];
            }
            case 954: 
            case 986: {
                this.attributeRegisterFlipFlop = false;
                if (this.SYSFLAG_VGATIMINGMETHOD == 1) {
                    double d;
                    long l = VGACard.systemClockToVGAClock(this.timeSource.getTime()) - this.whenFrameStarted;
                    this.st01 &= 0xFFFFFFF6;
                    if (l >= this.draw_vrstart && l <= this.draw_vrend) {
                        this.st01 |= 8;
                    }
                    if (l >= this.draw_vdend) {
                        this.st01 |= 1;
                    } else if (this.SYSFLAG_VGAHRETRACE && (d = (double)(l % this.draw_htotal)) >= (double)this.draw_hblkstart && d <= (double)this.draw_hblkend) {
                        this.st01 |= 1;
                    }
                } else if (this.retracing) {
                    this.st01 |= 9;
                } else {
                    int n4 = 10 * this.lastScreenHeight;
                    int n5 = 0;
                    if (n4 == 0) {
                        n4 = 1;
                    }
                    long l = this.timeSource.getTime() - (this.nextTimerExpiry - 16666666L);
                    n5 = VGACard.rescaleValue((int)l, 16666666, n4);
                    this.st01 &= 0xFFFFFFF7;
                    this.st01 = !this.SYSFLAG_VGAHRETRACE || n5 % 10 < 9 ? (this.st01 &= 0xFFFFFFFE) : (this.st01 |= 1);
                }
                return this.st01;
            }
        }
        return 0;
    }

    private static final int rescaleValue(int n, int n2, int n3) {
        long l = (long)n * (long)n3;
        return (int)(l / (long)n2);
    }

    private final void vbeIOPortWriteIndex(int n) {
        this.vbeIndex = n;
    }

    private final void vbeIOPortWriteData(int n) {
        if (this.vbeIndex < 10) {
            switch (this.vbeIndex) {
                case 0: {
                    if (n != 45248 && n != 45249 && n != 45250 && (n != 45251 && n != 45252 && n != 45253 || this.SYSFLAG_SVGATYPE != 1)) break;
                    this.vbeRegs[this.vbeIndex] = n;
                    break;
                }
                case 1: {
                    if (n > 1600 || (n & 7) != 0) break;
                    this.vbeRegs[this.vbeIndex] = n;
                    break;
                }
                case 2: {
                    if (n > 1200) break;
                    this.vbeRegs[this.vbeIndex] = n;
                    break;
                }
                case 3: {
                    if (n == 0) {
                        n = 8;
                    }
                    if (n != 4 && n != 8 && n != 15 && n != 16 && n != 24 && n != 32) break;
                    this.vbeRegs[this.vbeIndex] = n;
                    break;
                }
                case 5: {
                    this.vbeRegs[this.vbeIndex] = n &= this.vbeBankMask;
                    this.bankOffset = n << 16;
                    break;
                }
                case 4: {
                    boolean bl = this.vbeCapsMode = (n & 2) != 0;
                    if ((n & 1) != 0) {
                        int n2;
                        int n3;
                        this.vbeRegs[6] = this.vbeRegs[1];
                        this.vbeRegs[7] = this.vbeRegs[2];
                        this.vbeRegs[8] = 0;
                        this.vbeRegs[9] = 0;
                        this.vbeLineOffset = this.vbeRegs[3] == 4 ? this.vbeRegs[1] >>> 1 : this.vbeRegs[1] * (this.vbeRegs[3] + 7 >>> 3);
                        this.vbeStartAddress = 0;
                        if ((n & 0x80) == 0) {
                            n3 = this.vbeRegs[2] * this.vbeLineOffset;
                            for (n2 = 0; n2 < n3; ++n2) {
                                this.ioRegion.setByte(n2, (byte)0);
                            }
                        }
                        this.graphicsRegister[6] = this.graphicsRegister[6] & 0xFFFFFFF3 | 5;
                        this.crtRegister[23] = this.crtRegister[23] | 3;
                        this.crtRegister[19] = this.vbeLineOffset >>> 3;
                        this.crtRegister[1] = (this.vbeRegs[1] >>> 3) - 1;
                        this.crtRegister[18] = n3 = this.vbeRegs[2] - 1;
                        this.crtRegister[7] = this.crtRegister[7] & 0xFFFFFFBD | n3 >>> 7 & 2 | n3 >>> 3 & 0x40;
                        this.crtRegister[24] = 255;
                        this.crtRegister[7] = this.crtRegister[7] | 0x10;
                        this.crtRegister[9] = this.crtRegister[9] | 0x40;
                        if (this.vbeRegs[3] == 4) {
                            n2 = 0;
                            this.sequencerRegister[1] = this.sequencerRegister[1] & 0xFFFFFFF7;
                        } else {
                            n2 = 2;
                            this.sequencerRegister[4] = this.sequencerRegister[4] | 8;
                            this.sequencerRegister[2] = this.sequencerRegister[2] | 0xF;
                        }
                        this.graphicsRegister[5] = this.graphicsRegister[5] & 0xFFFFFF9F | n2 << 5;
                        this.crtRegister[9] = this.crtRegister[9] & 0xFFFFFF60;
                    } else {
                        this.bankOffset = 0;
                    }
                    this.vbeRegs[this.vbeIndex] = n;
                    break;
                }
                case 6: {
                    if (n < this.vbeRegs[1]) {
                        return;
                    }
                    int n4 = n;
                    int n5 = this.vbeRegs[3] == 4 ? n >>> 1 : n * (this.vbeRegs[3] + 7 >>> 3);
                    int n6 = 0x1000000 / n5;
                    if (n6 < this.vbeRegs[2]) {
                        return;
                    }
                    this.vbeRegs[6] = n4;
                    this.vbeRegs[7] = n6;
                    this.vbeLineOffset = n5;
                    break;
                }
                case 8: 
                case 9: {
                    this.vbeRegs[this.vbeIndex] = n;
                    this.vbeStartAddress = this.vbeLineOffset * this.vbeRegs[9];
                    int n7 = this.vbeRegs[8];
                    this.vbeStartAddress = this.vbeRegs[3] == 4 ? (this.vbeStartAddress += n7 >>> 1) : (this.vbeStartAddress += n7 * (this.vbeRegs[3] + 7 >>> 3));
                    this.vbeStartAddress >>>= 2;
                    break;
                }
                default: {
                    System.err.println("Warning: Invalid VBE write mode: vbeIndex=" + this.vbeIndex);
                }
            }
        }
    }

    private final int vbeIOPortReadIndex() {
        return this.vbeIndex;
    }

    private final int vbeIOPortReadData() {
        if (this.vbeCapsMode && this.vbeIndex == 1) {
            return 1600;
        }
        if (this.vbeCapsMode && this.vbeIndex == 2) {
            return 1200;
        }
        if (this.vbeCapsMode && this.vbeIndex == 3) {
            return 32;
        }
        if (this.vbeIndex < 10) {
            return this.vbeRegs[this.vbeIndex];
        }
        if (this.vbeIndex == 10) {
            return 256;
        }
        return 0;
    }

    private final void internalReset() {
        this.latch = 0;
        this.crtRegisterIndex = 0;
        this.attributeRegisterIndex = 0;
        this.graphicsRegisterIndex = 0;
        this.sequencerRegisterIndex = 0;
        this.attributeRegisterFlipFlop = false;
        this.miscellaneousOutputRegister = 0;
        this.featureControlRegister = 0;
        this.st01 = 0;
        this.st00 = 0;
        this.dacWriteIndex = 0;
        this.dacReadIndex = 0;
        this.dacSubIndex = 0;
        this.dacState = 0;
        this.doubleScan = 0;
        this.shiftControl = 0;
        this.bankOffset = 0;
        this.vbeIndex = 0;
        this.vbeStartAddress = 0;
        this.vbeLineOffset = 0;
        this.vbeBankMask = 0;
        this.graphicMode = 0;
        this.lineOffset = 0;
        this.lineCompare = 0;
        this.startAddress = 0;
        this.pixelPanning = 0;
        this.usePixelPanning = 0;
        this.byteSkip = 0;
        this.planeUpdated = 0;
        this.lastCH = 0;
        this.lastCW = 0;
        this.lastHeight = 0;
        this.lastWidth = 0;
        this.lastScreenHeight = 0;
        this.lastScreenWidth = 0;
        this.cursorEnd = 0;
        this.cursorStart = 0;
        this.cursorOffset = 0;
        this.lastChar = new int[16000];
        this.fontOffset = new int[2];
        this.vbeRegs = new int[10];
        this.dacCache = new int[3];
        this.palette = new int[768];
        this.sequencerRegister = new int[256];
        this.graphicsRegister = new int[256];
        this.attributeRegister = new int[256];
        this.crtRegister = new int[256];
        this.graphicMode = -1;
    }

    @Override
    public long getFrameNumber() {
        return this.frameNumber;
    }

    @Override
    public int getWidth() {
        return this.lastScreenWidth;
    }

    @Override
    public int getHeight() {
        return this.lastScreenHeight;
    }

    public final void updateDisplay() {
        this.updatingScreen = true;
        this.outputDevice.resetDirtyRegion();
        boolean bl = this.updated;
        int n = (this.attributeRegisterIndex & 0x20) == 0 ? 2 : this.graphicsRegister[6] & 1;
        if (n != this.graphicMode) {
            this.graphicMode = n;
            bl = true;
        }
        switch (this.graphicMode) {
            case 0: {
                this.drawText(bl);
                break;
            }
            case 1: {
                this.drawGraphic(bl);
                break;
            }
            default: {
                this.drawBlank(bl);
            }
        }
        this.updatingScreen = false;
    }

    private final void drawText(boolean bl) {
        int n;
        int n2;
        boolean bl2 = this.updatePalette16();
        bl |= bl2;
        int[] nArray = this.lastPalette;
        int n3 = this.sequencerRegister[3];
        int n4 = (n3 >>> 4 & 1 | n3 << 1 & 6) * 8192 * 4 + 2;
        if (n4 != this.fontOffset[0]) {
            this.fontOffset[0] = n4;
            bl = true;
        }
        if ((n4 = (n3 >>> 5 & 1 | n3 >>> 1 & 6) * 8192 * 4 + 2) != this.fontOffset[1]) {
            this.fontOffset[1] = n4;
            bl = true;
        }
        if ((this.planeUpdated & 4) != 0) {
            this.planeUpdated = 0;
            bl = true;
        }
        int n5 = this.startAddress * 4;
        int n6 = (this.crtRegister[9] & 0x1F) + 1;
        int n7 = 8;
        if ((this.sequencerRegister[1] & 1) == 0) {
            n7 = 9;
        }
        if ((this.sequencerRegister[1] & 8) != 0) {
            n7 = 16;
        }
        int n8 = this.crtRegister[1] + 1;
        if (this.crtRegister[6] == 100) {
            n2 = 100;
        } else {
            n2 = this.crtRegister[18] | (this.crtRegister[7] & 2) << 7 | (this.crtRegister[7] & 0x40) << 3;
            n2 = (n2 + 1) / n6;
        }
        if (n2 * n8 > 16000) {
            return;
        }
        if (n8 != this.lastWidth || n2 != this.lastHeight || n7 != this.lastCW || n6 != this.lastCH) {
            this.lastScreenWidth = n8 * n7;
            this.lastScreenHeight = n2 * n6;
            this.outputDevice.resizeDisplay(this.lastScreenWidth, this.lastScreenHeight);
            this.lastWidth = n8;
            this.lastHeight = n2;
            this.lastCH = n6;
            this.lastCW = n7;
            bl = true;
        }
        if ((n = (this.crtRegister[14] << 8 | this.crtRegister[15]) - this.startAddress) != this.cursorOffset || this.crtRegister[10] != this.cursorStart || this.crtRegister[11] != this.cursorEnd) {
            if (this.cursorOffset < 16000 && this.cursorOffset >= 0) {
                this.lastChar[this.cursorOffset] = -1;
            }
            if (n < 16000 && n >= 0) {
                this.lastChar[n] = -1;
            }
            this.cursorOffset = n;
            this.cursorStart = this.crtRegister[10];
            this.cursorEnd = this.crtRegister[11];
        }
        int n9 = (this.startAddress + this.cursorOffset) * 4;
        int n10 = 0;
        switch (n7) {
            case 8: {
                for (int i = 0; i < n2; ++i) {
                    int n11 = n5;
                    for (int j = 0; j < n8; ++j) {
                        int n12 = 0xFFFF & this.ioRegion.getWord(n11);
                        if (bl || n12 != this.lastChar[n10]) {
                            this.lastChar[n10] = n12;
                            int n13 = 0xFF & n12;
                            int n14 = n12 >>> 8;
                            int n15 = this.fontOffset[n14 >>> 3 & 1] + 128 * n13;
                            int n16 = nArray[n14 >>> 4];
                            int n17 = nArray[n14 & 0xF];
                            this.drawGlyph8(this.outputDevice.getDisplayBuffer(), i * n6 * this.lastScreenWidth + j * 8, this.lastScreenWidth, n15, n6, n17, n16);
                            this.outputDevice.dirtyDisplayRegion(j * 8, i * n6, 8, n6);
                            if (n11 == n9 && (this.crtRegister[10] & 0x20) == 0) {
                                int n18 = this.crtRegister[10] & 0x1F;
                                int n19 = this.crtRegister[11] & 0x1F;
                                if (n19 > n6 - 1) {
                                    n19 = n6 - 1;
                                }
                                if (n19 >= n18 && n18 < n6) {
                                    int n20 = n19 - n18 + 1;
                                    this.drawCursorGlyph8(this.outputDevice.getDisplayBuffer(), (i * n6 + n18) * this.lastScreenWidth + j * 8, this.lastScreenWidth, n20, n17, n16);
                                    this.outputDevice.dirtyDisplayRegion(j * 8, i * n6 + n18, 8, n20);
                                }
                            }
                        }
                        n11 += 4;
                        ++n10;
                    }
                    n5 += this.lineOffset;
                }
                return;
            }
            case 9: {
                for (int i = 0; i < n2; ++i) {
                    int n21 = n5;
                    for (int j = 0; j < n8; ++j) {
                        int n22 = 0xFFFF & this.ioRegion.getWord(n21);
                        if (bl || n22 != this.lastChar[n10]) {
                            this.lastChar[n10] = n22;
                            int n23 = 0xFF & n22;
                            int n24 = n22 >>> 8;
                            int n25 = this.fontOffset[n24 >>> 3 & 1] + 128 * n23;
                            int n26 = nArray[n24 >>> 4];
                            int n27 = nArray[n24 & 0xF];
                            boolean bl3 = n23 >= 176 && n23 <= 223 && (this.attributeRegister[16] & 4) != 0;
                            this.drawGlyph9(this.outputDevice.getDisplayBuffer(), i * n6 * this.lastScreenWidth + j * 9, this.lastScreenWidth, n25, n6, n27, n26, bl3);
                            this.outputDevice.dirtyDisplayRegion(j * 9, i * n6, 9, n6);
                            if (n21 == n9 && (this.crtRegister[10] & 0x20) == 0) {
                                int n28 = this.crtRegister[10] & 0x1F;
                                int n29 = this.crtRegister[11] & 0x1F;
                                if (n29 > n6 - 1) {
                                    n29 = n6 - 1;
                                }
                                if (n29 >= n28 && n28 < n6) {
                                    int n30 = n29 - n28 + 1;
                                    this.drawCursorGlyph9(this.outputDevice.getDisplayBuffer(), (i * n6 + n28) * this.lastScreenWidth + j * 9, this.lastScreenWidth, n30, n27, n26);
                                    this.outputDevice.dirtyDisplayRegion(j * 9, i * n6 + n28, 9, n30);
                                }
                            }
                        }
                        n21 += 4;
                        ++n10;
                    }
                    n5 += this.lineOffset;
                }
                return;
            }
            case 16: {
                for (int i = 0; i < n2; ++i) {
                    int n31 = n5;
                    for (int j = 0; j < n8; ++j) {
                        int n32 = 0xFFFF & this.ioRegion.getWord(n31);
                        if (bl || n32 != this.lastChar[n10]) {
                            this.lastChar[n10] = n32;
                            int n33 = 0xFF & n32;
                            int n34 = n32 >>> 8;
                            int n35 = this.fontOffset[n34 >>> 3 & 1] + 128 * n33;
                            int n36 = nArray[n34 >>> 4];
                            int n37 = nArray[n34 & 0xF];
                            this.drawGlyph16(this.outputDevice.getDisplayBuffer(), i * n6 * this.lastScreenWidth + j * 16, this.lastScreenWidth, n35, n6, n37, n36);
                            this.outputDevice.dirtyDisplayRegion(j * 16, i * n6, 16, n6);
                            if (n31 == n9 && (this.crtRegister[10] & 0x20) == 0) {
                                int n38 = this.crtRegister[10] & 0x1F;
                                int n39 = this.crtRegister[11] & 0x1F;
                                if (n39 > n6 - 1) {
                                    n39 = n6 - 1;
                                }
                                if (n39 >= n38 && n38 < n6) {
                                    int n40 = n39 - n38 + 1;
                                    this.drawCursorGlyph16(this.outputDevice.getDisplayBuffer(), (i * n6 + n38) * this.lastScreenWidth + j * 16, this.lastScreenWidth, n40, n37, n36);
                                    this.outputDevice.dirtyDisplayRegion(j * 16, i * n6 + n38, 16, n40);
                                }
                            }
                        }
                        n31 += 4;
                        ++n10;
                    }
                    n5 += this.lineOffset;
                }
                return;
            }
        }
        System.err.println("Warning: Unknown character width " + Integer.valueOf(n7) + ".");
    }

    private final void drawGraphic(boolean bl) {
        boolean bl2 = false;
        int n = (this.crtRegister[1] + 1) * 8;
        int n2 = (this.crtRegister[18] | (this.crtRegister[7] & 2) << 7 | (this.crtRegister[7] & 0x40) << 3) + 1;
        if ((this.vbeRegs[4] & 1) != 0) {
            n = this.vbeRegs[1];
            n2 = this.vbeRegs[2];
        }
        int n3 = n;
        int n4 = this.graphicsRegister[5] >>> 5 & 3;
        int n5 = this.crtRegister[9] >>> 7;
        int n6 = n4 != 1 ? ((this.crtRegister[9] & 0x1F) + 1 << n5) - 1 : n5;
        if (n4 != this.shiftControl || n5 != this.doubleScan) {
            bl = true;
            this.shiftControl = n4;
            this.doubleScan = n5;
        }
        GraphicsUpdater graphicsUpdater = null;
        if (this.shiftControl == 0) {
            bl2 = this.updatePalette16();
            bl |= bl2;
            if ((this.sequencerRegister[1] & 8) != 0) {
                graphicsUpdater = this.VGA_DRAW_LINE4D2;
                n3 <<= 1;
            } else {
                graphicsUpdater = this.VGA_DRAW_LINE4;
            }
        } else if (this.shiftControl == 1) {
            bl2 = this.updatePalette16();
            bl |= bl2;
            if ((this.sequencerRegister[1] & 8) != 0) {
                graphicsUpdater = this.VGA_DRAW_LINE2D2;
                n3 <<= 1;
            } else {
                graphicsUpdater = this.VGA_DRAW_LINE2;
            }
        } else {
            int n7 = 0;
            if ((this.vbeRegs[4] & 1) != 0) {
                n7 = this.vbeRegs[3];
            }
            switch (n7) {
                default: {
                    bl2 = this.updatePalette256();
                    bl |= bl2;
                    graphicsUpdater = this.VGA_DRAW_LINE8D2;
                    break;
                }
                case 8: {
                    bl2 = this.updatePalette256();
                    bl |= bl2;
                    graphicsUpdater = this.VGA_DRAW_LINE8;
                    break;
                }
                case 15: {
                    graphicsUpdater = this.VGA_DRAW_LINE15;
                    break;
                }
                case 16: {
                    graphicsUpdater = this.VGA_DRAW_LINE16;
                    break;
                }
                case 24: {
                    graphicsUpdater = this.VGA_DRAW_LINE24;
                    break;
                }
                case 32: {
                    graphicsUpdater = this.VGA_DRAW_LINE32;
                }
            }
        }
        if (n3 != this.lastWidth || n2 != this.lastHeight) {
            bl = true;
            this.lastScreenWidth = this.lastWidth = n3;
            this.lastScreenHeight = this.lastHeight = n2;
            this.outputDevice.resizeDisplay(this.lastScreenWidth, this.lastScreenHeight);
        }
        graphicsUpdater.updateDisplay(n, n2, n3, bl, n6);
    }

    private final void drawBlank(boolean bl) {
        if (!bl) {
            return;
        }
        if (this.lastScreenWidth <= 0 || this.lastScreenHeight <= 0) {
            return;
        }
        int[] nArray = this.outputDevice.getDisplayBuffer();
        int n = this.outputDevice.rgbToPixel(0, 0, 0);
        for (int i = nArray.length - 1; i >= 0; --i) {
            nArray[i] = n;
        }
        this.outputDevice.dirtyDisplayRegion(0, 0, this.lastScreenWidth, this.lastScreenHeight);
    }

    private final boolean updatePalette16() {
        boolean bl = false;
        int[] nArray = this.lastPalette;
        for (int i = 0; i <= 15; ++i) {
            int n = this.attributeRegister[i];
            n = (this.attributeRegister[16] & 0x80) != 0 ? (this.attributeRegister[20] & 0xF) << 4 | n & 0xF : (this.attributeRegister[20] & 0xC) << 4 | n & 0x3F;
            int n2 = (this.vbeRegs[4] & 0x20) == 32 ? this.outputDevice.rgbToPixel(this.palette[n], this.palette[n + 1], this.palette[n + 2]) : this.outputDevice.rgbToPixel(VGACard.c6to8(this.palette[n *= 3]), VGACard.c6to8(this.palette[n + 1]), VGACard.c6to8(this.palette[n + 2]));
            if (n2 == nArray[i]) continue;
            bl = true;
            nArray[i] = n2;
        }
        return bl;
    }

    private final boolean updatePalette256() {
        boolean bl = false;
        int[] nArray = this.lastPalette;
        int n = 0;
        int n2 = 0;
        while (n < 256) {
            int n3 = (this.vbeRegs[4] & 0x20) == 32 ? this.outputDevice.rgbToPixel(this.palette[n2], this.palette[n2 + 1], this.palette[n2 + 2]) : this.outputDevice.rgbToPixel(VGACard.c6to8(this.palette[n2]), VGACard.c6to8(this.palette[n2 + 1]), VGACard.c6to8(this.palette[n2 + 2]));
            if (n3 != nArray[n]) {
                bl = true;
                nArray[n] = n3;
            }
            ++n;
            n2 += 3;
        }
        return bl;
    }

    private final boolean updateBasicParameters() {
        int n;
        int n2;
        int n3;
        int n4;
        if ((this.vbeRegs[4] & 1) != 0) {
            n4 = this.vbeLineOffset;
            n3 = this.vbeStartAddress;
            n2 = 0;
            n = 0;
        } else {
            n4 = this.crtRegister[19];
            n4 <<= 3;
            n3 = this.crtRegister[13] | this.crtRegister[12] << 8;
            n = this.attributeRegister[19] & 0xF;
            n2 = this.crtRegister[8] >> 5 & 3;
        }
        int n5 = this.crtRegister[24] | (this.crtRegister[7] & 0x10) << 4 | (this.crtRegister[9] & 0x40) << 3;
        this.redoTimingCalculations();
        if (n4 != this.lineOffset || n3 != this.startAddress || n5 != this.lineCompare || n != this.pixelPanning || n2 != this.byteSkip) {
            this.lineOffset = n4;
            this.startAddress = n3;
            this.lineCompare = n5;
            this.usePixelPanning = this.pixelPanning = n;
            this.byteSkip = n2;
            return true;
        }
        return false;
    }

    private static final int c6to8(int n) {
        int n2 = (n &= 0x3F) & 1;
        return n << 2 | n2 << 1 | n2;
    }

    private final void drawGlyph8(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n6 ^ n5;
        n2 -= 8;
        do {
            byte by = this.ioRegion.getByte(n3);
            for (int i = 7; i >= 0; --i) {
                int n8 = -(by >>> i & 1) & n7 ^ n6;
                nArray[n++] = n8;
            }
            n3 += 4;
            n += n2;
        } while (--n4 != 0);
    }

    private final void drawGlyph16(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n6 ^ n5;
        n2 -= 16;
        do {
            int n8;
            int n9;
            byte by = this.ioRegion.getByte(n3);
            int n10 = expand4to8[by >>> 4 & 0xF];
            for (n9 = 7; n9 >= 0; --n9) {
                n8 = -(n10 >>> n9 & 1) & n7 ^ n6;
                nArray[n++] = n8;
            }
            n10 = expand4to8[by & 0xF];
            for (n9 = 7; n9 >= 0; --n9) {
                n8 = -(n10 >>> n9 & 1) & n7 ^ n6;
                nArray[n++] = n8;
            }
            n3 += 4;
            n += n2;
        } while (--n4 != 0);
    }

    private final void drawGlyph9(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        int n7 = n6 ^ n5;
        n2 -= 9;
        if (bl) {
            do {
                byte by = this.ioRegion.getByte(n3);
                for (int i = 7; i >= 0; --i) {
                    int n8 = -(by >>> i & 1) & n7 ^ n6;
                    nArray[n++] = n8;
                }
                nArray[n++] = nArray[n - 2];
                n3 += 4;
                n += n2;
            } while (--n4 != 0);
        } else {
            do {
                byte by = this.ioRegion.getByte(n3);
                for (int i = 7; i >= 0; --i) {
                    int n9 = -(by >>> i & 1) & n7 ^ n6;
                    nArray[n++] = n9;
                }
                nArray[n++] = n6;
                n3 += 4;
                n += n2;
            } while (--n4 != 0);
        }
    }

    private final void drawCursorGlyph8(int[] nArray, int n, int n2, int n3, int n4, int n5) {
        int n6 = n5 ^ n4;
        int n7 = 0;
        n2 -= 8;
        do {
            int n8 = cursorGlyph[n7];
            for (int i = 7; i >= 0; --i) {
                int n9 = -(n8 >>> i & 1) & n6 ^ n5;
                nArray[n++] = n9;
            }
            n7 += 4;
            n += n2;
        } while (--n3 != 0);
    }

    private final void drawCursorGlyph16(int[] nArray, int n, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        int n7 = n5 ^ n4;
        n2 -= 16;
        do {
            int n8;
            int n9;
            int n10 = cursorGlyph[n6];
            int n11 = expand4to8[n10 >>> 4 & 0xF];
            for (n9 = 7; n9 >= 0; --n9) {
                n8 = -(n11 >>> n9 & 1) & n7 ^ n5;
                nArray[n++] = n8;
            }
            n11 = expand4to8[n10 & 0xF];
            for (n9 = 7; n9 >= 0; --n9) {
                n8 = -(n11 >>> n9 & 1) & n7 ^ n5;
                nArray[n++] = n8;
            }
            n6 += 4;
            n += n2;
        } while (--n3 != 0);
    }

    private final void drawCursorGlyph9(int[] nArray, int n, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        int n7 = n5 ^ n4;
        n2 -= 9;
        do {
            int n8 = cursorGlyph[n6];
            for (int i = 7; i >= 0; --i) {
                int n9 = -(n8 >>> i & 1) & n7 ^ n5;
                nArray[n++] = n9;
            }
            nArray[n++] = nArray[n - 2];
            ++n6;
            n += n2;
        } while (--n3 != 0);
    }

    private void redoTimingCalculations() {
        if (this.SYSFLAG_VGATIMINGMETHOD == 0) {
            return;
        }
        if ((this.vbeRegs[4] & 1) != 0) {
            return;
        }
        int n = this.crtRegister[0];
        int n2 = this.crtRegister[1];
        int n3 = this.crtRegister[3] & 0x1F;
        int n4 = this.crtRegister[2];
        int n5 = this.crtRegister[4];
        int n6 = this.crtRegister[6] | (this.crtRegister[7] & 1) << 8;
        int n7 = this.crtRegister[18] | (this.crtRegister[7] & 2) << 7;
        int n8 = this.crtRegister[21] | (this.crtRegister[7] & 8) << 5;
        int n9 = this.crtRegister[16] + ((this.crtRegister[7] & 4) << 6);
        n += 3;
        n3 |= (this.crtRegister[5] & 0x80) >>> 2;
        n6 |= (this.crtRegister[7] & 0x20) << 4;
        n7 |= (this.crtRegister[7] & 0x40) << 3;
        n8 |= (this.crtRegister[9] & 0x20) << 4;
        n9 |= (this.crtRegister[7] & 0x80) << 2;
        int n10 = this.crtRegister[22] & 0x3F;
        n += 2;
        n6 += 2;
        ++n2;
        ++n7;
        n3 = n4 + (n3 - n4 & 0x3F);
        int n11 = this.crtRegister[22] & 0x1F;
        n11 = (n11 = n11 - n5 & 0x1F) == 0 ? n5 + 31 + 1 : n5 + n11;
        int n12 = this.crtRegister[17] & 0xF;
        n12 = n12 - n9 & 0xF;
        n12 = n12 == 0 ? n9 + 15 + 1 : n9 + n12;
        n10 = n10 - n8 & 0x3F;
        n10 = n10 == 0 ? n8 + 63 + 1 : n8 + n10;
        int n13 = 8;
        if ((this.miscellaneousOutputRegister >>> 2 & 3) == 0) {
            n13 = 9;
        }
        if (n <= 10) {
            n = 256;
        }
        if (n6 <= 10) {
            n6 = 256;
        }
        n13 = (this.sequencerRegister[1] & 1) != 0 ? (n13 *= 8) : (n13 *= 9);
        if ((this.sequencerRegister[1] & 8) != 0) {
            n *= 2;
        }
        int n14 = (this.crtRegister[9] & 0x1F) + 1;
        if ((this.crtRegister[9] & 0x80) != 0) {
            n14 *= 2;
        }
        this.draw_htotal = n * n13;
        this.draw_vtotal = this.draw_htotal * (long)n6;
        this.draw_hblkstart = n4 * n13;
        this.draw_hblkend = n3 * n13;
        this.draw_vrstart = (long)n9 * this.draw_htotal;
        this.draw_vrend = (long)n12 * this.draw_htotal;
        this.draw_vdend = (long)n7 * this.draw_htotal;
    }

    @Override
    public boolean initialised() {
        return this.ioportRegistered && this.pciRegistered && this.memoryRegistered && this.timeSource != null && this.traceTrap != null;
    }

    @Override
    public void reset() {
        this.ioportRegistered = false;
        this.memoryRegistered = false;
        this.pciRegistered = false;
        this.assignDeviceFunctionNumber(-1);
        this.setIRQIndex(16);
        this.putConfigWord(0, (short)4660);
        this.putConfigWord(2, (short)4369);
        this.putConfigWord(10, (short)768);
        this.putConfigByte(14, (byte)0);
        this.sequencerRegister = new int[256];
        this.graphicsRegister = new int[256];
        this.attributeRegister = new int[256];
        this.crtRegister = new int[256];
        this.dacCache = new int[3];
        this.palette = new int[768];
        this.ioRegion = new VGARAMIORegion();
        this.vbeRegs = new int[10];
        this.fontOffset = new int[2];
        this.lastChar = new int[16000];
        this.internalReset();
        this.bankOffset = 0;
        this.vbeRegs[0] = 45248;
        this.vbeBankMask = 255;
        super.reset();
        this.redoTimingCalculations();
    }

    @Override
    public int getTimerType() {
        return 7;
    }

    @Override
    public void callback() {
        switch (this.SYSFLAG_VGATIMINGMETHOD) {
            case 0: {
                if (this.retracing) {
                    this.retracing = false;
                    if (!this.vgaDrawHackFlag) {
                        this.updated = this.updateBasicParameters();
                    }
                    this.nextTimerExpiry += 15000000L;
                    this.retraceTimer.setExpiry(this.nextTimerExpiry);
                    this.traceTrap.doPotentialTrap(2L);
                    break;
                }
                this.retracing = true;
                if (this.vgaDrawHackFlag) {
                    this.updated = this.updateBasicParameters();
                }
                this.updateDisplay();
                ++this.frameNumber;
                this.outputDevice.holdOutput(this.nextTimerExpiry);
                long l = 1666667L;
                if ((this.frameNumber - 1L) % 3L == 0L) {
                    l = 1666666L;
                }
                this.nextTimerExpiry += l;
                this.retraceTimer.setExpiry(this.nextTimerExpiry);
                this.traceTrap.doPotentialTrap(1L);
                break;
            }
            case 1: {
                if (this.retracing) {
                    this.retracing = false;
                    if (!this.vgaDrawHackFlag) {
                        this.updated = this.updateBasicParameters();
                    }
                    long l = 0L;
                    if (this.draw_vtotal > this.draw_vrend) {
                        l = this.draw_vtotal - this.draw_vrend;
                        this.returningFromVretrace = true;
                    } else {
                        l = this.draw_vrstart;
                        this.whenFrameStarted = this.nextTimerExpiryVGA;
                        this.returningFromVretrace = false;
                    }
                    this.nextTimerExpiryVGA += l;
                    this.nextTimerExpiry = VGACard.vgaClockToSystemClock(this.nextTimerExpiryVGA);
                    this.retraceTimer.setExpiry(this.nextTimerExpiry);
                    this.traceTrap.doPotentialTrap(2L);
                    break;
                }
                if (!this.returningFromVretrace) {
                    this.retracing = true;
                    if (this.vgaDrawHackFlag) {
                        this.updated = this.updateBasicParameters();
                    }
                    this.updateDisplay();
                    ++this.frameNumber;
                    this.outputDevice.holdOutput(this.nextTimerExpiry);
                    long l = this.draw_vrend - this.draw_vrstart;
                    this.nextTimerExpiryVGA += l;
                    this.nextTimerExpiry = VGACard.vgaClockToSystemClock(this.nextTimerExpiryVGA);
                    this.retraceTimer.setExpiry(this.nextTimerExpiry);
                    this.traceTrap.doPotentialTrap(1L);
                    break;
                }
                long l = this.draw_vrstart;
                this.whenFrameStarted = this.nextTimerExpiryVGA;
                this.nextTimerExpiryVGA += l;
                this.nextTimerExpiry = VGACard.vgaClockToSystemClock(this.nextTimerExpiryVGA);
                this.retraceTimer.setExpiry(this.nextTimerExpiry);
                this.returningFromVretrace = false;
            }
        }
    }

    @Override
    public void acceptComponent(HardwareComponent hardwareComponent) {
        if (hardwareComponent instanceof PCIBus && hardwareComponent.initialised()) {
            ((PCIBus)hardwareComponent).registerDevice(this);
            this.pciRegistered = true;
        }
        if (hardwareComponent instanceof IOPortHandler && hardwareComponent.initialised()) {
            ((IOPortHandler)hardwareComponent).registerIOPortCapable(this);
            this.ioportRegistered = true;
        }
        if (hardwareComponent instanceof PhysicalAddressSpace && hardwareComponent.initialised()) {
            ((PhysicalAddressSpace)hardwareComponent).mapMemoryRegion(this.lowIORegion, 655360, 131072);
            this.memoryRegistered = true;
        }
        if (hardwareComponent instanceof TraceTrap && hardwareComponent.initialised()) {
            this.traceTrap = (TraceTrap)hardwareComponent;
        }
        if (hardwareComponent instanceof Clock && hardwareComponent.initialised() && hardwareComponent != this.timeSource) {
            this.timeSource = (Clock)hardwareComponent;
            this.retraceTimer = this.timeSource.newTimer(this);
            this.retraceTimer.setExpiry(this.nextTimerExpiry);
        }
    }

    @Override
    public boolean wantsMappingUpdate() {
        return true;
    }

    public String toString() {
        return "VGA Card [Mode: " + this.lastScreenWidth + " x " + this.lastScreenHeight + "]";
    }

    static {
        int n;
        int n2;
        int n3;
        expand4 = new int[256];
        for (n3 = 0; n3 < expand4.length; ++n3) {
            n2 = 0;
            for (n = 0; n < 8; ++n) {
                n2 |= (n3 >>> n & 1) << n * 4;
            }
            VGACard.expand4[n3] = n2;
        }
        expand2 = new int[256];
        for (n3 = 0; n3 < expand2.length; ++n3) {
            n2 = 0;
            for (n = 0; n < 4; ++n) {
                n2 |= (n3 >>> 2 * n & 3) << n * 4;
            }
            VGACard.expand2[n3] = n2;
        }
        expand4to8 = new int[16];
        for (n3 = 0; n3 < expand4to8.length; ++n3) {
            n2 = 0;
            for (n = 0; n < 4; ++n) {
                int n4 = n3 >>> n & 1;
                n2 |= n4 << 2 * n;
                n2 |= n4 << 2 * n + 1;
            }
            VGACard.expand4to8[n3] = n2;
        }
        sequencerRegisterMask = new int[]{3, 61, 15, 63, 14, 0, 0, 255};
        graphicsRegisterMask = new int[]{15, 15, 15, 31, 3, 123, 15, 15, 255, 0, 0, 0, 0, 0, 0, 0};
        mask16 = new int[]{0, 255, 65280, 65535, 0xFF0000, 0xFF00FF, 0xFFFF00, 0xFFFFFF, -16777216, -16776961, -16711936, -16711681, -65536, -65281, -256, -1};
        cursorGlyph = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    }

    public static class DrawLine32
    extends GraphicsUpdater {
        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
            super.dumpSRPartial(sRDumper);
        }

        public DrawLine32(SRLoader sRLoader) throws IOException {
            super(sRLoader);
        }

        public DrawLine32(VGACard vGACard) {
            super(vGACard);
        }

        @Override
        public void dumpStatusPartial(StatusDumper statusDumper) {
            super.dumpStatusPartial(statusDumper);
        }

        @Override
        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": DrawLine32:");
            this.dumpStatusPartial(statusDumper);
            statusDumper.endObject();
        }

        @Override
        int byteWidth(int n) {
            return n * 4;
        }

        @Override
        void drawLine(int n, int n2, int n3, int n4) {
            int[] nArray = this.upperBackref.outputDevice.getDisplayBuffer();
            int n5 = n3 * n4;
            do {
                int n6 = 0xFF & this.upperBackref.ioRegion.getByte(n++);
                int n7 = 0xFF & this.upperBackref.ioRegion.getByte(n++);
                int n8 = 0xFF & this.upperBackref.ioRegion.getByte(n++);
                ++n;
                nArray[n5++] = this.upperBackref.outputDevice.rgbToPixel(n8, n7, n6);
            } while (--n2 != 0);
            this.upperBackref.outputDevice.dirtyDisplayRegion(0, n3, n4, 1);
        }
    }

    public static class DrawLine24
    extends GraphicsUpdater {
        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
            super.dumpSRPartial(sRDumper);
        }

        public DrawLine24(SRLoader sRLoader) throws IOException {
            super(sRLoader);
        }

        public DrawLine24(VGACard vGACard) {
            super(vGACard);
        }

        @Override
        public void dumpStatusPartial(StatusDumper statusDumper) {
            super.dumpStatusPartial(statusDumper);
        }

        @Override
        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": DrawLine24:");
            this.dumpStatusPartial(statusDumper);
            statusDumper.endObject();
        }

        @Override
        int byteWidth(int n) {
            return n * 3;
        }

        @Override
        void drawLine(int n, int n2, int n3, int n4) {
            int[] nArray = this.upperBackref.outputDevice.getDisplayBuffer();
            int n5 = n3 * n4;
            do {
                int n6 = 0xFF & this.upperBackref.ioRegion.getByte(n++);
                int n7 = 0xFF & this.upperBackref.ioRegion.getByte(n++);
                int n8 = 0xFF & this.upperBackref.ioRegion.getByte(n++);
                nArray[n5++] = this.upperBackref.outputDevice.rgbToPixel(n8, n7, n6);
            } while (--n2 != 0);
            this.upperBackref.outputDevice.dirtyDisplayRegion(0, n3, n4, 1);
        }
    }

    public static class DrawLine16
    extends GraphicsUpdater {
        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
            super.dumpSRPartial(sRDumper);
        }

        public DrawLine16(SRLoader sRLoader) throws IOException {
            super(sRLoader);
        }

        public DrawLine16(VGACard vGACard) {
            super(vGACard);
        }

        @Override
        public void dumpStatusPartial(StatusDumper statusDumper) {
            super.dumpStatusPartial(statusDumper);
        }

        @Override
        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": DrawLine16:");
            this.dumpStatusPartial(statusDumper);
            statusDumper.endObject();
        }

        @Override
        int byteWidth(int n) {
            return n * 2;
        }

        @Override
        void drawLine(int n, int n2, int n3, int n4) {
            int[] nArray = this.upperBackref.outputDevice.getDisplayBuffer();
            int n5 = n3 * n4;
            do {
                int n6 = 0xFFFF & this.upperBackref.ioRegion.getWord(n);
                int n7 = n6 >>> 8 & 0xF8;
                int n8 = n6 >>> 3 & 0xFC;
                int n9 = n6 << 3 & 0xF8;
                nArray[n5] = this.upperBackref.outputDevice.rgbToPixel(n7, n8, n9);
                n += 2;
                ++n5;
            } while (--n2 != 0);
            this.upperBackref.outputDevice.dirtyDisplayRegion(0, n3, n4, 1);
        }
    }

    public static class DrawLine15
    extends GraphicsUpdater {
        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
            super.dumpSRPartial(sRDumper);
        }

        public DrawLine15(SRLoader sRLoader) throws IOException {
            super(sRLoader);
        }

        public DrawLine15(VGACard vGACard) {
            super(vGACard);
        }

        @Override
        public void dumpStatusPartial(StatusDumper statusDumper) {
            super.dumpStatusPartial(statusDumper);
        }

        @Override
        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": DrawLine15:");
            this.dumpStatusPartial(statusDumper);
            statusDumper.endObject();
        }

        @Override
        int byteWidth(int n) {
            return n * 2;
        }

        @Override
        void drawLine(int n, int n2, int n3, int n4) {
            int[] nArray = this.upperBackref.outputDevice.getDisplayBuffer();
            int n5 = n3 * n4;
            do {
                int n6 = 0xFFFF & this.upperBackref.ioRegion.getWord(n);
                int n7 = n6 >>> 7 & 0xF8;
                int n8 = n6 >>> 2 & 0xF8;
                int n9 = n6 << 3 & 0xF8;
                nArray[n5] = this.upperBackref.outputDevice.rgbToPixel(n7, n8, n9);
                n += 2;
                ++n5;
            } while (--n2 != 0);
            this.upperBackref.outputDevice.dirtyDisplayRegion(0, n3, n4, 1);
        }
    }

    public static class DrawLine8
    extends GraphicsUpdater {
        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
            super.dumpSRPartial(sRDumper);
        }

        public DrawLine8(SRLoader sRLoader) throws IOException {
            super(sRLoader);
        }

        public DrawLine8(VGACard vGACard) {
            super(vGACard);
        }

        @Override
        public void dumpStatusPartial(StatusDumper statusDumper) {
            super.dumpStatusPartial(statusDumper);
        }

        @Override
        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": DrawLine8:");
            this.dumpStatusPartial(statusDumper);
            statusDumper.endObject();
        }

        @Override
        int byteWidth(int n) {
            return n;
        }

        @Override
        void drawLine(int n, int n2, int n3, int n4) {
            int[] nArray = this.upperBackref.outputDevice.getDisplayBuffer();
            int n5 = n3 * n4;
            int n6 = n3 * n4 - (this.upperBackref.usePixelPanning & 0xF);
            n2 += n5 - n6;
            int[] nArray2 = this.upperBackref.lastPalette;
            do {
                if (n6 >= n5) {
                    nArray[n6] = nArray2[0xFF & this.upperBackref.ioRegion.getByte(n++)];
                }
                ++n6;
            } while (--n2 > 0);
            this.upperBackref.outputDevice.dirtyDisplayRegion(0, n3, n4, 1);
        }
    }

    public static class DrawLine8d2
    extends GraphicsUpdater {
        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
            super.dumpSRPartial(sRDumper);
        }

        public DrawLine8d2(SRLoader sRLoader) throws IOException {
            super(sRLoader);
        }

        public DrawLine8d2(VGACard vGACard) {
            super(vGACard);
        }

        @Override
        public void dumpStatusPartial(StatusDumper statusDumper) {
            super.dumpStatusPartial(statusDumper);
        }

        @Override
        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": DrawLine8d2:");
            this.dumpStatusPartial(statusDumper);
            statusDumper.endObject();
        }

        @Override
        int byteWidth(int n) {
            return n / 2;
        }

        @Override
        void drawLine(int n, int n2, int n3, int n4) {
            int[] nArray = this.upperBackref.outputDevice.getDisplayBuffer();
            int n5 = n3 * n4;
            int n6 = n3 * n4 - (this.upperBackref.usePixelPanning + (this.upperBackref.vgaScroll2HackFlag ? 2 : 0) & 0xF);
            int[] nArray2 = this.upperBackref.lastPalette;
            n2 += n5 - n6;
            n2 >>>= 1;
            do {
                int n7 = nArray2[0xFF & this.upperBackref.ioRegion.getByte(n++)];
                if (n6 < n5) {
                    ++n6;
                } else {
                    nArray[n6++] = n7;
                }
                if (n6 < n5) {
                    ++n6;
                    continue;
                }
                nArray[n6++] = n7;
            } while (--n2 > 0);
            this.upperBackref.outputDevice.dirtyDisplayRegion(0, n3, n4, 1);
        }
    }

    public static class DrawLine4d2
    extends GraphicsUpdater {
        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
            super.dumpSRPartial(sRDumper);
        }

        public DrawLine4d2(SRLoader sRLoader) throws IOException {
            super(sRLoader);
        }

        public DrawLine4d2(VGACard vGACard) {
            super(vGACard);
        }

        @Override
        public void dumpStatusPartial(StatusDumper statusDumper) {
            super.dumpStatusPartial(statusDumper);
        }

        @Override
        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": DrawLine4d2:");
            this.dumpStatusPartial(statusDumper);
            statusDumper.endObject();
        }

        @Override
        int byteWidth(int n) {
            return n / 2;
        }

        @Override
        void drawLine(int n, int n2, int n3, int n4) {
            int[] nArray = this.upperBackref.outputDevice.getDisplayBuffer();
            int n5 = n3 * n4;
            int n6 = (n3 + 1) * n4;
            int n7 = n3 * n4 - ((this.upperBackref.usePixelPanning & 0xF) << 1);
            int[] nArray2 = this.upperBackref.lastPalette;
            int n8 = mask16[this.upperBackref.attributeRegister[18] & 0xF];
            n2 += n5 - n7;
            n2 >>>= 3;
            do {
                int n9 = this.upperBackref.ioRegion.getDoubleWord(n);
                int n10 = expand4[(n9 &= n8) & 0xFF];
                n10 |= expand4[n9 >>> 8 & 0xFF] << 1;
                n10 |= expand4[n9 >>> 16 & 0xFF] << 2;
                n10 |= expand4[n9 >>> 24 & 0xFF] << 3;
                for (int i = 28; i >= 0 && n7 < n6; i -= 4) {
                    if (n7 < n5) {
                        n7 += 2;
                        continue;
                    }
                    int n11 = n7++;
                    int n12 = n7++;
                    int n13 = nArray2[n10 >>> i & 0xF];
                    nArray[n12] = n13;
                    nArray[n11] = n13;
                }
                n += 4;
            } while (--n2 > 0);
            this.upperBackref.outputDevice.dirtyDisplayRegion(0, n3, n4, 1);
        }
    }

    public static class DrawLine4
    extends GraphicsUpdater {
        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
            super.dumpSRPartial(sRDumper);
        }

        public DrawLine4(SRLoader sRLoader) throws IOException {
            super(sRLoader);
        }

        public DrawLine4(VGACard vGACard) {
            super(vGACard);
        }

        @Override
        public void dumpStatusPartial(StatusDumper statusDumper) {
            super.dumpStatusPartial(statusDumper);
        }

        @Override
        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": DrawLine4:");
            this.dumpStatusPartial(statusDumper);
            statusDumper.endObject();
        }

        @Override
        int byteWidth(int n) {
            return n / 2;
        }

        @Override
        void drawLine(int n, int n2, int n3, int n4) {
            int[] nArray = this.upperBackref.outputDevice.getDisplayBuffer();
            int n5 = n3 * n4;
            int n6 = n3 * n4 - (this.upperBackref.usePixelPanning & 0xF);
            int[] nArray2 = this.upperBackref.lastPalette;
            int n7 = mask16[this.upperBackref.attributeRegister[18] & 0xF];
            n2 += n5 - n6;
            n2 >>>= 3;
            do {
                int n8 = this.upperBackref.ioRegion.getDoubleWord(n) & n7;
                int n9 = expand4[n8 & 0xFF];
                n9 |= expand4[(n8 >>>= 8) & 0xFF] << 1;
                n9 |= expand4[(n8 >>>= 8) & 0xFF] << 2;
                n9 |= expand4[(n8 >>>= 8) & 0xFF] << 3;
                for (int i = 28; i >= 0; i -= 4) {
                    if (n6 < n5) {
                        ++n6;
                        continue;
                    }
                    nArray[n6++] = nArray2[n9 >>> i & 0xF];
                }
                n += 4;
            } while (--n2 != 0);
            this.upperBackref.outputDevice.dirtyDisplayRegion(0, n3, n4, 1);
        }
    }

    public static class DrawLine2d2
    extends GraphicsUpdater {
        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
            super.dumpSRPartial(sRDumper);
        }

        public DrawLine2d2(SRLoader sRLoader) throws IOException {
            super(sRLoader);
        }

        public DrawLine2d2(VGACard vGACard) {
            super(vGACard);
        }

        @Override
        public void dumpStatusPartial(StatusDumper statusDumper) {
            super.dumpStatusPartial(statusDumper);
        }

        @Override
        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": DrawLine2d2:");
            this.dumpStatusPartial(statusDumper);
            statusDumper.endObject();
        }

        @Override
        int byteWidth(int n) {
            return n / 2;
        }

        @Override
        void drawLine(int n, int n2, int n3, int n4) {
            int[] nArray = this.upperBackref.outputDevice.getDisplayBuffer();
            int n5 = n3 * n4;
            int n6 = n3 * n4 - (this.upperBackref.usePixelPanning & 0xF);
            int[] nArray2 = this.upperBackref.lastPalette;
            int n7 = mask16[this.upperBackref.attributeRegister[18] & 0xF];
            n2 += n5 - n6;
            n2 >>>= 3;
            do {
                int n8;
                int n9 = this.upperBackref.ioRegion.getDoubleWord(n);
                int n10 = expand2[(n9 &= n7) & 0xFF];
                n10 |= expand2[n9 >>> 16 & 0xFF] << 2;
                for (n8 = 12; n8 >= 0; n8 -= 4) {
                    if (n6 < n5) {
                        n6 += 2;
                        continue;
                    }
                    int n11 = n6++;
                    int n12 = n6++;
                    int n13 = nArray2[n10 >>> n8 & 0xF];
                    nArray[n12] = n13;
                    nArray[n11] = n13;
                }
                n10 = expand2[n9 >>> 8 & 0xFF];
                n10 |= expand2[n9 >>> 24 & 0xFF] << 2;
                for (n8 = 12; n8 >= 0; n8 -= 4) {
                    if (n6 < n5) {
                        n6 += 2;
                        continue;
                    }
                    int n14 = n6++;
                    int n15 = n6++;
                    int n16 = nArray2[n10 >>> n8 & 0xF];
                    nArray[n15] = n16;
                    nArray[n14] = n16;
                }
                n += 4;
            } while (--n2 > 0);
            this.upperBackref.outputDevice.dirtyDisplayRegion(0, n3, n4, 1);
        }
    }

    public static class DrawLine2
    extends GraphicsUpdater {
        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
            super.dumpSRPartial(sRDumper);
        }

        public DrawLine2(SRLoader sRLoader) throws IOException {
            super(sRLoader);
        }

        public DrawLine2(VGACard vGACard) {
            super(vGACard);
        }

        @Override
        public void dumpStatusPartial(StatusDumper statusDumper) {
            super.dumpStatusPartial(statusDumper);
        }

        @Override
        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": DrawLine2:");
            this.dumpStatusPartial(statusDumper);
            statusDumper.endObject();
        }

        @Override
        int byteWidth(int n) {
            return n / 2;
        }

        @Override
        void drawLine(int n, int n2, int n3, int n4) {
            int[] nArray = this.upperBackref.outputDevice.getDisplayBuffer();
            int n5 = n3 * n4;
            int n6 = n3 * n4 - (this.upperBackref.usePixelPanning & 0xF);
            int[] nArray2 = this.upperBackref.lastPalette;
            int n7 = mask16[this.upperBackref.attributeRegister[18] & 0xF];
            n2 += n5 - n6;
            n2 >>>= 3;
            do {
                int n8;
                int n9 = this.upperBackref.ioRegion.getDoubleWord(n);
                int n10 = expand2[(n9 &= n7) & 0xFF];
                n10 |= expand2[n9 >>> 16 & 0xFF] << 2;
                for (n8 = 12; n8 >= 0; n8 -= 4) {
                    if (n6 < n5) {
                        ++n6;
                        continue;
                    }
                    nArray[n6++] = nArray2[n10 >>> n8 & 0xF];
                }
                n10 = expand2[n9 >>> 8 & 0xFF];
                n10 |= expand2[n9 >>> 24 & 0xFF] << 2;
                for (n8 = 12; n8 >= 0; n8 -= 4) {
                    if (n6 < n5) {
                        ++n6;
                        continue;
                    }
                    nArray[n6++] = nArray2[n10 >>> n8 & 0xF];
                }
                n += 4;
            } while (--n2 > 0);
            this.upperBackref.outputDevice.dirtyDisplayRegion(0, n3, n4, 1);
        }
    }

    public static abstract class GraphicsUpdater
    implements SRDumpable {
        protected VGACard upperBackref;

        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
            sRDumper.dumpObject(this.upperBackref);
        }

        public GraphicsUpdater(SRLoader sRLoader) throws IOException {
            sRLoader.objectCreated(this);
            this.upperBackref = (VGACard)sRLoader.loadObject();
        }

        public GraphicsUpdater(VGACard vGACard) {
            this.upperBackref = vGACard;
        }

        public void dumpStatusPartial(StatusDumper statusDumper) {
            statusDumper.println("\tupperBackref <object #" + statusDumper.objectNumber(this.upperBackref) + ">");
            if (this.upperBackref != null) {
                this.upperBackref.dumpStatus(statusDumper);
            }
        }

        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": GraphicsUpdater:");
            this.dumpStatusPartial(statusDumper);
            statusDumper.endObject();
        }

        abstract int byteWidth(int var1);

        abstract void drawLine(int var1, int var2, int var3, int var4);

        void updateDisplay(int n, int n2, int n3, boolean bl, int n4) {
            int n5;
            int n6 = n4;
            int n7 = 4 * (this.upperBackref.startAddress + this.upperBackref.byteSkip);
            if (this.upperBackref.shiftControl == 0 || this.upperBackref.shiftControl != 1) {
                // empty if block
            }
            int n8 = 0;
            boolean bl2 = (this.upperBackref.crtRegister[23] & 1) == 0;
            boolean bl3 = (this.upperBackref.crtRegister[23] & 2) == 0;
            boolean bl4 = bl2 || bl3;
            int n9 = this.upperBackref.crtRegister[23] & 3 ^ 3;
            int n10 = Integer.MAX_VALUE;
            int n11 = Integer.MIN_VALUE;
            for (n5 = 0; n5 < n2; ++n5) {
                int n12;
                int n13 = n7;
                if (bl4) {
                    if (bl2) {
                        n12 = 14 + (this.upperBackref.crtRegister[23] >>> 6 & 1);
                        n13 = n13 & ~(1 << n12) | (n8 & 1) << n12;
                    }
                    if (bl3) {
                        n13 = n13 & 0xFFFF7FFF | (n8 & 2) << 14;
                    }
                }
                n12 = n13 >>> 12;
                int n14 = n13 + this.byteWidth(n) - 1 >>> 12;
                for (int i = n12; i <= n14; ++i) {
                    if (!bl && !this.upperBackref.ioRegion.pageIsDirty(i)) continue;
                    n10 = Math.min(n10, n12);
                    n11 = Math.max(n11, n14);
                    this.drawLine(n13, n, n5, n3);
                    break;
                }
                if (n6 == 0) {
                    if ((n8 & n9) == n9) {
                        n7 += this.upperBackref.lineOffset;
                    }
                    ++n8;
                    n6 = n4;
                } else {
                    --n6;
                }
                if (n5 != this.upperBackref.lineCompare) continue;
                n7 = 0;
                if ((this.upperBackref.attributeRegister[16] & 0x20) == 0) continue;
                this.upperBackref.usePixelPanning = 0;
            }
            for (n5 = n10; n5 <= n11; ++n5) {
                this.upperBackref.ioRegion.cleanPage(n5);
            }
        }
    }

    public static class VGARAMIORegion
    extends MemoryMappedIORegion {
        private byte[] buffer;
        private int startAddress;
        private boolean[] dirtyPages;

        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
            super.dumpSRPartial(sRDumper);
            sRDumper.dumpArray(this.buffer);
            sRDumper.dumpInt(this.startAddress);
            sRDumper.dumpArray(this.dirtyPages);
        }

        public VGARAMIORegion(SRLoader sRLoader) throws IOException {
            super(sRLoader);
            this.buffer = sRLoader.loadArrayByte();
            this.startAddress = sRLoader.loadInt();
            this.dirtyPages = sRLoader.loadArrayBoolean();
        }

        @Override
        public void dumpStatusPartial(StatusDumper statusDumper) {
            super.dumpStatusPartial(statusDumper);
            statusDumper.println("\tstartAddress " + this.startAddress);
            statusDumper.printArray(this.buffer, "buffer");
            statusDumper.printArray(this.dirtyPages, "dirtyPages");
        }

        @Override
        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": VGARAMIORegion:");
            this.dumpStatusPartial(statusDumper);
            statusDumper.endObject();
        }

        public VGARAMIORegion() {
            this.buffer = new byte[65536];
            this.dirtyPages = new boolean[4097];
            for (int i = 0; i < this.dirtyPages.length; ++i) {
                this.dirtyPages[i] = false;
            }
            this.startAddress = -1;
        }

        private void increaseVGARAMSize(int n) {
            int n2;
            if (n < 0 || n >= 0x1000000) {
                throw new ArrayIndexOutOfBoundsException("tried to access outside of memory bounds");
            }
            for (n2 = this.buffer.length; n2 <= n; n2 <<= 1) {
            }
            if (n2 > 0x1000000) {
                n2 = 0x1000000;
            }
            byte[] byArray = new byte[n2];
            System.arraycopy(this.buffer, 0, byArray, 0, this.buffer.length);
            this.buffer = byArray;
        }

        @Override
        public void copyContentsIntoArray(int n, byte[] byArray, int n2, int n3) {
            System.arraycopy(this.buffer, n, byArray, n2, n3);
        }

        @Override
        public void copyArrayIntoContents(int n, byte[] byArray, int n2, int n3) {
            System.arraycopy(byArray, n2, this.buffer, n, n3);
        }

        @Override
        public void clear() {
            int n;
            for (n = 0; n < this.buffer.length; ++n) {
                this.buffer[n] = 0;
            }
            for (n = 0; n < this.dirtyPages.length; ++n) {
                this.dirtyPages[n] = false;
            }
        }

        @Override
        public void clear(int n, int n2) {
            int n3;
            int n4 = n + n2;
            if ((long)n4 > this.getSize()) {
                throw new ArrayIndexOutOfBoundsException("Attempt to clear outside of memory bounds");
            }
            try {
                for (n3 = n; n3 < n4; ++n3) {
                    this.buffer[n3] = 0;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            n3 = n >>> 12;
            int n5 = n4 - 1 >>> 12;
            for (int i = n3; i <= n5; ++i) {
                this.dirtyPages[i] = true;
            }
        }

        public boolean pageIsDirty(int n) {
            return this.dirtyPages[n];
        }

        public void cleanPage(int n) {
            this.dirtyPages[n] = false;
        }

        @Override
        public int getAddress() {
            return this.startAddress;
        }

        @Override
        public long getSize() {
            return 0x1000000L;
        }

        @Override
        public int getType() {
            return 8;
        }

        @Override
        public int getRegionNumber() {
            return 0;
        }

        @Override
        public void setAddress(int n) {
            this.startAddress = n;
        }

        @Override
        public void setByte(int n, byte by) {
            try {
                this.dirtyPages[n >>> 12] = true;
                this.buffer[n] = by;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.increaseVGARAMSize(n);
                this.setByte(n, by);
            }
        }

        @Override
        public byte getByte(int n) {
            try {
                return this.buffer[n];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.increaseVGARAMSize(n);
                return this.getByte(n);
            }
        }

        @Override
        public void setWord(int n, short s) {
            try {
                this.buffer[n] = (byte)s;
                this.dirtyPages[n >>> 12] = true;
                this.buffer[++n] = (byte)(s >> 8);
                this.dirtyPages[n >>> 12] = true;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.increaseVGARAMSize(n);
                this.setWord(n, s);
            }
        }

        @Override
        public short getWord(int n) {
            try {
                int n2 = 0xFF & this.buffer[n];
                return (short)(n2 |= this.buffer[++n] << 8);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.increaseVGARAMSize(n);
                return this.getWord(n);
            }
        }

        @Override
        public void setDoubleWord(int n, int n2) {
            try {
                this.dirtyPages[n >>> 12] = true;
                this.buffer[n] = (byte)n2;
                this.buffer[++n] = (byte)(n2 >>= 8);
                this.buffer[++n] = (byte)(n2 >>= 8);
                this.buffer[++n] = (byte)(n2 >>= 8);
                this.dirtyPages[n >>> 12] = true;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.increaseVGARAMSize(n);
                this.setDoubleWord(n, n2);
            }
        }

        @Override
        public int getDoubleWord(int n) {
            try {
                int n2 = 0xFF & this.buffer[n];
                n2 |= (0xFF & this.buffer[++n]) << 8;
                n2 |= (0xFF & this.buffer[++n]) << 16;
                return n2 |= this.buffer[++n] << 24;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.increaseVGARAMSize(n);
                return this.getDoubleWord(n);
            }
        }

        public String toString() {
            return "VGA RAM ByteArray[" + this.getSize() + "]";
        }

        @Override
        public int executeReal(Processor processor, int n) {
            System.err.println("Critical error: Can't execute code in VGA memory.");
            throw new IllegalStateException("Can't exec code in VGA memory");
        }

        @Override
        public int executeProtected(Processor processor, int n) {
            System.err.println("Critical error: Can't execute code in VGA memory.");
            throw new IllegalStateException("Can't exec code in VGA memory");
        }

        @Override
        public int executeVirtual8086(Processor processor, int n) {
            System.err.println("Critical error: Can't execute code in VGA memory.");
            throw new IllegalStateException("Can't exec code in VGA memory");
        }

        @Override
        public boolean isAllocated() {
            return true;
        }

        @Override
        public void loadInitialContents(int n, byte[] byArray, int n2, int n3) {
            System.err.println("Critical error: LoadInitialContents() not supported for VGA memory.");
            throw new UnsupportedOperationException("LoadIntiialContents not supported for VGA mnemory.");
        }
    }

    public static class VGALowMemoryRegion
    implements Memory {
        private VGACard upperBackref;

        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
            sRDumper.dumpObject(this.upperBackref);
        }

        public VGALowMemoryRegion(VGACard vGACard) {
            this.upperBackref = vGACard;
        }

        public VGALowMemoryRegion(SRLoader sRLoader) throws IOException {
            sRLoader.objectCreated(this);
            this.upperBackref = (VGACard)sRLoader.loadObject();
        }

        public void dumpStatusPartial(StatusDumper statusDumper) {
            statusDumper.println("\tupperBackref <object #" + statusDumper.objectNumber(this.upperBackref) + ">");
            if (this.upperBackref != null) {
                this.upperBackref.dumpStatus(statusDumper);
            }
        }

        @Override
        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": VGALowMemoryRegion:");
            this.dumpStatusPartial(statusDumper);
            statusDumper.endObject();
        }

        @Override
        public void copyContentsIntoArray(int n, byte[] byArray, int n2, int n3) {
            System.err.println("Critical error: CopyContentsIntoArray not supported for low VGA memory.");
            throw new IllegalStateException("copyContentsInto: Invalid Operation for VGA Card");
        }

        @Override
        public void copyArrayIntoContents(int n, byte[] byArray, int n2, int n3) {
            System.err.println("Critical error: CopyArrayIntoContents not supported for low VGA memory.");
            throw new IllegalStateException("copyContentsFrom: Invalid Operation for VGA Card");
        }

        @Override
        public long getSize() {
            return 131072L;
        }

        @Override
        public boolean isAllocated() {
            return false;
        }

        @Override
        public byte getByte(int n) {
            boolean bl;
            int n2 = this.upperBackref.graphicsRegister[6] >>> 2 & 3;
            boolean bl2 = (n &= 0x1FFFF) < 65536;
            switch (n2) {
                case 0: {
                    break;
                }
                case 1: {
                    if (n >= 65536) {
                        return -1;
                    }
                    n += this.upperBackref.bankOffset;
                    break;
                }
                case 2: {
                    if ((n -= 65536) < 32768 && n >= 0) break;
                    return -1;
                }
                default: {
                    if ((n -= 98304) >= 0) break;
                    return -1;
                }
            }
            boolean bl3 = bl = (this.upperBackref.graphicsRegister[5] & 0x10) != 0;
            if (bl2) {
                bl = false;
            }
            if ((this.upperBackref.sequencerRegister[4] & 8) != 0) {
                return this.upperBackref.ioRegion.getByte(n);
            }
            if (bl) {
                int n3 = this.upperBackref.graphicsRegister[4] & 2 | n & 1;
                return this.upperBackref.ioRegion.getByte((n & 0xFFFFFFFE) << 1 | n3);
            }
            this.upperBackref.latch = this.upperBackref.ioRegion.getDoubleWord(4 * n);
            if ((this.upperBackref.graphicsRegister[5] & 8) == 0) {
                return (byte)(this.upperBackref.latch >>> this.upperBackref.graphicsRegister[4] * 8);
            }
            int n4 = (this.upperBackref.latch ^ mask16[this.upperBackref.graphicsRegister[2]]) & mask16[this.upperBackref.graphicsRegister[7]];
            n4 |= n4 >>> 16;
            n4 |= n4 >>> 8;
            return (byte)(~n4);
        }

        @Override
        public short getWord(int n) {
            int n2 = 0xFF & this.getByte(n);
            return (short)(n2 |= (0xFF & this.getByte(n + 1)) << 8);
        }

        @Override
        public int getDoubleWord(int n) {
            int n2 = 0xFF & this.getByte(n);
            n2 |= (0xFF & this.getByte(n + 1)) << 8;
            n2 |= (0xFF & this.getByte(n + 2)) << 16;
            return n2 |= (0xFF & this.getByte(n + 3)) << 24;
        }

        @Override
        public long getQuadWord(int n) {
            long l = 0xFFL & (long)this.getByte(n);
            l |= (0xFFL & (long)this.getByte(n + 1)) << 8;
            l |= (0xFFL & (long)this.getByte(n + 2)) << 16;
            l |= (0xFFL & (long)this.getByte(n + 3)) << 24;
            l |= (0xFFL & (long)this.getByte(n + 4)) << 32;
            l |= (0xFFL & (long)this.getByte(n + 5)) << 40;
            l |= (0xFFL & (long)this.getByte(n + 6)) << 48;
            return l |= (0xFFL & (long)this.getByte(n + 7)) << 56;
        }

        @Override
        public long getLowerDoubleQuadWord(int n) {
            return this.getQuadWord(n);
        }

        @Override
        public long getUpperDoubleQuadWord(int n) {
            return this.getQuadWord(n + 8);
        }

        @Override
        public void setByte(int n, byte by) {
            boolean bl;
            int n2 = this.upperBackref.graphicsRegister[6] >>> 2 & 3;
            boolean bl2 = (n &= 0x1FFFF) < 65536;
            switch (n2) {
                case 0: {
                    break;
                }
                case 1: {
                    if (n >= 65536) {
                        return;
                    }
                    n += this.upperBackref.bankOffset;
                    break;
                }
                case 2: {
                    if ((n -= 65536) < 32768 && n >= 0) break;
                    return;
                }
                default: {
                    if ((n -= 98304) >= 0) break;
                    return;
                }
            }
            boolean bl3 = bl = (this.upperBackref.graphicsRegister[5] & 0x10) != 0;
            if (bl2) {
                bl = false;
            }
            if ((this.upperBackref.sequencerRegister[4] & 8) != 0) {
                int n3 = n & 3;
                int n4 = 1 << n3;
                if ((this.upperBackref.sequencerRegister[2] & n4) != 0) {
                    this.upperBackref.ioRegion.setByte(n, by);
                    this.upperBackref.planeUpdated |= n4;
                }
            } else if (bl) {
                int n5 = this.upperBackref.graphicsRegister[4] & 2 | n & 1;
                int n6 = 1 << n5;
                if ((this.upperBackref.sequencerRegister[2] & n6) != 0) {
                    this.upperBackref.ioRegion.setByte((n & 0xFFFFFFFE) << 1 | n5, by);
                    this.upperBackref.planeUpdated |= n6;
                }
            } else {
                int n7;
                int n8;
                int n9 = 0;
                int n10 = this.upperBackref.graphicsRegister[5] & 3;
                int n11 = 0xFF & by;
                switch (n10) {
                    default: {
                        n8 = this.upperBackref.graphicsRegister[3] & 7;
                        n11 |= n11 << 8;
                        n11 |= n11 << 16;
                        n11 = n11 >>> n8 | n11 << -n8;
                        n7 = mask16[this.upperBackref.graphicsRegister[1]];
                        n11 = n11 & ~n7 | mask16[this.upperBackref.graphicsRegister[0]] & n7;
                        n9 = this.upperBackref.graphicsRegister[8];
                        break;
                    }
                    case 1: {
                        n11 = this.upperBackref.latch;
                        int n12 = this.upperBackref.sequencerRegister[2];
                        this.upperBackref.planeUpdated |= n12;
                        int n13 = mask16[n12];
                        this.upperBackref.ioRegion.setDoubleWord(n <<= 2, this.upperBackref.ioRegion.getDoubleWord(n) & ~n13 | n11 & n13);
                        return;
                    }
                    case 2: {
                        n11 = mask16[n11 & 0xF];
                        n9 = this.upperBackref.graphicsRegister[8];
                        break;
                    }
                    case 3: {
                        n8 = this.upperBackref.graphicsRegister[3] & 7;
                        n11 = n11 >>> n8 | n11 << 8 - n8;
                        n9 = this.upperBackref.graphicsRegister[8] & n11;
                        n11 = mask16[this.upperBackref.graphicsRegister[0]];
                    }
                }
                n8 = this.upperBackref.graphicsRegister[3] >>> 3;
                switch (n8) {
                    default: {
                        break;
                    }
                    case 1: {
                        n11 &= this.upperBackref.latch;
                        break;
                    }
                    case 2: {
                        n11 |= this.upperBackref.latch;
                        break;
                    }
                    case 3: {
                        n11 ^= this.upperBackref.latch;
                    }
                }
                n9 |= n9 << 8;
                n9 |= n9 << 16;
                n11 = n11 & n9 | this.upperBackref.latch & ~n9;
                n7 = this.upperBackref.sequencerRegister[2];
                this.upperBackref.planeUpdated |= n7;
                int n14 = mask16[n7];
                this.upperBackref.ioRegion.setDoubleWord(n <<= 2, this.upperBackref.ioRegion.getDoubleWord(n) & ~n14 | n11 & n14);
            }
        }

        @Override
        public void setWord(int n, short s) {
            this.setByte(n++, (byte)s);
            s = (short)(s >>> 8);
            this.setByte(n, (byte)s);
        }

        @Override
        public void setDoubleWord(int n, int n2) {
            this.setByte(n++, (byte)n2);
            this.setByte(n++, (byte)(n2 >>>= 8));
            this.setByte(n++, (byte)(n2 >>>= 8));
            this.setByte(n, (byte)(n2 >>>= 8));
        }

        @Override
        public void setQuadWord(int n, long l) {
            this.setDoubleWord(n, (int)l);
            this.setDoubleWord(n + 4, (int)(l >> 32));
        }

        @Override
        public void setLowerDoubleQuadWord(int n, long l) {
            this.setDoubleWord(n, (int)l);
            this.setDoubleWord(n + 4, (int)(l >> 32));
        }

        @Override
        public void setUpperDoubleQuadWord(int n, long l) {
            this.setDoubleWord(n += 8, (int)l);
            this.setDoubleWord(n + 4, (int)(l >> 32));
        }

        @Override
        public void clear() {
            this.upperBackref.internalReset();
        }

        @Override
        public void clear(int n, int n2) {
            this.clear();
        }

        @Override
        public int executeReal(Processor processor, int n) {
            System.err.println("Critical error: Can't execute code in low VGA memory.");
            throw new IllegalStateException("Can't exec code in low VGA memory");
        }

        @Override
        public int executeProtected(Processor processor, int n) {
            System.err.println("Critical error: Can't execute code in low VGA memory.");
            throw new IllegalStateException("Can't exec code in low VGA memory");
        }

        @Override
        public int executeVirtual8086(Processor processor, int n) {
            System.err.println("Critical error: Can't execute code in low VGA memory.");
            throw new IllegalStateException("Can't exec code in low VGA memory");
        }

        @Override
        public void loadInitialContents(int n, byte[] byArray, int n2, int n3) {
            System.err.println("Critical error: LoadInitialContents() not supported for low VGA memory.");
            throw new UnsupportedOperationException("LoadIntiialContents not implemented for low VGA memory");
        }
    }
}

