/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.processor;

import java.io.IOException;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.SRLoader;
import org.jpc.emulator.StatusDumper;
import org.jpc.emulator.memory.AddressSpace;
import org.jpc.emulator.memory.LinearAddressSpace;
import org.jpc.emulator.processor.Processor;
import org.jpc.emulator.processor.ProcessorException;
import org.jpc.emulator.processor.Segment;

public abstract class ProtectedModeSegment
extends Segment {
    public static final int TYPE_ACCESSED = 1;
    public static final int TYPE_CODE = 8;
    public static final int TYPE_DATA_WRITABLE = 2;
    public static final int TYPE_DATA_EXPAND_DOWN = 4;
    public static final int TYPE_CODE_READABLE = 2;
    public static final int TYPE_CODE_CONFORMING = 4;
    public static final int DESCRIPTOR_TYPE_CODE_DATA = 16;
    private final boolean defaultSize;
    private final boolean granularity;
    private final boolean present;
    private final boolean system;
    private final int selector;
    private final int base;
    private final int dpl;
    private final long limit;
    private final long descriptor;
    private int rpl;

    @Override
    public void dumpStatusPartial(StatusDumper statusDumper) {
        super.dumpStatusPartial(statusDumper);
        statusDumper.println("\tselector " + this.selector + " base " + this.base + " limit " + this.limit + " rpl " + this.rpl);
        statusDumper.println("\tdefaultSize " + this.defaultSize + " system " + this.system + " present " + this.present);
        statusDumper.println("\tdpl " + this.dpl + " granularity " + this.granularity + " descriptor " + this.descriptor);
    }

    @Override
    public void dumpStatus(StatusDumper statusDumper) {
        if (statusDumper.dumped(this)) {
            return;
        }
        statusDumper.println("#" + statusDumper.objectNumber(this) + ": ProtectedModeSegment:");
        this.dumpStatusPartial(statusDumper);
        statusDumper.endObject();
    }

    @Override
    public void dumpSRPartial(SRDumper sRDumper) throws IOException {
        super.dumpSRPartial(sRDumper);
        sRDumper.dumpInt(this.selector);
        sRDumper.dumpInt(this.base);
        sRDumper.dumpInt(this.dpl);
        sRDumper.dumpInt(this.rpl);
        sRDumper.dumpLong(this.descriptor);
        sRDumper.dumpLong(this.limit);
        sRDumper.dumpBoolean(this.defaultSize);
        sRDumper.dumpBoolean(this.granularity);
        sRDumper.dumpBoolean(this.present);
        sRDumper.dumpBoolean(this.system);
    }

    public ProtectedModeSegment(SRLoader sRLoader) throws IOException {
        super(sRLoader);
        this.selector = sRLoader.loadInt();
        this.base = sRLoader.loadInt();
        this.dpl = sRLoader.loadInt();
        this.rpl = sRLoader.loadInt();
        this.descriptor = sRLoader.loadLong();
        this.limit = sRLoader.loadLong();
        this.defaultSize = sRLoader.loadBoolean();
        this.granularity = sRLoader.loadBoolean();
        this.present = sRLoader.loadBoolean();
        this.system = sRLoader.loadBoolean();
    }

    public ProtectedModeSegment(AddressSpace addressSpace, int n, long l) {
        super(addressSpace, true);
        this.selector = n;
        this.descriptor = l;
        this.granularity = (l & 0x80000000000000L) != 0L;
        this.limit = this.granularity ? l << 12 & 0xFFFF000L | l >>> 20 & 0xF0000000L | 0xFFFL : l & 0xFFFFL | l >>> 32 & 0xF0000L;
        this.base = (int)(0xFFFFFFL & l >> 16 | l >> 32 & 0xFFFFFFFFFF000000L);
        this.rpl = n & 3;
        this.dpl = (int)(l >> 45 & 3L);
        this.defaultSize = (l & 0x40000000000000L) != 0L;
        this.present = (l & 0x800000000000L) != 0L;
        this.system = (l & 0x100000000000L) != 0L;
    }

    @Override
    public boolean isPresent() {
        return this.present;
    }

    @Override
    public boolean isSystem() {
        return !this.system;
    }

    @Override
    public int translateAddressRead(int n) {
        this.checkAddress(n);
        return this.base + n;
    }

    @Override
    public int translateAddressWrite(int n) {
        this.checkAddress(n);
        return this.base + n;
    }

    @Override
    public void checkAddress(int n) {
        if ((0xFFFFFFFFL & (long)n) > this.limit) {
            System.err.println("Emulated: " + this + "segment limit exceeded: " + Integer.toHexString(n) + " > " + Integer.toHexString((int)this.limit) + ".");
            System.err.println("Debug: selector " + this.selector + " base " + this.base + " limit " + this.limit + " rpl " + this.rpl);
            System.err.println("Debug: defaultSize " + this.defaultSize + " system " + this.system + " present " + this.present);
            System.err.println("Debug: dpl " + this.dpl + " granularity " + this.granularity + " descriptor " + this.descriptor);
            throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, 0, true);
        }
    }

    @Override
    public boolean getDefaultSizeFlag() {
        return this.defaultSize;
    }

    @Override
    public int getLimit() {
        return (int)this.limit;
    }

    @Override
    public int getBase() {
        return this.base;
    }

    @Override
    public int getSelector() {
        return this.selector & 0xFFFC | this.rpl;
    }

    @Override
    public int getRPL() {
        return this.rpl;
    }

    @Override
    public int getDPL() {
        return this.dpl;
    }

    @Override
    public void setRPL(int n) {
        this.rpl = n;
    }

    @Override
    public boolean setSelector(int n) {
        System.err.println("Critical error: Cannot set a selector for a descriptor table segment");
        throw new IllegalStateException("Cannot set a selector for a descriptor table segment");
    }

    @Override
    public void printState() {
        System.out.println("PM Mode segment");
        System.out.println("selector: " + Integer.toHexString(this.selector));
        System.out.println("base: " + Integer.toHexString(this.base));
        System.out.println("dpl: " + Integer.toHexString(this.dpl));
        System.out.println("rpl: " + Integer.toHexString(this.rpl));
        System.out.println("limit: " + Long.toHexString(this.limit));
        System.out.println("descriptor: " + Long.toHexString(this.descriptor));
    }

    public static final class Busy16BitTSS
    extends ProtectedModeSegment {
        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
            super.dumpSRPartial(sRDumper);
        }

        public Busy16BitTSS(SRLoader sRLoader) throws IOException {
            super(sRLoader);
        }

        @Override
        public void dumpStatusPartial(StatusDumper statusDumper) {
            super.dumpStatusPartial(statusDumper);
        }

        @Override
        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": Busy16BitTSS:");
            this.dumpStatusPartial(statusDumper);
            statusDumper.endObject();
        }

        public Busy16BitTSS(AddressSpace addressSpace, int n, long l) {
            super(addressSpace, n, l);
        }

        @Override
        public int getType() {
            return 3;
        }
    }

    public static final class Available16BitTSS
    extends ProtectedModeSegment {
        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
            super.dumpSRPartial(sRDumper);
        }

        public Available16BitTSS(SRLoader sRLoader) throws IOException {
            super(sRLoader);
        }

        @Override
        public void dumpStatusPartial(StatusDumper statusDumper) {
            super.dumpStatusPartial(statusDumper);
        }

        @Override
        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": Available16BitTSS:");
            this.dumpStatusPartial(statusDumper);
            statusDumper.endObject();
        }

        public Available16BitTSS(AddressSpace addressSpace, int n, long l) {
            super(addressSpace, n, l);
        }

        @Override
        public int getType() {
            return 1;
        }
    }

    public static final class CallGate16Bit
    extends GateSegment {
        private final int parameterCount;

        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
            super.dumpSRPartial(sRDumper);
            sRDumper.dumpInt(this.parameterCount);
        }

        public CallGate16Bit(SRLoader sRLoader) throws IOException {
            super(sRLoader);
            this.parameterCount = sRLoader.loadInt();
        }

        @Override
        public void dumpStatusPartial(StatusDumper statusDumper) {
            super.dumpStatusPartial(statusDumper);
            statusDumper.println("\tparameterCount " + this.parameterCount);
        }

        @Override
        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": CallGate16Bit:");
            this.dumpStatusPartial(statusDumper);
            statusDumper.endObject();
        }

        public CallGate16Bit(AddressSpace addressSpace, int n, long l) {
            super(addressSpace, n, l);
            this.parameterCount = (int)(l >> 32 & 0xFL);
        }

        @Override
        public int getType() {
            return 4;
        }

        public final int getParameterCount() {
            return this.parameterCount;
        }
    }

    public static final class CallGate32Bit
    extends GateSegment {
        private final int parameterCount;

        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
            super.dumpSRPartial(sRDumper);
            sRDumper.dumpInt(this.parameterCount);
        }

        public CallGate32Bit(SRLoader sRLoader) throws IOException {
            super(sRLoader);
            this.parameterCount = sRLoader.loadInt();
        }

        @Override
        public void dumpStatusPartial(StatusDumper statusDumper) {
            super.dumpStatusPartial(statusDumper);
            statusDumper.println("\tparameterCount " + this.parameterCount);
        }

        @Override
        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": CallGate32Bit:");
            this.dumpStatusPartial(statusDumper);
            statusDumper.endObject();
        }

        public CallGate32Bit(AddressSpace addressSpace, int n, long l) {
            super(addressSpace, n, l);
            this.parameterCount = (int)(l >> 32 & 0xFL);
        }

        @Override
        public int getType() {
            return 12;
        }

        public final int getParameterCount() {
            return this.parameterCount;
        }
    }

    public static final class TrapGate16Bit
    extends GateSegment {
        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
            super.dumpSRPartial(sRDumper);
        }

        public TrapGate16Bit(SRLoader sRLoader) throws IOException {
            super(sRLoader);
        }

        @Override
        public void dumpStatusPartial(StatusDumper statusDumper) {
            super.dumpStatusPartial(statusDumper);
        }

        @Override
        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": TrapGate16Bit:");
            this.dumpStatusPartial(statusDumper);
            statusDumper.endObject();
        }

        public TrapGate16Bit(AddressSpace addressSpace, int n, long l) {
            super(addressSpace, n, l);
        }

        @Override
        public int getType() {
            return 7;
        }
    }

    public static final class TrapGate32Bit
    extends GateSegment {
        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
            super.dumpSRPartial(sRDumper);
        }

        public TrapGate32Bit(SRLoader sRLoader) throws IOException {
            super(sRLoader);
        }

        @Override
        public void dumpStatusPartial(StatusDumper statusDumper) {
            super.dumpStatusPartial(statusDumper);
        }

        @Override
        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": TrapGate32Bit:");
            this.dumpStatusPartial(statusDumper);
            statusDumper.endObject();
        }

        public TrapGate32Bit(AddressSpace addressSpace, int n, long l) {
            super(addressSpace, n, l);
        }

        @Override
        public int getType() {
            return 15;
        }
    }

    public static final class InterruptGate16Bit
    extends GateSegment {
        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
            super.dumpSRPartial(sRDumper);
        }

        public InterruptGate16Bit(SRLoader sRLoader) throws IOException {
            super(sRLoader);
        }

        @Override
        public void dumpStatusPartial(StatusDumper statusDumper) {
            super.dumpStatusPartial(statusDumper);
        }

        @Override
        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": InterruptGate16Bit:");
            this.dumpStatusPartial(statusDumper);
            statusDumper.endObject();
        }

        public InterruptGate16Bit(AddressSpace addressSpace, int n, long l) {
            super(addressSpace, n, l);
        }

        @Override
        public int getType() {
            return 6;
        }
    }

    public static final class InterruptGate32Bit
    extends GateSegment {
        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
            super.dumpSRPartial(sRDumper);
        }

        public InterruptGate32Bit(SRLoader sRLoader) throws IOException {
            super(sRLoader);
        }

        @Override
        public void dumpStatusPartial(StatusDumper statusDumper) {
            super.dumpStatusPartial(statusDumper);
        }

        @Override
        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": InterruptGate32Bit:");
            this.dumpStatusPartial(statusDumper);
            statusDumper.endObject();
        }

        public InterruptGate32Bit(AddressSpace addressSpace, int n, long l) {
            super(addressSpace, n, l);
        }

        @Override
        public int getType() {
            return 14;
        }
    }

    public static final class TaskGate
    extends GateSegment {
        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
            super.dumpSRPartial(sRDumper);
        }

        public TaskGate(SRLoader sRLoader) throws IOException {
            super(sRLoader);
        }

        @Override
        public void dumpStatusPartial(StatusDumper statusDumper) {
            super.dumpStatusPartial(statusDumper);
        }

        @Override
        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": TaskGate:");
            this.dumpStatusPartial(statusDumper);
            statusDumper.endObject();
        }

        public TaskGate(AddressSpace addressSpace, int n, long l) {
            super(addressSpace, n, l);
        }

        @Override
        public final int getTargetOffset() {
            System.err.println("Critical error: TaskGate getTargetOffset().");
            throw new IllegalStateException("Task Gate getTargetOffset()");
        }

        @Override
        public int getType() {
            return 5;
        }
    }

    public static abstract class GateSegment
    extends ReadOnlyProtectedModeSegment {
        private int targetSegment;
        private int targetOffset;

        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
            super.dumpSRPartial(sRDumper);
            sRDumper.dumpInt(this.targetSegment);
            sRDumper.dumpInt(this.targetOffset);
        }

        public GateSegment(SRLoader sRLoader) throws IOException {
            super(sRLoader);
            this.targetSegment = sRLoader.loadInt();
            this.targetOffset = sRLoader.loadInt();
        }

        @Override
        public void dumpStatusPartial(StatusDumper statusDumper) {
            super.dumpStatusPartial(statusDumper);
            statusDumper.println("\ttargetSegment " + this.targetSegment + " targetOffset " + this.targetOffset);
        }

        @Override
        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": GateSegment:");
            this.dumpStatusPartial(statusDumper);
            statusDumper.endObject();
        }

        public GateSegment(AddressSpace addressSpace, int n, long l) {
            super(addressSpace, n, l);
            this.targetSegment = (int)(l >> 16 & 0xFFFFL);
            this.targetOffset = (int)(l & 0xFFFFL | l >>> 32 & 0xFFFFFFFFFFFF0000L);
        }

        public int getTargetSegment() {
            return this.targetSegment;
        }

        public int getTargetOffset() {
            return this.targetOffset;
        }
    }

    public static final class LDT
    extends ReadOnlyProtectedModeSegment {
        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
            super.dumpSRPartial(sRDumper);
        }

        public LDT(SRLoader sRLoader) throws IOException {
            super(sRLoader);
        }

        @Override
        public void dumpStatusPartial(StatusDumper statusDumper) {
            super.dumpStatusPartial(statusDumper);
        }

        @Override
        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": LDT:");
            this.dumpStatusPartial(statusDumper);
            statusDumper.endObject();
        }

        public LDT(AddressSpace addressSpace, int n, long l) {
            super(addressSpace, n, l);
        }

        @Override
        public int getType() {
            return 2;
        }
    }

    public static final class Busy32BitTSS
    extends AbstractTSS {
        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
            super.dumpSRPartial(sRDumper);
        }

        public Busy32BitTSS(SRLoader sRLoader) throws IOException {
            super(sRLoader);
        }

        @Override
        public void dumpStatusPartial(StatusDumper statusDumper) {
            super.dumpStatusPartial(statusDumper);
        }

        @Override
        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": Busy32BitTSS:");
            this.dumpStatusPartial(statusDumper);
            statusDumper.endObject();
        }

        public Busy32BitTSS(AddressSpace addressSpace, int n, long l) {
            super(addressSpace, n, l);
        }

        @Override
        public int getType() {
            return 11;
        }
    }

    public static final class Available32BitTSS
    extends AbstractTSS {
        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
            super.dumpSRPartial(sRDumper);
        }

        public Available32BitTSS(SRLoader sRLoader) throws IOException {
            super(sRLoader);
        }

        @Override
        public void dumpStatusPartial(StatusDumper statusDumper) {
            super.dumpStatusPartial(statusDumper);
        }

        @Override
        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": Available32BitTSS:");
            this.dumpStatusPartial(statusDumper);
            statusDumper.endObject();
        }

        public Available32BitTSS(AddressSpace addressSpace, int n, long l) {
            super(addressSpace, n, l);
        }

        @Override
        public int getType() {
            return 9;
        }
    }

    public static abstract class AbstractTSS
    extends ReadOnlyProtectedModeSegment {
        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
            super.dumpSRPartial(sRDumper);
        }

        public AbstractTSS(SRLoader sRLoader) throws IOException {
            super(sRLoader);
        }

        @Override
        public void dumpStatusPartial(StatusDumper statusDumper) {
            super.dumpStatusPartial(statusDumper);
        }

        @Override
        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": AbstractTSS:");
            this.dumpStatusPartial(statusDumper);
            statusDumper.endObject();
        }

        public AbstractTSS(AddressSpace addressSpace, int n, long l) {
            super(addressSpace, n, l);
        }

        public void saveCPUState(Processor processor) {
            int n = this.translateAddressWrite(0);
            this.memory.setDoubleWord(n + 32, processor.eip);
            this.memory.setDoubleWord(n + 36, processor.getEFlags());
            this.memory.setDoubleWord(n + 40, processor.eax);
            this.memory.setDoubleWord(n + 44, processor.ecx);
            this.memory.setDoubleWord(n + 48, processor.edx);
            this.memory.setDoubleWord(n + 52, processor.ebx);
            this.memory.setDoubleWord(n + 56, processor.esp);
            this.memory.setDoubleWord(n + 60, processor.ebp);
            this.memory.setDoubleWord(n + 64, processor.esi);
            this.memory.setDoubleWord(n + 68, processor.edi);
            this.memory.setDoubleWord(n + 72, processor.es.getSelector());
            this.memory.setDoubleWord(n + 76, processor.cs.getSelector());
            this.memory.setDoubleWord(n + 80, processor.ss.getSelector());
            this.memory.setDoubleWord(n + 84, processor.ds.getSelector());
            this.memory.setDoubleWord(n + 88, processor.fs.getSelector());
            this.memory.setDoubleWord(n + 92, processor.gs.getSelector());
        }

        public void restoreCPUState(Processor processor) {
            int n = this.translateAddressRead(0);
            processor.eip = this.memory.getDoubleWord(n + 32);
            processor.setEFlags(this.memory.getDoubleWord(n + 36));
            processor.eax = this.memory.getDoubleWord(n + 40);
            processor.ecx = this.memory.getDoubleWord(n + 44);
            processor.edx = this.memory.getDoubleWord(n + 48);
            processor.ebx = this.memory.getDoubleWord(n + 52);
            processor.esp = this.memory.getDoubleWord(n + 56);
            processor.ebp = this.memory.getDoubleWord(n + 60);
            processor.esi = this.memory.getDoubleWord(n + 64);
            processor.edi = this.memory.getDoubleWord(n + 68);
            processor.es = processor.getSegment(0xFFFF & this.memory.getDoubleWord(n + 72));
            processor.cs = processor.getSegment(0xFFFF & this.memory.getDoubleWord(n + 76));
            processor.ss = processor.getSegment(0xFFFF & this.memory.getDoubleWord(n + 80));
            processor.ds = processor.getSegment(0xFFFF & this.memory.getDoubleWord(n + 84));
            processor.fs = processor.getSegment(0xFFFF & this.memory.getDoubleWord(n + 88));
            processor.gs = processor.getSegment(0xFFFF & this.memory.getDoubleWord(n + 92));
            processor.ldtr = processor.getSegment(0xFFFF & this.memory.getDoubleWord(n + 96));
            processor.setCR3(this.memory.getDoubleWord(n + 28));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte getByte(int n) {
            boolean bl = ((LinearAddressSpace)this.memory).isSupervisor();
            try {
                ((LinearAddressSpace)this.memory).setSupervisor(true);
                byte by = super.getByte(n);
                return by;
            }
            finally {
                ((LinearAddressSpace)this.memory).setSupervisor(bl);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public short getWord(int n) {
            boolean bl = ((LinearAddressSpace)this.memory).isSupervisor();
            try {
                ((LinearAddressSpace)this.memory).setSupervisor(true);
                short s = super.getWord(n);
                return s;
            }
            finally {
                ((LinearAddressSpace)this.memory).setSupervisor(bl);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getDoubleWord(int n) {
            boolean bl = ((LinearAddressSpace)this.memory).isSupervisor();
            try {
                ((LinearAddressSpace)this.memory).setSupervisor(true);
                int n2 = super.getDoubleWord(n);
                return n2;
            }
            finally {
                ((LinearAddressSpace)this.memory).setSupervisor(bl);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getQuadWord(int n) {
            boolean bl = ((LinearAddressSpace)this.memory).isSupervisor();
            try {
                ((LinearAddressSpace)this.memory).setSupervisor(true);
                long l = super.getQuadWord(n);
                return l;
            }
            finally {
                ((LinearAddressSpace)this.memory).setSupervisor(bl);
            }
        }
    }

    public static final class ExecuteReadConformingCodeSegment
    extends ProtectedModeSegment {
        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
            super.dumpSRPartial(sRDumper);
        }

        public ExecuteReadConformingCodeSegment(SRLoader sRLoader) throws IOException {
            super(sRLoader);
        }

        @Override
        public void dumpStatusPartial(StatusDumper statusDumper) {
            super.dumpStatusPartial(statusDumper);
        }

        @Override
        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": ExecuteReadConformingCodeSegment:");
            this.dumpStatusPartial(statusDumper);
            statusDumper.endObject();
        }

        public ExecuteReadConformingCodeSegment(AddressSpace addressSpace, int n, long l) {
            super(addressSpace, n, l);
        }

        @Override
        public int getType() {
            return 30;
        }
    }

    public static final class ExecuteReadConformingAccessedCodeSegment
    extends ProtectedModeSegment {
        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
            super.dumpSRPartial(sRDumper);
        }

        public ExecuteReadConformingAccessedCodeSegment(SRLoader sRLoader) throws IOException {
            super(sRLoader);
        }

        @Override
        public void dumpStatusPartial(StatusDumper statusDumper) {
            super.dumpStatusPartial(statusDumper);
        }

        @Override
        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": ExecuteReadConformingAccessedCodeSegment:");
            this.dumpStatusPartial(statusDumper);
            statusDumper.endObject();
        }

        public ExecuteReadConformingAccessedCodeSegment(AddressSpace addressSpace, int n, long l) {
            super(addressSpace, n, l);
        }

        @Override
        public int getType() {
            return 31;
        }
    }

    public static final class ExecuteOnlyConformingAccessedCodeSegment
    extends ReadOnlyProtectedModeSegment {
        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
            super.dumpSRPartial(sRDumper);
        }

        public ExecuteOnlyConformingAccessedCodeSegment(SRLoader sRLoader) throws IOException {
            super(sRLoader);
        }

        @Override
        public void dumpStatusPartial(StatusDumper statusDumper) {
            super.dumpStatusPartial(statusDumper);
        }

        @Override
        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": ExecuteOnlyConformingAccessedCodeSegment:");
            this.dumpStatusPartial(statusDumper);
            statusDumper.endObject();
        }

        public ExecuteOnlyConformingAccessedCodeSegment(AddressSpace addressSpace, int n, long l) {
            super(addressSpace, n, l);
        }

        @Override
        public int getType() {
            return 29;
        }
    }

    public static final class ExecuteReadCodeSegment
    extends ProtectedModeSegment {
        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
            super.dumpSRPartial(sRDumper);
        }

        public ExecuteReadCodeSegment(SRLoader sRLoader) throws IOException {
            super(sRLoader);
        }

        @Override
        public void dumpStatusPartial(StatusDumper statusDumper) {
            super.dumpStatusPartial(statusDumper);
        }

        @Override
        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": ExecuteReadCodeSegment:");
            this.dumpStatusPartial(statusDumper);
            statusDumper.endObject();
        }

        public ExecuteReadCodeSegment(AddressSpace addressSpace, int n, long l) {
            super(addressSpace, n, l);
        }

        @Override
        public int getType() {
            return 26;
        }
    }

    public static final class ExecuteReadAccessedCodeSegment
    extends ProtectedModeSegment {
        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
            super.dumpSRPartial(sRDumper);
        }

        public ExecuteReadAccessedCodeSegment(SRLoader sRLoader) throws IOException {
            super(sRLoader);
        }

        @Override
        public void dumpStatusPartial(StatusDumper statusDumper) {
            super.dumpStatusPartial(statusDumper);
        }

        @Override
        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": ExecuteReadAccessedCodeSegment:");
            this.dumpStatusPartial(statusDumper);
            statusDumper.endObject();
        }

        public ExecuteReadAccessedCodeSegment(AddressSpace addressSpace, int n, long l) {
            super(addressSpace, n, l);
        }

        @Override
        public int getType() {
            return 27;
        }
    }

    public static final class ExecuteOnlyCodeSegment
    extends ReadOnlyProtectedModeSegment {
        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
            super.dumpSRPartial(sRDumper);
        }

        public ExecuteOnlyCodeSegment(SRLoader sRLoader) throws IOException {
            super(sRLoader);
        }

        @Override
        public void dumpStatusPartial(StatusDumper statusDumper) {
            super.dumpStatusPartial(statusDumper);
        }

        @Override
        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": ExecuteOnlyCodeSegment:");
            this.dumpStatusPartial(statusDumper);
            statusDumper.endObject();
        }

        public ExecuteOnlyCodeSegment(AddressSpace addressSpace, int n, long l) {
            super(addressSpace, n, l);
        }

        @Override
        public int getType() {
            return 24;
        }
    }

    public static final class ReadWriteAccessedDataSegment
    extends ProtectedModeSegment {
        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
            super.dumpSRPartial(sRDumper);
        }

        public ReadWriteAccessedDataSegment(SRLoader sRLoader) throws IOException {
            super(sRLoader);
        }

        @Override
        public void dumpStatusPartial(StatusDumper statusDumper) {
            super.dumpStatusPartial(statusDumper);
        }

        @Override
        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": ReadWriteAccessedDataSegment:");
            this.dumpStatusPartial(statusDumper);
            statusDumper.endObject();
        }

        public ReadWriteAccessedDataSegment(AddressSpace addressSpace, int n, long l) {
            super(addressSpace, n, l);
        }

        @Override
        public int getType() {
            return 19;
        }
    }

    public static final class DownReadWriteDataSegment
    extends ProtectedModeSegment {
        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
            super.dumpSRPartial(sRDumper);
        }

        public DownReadWriteDataSegment(SRLoader sRLoader) throws IOException {
            super(sRLoader);
        }

        @Override
        public void dumpStatusPartial(StatusDumper statusDumper) {
            super.dumpStatusPartial(statusDumper);
        }

        @Override
        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": DownReadWriteDataSegment:");
            this.dumpStatusPartial(statusDumper);
            statusDumper.endObject();
        }

        public DownReadWriteDataSegment(AddressSpace addressSpace, int n, long l) {
            super(addressSpace, n, l);
        }

        @Override
        public int getType() {
            return 18;
        }

        @Override
        public final int translateAddressRead(int n) {
            this.checkAddress(n);
            return ((ProtectedModeSegment)this).base + n;
        }

        @Override
        public final int translateAddressWrite(int n) {
            this.checkAddress(n);
            return ((ProtectedModeSegment)this).base + n;
        }

        @Override
        public final void checkAddress(int n) {
            if ((0xFFFFFFFFL & (long)n) > ((ProtectedModeSegment)this).limit) {
                throw new ProcessorException(ProcessorException.Type.GENERAL_PROTECTION, 0, true);
            }
        }
    }

    public static final class ReadWriteDataSegment
    extends ProtectedModeSegment {
        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
            super.dumpSRPartial(sRDumper);
        }

        public ReadWriteDataSegment(SRLoader sRLoader) throws IOException {
            super(sRLoader);
        }

        @Override
        public void dumpStatusPartial(StatusDumper statusDumper) {
            super.dumpStatusPartial(statusDumper);
        }

        @Override
        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": ReadWriteDataSegment:");
            this.dumpStatusPartial(statusDumper);
            statusDumper.endObject();
        }

        public ReadWriteDataSegment(AddressSpace addressSpace, int n, long l) {
            super(addressSpace, n, l);
        }

        @Override
        public int getType() {
            return 18;
        }
    }

    public static final class ReadOnlyAccessedDataSegment
    extends ReadOnlyProtectedModeSegment {
        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
            super.dumpSRPartial(sRDumper);
        }

        public ReadOnlyAccessedDataSegment(SRLoader sRLoader) throws IOException {
            super(sRLoader);
        }

        @Override
        public void dumpStatusPartial(StatusDumper statusDumper) {
            super.dumpStatusPartial(statusDumper);
        }

        @Override
        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": ReadOnlyAccessedDataSegment:");
            this.dumpStatusPartial(statusDumper);
            statusDumper.endObject();
        }

        public ReadOnlyAccessedDataSegment(AddressSpace addressSpace, int n, long l) {
            super(addressSpace, n, l);
        }

        @Override
        public int getType() {
            return 17;
        }

        @Override
        void writeAttempted() {
            throw ProcessorException.GENERAL_PROTECTION_0;
        }
    }

    public static final class ReadOnlyDataSegment
    extends ReadOnlyProtectedModeSegment {
        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
            super.dumpSRPartial(sRDumper);
        }

        public ReadOnlyDataSegment(SRLoader sRLoader) throws IOException {
            super(sRLoader);
        }

        @Override
        public void dumpStatusPartial(StatusDumper statusDumper) {
            super.dumpStatusPartial(statusDumper);
        }

        @Override
        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": ReadOnlyDataSegment:");
            this.dumpStatusPartial(statusDumper);
            statusDumper.endObject();
        }

        public ReadOnlyDataSegment(AddressSpace addressSpace, int n, long l) {
            super(addressSpace, n, l);
        }

        @Override
        public int getType() {
            return 16;
        }

        @Override
        void writeAttempted() {
            throw ProcessorException.GENERAL_PROTECTION_0;
        }
    }

    public static abstract class ReadOnlyProtectedModeSegment
    extends ProtectedModeSegment {
        @Override
        public void dumpSRPartial(SRDumper sRDumper) throws IOException {
            super.dumpSRPartial(sRDumper);
        }

        public ReadOnlyProtectedModeSegment(SRLoader sRLoader) throws IOException {
            super(sRLoader);
        }

        @Override
        public void dumpStatusPartial(StatusDumper statusDumper) {
            super.dumpStatusPartial(statusDumper);
        }

        @Override
        public void dumpStatus(StatusDumper statusDumper) {
            if (statusDumper.dumped(this)) {
                return;
            }
            statusDumper.println("#" + statusDumper.objectNumber(this) + ": ReadOnlyProtectedModeSegment:");
            this.dumpStatusPartial(statusDumper);
            statusDumper.endObject();
        }

        public ReadOnlyProtectedModeSegment(AddressSpace addressSpace, int n, long l) {
            super(addressSpace, n, l);
        }

        void writeAttempted() {
            System.err.println("Critical error: write attempted to Read Only PM segment.");
            throw new IllegalStateException("Can't write to read only PM segment");
        }

        @Override
        public final void setByte(int n, byte by) {
            this.writeAttempted();
        }

        @Override
        public final void setWord(int n, short s) {
            this.writeAttempted();
        }

        @Override
        public final void setDoubleWord(int n, int n2) {
            this.writeAttempted();
        }

        @Override
        public final void setQuadWord(int n, long l) {
            this.writeAttempted();
        }
    }
}

