/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.processor;

import java.io.IOException;
import org.jpc.emulator.SRDumpable;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.SRLoader;
import org.jpc.emulator.StatusDumper;
import org.jpc.emulator.memory.AddressSpace;
import org.jpc.emulator.processor.ProcessorException;

public abstract class Segment
implements SRDumpable {
    protected AddressSpace memory;

    public Segment(AddressSpace addressSpace, boolean bl) {
        this.memory = addressSpace;
    }

    public final void setAddressSpace(AddressSpace addressSpace) {
        this.memory = addressSpace;
    }

    public abstract boolean isPresent();

    public abstract boolean isSystem();

    public abstract int getType();

    public abstract int getSelector();

    public abstract int getLimit();

    public abstract int getBase();

    public abstract boolean getDefaultSizeFlag();

    public abstract int getRPL();

    public abstract void setRPL(int var1);

    public abstract int getDPL();

    public abstract boolean setSelector(int var1);

    public abstract void checkAddress(int var1) throws ProcessorException;

    public abstract int translateAddressRead(int var1);

    public abstract int translateAddressWrite(int var1);

    public abstract void printState();

    public byte getByte(int n) {
        return this.memory.getByte(this.translateAddressRead(n));
    }

    public short getWord(int n) {
        return this.memory.getWord(this.translateAddressRead(n));
    }

    public int getDoubleWord(int n) {
        return this.memory.getDoubleWord(this.translateAddressRead(n));
    }

    public long getQuadWord(int n) {
        int n2 = this.translateAddressRead(n);
        long l = 0xFFFFFFFFL & (long)this.memory.getDoubleWord(n2);
        n2 = this.translateAddressRead(n + 4);
        return l |= (long)this.memory.getDoubleWord(n2) << 32;
    }

    public void setByte(int n, byte by) {
        this.memory.setByte(this.translateAddressWrite(n), by);
    }

    public void setWord(int n, short s) {
        this.memory.setWord(this.translateAddressWrite(n), s);
    }

    public void setDoubleWord(int n, int n2) {
        this.memory.setDoubleWord(this.translateAddressWrite(n), n2);
    }

    public void setQuadWord(int n, long l) {
        int n2 = this.translateAddressWrite(n);
        this.memory.setDoubleWord(n2, (int)l);
        n2 = this.translateAddressWrite(n + 4);
        this.memory.setDoubleWord(n2, (int)(l >>> 32));
    }

    public void dumpStatus(StatusDumper statusDumper) {
        if (statusDumper.dumped(this)) {
            return;
        }
        statusDumper.println("#" + statusDumper.objectNumber(this) + ": Segment:");
        this.dumpStatusPartial(statusDumper);
        statusDumper.endObject();
    }

    public void dumpStatusPartial(StatusDumper statusDumper) {
        statusDumper.println("\tmemory <object #" + statusDumper.objectNumber(this.memory) + ">");
        if (this.memory != null) {
            this.memory.dumpStatus(statusDumper);
        }
    }

    @Override
    public void dumpSRPartial(SRDumper sRDumper) throws IOException {
        sRDumper.dumpObject(this.memory);
    }

    public Segment(SRLoader sRLoader) throws IOException {
        sRLoader.objectCreated(this);
        this.memory = (AddressSpace)sRLoader.loadObject();
    }
}

