/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.processor;

import java.io.IOException;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.SRLoader;
import org.jpc.emulator.StatusDumper;
import org.jpc.emulator.memory.AddressSpace;
import org.jpc.emulator.processor.ProcessorException;
import org.jpc.emulator.processor.Segment;

public class Virtual8086ModeSegment
extends Segment {
    private int selector;
    private int base;
    private int type;
    private int dpl;
    private int rpl;
    private long limit;

    @Override
    public void dumpStatusPartial(StatusDumper statusDumper) {
        super.dumpStatusPartial(statusDumper);
        statusDumper.println("\tselector " + this.selector + " base " + this.base + " limit " + this.limit + " rpl " + this.rpl);
        statusDumper.println("\tdpl " + this.dpl + " type " + this.type);
    }

    @Override
    public void dumpStatus(StatusDumper statusDumper) {
        if (statusDumper.dumped(this)) {
            return;
        }
        statusDumper.println("#" + statusDumper.objectNumber(this) + ": Virtual8086ModeSegment:");
        this.dumpStatusPartial(statusDumper);
        statusDumper.endObject();
    }

    @Override
    public void dumpSRPartial(SRDumper sRDumper) throws IOException {
        sRDumper.dumpInt(this.selector);
        sRDumper.dumpInt(this.base);
        sRDumper.dumpInt(this.type);
        sRDumper.dumpInt(this.dpl);
        sRDumper.dumpInt(this.rpl);
        sRDumper.dumpLong(this.limit);
    }

    public Virtual8086ModeSegment(SRLoader sRLoader) throws IOException {
        super(sRLoader);
        this.selector = sRLoader.loadInt();
        this.base = sRLoader.loadInt();
        this.type = sRLoader.loadInt();
        this.dpl = sRLoader.loadInt();
        this.rpl = sRLoader.loadInt();
        this.limit = sRLoader.loadLong();
    }

    public Virtual8086ModeSegment(AddressSpace addressSpace, int n, boolean bl) {
        super(addressSpace, true);
        this.selector = n;
        this.base = n << 4;
        this.limit = 65535L;
        this.dpl = 3;
        this.rpl = 3;
        this.type = bl ? 11 : 3;
    }

    public Virtual8086ModeSegment(AddressSpace addressSpace, Segment segment) {
        super(addressSpace, true);
        this.selector = segment.getSelector();
        this.base = segment.getBase();
        this.type = segment.getType();
        this.limit = 0xFFFFFFFFL & (long)segment.getLimit();
    }

    @Override
    public boolean getDefaultSizeFlag() {
        return false;
    }

    @Override
    public int getLimit() {
        return (int)this.limit;
    }

    @Override
    public int getBase() {
        return this.base;
    }

    @Override
    public int getSelector() {
        return this.selector;
    }

    @Override
    public boolean setSelector(int n) {
        this.selector = n;
        this.base = n << 4;
        this.type = 3;
        return true;
    }

    @Override
    public void checkAddress(int n) {
        if ((0xFFFFFFFFL & (long)n) > this.limit) {
            throw ProcessorException.GENERAL_PROTECTION_0;
        }
    }

    @Override
    public int translateAddressRead(int n) {
        this.checkAddress(n);
        return this.base + n;
    }

    @Override
    public int translateAddressWrite(int n) {
        this.checkAddress(n);
        return this.base + n;
    }

    @Override
    public int getRPL() {
        return this.rpl;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public boolean isPresent() {
        return true;
    }

    @Override
    public boolean isSystem() {
        return false;
    }

    @Override
    public int getDPL() {
        return this.dpl;
    }

    @Override
    public void setRPL(int n) {
        this.rpl = n;
    }

    @Override
    public void printState() {
        System.out.println("VM86 Segment");
        System.out.println("selector: " + Integer.toHexString(this.selector));
        System.out.println("base: " + Integer.toHexString(this.base));
        System.out.println("dpl: " + Integer.toHexString(this.dpl));
        System.out.println("rpl: " + Integer.toHexString(this.rpl));
        System.out.println("limit: " + Long.toHexString(this.limit));
        System.out.println("type: " + Integer.toHexString(this.type));
    }
}

