/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.j2se;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.UIManager;
import org.jpc.ArgProcessor;
import org.jpc.Misc;
import org.jpc.Revision;
import org.jpc.diskimages.DiskImage;
import org.jpc.diskimages.ImageLibrary;
import org.jpc.diskimages.ImageMaker;
import org.jpc.pluginsbase.Plugin;
import org.jpc.pluginsbase.Plugins;

public class JPCApplication {
    public static Plugin instantiatePlugin(Plugins plugins, Class<?> clazz, String string) throws IOException {
        Constructor<?> constructor;
        if (string != null) {
            try {
                constructor = clazz.getConstructor(Plugins.class, String.class);
            }
            catch (Exception exception) {
                throw new IOException("Plugin \"" + clazz.getName() + "\" does not take arguments.");
            }
        }
        try {
            constructor = clazz.getConstructor(Plugins.class);
        }
        catch (Exception exception) {
            throw new IOException("Plugin \"" + clazz.getName() + "\" requires arguments.");
        }
        try {
            if (string != null) {
                return (Plugin)constructor.newInstance(plugins, string);
            }
            return (Plugin)constructor.newInstance(plugins);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                IOException iOException = new IOException("Error while invoking loader: " + throwable);
                iOException.setStackTrace(throwable.getStackTrace());
                throw iOException;
            }
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            IOException iOException = new IOException("Unknown exception while invoking loader: " + throwable);
            iOException.setStackTrace(throwable.getStackTrace());
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException("Failed to invoke plugin \"" + clazz.getName() + "\" constructor.");
        }
    }

    private static void loadPlugin(Plugins plugins, String string) throws IOException {
        Class<?> clazz;
        String string2;
        String string3 = string;
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = string3.length();
        boolean bl = false;
        int n6 = 0;
        while (true) {
            if (n6 >= n5) {
                if (n == 0) {
                    if (n2 < 0) {
                        n2 = n6 - 1;
                    }
                    string2 = string3.substring(0, n6);
                    if (n6 < n5) {
                        if (!(string3 = string3.substring(n6 + 1)).equals("")) break;
                        throw new IOException("Error in module string: Blank module name not allowed.");
                    }
                    string3 = "";
                    break;
                }
                throw new IOException("Error in module string: unclosed '('.");
            }
            int n7 = string3.codePointAt(n6);
            if (n7 >= 65536) {
                ++n6;
            }
            if (n7 >= 55296 && n7 < 57344 || (n7 & 0xFFFE) == 65534 || n7 >>> 16 > 16 || n7 < 0) {
                throw new IOException("Error In module string: invalid Unicode character.");
            }
            if (bl && n7 != 44) {
                throw new IOException("Error in module string: Expected ',' after ')' closing parameter list.");
            }
            if (n7 == 44 && n6 == 0) {
                throw new IOException("Error in module string: Blank module name not allowed.");
            }
            if (n7 == 40) {
                if (n == 0) {
                    n3 = n6 + 1;
                    n2 = n6 - 1;
                }
                ++n;
            } else if (n7 == 41) {
                if (n == 0) {
                    throw new IOException("Error in module string: Unpaired ')'.");
                }
                if (n == 1) {
                    n4 = n6 - 1;
                    bl = true;
                }
                --n;
            }
            ++n6;
        }
        String string4 = string2.substring(0, n2 + 1);
        String string5 = null;
        if (n3 >= 0) {
            string5 = string2.substring(n3, n4 + 1);
        }
        try {
            clazz = Class.forName(string4);
        }
        catch (Exception exception) {
            throw new IOException("Unable to find plugin \"" + string4 + "\".");
        }
        if (!Plugin.class.isAssignableFrom(clazz)) {
            throw new IOException("Plugin \"" + string4 + "\" is not valid plugin.");
        }
        Plugin plugin = JPCApplication.instantiatePlugin(plugins, clazz, string5);
        plugins.registerPlugin(plugin);
    }

    private static void doListImages(ImageLibrary imageLibrary, String string) throws IOException {
        Object object;
        PrintStream printStream = System.out;
        boolean bl = false;
        if (string != null) {
            object = new BufferedOutputStream(new FileOutputStream(string));
            printStream = new PrintStream((OutputStream)object, false, "UTF-8");
            bl = true;
        }
        for (String string2 : object = imageLibrary.imagesByType(-2L)) {
            JPCApplication.printImageInfo(printStream, imageLibrary, string2, true);
        }
        if (bl) {
            printStream.close();
        }
    }

    public static void printImageInfo(PrintStream printStream, ImageLibrary imageLibrary, String string, boolean bl) throws IOException {
        String string2 = imageLibrary.searchFileName(string);
        if (string2 == null) {
            System.err.println("No image named '" + string + "' exists.");
            return;
        }
        try {
            String string3;
            ImageMaker.ParsedImage parsedImage = new ImageMaker.ParsedImage(string2);
            switch (parsedImage.typeCode) {
                case 0: {
                    string3 = "floppy    ";
                    break;
                }
                case 1: {
                    string3 = "HDD       ";
                    break;
                }
                case 2: {
                    string3 = "CD-ROM    ";
                    break;
                }
                case 3: {
                    string3 = "BIOS      ";
                    break;
                }
                default: {
                    string3 = "<Unknown> ";
                }
            }
            if (bl) {
                printStream.println("" + new ImageLibrary.ByteArray(parsedImage.diskID) + " " + string3 + " " + string);
                return;
            }
            printStream.println("Name               : " + string);
            printStream.println("File name          : " + string2);
            printStream.println("Type               : " + string3);
            if (parsedImage.typeCode == 0 || parsedImage.typeCode == 1) {
                printStream.println("Tracks             : " + parsedImage.tracks);
                printStream.println("Sides              : " + parsedImage.sides);
                printStream.println("Sectors            : " + parsedImage.sectors);
                printStream.println("Total sectors      : " + parsedImage.totalSectors);
                printStream.println("Primary extent size: " + parsedImage.sectorsPresent);
                printStream.println("Storage Method     : " + parsedImage.method);
                int n = 0;
                for (int i = 0; i < parsedImage.totalSectors; ++i) {
                    if (i >= parsedImage.sectorOffsetMap.length || parsedImage.sectorOffsetMap[i] <= 0) continue;
                    ++n;
                }
                printStream.println("Sectors present    : " + n);
            } else if (parsedImage.typeCode == 2) {
                printStream.println("Total sectors      : " + parsedImage.totalSectors);
            } else if (parsedImage.typeCode == 3) {
                printStream.println("Image Size         : " + parsedImage.rawImage.length);
            }
            printStream.println("Claimed Disk ID    : " + new ImageLibrary.ByteArray(parsedImage.diskID));
            List<String> list = parsedImage.comments;
            if (list != null) {
                printStream.println("");
                printStream.println("Comments section:");
                printStream.println("");
                for (String string4 : list) {
                    printStream.println(string4);
                }
            }
        }
        catch (IOException iOException) {
            Misc.errorDialog(iOException, "Failed to read image", null, "Quit");
        }
    }

    private static void doImageInfo(ImageLibrary imageLibrary, String string) throws IOException {
        PrintStream printStream = System.out;
        boolean bl = false;
        int n = string.indexOf(" ");
        if (n > 0) {
            String string2 = string.substring(0, n);
            string = string.substring(n + 1);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string2));
            printStream = new PrintStream((OutputStream)bufferedOutputStream, false, "UTF-8");
            bl = true;
        }
        JPCApplication.printImageInfo(printStream, imageLibrary, string, false);
        if (bl) {
            printStream.close();
        }
    }

    public static void doCommand(Plugins plugins, String string) throws IOException {
        block41: {
            if (string.toLowerCase().startsWith("load ")) {
                try {
                    JPCApplication.loadPlugin(plugins, string.substring(5));
                }
                catch (Exception exception) {
                    Misc.errorDialog(exception, "Plugin Loading failed", null, "Dismiss");
                }
            } else if (string.toLowerCase().equals("exit")) {
                plugins.shutdownEmulator();
            } else if (!string.toLowerCase().equals("")) {
                if (string.toLowerCase().startsWith("emuname ")) {
                    Misc.emuname = "[" + string.substring(8) + "]";
                } else if (string.toLowerCase().startsWith("command ")) {
                    try {
                        String[] stringArray = Misc.parseString(string.substring(8));
                        if (stringArray == null) {
                            throw new Exception("No command to send given");
                        }
                        String string2 = stringArray[0];
                        String[] stringArray2 = null;
                        if (stringArray.length > 1) {
                            stringArray2 = new String[stringArray.length - 1];
                            System.arraycopy(stringArray, 1, stringArray2, 0, stringArray.length - 1);
                        }
                        plugins.invokeExternalCommandSynchronous(string2, stringArray2);
                    }
                    catch (Exception exception) {
                        Misc.errorDialog(exception, "Command sending failed", null, "Dismiss");
                    }
                } else if (string.toLowerCase().startsWith("call ")) {
                    try {
                        Object[] objectArray;
                        String[] stringArray = Misc.parseString(string.substring(5));
                        if (stringArray == null) {
                            throw new Exception("No command to send given");
                        }
                        String string3 = stringArray[0];
                        String[] stringArray3 = null;
                        if (stringArray.length > 1) {
                            stringArray3 = new String[stringArray.length - 1];
                            System.arraycopy(stringArray, 1, stringArray3, 0, stringArray.length - 1);
                        }
                        if ((objectArray = plugins.invokeExternalCommandReturn(string3, stringArray3)) != null) {
                            for (int i = 0; i < objectArray.length; ++i) {
                                System.out.println(objectArray[i].toString());
                            }
                            break block41;
                        }
                        System.out.println("Nothing returned.");
                    }
                    catch (Exception exception) {
                        Misc.errorDialog(exception, "Command sending failed", null, "Dismiss");
                    }
                } else if (string.toLowerCase().startsWith("library ")) {
                    String string4 = string.substring(8);
                    File file = new File(string4);
                    if (!file.isDirectory() && !file.mkdirs()) {
                        Misc.callShowOptionDialog(null, "Library (" + string4 + ") does not exist and can't be created", "Disk library error", 0, 2, null, new String[]{"Dismiss"}, "Dismiss");
                        return;
                    }
                    DiskImage.setLibrary(new ImageLibrary(string4));
                } else if (string.toLowerCase().equals("lsdisks") || string.toLowerCase().startsWith("lsdisks ")) {
                    ImageLibrary imageLibrary;
                    String string5 = null;
                    if (string.length() > 8) {
                        string5 = string.substring(8);
                    }
                    if ((imageLibrary = DiskImage.getLibrary()) == null) {
                        System.err.println("No library loaded");
                        return;
                    }
                    try {
                        JPCApplication.doListImages(imageLibrary, string5);
                    }
                    catch (Exception exception) {
                        Misc.errorDialog(exception, "Failed to lisk known images", null, "Dismiss");
                    }
                } else if (string.toLowerCase().startsWith("diskinfo ")) {
                    String string6 = string.substring(9);
                    ImageLibrary imageLibrary = DiskImage.getLibrary();
                    if (imageLibrary == null) {
                        System.err.println("No library loaded");
                        return;
                    }
                    try {
                        JPCApplication.doImageInfo(imageLibrary, string6);
                    }
                    catch (Exception exception) {
                        Misc.errorDialog(exception, "Failed to get information for image", null, "Dismiss");
                    }
                } else if (string.toLowerCase().equals("kill")) {
                    String string7 = "crashdump-" + System.currentTimeMillis() + ".text";
                    try {
                        FileOutputStream fileOutputStream = new FileOutputStream(string7);
                        Misc.doCrashDump(fileOutputStream);
                        ((OutputStream)fileOutputStream).close();
                        System.err.println("Crash dump saved to '" + string7 + "'.");
                        plugins.doKillEmulator();
                    }
                    catch (Exception exception) {
                        System.err.println("Failed to save crash dump to '" + string7 + "':" + exception.getMessage());
                    }
                } else {
                    System.err.println("Invalid command");
                }
            }
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Throwable throwable) {
            System.err.println("Warning: System Look-and-Feel not loaded" + throwable.getMessage());
        }
        if (stringArray != null && stringArray.length > 0 && "-imagemaker".equals(stringArray[0])) {
            String[] stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray2, 0, stringArray.length - 1);
            ImageMaker.main(stringArray2);
            return;
        }
        System.out.println("JPC-RR: Rerecording PC emulator based on JPC PC emulator. Release " + Revision.getRelease());
        System.out.println("Revision: " + Revision.getRevision());
        System.out.println("Based on JPC PC emulator.");
        System.out.println("Copyright (C) 2007-2009 Isis Innovation Limited");
        System.out.println("Copyright (C) 2009-2010 H. Ilari Liusvaara");
        System.out.println("JPC-RR is released under GPL Version 2 and comes with absoutely no warranty.");
        Misc.probeRenameOver(ArgProcessor.findFlag(stringArray, "-norenames"));
        Plugins plugins = new Plugins();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
        boolean bl = ArgProcessor.findFlag(stringArray, "-noautoexec");
        String string = ArgProcessor.findVariable(stringArray, "autoexec", null);
        if (string != null && !bl) {
            try {
                String string2;
                object = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "UTF-8"));
                while ((string2 = ((BufferedReader)object).readLine()) != null) {
                    JPCApplication.doCommand(plugins, string2);
                }
            }
            catch (Exception exception) {
                System.err.println("Failed to load autoexec script: " + exception.getMessage());
            }
        }
        while (true) {
            System.out.print("JPC-RR> ");
            System.out.flush();
            object = bufferedReader.readLine();
            try {
                JPCApplication.doCommand(plugins, (String)object);
                continue;
            }
            catch (Exception exception) {
                Misc.errorDialog(exception, "Command execution failed", null, "Dismiss");
                continue;
            }
            break;
        }
    }
}

