/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.jrsr;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;

public class FourToFiveDecoder
extends InputStream
implements Closeable {
    private InputStream underlying;
    private byte[] buffer;
    private int bufferFill;
    private int bufferBase;
    private int bufferRemainder;
    private int bufferRemainderStart;
    private boolean eofFlag;
    private boolean closed;

    public FourToFiveDecoder(InputStream inputStream) {
        this.underlying = inputStream;
        this.buffer = new byte[2100];
        this.bufferFill = 0;
        this.bufferBase = 0;
        this.bufferRemainder = 0;
        this.bufferRemainderStart = 0;
        this.eofFlag = false;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int n) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("FourToFiveDecoder does not support marks");
    }

    @Override
    public void close() throws IOException {
        this.underlying.close();
        this.closed = true;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int available() throws IOException {
        if (this.closed) {
            throw new IOException("Trying to operate on closed stream");
        }
        return this.underlying.available() / 5 * 4;
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("Trying to operate on closed stream");
        }
        byte[] byArray = new byte[1];
        int n = this.read(byArray, 0, 1);
        if (n == -1) {
            return -1;
        }
        return byArray[0] & 0xFF;
    }

    private String formatCode(byte[] byArray, int n, int n2) {
        char[] cArray = new char[n2];
        for (int i = 0; i < n2; ++i) {
            System.err.println("" + (byArray[n + i] & 0xFF));
            cArray[i] = (char)(byArray[n + i] & 0xFF);
        }
        return new String(cArray);
    }

    private int collapseWhitespace(byte[] byArray, int n) throws IOException {
        int n2 = 0;
        int n3 = 0;
        block12: for (int i = 0; i < n; ++i) {
            int n4 = byArray[i] & 0xFF;
            switch (n2) {
                case 0: {
                    if (n4 == 9 || n4 == 10 || n4 == 12 || n4 == 13 || n4 == 28 || n4 == 29 || n4 == 30 || n4 == 32) continue block12;
                    if (n4 >= 33 && n4 <= 126) {
                        byArray[n3++] = byArray[i];
                        continue block12;
                    }
                    if (n4 == 194) {
                        n2 = 1;
                        continue block12;
                    }
                    if (n4 == 225) {
                        n2 = 2;
                        continue block12;
                    }
                    if (n4 == 226) {
                        n2 = 3;
                        continue block12;
                    }
                    if (n4 == 227) {
                        n2 = 4;
                        continue block12;
                    }
                    throw new IOException("Illegal character " + n4 + " in FourToFive stream");
                }
                case 1: {
                    if (n4 == 133) {
                        n2 = 0;
                        continue block12;
                    }
                    throw new IOException("Illegal character 194-" + n4 + " in FourToFive stream");
                }
                case 2: {
                    if (n4 == 154) {
                        n2 = 5;
                        continue block12;
                    }
                    if (n4 == 160) {
                        n2 = 6;
                        continue block12;
                    }
                    throw new IOException("Illegal character 225-" + n4 + " in FourToFive stream");
                }
                case 3: {
                    if (n4 == 128) {
                        n2 = 7;
                        continue block12;
                    }
                    if (n4 == 129) {
                        n2 = 8;
                        continue block12;
                    }
                    throw new IOException("Illegal character 226-" + n4 + " in FourToFive stream");
                }
                case 4: {
                    if (n4 == 128) {
                        n2 = 9;
                        continue block12;
                    }
                    throw new IOException("Illegal character 227-" + n4 + " in FourToFive stream");
                }
                case 5: {
                    if (n4 == 128) {
                        n2 = 0;
                        continue block12;
                    }
                    throw new IOException("Illegal character 225-154-" + n4 + " in FourToFive stream");
                }
                case 6: {
                    if (n4 == 142) {
                        n2 = 0;
                        continue block12;
                    }
                    throw new IOException("Illegal character 225-160-" + n4 + " in FourToFive stream");
                }
                case 7: {
                    if (n4 >= 128 && n4 <= 138) {
                        n2 = 0;
                        continue block12;
                    }
                    if (n4 == 168) {
                        n2 = 0;
                        continue block12;
                    }
                    if (n4 == 169) {
                        n2 = 0;
                        continue block12;
                    }
                    throw new IOException("Illegal character 226-128-" + n4 + " in FourToFive stream");
                }
                case 8: {
                    if (n4 == 159) {
                        n2 = 0;
                        continue block12;
                    }
                    throw new IOException("Illegal character 226-129-" + n4 + " in FourToFive stream");
                }
                case 9: {
                    if (n4 == 128) {
                        n2 = 0;
                        continue block12;
                    }
                    throw new IOException("Illegal character 227-128-" + n4 + " in FourToFive stream");
                }
            }
        }
        return n3;
    }

    private void fillBuffer() throws IOException {
        int n;
        int n2;
        int n3;
        boolean bl = false;
        System.arraycopy(this.buffer, this.bufferRemainderStart, this.buffer, 0, this.bufferRemainder);
        this.bufferRemainder = 0;
        for (n2 = this.bufferRemainder; n2 < this.buffer.length; n2 += n3) {
            n3 = this.underlying.read(this.buffer, n2, this.buffer.length - n2);
            if (n3 != -1) continue;
            this.eofFlag = true;
            break;
        }
        n3 = 0;
        n2 = n = this.collapseWhitespace(this.buffer, n2);
        n3 = 0;
        n = 0;
        while (n3 < n2) {
            long l;
            if (this.buffer[n3] == 33) {
                bl = true;
                this.eofFlag = true;
                break;
            }
            if (this.buffer[n3] >= 34 && this.buffer[n3] <= 36) {
                if (n3 + 2 > n2) break;
                if (this.buffer[n3 + 1] == 33) {
                    throw new IOException("! in middle of sequence not allowed");
                }
                l = (long)(this.buffer[n3] - 34) * 93L + (long)(this.buffer[n3 + 1] - 34);
                if (l > 255L) {
                    throw new IOException("Illegal sequence " + this.formatCode(this.buffer, n3, 2) + " in FourToFive stream");
                }
                n3 += 2;
                this.buffer[n++] = (byte)l;
                continue;
            }
            if (this.buffer[n3] >= 37 && this.buffer[n3] <= 44) {
                if (n3 + 3 > n2) break;
                if (this.buffer[n3 + 1] == 33) {
                    throw new IOException("! in middle of sequence not allowed");
                }
                if (this.buffer[n3 + 2] == 33) {
                    throw new IOException("! in middle of sequence not allowed");
                }
                l = (long)(this.buffer[n3] - 37) * 93L * 93L + (long)(this.buffer[n3 + 1] - 34) * 93L + (long)(this.buffer[n3 + 2] - 34);
                if (l > 65535L) {
                    throw new IOException("Illegal sequence " + this.formatCode(this.buffer, n3, 3) + " in FourToFive stream");
                }
                n3 += 3;
                this.buffer[n++] = (byte)(l / 256L);
                this.buffer[n++] = (byte)(l % 256L);
                continue;
            }
            if (this.buffer[n3] >= 45 && this.buffer[n3] <= 65) {
                if (n3 + 4 > n2) break;
                if (this.buffer[n3 + 1] == 33) {
                    throw new IOException("! in middle of sequence not allowed");
                }
                if (this.buffer[n3 + 2] == 33) {
                    throw new IOException("! in middle of sequence not allowed");
                }
                if (this.buffer[n3 + 3] == 33) {
                    throw new IOException("! in middle of sequence not allowed");
                }
                l = (long)(this.buffer[n3] - 45) * 93L * 93L * 93L + (long)(this.buffer[n3 + 1] - 34) * 93L * 93L + (long)(this.buffer[n3 + 2] - 34) * 93L + (long)(this.buffer[n3 + 3] - 34);
                if (l > 0xFFFFFFL) {
                    throw new IOException("Illegal sequence " + this.formatCode(this.buffer, n3, 4) + " in FourToFive stream");
                }
                n3 += 4;
                this.buffer[n++] = (byte)(l / 65536L);
                this.buffer[n++] = (byte)(l / 256L % 256L);
                this.buffer[n++] = (byte)(l % 256L);
                continue;
            }
            if (this.buffer[n3] >= 66 && this.buffer[n3] <= 123) {
                if (n3 + 5 > n2) break;
                if (this.buffer[n3 + 1] == 33) {
                    throw new IOException("! in middle of sequence not allowed");
                }
                if (this.buffer[n3 + 2] == 33) {
                    throw new IOException("! in middle of sequence not allowed");
                }
                if (this.buffer[n3 + 3] == 33) {
                    throw new IOException("! in middle of sequence not allowed");
                }
                if (this.buffer[n3 + 4] == 33) {
                    throw new IOException("! in middle of sequence not allowed");
                }
                l = (long)(this.buffer[n3] - 66) * 93L * 93L * 93L * 93L + (long)(this.buffer[n3 + 1] - 34) * 93L * 93L * 93L + (long)(this.buffer[n3 + 2] - 34) * 93L * 93L + (long)(this.buffer[n3 + 3] - 34) * 93L + (long)(this.buffer[n3 + 4] - 34);
                if (l > 0x100000000L) {
                    throw new IOException("Illegal sequence " + this.formatCode(this.buffer, n3, 5) + " in FourToFive stream (position " + n3 + ")");
                }
                n3 += 5;
                this.buffer[n++] = (byte)(l / 0x1000000L);
                this.buffer[n++] = (byte)(l / 65536L % 256L);
                this.buffer[n++] = (byte)(l / 256L % 256L);
                this.buffer[n++] = (byte)(l % 256L);
                continue;
            }
            throw new IOException("Illegal sequence " + this.formatCode(this.buffer, n3, 1) + " in FourToFive stream");
        }
        if (!bl && n2 > n3) {
            this.bufferRemainderStart = n3;
            this.bufferRemainder = n2 - n3;
        } else {
            this.bufferRemainder = 0;
        }
        if (this.eofFlag && this.bufferRemainder > 0) {
            throw new IOException("Unexpected end of FourToFive stream in partial sequence " + this.formatCode(this.buffer, this.bufferRemainderStart, this.bufferRemainder));
        }
        this.bufferBase = 0;
        this.bufferFill = n;
    }

    @Override
    public long skip(long l) throws IOException {
        if (this.closed) {
            throw new IOException("Trying to operate on closed stream");
        }
        long l2 = 0L;
        while (l > 0L) {
            if (this.bufferFill == 0) {
                if (this.eofFlag) {
                    return l2;
                }
                this.fillBuffer();
            }
            if (l < (long)this.bufferFill) {
                this.bufferBase += (int)l;
                this.bufferFill -= (int)l;
                l2 += l;
                l = 0L;
                continue;
            }
            l -= (long)this.bufferFill;
            this.bufferBase += this.bufferFill;
            l2 += (long)this.bufferFill;
            this.bufferFill = 0;
        }
        return l2;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException("Trying to operate on closed stream");
        }
        int n3 = 0;
        while (n2 > 0) {
            if (this.bufferFill == 0) {
                if (this.eofFlag && n3 == 0) {
                    return -1;
                }
                if (this.eofFlag) {
                    return n3;
                }
                this.fillBuffer();
            }
            if (n2 < this.bufferFill) {
                System.arraycopy(this.buffer, this.bufferBase, byArray, n, n2);
                this.bufferBase += n2;
                this.bufferFill -= n2;
                n += n2;
                n3 += n2;
                n2 = 0;
                continue;
            }
            System.arraycopy(this.buffer, this.bufferBase, byArray, n, this.bufferFill);
            n += this.bufferFill;
            n2 -= this.bufferFill;
            this.bufferBase += this.bufferFill;
            n3 += this.bufferFill;
            this.bufferFill = 0;
        }
        return n3;
    }
}

