/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.jrsr;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import org.jpc.Misc;

public class JRSRArchiveWriter
implements Closeable {
    private boolean active = false;
    private OutputStream underlying;
    private String finalName;
    private File temporary;
    private boolean closed;

    public JRSRArchiveWriter(String string) throws IOException {
        String string2 = Misc.tempname(string);
        this.temporary = new File(string2);
        this.finalName = string;
        this.underlying = new FileOutputStream(this.temporary);
        byte[] byArray = new byte[]{74, 82, 83, 82, 10};
        this.underlying.write(byArray);
    }

    public void rollback() throws IOException {
        if (this.closed) {
            return;
        }
        this.underlying.close();
        this.temporary.delete();
        this.closed = true;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.active) {
            throw new IOException("Trying close JRSR Archive without closing member");
        }
        byte[] byArray = new byte[]{33, 69, 78, 68, 10};
        this.underlying.write(byArray);
        this.underlying.flush();
        this.underlying.close();
        Misc.renameFile(this.temporary, new File(this.finalName));
        this.closed = true;
    }

    public JRSRArchiveOutputStream addMember(String string) throws IOException {
        ByteBuffer byteBuffer;
        if (this.closed) {
            throw new IOException("Trying to operate on closed stream");
        }
        if (this.active) {
            throw new IOException("Trying to add new member to JRSR Archive without closing previous");
        }
        byte[] byArray = new byte[]{33, 66, 69, 71, 73, 78, 32};
        byte[] byArray2 = new byte[]{10};
        try {
            byteBuffer = Charset.forName("UTF-8").newEncoder().encode(CharBuffer.wrap(string));
        }
        catch (CharacterCodingException characterCodingException) {
            throw new IOException("WTF??? UTF-8 can't encode String???");
        }
        byte[] byArray3 = new byte[byteBuffer.remaining()];
        byteBuffer.get(byArray3);
        if (byArray3.length > 1024) {
            throw new IOException("JRSR member maximum name length of 1024 bytes exceeded");
        }
        this.underlying.write(byArray);
        this.underlying.write(byArray3);
        this.underlying.write(byArray2);
        this.active = true;
        return new JRSRArchiveOutputStream();
    }

    public class JRSRArchiveOutputStream
    extends OutputStream {
        public boolean atLineStart = true;
        private boolean closed2;

        JRSRArchiveOutputStream() {
        }

        @Override
        public void close() throws IOException {
            if (this.closed2) {
                return;
            }
            this.flush();
            JRSRArchiveWriter.this.active = false;
            byte[] byArray = new byte[]{10};
            if (!this.atLineStart) {
                JRSRArchiveWriter.this.underlying.write(byArray);
            }
            JRSRArchiveWriter.this.underlying.flush();
            this.closed2 = true;
        }

        @Override
        public void flush() throws IOException {
            if (JRSRArchiveWriter.this.closed || this.closed2) {
                throw new IOException("Trying to operate on closed stream");
            }
            JRSRArchiveWriter.this.underlying.flush();
        }

        private int min3(int n, int n2, int n3) {
            if (n <= n2 && n <= n3) {
                return n;
            }
            if (n2 <= n && n2 <= n3) {
                return n2;
            }
            return n3;
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (JRSRArchiveWriter.this.closed || this.closed2) {
                throw new IOException("Trying to operate on closed stream");
            }
            byte[] byArray2 = new byte[2048];
            int n3 = 0;
            while (n2 > 0) {
                int n4;
                for (n4 = 0; n4 < n2 && byArray[n + n4] != 10; ++n4) {
                }
                if (this.atLineStart) {
                    byArray2[n3++] = 43;
                    this.atLineStart = false;
                }
                int n5 = byArray2.length - n3;
                int n6 = n4 == n2 ? byArray2.length + 1 : n4 + 1;
                int n7 = this.min3(n5, n6, n2);
                System.arraycopy(byArray, n, byArray2, n3, n7);
                n += n7;
                n2 -= n7;
                n3 += n7;
                if (n5 == n7) {
                    JRSRArchiveWriter.this.underlying.write(byArray2);
                    n3 = 0;
                }
                if (n6 != n7) continue;
                this.atLineStart = true;
            }
            if (n3 > 0) {
                JRSRArchiveWriter.this.underlying.write(byArray2, 0, n3);
            }
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        @Override
        public void write(int n) throws IOException {
            byte[] byArray = new byte[]{(byte)n};
            this.write(byArray, 0, 1);
        }
    }
}

