/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.jrsr;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;

public class UTFInputLineStream
implements Closeable {
    private InputStream underlying;
    private byte[] buffer;
    private int bufferStart;
    private int bufferFill;
    private boolean eofFlag;
    private char[] cBuffer;
    private int cBufferStart;
    private int cBufferFill;
    private boolean cEOFFlag;
    private int bytesTotal;
    private int bytesComing;
    private int partialValue;
    private boolean invalidRunFlag;
    private boolean closed;

    public UTFInputLineStream(InputStream inputStream) {
        this.underlying = inputStream;
        this.buffer = new byte[1024];
        this.bufferStart = 0;
        this.bufferFill = 0;
        this.eofFlag = false;
        this.cBuffer = new char[384];
        this.cBufferStart = 0;
        this.cBufferFill = 0;
        this.cEOFFlag = false;
        this.bytesTotal = 0;
        this.bytesComing = 0;
        this.partialValue = 0;
        this.invalidRunFlag = false;
    }

    @Override
    public void close() throws IOException {
        this.underlying.close();
        this.closed = true;
    }

    private void fillBuffer() throws IOException {
        if (this.bufferStart > 0 && this.bufferFill > 0) {
            System.arraycopy(this.buffer, this.bufferStart, this.buffer, 0, this.bufferFill);
        }
        this.bufferStart = 0;
        if (this.bufferFill > this.buffer.length / 2) {
            return;
        }
        if (!this.eofFlag) {
            int n = this.underlying.read(this.buffer, this.bufferFill, this.buffer.length - this.bufferFill);
            if (n < 0) {
                this.eofFlag = true;
            } else {
                this.bufferFill += n;
            }
        }
    }

    private void fillCBuffer() throws IOException {
        if (this.cBufferStart > 0 && this.cBufferFill > 0) {
            System.arraycopy(this.cBuffer, this.cBufferStart, this.cBuffer, 0, this.cBufferFill);
        }
        this.cBufferStart = 0;
        while (this.bufferFill > 0 && this.cBufferFill < this.cBuffer.length - 2) {
            int n = this.buffer[this.bufferStart++] & 0xFF;
            --this.bufferFill;
            if (this.bytesComing > 0) {
                if (n < 128 && n > 159) {
                    this.cBuffer[this.cBufferFill++] = 65533;
                    this.bytesTotal = 0;
                    this.bytesComing = 0;
                    this.partialValue = 0;
                    --this.bufferStart;
                    ++this.bufferFill;
                    continue;
                }
                this.partialValue = this.partialValue * 64 + (n - 128);
                --this.bytesComing;
                if (this.bytesComing != 0) continue;
                if (this.bytesTotal == 2 && this.partialValue < 128) {
                    this.partialValue = 65533;
                }
                if (this.bytesTotal == 3 && this.partialValue < 2048) {
                    this.partialValue = 65533;
                }
                if (this.bytesTotal == 4 && this.partialValue < 65536) {
                    this.partialValue = 65533;
                }
                if (this.bytesTotal < 1 && this.bytesTotal > 4) {
                    this.partialValue = 65533;
                }
                if (this.partialValue > 127 && this.partialValue < 160 && this.partialValue != 133) {
                    throw new IOException("Illegal character " + this.partialValue + " in stream");
                }
                if (this.partialValue >= 55296 && this.partialValue <= 57343) {
                    throw new IOException("Illegal character " + this.partialValue + " in stream");
                }
                if ((this.partialValue & 0xFFFE) == 65534) {
                    throw new IOException("Illegal character " + this.partialValue + " in stream");
                }
                if (this.partialValue > 0x10FFFF) {
                    throw new IOException("Illegal character " + this.partialValue + " in stream");
                }
                if (this.partialValue < 65536) {
                    this.cBuffer[this.cBufferFill++] = (char)this.partialValue;
                    continue;
                }
                this.cBuffer[this.cBufferFill++] = (char)(this.partialValue + 56557568 >> 10);
                this.cBuffer[this.cBufferFill++] = (char)((this.partialValue & 0x3FF) + 56320);
                continue;
            }
            if (n < 128) {
                if (n < 32 && n != 13 && n != 10 && n != 9 && n != 12 && n != 28 && n != 29 && n != 30 || n == 127) {
                    throw new IOException("Illegal character " + n + " in stream");
                }
                this.bytesComing = 0;
                this.cBuffer[this.cBufferFill++] = (char)n;
                this.invalidRunFlag = false;
                continue;
            }
            if (n >= 128 && n < 192 || n >= 248) {
                if (!this.invalidRunFlag) {
                    this.cBuffer[this.cBufferFill++] = 65533;
                }
                this.invalidRunFlag = true;
                continue;
            }
            if (n >= 192 && n < 224) {
                this.bytesTotal = 2;
                this.bytesComing = 1;
                this.partialValue = n - 192;
                this.invalidRunFlag = false;
                continue;
            }
            if (n >= 224 && n < 240) {
                this.bytesTotal = 3;
                this.bytesComing = 2;
                this.partialValue = n - 224;
                this.invalidRunFlag = false;
                continue;
            }
            if (n < 240 || n >= 248) continue;
            this.bytesTotal = 4;
            this.bytesComing = 3;
            this.partialValue = n - 240;
            this.invalidRunFlag = false;
        }
        if (this.bufferFill == 0 && this.eofFlag) {
            this.cEOFFlag = true;
            if (this.bytesComing > 0) {
                this.cBuffer[this.cBufferFill++] = 65533;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String readLine() throws IOException {
        if (this.closed) {
            throw new IOException("Trying to operate on closed stream");
        }
        char c = '\r';
        char c2 = '\n';
        char c3 = '\u001c';
        char c4 = '\u001d';
        char c5 = '\u001e';
        char c6 = '\u2029';
        char c7 = '\u0085';
        char c8 = '\uffffffff';
        char c9 = '\ufffffffe';
        int n = 1;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.cEOFFlag && this.cBufferFill == 0) {
            return null;
        }
        while (true) {
            int n2;
            this.fillBuffer();
            this.fillCBuffer();
            n = 1;
            for (n2 = 0; n2 < this.cBufferFill; ++n2) {
                char c10 = this.cBuffer[this.cBufferStart + n2];
                char c11 = n2 < this.cBufferFill - 1 ? this.cBuffer[this.cBufferStart + n2 + 1] : (this.cEOFFlag ? c9 : c8);
                if (c10 == c2 || c10 == c3 || c10 == c4 || c10 == c5 || c10 == c6 || c10 == c7) break;
                if (c10 == c && c11 == c8) {
                    n = 0;
                    break;
                }
                if (c10 == c && c11 == c9) break;
                if (c10 == c && c11 == c2) {
                    n = 2;
                    break;
                }
                if (c10 == c) break;
            }
            if (n2 == this.cBufferFill) {
                stringBuilder.append(this.cBuffer, this.cBufferStart, this.cBufferFill);
                this.cBufferFill = 0;
                if (!this.cEOFFlag) continue;
                return stringBuilder.toString();
            }
            stringBuilder.append(this.cBuffer, this.cBufferStart, n2);
            this.cBufferStart += n2 + n;
            this.cBufferFill -= n2 + n;
            if (n > 0) return stringBuilder.toString();
        }
    }
}

