/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.jrsr;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import org.jpc.Misc;

public class UTFOutputLineStream
implements Closeable {
    private OutputStream underlying;
    private boolean closed;

    public UTFOutputLineStream(OutputStream outputStream) {
        this.underlying = outputStream;
    }

    public void writeLine(String string) throws IOException {
        ByteBuffer byteBuffer;
        if (this.closed) {
            throw new IOException("Trying to operate on closed stream");
        }
        try {
            byteBuffer = Charset.forName("UTF-8").newEncoder().encode(CharBuffer.wrap(string));
        }
        catch (CharacterCodingException characterCodingException) {
            throw new IOException("WTF??? UTF-8 can't encode String???");
        }
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.get(byArray);
        this.underlying.write(byArray);
        this.underlying.write(10);
    }

    public void encodeLine(Object ... objectArray) throws IOException {
        if (this.closed) {
            throw new IOException("Trying to operate on closed stream");
        }
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null) {
                return;
            }
            stringArray[i] = objectArray[i].toString();
        }
        this.writeLine(Misc.encodeLine(stringArray));
    }

    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("Trying to operate on closed stream");
        }
        this.underlying.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.flush();
        this.underlying.close();
        this.closed = true;
    }
}

