/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.luaextensions;

import java.io.IOException;
import java.io.RandomAccessFile;
import mnj.lua.Lua;
import org.jpc.plugins.LuaPlugin;

public class BinaryFile
extends LuaPlugin.LuaResource {
    RandomAccessFile object;

    public BinaryFile(LuaPlugin luaPlugin, String string, String string2) throws IOException {
        super(luaPlugin);
        this.object = new RandomAccessFile(string, string2);
    }

    @Override
    public void destroy() throws IOException {
        this.object.close();
        this.object = null;
    }

    public int luaCB_length(Lua lua, LuaPlugin luaPlugin) {
        try {
            lua.pushNumber(this.object.length());
        }
        catch (IOException iOException) {
            lua.pushNil();
            lua.pushString("IOException: " + iOException.getMessage());
            return 2;
        }
        return 1;
    }

    public int luaCB_set_length(Lua lua, LuaPlugin luaPlugin) {
        lua.pushNil();
        try {
            this.object.setLength((long)lua.checkNumber(2));
        }
        catch (IOException iOException) {
            lua.pushNil();
            lua.pushString("IOException: " + iOException.getMessage());
            return 2;
        }
        return 1;
    }

    public int luaCB_read(Lua lua, LuaPlugin luaPlugin) {
        lua.pushNil();
        lua.pushNil();
        try {
            long l = (long)lua.checkNumber(2);
            int n = (int)lua.checkNumber(3);
            if (n <= 0) {
                lua.pushNil();
                lua.pushString("Length is not positive");
                return 2;
            }
            byte[] byArray = new byte[n];
            this.object.seek(l);
            n = this.object.read(byArray);
            if (n < 0) {
                lua.pushNil();
                lua.pushNil();
                return 2;
            }
            StringBuffer stringBuffer = new StringBuffer(n);
            for (byte by : byArray) {
                stringBuffer.appendCodePoint(by & 0xFF);
            }
            lua.push(stringBuffer.toString());
        }
        catch (IOException iOException) {
            lua.pushNil();
            lua.pushString("IOException: " + iOException.getMessage());
            return 2;
        }
        return 1;
    }

    public int luaCB_write(Lua lua, LuaPlugin luaPlugin) {
        lua.pushNil();
        lua.pushNil();
        try {
            long l = (long)lua.checkNumber(2);
            String string = lua.checkString(3);
            if (string == "") {
                lua.pushBoolean(true);
                return 1;
            }
            byte[] byArray = new byte[string.length()];
            this.object.seek(l);
            for (int i = 0; i < string.length(); ++i) {
                byArray[i] = (byte)string.charAt(i);
            }
            this.object.write(byArray);
            lua.pushBoolean(true);
        }
        catch (IOException iOException) {
            lua.pushBoolean(false);
            lua.pushString("IOException: " + iOException.getMessage());
            return 2;
        }
        return 1;
    }

    public int luaCB_close(Lua lua, LuaPlugin luaPlugin) {
        try {
            luaPlugin.destroyLuaObject(lua);
            lua.pushBoolean(true);
        }
        catch (IOException iOException) {
            lua.pushBoolean(false);
            lua.pushString("IOException: " + iOException.getMessage());
            return 2;
        }
        return 1;
    }

    public static int luaCB_open(Lua lua, LuaPlugin luaPlugin) {
        lua.pushNil();
        lua.pushNil();
        String string = lua.checkString(1);
        String string2 = lua.checkString(2);
        try {
            luaPlugin.generateLuaClass(lua, new BinaryFile(luaPlugin, string, string2));
        }
        catch (IOException iOException) {
            lua.pushNil();
            lua.pushString("IOException: " + iOException.getMessage());
            return 2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            lua.pushNil();
            lua.pushString("Illegal argument: " + illegalArgumentException.getMessage());
            return 2;
        }
        return 1;
    }
}

