/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.luaextensions;

import java.util.Formatter;
import mnj.lua.Lua;
import org.jpc.plugins.LuaPlugin;

public class Bitops
extends LuaPlugin.LuaResource {
    private static long BIT_MASK = 0xFFFFFFFFFFFFL;
    private static long BIT_HIGH = 0x800000000000L;
    private static long BITS = 48L;

    @Override
    public void destroy() {
    }

    private Bitops(LuaPlugin luaPlugin) {
        super(luaPlugin);
    }

    private static int intLuaCBBitwise(Lua lua, int n) {
        long l = 0L;
        int n2 = 1;
        if (n == 0 || n == 3) {
            l = BIT_MASK;
        }
        while (lua.type(n2) == 3) {
            long l2 = (long)lua.checkNumber(n2) & BIT_MASK;
            if (n == 0) {
                l &= l2 ^ 0xFFFFFFFFFFFFFFFFL;
            } else if (n == 1) {
                l |= l2;
            } else if (n == 2) {
                l ^= l2;
            } else if (n == 3) {
                l &= l2;
            } else if (n == 4) {
                l = l + l2 & BIT_MASK;
            } else if (n == 5) {
                l = l - l2 & BIT_MASK;
            } else if (n == 6 && n2 % 2 == 1) {
                l = l + l2 & BIT_MASK;
            } else if (n == 6 && n2 % 2 == 0) {
                l = l - l2 & BIT_MASK;
            }
            ++n2;
        }
        if (lua.type(n2) != -1) {
            lua.error("All bitwise operation arguments must be numbers");
            return 0;
        }
        lua.pushNumber(l);
        return 1;
    }

    public static int luaCB_none(Lua lua, LuaPlugin luaPlugin) {
        return Bitops.intLuaCBBitwise(lua, 0);
    }

    public static int luaCB_any(Lua lua, LuaPlugin luaPlugin) {
        return Bitops.intLuaCBBitwise(lua, 1);
    }

    public static int luaCB_parity(Lua lua, LuaPlugin luaPlugin) {
        return Bitops.intLuaCBBitwise(lua, 2);
    }

    public static int luaCB_all(Lua lua, LuaPlugin luaPlugin) {
        return Bitops.intLuaCBBitwise(lua, 3);
    }

    public static int luaCB_add(Lua lua, LuaPlugin luaPlugin) {
        return Bitops.intLuaCBBitwise(lua, 4);
    }

    public static int luaCB_addneg(Lua lua, LuaPlugin luaPlugin) {
        return Bitops.intLuaCBBitwise(lua, 5);
    }

    public static int luaCB_addalt(Lua lua, LuaPlugin luaPlugin) {
        return Bitops.intLuaCBBitwise(lua, 6);
    }

    private static int intLuaCBShift(Lua lua, int n) {
        long l = 0L;
        long l2 = 0L;
        lua.pushNil();
        lua.pushNil();
        l = (long)lua.checkNumber(1) & BIT_MASK;
        l2 = (long)lua.checkNumber(2);
        if (l2 < 0L || l2 >= BITS) {
            lua.error("Invalid shift count: " + l2);
        }
        if (n == 0) {
            l <<= (int)l2;
        } else if (n == 1) {
            l >>>= (int)l2;
        } else if (n == 2) {
            int n2 = 0;
            while ((long)n2 < l2) {
                boolean bl = (l & BIT_HIGH) != 0L;
                l >>>= 1;
                if (bl) {
                    l |= BIT_HIGH;
                }
                ++n2;
            }
        } else if (n == 3) {
            l = l >>> (int)(BITS - l2) | l << (int)l2;
        } else if (n == 4) {
            l = l << (int)(BITS - l2) | l >>> (int)l2;
        }
        lua.pushNumber(l & BIT_MASK);
        return 1;
    }

    public static int luaCB_lshift(Lua lua, LuaPlugin luaPlugin) {
        return Bitops.intLuaCBShift(lua, 0);
    }

    public static int luaCB_rshift(Lua lua, LuaPlugin luaPlugin) {
        return Bitops.intLuaCBShift(lua, 1);
    }

    public static int luaCB_arshift(Lua lua, LuaPlugin luaPlugin) {
        return Bitops.intLuaCBShift(lua, 2);
    }

    public static int luaCB_rol(Lua lua, LuaPlugin luaPlugin) {
        return Bitops.intLuaCBShift(lua, 3);
    }

    public static int luaCB_ror(Lua lua, LuaPlugin luaPlugin) {
        return Bitops.intLuaCBShift(lua, 4);
    }

    public static int luaCB_bswap2(Lua lua, LuaPlugin luaPlugin) {
        long l = 0L;
        lua.pushNil();
        l = (long)lua.checkNumber(1) & BIT_MASK;
        l = l & 0xFFFFFFFFFFFF0000L | (l & 0xFFL) << 8 | (l & 0xFF00L) >> 8;
        lua.pushNumber(l & BIT_MASK);
        return 1;
    }

    public static int luaCB_bswap3(Lua lua, LuaPlugin luaPlugin) {
        long l = 0L;
        lua.pushNil();
        l = (long)lua.checkNumber(1) & BIT_MASK;
        l = l & 0xFFFFFFFFFF00FF00L | (l & 0xFFL) << 16 | (l & 0xFF0000L) >> 16;
        lua.pushNumber(l & BIT_MASK);
        return 1;
    }

    public static int luaCB_bswap4(Lua lua, LuaPlugin luaPlugin) {
        long l = 0L;
        lua.pushNil();
        l = (long)lua.checkNumber(1) & BIT_MASK;
        l = l & 0xFFFFFFFF00000000L | (l & 0xFFL) << 24 | (l & 0xFF00L) << 8 | (l & 0xFF0000L) >> 8 | (l & 0xFF000000L) >> 24;
        lua.pushNumber(l & BIT_MASK);
        return 1;
    }

    public static int luaCB_bswap5(Lua lua, LuaPlugin luaPlugin) {
        long l = 0L;
        lua.pushNil();
        l = (long)lua.checkNumber(1) & BIT_MASK;
        l = l & 0xFFFFFFFF00000000L | (l & 0xFFL) << 32 | (l & 0xFF00L) << 16 | (l & 0xFF000000L) >> 16 | (l & 0xFF00000000L) >> 32;
        lua.pushNumber(l & BIT_MASK);
        return 1;
    }

    public static int luaCB_bswap6(Lua lua, LuaPlugin luaPlugin) {
        long l = 0L;
        lua.pushNil();
        l = (long)lua.checkNumber(1) & BIT_MASK;
        l = l & 0xFFFFFFFF00000000L | (l & 0xFFL) << 40 | (l & 0xFF00L) << 24 | (l & 0xFF000000L) << 8 | (l & 0xFF00000000L) >> 8 | (l & 0xFF0000000000L) >> 24 | (l & 0xFF000000000000L) >> 40;
        lua.pushNumber(l & BIT_MASK);
        return 1;
    }

    public static int luaCB_signextend(Lua lua, LuaPlugin luaPlugin) {
        long l = 0L;
        long l2 = 0L;
        lua.pushNil();
        lua.pushNil();
        l = (long)lua.checkNumber(1) & BIT_MASK;
        l2 = (long)lua.checkNumber(2);
        if (l2 < 0L || l2 >= BITS) {
            lua.error("Invalid sign bit: " + l2);
        }
        l = (l & (long)(1 << (int)l2)) != 0L ? (l |= BIT_MASK - (long)((1 << (int)l2) - 1)) : (l &= (long)((1 << (int)l2) - 1));
        lua.pushNumber(l & BIT_MASK);
        return 1;
    }

    public static int luaCB_tosigned(Lua lua, LuaPlugin luaPlugin) {
        long l = 0L;
        long l2 = 0L;
        lua.pushNil();
        lua.pushNil();
        l = (long)lua.checkNumber(1) & BIT_MASK;
        l2 = (long)lua.checkNumber(2);
        if (l2 < 0L || l2 >= BITS) {
            lua.error("Invalid sign bit: " + l2);
        }
        if ((l & (long)(1 << (int)l2)) != 0L) {
            l &= (long)((1 << (int)l2) - 1);
            l -= (long)(1 << (int)l2);
        } else {
            l &= (long)((1 << (int)l2) - 1);
        }
        lua.pushNumber(l);
        return 1;
    }

    public static int luaCB_tohex(Lua lua, LuaPlugin luaPlugin) {
        long l = 0L;
        lua.pushNil();
        l = (long)lua.checkNumber(1) & BIT_MASK;
        lua.push(new Formatter().format("%012X", l).toString());
        return 1;
    }
}

