/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.luaextensions;

import mnj.lua.Lua;
import org.jpc.emulator.peripheral.Keyboard;
import org.jpc.modules.Joystick;
import org.jpc.plugins.LuaPlugin;

public class InputDevices
extends LuaPlugin.LuaResource {
    @Override
    public void destroy() {
    }

    private InputDevices(LuaPlugin luaPlugin) {
        super(luaPlugin);
    }

    public static int luaCB_keypressed(Lua lua, LuaPlugin luaPlugin) {
        if (lua.type(1) != 3) {
            lua.error("Unexpected types to keypressed");
            return 0;
        }
        Keyboard keyboard = (Keyboard)luaPlugin.getComponent(Keyboard.class);
        if (keyboard != null) {
            lua.pushBoolean(keyboard.getKeyExecStatus((byte)lua.checkNumber(1)));
        } else {
            lua.pushBoolean(false);
        }
        return 1;
    }

    public static int luaCB_keypressed_edge(Lua lua, LuaPlugin luaPlugin) {
        if (lua.type(1) != 3) {
            lua.error("Unexpected types to keypressed");
            return 0;
        }
        Keyboard keyboard = (Keyboard)luaPlugin.getComponent(Keyboard.class);
        if (keyboard != null) {
            lua.pushBoolean(keyboard.getKeyStatus((byte)lua.checkNumber(1)));
        } else {
            lua.pushBoolean(false);
        }
        return 1;
    }

    public static int luaCB_keyboard_leds(Lua lua, LuaPlugin luaPlugin) {
        Keyboard keyboard = (Keyboard)luaPlugin.getComponent(Keyboard.class);
        if (keyboard != null) {
            int n = keyboard.getLEDStatus();
            if (n < 0) {
                lua.pushBoolean(false);
                return 1;
            }
            lua.pushBoolean((n & 2) != 0);
            lua.pushBoolean((n & 4) != 0);
            lua.pushBoolean((n & 1) != 0);
            return 3;
        }
        lua.pushNil();
        return 1;
    }

    public static int luaCB_joystick_state(Lua lua, LuaPlugin luaPlugin) {
        Joystick joystick = (Joystick)luaPlugin.getComponent(Joystick.class);
        if (joystick != null) {
            lua.push(new Double(joystick.axisHoldTime(0, false)));
            lua.push(new Double(joystick.axisHoldTime(1, false)));
            lua.push(new Double(joystick.axisHoldTime(2, false)));
            lua.push(new Double(joystick.axisHoldTime(3, false)));
            lua.pushBoolean(joystick.buttonState(0, false));
            lua.pushBoolean(joystick.buttonState(1, false));
            lua.pushBoolean(joystick.buttonState(2, false));
            lua.pushBoolean(joystick.buttonState(3, false));
            return 8;
        }
        lua.pushNil();
        return 1;
    }

    public static int luaCB_mouse_state(Lua lua, LuaPlugin luaPlugin) {
        Keyboard keyboard = (Keyboard)luaPlugin.getComponent(Keyboard.class);
        if (keyboard != null) {
            lua.push(new Double(keyboard.getMouseXPendingMotion()));
            lua.push(new Double(keyboard.getMouseYPendingMotion()));
            lua.push(new Double(keyboard.getMouseZPendingMotion()));
            int n = keyboard.getMouseButtonStatus();
            lua.pushBoolean((n & 1) != 0);
            lua.pushBoolean((n & 2) != 0);
            lua.pushBoolean((n & 4) != 0);
            lua.pushBoolean((n & 8) != 0);
            lua.pushBoolean((n & 0x10) != 0);
            return 8;
        }
        lua.pushNil();
        return 1;
    }
}

