/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.luaextensions;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import mnj.lua.Lua;
import org.jpc.emulator.memory.PhysicalAddressSpace;
import org.jpc.emulator.processor.fpu64.FpuState64;
import org.jpc.plugins.LuaPlugin;

public class MemorySearch
extends LuaPlugin.LuaResource {
    Map<Integer, byte[]> currentPages = new HashMap<Integer, byte[]>();
    Map<Integer, Integer> currentPageCandidates = new HashMap<Integer, Integer>();
    long candidates;
    int firstBadPage;

    public MemorySearch(LuaPlugin luaPlugin) throws IOException {
        super(luaPlugin);
    }

    @Override
    public void destroy() throws IOException {
        this.currentPages.clear();
        this.currentPageCandidates.clear();
        this.candidates = 0L;
        this.firstBadPage = 0;
    }

    public int luaCB_reset(Lua lua, LuaPlugin luaPlugin) {
        PhysicalAddressSpace physicalAddressSpace = (PhysicalAddressSpace)luaPlugin.getComponent(PhysicalAddressSpace.class);
        this.currentPages.clear();
        this.currentPageCandidates.clear();
        this.candidates = 0L;
        this.firstBadPage = 0;
        if (physicalAddressSpace != null) {
            int n = 0;
            Integer n2 = new Integer(4096);
            while ((n = physicalAddressSpace.findFirstRAMPage(n)) >= 0) {
                byte[] byArray = new byte[4608];
                Arrays.fill(byArray, 4096, 4608, (byte)-1);
                Integer n3 = new Integer(n);
                this.currentPages.put(n3, byArray);
                this.currentPageCandidates.put(n3, n2);
                physicalAddressSpace.readRAMPage(n, byArray);
                this.candidates += 4096L;
                this.firstBadPage = ++n;
            }
        }
        lua.pushNumber(this.candidates);
        return 1;
    }

    private static final int typeSize(int n) throws IOException {
        switch (n) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 8;
            }
            case 64: {
                return 4;
            }
            case 65: {
                return 8;
            }
            case 66: {
                return 10;
            }
        }
        throw new IOException("Bad access type " + n);
    }

    private static final boolean canFastpath(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 6: 
            case 7: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    public final boolean compareCore(long l, long l2, long l3, int n) throws IOException {
        switch (n) {
            case 0: {
                return l2 < l3;
            }
            case 3: {
                if (l2 == l3) {
                    return true;
                }
            }
            case 1: {
                if (l2 >= 0L && l3 >= 0L) {
                    return l2 < l3;
                }
                if (l2 < 0L && l3 < 0L) {
                    return l2 > l3;
                }
                return l2 >= 0L && l3 < 0L;
            }
            case 2: {
                return l2 <= l3;
            }
            case 4: {
                return l2 >= l3;
            }
            case 6: {
                return l2 > l3;
            }
            case 5: {
                if (l2 == l3) {
                    return true;
                }
            }
            case 7: {
                if (l2 >= 0L && l3 >= 0L) {
                    return l2 > l3;
                }
                if (l2 < 0L && l3 < 0L) {
                    return l2 < l3;
                }
                return l2 < 0L && l3 >= 0L;
            }
            case 8: {
                return l2 == l3;
            }
            case 9: {
                return l2 != l3;
            }
        }
        throw new IOException("Bad compare type " + n);
    }

    public final boolean floatCompareCore(long l, double d, double d2, int n) throws IOException {
        switch (n) {
            case 0: {
                return d < d2;
            }
            case 2: {
                return d <= d2;
            }
            case 4: {
                return d >= d2;
            }
            case 6: {
                return d > d2;
            }
            case 8: {
                return d == d2;
            }
            case 9: {
                return d != d2;
            }
        }
        throw new IOException("Bad compare type " + n);
    }

    public final boolean byteCompare(PhysicalAddressSpace physicalAddressSpace, int n, byte[] byArray, byte[] byArray2, int n2, int n3) throws IOException {
        byte[] byArray3 = new byte[4096];
        physicalAddressSpace.readRAMPage(n, byArray3);
        int n4 = byArray[n2] & 0xFF;
        int n5 = byArray3[n2] & 0xFF;
        if (n4 > 127) {
            n4 -= 256;
        }
        if (n5 > 127) {
            n5 -= 256;
        }
        return this.compareCore(n * 4096 + n2, n5, n4, n3);
    }

    public final boolean leWordCompare(PhysicalAddressSpace physicalAddressSpace, int n, byte[] byArray, byte[] byArray2, int n2, int n3) throws IOException {
        byte[] byArray3 = new byte[4096];
        byte[] byArray4 = new byte[4096];
        physicalAddressSpace.readRAMPage(n, byArray3);
        physicalAddressSpace.readRAMPage(n + 1, byArray4);
        int n4 = n2 % 4096;
        int n5 = (n2 + 1) % 4096;
        if (n5 < 1 && byArray2 == null) {
            return false;
        }
        int n6 = byArray[n4] & 0xFF;
        int n7 = byArray3[n4] & 0xFF;
        int n8 = (n5 < 1 ? byArray2[n5] : byArray[n5]) & 0xFF;
        int n9 = (n5 < 1 ? byArray4[n5] : byArray3[n5]) & 0xFF;
        int n10 = n8 << 8 | n6;
        int n11 = n9 << 8 | n7;
        if (n10 > Short.MAX_VALUE) {
            n10 -= 65536;
        }
        if (n11 > Short.MAX_VALUE) {
            n11 -= 65536;
        }
        return this.compareCore(n * 4096 + n2, n11, n10, n3);
    }

    public final boolean leDwordCompare(PhysicalAddressSpace physicalAddressSpace, int n, byte[] byArray, byte[] byArray2, int n2, int n3) throws IOException {
        byte[] byArray3 = new byte[4096];
        byte[] byArray4 = new byte[4096];
        physicalAddressSpace.readRAMPage(n, byArray3);
        physicalAddressSpace.readRAMPage(n + 1, byArray4);
        int n4 = n2 % 4096;
        int n5 = (n2 + 1) % 4096;
        int n6 = (n2 + 2) % 4096;
        int n7 = (n2 + 3) % 4096;
        if (n7 < 3 && byArray2 == null) {
            return false;
        }
        int n8 = byArray[n4] & 0xFF;
        int n9 = byArray3[n4] & 0xFF;
        int n10 = (n5 < 1 ? byArray2[n5] : byArray[n5]) & 0xFF;
        int n11 = (n5 < 1 ? byArray4[n5] : byArray3[n5]) & 0xFF;
        int n12 = (n6 < 2 ? byArray2[n6] : byArray[n6]) & 0xFF;
        int n13 = (n6 < 2 ? byArray4[n6] : byArray3[n6]) & 0xFF;
        int n14 = (n7 < 3 ? byArray2[n7] : byArray[n7]) & 0xFF;
        int n15 = (n7 < 3 ? byArray4[n7] : byArray3[n7]) & 0xFF;
        int n16 = n14 << 24 | n12 << 16 | n10 << 8 | n8;
        int n17 = n15 << 24 | n13 << 16 | n11 << 8 | n9;
        if (n16 > Integer.MAX_VALUE) {
            n16 = (int)((long)n16 - 0x100000000L);
        }
        if (n17 > Integer.MAX_VALUE) {
            n17 = (int)((long)n17 - 0x100000000L);
        }
        return this.compareCore(n * 4096 + n2, n17, n16, n3);
    }

    public final boolean leQwordCompare(PhysicalAddressSpace physicalAddressSpace, int n, byte[] byArray, byte[] byArray2, int n2, int n3) throws IOException {
        byte[] byArray3 = new byte[4096];
        byte[] byArray4 = new byte[4096];
        physicalAddressSpace.readRAMPage(n, byArray3);
        physicalAddressSpace.readRAMPage(n + 1, byArray4);
        int n4 = n2 % 4096;
        int n5 = (n2 + 1) % 4096;
        int n6 = (n2 + 2) % 4096;
        int n7 = (n2 + 3) % 4096;
        int n8 = (n2 + 4) % 4096;
        int n9 = (n2 + 5) % 4096;
        int n10 = (n2 + 6) % 4096;
        int n11 = (n2 + 7) % 4096;
        if (n11 < 7 && byArray2 == null) {
            return false;
        }
        int n12 = byArray[n4] & 0xFF;
        int n13 = byArray3[n4] & 0xFF;
        int n14 = (n5 < 1 ? byArray2[n5] : byArray[n5]) & 0xFF;
        int n15 = (n5 < 1 ? byArray4[n5] : byArray3[n5]) & 0xFF;
        int n16 = (n6 < 2 ? byArray2[n6] : byArray[n6]) & 0xFF;
        int n17 = (n6 < 2 ? byArray4[n6] : byArray3[n6]) & 0xFF;
        int n18 = (n7 < 3 ? byArray2[n7] : byArray[n7]) & 0xFF;
        int n19 = (n7 < 3 ? byArray4[n7] : byArray3[n7]) & 0xFF;
        int n20 = (n8 < 4 ? byArray2[n8] : byArray[n8]) & 0xFF;
        int n21 = (n8 < 4 ? byArray4[n8] : byArray3[n8]) & 0xFF;
        int n22 = (n9 < 5 ? byArray2[n9] : byArray[n9]) & 0xFF;
        int n23 = (n9 < 5 ? byArray4[n9] : byArray3[n9]) & 0xFF;
        int n24 = (n10 < 6 ? byArray2[n10] : byArray[n10]) & 0xFF;
        int n25 = (n10 < 6 ? byArray4[n10] : byArray3[n10]) & 0xFF;
        int n26 = (n11 < 7 ? byArray2[n11] : byArray[n11]) & 0xFF;
        int n27 = (n11 < 7 ? byArray4[n11] : byArray3[n11]) & 0xFF;
        long l = (long)n26 << 56 | (long)n24 << 48 | (long)n22 << 40 | (long)n20 << 32 | (long)n18 << 24 | (long)n16 << 16 | (long)n14 << 8 | (long)n12;
        long l2 = (long)n27 << 56 | (long)n25 << 48 | (long)n23 << 40 | (long)n21 << 32 | (long)n19 << 24 | (long)n17 << 16 | (long)n15 << 8 | (long)n13;
        return this.compareCore(n * 4096 + n2, l2, l, n3);
    }

    public final boolean floatCompare(PhysicalAddressSpace physicalAddressSpace, int n, byte[] byArray, byte[] byArray2, int n2, int n3) throws IOException {
        byte[] byArray3 = new byte[4096];
        byte[] byArray4 = new byte[4096];
        physicalAddressSpace.readRAMPage(n, byArray3);
        physicalAddressSpace.readRAMPage(n + 1, byArray4);
        int n4 = n2 % 4096;
        int n5 = (n2 + 1) % 4096;
        int n6 = (n2 + 2) % 4096;
        int n7 = (n2 + 3) % 4096;
        if (n7 < 3 && byArray2 == null) {
            return false;
        }
        int n8 = byArray[n4] & 0xFF;
        int n9 = byArray3[n4] & 0xFF;
        int n10 = (n5 < 1 ? byArray2[n5] : byArray[n5]) & 0xFF;
        int n11 = (n5 < 1 ? byArray4[n5] : byArray3[n5]) & 0xFF;
        int n12 = (n6 < 2 ? byArray2[n6] : byArray[n6]) & 0xFF;
        int n13 = (n6 < 2 ? byArray4[n6] : byArray3[n6]) & 0xFF;
        int n14 = (n7 < 3 ? byArray2[n7] : byArray[n7]) & 0xFF;
        int n15 = (n7 < 3 ? byArray4[n7] : byArray3[n7]) & 0xFF;
        int n16 = n14 << 24 | n12 << 16 | n10 << 8 | n8;
        int n17 = n15 << 24 | n13 << 16 | n11 << 8 | n9;
        return this.floatCompareCore(n * 4096 + n2, Float.intBitsToFloat(n17), Float.intBitsToFloat(n16), n3);
    }

    public final boolean doubleCompare(PhysicalAddressSpace physicalAddressSpace, int n, byte[] byArray, byte[] byArray2, int n2, int n3) throws IOException {
        byte[] byArray3 = new byte[4096];
        byte[] byArray4 = new byte[4096];
        physicalAddressSpace.readRAMPage(n, byArray3);
        physicalAddressSpace.readRAMPage(n + 1, byArray4);
        int n4 = n2 % 4096;
        int n5 = (n2 + 1) % 4096;
        int n6 = (n2 + 2) % 4096;
        int n7 = (n2 + 3) % 4096;
        int n8 = (n2 + 4) % 4096;
        int n9 = (n2 + 5) % 4096;
        int n10 = (n2 + 6) % 4096;
        int n11 = (n2 + 7) % 4096;
        if (n11 < 7 && byArray2 == null) {
            return false;
        }
        int n12 = byArray[n4] & 0xFF;
        int n13 = byArray3[n4] & 0xFF;
        int n14 = (n5 < 1 ? byArray2[n5] : byArray[n5]) & 0xFF;
        int n15 = (n5 < 1 ? byArray4[n5] : byArray3[n5]) & 0xFF;
        int n16 = (n6 < 2 ? byArray2[n6] : byArray[n6]) & 0xFF;
        int n17 = (n6 < 2 ? byArray4[n6] : byArray3[n6]) & 0xFF;
        int n18 = (n7 < 3 ? byArray2[n7] : byArray[n7]) & 0xFF;
        int n19 = (n7 < 3 ? byArray4[n7] : byArray3[n7]) & 0xFF;
        int n20 = (n8 < 4 ? byArray2[n8] : byArray[n8]) & 0xFF;
        int n21 = (n8 < 4 ? byArray4[n8] : byArray3[n8]) & 0xFF;
        int n22 = (n9 < 5 ? byArray2[n9] : byArray[n9]) & 0xFF;
        int n23 = (n9 < 5 ? byArray4[n9] : byArray3[n9]) & 0xFF;
        int n24 = (n10 < 6 ? byArray2[n10] : byArray[n10]) & 0xFF;
        int n25 = (n10 < 6 ? byArray4[n10] : byArray3[n10]) & 0xFF;
        int n26 = (n11 < 7 ? byArray2[n11] : byArray[n11]) & 0xFF;
        int n27 = (n11 < 7 ? byArray4[n11] : byArray3[n11]) & 0xFF;
        long l = (long)n26 << 56 | (long)n24 << 48 | (long)n22 << 40 | (long)n20 << 32 | (long)n18 << 24 | (long)n16 << 16 | (long)n14 << 8 | (long)n12;
        long l2 = (long)n27 << 56 | (long)n25 << 48 | (long)n23 << 40 | (long)n21 << 32 | (long)n19 << 24 | (long)n17 << 16 | (long)n15 << 8 | (long)n13;
        return this.floatCompareCore(n * 4096 + n2, Double.longBitsToDouble(l2), Double.longBitsToDouble(l), n3);
    }

    public final boolean longDoubleCompare(PhysicalAddressSpace physicalAddressSpace, int n, byte[] byArray, byte[] byArray2, int n2, int n3) throws IOException {
        byte[] byArray3 = new byte[4096];
        byte[] byArray4 = new byte[4096];
        byte[] byArray5 = new byte[10];
        byte[] byArray6 = new byte[10];
        physicalAddressSpace.readRAMPage(n, byArray3);
        physicalAddressSpace.readRAMPage(n + 1, byArray4);
        if (n2 > 4086 && byArray2 == null) {
            return false;
        }
        for (int i = 0; i < 10; ++i) {
            byArray5[i] = n2 + i > 4095 ? byArray2[(n2 + i) % 4096] : byArray[n2 + i];
            byArray6[i] = n2 + i > 4095 ? byArray4[(n2 + i) % 4096] : byArray3[n2 + i];
        }
        return this.floatCompareCore(n * 4096 + n2, FpuState64.extendedToDouble(byArray6), FpuState64.extendedToDouble(byArray5), n3);
    }

    private int fastpathProcessPage(PhysicalAddressSpace physicalAddressSpace, int n, byte[] byArray, int n2, int n3) throws IOException {
        if (!MemorySearch.canFastpath(n2)) {
            return 0;
        }
        byte[] byArray2 = new byte[4096];
        physicalAddressSpace.readRAMPage(n, byArray2);
        int n4 = 4096;
        int n5 = MemorySearch.typeSize(n3);
        for (int i = 0; i < n4; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            if (i >= n5) {
                return i - n5 + 1;
            }
            return 0;
        }
        return n4 - n5;
    }

    public int doUpdate(PhysicalAddressSpace physicalAddressSpace, int n) throws IOException {
        int n2 = n & 0x43;
        int n3 = (n & 0xFFFFFFFC) >>> 2;
        for (Map.Entry<Integer, byte[]> entry : this.currentPages.entrySet()) {
            int n4;
            byte[] byArray = this.currentPages.get(entry.getKey() + 1);
            int n5 = 0;
            Integer n6 = entry.getKey();
            if (this.currentPageCandidates.get(n6) == 0) continue;
            byte[] byArray2 = entry.getValue();
            int n7 = this.fastpathProcessPage(physicalAddressSpace, n6, byArray2, n3, n2);
            for (n4 = 0; n4 < n7; ++n4) {
                if ((byArray2[4096 + n4 / 8] & 1 << n4 % 8) == 0) continue;
                ++n5;
                int n8 = 4096 + n4 / 8;
                byArray2[n8] = (byte)(byArray2[n8] & ~(1 << n4 % 8));
            }
            for (n4 = n7; n4 < 4096; ++n4) {
                if ((byArray2[4096 + n4 / 8] >> n4 % 8 & 1) == 0) continue;
                boolean bl = true;
                switch (n2) {
                    case 0: {
                        bl = this.byteCompare(physicalAddressSpace, n6, byArray2, byArray, n4, n3);
                        break;
                    }
                    case 1: {
                        bl = this.leWordCompare(physicalAddressSpace, n6, byArray2, byArray, n4, n3);
                        break;
                    }
                    case 2: {
                        bl = this.leDwordCompare(physicalAddressSpace, n6, byArray2, byArray, n4, n3);
                        break;
                    }
                    case 3: {
                        bl = this.leQwordCompare(physicalAddressSpace, n6, byArray2, byArray, n4, n3);
                        break;
                    }
                    case 64: {
                        bl = this.floatCompare(physicalAddressSpace, n6, byArray2, byArray, n4, n3);
                        break;
                    }
                    case 65: {
                        bl = this.doubleCompare(physicalAddressSpace, n6, byArray2, byArray, n4, n3);
                        break;
                    }
                    case 66: {
                        bl = this.longDoubleCompare(physicalAddressSpace, n6, byArray2, byArray, n4, n3);
                        break;
                    }
                    default: {
                        throw new IOException("Bad access type " + n2);
                    }
                }
                if (bl) continue;
                ++n5;
                int n9 = 4096 + n4 / 8;
                byArray2[n9] = (byte)(byArray2[n9] & ~(1 << n4 % 8));
            }
            this.currentPageCandidates.put(n6, this.currentPageCandidates.get(n6) - n5);
            this.candidates -= (long)n5;
            physicalAddressSpace.readRAMPage(entry.getKey(), entry.getValue());
        }
        return (int)this.candidates;
    }

    private static String doFormat(long l, int n, boolean bl) {
        if (n == 8) {
            int n2 = (int)l;
            return String.format("%g", Float.valueOf(Float.intBitsToFloat(n2)));
        }
        if (n == 9) {
            return String.format("%g", Double.longBitsToDouble(l));
        }
        if (bl && (n == 0 || n == 4)) {
            return String.format("%02x", l & 0xFFL);
        }
        if (bl && (n == 1 || n == 5)) {
            return String.format("%04x", l & 0xFFFFL);
        }
        if (bl && (n == 2 || n == 6)) {
            return String.format("%08x", l & 0xFFFFFFFFL);
        }
        if (bl && (n == 3 || n == 7)) {
            String string = String.format("%08x", l >>> 32);
            String string2 = String.format("%08x", l & 0xFFFFFFFFL);
            return string + string2;
        }
        if (n == 0) {
            return String.format("%d", l & 0xFFL);
        }
        if (n == 1) {
            return String.format("%d", l & 0xFFFFL);
        }
        if (n == 2) {
            return String.format("%d", l & 0xFFFFFFFFL);
        }
        if (n == 3) {
            return String.format("%d", l);
        }
        if (n == 4 || n == 5 || n == 6 || n == 7) {
            return String.format("%d", l);
        }
        return "N/A";
    }

    private static String doFormatLongDouble(PhysicalAddressSpace physicalAddressSpace, long l) {
        byte[] byArray = new byte[4096];
        byte[] byArray2 = new byte[4096];
        byte[] byArray3 = new byte[10];
        int n = (int)(l >> 12);
        int n2 = (int)(l & 0xFFFL);
        physicalAddressSpace.readRAMPage(n, byArray);
        physicalAddressSpace.readRAMPage(n + 1, byArray2);
        for (int i = 0; i < 10; ++i) {
            byArray3[i] = n2 + i > 4095 ? byArray2[(n2 + i) % 4096] : byArray[n2 + i];
        }
        return String.format("%g", FpuState64.extendedToDouble(byArray3));
    }

    private static long readNumber(PhysicalAddressSpace physicalAddressSpace, long l, int n) {
        byte[] byArray = new byte[8192];
        physicalAddressSpace.readRAMPage((int)(l >> 12), byArray, 0);
        physicalAddressSpace.readRAMPage((int)(l >> 12) + 1, byArray, 4096);
        int n2 = (int)(l & 0xFFFL);
        if (n == 0 || n == 4) {
            return (long)byArray[n2] & 0xFFL;
        }
        if (n == 1 || n == 5) {
            return ((long)byArray[n2 + 1] & 0xFFL) << 8 | (long)byArray[n2 + 0] & 0xFFL;
        }
        if (n == 2 || n == 6 || n == 8) {
            return ((long)byArray[n2 + 3] & 0xFFL) << 24 | ((long)byArray[n2 + 2] & 0xFFL) << 16 | ((long)byArray[n2 + 1] & 0xFFL) << 8 | (long)byArray[n2 + 0] & 0xFFL;
        }
        if (n == 3 || n == 7 || n == 9) {
            return ((long)byArray[n2 + 7] & 0xFFL) << 56 | ((long)byArray[n2 + 6] & 0xFFL) << 48 | ((long)byArray[n2 + 5] & 0xFFL) << 40 | ((long)byArray[n2 + 4] & 0xFFL) << 32 | ((long)byArray[n2 + 3] & 0xFFL) << 24 | ((long)byArray[n2 + 2] & 0xFFL) << 16 | ((long)byArray[n2 + 1] & 0xFFL) << 8 | (long)byArray[n2 + 0] & 0xFFL;
        }
        return 0L;
    }

    public static int luaCB_format(Lua lua, LuaPlugin luaPlugin) {
        PhysicalAddressSpace physicalAddressSpace;
        lua.pushNil();
        lua.pushNil();
        lua.pushNil();
        long l = (long)((int)lua.checkNumber(1)) & 0xFFFFFFFFFFFFFFFFL;
        int n = (int)lua.checkNumber(2);
        Object object = lua.value(3);
        boolean bl = lua.toBoolean(object);
        if (!Lua.isBoolean(object)) {
            lua.error("Expected boolean as 3rd parameter of MemorySearch.Format");
        }
        if ((physicalAddressSpace = (PhysicalAddressSpace)luaPlugin.getComponent(PhysicalAddressSpace.class)) == null) {
            lua.pushString("N/A");
            return 1;
        }
        if (n != 10) {
            long l2 = MemorySearch.readNumber(physicalAddressSpace, l, n);
            lua.pushString(MemorySearch.doFormat(l2, n, bl));
        } else {
            lua.pushString(MemorySearch.doFormatLongDouble(physicalAddressSpace, l));
        }
        return 1;
    }

    public int luaCB_update(Lua lua, LuaPlugin luaPlugin) {
        lua.pushNil();
        int n = (int)lua.checkNumber(2);
        try {
            PhysicalAddressSpace physicalAddressSpace = (PhysicalAddressSpace)luaPlugin.getComponent(PhysicalAddressSpace.class);
            if (physicalAddressSpace == null) {
                this.currentPages.clear();
                this.candidates = 0L;
                lua.pushNumber(0.0);
            } else {
                lua.pushNumber(this.doUpdate(physicalAddressSpace, n));
            }
        }
        catch (IOException iOException) {
            lua.pushBoolean(false);
            lua.pushString("IOException: " + iOException.getMessage());
            return 2;
        }
        return 1;
    }

    public int luaCB_candidate_count(Lua lua, LuaPlugin luaPlugin) {
        lua.pushNumber(this.candidates);
        return 1;
    }

    public int luaCB_next_candidate(Lua lua, LuaPlugin luaPlugin) {
        lua.pushNil();
        int n = (int)lua.checkNumber(2);
        while (true) {
            int n2;
            if ((n2 = n >> 12) >= this.firstBadPage) {
                n = -1;
                break;
            }
            if (!this.currentPageCandidates.containsKey(n2) || this.currentPageCandidates.get(n2) == 0) {
                n = (n >> 12) + 1 << 12;
                continue;
            }
            int n3 = n % 4096 / 8;
            byte[] byArray = this.currentPages.get(n2);
            if (byArray[4096 + n3] == 0) {
                n = (n >> 3) + 1 << 3;
                continue;
            }
            if ((byArray[4096 + n3] >> n % 8 & 1) != 0) break;
            ++n;
        }
        lua.pushNumber(n);
        return 1;
    }

    public int luaCB_destroy(Lua lua, LuaPlugin luaPlugin) {
        try {
            luaPlugin.destroyLuaObject(lua);
            lua.pushBoolean(true);
        }
        catch (IOException iOException) {
            lua.pushBoolean(false);
            lua.pushString("IOException: " + iOException.getMessage());
            return 2;
        }
        return 1;
    }

    public static int luaCB_create(Lua lua, LuaPlugin luaPlugin) {
        try {
            luaPlugin.generateLuaClass(lua, new MemorySearch(luaPlugin));
        }
        catch (IOException iOException) {
            lua.pushNil();
            lua.pushString("IOException: " + iOException.getMessage());
            return 2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            lua.pushNil();
            lua.pushString("Illegal argument: " + illegalArgumentException.getMessage());
            return 2;
        }
        return 1;
    }
}

