/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.luaextensions;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import mnj.lua.Lua;
import mnj.lua.LuaTable;
import org.jpc.plugins.LuaPlugin;

public class Window
extends LuaPlugin.LuaResource
implements ActionListener {
    private JFrame window;
    private Map<String, JComponent> components;
    private LuaPlugin plug;

    Window(LuaPlugin luaPlugin, String string) throws IOException {
        super(luaPlugin);
        this.window = new JFrame(string);
        this.window.setDefaultCloseOperation(0);
        this.window.setLayout(new GridBagLayout());
        this.window.setVisible(false);
        this.components = new HashMap<String, JComponent>();
    }

    @Override
    public void destroy() throws IOException {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Window.this.window.dispose();
                Window.this.window = null;
                Window.this.components = null;
            }
        });
    }

    private int doPush(Lua lua, int n) {
        lua.push(new Double(n));
        return 1;
    }

    public int luaCB_ABOVE_BASELINE(Lua lua, LuaPlugin luaPlugin) {
        return this.doPush(lua, 1024);
    }

    public int luaCB_ABOVE_BASELINE_LEADING(Lua lua, LuaPlugin luaPlugin) {
        return this.doPush(lua, 1280);
    }

    public int luaCB_ABOVE_BASELINE_TRAILING(Lua lua, LuaPlugin luaPlugin) {
        return this.doPush(lua, 1536);
    }

    public int luaCB_BASELINE(Lua lua, LuaPlugin luaPlugin) {
        return this.doPush(lua, 256);
    }

    public int luaCB_BASELINE_LEADING(Lua lua, LuaPlugin luaPlugin) {
        return this.doPush(lua, 512);
    }

    public int luaCB_BASELINE_TRAILING(Lua lua, LuaPlugin luaPlugin) {
        return this.doPush(lua, 768);
    }

    public int luaCB_BELOW_BASELINE(Lua lua, LuaPlugin luaPlugin) {
        return this.doPush(lua, 1792);
    }

    public int luaCB_BELOW_BASELINE_LEADING(Lua lua, LuaPlugin luaPlugin) {
        return this.doPush(lua, 2048);
    }

    public int luaCB_BELOW_BASELINE_TRAILING(Lua lua, LuaPlugin luaPlugin) {
        return this.doPush(lua, 2304);
    }

    public int luaCB_BOTH(Lua lua, LuaPlugin luaPlugin) {
        return this.doPush(lua, 1);
    }

    public int luaCB_CENTER(Lua lua, LuaPlugin luaPlugin) {
        return this.doPush(lua, 10);
    }

    public int luaCB_EAST(Lua lua, LuaPlugin luaPlugin) {
        return this.doPush(lua, 13);
    }

    public int luaCB_FIRST_LINE_END(Lua lua, LuaPlugin luaPlugin) {
        return this.doPush(lua, 24);
    }

    public int luaCB_FIRST_LINE_START(Lua lua, LuaPlugin luaPlugin) {
        return this.doPush(lua, 23);
    }

    public int luaCB_HORIZONTAL(Lua lua, LuaPlugin luaPlugin) {
        return this.doPush(lua, 2);
    }

    public int luaCB_LAST_LINE_END(Lua lua, LuaPlugin luaPlugin) {
        return this.doPush(lua, 26);
    }

    public int luaCB_LAST_LINE_START(Lua lua, LuaPlugin luaPlugin) {
        return this.doPush(lua, 25);
    }

    public int luaCB_LINE_END(Lua lua, LuaPlugin luaPlugin) {
        return this.doPush(lua, 22);
    }

    public int luaCB_LINE_START(Lua lua, LuaPlugin luaPlugin) {
        return this.doPush(lua, 21);
    }

    public int luaCB_NONE(Lua lua, LuaPlugin luaPlugin) {
        return this.doPush(lua, 0);
    }

    public int luaCB_NORTH(Lua lua, LuaPlugin luaPlugin) {
        return this.doPush(lua, 11);
    }

    public int luaCB_NORTHEAST(Lua lua, LuaPlugin luaPlugin) {
        return this.doPush(lua, 12);
    }

    public int luaCB_NORTHWEST(Lua lua, LuaPlugin luaPlugin) {
        return this.doPush(lua, 18);
    }

    public int luaCB_PAGE_END(Lua lua, LuaPlugin luaPlugin) {
        return this.doPush(lua, 20);
    }

    public int luaCB_PAGE_START(Lua lua, LuaPlugin luaPlugin) {
        return this.doPush(lua, 19);
    }

    public int luaCB_RELATIVE(Lua lua, LuaPlugin luaPlugin) {
        return this.doPush(lua, -1);
    }

    public int luaCB_REMAINDER(Lua lua, LuaPlugin luaPlugin) {
        return this.doPush(lua, 0);
    }

    public int luaCB_SOUTH(Lua lua, LuaPlugin luaPlugin) {
        return this.doPush(lua, 15);
    }

    public int luaCB_SOUTHEAST(Lua lua, LuaPlugin luaPlugin) {
        return this.doPush(lua, 14);
    }

    public int luaCB_SOUTHWEST(Lua lua, LuaPlugin luaPlugin) {
        return this.doPush(lua, 16);
    }

    public int luaCB_VERTICAL(Lua lua, LuaPlugin luaPlugin) {
        return this.doPush(lua, 3);
    }

    public int luaCB_WEST(Lua lua, LuaPlugin luaPlugin) {
        return this.doPush(lua, 17);
    }

    private Integer extractIntParameter(Lua lua, LuaTable luaTable, String string) {
        Object object = Lua.rawGet(luaTable, string);
        if (object == null || !(object instanceof Double)) {
            return null;
        }
        Double d = (Double)object;
        return new Integer((int)d.doubleValue());
    }

    private Double extractDoubleParameter(Lua lua, LuaTable luaTable, String string) {
        Object object = Lua.rawGet(luaTable, string);
        if (object == null || !(object instanceof Double)) {
            return null;
        }
        return (Double)object;
    }

    private String extractStringParameter(Lua lua, LuaTable luaTable, String string) {
        Object object = Lua.rawGet(luaTable, string);
        if (object == null || !(object instanceof String)) {
            return null;
        }
        return (String)object;
    }

    private GridBagConstraints parseConstraints(Lua lua, LuaTable luaTable) {
        Integer n;
        Integer n2;
        Integer n3;
        Integer n4;
        Double d;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Integer n5 = this.extractIntParameter(lua, luaTable, "anchor");
        if (n5 != null) {
            gridBagConstraints.anchor = n5;
        }
        if ((n5 = this.extractIntParameter(lua, luaTable, "fill")) != null) {
            gridBagConstraints.fill = n5;
        }
        if ((n5 = this.extractIntParameter(lua, luaTable, "gridheight")) != null) {
            gridBagConstraints.gridheight = n5;
        }
        if ((n5 = this.extractIntParameter(lua, luaTable, "gridwidth")) != null) {
            gridBagConstraints.gridwidth = n5;
        }
        if ((n5 = this.extractIntParameter(lua, luaTable, "gridx")) != null) {
            gridBagConstraints.gridx = n5;
        }
        if ((n5 = this.extractIntParameter(lua, luaTable, "gridy")) != null) {
            gridBagConstraints.gridy = n5;
        }
        if ((n5 = this.extractIntParameter(lua, luaTable, "ipadx")) != null) {
            gridBagConstraints.ipadx = n5;
        }
        if ((n5 = this.extractIntParameter(lua, luaTable, "ipady")) != null) {
            gridBagConstraints.ipady = n5;
        }
        if ((d = this.extractDoubleParameter(lua, luaTable, "weightx")) != null) {
            gridBagConstraints.weightx = d;
        }
        if ((d = this.extractDoubleParameter(lua, luaTable, "weighty")) != null) {
            gridBagConstraints.weighty = d;
        }
        if ((n4 = this.extractIntParameter(lua, luaTable, "insets_left")) == null) {
            n4 = new Integer(0);
        }
        if ((n3 = this.extractIntParameter(lua, luaTable, "insets_right")) == null) {
            n3 = new Integer(0);
        }
        if ((n2 = this.extractIntParameter(lua, luaTable, "insets_up")) == null) {
            n2 = new Integer(0);
        }
        if ((n = this.extractIntParameter(lua, luaTable, "insets_down")) == null) {
            n = new Integer(0);
        }
        gridBagConstraints.insets = new Insets(n2, n4, n, n3);
        return gridBagConstraints;
    }

    public int luaCB_create_component(Lua lua, LuaPlugin luaPlugin) {
        Serializable serializable;
        Serializable serializable2;
        lua.pushNil();
        Object object = lua.value(2);
        if (!(object instanceof LuaTable)) {
            lua.pushBoolean(false);
            return 1;
        }
        LuaTable luaTable = (LuaTable)object;
        GridBagConstraints gridBagConstraints = this.parseConstraints(lua, luaTable);
        String string = this.extractStringParameter(lua, luaTable, "type");
        String string2 = this.extractStringParameter(lua, luaTable, "text");
        String string3 = this.extractStringParameter(lua, luaTable, "name");
        if (this.components.get(string3) != null) {
            this.components.remove(string3);
        }
        Serializable serializable3 = null;
        if (string == "button") {
            serializable2 = new JButton(string2);
            ((AbstractButton)serializable2).setActionCommand(string3);
            ((AbstractButton)serializable2).addActionListener(this);
            serializable3 = serializable2;
        } else if (string == "label") {
            serializable2 = new JLabel(string2);
            serializable3 = serializable2;
        } else if (string == "textfield") {
            serializable2 = this.extractIntParameter(lua, luaTable, "columns");
            serializable = serializable2 == null ? new JTextField(string2) : new JTextField(string2, (Integer)serializable2);
            ((JTextField)serializable).setActionCommand(string3);
            ((JTextField)serializable).addActionListener(this);
            serializable3 = serializable;
        } else if (string == "checkbox") {
            serializable2 = new JCheckBox(string2);
            ((AbstractButton)serializable2).setActionCommand(string3);
            ((AbstractButton)serializable2).addActionListener(this);
            serializable3 = serializable2;
        }
        if (serializable3 != null) {
            this.components.put(string3, (JComponent)serializable3);
            lua.pushBoolean(true);
        } else {
            lua.pushBoolean(false);
        }
        serializable2 = serializable3;
        serializable = gridBagConstraints;
        SwingUtilities.invokeLater(new Runnable((JComponent)serializable2, (GridBagConstraints)serializable){
            final /* synthetic */ JComponent val$newComponent2;
            final /* synthetic */ GridBagConstraints val$placement2;
            {
                this.val$newComponent2 = jComponent;
                this.val$placement2 = gridBagConstraints;
            }

            @Override
            public void run() {
                Window.this.window.add((Component)this.val$newComponent2, this.val$placement2);
                Window.this.window.pack();
            }
        });
        return 1;
    }

    public int luaCB_set_text(Lua lua, LuaPlugin luaPlugin) {
        lua.pushNil();
        lua.pushNil();
        String string = lua.checkString(2);
        final String string2 = lua.checkString(3);
        final JComponent jComponent = this.components.get(string);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (jComponent != null) {
                    if (jComponent instanceof JButton) {
                        ((JButton)jComponent).setText(string2);
                    } else if (jComponent instanceof JCheckBox) {
                        ((JCheckBox)jComponent).setText(string2);
                    } else if (jComponent instanceof JLabel) {
                        ((JLabel)jComponent).setText(string2);
                    } else if (jComponent instanceof JTextField) {
                        ((JTextField)jComponent).setText(string2);
                    }
                }
            }
        });
        return 0;
    }

    public int luaCB_set_color(Lua lua, LuaPlugin luaPlugin) {
        lua.pushNil();
        lua.pushNil();
        lua.pushNil();
        lua.pushNil();
        String string = lua.checkString(2);
        final int n = (int)lua.checkNumber(3);
        final int n2 = (int)lua.checkNumber(4);
        final int n3 = (int)lua.checkNumber(5);
        final JComponent jComponent = this.components.get(string);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (jComponent != null) {
                    jComponent.setForeground(new Color(n, n2, n3));
                }
            }
        });
        return 0;
    }

    public int luaCB_get_text(Lua lua, LuaPlugin luaPlugin) {
        lua.pushNil();
        String string = lua.checkString(2);
        JComponent jComponent = this.components.get(string);
        if (jComponent != null) {
            if (jComponent instanceof JButton) {
                lua.push(((JButton)jComponent).getText());
            } else if (jComponent instanceof JCheckBox) {
                lua.push(((JCheckBox)jComponent).getText());
            } else if (jComponent instanceof JLabel) {
                lua.push(((JLabel)jComponent).getText());
            } else if (jComponent instanceof JTextField) {
                lua.push(((JTextField)jComponent).getText());
            }
        }
        return 1;
    }

    public int luaCB_destroy_component(Lua lua, LuaPlugin luaPlugin) {
        lua.pushNil();
        String string = lua.checkString(2);
        final JComponent jComponent = this.components.get(string);
        if (jComponent != null) {
            this.window.remove(jComponent);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Window.this.components.remove(jComponent);
                }
            });
            lua.pushBoolean(true);
        } else {
            lua.pushBoolean(false);
        }
        return 1;
    }

    public int luaCB_disable(Lua lua, LuaPlugin luaPlugin) {
        lua.pushNil();
        String string = lua.checkString(2);
        final JComponent jComponent = this.components.get(string);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                jComponent.setEnabled(false);
            }
        });
        return 0;
    }

    public int luaCB_enable(Lua lua, LuaPlugin luaPlugin) {
        lua.pushNil();
        String string = lua.checkString(2);
        final JComponent jComponent = this.components.get(string);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                jComponent.setEnabled(true);
            }
        });
        return 0;
    }

    public int luaCB_selected(Lua lua, LuaPlugin luaPlugin) {
        lua.pushNil();
        String string = lua.checkString(2);
        JComponent jComponent = this.components.get(string);
        if (jComponent instanceof JCheckBox) {
            lua.pushBoolean(((JCheckBox)jComponent).isSelected());
        } else {
            lua.pushBoolean(false);
        }
        return 1;
    }

    public int luaCB_unselect(Lua lua, LuaPlugin luaPlugin) {
        lua.pushNil();
        String string = lua.checkString(2);
        final JComponent jComponent = this.components.get(string);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (jComponent instanceof JCheckBox) {
                    ((JCheckBox)jComponent).setSelected(false);
                }
            }
        });
        return 0;
    }

    public int luaCB_select(Lua lua, LuaPlugin luaPlugin) {
        lua.pushNil();
        String string = lua.checkString(2);
        final JComponent jComponent = this.components.get(string);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (jComponent instanceof JCheckBox) {
                    ((JCheckBox)jComponent).setSelected(true);
                }
            }
        });
        return 0;
    }

    public int luaCB_show(Lua lua, LuaPlugin luaPlugin) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Window.this.window.setVisible(true);
            }
        });
        return 0;
    }

    public int luaCB_hide(Lua lua, LuaPlugin luaPlugin) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Window.this.window.setVisible(false);
            }
        });
        return 0;
    }

    public int luaCB_close(Lua lua, LuaPlugin luaPlugin) {
        try {
            luaPlugin.destroyLuaObject(lua);
            lua.pushBoolean(true);
        }
        catch (IOException iOException) {
            lua.pushBoolean(false);
            lua.pushString("IOException: " + iOException.getMessage());
            return 2;
        }
        return 1;
    }

    public static int luaCB_create(Lua lua, LuaPlugin luaPlugin) {
        lua.pushNil();
        String string = lua.checkString(1);
        try {
            Window window = new Window(luaPlugin, string);
            luaPlugin.generateLuaClass(lua, window);
            window.plug = luaPlugin;
        }
        catch (IOException iOException) {
            lua.pushNil();
            lua.pushString("IOException: " + iOException.getMessage());
            return 2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            lua.pushNil();
            lua.pushString("Illegal argument: " + illegalArgumentException.getMessage());
            return 2;
        }
        return 1;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        this.plug.queueEvent("uiaction", string);
    }
}

