/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.plugins;

import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import org.jpc.Misc;
import org.jpc.diskimages.BlockDevice;
import org.jpc.diskimages.DiskImage;
import org.jpc.diskimages.DiskImageSet;
import org.jpc.emulator.Clock;
import org.jpc.emulator.DisplayController;
import org.jpc.emulator.DriveSet;
import org.jpc.emulator.EventRecorder;
import org.jpc.emulator.HardwareComponent;
import org.jpc.emulator.PC;
import org.jpc.emulator.StatusDumper;
import org.jpc.emulator.memory.PhysicalAddressSpace;
import org.jpc.jrsr.JRSRArchiveReader;
import org.jpc.jrsr.JRSRArchiveWriter;
import org.jpc.jrsr.UTFInputLineStream;
import org.jpc.plugins.RAWDumper;
import org.jpc.pluginsaux.AsyncGUITask;
import org.jpc.pluginsaux.AuthorsDialog;
import org.jpc.pluginsaux.HUDRenderer;
import org.jpc.pluginsaux.ImportDiskImage;
import org.jpc.pluginsaux.MenuManager;
import org.jpc.pluginsaux.NewDiskDialog;
import org.jpc.pluginsaux.PCConfigDialog;
import org.jpc.pluginsaux.PCMonitorPanel;
import org.jpc.pluginsaux.PCMonitorPanelEmbedder;
import org.jpc.pluginsbase.Plugin;
import org.jpc.pluginsbase.Plugins;

public class PCControl
implements Plugin,
PCMonitorPanelEmbedder {
    private static long PROFILE_ALWAYS = 0L;
    private static long PROFILE_NO_PC = 1L;
    private static long PROFILE_HAVE_PC = 2L;
    private static long PROFILE_STOPPED = 4L;
    private static long PROFILE_RUNNING = 8L;
    private static long PROFILE_EVENTS = 16L;
    private static long PROFILE_CDROM = 32L;
    private static long PROFILE_DUMPING = 64L;
    private static long PROFILE_NOT_DUMPING = 128L;
    private static long PROFILE_HAVE_HDA = 256L;
    private static long PROFILE_HAVE_HDB = 512L;
    private static long PROFILE_HAVE_HDC = 1024L;
    private static long PROFILE_HAVE_HDD = 2048L;
    private static String SAVESTATE_LABEL = "Savestating...";
    private static String LOADSTATE_LABEL = "Loadstating...";
    private static String RAMDUMP_LABEL = "Dumping RAM...";
    private static String IMAGEDUMP_LABEL = "Dumping Image...";
    private static String STATUSDUMP_LABEL = "Dumping status...";
    private static String ASSEMBLE_LABEL = "Assembling system...";
    private static String ADDDISK_LABEL = "Adding new disk...";
    private static String CHANGEAUTHORS_LABEL = "Changing run authors...";
    private static final long serialVersionUID = 8L;
    private Plugins vPluginManager;
    private JFrame window;
    private JFileChooser snapshotFileChooser;
    private JFileChooser otherFileChooser;
    private DropTarget dropTarget;
    private LoadstateDropTarget loadstateDropTarget;
    private RAWDumper dumper;
    private Set<String> disks;
    protected PC pc;
    private int trapFlags;
    private volatile long profile;
    private volatile boolean running;
    private volatile boolean waiting;
    private boolean uncompressedSave;
    private static final long[] stopTime = new long[]{-1L, 0L, 1000L, 2000L, 5000L, 10000L, 20000L, 50000L, 100000L, 200000L, 500000L, 1000000L, 2000000L, 5000000L, 10000000L, 20000000L, 50000000L, 100000000L, 200000000L, 500000000L, 1000000000L, 2000000000L, 5000000000L, 10000000000L, 20000000000L, 50000000000L};
    private static final String[] stopLabel = new String[]{"(unbounded)", "(singlestep)", "1\u00b5s", "2\u00b5s", "5\u00b5s", "10\u00b5s", "20\u00b5s", "50\u00b5s", "100\u00b5s", "200\u00b5s", "500\u00b5s", "1ms", "2ms", "5ms", "10ms", "20ms", "50ms", "100ms", "200ms", "500ms", "1s", "2s", "5s", "10s", "20s", "50s"};
    private volatile long imminentTrapTime;
    private boolean shuttingDown;
    private int nativeWidth;
    private int nativeHeight;
    private PCConfigDialog configDialog;
    private MenuManager menuManager;
    private Map<String, List<String[]>> extraActions;
    private PCMonitorPanel panel;
    private JLabel statusBar;
    private volatile int currentResolutionWidth;
    private volatile int currentResolutionHeight;
    private volatile Runnable taskToDo;
    private volatile String taskLabel;
    private boolean cycleDone;
    private Map<String, Class<?>> debugInClass;
    private Map<String, Boolean> debugState;
    private PC.PCFullStatus currentProject;

    private boolean handleURLDropped(String string) {
        if (!string.startsWith("file:///")) {
            Misc.callShowOptionDialog(this.window, "Can't load remote resource.", "DnD error", 0, 2, null, new String[]{"Dismiss"}, "Dismiss");
            return false;
        }
        string = string.substring(7);
        this.setTask(new LoadStateTask(string, 1), LOADSTATE_LABEL);
        return true;
    }

    @Override
    public boolean systemShutdown() {
        if (!this.running || this.pc == null) {
            return true;
        }
        this.shuttingDown = true;
        this.stop();
        while (this.running) {
        }
        return true;
    }

    @Override
    public void reconnect(PC pC) {
        this.panel.setPC(pC);
        this.pcStopping();
        this.updateStatusBar();
        this.updateDebug();
    }

    @Override
    public void notifySizeChange(int n, int n2) {
        final int n3 = n;
        final int n4 = n2;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PCControl.this.window.pack();
                Dimension dimension = PCControl.this.window.getSize();
                PCControl.this.nativeWidth = dimension.width;
                PCControl.this.nativeHeight = dimension.height;
                PCControl.this.currentResolutionWidth = n3;
                PCControl.this.currentResolutionHeight = n4;
                PCControl.this.updateStatusBarEventThread();
            }
        });
    }

    @Override
    public void notifyFrameReceived(int n, int n2) {
        this.currentResolutionWidth = n;
        this.currentResolutionHeight = n2;
        this.updateStatusBar();
    }

    private void setTrapFlags() {
        this.pc.getTraceTrap().setTrapFlags(this.trapFlags);
    }

    @Override
    public void pcStarting() {
        this.profile = PROFILE_HAVE_PC | PROFILE_RUNNING | this.profile & (PROFILE_DUMPING | PROFILE_NOT_DUMPING);
        if (this.currentProject == null || this.currentProject.events != null) {
            // empty if block
        }
        this.profile |= PROFILE_EVENTS;
        if (this.pc.getCDROMIndex() >= 0) {
            this.profile |= PROFILE_CDROM;
        }
        this.menuManager.setProfile(this.profile);
        if (this.running) {
            return;
        }
        this.setTrapFlags();
        Clock clock = (Clock)this.pc.getComponent(Clock.class);
        long l = clock.getTime();
        if (this.imminentTrapTime > 0L) {
            this.pc.getTraceTrap().setTrapTime(l + this.imminentTrapTime);
        } else if (this.imminentTrapTime == 0L) {
            this.pc.getTraceTrap().setTrapTime(l);
        }
        if (this.currentProject.events != null) {
            this.currentProject.events.setPCRunStatus(true);
        }
    }

    @Override
    public void pcStopping() {
        if (this.currentProject.events != null) {
            this.currentProject.events.setPCRunStatus(false);
        }
        if (this.shuttingDown) {
            return;
        }
        this.profile = PROFILE_STOPPED | this.profile & (PROFILE_DUMPING | PROFILE_NOT_DUMPING);
        this.profile = this.pc != null ? (this.profile |= PROFILE_HAVE_PC) : (this.profile |= PROFILE_NO_PC);
        if (this.currentProject == null || this.currentProject.events != null) {
            // empty if block
        }
        this.profile |= PROFILE_EVENTS;
        if (this.pc.getCDROMIndex() >= 0) {
            this.profile |= PROFILE_CDROM;
        }
        this.menuManager.setProfile(this.profile);
        this.updateStatusBar();
        try {
            this.updateDisks();
        }
        catch (Exception exception) {
            Misc.errorDialog(exception, "Failed to update disk menus", null, "Dismiss");
        }
        if (this.pc != null) {
            this.pc.getTraceTrap().clearTrapTime();
            this.pc.getTraceTrap().getAndClearTrapActive();
        }
    }

    private String diskNameByIdx(int n) {
        return this.pc.getDisks().lookupDisk(n).getName();
    }

    private void updateDisks() throws Exception {
        String string;
        int n;
        for (String object2 : this.disks) {
            this.menuManager.removeMenuItem(object2);
        }
        this.disks.clear();
        if (this.pc == null) {
            return;
        }
        DiskImageSet diskImageSet = this.pc.getDisks();
        DriveSet driveSet = this.pc.getDrives();
        int[] nArray = diskImageSet.diskIndicesByType(BlockDevice.Type.FLOPPY);
        int[] nArray2 = diskImageSet.diskIndicesByType(BlockDevice.Type.CDROM);
        for (n = 0; n < nArray.length; ++n) {
            string = this.diskNameByIdx(nArray[n]);
            this.menuManager.addMenuItem("Drives\u2192fda\u2192" + string, this, "menuChangeDisk", new Object[]{new Integer(0), new Integer(nArray[n])}, PROFILE_HAVE_PC);
            this.menuManager.addMenuItem("Drives\u2192fdb\u2192" + string, this, "menuChangeDisk", new Object[]{new Integer(1), new Integer(nArray[n])}, PROFILE_HAVE_PC);
            this.menuManager.addMenuItem("Drives\u2192dump\u2192" + string, this, "menuDumpDisk", new Object[]{new Integer(nArray[n])}, PROFILE_HAVE_PC);
            this.menuManager.addSelectableMenuItem("Drives\u2192Write Protect\u2192" + string, this, "menuWriteProtect", new Object[]{new Integer(nArray[n])}, diskImageSet.lookupDisk(nArray[n]).isReadOnly(), PROFILE_HAVE_PC);
            this.disks.add("Drives\u2192fda\u2192" + string);
            this.disks.add("Drives\u2192fdb\u2192" + string);
            this.disks.add("Drives\u2192Write Protect\u2192" + string);
            this.disks.add("Drives\u2192dump\u2192" + string);
            DriveSet driveSet2 = this.pc.getDrives();
            this.profile &= (PROFILE_HAVE_HDA | PROFILE_HAVE_HDB | PROFILE_HAVE_HDC | PROFILE_HAVE_HDD) ^ 0xFFFFFFFFFFFFFFFFL;
            BlockDevice blockDevice = driveSet2.getHardDrive(0);
            this.profile |= blockDevice != null && blockDevice.getType() == BlockDevice.Type.HARDDRIVE ? PROFILE_HAVE_HDA : 0L;
            blockDevice = driveSet2.getHardDrive(1);
            this.profile |= blockDevice != null && blockDevice.getType() == BlockDevice.Type.HARDDRIVE ? PROFILE_HAVE_HDB : 0L;
            blockDevice = driveSet2.getHardDrive(2);
            this.profile |= blockDevice != null && blockDevice.getType() == BlockDevice.Type.HARDDRIVE ? PROFILE_HAVE_HDC : 0L;
            blockDevice = driveSet2.getHardDrive(3);
            this.profile |= blockDevice != null && blockDevice.getType() == BlockDevice.Type.HARDDRIVE ? PROFILE_HAVE_HDD : 0L;
            this.menuManager.setProfile(this.profile);
        }
        for (n = 0; n < nArray2.length; ++n) {
            string = this.diskNameByIdx(nArray2[n]);
            this.menuManager.addMenuItem("Drives\u2192CD-ROM\u2192" + string, this, "menuChangeDisk", new Object[]{new Integer(1), new Integer(nArray2[n])}, PROFILE_HAVE_PC | PROFILE_CDROM);
            this.disks.add("Drives\u2192CD-ROM\u2192" + string);
        }
    }

    private synchronized boolean setTask(Runnable runnable, String string) {
        boolean bl = this.running;
        if (bl || this.taskToDo != null) {
            return false;
        }
        this.taskToDo = runnable;
        this.taskLabel = string;
        this.notifyAll();
        this.updateStatusBar();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void main() {
        boolean bl = false;
        while (true) {
            if (!(this.running && this.pc != null || this.taskToDo != null)) {
                if (!this.running && bl && this.pc != null) {
                    this.pc.stop();
                }
                bl = this.running;
                try {
                    PCControl pCControl = this;
                    synchronized (pCControl) {
                        if (this.running && this.pc != null || this.taskToDo != null) {
                        }
                        this.waiting = true;
                        this.notifyAll();
                        this.wait();
                        this.waiting = false;
                    }
                }
                catch (Exception exception) {}
                continue;
            }
            if (this.running && !bl) {
                this.pc.start();
            }
            bl = this.running;
            if (this.taskToDo != null) {
                this.taskToDo.run();
                this.taskToDo = null;
                this.updateStatusBar();
                continue;
            }
            try {
                this.pc.execute();
                if (!this.pc.getHitTraceTrap()) continue;
                if (this.pc.getAndClearTripleFaulted()) {
                    Misc.callShowOptionDialog(this.window, "CPU shut itself down due to triple fault. Rebooting the system.", "Triple fault!", 0, 2, null, new String[]{"Dismiss"}, "Dismiss");
                }
                if (this.shuttingDown) {
                    this.stopNoWait();
                } else {
                    SwingUtilities.invokeAndWait(new Thread(){

                        @Override
                        public void run() {
                            PCControl.this.stopNoWait();
                        }
                    });
                }
                this.running = false;
                this.doCycle(this.pc);
                continue;
            }
            catch (Exception exception) {
                this.running = false;
                this.doCycle(this.pc);
                Misc.errorDialog(exception, "Hardware emulator internal error", this.window, "Dismiss");
                try {
                    if (this.shuttingDown) {
                        this.stopNoWait();
                    } else {
                        SwingUtilities.invokeAndWait(new Thread(){

                            @Override
                            public void run() {
                                PCControl.this.stopNoWait();
                            }
                        });
                    }
                    SwingUtilities.invokeAndWait(new Thread(){

                        @Override
                        public void run() {
                            PCControl.this.stopNoWait();
                        }
                    });
                }
                catch (Exception exception2) {
                }
                continue;
            }
            break;
        }
    }

    public void connectPC(PC pC) {
        this.currentProject.pc = pC;
        this.vPluginManager.reconnect(pC);
        this.pc = pC;
    }

    private void startExternal() {
        if (this.pc != null && !this.running) {
            if (!SwingUtilities.isEventDispatchThread()) {
                try {
                    SwingUtilities.invokeAndWait(new Thread(){

                        @Override
                        public void run() {
                            PCControl.this.start();
                        }
                    });
                }
                catch (Exception exception) {}
            } else {
                this.start();
            }
        }
    }

    private void stopExternal() {
        if (this.pc != null && this.running) {
            if (!SwingUtilities.isEventDispatchThread()) {
                try {
                    SwingUtilities.invokeAndWait(new Thread(){

                        @Override
                        public void run() {
                            PCControl.this.stop();
                        }
                    });
                }
                catch (Exception exception) {}
            } else {
                this.stop();
            }
        }
    }

    public boolean eci_state_save(String string) {
        return this.setTask(new SaveStateTask(string, false), SAVESTATE_LABEL);
    }

    public boolean eci_state_dump(String string) {
        return this.setTask(new StatusDumpTask(string), STATUSDUMP_LABEL);
    }

    public boolean eci_movie_save(String string) {
        return this.setTask(new SaveStateTask(string, true), SAVESTATE_LABEL);
    }

    public boolean eci_state_load(String string) {
        return this.setTask(new LoadStateTask(string, 1), LOADSTATE_LABEL);
    }

    public boolean eci_state_load_noevents(String string) {
        return this.setTask(new LoadStateTask(string, 2), LOADSTATE_LABEL);
    }

    public boolean eci_movie_load(String string) {
        return this.setTask(new LoadStateTask(string, 3), LOADSTATE_LABEL);
    }

    public boolean eci_pc_assemble() {
        return this.setTask(new AssembleTask(), ASSEMBLE_LABEL);
    }

    public boolean eci_ram_dump_text(String string) {
        return this.setTask(new RAMDumpTask(string, false), RAMDUMP_LABEL);
    }

    public boolean eci_image_dump(String string, int n) {
        return this.setTask(new ImageDumpTask(string, n), IMAGEDUMP_LABEL);
    }

    public boolean eci_ram_dump_binary(String string) {
        return this.setTask(new RAMDumpTask(string, true), RAMDUMP_LABEL);
    }

    public void eci_trap_vretrace_start_on() {
        this.trapFlags = (int)((long)this.trapFlags | 1L);
    }

    public void eci_trap_vretrace_start_off() {
        this.trapFlags = (int)((long)this.trapFlags & 0xFFFFFFFFFFFFFFFEL);
    }

    public void eci_trap_vretrace_end_on() {
        this.trapFlags = (int)((long)this.trapFlags | 2L);
    }

    public void eci_trap_vretrace_end_off() {
        this.trapFlags = (int)((long)this.trapFlags & 0xFFFFFFFFFFFFFFFDL);
    }

    public void eci_trap_timed_disable() {
        this.imminentTrapTime = -1L;
    }

    public void eci_trap_timed(Long l) {
        this.imminentTrapTime = l;
    }

    public void eci_pc_start() {
        this.startExternal();
    }

    public void eci_pc_stop() {
        this.stopExternal();
    }

    public void eci_pccontrol_setwinpos(Integer n, Integer n2) {
        Misc.moveWindow(this.window, n, n2, this.nativeWidth, this.nativeHeight);
    }

    public void eci_sendevent(String string, String[] stringArray) {
        System.err.println("Event to: '" + string + "':");
        for (int i = 0; i < stringArray.length; ++i) {
            System.err.println("rargs[" + i + "]: '" + stringArray[i] + "'.");
        }
        if (this.currentProject.events != null) {
            try {
                Class<HardwareComponent> clazz = Class.forName(string).asSubclass(HardwareComponent.class);
                this.currentProject.events.addEvent(0L, clazz, stringArray);
            }
            catch (Exception exception) {
                System.err.println("Error adding event: " + exception.getMessage());
            }
        }
    }

    public void eci_sendevent_lowbound(Long l, String string, String[] stringArray) {
        System.err.println("Event to: '" + string + "' (with low bound of " + l + "):");
        for (int i = 0; i < stringArray.length; ++i) {
            System.err.println("rargs[" + i + "]: '" + stringArray[i] + "'.");
        }
        if (this.currentProject.events != null) {
            try {
                Class<HardwareComponent> clazz = Class.forName(string).asSubclass(HardwareComponent.class);
                this.currentProject.events.addEvent(l, clazz, stringArray);
            }
            catch (Exception exception) {
                System.err.println("Error adding event: " + exception.getMessage());
            }
        }
    }

    public void eci_memory_read(Long l, Integer n) {
        if (this.currentProject.pc != null) {
            long l2 = l;
            long l3 = n.intValue();
            long l4 = 0L;
            if (l2 < 0L || l2 > 0xFFFFFFFFL || l3 != 1L && l3 != 2L && l3 != 4L) {
                return;
            }
            PhysicalAddressSpace physicalAddressSpace = (PhysicalAddressSpace)this.currentProject.pc.getComponent(PhysicalAddressSpace.class);
            if (l3 == 1L) {
                l4 = (long)physicalAddressSpace.getByte((int)l2) & 0xFFL;
            } else if (l3 == 2L) {
                l4 = (long)physicalAddressSpace.getWord((int)l2) & 0xFFFFL;
            } else if (l3 == 4L) {
                l4 = (long)physicalAddressSpace.getDoubleWord((int)l2) & 0xFFFFFFFFL;
            }
            this.vPluginManager.returnValue(l4);
        }
    }

    public void eci_memory_write(Long l, Long l2, Integer n) {
        if (this.currentProject.pc != null) {
            long l3 = l;
            long l4 = n.intValue();
            long l5 = l2;
            if (l3 < 0L || l3 > 0xFFFFFFFFL || l4 != 1L && l4 != 2L && l4 != 4L) {
                return;
            }
            PhysicalAddressSpace physicalAddressSpace = (PhysicalAddressSpace)this.currentProject.pc.getComponent(PhysicalAddressSpace.class);
            if (l4 == 1L) {
                physicalAddressSpace.setByte((int)l3, (byte)l5);
            } else if (l4 == 2L) {
                physicalAddressSpace.setWord((int)l3, (short)l5);
            } else if (l4 == 4L) {
                physicalAddressSpace.setDoubleWord((int)l3, (int)l5);
            }
        }
    }

    public PCControl(Plugins plugins, String string) throws Exception {
        block11: {
            this(plugins);
            UTFInputLineStream uTFInputLineStream = null;
            Map<String, String> map = Misc.parseStringToComponents(string);
            HashSet<String> hashSet = new HashSet<String>();
            String string2 = map.get("extramenu");
            String string3 = map.get("uncompressedsave");
            if (string3 != null) {
                this.uncompressedSave = true;
            }
            if (string2 == null) {
                return;
            }
            try {
                uTFInputLineStream = new UTFInputLineStream(new FileInputStream(string2));
                while (true) {
                    boolean bl = false;
                    String[] stringArray = Misc.nextParseLine(uTFInputLineStream);
                    if (stringArray == null) break;
                    if (stringArray.length < 3 || stringArray[0].charAt(0) == '\u2192') {
                        System.err.println("Warning: Bad extra menu item '" + stringArray[0] + "'.");
                        continue;
                    }
                    if (stringArray[0].length() == 0 || stringArray[0].charAt(stringArray[0].length() - 1) == '\u2192') {
                        System.err.println("Warning: Bad extra menu item '" + stringArray[0] + "'.");
                        continue;
                    }
                    if (stringArray[0].indexOf("\u2192\u2192") >= 0) {
                        System.err.println("Warning: Bad extra menu item '" + stringArray[0] + "'.");
                        continue;
                    }
                    if (hashSet.contains(stringArray[0])) {
                        bl = true;
                    }
                    KeyStroke keyStroke = null;
                    if (!stringArray[1].equals("<>") && (keyStroke = KeyStroke.getKeyStroke(stringArray[1])) == null) {
                        System.err.println("Warning: Bad keystroke '" + stringArray[1] + "'.");
                    }
                    String[] stringArray2 = Arrays.copyOfRange(stringArray, 2, stringArray.length);
                    hashSet.add(stringArray[0]);
                    List<String[]> list = this.extraActions.get(stringArray[0]);
                    if (list == null) {
                        list = new ArrayList<String[]>();
                        this.extraActions.put(stringArray[0], list);
                    }
                    list.add(stringArray2);
                    if (bl) continue;
                    this.menuManager.addMenuItem("Extra\u2192" + stringArray[0], this, "menuExtra", new String[]{stringArray[0]}, PROFILE_ALWAYS, keyStroke);
                }
                uTFInputLineStream.close();
            }
            catch (IOException iOException) {
                Misc.errorDialog(iOException, "Failed to load extra menu defintions", null, "dismiss");
                if (uTFInputLineStream == null) break block11;
                uTFInputLineStream.close();
            }
        }
        this.window.setJMenuBar(this.menuManager.getMainBar());
    }

    public PCControl(Plugins plugins) throws Exception {
        this.window = new JFrame("JPC-RR" + Misc.emuname);
        if (DiskImage.getLibrary() == null) {
            throw new Exception("PCControl plugin requires disk library");
        }
        this.running = false;
        this.shuttingDown = false;
        this.debugInClass = new HashMap();
        this.debugState = new HashMap<String, Boolean>();
        this.configDialog = new PCConfigDialog();
        this.extraActions = new HashMap<String, List<String[]>>();
        this.menuManager = new MenuManager();
        this.profile = PROFILE_NO_PC | PROFILE_STOPPED | PROFILE_NOT_DUMPING;
        this.menuManager.setProfile(this.profile);
        this.menuManager.addMenuItem("System\u2192Assemble", this, "menuAssemble", null, PROFILE_STOPPED);
        this.menuManager.addMenuItem("System\u2192Start", this, "menuStart", null, PROFILE_STOPPED | PROFILE_HAVE_PC);
        this.menuManager.addMenuItem("System\u2192Stop", this, "menuStop", null, PROFILE_RUNNING);
        this.menuManager.addMenuItem("System\u2192Reset", this, "menuReset", null, PROFILE_HAVE_PC);
        this.menuManager.addMenuItem("System\u2192Start dumping", this, "menuStartDump", null, PROFILE_STOPPED | PROFILE_NOT_DUMPING);
        this.menuManager.addMenuItem("System\u2192Stop dumping", this, "menuStopDump", null, PROFILE_STOPPED | PROFILE_DUMPING);
        this.menuManager.addMenuItem("System\u2192Quit", this, "menuQuit", null, PROFILE_ALWAYS);
        this.menuManager.addSelectableMenuItem("Breakpoints\u2192Trap VRetrace Start", this, "menuVRetraceStart", null, false, PROFILE_ALWAYS);
        this.menuManager.addSelectableMenuItem("Breakpoints\u2192Trap VRetrace End", this, "menuVRetraceEnd", null, false, PROFILE_ALWAYS);
        this.menuManager.addMenuItem("Snapshot\u2192Change Run Authors", this, "menuChangeAuthors", null, PROFILE_HAVE_PC);
        this.menuManager.addMenuItem("Snapshot\u2192Save\u2192Snapshot", this, "menuSave", new Object[]{new Boolean(false)}, PROFILE_HAVE_PC | PROFILE_STOPPED);
        this.menuManager.addMenuItem("Snapshot\u2192Save\u2192Movie", this, "menuSave", new Object[]{new Boolean(true)}, PROFILE_HAVE_PC | PROFILE_STOPPED);
        this.menuManager.addMenuItem("Snapshot\u2192Save\u2192Status Dump", this, "menuStatusDump", null, PROFILE_HAVE_PC | PROFILE_STOPPED);
        this.menuManager.addMenuItem("Snapshot\u2192Load\u2192Snapshot", this, "menuLoad", new Object[]{new Integer(1)}, PROFILE_STOPPED);
        this.menuManager.addMenuItem("Snapshot\u2192Load\u2192Snapshot (preserve events)", this, "menuLoad", new Object[]{new Integer(2)}, PROFILE_STOPPED | PROFILE_EVENTS);
        this.menuManager.addMenuItem("Snapshot\u2192Load\u2192Movie", this, "menuLoad", new Object[]{new Integer(3)}, PROFILE_STOPPED);
        this.menuManager.addMenuItem("Snapshot\u2192RAM Dump\u2192Hexadecimal", this, "menuRAMDump", new Object[]{new Boolean(false)}, PROFILE_HAVE_PC | PROFILE_STOPPED);
        this.menuManager.addMenuItem("Snapshot\u2192RAM Dump\u2192Binary", this, "menuRAMDump", new Object[]{new Boolean(true)}, PROFILE_HAVE_PC | PROFILE_STOPPED);
        this.menuManager.addMenuItem("Snapshot\u2192Truncate Event Stream", this, "menuTruncate", null, PROFILE_STOPPED | PROFILE_EVENTS);
        for (int i = 0; i < stopLabel.length; ++i) {
            this.menuManager.addSelectableMenuItem("Breakpoints\u2192Timed Stops\u2192" + stopLabel[i], this, "menuTimedStop", null, i == 0, PROFILE_ALWAYS);
        }
        this.imminentTrapTime = -1L;
        this.menuManager.addMenuItem("Drives\u2192fda\u2192<Empty>", this, "menuChangeDisk", new Object[]{new Integer(0), new Integer(-1)}, PROFILE_HAVE_PC);
        this.menuManager.addMenuItem("Drives\u2192fdb\u2192<Empty>", this, "menuChangeDisk", new Object[]{new Integer(1), new Integer(-1)}, PROFILE_HAVE_PC);
        this.menuManager.addMenuItem("Drives\u2192CD-ROM\u2192<Empty>", this, "menuChangeDisk", new Object[]{new Integer(2), new Integer(-1)}, PROFILE_HAVE_PC | PROFILE_CDROM);
        this.menuManager.addMenuItem("Drives\u2192Add image", this, "menuAddDisk", null, PROFILE_HAVE_PC);
        this.menuManager.addMenuItem("Drives\u2192Import Image", this, "menuImport", null, PROFILE_ALWAYS);
        this.menuManager.addMenuItem("Drives\u2192dump\u2192HDA", this, "menuDumpDisk", new Object[]{new Integer(-1)}, PROFILE_HAVE_PC | PROFILE_HAVE_HDA);
        this.menuManager.addMenuItem("Drives\u2192dump\u2192HDB", this, "menuDumpDisk", new Object[]{new Integer(-2)}, PROFILE_HAVE_PC | PROFILE_HAVE_HDB);
        this.menuManager.addMenuItem("Drives\u2192dump\u2192HDC", this, "menuDumpDisk", new Object[]{new Integer(-3)}, PROFILE_HAVE_PC | PROFILE_HAVE_HDC);
        this.menuManager.addMenuItem("Drives\u2192dump\u2192HDD", this, "menuDumpDisk", new Object[]{new Integer(-4)}, PROFILE_HAVE_PC | PROFILE_HAVE_HDD);
        this.menuManager.addMenuItem("Debug\u2192Hacks\u2192NO_FPU", this, "menuNOFPU", null, PROFILE_HAVE_PC);
        this.menuManager.addMenuItem("Debug\u2192Hacks\u2192VGA_DRAW", this, "menuVGADRAW", null, PROFILE_HAVE_PC);
        this.menuManager.addMenuItem("Debug\u2192Hacks\u2192VGA_SCROLL_2", this, "menuVGASCROLL2", null, PROFILE_HAVE_PC);
        this.disks = new HashSet<String>();
        this.currentProject = new PC.PCFullStatus();
        this.pc = null;
        this.vPluginManager = plugins;
        this.panel = new PCMonitorPanel(this, plugins.getOutputConnector());
        this.loadstateDropTarget = new LoadstateDropTarget();
        this.dropTarget = new DropTarget(this.panel.getMonitorPanel(), this.loadstateDropTarget);
        this.statusBar = new JLabel("");
        this.statusBar.setBorder(new EtchedBorder(1));
        plugins.addSlaveObject(this, this.panel);
        this.panel.startThread();
        this.window.getContentPane().add("Center", this.panel.getMonitorPanel());
        this.window.getContentPane().add("South", this.statusBar);
        JMenuBar jMenuBar = this.menuManager.getMainBar();
        for (JMenu jMenu : this.panel.getMenusNeeded()) {
            jMenuBar.add(jMenu);
        }
        this.window.setJMenuBar(jMenuBar);
        try {
            this.window.setDefaultCloseOperation(3);
        }
        catch (AccessControlException accessControlException) {
            System.err.println("Error: Not able to add some components to frame: " + accessControlException.getMessage());
        }
        this.snapshotFileChooser = new JFileChooser(System.getProperty("user.dir"));
        this.otherFileChooser = new JFileChooser(System.getProperty("user.dir"));
        this.window.getContentPane().validate();
        this.window.validate();
        this.window.pack();
        Dimension dimension = this.window.getSize();
        this.nativeWidth = dimension.width;
        this.nativeHeight = dimension.height;
        this.updateStatusBarEventThread();
        this.window.setVisible(true);
    }

    @Override
    public void sendMessage(String string) {
        this.vPluginManager.invokeExternalCommand("luaplugin-sendmessage", new Object[]{string});
    }

    private String debugShowName(String string) {
        string = string.substring(12);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '_') {
                stringBuffer.append(' ');
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    private void addDebug(String string, Class<?> clazz) {
        if (this.debugInClass.get(string) != null) {
            return;
        }
        this.debugInClass.put(string, clazz);
        this.debugState.put(string, false);
        try {
            this.menuManager.addSelectableMenuItem("Debug\u2192" + this.debugShowName(string), this, "menuDEBUGOPTION", new Object[]{string}, false, PROFILE_HAVE_PC);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void menuDEBUGOPTION(String string, Object[] objectArray) {
        String string2 = (String)objectArray[0];
        String string3 = "Debug\u2192" + this.debugShowName(string2);
        this.debugState.put(string2, this.debugState.get(string2) == false);
        this.setDebugOption(string2);
        this.menuManager.setSelected(string3, this.debugState.get(string2));
    }

    private void setDebugOption(String string) {
        try {
            this.debugInClass.get(string).getDeclaredMethod(string, Boolean.TYPE).invoke((Object)this.pc.getComponent(this.debugInClass.get(string)), this.debugState.get(string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void setDebugOptions() {
        for (Map.Entry<String, Class<?>> entry : this.debugInClass.entrySet()) {
            this.setDebugOption(entry.getKey());
        }
    }

    private void updateDebug() {
        this.setDebugOptions();
        for (HardwareComponent hardwareComponent : this.pc.allComponents()) {
            Class<?> clazz = hardwareComponent.getClass();
            for (Method method : clazz.getDeclaredMethods()) {
                Class<?>[] classArray = method.getParameterTypes();
                if (!method.getName().startsWith("DEBUGOPTION_") || classArray.length != 1 || classArray[0] != Boolean.TYPE) continue;
                this.addDebug(method.getName(), clazz);
            }
        }
    }

    @Override
    public void notifyRenderer(HUDRenderer hUDRenderer) {
        this.vPluginManager.addRenderer(hUDRenderer);
    }

    private void updateStatusBar() {
        if (this.vPluginManager.isShuttingDown()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PCControl.this.updateStatusBarEventThread();
            }
        });
    }

    private void updateStatusBarEventThread() {
        String string;
        if (this.currentProject.pc != null && this.taskToDo == null) {
            long l = ((Clock)this.currentProject.pc.getComponent(Clock.class)).getTime();
            long l2 = this.currentProject.events.getLastEventTime();
            string = " Time: " + l / 1000000L + "ms, movie length: " + l2 / 1000000L + "ms";
            string = this.currentResolutionWidth > 0 && this.currentResolutionHeight > 0 ? string + ", resolution: " + this.currentResolutionWidth + "*" + this.currentResolutionHeight : string + ", resolution: <No valid signal>";
            if (this.currentProject.events.isAtMovieEnd()) {
                string = string + " (At movie end)";
            }
        } else {
            string = this.taskToDo != null ? this.taskLabel : " NO PC CONNECTED";
        }
        this.statusBar.setText(string);
    }

    public void menuExtra(String string, Object[] objectArray) {
        final List<String[]> list = this.extraActions.get(objectArray[0]);
        if (list == null) {
            System.err.println("Warning: Called extra menu with unknown entry '" + objectArray[0] + "'.");
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                PCControl.this.menuExtraThreadFunc(list);
            }
        }, "Extra action thread").start();
    }

    private void menuExtraThreadFunc(List<String[]> list) {
        for (String[] stringArray : list) {
            if (stringArray.length == 1) {
                this.vPluginManager.invokeExternalCommandSynchronous(stringArray[0], null);
                continue;
            }
            String[] stringArray2 = (String[])Arrays.copyOfRange(stringArray, 1, stringArray.length, String[].class);
            this.vPluginManager.invokeExternalCommandSynchronous(stringArray[0], stringArray2);
        }
    }

    public void menuAssemble(String string, Object[] objectArray) {
        this.setTask(new AssembleTask(), ASSEMBLE_LABEL);
    }

    public void menuStart(String string, Object[] objectArray) {
        this.start();
    }

    public void menuStartDump(String string, Object[] objectArray) {
        int n = this.otherFileChooser.showDialog(this.window, "Dump to file");
        if (n != 0) {
            return;
        }
        File file = this.otherFileChooser.getSelectedFile();
        try {
            this.dumper = new RAWDumper(this.vPluginManager, "rawoutput=" + file.getAbsolutePath());
            this.vPluginManager.registerPlugin(this.dumper);
            this.pc.refreshGameinfo(this.currentProject);
        }
        catch (Exception exception) {
            Misc.errorDialog(exception, "Failed to start dumping", null, "Dismiss");
            return;
        }
        this.profile &= PROFILE_NOT_DUMPING ^ 0xFFFFFFFFFFFFFFFFL;
        this.profile |= PROFILE_DUMPING;
        this.menuManager.setProfile(this.profile);
    }

    public void menuStopDump(String string, Object[] objectArray) {
        this.vPluginManager.unregisterPlugin(this.dumper);
        this.profile &= PROFILE_DUMPING ^ 0xFFFFFFFFFFFFFFFFL;
        this.profile |= PROFILE_NOT_DUMPING;
        this.menuManager.setProfile(this.profile);
    }

    public void menuStop(String string, Object[] objectArray) {
        this.stop();
    }

    public void menuReset(String string, Object[] objectArray) {
        this.reset();
    }

    public void menuImport(String string, Object[] objectArray) {
        try {
            new ImportDiskImage();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void menuNOFPU(String string, Object[] objectArray) {
        this.pc.setFPUHack();
    }

    public void menuVGADRAW(String string, Object[] objectArray) {
        this.pc.setVGADrawHack();
    }

    public void menuVGASCROLL2(String string, Object[] objectArray) {
        this.pc.setVGAScroll2Hack();
    }

    public void menuQuit(String string, Object[] objectArray) {
        this.vPluginManager.shutdownEmulator();
    }

    public void menuVRetraceStart(String string, Object[] objectArray) {
        this.trapFlags = (int)((long)this.trapFlags ^ 1L);
        this.menuManager.setSelected("Breakpoints\u2192Trap VRetrace Start", ((long)this.trapFlags & 1L) == 1L);
    }

    public void menuVRetraceEnd(String string, Object[] objectArray) {
        this.trapFlags = (int)((long)this.trapFlags ^ 2L);
        this.menuManager.setSelected("Breakpoints\u2192Trap VRetrace End", ((long)this.trapFlags & 2L) == 2L);
    }

    public void menuTimedStop(String string, Object[] objectArray) {
        for (int i = 0; i < stopLabel.length; ++i) {
            String string2 = "Breakpoints\u2192Timed Stops\u2192" + stopLabel[i];
            if (string.equals(string2)) {
                this.imminentTrapTime = stopTime[i];
                this.menuManager.select(string2);
                continue;
            }
            this.menuManager.unselect(string2);
        }
    }

    public void menuSave(String string, Object[] objectArray) {
        this.setTask(new SaveStateTask((Boolean)objectArray[0]), SAVESTATE_LABEL);
    }

    public void menuStatusDump(String string, Object[] objectArray) {
        this.setTask(new StatusDumpTask(), STATUSDUMP_LABEL);
    }

    public void menuLoad(String string, Object[] objectArray) {
        this.setTask(new LoadStateTask((Integer)objectArray[0]), LOADSTATE_LABEL);
    }

    public void menuRAMDump(String string, Object[] objectArray) {
        this.setTask(new RAMDumpTask((Boolean)objectArray[0]), RAMDUMP_LABEL);
    }

    public void menuDumpDisk(String string, Object[] objectArray) {
        this.setTask(new ImageDumpTask((Integer)objectArray[0]), IMAGEDUMP_LABEL);
    }

    public void menuTruncate(String string, Object[] objectArray) {
        this.currentProject.events.truncateEventStream();
    }

    public void menuChangeDisk(String string, Object[] objectArray) {
        this.changeFloppy((Integer)objectArray[0], (Integer)objectArray[1]);
    }

    public void menuWriteProtect(String string, Object[] objectArray) {
        int n = (Integer)objectArray[0];
        this.writeProtect(n, this.menuManager.isSelected(string));
        DiskImageSet diskImageSet = this.pc.getDisks();
        this.menuManager.setSelected(string, diskImageSet.lookupDisk(n).isReadOnly());
    }

    public void menuAddDisk(String string, Object[] objectArray) {
        this.setTask(new AddDiskTask(), ADDDISK_LABEL);
    }

    public void menuChangeAuthors(String string, Object[] objectArray) {
        this.setTask(new ChangeAuthorsTask(), CHANGEAUTHORS_LABEL);
    }

    public synchronized void start() {
        if (this.taskToDo != null) {
            return;
        }
        this.vPluginManager.pcStarted();
        this.running = true;
        this.notifyAll();
    }

    private String prettyPrintTime(long l) {
        String string = "";
        if (l >= 1000000000L) {
            string = string + "" + l / 1000000000L + " ";
        }
        if (l >= 100000000L) {
            string = string + "" + l % 1000000000L / 100000000L;
        }
        if (l >= 10000000L) {
            string = string + "" + l % 100000000L / 10000000L;
        }
        if (l >= 1000000L) {
            string = string + "" + l % 10000000L / 1000000L + " ";
        }
        if (l >= 100000L) {
            string = string + "" + l % 1000000L / 100000L;
        }
        if (l >= 10000L) {
            string = string + "" + l % 100000L / 10000L;
        }
        if (l >= 1000L) {
            string = string + "" + l % 10000L / 1000L + " ";
        }
        if (l >= 100L) {
            string = string + "" + l % 1000L / 100L;
        }
        if (l >= 10L) {
            string = string + "" + l % 100L / 10L;
        }
        string = string + "" + l % 10L;
        return string;
    }

    protected synchronized void stopNoWait() {
        this.running = false;
        this.vPluginManager.pcStopped();
        Clock clock = (Clock)this.pc.getComponent(Clock.class);
        System.err.println("Notice: PC emulation stopped (at time sequence value " + this.prettyPrintTime(clock.getTime()) + ")");
    }

    public synchronized void stop() {
        this.pc.getTraceTrap().doPotentialTrap(Integer.MIN_VALUE);
        System.err.println("Informational: Waiting for PC to halt...");
    }

    public JScrollPane getMonitorPane() {
        return null;
    }

    protected void reset() {
        this.pc.reboot();
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    private void changeFloppy(int n, int n2) {
        try {
            PC.DiskChanger diskChanger = (PC.DiskChanger)this.pc.getComponent(PC.DiskChanger.class);
            diskChanger.changeFloppyDisk(n, n2);
        }
        catch (Exception exception) {
            System.err.println("Error: Failed to change disk");
            Misc.errorDialog(exception, "Failed to change disk", null, "Dismiss");
        }
    }

    private void writeProtect(int n, boolean bl) {
        try {
            PC.DiskChanger diskChanger = (PC.DiskChanger)this.pc.getComponent(PC.DiskChanger.class);
            diskChanger.wpFloppyDisk(n, bl);
        }
        catch (Exception exception) {
            System.err.println("Error: Failed to change floppy write protect");
            Misc.errorDialog(exception, "Failed to write (un)protect floppy", null, "Dismiss");
        }
    }

    private synchronized void doCycleDedicatedThread(PC pC) {
        if (pC == null) {
            this.cycleDone = true;
            return;
        }
        DisplayController displayController = (DisplayController)((Object)pC.getComponent(DisplayController.class));
        displayController.getOutputDevice().holdOutput(pC.getTime());
        this.cycleDone = true;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCycle(PC pC) {
        final PC pC2 = pC;
        this.cycleDone = false;
        new Thread(new Runnable(){

            @Override
            public void run() {
                PCControl.this.doCycleDedicatedThread(pC2);
            }
        }, "VGA output cycle thread").start();
        while (this.cycleDone) {
            try {
                PCControl pCControl = this;
                synchronized (pCControl) {
                    if (this.cycleDone) {
                        break;
                    }
                    this.wait();
                }
            }
            catch (Exception exception) {
            }
        }
    }

    private class ChangeAuthorsTask
    extends AsyncGUITask {
        Exception caught;
        AuthorsDialog ad;

        public ChangeAuthorsTask() {
            boolean bl = false;
            boolean bl2 = false;
            AuthorsDialog.AuthorElement[] authorElementArray = null;
            if (PCControl.this.currentProject != null) {
                authorElementArray = AuthorsDialog.readAuthorsFromHeaders(((PCControl)PCControl.this).currentProject.extraHeaders);
            }
            this.ad = new AuthorsDialog(authorElementArray);
        }

        @Override
        protected void runPrepare() {
        }

        @Override
        protected void runFinish() {
            if (this.caught != null) {
                Misc.errorDialog(this.caught, "Changing authors failed", PCControl.this.window, "Dismiss");
            }
            PCControl.this.vPluginManager.signalCommandCompletion();
        }

        @Override
        protected void runTask() {
            AuthorsDialog.Response response = this.ad.waitClose();
            if (response == null) {
                return;
            }
            try {
                ((PCControl)PCControl.this).currentProject.extraHeaders = AuthorsDialog.rewriteHeaderAuthors(((PCControl)PCControl.this).currentProject.extraHeaders, response.authors);
                ((PCControl)PCControl.this).currentProject.events.setHeaders(((PCControl)PCControl.this).currentProject.extraHeaders);
            }
            catch (Exception exception) {
                this.caught = exception;
            }
        }
    }

    private class AddDiskTask
    extends AsyncGUITask {
        Exception caught;
        NewDiskDialog dd = new NewDiskDialog();

        @Override
        protected void runPrepare() {
        }

        @Override
        protected void runFinish() {
            if (this.caught != null) {
                Misc.errorDialog(this.caught, "Adding disk failed", PCControl.this.window, "Dismiss");
            }
            try {
                PCControl.this.updateDisks();
            }
            catch (Exception exception) {
                Misc.errorDialog(exception, "Failed to update disk menus", null, "Dismiss");
            }
            PCControl.this.vPluginManager.signalCommandCompletion();
        }

        @Override
        protected void runTask() {
            NewDiskDialog.Response response = this.dd.waitClose();
            if (response == null) {
                return;
            }
            try {
                DiskImage diskImage = new DiskImage(response.diskFile, false);
                PCControl.this.pc.getDisks().addDisk(diskImage);
                diskImage.setName(response.diskName);
            }
            catch (Exception exception) {
                this.caught = exception;
            }
        }
    }

    private class AssembleTask
    extends AsyncGUITask {
        Exception caught;
        boolean canceled = false;

        @Override
        protected void runPrepare() {
            try {
                PCControl.this.configDialog.popUp();
            }
            catch (Exception exception) {
                this.caught = exception;
            }
        }

        @Override
        protected void runFinish() {
            if (this.caught == null && !this.canceled) {
                try {
                    ((PCControl)PCControl.this).currentProject.projectID = Misc.randomHexes(24);
                    ((PCControl)PCControl.this).currentProject.rerecords = 0L;
                    ((PCControl)PCControl.this).currentProject.events = new EventRecorder();
                    ((PCControl)PCControl.this).currentProject.events.attach(PCControl.this.pc, null);
                    ((PCControl)PCControl.this).currentProject.savestateID = null;
                    ((PCControl)PCControl.this).currentProject.extraHeaders = null;
                    ((PCControl)PCControl.this).currentProject.events.setRerecordCount(0L);
                    ((PCControl)PCControl.this).currentProject.events.setHeaders(((PCControl)PCControl.this).currentProject.extraHeaders);
                    PCControl.this.connectPC(PCControl.this.pc);
                }
                catch (Exception exception) {
                    this.caught = exception;
                }
            }
            if (this.caught != null) {
                Misc.errorDialog(this.caught, "PC Assembly failed", PCControl.this.window, "Dismiss");
            }
            PCControl.this.vPluginManager.signalCommandCompletion();
        }

        @Override
        protected void runTask() {
            if (this.caught != null) {
                return;
            }
            PC.PCHardwareInfo pCHardwareInfo = PCControl.this.configDialog.waitClose();
            if (pCHardwareInfo == null) {
                this.canceled = true;
                return;
            }
            try {
                PCControl.this.pc = PC.createPC(pCHardwareInfo);
            }
            catch (Exception exception) {
                this.caught = exception;
            }
        }
    }

    private class ImageDumpTask
    extends AsyncGUITask {
        File chosen = null;
        Exception caught;
        int index;

        public ImageDumpTask(int n) {
            this.index = n;
        }

        public ImageDumpTask(String string, int n) {
            this(n);
            this.chosen = new File(string);
        }

        @Override
        protected void runPrepare() {
            if (this.chosen == null) {
                int n = PCControl.this.otherFileChooser.showDialog(PCControl.this.window, "Save Image dump");
                this.chosen = PCControl.this.otherFileChooser.getSelectedFile();
                if (n != 0) {
                    this.chosen = null;
                }
            }
        }

        @Override
        protected void runFinish() {
            if (this.caught != null) {
                Misc.errorDialog(this.caught, "Image dump failed", PCControl.this.window, "Dismiss");
            }
            PCControl.this.vPluginManager.signalCommandCompletion();
        }

        @Override
        protected void runTask() {
            if (this.chosen == null) {
                return;
            }
            try {
                DiskImage diskImage = this.index < 0 ? PCControl.this.pc.getDrives().getHardDrive(-1 - this.index).getImage() : PCControl.this.pc.getDisks().lookupDisk(this.index);
                if (diskImage == null) {
                    throw new IOException("Trying to dump nonexistent disk");
                }
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.chosen));
                byte[] byArray = new byte[512];
                long l = diskImage.getTotalSectors();
                for (long i = 0L; i < l; ++i) {
                    diskImage.read(i, byArray, 1);
                    ((OutputStream)bufferedOutputStream).write(byArray);
                }
                ((OutputStream)bufferedOutputStream).close();
                System.err.println("Informational: Dumped disk image (" + l + " sectors).");
            }
            catch (Exception exception) {
                this.caught = exception;
            }
        }
    }

    private class RAMDumpTask
    extends AsyncGUITask {
        File chosen = null;
        Exception caught;
        boolean binary;

        public RAMDumpTask(boolean bl) {
            this.binary = bl;
        }

        public RAMDumpTask(String string, boolean bl) {
            this(bl);
            this.chosen = new File(string);
        }

        @Override
        protected void runPrepare() {
            if (this.chosen == null) {
                int n = this.binary ? PCControl.this.otherFileChooser.showDialog(PCControl.this.window, "Save RAM dump") : PCControl.this.otherFileChooser.showDialog(PCControl.this.window, "Save RAM hexdump");
                this.chosen = PCControl.this.otherFileChooser.getSelectedFile();
                if (n != 0) {
                    this.chosen = null;
                }
            }
        }

        @Override
        protected void runFinish() {
            if (this.caught != null) {
                Misc.errorDialog(this.caught, "RAM dump failed", PCControl.this.window, "Dismiss");
            }
            PCControl.this.vPluginManager.signalCommandCompletion();
        }

        @Override
        protected void runTask() {
            if (this.chosen == null) {
                return;
            }
            try {
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.chosen));
                byte[] byArray = new byte[4096];
                PhysicalAddressSpace physicalAddressSpace = (PhysicalAddressSpace)PCControl.this.pc.getComponent(PhysicalAddressSpace.class);
                int n = physicalAddressSpace.findFirstRAMPage(0);
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                while (n >= 0) {
                    while (n2 < n) {
                        this.dumpPage(bufferedOutputStream, n2, null);
                        ++n2;
                    }
                    physicalAddressSpace.readRAMPage(n2++, byArray);
                    this.dumpPage(bufferedOutputStream, n, byArray);
                    ++n4;
                    n3 = n + 1;
                    ++n;
                    n = physicalAddressSpace.findFirstRAMPage(n);
                }
                ((OutputStream)bufferedOutputStream).flush();
                System.err.println("Informational: Dumped machine RAM (" + n3 + " pages examined, " + n4 + " pages present).");
            }
            catch (Exception exception) {
                this.caught = exception;
            }
        }

        private byte charForHex(int n) {
            if (n < 10) {
                return (byte)(n + 48);
            }
            if (n > 9 && n < 16) {
                return (byte)(n + 55);
            }
            System.err.println("Unknown hex value: " + n + ".");
            return 90;
        }

        private void dumpPage(OutputStream outputStream, int n, byte[] byArray) throws IOException {
            n &= 0xFFFFF;
            if (!this.binary && byArray == null) {
                return;
            }
            int n2 = this.binary ? 4096 : 14592;
            byte[] byArray2 = new byte[n2];
            if (byArray != null && this.binary) {
                System.arraycopy(byArray, 0, byArray2, 0, 4096);
            } else if (byArray != null) {
                for (int i = 0; i < 256; ++i) {
                    for (int j = 0; j < 57; ++j) {
                        if (j < 5) {
                            byArray2[57 * i + j] = this.charForHex(n >>> 4 * (4 - j) & 0xF);
                            continue;
                        }
                        if (j == 5) {
                            byArray2[57 * i + j] = this.charForHex(i / 16);
                            continue;
                        }
                        if (j == 6) {
                            byArray2[57 * i + j] = this.charForHex(i % 16);
                            continue;
                        }
                        if (j == 7) {
                            byArray2[57 * i + j] = 48;
                            continue;
                        }
                        if (j == 56) {
                            byArray2[57 * i + j] = 10;
                            continue;
                        }
                        if (j % 3 == 2) {
                            byArray2[57 * i + j] = 32;
                            continue;
                        }
                        if (j % 3 == 0) {
                            byArray2[57 * i + j] = this.charForHex((byArray[16 * i + j / 3 - 3] & 0xFF) / 16);
                            continue;
                        }
                        if (j % 3 == 1) {
                            byArray2[57 * i + j] = this.charForHex(byArray[16 * i + j / 3 - 3] & 0xF);
                            continue;
                        }
                        System.err.println("Error: dumpPage: unhandled j = " + j + ".");
                    }
                }
            }
            outputStream.write(byArray2);
        }
    }

    private class StatusDumpTask
    extends AsyncGUITask {
        File chosen = null;
        Exception caught;

        public StatusDumpTask() {
        }

        public StatusDumpTask(String string) {
            this();
            this.chosen = new File(string);
        }

        @Override
        protected void runPrepare() {
            if (this.chosen == null) {
                int n = PCControl.this.otherFileChooser.showDialog(PCControl.this.window, "Save Status dump");
                this.chosen = PCControl.this.otherFileChooser.getSelectedFile();
                if (n != 0) {
                    this.chosen = null;
                }
            }
        }

        @Override
        protected void runFinish() {
            if (this.caught != null) {
                Misc.errorDialog(this.caught, "Status dump failed", PCControl.this.window, "Dismiss");
            }
            PCControl.this.vPluginManager.signalCommandCompletion();
        }

        @Override
        protected void runTask() {
            if (this.chosen == null) {
                return;
            }
            try {
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.chosen));
                PrintStream printStream = new PrintStream((OutputStream)bufferedOutputStream, false, "UTF-8");
                StatusDumper statusDumper = new StatusDumper(printStream);
                PCControl.this.pc.dumpStatus(statusDumper);
                printStream.flush();
                ((OutputStream)bufferedOutputStream).flush();
                System.err.println("Informational: Dumped " + statusDumper.dumpedObjects() + " objects");
            }
            catch (Exception exception) {
                this.caught = exception;
            }
        }
    }

    private class SaveStateTask
    extends AsyncGUITask {
        File chosen = null;
        Exception caught;
        boolean movieOnly;
        long oTime = System.currentTimeMillis();

        public SaveStateTask(boolean bl) {
            this.movieOnly = bl;
        }

        public SaveStateTask(String string, boolean bl) {
            this(bl);
            this.chosen = new File(string);
        }

        @Override
        protected void runPrepare() {
            if (this.chosen == null) {
                int n = PCControl.this.snapshotFileChooser.showDialog(PCControl.this.window, this.movieOnly ? "Save JPC-RR Movie" : "Save JPC-RR Snapshot");
                this.chosen = PCControl.this.snapshotFileChooser.getSelectedFile();
                if (n != 0) {
                    this.chosen = null;
                }
            }
        }

        @Override
        protected void runFinish() {
            if (this.caught != null) {
                Misc.errorDialog(this.caught, "Saving savestate failed", PCControl.this.window, "Dismiss");
            }
            System.err.println("Total save time: " + (System.currentTimeMillis() - this.oTime) + "ms.");
            PCControl.this.vPluginManager.signalCommandCompletion();
        }

        @Override
        protected void runTask() {
            if (this.chosen == null) {
                return;
            }
            JRSRArchiveWriter jRSRArchiveWriter = null;
            try {
                System.err.println("Informational: Savestating...");
                long l = System.currentTimeMillis();
                jRSRArchiveWriter = new JRSRArchiveWriter(this.chosen.getAbsolutePath());
                PC.saveSavestate(jRSRArchiveWriter, PCControl.this.currentProject, this.movieOnly, PCControl.this.uncompressedSave);
                Misc.renameFile(this.chosen, new File(this.chosen.getAbsolutePath() + ".backup"));
                jRSRArchiveWriter.close();
                long l2 = System.currentTimeMillis();
                System.err.println("Informational: Savestate complete (" + (l2 - l) + "ms). on" + this.chosen.getAbsolutePath());
            }
            catch (Exception exception) {
                if (jRSRArchiveWriter != null) {
                    try {
                        jRSRArchiveWriter.rollback();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
                this.caught = exception;
            }
        }
    }

    private class LoadStateTask
    extends AsyncGUITask {
        File chosen = null;
        Exception caught;
        int _mode;
        long oTime = System.currentTimeMillis();
        private static final int MODE_NORMAL = 1;
        private static final int MODE_PRESERVE = 2;
        private static final int MODE_MOVIEONLY = 3;

        public LoadStateTask(int n) {
            this._mode = n;
        }

        public LoadStateTask(String string, int n) {
            this(n);
            this.chosen = new File(string);
        }

        @Override
        protected void runPrepare() {
            if (this.chosen == null) {
                int n = 0;
                n = this._mode == 2 ? PCControl.this.snapshotFileChooser.showDialog(PCControl.this.window, "LOAD JPC-RR Snapshot (PE)") : (this._mode == 3 ? PCControl.this.snapshotFileChooser.showDialog(PCControl.this.window, "LOAD JPC-RR Snapshot (MO)") : PCControl.this.snapshotFileChooser.showDialog(PCControl.this.window, "LOAD JPC-RR Snapshot"));
                this.chosen = PCControl.this.snapshotFileChooser.getSelectedFile();
                if (n != 0) {
                    this.chosen = null;
                }
            }
        }

        @Override
        protected void runFinish() {
            if (this.chosen == null) {
                return;
            }
            if (this.caught == null) {
                try {
                    PCControl.this.pc = ((PCControl)PCControl.this).currentProject.pc;
                    PCControl.this.connectPC(PCControl.this.pc);
                    PCControl.this.doCycle(PCControl.this.pc);
                    System.err.println("Informational: Loadstate done on " + this.chosen.getAbsolutePath());
                }
                catch (Exception exception) {
                    this.caught = exception;
                }
            }
            if (this.caught != null) {
                Misc.errorDialog(this.caught, "Load savestate failed", PCControl.this.window, "Dismiss");
            }
            System.err.println("Total save time: " + (System.currentTimeMillis() - this.oTime) + "ms.");
            PCControl.this.vPluginManager.signalCommandCompletion();
        }

        @Override
        protected void runTask() {
            if (this.chosen == null) {
                return;
            }
            try {
                System.err.println("Informational: Loading a snapshot of JPC-RR");
                long l = System.currentTimeMillis();
                JRSRArchiveReader jRSRArchiveReader = new JRSRArchiveReader(this.chosen.getAbsolutePath());
                PC.PCFullStatus pCFullStatus = PC.loadSavestate(jRSRArchiveReader, this._mode == 2, this._mode == 3, PCControl.this.currentProject);
                PCControl.this.currentProject = pCFullStatus;
                jRSRArchiveReader.close();
                long l2 = System.currentTimeMillis();
                System.err.println("Informational: Loadstate complete (" + (l2 - l) + "ms).");
            }
            catch (Exception exception) {
                this.caught = exception;
            }
        }
    }

    class LoadstateDropTarget
    implements DropTargetListener {
        LoadstateDropTarget() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        }

        @Override
        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            Object object;
            Transferable transferable;
            if (PCControl.this.running) {
                dropTargetDropEvent.rejectDrop();
                return;
            }
            dropTargetDropEvent.acceptDrop(1);
            int n = 0;
            for (DataFlavor dataFlavor : dropTargetDropEvent.getCurrentDataFlavors()) {
                try {
                    transferable = dropTargetDropEvent.getTransferable();
                    object = transferable.getTransferData(dataFlavor);
                    if (!dataFlavor.isMimeTypeEqual("text/uri-list") || object.getClass() != String.class) continue;
                    String string = (String)object;
                    if (string.indexOf(10) >= 0) {
                        Misc.callShowOptionDialog(PCControl.this.window, "Hey, only single file at time!", "DnD error", 0, 2, null, new String[]{"Dismiss"}, "Dismiss");
                        dropTargetDropEvent.dropComplete(false);
                        return;
                    }
                    dropTargetDropEvent.dropComplete(PCControl.this.handleURLDropped(string));
                    return;
                }
                catch (Exception exception) {
                    Misc.errorDialog(exception, "Failed to get DnD data", null, "Dismiss");
                    dropTargetDropEvent.dropComplete(false);
                    return;
                }
            }
            for (DataFlavor dataFlavor : dropTargetDropEvent.getCurrentDataFlavors()) {
                n = 0;
                try {
                    transferable = dropTargetDropEvent.getTransferable();
                    object = transferable.getTransferData(dataFlavor);
                    System.err.println("Notice: Format #" + ++n + ":" + object.getClass().getName() + "(" + dataFlavor + ")");
                }
                catch (Exception exception) {
                    System.err.println("Notice: Format #" + n + ": <ERROR>(" + dataFlavor + ")");
                }
            }
            Misc.callShowOptionDialog(PCControl.this.window, "Can't recognize file to load from drop (debugging information dumped to console).", "DnD error", 0, 2, null, new String[]{"Dismiss"}, "Dismiss");
            dropTargetDropEvent.dropComplete(false);
        }
    }
}

