/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.plugins;

import java.util.Map;
import org.jpc.Misc;
import org.jpc.diskimages.DiskImage;
import org.jpc.emulator.PC;
import org.jpc.emulator.memory.PhysicalAddressSpace;
import org.jpc.jrsr.JRSRArchiveReader;
import org.jpc.pluginsbase.Plugin;
import org.jpc.pluginsbase.Plugins;

public class PCRunner
implements Plugin {
    private static final long serialVersionUID = 8L;
    private Plugins vPluginManager;
    private String fileName;
    private boolean shutDown;
    private boolean shutDownRequest;
    private boolean fpuHack;
    private boolean vgaDrawHack;
    private boolean vgaScroll2Hack;
    private long imminentTrapTime;
    protected PC pc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean systemShutdown() {
        this.shutDownRequest = true;
        PCRunner pCRunner = this;
        synchronized (pCRunner) {
            while (!this.shutDown) {
                try {
                    this.wait();
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }

    @Override
    public void reconnect(PC pC) {
        if (this.fpuHack) {
            pC.setFPUHack();
        }
        if (this.vgaDrawHack) {
            pC.setVGADrawHack();
        }
        if (this.vgaScroll2Hack) {
            pC.setVGAScroll2Hack();
        }
    }

    @Override
    public void pcStarting() {
    }

    @Override
    public void pcStopping() {
    }

    public void eci_memory_read(Long l, Integer n) {
        if (this.pc != null) {
            long l2 = l;
            long l3 = n.intValue();
            long l4 = 0L;
            if (l2 < 0L || l2 > 0xFFFFFFFFL || l3 != 1L && l3 != 2L && l3 != 4L) {
                return;
            }
            PhysicalAddressSpace physicalAddressSpace = (PhysicalAddressSpace)this.pc.getComponent(PhysicalAddressSpace.class);
            if (l3 == 1L) {
                l4 = (long)physicalAddressSpace.getByte((int)l2) & 0xFFL;
            } else if (l3 == 2L) {
                l4 = (long)physicalAddressSpace.getWord((int)l2) & 0xFFFFL;
            } else if (l3 == 4L) {
                l4 = (long)physicalAddressSpace.getDoubleWord((int)l2) & 0xFFFFFFFFL;
            }
            this.vPluginManager.returnValue(l4);
        }
    }

    public void eci_shutdown_emulator() {
        this.shutDownRequest = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void main() {
        Object object;
        Exception exception = null;
        if (this.fileName == null) {
            System.err.println("Critical: No savestate to load.");
            return;
        }
        try {
            System.err.println("Informational: Loading a snapshot of JPC-RR");
            object = new JRSRArchiveReader(this.fileName);
            PC.PCFullStatus pCFullStatus = PC.loadSavestate((JRSRArchiveReader)object, false, false, null);
            this.pc = pCFullStatus.pc;
            ((JRSRArchiveReader)object).close();
            pCFullStatus.events.setPCRunStatus(true);
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        if (exception == null) {
            try {
                this.connectPC(this.pc);
                System.err.println("Informational: Loadstate done");
            }
            catch (Exception exception3) {
                exception = exception3;
            }
        }
        if (exception != null) {
            System.err.println("Critical: Savestate load failed.");
            Misc.errorDialog(exception, "Failed to load savestate", null, "Quit");
            this.shutDown = true;
            this.vPluginManager.shutdownEmulator();
            return;
        }
        this.vPluginManager.pcStarted();
        this.pc.start();
        if (this.imminentTrapTime > 0L) {
            this.pc.getTraceTrap().setTrapTime(this.imminentTrapTime);
        }
        while (!this.shutDownRequest) {
            try {
                this.pc.execute();
                if (!this.pc.getHitTraceTrap()) continue;
                if (!this.pc.getAndClearTripleFaulted()) break;
                System.err.println("Warning: CPU shut itself down due to triple fault. Rebooting the system.");
                break;
            }
            catch (Exception exception4) {
                System.err.println("Critical: Hardware emulator internal error");
                Misc.errorDialog(exception4, "Emulator internal error", null, "Quit");
                break;
            }
        }
        System.err.println("Informational: Emulation stopped. Exiting.");
        this.pc.stop();
        this.vPluginManager.pcStopped();
        object = this;
        synchronized (object) {
            this.shutDown = true;
            this.notifyAll();
        }
        this.vPluginManager.shutdownEmulator();
    }

    public synchronized void connectPC(PC pC) {
        this.vPluginManager.reconnect(pC);
        this.pc = pC;
        this.notifyAll();
    }

    public PCRunner(Plugins plugins, String string) throws Exception {
        Map<String, String> map = Misc.parseStringToComponents(string);
        if (DiskImage.getLibrary() == null) {
            throw new Exception("PCRunner plugin requires disk library");
        }
        this.pc = null;
        this.vPluginManager = plugins;
        this.fileName = map.get("movie");
        String string2 = map.get("stoptime");
        if (this.fileName == null) {
            throw new Exception("No movie to load");
        }
        if (string2 != null) {
            this.imminentTrapTime = Long.parseLong(string2);
        }
        if (map.get("fpuhack") != null) {
            this.fpuHack = true;
        }
        if (map.get("vgadrawhack") != null) {
            this.vgaDrawHack = true;
        }
        if (map.get("vgascroll2hack") != null) {
            this.vgaScroll2Hack = true;
        }
    }
}

