/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.plugins;

import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jpc.Misc;
import org.jpc.emulator.Clock;
import org.jpc.emulator.EventRecorder;
import org.jpc.emulator.PC;
import org.jpc.pluginsbase.Plugin;
import org.jpc.pluginsbase.Plugins;

public class TimeDisplay
implements Plugin {
    private JFrame window;
    private JPanel panel;
    private JLabel display;
    private PC pc;
    private Plugins pluginManager;
    private int nativeWidth;
    private int nativeHeight;

    public void eci_timedisplay_setwinpos(Integer n, Integer n2) {
        Misc.moveWindow(this.window, n, n2, this.nativeWidth, this.nativeHeight);
    }

    public TimeDisplay(Plugins plugins) {
        this.pluginManager = plugins;
        this.pc = null;
        this.window = new JFrame("Time Display" + Misc.emuname);
        this.panel = new JPanel();
        this.window.add(this.panel);
        this.display = new JLabel("Time: <NO PC CONNECTED>           ");
        this.panel.add(this.display);
        this.window.pack();
        this.window.setDefaultCloseOperation(0);
        Dimension dimension = this.window.getSize();
        this.nativeWidth = dimension.width;
        this.nativeHeight = dimension.height;
        this.window.setVisible(true);
    }

    @Override
    public void main() {
    }

    @Override
    public boolean systemShutdown() {
        return true;
    }

    private void updateTime(long l, long l2) {
        String string = l >= 0L ? "Time: " + l / 1000000L + " / " + l2 / 1000000L : (l == -1L ? "Time: <NO PC CONNECTED>" : "Time: <N/A>");
        final String string2 = string;
        if (this.pluginManager.isShuttingDown()) {
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Thread(){

                    @Override
                    public void run() {
                        TimeDisplay.this.display.setText(string2);
                    }
                });
            }
            catch (Exception exception) {}
        } else {
            this.display.setText(string2);
        }
    }

    @Override
    public void pcStarting() {
        this.updateTime(-2L, 0L);
    }

    @Override
    public void pcStopping() {
        PC.ResetButton resetButton = (PC.ResetButton)this.pc.getComponent(PC.ResetButton.class);
        EventRecorder eventRecorder = resetButton.getRecorder();
        long l = eventRecorder.getLastEventTime();
        this.updateTime(((Clock)this.pc.getComponent(Clock.class)).getTime(), l);
    }

    @Override
    public void reconnect(PC pC) {
        this.pc = pC;
        if (this.pc != null) {
            PC.ResetButton resetButton = (PC.ResetButton)this.pc.getComponent(PC.ResetButton.class);
            EventRecorder eventRecorder = resetButton.getRecorder();
            long l = eventRecorder.getLastEventTime();
            this.updateTime(((Clock)this.pc.getComponent(Clock.class)).getTime(), l);
        } else {
            this.updateTime(-1L, 0L);
        }
    }
}

