/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.pluginsaux;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jpc.Misc;
import org.jpc.diskimages.DiskImage;
import org.jpc.emulator.DriveSet;
import org.jpc.emulator.PC;

public class PCConfigDialog
implements ActionListener,
WindowListener {
    private JFrame window;
    private JPanel panel;
    private PC.PCHardwareInfo hw = new PC.PCHardwareInfo();
    private PC.PCHardwareInfo hwr = null;
    private boolean answerReady = false;
    private Map<String, JTextField> settings;
    private Map<String, JComboBox> settings2;
    private Map<String, JCheckBox> settings3;
    private Map<String, Long> settings2Types;
    private Map<String, String[]> settings2Values;
    private JComboBox bootDevice;
    private JComboBox vgaTimingMethod;
    private JComboBox svgaType;

    public void addOption(String string, String string2, String string3) {
        JLabel jLabel = new JLabel(string);
        JTextField jTextField = new JTextField(string3, 40);
        this.settings.put(string2, jTextField);
        this.panel.add(jLabel);
        this.panel.add(jTextField);
    }

    public void addBoolean(String string, String string2) {
        JLabel jLabel = new JLabel(string);
        JCheckBox jCheckBox = new JCheckBox("");
        this.settings3.put(string2, jCheckBox);
        this.panel.add(jLabel);
        this.panel.add(jCheckBox);
    }

    public void addBoolean(String string, String string2, boolean bl) {
        JLabel jLabel = new JLabel(string);
        JCheckBox jCheckBox = new JCheckBox("", bl);
        this.settings3.put(string2, jCheckBox);
        this.panel.add(jLabel);
        this.panel.add(jCheckBox);
    }

    public void addDiskCombo(String string, String string2, long l) throws Exception {
        Object[] objectArray = DiskImage.getLibrary().imagesByType(l);
        JLabel jLabel = new JLabel(string);
        this.panel.add(jLabel);
        if (objectArray != null) {
            Arrays.sort(objectArray);
            this.settings2.put(string2, new JComboBox<Object>(objectArray));
        } else {
            this.settings2.put(string2, new JComboBox());
        }
        this.panel.add(this.settings2.get(string2));
        this.settings2Types.put(string2, new Long(l));
        this.settings2Values.put(string2, (String[])objectArray);
        if (objectArray == null) {
            return;
        }
        if ((l & 0x10L) != 0L && Arrays.binarySearch(objectArray, string2, null) >= 0) {
            this.settings2.get(string2).setSelectedItem(string2);
        }
    }

    public void updateDiskCombo(String string) throws Exception {
        Object[] objectArray = DiskImage.getLibrary().imagesByType(this.settings2Types.get(string));
        if (objectArray == null) {
            throw new Exception("No valid " + string + " image");
        }
        Arrays.sort(objectArray);
        String[] stringArray = this.settings2Values.get(string);
        int n = 0;
        if (stringArray != null) {
            n = stringArray.length;
        }
        JComboBox jComboBox = this.settings2.get(string);
        int n2 = 0;
        int n3 = 0;
        while (n2 < n || n3 < objectArray.length) {
            int n4 = 0;
            n4 = n2 == n ? 1 : (n3 == objectArray.length ? -1 : stringArray[n2].compareTo((String)objectArray[n3]));
            if (n4 < 0) {
                jComboBox.removeItem(stringArray[n2]);
                ++n2;
                continue;
            }
            if (n4 > 0) {
                jComboBox.addItem(objectArray[n3]);
                ++n3;
                continue;
            }
            ++n2;
            ++n3;
        }
        this.settings2Values.put(string, (String[])objectArray);
    }

    public PCConfigDialog() throws Exception {
        this.window = new JFrame("PC Settings");
        this.settings = new HashMap<String, JTextField>();
        this.settings2 = new HashMap<String, JComboBox>();
        this.settings3 = new HashMap<String, JCheckBox>();
        this.settings2Types = new HashMap<String, Long>();
        this.settings2Values = new HashMap<String, String[]>();
        GridLayout gridLayout = new GridLayout(0, 2);
        this.panel = new JPanel(gridLayout);
        this.window.add(this.panel);
        this.window.addWindowListener(this);
        this.addDiskCombo("BIOS image", "BIOS", 16L);
        this.addDiskCombo("VGA BIOS image", "VGABIOS", 16L);
        this.addDiskCombo("Fda image", "FDA", 3L);
        this.addDiskCombo("Fdb image", "FDB", 3L);
        this.addDiskCombo("Hda image", "HDA", 5L);
        this.addDiskCombo("Hdb image", "HDB", 5L);
        this.addDiskCombo("Hdc image", "HDC", 5L);
        this.addDiskCombo("Hdd image", "HDD", 5L);
        this.addDiskCombo("CD-ROM image", "CDROM", 9L);
        this.addOption("Initial RTC time", "INITTIME", "1000000000000");
        this.addOption("CPU freq. divider", "CPUDIVIDER", "50");
        this.addOption("Memory size (4KiB pages)", "MEMSIZE", "4096");
        this.addOption("Modules", "MODULES", "org.jpc.modules.BasicFPU,org.jpc.modules.SoundCard");
        this.addBoolean("Emulate I/O delay", "IOPORTDELAY");
        this.addBoolean("Emulate VGA Hretrace", "VGAHRETRACE");
        this.addBoolean("Shorten pipeline for self-modifying code", "FLUSHONMODIFY");
        this.settings3.get("FLUSHONMODIFY").setSelected(true);
        JLabel jLabel = new JLabel("VGA frame rate method");
        this.vgaTimingMethod = new JComboBox<String>(new String[]{"force constant 60.000 fps", "emulate VGA"});
        JLabel jLabel2 = new JLabel("SVGA card type");
        this.svgaType = new JComboBox<String>(new String[]{"BGA rev.2", "BGA rev.5"});
        this.vgaTimingMethod.setEditable(false);
        this.vgaTimingMethod.setSelectedIndex(1);
        this.svgaType.setEditable(false);
        this.svgaType.setSelectedIndex(1);
        this.panel.add(jLabel);
        this.panel.add(this.vgaTimingMethod);
        this.panel.add(jLabel2);
        this.panel.add(this.svgaType);
        JLabel jLabel3 = new JLabel("Boot device");
        this.bootDevice = new JComboBox<String>(new String[]{"fda", "hda", "cdrom"});
        this.bootDevice.setEditable(false);
        this.panel.add(jLabel3);
        this.panel.add(this.bootDevice);
        JButton jButton = new JButton("Assemble");
        jButton.setActionCommand("ASSEMBLE");
        jButton.addActionListener(this);
        JButton jButton2 = new JButton("Cancel");
        jButton2.setActionCommand("CANCEL");
        jButton2.addActionListener(this);
        this.panel.add(jButton);
        this.panel.add(jButton2);
        this.window.pack();
        this.window.setDefaultCloseOperation(0);
    }

    public void popUp() throws Exception {
        this.updateDiskCombo("BIOS");
        this.updateDiskCombo("VGABIOS");
        this.updateDiskCombo("FDA");
        this.updateDiskCombo("FDB");
        this.updateDiskCombo("HDA");
        this.updateDiskCombo("HDB");
        this.updateDiskCombo("HDC");
        this.updateDiskCombo("HDD");
        this.updateDiskCombo("CDROM");
        this.window.setVisible(true);
    }

    public synchronized PC.PCHardwareInfo waitClose() {
        if (this.answerReady) {
            this.answerReady = false;
            return this.hwr;
        }
        while (!this.answerReady) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.answerReady = false;
        return this.hwr;
    }

    private String textFor(String string) {
        String string2 = null;
        if (this.settings.containsKey(string)) {
            string2 = this.settings.get(string).getText();
        }
        if (string2 == null) {
            string2 = (String)this.settings2.get(string).getSelectedItem();
        }
        if (!"".equals(string2)) {
            return string2;
        }
        return null;
    }

    private boolean booleanValue(String string) {
        boolean bl = false;
        if (this.settings3.containsKey(string)) {
            bl = this.settings3.get(string).isSelected();
        }
        return bl;
    }

    private boolean checkOK() {
        try {
            Object object;
            Object object2;
            String string = this.textFor("BIOS");
            this.hw.biosID = DiskImage.getLibrary().canonicalNameFor(string);
            if (this.hw.biosID == null) {
                throw new IOException("Can't find image \"" + string + "\".");
            }
            String string2 = this.textFor("VGABIOS");
            this.hw.vgaBIOSID = DiskImage.getLibrary().canonicalNameFor(string2);
            if (this.hw.vgaBIOSID == null) {
                throw new IOException("Can't find image \"" + string2 + "\".");
            }
            String string3 = this.textFor("HDA");
            this.hw.hdaID = DiskImage.getLibrary().canonicalNameFor(string3);
            if (this.hw.hdaID == null && string3 != null) {
                throw new IOException("Can't find image \"" + string3 + "\".");
            }
            String string4 = this.textFor("HDB");
            this.hw.hdbID = DiskImage.getLibrary().canonicalNameFor(string4);
            if (this.hw.hdbID == null && string4 != null) {
                throw new IOException("Can't find image \"" + string4 + "\".");
            }
            String string5 = this.textFor("HDC");
            this.hw.hdcID = DiskImage.getLibrary().canonicalNameFor(string5);
            if (this.hw.hdcID == null && string5 != null) {
                throw new IOException("Can't find image \"" + string5 + "\".");
            }
            String string6 = this.textFor("HDD");
            this.hw.hddID = DiskImage.getLibrary().canonicalNameFor(string6);
            if (this.hw.hddID == null && string6 != null) {
                throw new IOException("Can't find image \"" + string6 + "\".");
            }
            String string7 = this.textFor("CDROM");
            if (string7 != null) {
                if (string5 != null) {
                    throw new IOException("-hdc and -cdrom are mutually exclusive.");
                }
                this.hw.initCDROMIndex = this.hw.images.addDisk(new DiskImage(string7, false));
                this.hw.images.lookupDisk(this.hw.initCDROMIndex).setName(string7 + " (initial cdrom disk)");
            } else {
                this.hw.initCDROMIndex = -1;
            }
            String string8 = this.textFor("FDA");
            if (string8 != null) {
                object2 = DiskImage.getLibrary().canonicalNameFor(string8);
                if (object2 == null && string8 != null) {
                    throw new IOException("Can't find image \"" + string8 + "\".");
                }
                this.hw.initFDAIndex = this.hw.images.addDisk(new DiskImage(string8, false));
                this.hw.images.lookupDisk(this.hw.initFDAIndex).setName(string8 + " (initial fda disk)");
            } else {
                this.hw.initFDAIndex = -1;
            }
            object2 = this.textFor("FDB");
            if (object2 != null) {
                object = DiskImage.getLibrary().canonicalNameFor((String)object2);
                if (object == null && object2 != null) {
                    throw new IOException("Can't find image \"" + (String)object2 + "\".");
                }
                this.hw.initFDBIndex = this.hw.images.addDisk(new DiskImage((String)object2, false));
                this.hw.images.lookupDisk(this.hw.initFDBIndex).setName((String)object2 + " (initial fdb disk)");
            } else {
                this.hw.initFDBIndex = -1;
            }
            object = this.textFor("INITTIME");
            try {
                this.hw.initRTCTime = Long.parseLong((String)object, 10);
                if (this.hw.initRTCTime < 0L || this.hw.initRTCTime > 4102444799999L) {
                    throw new Exception("Invalid time value (bounds are 0 and 4102444799999).");
                }
            }
            catch (Exception exception) {
                if (object != null) {
                    throw exception;
                }
                this.hw.initRTCTime = 1000000000000L;
            }
            String string9 = this.textFor("CPUDIVIDER");
            try {
                this.hw.cpuDivider = Integer.parseInt(string9, 10);
                if (this.hw.cpuDivider < 1 || this.hw.cpuDivider > 256) {
                    throw new Exception("Invalid CPU divider value (bounds are 1 and 256).");
                }
            }
            catch (Exception exception) {
                if (string9 != null) {
                    throw exception;
                }
                this.hw.cpuDivider = 50;
            }
            this.hw.fpuEmulator = null;
            String string10 = this.textFor("MEMSIZE");
            try {
                this.hw.memoryPages = Integer.parseInt(string10, 10);
                if (this.hw.memoryPages < 256 || this.hw.memoryPages > 262144) {
                    throw new Exception("Invalid memory size value (bounds are 256 and 262144).");
                }
            }
            catch (Exception exception) {
                if (string10 != null) {
                    throw exception;
                }
                this.hw.memoryPages = 4096;
            }
            String string11 = (String)this.bootDevice.getSelectedItem();
            if ((string11 = string11.toLowerCase()).equals("fda")) {
                this.hw.bootType = DriveSet.BootType.FLOPPY;
            } else if (string11.equals("hda")) {
                this.hw.bootType = DriveSet.BootType.HARD_DRIVE;
            } else if (string11.equals("cdrom")) {
                this.hw.bootType = DriveSet.BootType.CDROM;
            }
            String string12 = this.textFor("MODULES");
            if (string12 != null) {
                this.hw.hwModules = PC.parseHWModules(string12);
            }
            this.hw.booleanOptions = new TreeMap<String, Boolean>();
            this.hw.intOptions = new TreeMap<String, Integer>();
            for (Map.Entry<String, JCheckBox> entry : this.settings3.entrySet()) {
                this.hw.booleanOptions.put(entry.getKey(), this.booleanValue(entry.getKey()));
            }
            this.hw.intOptions.put("VGATIMINGMETHOD", this.vgaTimingMethod.getSelectedIndex());
            this.hw.intOptions.put("SVGATYPE", this.svgaType.getSelectedIndex());
        }
        catch (Exception exception) {
            Misc.errorDialog(exception, "Problem with settings.", this.window, "Dismiss");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "ASSEMBLE") {
            if (!this.checkOK()) {
                this.hw = new PC.PCHardwareInfo();
                return;
            }
            this.window.setVisible(false);
            PCConfigDialog pCConfigDialog = this;
            synchronized (pCConfigDialog) {
                this.hwr = this.hw;
                this.answerReady = true;
                this.notifyAll();
                this.hw = new PC.PCHardwareInfo();
            }
            this.hw = new PC.PCHardwareInfo();
        } else if (string == "CANCEL") {
            this.window.setVisible(false);
            PCConfigDialog pCConfigDialog = this;
            synchronized (pCConfigDialog) {
                this.hwr = null;
                this.answerReady = true;
                this.notifyAll();
            }
        }
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.window.setVisible(false);
        PCConfigDialog pCConfigDialog = this;
        synchronized (pCConfigDialog) {
            this.hwr = null;
            this.answerReady = true;
            this.notifyAll();
        }
    }
}

