/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.pluginsaux;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import org.jpc.Misc;
import org.jpc.emulator.PC;
import org.jpc.output.OutputClient;
import org.jpc.output.OutputFrame;
import org.jpc.output.OutputFrameImage;
import org.jpc.output.OutputStatic;
import org.jpc.pluginsaux.HUDRenderer;
import org.jpc.pluginsaux.PCMonitorPanelEmbedder;
import org.jpc.pluginsaux.PNGSaver;

public class PCMonitorPanel
implements ActionListener,
MouseListener {
    private static final long serialVersionUID = 6L;
    private OutputStatic outputServer;
    private PC pc;
    private OutputClient outputClient;
    private volatile boolean signalCheck;
    private BufferedImage buffer;
    private int ssSeq;
    private int[] renderBuffer;
    private int renderBufferW;
    private int renderBufferH;
    private int[] rawImageData;
    private int screenWidth;
    private int screenHeight;
    private MonitorPanel monitorPanel = new MonitorPanel();
    private Thread monitorThread;
    private HUDRenderer renderer;
    private PCMonitorPanelEmbedder embedder;
    private List<JMenu> menusNeeded;
    private OutputFrameImage lastFrame;
    private volatile boolean clearBackground = true;

    public PCMonitorPanel(PCMonitorPanelEmbedder pCMonitorPanelEmbedder, OutputStatic outputStatic) {
        this.monitorPanel.setDoubleBuffered(false);
        this.monitorPanel.requestFocusInWindow();
        this.outputServer = outputStatic;
        this.outputClient = new OutputClient(outputStatic);
        this.monitorPanel.setInputMap(0, null);
        this.embedder = pCMonitorPanelEmbedder;
        this.renderer = new HUDRenderer(1);
        this.embedder.notifyRenderer(this.renderer);
        this.menusNeeded = new ArrayList<JMenu>();
        JMenu jMenu = new JMenu("Gain");
        this.menusNeeded.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("1x");
        jMenuItem.setActionCommand("LAMP1X");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("2x");
        jMenuItem.setActionCommand("LAMP2X");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("4x");
        jMenuItem.setActionCommand("LAMP4X");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("8x");
        jMenuItem.setActionCommand("LAMP8X");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("16x");
        jMenuItem.setActionCommand("LAMP16X");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("32x");
        jMenuItem.setActionCommand("LAMP32X");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenu = new JMenu("Screenshot");
        this.menusNeeded.add(jMenu);
        jMenuItem = new JMenuItem("VGA output buffer");
        jMenuItem.setActionCommand("SSVGAOUT");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("render buffer");
        jMenuItem.setActionCommand("SSRENDER");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        this.monitorPanel.addMouseListener(this);
        this.resizeDisplay(480, 360, true);
    }

    public void eci_screenshot_vgabuffer() {
        this.screenShot(false);
    }

    public void eci_screenshot_renderbuffer() {
        this.screenShot(true);
    }

    public List<JMenu> getMenusNeeded() {
        return this.menusNeeded;
    }

    public JPanel getMonitorPanel() {
        return this.monitorPanel;
    }

    public void startThread() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                PCMonitorPanel.this.main();
            }
        }, "Monitor Panel Thread").start();
    }

    public void setPC(PC pC) {
        this.pc = pC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void main() {
        this.monitorThread = Thread.currentThread();
        while (true) {
            PCMonitorPanel pCMonitorPanel = this;
            synchronized (pCMonitorPanel) {
                if (this.outputClient.aquire()) {
                    OutputFrame outputFrame = this.outputServer.lastFrame(OutputFrameImage.class);
                    if (outputFrame == null) {
                        this.outputClient.releaseWaitAll();
                        continue;
                    }
                    this.lastFrame = (OutputFrameImage)outputFrame;
                    int n = this.lastFrame.getWidth();
                    int n2 = this.lastFrame.getHeight();
                    this.embedder.notifyFrameReceived(n, n2);
                    int[] nArray = this.lastFrame.getImageData();
                    this.renderer.setBackground(nArray, n, n2);
                    this.outputClient.releaseWaitAll();
                    n = this.renderBufferW = this.renderer.getRenderWidth();
                    n2 = this.renderBufferH = this.renderer.getRenderHeight();
                    this.renderBuffer = this.renderer.getFinishedAndReset();
                    if (n > 0 && n2 > 0 && (n != this.screenWidth || n2 != this.screenHeight)) {
                        this.resizeDisplay(n, n2, false);
                        this.embedder.notifySizeChange(n, n2);
                    }
                    if (this.renderBuffer == null) {
                        continue;
                    }
                    for (int i = 0; i < n2; ++i) {
                        int n3 = i * n;
                        if (n <= 0) continue;
                        System.arraycopy(this.renderBuffer, n3, this.rawImageData, n3, n);
                    }
                    this.monitorPanel.repaint(0, 0, n, n2);
                }
            }
        }
    }

    public void resizeDisplay(int n, int n2, boolean bl) {
        this.monitorPanel.setPreferredSize(new Dimension(n, n2));
        this.monitorPanel.setMaximumSize(new Dimension(n, n2));
        this.monitorPanel.setMinimumSize(new Dimension(n, n2));
        if (n > 0 && n2 > 0) {
            this.buffer = new BufferedImage(n, n2, 1);
            this.buffer.setAccelerationPriority(1.0f);
            DataBufferInt dataBufferInt = (DataBufferInt)this.buffer.getRaster().getDataBuffer();
            this.rawImageData = dataBufferInt.getData();
        }
        this.screenWidth = n;
        this.screenHeight = n2;
        this.clearBackground = true;
        this.monitorPanel.revalidate();
        if (bl) {
            this.monitorPanel.repaint(0, 0, this.screenWidth, this.screenHeight);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == null) {
            return;
        }
        if (string.equals("LAMP1X")) {
            this.renderer.setLightAmplification(1);
        }
        if (string.equals("LAMP2X")) {
            this.renderer.setLightAmplification(2);
        }
        if (string.equals("LAMP4X")) {
            this.renderer.setLightAmplification(4);
        }
        if (string.equals("LAMP8X")) {
            this.renderer.setLightAmplification(8);
        }
        if (string.equals("LAMP16X")) {
            this.renderer.setLightAmplification(16);
        }
        if (string.equals("LAMP32X")) {
            this.renderer.setLightAmplification(32);
        }
        if (string.equals("SSVGAOUT")) {
            this.screenShot(false);
        }
        if (string.equals("SSRENDER")) {
            this.screenShot(true);
        }
    }

    private void screenShot(boolean bl) {
        int n = 0;
        int n2 = 0;
        int[] nArray = null;
        if (bl) {
            n = this.renderBufferW;
            n2 = this.renderBufferH;
            nArray = this.renderBuffer;
        } else if (this.lastFrame != null && (n = this.lastFrame.getWidth()) * (n2 = this.lastFrame.getHeight()) > (nArray = this.lastFrame.getImageData()).length) {
            System.err.println("Error: Can't get stable VGA output buffer.");
            return;
        }
        if (nArray == null || n == 0 || n2 == 0) {
            System.err.println("Error: No image to screenshot.");
            return;
        }
        String string = "Screenshot-" + System.currentTimeMillis() + "-" + this.ssSeq++ + ".png";
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(string));
            PNGSaver.savePNG(dataOutputStream, nArray, n, n2);
            dataOutputStream.close();
        }
        catch (Exception exception) {
            Misc.errorDialog(exception, "Can't save screenshot", null, "Dismiss");
        }
        System.err.println("Informative: Screenshot '" + string + "' saved.");
    }

    private int getButtonNumber(MouseEvent mouseEvent) {
        int n = mouseEvent.getButton();
        if (n == 1) {
            return 1;
        }
        if (n == 2) {
            return 2;
        }
        if (n == 3) {
            return 3;
        }
        return 0;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n = this.getButtonNumber(mouseEvent);
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        this.embedder.sendMessage("MouseClicked " + n + " " + n2 + " " + n3);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        int n = this.getButtonNumber(mouseEvent);
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        this.embedder.sendMessage("MousePressed " + n + " " + n2 + " " + n3);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        int n = this.getButtonNumber(mouseEvent);
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        this.embedder.sendMessage("MouseReleased " + n + " " + n2 + " " + n3);
    }

    public class MonitorPanel
    extends JPanel {
        private static final long serialVersionUID = 9L;

        @Override
        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        @Override
        public void paint(Graphics graphics) {
            Dimension dimension;
            int n;
            int n2;
            if (PCMonitorPanel.this.screenHeight > 0 && PCMonitorPanel.this.screenWidth > 0) {
                n2 = PCMonitorPanel.this.screenWidth;
                n = PCMonitorPanel.this.screenHeight;
            } else {
                dimension = this.getSize();
                n2 = dimension.width;
                n = dimension.height;
            }
            if (PCMonitorPanel.this.clearBackground) {
                graphics.setColor(Color.white);
                dimension = this.getSize();
                if (dimension.width > n2) {
                    graphics.fillRect(n2, 0, dimension.width - n2, dimension.height);
                }
                if (dimension.height > n) {
                    graphics.fillRect(0, n, dimension.width, dimension.height - n);
                }
                PCMonitorPanel.this.clearBackground = false;
            }
            graphics.drawImage(PCMonitorPanel.this.buffer, 0, 0, null);
            dimension = this.getSize();
            graphics.setColor(this.getBackground());
            graphics.fillRect(n2, 0, dimension.width - n2, n);
            graphics.fillRect(0, n, dimension.width, dimension.height - n);
        }
    }
}

