/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.pluginsaux;

import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import org.jpc.Misc;

public class PNGSaver {
    private int sequenceNumber;
    private String prefix;
    private static final int NUMBERS = 12;
    private String lastName;

    public PNGSaver(String string) {
        this.prefix = string;
        this.sequenceNumber = 0;
    }

    public String lastPNGName() {
        return this.lastName;
    }

    public static String numberToString(int n, int n2) {
        if (n2 == 0) {
            return "";
        }
        return PNGSaver.numberToString(n / 10, n2 - 1) + n % 10;
    }

    public static String numberToString(int n) {
        return PNGSaver.numberToString(n, 12);
    }

    public void savePNG(int[] nArray, int n, int n2) throws IOException {
        this.lastName = this.prefix + PNGSaver.numberToString(this.sequenceNumber) + ".png";
        PNGSaver.savePNG(this.lastName, nArray, n, n2);
        ++this.sequenceNumber;
    }

    public static void savePNG(String string, int[] nArray, int n, int n2) throws IOException {
        File file = new File(string);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        DataOutputStream dataOutputStream = new DataOutputStream(bufferedOutputStream);
        PNGSaver.savePNG(dataOutputStream, nArray, n, n2);
        bufferedOutputStream.flush();
    }

    private static void flushChunk(DataOutput dataOutput, int n, byte[] byArray, int n2) throws IOException {
        byte[] byArray2 = new byte[4];
        CRC32 cRC32 = new CRC32();
        if (n2 < 0 && byArray != null) {
            n2 = byArray.length;
        }
        if (byArray != null) {
            dataOutput.writeInt(n2);
        } else {
            dataOutput.writeInt(0);
        }
        byArray2[0] = (byte)(n >>> 24 & 0xFF);
        byArray2[1] = (byte)(n >>> 16 & 0xFF);
        byArray2[2] = (byte)(n >>> 8 & 0xFF);
        byArray2[3] = (byte)(n & 0xFF);
        dataOutput.write(byArray2);
        cRC32.update(byArray2);
        if (byArray != null) {
            dataOutput.write(byArray, 0, n2);
            cRC32.update(byArray, 0, n2);
        }
        int n3 = (int)cRC32.getValue();
        dataOutput.writeInt(n3);
    }

    public static void savePNG(DataOutput dataOutput, int[] nArray, int n, int n2) throws IOException {
        byte[] byArray = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        int n3 = 1229472850;
        int n4 = 1229278788;
        int n5 = 1229209940;
        int n6 = 32768;
        int n7 = 10000;
        byte[] byArray2 = new byte[n7];
        byte[] byArray3 = new byte[]{25, 25, 25, 25, 25, 25, 25, 25, 8, 2, 0, 0, 0};
        byte[] byArray4 = new byte[n6];
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        boolean bl = false;
        boolean bl2 = false;
        Deflater deflater = new Deflater();
        dataOutput.write(byArray);
        if (n == 0) {
            n = 720;
        }
        if (n2 == 0) {
            n2 = 400;
        }
        if (n * n2 > nArray.length) {
            System.err.println("Warning: Invalid video input data.");
            nArray = new int[n * n2];
        }
        byArray3[0] = (byte)(n >>> 24 & 0xFF);
        byArray3[1] = (byte)(n >>> 16 & 0xFF);
        byArray3[2] = (byte)(n >>> 8 & 0xFF);
        byArray3[3] = (byte)(n & 0xFF);
        byArray3[4] = (byte)(n2 >>> 24 & 0xFF);
        byArray3[5] = (byte)(n2 >>> 16 & 0xFF);
        byArray3[6] = (byte)(n2 >>> 8 & 0xFF);
        byArray3[7] = (byte)(n2 & 0xFF);
        PNGSaver.flushChunk(dataOutput, n3, byArray3, -1);
        while (!deflater.finished()) {
            if (deflater.needsInput()) {
                if (n9 == n * n2) {
                    if (!bl2) {
                        deflater.finish();
                    }
                    bl2 = true;
                } else {
                    int n11 = 0;
                    while (n11 < n7 && n9 < n * n2) {
                        if (n9 % n == 0 && !bl) {
                            byArray2[n11++] = 0;
                            bl = true;
                        }
                        if (n11 > n7 - 3) break;
                        bl = false;
                        byArray2[n11++] = (byte)(nArray[n9] >> 16 & 0xFF);
                        byArray2[n11++] = (byte)(nArray[n9] >> 8 & 0xFF);
                        byArray2[n11++] = (byte)(nArray[n9] & 0xFF);
                        ++n9;
                    }
                    n10 += n11;
                    deflater.setInput(byArray2, 0, n11);
                }
            }
            if (n8 == n6) {
                PNGSaver.flushChunk(dataOutput, n5, byArray4, -1);
                n8 = 0;
                continue;
            }
            n8 += deflater.deflate(byArray4, n8, n6 - n8);
        }
        if (n8 > 0) {
            PNGSaver.flushChunk(dataOutput, n5, byArray4, n8);
            n8 = 0;
        }
        PNGSaver.flushChunk(dataOutput, n4, null, -1);
    }

    public static void main(String[] stringArray) {
        int n;
        int[] nArray = new int[196608];
        for (n = 0; n < 65536; ++n) {
            nArray[n] = 65536 * (n / 256) + 256 * (n % 256);
        }
        for (n = 0; n < 65536; ++n) {
            nArray[n + 65536] = 256 * (n / 256) + n % 256;
        }
        for (n = 0; n < 65536; ++n) {
            nArray[n + 131072] = 65536 * (n / 256) + n % 256;
        }
        try {
            PNGSaver.savePNG("test.png", nArray, 256, 256);
        }
        catch (Exception exception) {
            Misc.errorDialog(exception, "Failed to save test PNG", null, "Quit");
        }
    }
}

