/*
 * Decompiled with CFR 0.152.
 */
package mnj.lua;

import java.util.Hashtable;
import mnj.lua.BlockCnt;
import mnj.lua.Expdesc;
import mnj.lua.LocVar;
import mnj.lua.Lua;
import mnj.lua.Proto;
import mnj.lua.Syntax;

final class FuncState {
    static final int NO_JUMP = -1;
    Proto f;
    Hashtable<Object, Object> h = new Hashtable();
    FuncState prev;
    Syntax ls;
    Lua L;
    BlockCnt bl;
    int pc;
    int lasttarget = -1;
    int jpc = -1;
    int freereg;
    int nk;
    int np;
    short nlocvars;
    short nactvar;
    int[] upvalues = new int[60];
    short[] actvar = new short[200];
    private static final int OP_ARG_N = 0;
    private static final int OP_ARG_U = 1;
    private static final int OP_ARG_R = 2;
    private static final int OP_ARG_K = 3;
    private static final int iABC = 0;
    private static final int iABx = 1;
    private static final int iAsBx = 2;
    private static final byte[] OPMODE = new byte[]{FuncState.opmode(0, 1, 2, 0, 0), FuncState.opmode(0, 1, 3, 0, 1), FuncState.opmode(0, 1, 1, 1, 0), FuncState.opmode(0, 1, 2, 0, 0), FuncState.opmode(0, 1, 1, 0, 0), FuncState.opmode(0, 1, 3, 0, 1), FuncState.opmode(0, 1, 2, 3, 0), FuncState.opmode(0, 0, 3, 0, 1), FuncState.opmode(0, 0, 1, 0, 0), FuncState.opmode(0, 0, 3, 3, 0), FuncState.opmode(0, 1, 1, 1, 0), FuncState.opmode(0, 1, 2, 3, 0), FuncState.opmode(0, 1, 3, 3, 0), FuncState.opmode(0, 1, 3, 3, 0), FuncState.opmode(0, 1, 3, 3, 0), FuncState.opmode(0, 1, 3, 3, 0), FuncState.opmode(0, 1, 3, 3, 0), FuncState.opmode(0, 1, 3, 3, 0), FuncState.opmode(0, 1, 2, 0, 0), FuncState.opmode(0, 1, 2, 0, 0), FuncState.opmode(0, 1, 2, 0, 0), FuncState.opmode(0, 1, 2, 2, 0), FuncState.opmode(0, 0, 2, 0, 2), FuncState.opmode(1, 0, 3, 3, 0), FuncState.opmode(1, 0, 3, 3, 0), FuncState.opmode(1, 0, 3, 3, 0), FuncState.opmode(1, 1, 2, 1, 0), FuncState.opmode(1, 1, 2, 1, 0), FuncState.opmode(0, 1, 1, 1, 0), FuncState.opmode(0, 1, 1, 1, 0), FuncState.opmode(0, 0, 1, 0, 0), FuncState.opmode(0, 1, 2, 0, 2), FuncState.opmode(0, 1, 2, 0, 2), FuncState.opmode(1, 0, 0, 1, 0), FuncState.opmode(0, 0, 1, 1, 0), FuncState.opmode(0, 0, 0, 0, 0), FuncState.opmode(0, 1, 1, 0, 1), FuncState.opmode(0, 1, 1, 0, 0)};

    FuncState(Syntax syntax) {
        this.f = new Proto(syntax.source, 2);
        this.L = syntax.L;
        this.ls = syntax;
    }

    void close() {
        this.f.closeCode(this.pc);
        this.f.closeLineinfo(this.pc);
        this.f.closeK(this.nk);
        this.f.closeP(this.np);
        this.f.closeLocvars(this.nlocvars);
        this.f.closeUpvalues();
        this.L.gCheckcode(this.f);
    }

    LocVar getlocvar(int n) {
        return this.f.locvars[this.actvar[n]];
    }

    void kCheckstack(int n) {
        int n2 = this.freereg + n;
        if (n2 > this.f.maxstacksize()) {
            if (n2 >= 250) {
                this.ls.xSyntaxerror("function or expression too complex");
            }
            this.f.setMaxstacksize(n2);
        }
    }

    int kCode(int n, int n2) {
        this.dischargejpc();
        this.f.codeAppend(this.L, this.pc, n, n2);
        return this.pc++;
    }

    int kCodeABC(int n, int n2, int n3, int n4) {
        return this.kCode(Lua.CREATE_ABC(n, n2, n3, n4), this.ls.lastline());
    }

    int kCodeABx(int n, int n2, int n3) {
        return this.kCode(Lua.CREATE_ABx(n, n2, n3), this.ls.lastline());
    }

    int kCodeAsBx(int n, int n2, int n3) {
        return this.kCodeABx(n, n2, n3 + 131071);
    }

    void kDischargevars(Expdesc expdesc) {
        switch (expdesc.kind()) {
            case 6: {
                expdesc.setKind(12);
                break;
            }
            case 7: {
                expdesc.reloc(this.kCodeABC(4, 0, expdesc.info, 0));
                break;
            }
            case 8: {
                expdesc.reloc(this.kCodeABx(5, 0, expdesc.info));
                break;
            }
            case 9: {
                this.freereg(expdesc.aux());
                this.freereg(expdesc.info());
                expdesc.reloc(this.kCodeABC(6, 0, expdesc.info, expdesc.aux));
                break;
            }
            case 13: 
            case 14: {
                this.kSetoneret(expdesc);
                break;
            }
        }
    }

    int kExp2anyreg(Expdesc expdesc) {
        this.kDischargevars(expdesc);
        if (expdesc.k == 12) {
            if (!expdesc.hasjumps()) {
                return expdesc.info;
            }
            if (expdesc.info >= this.nactvar) {
                this.exp2reg(expdesc, expdesc.info);
                return expdesc.info;
            }
        }
        this.kExp2nextreg(expdesc);
        return expdesc.info;
    }

    void kExp2nextreg(Expdesc expdesc) {
        this.kDischargevars(expdesc);
        this.freeexp(expdesc);
        this.kReserveregs(1);
        this.exp2reg(expdesc, this.freereg - 1);
    }

    void kFixline(int n) {
        this.f.setLineinfo(this.pc - 1, n);
    }

    void kInfix(int n, Expdesc expdesc) {
        switch (n) {
            case 13: {
                this.kGoiftrue(expdesc);
                break;
            }
            case 14: {
                this.kGoiffalse(expdesc);
                break;
            }
            case 6: {
                this.kExp2nextreg(expdesc);
                break;
            }
            default: {
                if (this.isnumeral(expdesc)) break;
                this.kExp2RK(expdesc);
            }
        }
    }

    private boolean isnumeral(Expdesc expdesc) {
        return expdesc.k == 5 && expdesc.t == -1 && expdesc.f == -1;
    }

    void kNil(int n, int n2) {
        if (this.pc > this.lasttarget) {
            if (this.pc == 0) {
                return;
            }
            int n3 = this.pc - 1;
            int n4 = this.f.code[n3];
            if (Lua.OPCODE(n4) == 3) {
                int n5 = Lua.ARGA(n4);
                int n6 = Lua.ARGB(n4);
                if (n5 <= n && n <= n6 + 1) {
                    if (n + n2 - 1 > n6) {
                        this.f.code[n3] = Lua.SETARG_B(n4, n + n2 - 1);
                    }
                    return;
                }
            }
        }
        this.kCodeABC(3, n, n + n2 - 1, 0);
    }

    int kNumberK(double d) {
        return this.addk(Lua.valueOfNumber(d));
    }

    void kPosfix(int n, Expdesc expdesc, Expdesc expdesc2) {
        switch (n) {
            case 13: {
                this.kDischargevars(expdesc2);
                expdesc2.f = this.kConcat(expdesc2.f, expdesc.f);
                expdesc.init(expdesc2);
                break;
            }
            case 14: {
                this.kDischargevars(expdesc2);
                expdesc2.t = this.kConcat(expdesc2.t, expdesc.t);
                expdesc.init(expdesc2);
                break;
            }
            case 6: {
                this.kExp2val(expdesc2);
                if (expdesc2.k == 11 && Lua.OPCODE(this.getcode(expdesc2)) == 21) {
                    this.freeexp(expdesc);
                    this.setcode(expdesc2, Lua.SETARG_B(this.getcode(expdesc2), expdesc.info));
                    expdesc.k = expdesc2.k;
                    expdesc.info = expdesc2.info;
                    break;
                }
                this.kExp2nextreg(expdesc2);
                this.codearith(21, expdesc, expdesc2);
                break;
            }
            case 0: {
                this.codearith(12, expdesc, expdesc2);
                break;
            }
            case 1: {
                this.codearith(13, expdesc, expdesc2);
                break;
            }
            case 2: {
                this.codearith(14, expdesc, expdesc2);
                break;
            }
            case 3: {
                this.codearith(15, expdesc, expdesc2);
                break;
            }
            case 4: {
                this.codearith(16, expdesc, expdesc2);
                break;
            }
            case 5: {
                this.codearith(17, expdesc, expdesc2);
                break;
            }
            case 8: {
                this.codecomp(23, true, expdesc, expdesc2);
                break;
            }
            case 7: {
                this.codecomp(23, false, expdesc, expdesc2);
                break;
            }
            case 9: {
                this.codecomp(24, true, expdesc, expdesc2);
                break;
            }
            case 10: {
                this.codecomp(25, true, expdesc, expdesc2);
                break;
            }
            case 11: {
                this.codecomp(24, false, expdesc, expdesc2);
                break;
            }
            case 12: {
                this.codecomp(25, false, expdesc, expdesc2);
                break;
            }
        }
    }

    void kPrefix(int n, Expdesc expdesc) {
        Expdesc expdesc2 = new Expdesc(5, 0);
        switch (n) {
            case 0: {
                if (expdesc.kind() == 4) {
                    this.kExp2anyreg(expdesc);
                }
                this.codearith(18, expdesc, expdesc2);
                break;
            }
            case 1: {
                this.codenot(expdesc);
                break;
            }
            case 2: {
                this.kExp2anyreg(expdesc);
                this.codearith(20, expdesc, expdesc2);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    void kReserveregs(int n) {
        this.kCheckstack(n);
        this.freereg += n;
    }

    void kRet(int n, int n2) {
        this.kCodeABC(30, n, n2 + 1, 0);
    }

    void kSetmultret(Expdesc expdesc) {
        this.kSetreturns(expdesc, -1);
    }

    void kSetoneret(Expdesc expdesc) {
        if (expdesc.kind() == 13) {
            expdesc.nonreloc(Lua.ARGA(this.getcode(expdesc)));
        } else if (expdesc.kind() == 14) {
            this.setargb(expdesc, 2);
            expdesc.setKind(11);
        }
    }

    void kSetreturns(Expdesc expdesc, int n) {
        if (expdesc.kind() == 13) {
            this.setargc(expdesc, n + 1);
        } else if (expdesc.kind() == 14) {
            this.setargb(expdesc, n + 1);
            this.setarga(expdesc, this.freereg);
            this.kReserveregs(1);
        }
    }

    int kStringK(String string) {
        return this.addk(string.intern());
    }

    private int addk(Object object) {
        Object object2 = object;
        Object object3 = this.h.get(object2);
        if (object3 != null) {
            return (Integer)object3;
        }
        this.f.constantAppend(this.nk, object);
        this.h.put(object2, new Integer(this.nk));
        return this.nk++;
    }

    private void codearith(int n, Expdesc expdesc, Expdesc expdesc2) {
        if (this.constfolding(n, expdesc, expdesc2)) {
            return;
        }
        int n2 = this.kExp2RK(expdesc);
        int n3 = n != 18 && n != 20 ? this.kExp2RK(expdesc2) : 0;
        this.freeexp(expdesc2);
        this.freeexp(expdesc);
        expdesc.info = this.kCodeABC(n, 0, n2, n3);
        expdesc.k = 11;
    }

    private boolean constfolding(int n, Expdesc expdesc, Expdesc expdesc2) {
        double d;
        if (!this.isnumeral(expdesc) || !this.isnumeral(expdesc2)) {
            return false;
        }
        double d2 = expdesc.nval;
        double d3 = expdesc2.nval;
        switch (n) {
            case 12: {
                d = d2 + d3;
                break;
            }
            case 13: {
                d = d2 - d3;
                break;
            }
            case 14: {
                d = d2 * d3;
                break;
            }
            case 15: {
                if (d3 == 0.0) {
                    return false;
                }
                d = d2 / d3;
                break;
            }
            case 16: {
                if (d3 == 0.0) {
                    return false;
                }
                d = d2 % d3;
                break;
            }
            case 17: {
                d = Lua.iNumpow(d2, d3);
                break;
            }
            case 18: {
                d = -d2;
                break;
            }
            case 20: {
                return false;
            }
            default: {
                d = 0.0;
            }
        }
        if (Double.isNaN(d)) {
            return false;
        }
        expdesc.nval = d;
        return true;
    }

    private void codenot(Expdesc expdesc) {
        this.kDischargevars(expdesc);
        switch (expdesc.k) {
            case 1: 
            case 3: {
                expdesc.k = 2;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                expdesc.k = 3;
                break;
            }
            case 10: {
                this.invertjump(expdesc);
                break;
            }
            case 11: 
            case 12: {
                this.discharge2anyreg(expdesc);
                this.freeexp(expdesc);
                expdesc.info = this.kCodeABC(19, 0, expdesc.info, 0);
                expdesc.k = 11;
                break;
            }
        }
        int n = expdesc.f;
        expdesc.f = expdesc.t;
        expdesc.t = n;
        this.removevalues(expdesc.f);
        this.removevalues(expdesc.t);
    }

    private void removevalues(int n) {
        while (n != -1) {
            this.patchtestreg(n, 255);
            n = this.getjump(n);
        }
    }

    private void dischargejpc() {
        this.patchlistaux(this.jpc, this.pc, 255, this.pc);
        this.jpc = -1;
    }

    private void discharge2reg(Expdesc expdesc, int n) {
        this.kDischargevars(expdesc);
        switch (expdesc.k) {
            case 1: {
                this.kNil(n, 1);
                break;
            }
            case 2: 
            case 3: {
                this.kCodeABC(2, n, expdesc.k == 2 ? 1 : 0, 0);
                break;
            }
            case 4: {
                this.kCodeABx(1, n, expdesc.info);
                break;
            }
            case 5: {
                this.kCodeABx(1, n, this.kNumberK(expdesc.nval));
                break;
            }
            case 11: {
                this.setarga(expdesc, n);
                break;
            }
            case 12: {
                if (n == expdesc.info) break;
                this.kCodeABC(0, n, expdesc.info, 0);
                break;
            }
            case 0: 
            case 10: {
                return;
            }
        }
        expdesc.nonreloc(n);
    }

    private void exp2reg(Expdesc expdesc, int n) {
        this.discharge2reg(expdesc, n);
        if (expdesc.k == 10) {
            expdesc.t = this.kConcat(expdesc.t, expdesc.info);
        }
        if (expdesc.hasjumps()) {
            int n2;
            int n3 = -1;
            int n4 = -1;
            if (this.need_value(expdesc.t) || this.need_value(expdesc.f)) {
                n2 = expdesc.k == 10 ? -1 : this.kJump();
                n3 = this.code_label(n, 0, 1);
                n4 = this.code_label(n, 1, 0);
                this.kPatchtohere(n2);
            }
            n2 = this.kGetlabel();
            this.patchlistaux(expdesc.f, n2, n, n3);
            this.patchlistaux(expdesc.t, n2, n, n4);
        }
        expdesc.init(12, n);
    }

    private int code_label(int n, int n2, int n3) {
        this.kGetlabel();
        return this.kCodeABC(2, n, n2, n3);
    }

    private boolean need_value(int n) {
        while (n != -1) {
            int n2 = this.getjumpcontrol(n);
            int n3 = this.f.code[n2];
            if (Lua.OPCODE(n3) != 27) {
                return true;
            }
            n = this.getjump(n);
        }
        return false;
    }

    private void freeexp(Expdesc expdesc) {
        if (expdesc.kind() == 12) {
            this.freereg(expdesc.info);
        }
    }

    private void freereg(int n) {
        if (!Lua.ISK(n) && n >= this.nactvar) {
            --this.freereg;
        }
    }

    int getcode(Expdesc expdesc) {
        return this.f.code[expdesc.info];
    }

    void setcode(Expdesc expdesc, int n) {
        this.f.code[expdesc.info] = n;
    }

    int searchvar(String string) {
        for (int i = this.nactvar - 1; i >= 0; --i) {
            if (!string.equals(this.getlocvar((int)i).varname)) continue;
            return i;
        }
        return -1;
    }

    void setarga(Expdesc expdesc, int n) {
        int n2 = expdesc.info;
        int[] nArray = this.f.code;
        nArray[n2] = Lua.SETARG_A(nArray[n2], n);
    }

    void setargb(Expdesc expdesc, int n) {
        int n2 = expdesc.info;
        int[] nArray = this.f.code;
        nArray[n2] = Lua.SETARG_B(nArray[n2], n);
    }

    void setargc(Expdesc expdesc, int n) {
        int n2 = expdesc.info;
        int[] nArray = this.f.code;
        nArray[n2] = Lua.SETARG_C(nArray[n2], n);
    }

    int kGetlabel() {
        this.lasttarget = this.pc;
        return this.pc;
    }

    int kConcat(int n, int n2) {
        int n3;
        if (n2 == -1) {
            return n;
        }
        if (n == -1) {
            return n2;
        }
        int n4 = n;
        while ((n3 = this.getjump(n4)) != -1) {
            n4 = n3;
        }
        this.fixjump(n4, n2);
        return n;
    }

    void kPatchlist(int n, int n2) {
        if (n2 == this.pc) {
            this.kPatchtohere(n);
        } else {
            this.patchlistaux(n, n2, 255, n2);
        }
    }

    private void patchlistaux(int n, int n2, int n3, int n4) {
        while (n != -1) {
            int n5 = this.getjump(n);
            if (this.patchtestreg(n, n3)) {
                this.fixjump(n, n2);
            } else {
                this.fixjump(n, n4);
            }
            n = n5;
        }
    }

    private boolean patchtestreg(int n, int n2) {
        int[] nArray = this.f.code;
        int n3 = this.getjumpcontrol(n);
        int n4 = nArray[n3];
        if (Lua.OPCODE(n4) != 27) {
            return false;
        }
        nArray[n3] = n2 != 255 && n2 != Lua.ARGB(n4) ? Lua.SETARG_A(n4, n2) : Lua.CREATE_ABC(26, Lua.ARGB(n4), 0, Lua.ARGC(n4));
        return true;
    }

    private int getjumpcontrol(int n) {
        int[] nArray = this.f.code;
        if (n >= 1 && this.testTMode(Lua.OPCODE(nArray[n - 1]))) {
            return n - 1;
        }
        return n;
    }

    static byte opmode(int n, int n2, int n3, int n4, int n5) {
        return (byte)(n << 7 | n2 << 6 | n3 << 4 | n4 << 2 | n5);
    }

    private boolean testTMode(int n) {
        return (OPMODE[n] & 0x80) != 0;
    }

    void kPatchtohere(int n) {
        this.kGetlabel();
        this.jpc = this.kConcat(this.jpc, n);
    }

    private void fixjump(int n, int n2) {
        int n3 = this.f.code[n];
        int n4 = n2 - (n + 1);
        if (Math.abs(n4) > 131071) {
            this.ls.xSyntaxerror("control structure too long");
        }
        this.f.code[n] = Lua.SETARG_sBx(n3, n4);
    }

    private int getjump(int n) {
        int n2 = Lua.ARGsBx(this.f.code[n]);
        if (n2 == -1) {
            return -1;
        }
        return n + 1 + n2;
    }

    int kJump() {
        int n = this.jpc;
        this.jpc = -1;
        int n2 = this.kCodeAsBx(22, 0, -1);
        n2 = this.kConcat(n2, n);
        return n2;
    }

    void kStorevar(Expdesc expdesc, Expdesc expdesc2) {
        switch (expdesc.k) {
            case 6: {
                this.freeexp(expdesc2);
                this.exp2reg(expdesc2, expdesc.info);
                return;
            }
            case 7: {
                int n = this.kExp2anyreg(expdesc2);
                this.kCodeABC(8, n, expdesc.info, 0);
                break;
            }
            case 8: {
                int n = this.kExp2anyreg(expdesc2);
                this.kCodeABx(7, n, expdesc.info);
                break;
            }
            case 9: {
                int n = this.kExp2RK(expdesc2);
                this.kCodeABC(9, expdesc.info, expdesc.aux, n);
                break;
            }
        }
        this.freeexp(expdesc2);
    }

    void kIndexed(Expdesc expdesc, Expdesc expdesc2) {
        expdesc.aux = this.kExp2RK(expdesc2);
        expdesc.k = 9;
    }

    int kExp2RK(Expdesc expdesc) {
        this.kExp2val(expdesc);
        switch (expdesc.k) {
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                if (this.nk > 255) break;
                expdesc.info = expdesc.k == 1 ? this.nilK() : (expdesc.k == 5 ? this.kNumberK(expdesc.nval) : this.boolK(expdesc.k == 2));
                expdesc.k = 4;
                return expdesc.info | 0x100;
            }
            case 4: {
                if (expdesc.info > 255) break;
                return expdesc.info | 0x100;
            }
        }
        return this.kExp2anyreg(expdesc);
    }

    void kExp2val(Expdesc expdesc) {
        if (expdesc.hasjumps()) {
            this.kExp2anyreg(expdesc);
        } else {
            this.kDischargevars(expdesc);
        }
    }

    private int boolK(boolean bl) {
        return this.addk(Lua.valueOfBoolean(bl));
    }

    private int nilK() {
        return this.addk(Lua.NIL);
    }

    void kGoiffalse(Expdesc expdesc) {
        int n;
        this.kDischargevars(expdesc);
        switch (expdesc.k) {
            case 1: 
            case 3: {
                n = -1;
                break;
            }
            case 2: {
                n = this.kJump();
                break;
            }
            case 10: {
                n = expdesc.info;
                break;
            }
            default: {
                n = this.jumponcond(expdesc, true);
            }
        }
        expdesc.t = this.kConcat(expdesc.t, n);
        this.kPatchtohere(expdesc.f);
        expdesc.f = -1;
    }

    void kGoiftrue(Expdesc expdesc) {
        int n;
        this.kDischargevars(expdesc);
        switch (expdesc.k) {
            case 2: 
            case 4: 
            case 5: {
                n = -1;
                break;
            }
            case 3: {
                n = this.kJump();
                break;
            }
            case 10: {
                this.invertjump(expdesc);
                n = expdesc.info;
                break;
            }
            default: {
                n = this.jumponcond(expdesc, false);
            }
        }
        expdesc.f = this.kConcat(expdesc.f, n);
        this.kPatchtohere(expdesc.t);
        expdesc.t = -1;
    }

    private void invertjump(Expdesc expdesc) {
        int[] nArray = this.f.code;
        int n = this.getjumpcontrol(expdesc.info);
        int n2 = nArray[n];
        int n3 = Lua.ARGA(n2) == 0 ? 1 : 0;
        nArray[n] = Lua.SETARG_A(n2, n3);
    }

    private int jumponcond(Expdesc expdesc, boolean bl) {
        int n;
        if (expdesc.k == 11 && Lua.OPCODE(n = this.getcode(expdesc)) == 19) {
            --this.pc;
            return this.condjump(26, Lua.ARGB(n), 0, bl ? 0 : 1);
        }
        this.discharge2anyreg(expdesc);
        this.freeexp(expdesc);
        return this.condjump(27, 255, expdesc.info, bl ? 1 : 0);
    }

    private int condjump(int n, int n2, int n3, int n4) {
        this.kCodeABC(n, n2, n3, n4);
        return this.kJump();
    }

    private void discharge2anyreg(Expdesc expdesc) {
        if (expdesc.k != 12) {
            this.kReserveregs(1);
            this.discharge2reg(expdesc, this.freereg - 1);
        }
    }

    void kSelf(Expdesc expdesc, Expdesc expdesc2) {
        this.kExp2anyreg(expdesc);
        this.freeexp(expdesc);
        int n = this.freereg;
        this.kReserveregs(2);
        this.kCodeABC(11, n, expdesc.info, this.kExp2RK(expdesc2));
        this.freeexp(expdesc2);
        expdesc.info = n;
        expdesc.k = 12;
    }

    void kSetlist(int n, int n2, int n3) {
        int n4;
        int n5 = (n2 - 1) / 50 + 1;
        int n6 = n4 = n3 == -1 ? 0 : n3;
        if (n5 <= 511) {
            this.kCodeABC(34, n, n4, n5);
        } else {
            this.kCodeABC(34, n, n4, 0);
            this.kCode(n5, this.ls.lastline);
        }
        this.freereg = n + 1;
    }

    void codecomp(int n, boolean bl, Expdesc expdesc, Expdesc expdesc2) {
        int n2 = this.kExp2RK(expdesc);
        int n3 = this.kExp2RK(expdesc2);
        this.freeexp(expdesc2);
        this.freeexp(expdesc);
        if (!bl && n != 23) {
            int n4 = n2;
            n2 = n3;
            n3 = n4;
            bl = true;
        }
        expdesc.info = this.condjump(n, bl ? 1 : 0, n2, n3);
        expdesc.k = 10;
    }

    void markupval(int n) {
        BlockCnt blockCnt = this.bl;
        while (blockCnt != null && blockCnt.nactvar > n) {
            blockCnt = blockCnt.previous;
        }
        if (blockCnt != null) {
            blockCnt.upval = true;
        }
    }
}

