/*
 * Decompiled with CFR 0.152.
 */
package mnj.lua;

import java.util.Random;
import mnj.lua.Lua;
import mnj.lua.LuaJavaCallback;
import mnj.lua.LuaTable;

public final class MathLib
extends LuaJavaCallback {
    private static final int ABS = 1;
    private static final int ACOS = 2;
    private static final int ASIN = 3;
    private static final int ATAN2 = 4;
    private static final int ATAN = 5;
    private static final int CEIL = 6;
    private static final int COSH = 7;
    private static final int COS = 8;
    private static final int DEG = 9;
    private static final int EXP = 10;
    private static final int FLOOR = 11;
    private static final int FMOD = 12;
    private static final int FREXP = 13;
    private static final int LDEXP = 14;
    private static final int LOG = 15;
    private static final int MAX = 16;
    private static final int MIN = 17;
    private static final int MODF = 18;
    private static final int POW = 19;
    private static final int RAD = 20;
    private static final int RANDOM = 21;
    private static final int RANDOMSEED = 22;
    private static final int SINH = 23;
    private static final int SIN = 24;
    private static final int SQRT = 25;
    private static final int TANH = 26;
    private static final int TAN = 27;
    private static final int LOG10 = 28;
    private static final int L2MAGNITUDE = 29;
    private static final Random rng = new Random();
    private int which;

    private MathLib(int n) {
        this.which = n;
    }

    @Override
    public int luaFunction(Lua lua) {
        switch (this.which) {
            case 1: {
                return MathLib.abs(lua);
            }
            case 2: {
                return MathLib.acos(lua);
            }
            case 3: {
                return MathLib.asin(lua);
            }
            case 5: {
                return MathLib.atan(lua);
            }
            case 4: {
                return MathLib.atan2(lua);
            }
            case 6: {
                return MathLib.ceil(lua);
            }
            case 7: {
                return MathLib.cosh(lua);
            }
            case 8: {
                return MathLib.cos(lua);
            }
            case 9: {
                return MathLib.deg(lua);
            }
            case 10: {
                return MathLib.exp(lua);
            }
            case 11: {
                return MathLib.floor(lua);
            }
            case 12: {
                return MathLib.fmod(lua);
            }
            case 13: {
                return MathLib.frexp(lua);
            }
            case 14: {
                return MathLib.ldexp(lua);
            }
            case 15: {
                return MathLib.log(lua);
            }
            case 28: {
                return MathLib.log10(lua);
            }
            case 16: {
                return MathLib.max(lua);
            }
            case 17: {
                return MathLib.min(lua);
            }
            case 18: {
                return MathLib.modf(lua);
            }
            case 19: {
                return MathLib.pow(lua);
            }
            case 20: {
                return MathLib.rad(lua);
            }
            case 21: {
                return MathLib.random(lua);
            }
            case 22: {
                return MathLib.randomseed(lua);
            }
            case 23: {
                return MathLib.sinh(lua);
            }
            case 24: {
                return MathLib.sin(lua);
            }
            case 25: {
                return MathLib.sqrt(lua);
            }
            case 26: {
                return MathLib.tanh(lua);
            }
            case 27: {
                return MathLib.tan(lua);
            }
            case 29: {
                return MathLib.l2magnitude(lua);
            }
        }
        return 0;
    }

    public static void open(Lua lua) {
        LuaTable luaTable = lua.register("math");
        MathLib.r(lua, "abs", 1);
        MathLib.r(lua, "acos", 2);
        MathLib.r(lua, "asin", 3);
        MathLib.r(lua, "atan", 5);
        MathLib.r(lua, "atan2", 4);
        MathLib.r(lua, "ceil", 6);
        MathLib.r(lua, "cosh", 7);
        MathLib.r(lua, "cos", 8);
        MathLib.r(lua, "deg", 9);
        MathLib.r(lua, "exp", 10);
        MathLib.r(lua, "floor", 11);
        MathLib.r(lua, "fmod", 12);
        MathLib.r(lua, "frexp", 13);
        MathLib.r(lua, "ldexp", 14);
        MathLib.r(lua, "log", 15);
        MathLib.r(lua, "log10", 28);
        MathLib.r(lua, "max", 16);
        MathLib.r(lua, "min", 17);
        MathLib.r(lua, "modf", 18);
        MathLib.r(lua, "pow", 19);
        MathLib.r(lua, "rad", 20);
        MathLib.r(lua, "random", 21);
        MathLib.r(lua, "randomseed", 22);
        MathLib.r(lua, "sinh", 23);
        MathLib.r(lua, "sin", 24);
        MathLib.r(lua, "sqrt", 25);
        MathLib.r(lua, "tanh", 26);
        MathLib.r(lua, "tan", 27);
        MathLib.r(lua, "l2magnitude", 29);
        lua.setField(luaTable, "pi", Lua.valueOfNumber(Math.PI));
        lua.setField(luaTable, "huge", Lua.valueOfNumber(Double.POSITIVE_INFINITY));
    }

    private static void r(Lua lua, String string, int n) {
        MathLib mathLib = new MathLib(n);
        lua.setField(lua.getGlobal("math"), string, mathLib);
    }

    private static int abs(Lua lua) {
        lua.pushNumber(Math.abs(lua.checkNumber(1)));
        return 1;
    }

    private static int acos(Lua lua) {
        lua.pushNumber(Math.acos(lua.checkNumber(1)));
        return 1;
    }

    private static int asin(Lua lua) {
        lua.pushNumber(Math.asin(lua.checkNumber(1)));
        return 1;
    }

    private static int atan(Lua lua) {
        lua.pushNumber(Math.atan(lua.checkNumber(1)));
        return 1;
    }

    private static int atan2(Lua lua) {
        lua.pushNumber(Math.atan2(lua.checkNumber(1), lua.checkNumber(2)));
        return 1;
    }

    private static int ceil(Lua lua) {
        lua.pushNumber(Math.ceil(lua.checkNumber(1)));
        return 1;
    }

    private static int cosh(Lua lua) {
        lua.pushNumber(Math.cosh(lua.checkNumber(1)));
        return 1;
    }

    private static int cos(Lua lua) {
        lua.pushNumber(Math.cos(lua.checkNumber(1)));
        return 1;
    }

    private static int deg(Lua lua) {
        lua.pushNumber(Math.toDegrees(lua.checkNumber(1)));
        return 1;
    }

    private static int exp(Lua lua) {
        lua.pushNumber(Lua.iNumpow(Math.E, lua.checkNumber(1)));
        return 1;
    }

    private static int floor(Lua lua) {
        lua.pushNumber(Math.floor(lua.checkNumber(1)));
        return 1;
    }

    private static int fmod(Lua lua) {
        lua.pushNumber(lua.checkNumber(1) % lua.checkNumber(2));
        return 1;
    }

    private static int frexp(Lua lua) {
        int n = 1 + Math.getExponent(lua.checkNumber(1));
        lua.pushNumber(Math.scalb(lua.checkNumber(1), -n));
        lua.pushNumber(n);
        return 2;
    }

    private static int ldexp(Lua lua) {
        lua.pushNumber(Math.scalb(lua.checkNumber(1), (int)lua.checkNumber(2)));
        return 1;
    }

    private static int log(Lua lua) {
        lua.pushNumber(Math.log(lua.checkNumber(1)));
        return 1;
    }

    private static int log10(Lua lua) {
        lua.pushNumber(Math.log(lua.checkNumber(1)) / Math.log(10.0));
        return 1;
    }

    private static int max(Lua lua) {
        int n = lua.getTop();
        double d = lua.checkNumber(1);
        for (int i = 2; i <= n; ++i) {
            double d2 = lua.checkNumber(i);
            d = Math.max(d, d2);
        }
        lua.pushNumber(d);
        return 1;
    }

    private static int min(Lua lua) {
        int n = lua.getTop();
        double d = lua.checkNumber(1);
        for (int i = 2; i <= n; ++i) {
            double d2 = lua.checkNumber(i);
            d = Math.min(d, d2);
        }
        lua.pushNumber(d);
        return 1;
    }

    private static int modf(Lua lua) {
        double d = lua.checkNumber(1);
        double d2 = d % 1.0;
        double d3 = d - d2;
        lua.pushNumber(d3);
        lua.pushNumber(d2);
        return 2;
    }

    private static int pow(Lua lua) {
        lua.pushNumber(Lua.iNumpow(lua.checkNumber(1), lua.checkNumber(2)));
        return 1;
    }

    private static int rad(Lua lua) {
        lua.pushNumber(Math.toRadians(lua.checkNumber(1)));
        return 1;
    }

    private static int random(Lua lua) {
        switch (lua.getTop()) {
            case 0: {
                lua.pushNumber(rng.nextDouble());
                break;
            }
            case 1: {
                int n = lua.checkInt(1);
                lua.argCheck(1 <= n, 1, "interval is empty");
                lua.pushNumber(rng.nextInt(n) + 1);
                break;
            }
            case 2: {
                int n = lua.checkInt(1);
                int n2 = lua.checkInt(2);
                lua.argCheck(n <= n2, 2, "interval is empty");
                lua.pushNumber(rng.nextInt(n2) + n);
                break;
            }
            default: {
                return lua.error("wrong number of arguments");
            }
        }
        return 1;
    }

    private static int randomseed(Lua lua) {
        rng.setSeed((long)lua.checkNumber(1));
        return 0;
    }

    private static int sinh(Lua lua) {
        lua.pushNumber(Math.sinh(lua.checkNumber(1)));
        return 1;
    }

    private static int sin(Lua lua) {
        lua.pushNumber(Math.sin(lua.checkNumber(1)));
        return 1;
    }

    private static int sqrt(Lua lua) {
        lua.pushNumber(Math.sqrt(lua.checkNumber(1)));
        return 1;
    }

    private static int tanh(Lua lua) {
        lua.pushNumber(Math.tanh(lua.checkNumber(1)));
        return 1;
    }

    private static int tan(Lua lua) {
        lua.pushNumber(Math.tan(lua.checkNumber(1)));
        return 1;
    }

    private static int l2magnitude(Lua lua) {
        lua.pushNumber(Math.ceil(Math.log(lua.checkNumber(1) + 1.0) / Math.log(2.0)));
        return 1;
    }
}

