/*
 * Decompiled with CFR 0.152.
 */
package mnj.lua;

import mnj.lua.LocVar;
import mnj.lua.Lua;
import mnj.lua.Slot;

final class Proto {
    private static final int[] ZERO_INT_ARRAY = new int[0];
    private static final LocVar[] ZERO_LOCVAR_ARRAY = new LocVar[0];
    private static final Slot[] ZERO_CONSTANT_ARRAY = new Slot[0];
    private static final Proto[] ZERO_PROTO_ARRAY = new Proto[0];
    private static final String[] ZERO_STRING_ARRAY = new String[0];
    Slot[] k;
    int sizek;
    int[] code;
    int sizecode;
    Proto[] p;
    int sizep;
    int nups;
    int numparams;
    boolean isVararg;
    int maxstacksize;
    int[] lineinfo;
    int sizelineinfo;
    LocVar[] locvars;
    int sizelocvars;
    String[] upvalues;
    int sizeupvalues;
    String source;
    int linedefined;
    int lastlinedefined;

    Proto(Slot[] slotArray, int[] nArray, Proto[] protoArray, int n, int n2, boolean bl, int n3) {
        if (null == slotArray || null == nArray || null == protoArray) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException();
        }
        this.k = slotArray;
        this.sizek = this.k.length;
        this.code = nArray;
        this.sizecode = nArray.length;
        this.p = protoArray;
        this.sizep = protoArray.length;
        this.nups = n;
        this.numparams = n2;
        this.isVararg = bl;
        this.maxstacksize = n3;
    }

    Proto(String string, int n) {
        this.maxstacksize = n;
        this.source = string;
        this.k = ZERO_CONSTANT_ARRAY;
        this.sizek = 0;
        this.code = ZERO_INT_ARRAY;
        this.sizecode = 0;
        this.p = ZERO_PROTO_ARRAY;
        this.sizep = 0;
        this.lineinfo = ZERO_INT_ARRAY;
        this.sizelineinfo = 0;
        this.locvars = ZERO_LOCVAR_ARRAY;
        this.sizelocvars = 0;
        this.upvalues = ZERO_STRING_ARRAY;
        this.sizeupvalues = 0;
    }

    void debug(int[] nArray, LocVar[] locVarArray, String[] stringArray) {
        this.lineinfo = nArray;
        this.sizelineinfo = this.lineinfo.length;
        this.locvars = locVarArray;
        this.sizelocvars = this.locvars.length;
        this.upvalues = stringArray;
        this.sizeupvalues = this.upvalues.length;
    }

    String source() {
        return this.source;
    }

    void setSource(String string) {
        this.source = string;
    }

    int linedefined() {
        return this.linedefined;
    }

    void setLinedefined(int n) {
        this.linedefined = n;
    }

    int lastlinedefined() {
        return this.lastlinedefined;
    }

    void setLastlinedefined(int n) {
        this.lastlinedefined = n;
    }

    int nups() {
        return this.nups;
    }

    int numparams() {
        return this.numparams;
    }

    int maxstacksize() {
        return this.maxstacksize;
    }

    void setMaxstacksize(int n) {
        this.maxstacksize = n;
    }

    int[] code() {
        return this.code;
    }

    void codeAppend(Lua lua, int n, int n2, int n3) {
        this.ensureCode(lua, n);
        this.code[n] = n2;
        if (n >= this.lineinfo.length) {
            int[] nArray = new int[this.lineinfo.length * 2 + 1];
            System.arraycopy(this.lineinfo, 0, nArray, 0, this.lineinfo.length);
            this.lineinfo = nArray;
        }
        this.lineinfo[n] = n3;
    }

    void ensureLocvars(Lua lua, int n, int n2) {
        if (n + 1 > this.sizelocvars) {
            int n3 = n * 2 + 1;
            if (n3 > n2) {
                n3 = n2;
            }
            if (n + 1 > n3) {
                lua.gRunerror("too many local variables");
            }
            LocVar[] locVarArray = new LocVar[n3];
            System.arraycopy(this.locvars, 0, locVarArray, 0, this.sizelocvars);
            for (int i = this.sizelocvars; i < n3; ++i) {
                locVarArray[i] = new LocVar();
            }
            this.locvars = locVarArray;
            this.sizelocvars = n3;
        }
    }

    void ensureProtos(Lua lua, int n) {
        if (n + 1 > this.sizep) {
            int n2 = n * 2 + 1;
            if (n2 > 262143) {
                n2 = 262143;
            }
            if (n + 1 > n2) {
                lua.gRunerror("constant table overflow");
            }
            Proto[] protoArray = new Proto[n2];
            System.arraycopy(this.p, 0, protoArray, 0, this.sizep);
            this.p = protoArray;
            this.sizep = n2;
        }
    }

    void ensureUpvals(Lua lua, int n) {
        if (n + 1 > this.sizeupvalues) {
            int n2 = n * 2 + 1;
            if (n + 1 > n2) {
                lua.gRunerror("upvalues overflow");
            }
            String[] stringArray = new String[n2];
            System.arraycopy(this.upvalues, 0, stringArray, 0, this.sizeupvalues);
            this.upvalues = stringArray;
            this.sizeupvalues = n2;
        }
    }

    void ensureCode(Lua lua, int n) {
        if (n + 1 > this.sizecode) {
            int n2 = n * 2 + 1;
            if (n + 1 > n2) {
                lua.gRunerror("code overflow");
            }
            int[] nArray = new int[n2];
            System.arraycopy(this.code, 0, nArray, 0, this.sizecode);
            this.code = nArray;
            this.sizecode = n2;
        }
    }

    void setLineinfo(int n, int n2) {
        this.lineinfo[n] = n2;
    }

    int getline(int n) {
        if (this.lineinfo.length == 0) {
            return 0;
        }
        return this.lineinfo[n];
    }

    Proto[] proto() {
        return this.p;
    }

    Slot[] constant() {
        return this.k;
    }

    void constantAppend(int n, Object object) {
        if (n >= this.k.length) {
            Slot[] slotArray = new Slot[this.k.length * 2 + 1];
            System.arraycopy(this.k, 0, slotArray, 0, this.k.length);
            this.k = slotArray;
        }
        this.k[n] = new Slot(object);
    }

    boolean isVararg() {
        return this.isVararg;
    }

    void setIsVararg() {
        this.isVararg = true;
    }

    LocVar[] locvars() {
        return this.locvars;
    }

    private int[] trimInt(int[] nArray, int n) {
        if (n == nArray.length) {
            return nArray;
        }
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        return nArray2;
    }

    void closeCode(int n) {
        this.code = this.trimInt(this.code, n);
        this.sizecode = this.code.length;
    }

    void closeLineinfo(int n) {
        this.lineinfo = this.trimInt(this.lineinfo, n);
        this.sizelineinfo = n;
    }

    void closeK(int n) {
        if (this.k.length > n) {
            Slot[] slotArray = new Slot[n];
            System.arraycopy(this.k, 0, slotArray, 0, n);
            this.k = slotArray;
        }
        this.sizek = n;
    }

    void closeP(int n) {
        if (n == this.p.length) {
            return;
        }
        Proto[] protoArray = new Proto[n];
        System.arraycopy(this.p, 0, protoArray, 0, n);
        this.p = protoArray;
        this.sizep = n;
    }

    void closeLocvars(int n) {
        if (n == this.locvars.length) {
            return;
        }
        LocVar[] locVarArray = new LocVar[n];
        System.arraycopy(this.locvars, 0, locVarArray, 0, n);
        this.locvars = locVarArray;
        this.sizelocvars = n;
    }

    void closeUpvalues() {
        if (this.nups == this.upvalues.length) {
            return;
        }
        String[] stringArray = new String[this.nups];
        System.arraycopy(this.upvalues, 0, stringArray, 0, this.nups);
        this.upvalues = stringArray;
        this.sizeupvalues = this.nups;
    }
}

