/*
 * Decompiled with CFR 0.152.
 */
package mnj.lua;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import mnj.lua.FormatItem;
import mnj.lua.Lua;
import mnj.lua.LuaJavaCallback;
import mnj.lua.LuaTable;
import mnj.lua.MatchState;

public final class StringLib
extends LuaJavaCallback {
    private static final int BYTE = 1;
    private static final int CHAR = 2;
    private static final int DUMP = 3;
    private static final int FIND = 4;
    private static final int FORMAT = 5;
    private static final int GFIND = 6;
    private static final int GMATCH = 7;
    private static final int GSUB = 8;
    private static final int LEN = 9;
    private static final int LOWER = 10;
    private static final int MATCH = 11;
    private static final int REP = 12;
    private static final int REVERSE = 13;
    private static final int SUB = 14;
    private static final int UPPER = 15;
    private static final int GMATCH_AUX = 16;
    private static final StringLib GMATCH_AUX_FUN = new StringLib(16);
    private int which;

    private StringLib(int n) {
        this.which = n;
    }

    public void formatISO() {
        FormatItem.E_LOWER = (char)101;
    }

    @Override
    public int luaFunction(Lua lua) {
        switch (this.which) {
            case 1: {
                return StringLib.byteFunction(lua);
            }
            case 2: {
                return StringLib.charFunction(lua);
            }
            case 3: {
                return StringLib.dump(lua);
            }
            case 4: {
                return StringLib.find(lua);
            }
            case 5: {
                return StringLib.format(lua);
            }
            case 7: {
                return StringLib.gmatch(lua);
            }
            case 8: {
                return StringLib.gsub(lua);
            }
            case 9: {
                return StringLib.len(lua);
            }
            case 10: {
                return StringLib.lower(lua);
            }
            case 11: {
                return StringLib.match(lua);
            }
            case 12: {
                return StringLib.rep(lua);
            }
            case 13: {
                return StringLib.reverse(lua);
            }
            case 14: {
                return StringLib.sub(lua);
            }
            case 15: {
                return StringLib.upper(lua);
            }
            case 16: {
                return StringLib.gmatchaux(lua);
            }
        }
        return 0;
    }

    public static void open(Lua lua) {
        LuaTable luaTable = lua.register("string");
        StringLib.r(lua, "byte", 1);
        StringLib.r(lua, "char", 2);
        StringLib.r(lua, "dump", 3);
        StringLib.r(lua, "find", 4);
        StringLib.r(lua, "format", 5);
        StringLib.r(lua, "gfind", 6);
        StringLib.r(lua, "gmatch", 7);
        StringLib.r(lua, "gsub", 8);
        StringLib.r(lua, "len", 9);
        StringLib.r(lua, "lower", 10);
        StringLib.r(lua, "match", 11);
        StringLib.r(lua, "rep", 12);
        StringLib.r(lua, "reverse", 13);
        StringLib.r(lua, "sub", 14);
        StringLib.r(lua, "upper", 15);
        LuaTable luaTable2 = new LuaTable();
        lua.setMetatable("", luaTable2);
        lua.setField(luaTable2, "__index", luaTable);
    }

    private static void r(Lua lua, String string, int n) {
        StringLib stringLib = new StringLib(n);
        Object object = lua.getGlobal("string");
        lua.setField(object, string, stringLib);
    }

    private static int byteFunction(Lua lua) {
        String string = lua.checkString(1);
        int n = StringLib.posrelat(lua.optInt(2, 1), string);
        int n2 = StringLib.posrelat(lua.optInt(3, n), string);
        if (n <= 0) {
            n = 1;
        }
        if (n2 > string.length()) {
            n2 = string.length();
        }
        if (n > n2) {
            return 0;
        }
        int n3 = n2 - n + 1;
        for (int i = 0; i < n3; ++i) {
            lua.pushNumber(string.charAt(n + i - 1));
        }
        return n3;
    }

    private static int charFunction(Lua lua) {
        int n = lua.getTop();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 1; i <= n; ++i) {
            int n2 = lua.checkInt(i);
            lua.argCheck((char)n2 == n2, i, "invalid value");
            stringBuffer.append((char)n2);
        }
        lua.push(stringBuffer.toString());
        return 1;
    }

    private static int dump(Lua lua) {
        lua.checkType(1, 6);
        lua.setTop(1);
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Lua.dump(lua.value(1), byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream = null;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < byArray.length; ++i) {
                stringBuffer.append((char)(byArray[i] & 0xFF));
            }
            lua.pushString(stringBuffer.toString());
            return 1;
        }
        catch (IOException iOException) {
            lua.error("unabe to dump given function");
            return 0;
        }
    }

    private static int findAux(Lua lua, boolean bl) {
        String string = lua.checkString(1);
        String string2 = lua.checkString(2);
        int n = string.length();
        int n2 = string2.length();
        int n3 = StringLib.posrelat(lua.optInt(3, 1), string) - 1;
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 > n) {
            n3 = n;
        }
        if (bl && (lua.toBoolean(lua.value(4)) || StringLib.strpbrk(string2, "^$*+?.([%-") < 0)) {
            int n4 = StringLib.lmemfind(string.substring(n3), n - n3, string2, n2);
            if (n4 >= 0) {
                lua.pushNumber(n3 + n4 + 1);
                lua.pushNumber(n3 + n4 + n2);
                return 2;
            }
        } else {
            MatchState matchState = new MatchState(lua, string, n);
            boolean bl2 = string2.charAt(0) == '^';
            int n5 = n3;
            do {
                matchState.level = 0;
                int n6 = matchState.match(n5, string2, bl2 ? 1 : 0);
                if (n6 < 0) continue;
                if (bl) {
                    lua.pushNumber(n5 + 1);
                    lua.pushNumber(n6);
                    return matchState.push_captures(-1, -1) + 2;
                }
                return matchState.push_captures(n5, n6);
            } while (n5++ < matchState.end && !bl2);
        }
        lua.pushNil();
        return 1;
    }

    private static int find(Lua lua) {
        return StringLib.findAux(lua, true);
    }

    private static int gmatch(Lua lua) {
        Object[] objectArray = new Object[]{lua.checkString(1), lua.checkString(2), new Integer(0)};
        lua.push(GMATCH_AUX_FUN);
        lua.push(objectArray);
        return 2;
    }

    private static int gmatchaux(Lua lua) {
        Object[] objectArray = (Object[])lua.value(1);
        String string = (String)objectArray[0];
        String string2 = (String)objectArray[1];
        MatchState matchState = new MatchState(lua, string, string.length());
        for (int i = ((Integer)objectArray[2]).intValue(); i <= matchState.end; ++i) {
            matchState.level = 0;
            int n = matchState.match(i, string2, 0);
            if (n < 0) continue;
            int n2 = n;
            if (n == i) {
                ++n2;
            }
            objectArray[2] = new Integer(n2);
            return matchState.push_captures(i, n);
        }
        return 0;
    }

    private static int gsub(Lua lua) {
        String string = lua.checkString(1);
        int n = string.length();
        String string2 = lua.checkString(2);
        int n2 = lua.optInt(4, n + 1);
        boolean bl = false;
        if (string2.length() > 0) {
            boolean bl2 = bl = string2.charAt(0) == '^';
        }
        if (bl) {
            string2 = string2.substring(1);
        }
        MatchState matchState = new MatchState(lua, string, n);
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            matchState.level = 0;
            int n5 = matchState.match(n4, string2, 0);
            if (n5 >= 0) {
                ++n3;
                matchState.addvalue(stringBuffer, n4, n5);
            }
            if (n5 >= 0 && n5 > n4) {
                n4 = n5;
            } else {
                if (n4 >= matchState.end) break;
                stringBuffer.append(string.charAt(n4++));
            }
            if (!bl) continue;
            break;
        }
        stringBuffer.append(string.substring(n4));
        lua.pushString(stringBuffer.toString());
        lua.pushNumber(n3);
        return 2;
    }

    static void addquoted(Lua lua, StringBuffer stringBuffer, int n) {
        String string = lua.checkString(n);
        int n2 = string.length();
        stringBuffer.append('\"');
        block5: for (int i = 0; i < n2; ++i) {
            switch (string.charAt(i)) {
                case '\n': 
                case '\"': 
                case '\\': {
                    stringBuffer.append('\\');
                    stringBuffer.append(string.charAt(i));
                    continue block5;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block5;
                }
                case '\u0000': {
                    stringBuffer.append("\\000");
                    continue block5;
                }
                default: {
                    stringBuffer.append(string.charAt(i));
                }
            }
        }
        stringBuffer.append('\"');
    }

    static int format(Lua lua) {
        int n = 1;
        String string = lua.checkString(1);
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        block7: while (n3 < n2) {
            if (string.charAt(n3) != '%') {
                stringBuffer.append(string.charAt(n3++));
                continue;
            }
            if (string.charAt(++n3) == '%') {
                stringBuffer.append(string.charAt(n3++));
                continue;
            }
            ++n;
            FormatItem formatItem = new FormatItem(lua, string.substring(n3));
            n3 += formatItem.length();
            switch (formatItem.type()) {
                case 99: {
                    formatItem.formatChar(stringBuffer, (char)lua.checkNumber(n));
                    continue block7;
                }
                case 88: 
                case 100: 
                case 105: 
                case 111: 
                case 117: 
                case 120: {
                    formatItem.formatInteger(stringBuffer, (long)lua.checkNumber(n));
                    continue block7;
                }
                case 69: 
                case 71: 
                case 101: 
                case 102: 
                case 103: {
                    formatItem.formatFloat(stringBuffer, lua.checkNumber(n));
                    continue block7;
                }
                case 113: {
                    StringLib.addquoted(lua, stringBuffer, n);
                    continue block7;
                }
                case 115: {
                    formatItem.formatString(stringBuffer, lua.checkString(n));
                    continue block7;
                }
            }
            return lua.error("invalid option to 'format'");
        }
        lua.pushString(stringBuffer.toString());
        return 1;
    }

    private static int len(Lua lua) {
        String string = lua.checkString(1);
        lua.pushNumber(string.length());
        return 1;
    }

    private static int lower(Lua lua) {
        String string = lua.checkString(1);
        lua.push(string.toLowerCase());
        return 1;
    }

    private static int match(Lua lua) {
        return StringLib.findAux(lua, false);
    }

    private static int rep(Lua lua) {
        String string = lua.checkString(1);
        int n = lua.checkInt(2);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(string);
        }
        lua.push(stringBuffer.toString());
        return 1;
    }

    private static int reverse(Lua lua) {
        String string = lua.checkString(1);
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        while (--n >= 0) {
            stringBuffer.append(string.charAt(n));
        }
        lua.push(stringBuffer.toString());
        return 1;
    }

    private static int posrelat(int n, String string) {
        if (n >= 0) {
            return n;
        }
        int n2 = string.length();
        return n2 + n + 1;
    }

    private static int sub(Lua lua) {
        String string = lua.checkString(1);
        int n = StringLib.posrelat(lua.checkInt(2), string);
        int n2 = StringLib.posrelat(lua.optInt(3, -1), string);
        if (n < 1) {
            n = 1;
        }
        if (n2 > string.length()) {
            n2 = string.length();
        }
        if (n <= n2) {
            lua.push(string.substring(n - 1, n2));
        } else {
            lua.pushLiteral("");
        }
        return 1;
    }

    private static int upper(Lua lua) {
        String string = lua.checkString(1);
        lua.push(string.toUpperCase());
        return 1;
    }

    private static int lmemfind(String string, int n, String string2, int n2) {
        if (n2 == 0) {
            return 0;
        }
        if (n2 > n) {
            return -1;
        }
        return string.indexOf(string2);
    }

    private static int strpbrk(String string, String string2) {
        int n = string2.length();
        for (int i = 0; i < n; ++i) {
            int n2 = string.indexOf(string2.charAt(i));
            if (n2 < 0) continue;
            return n2;
        }
        return -1;
    }
}

