/*
 * Decompiled with CFR 0.152.
 */
package mnj.lua;

import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;
import mnj.lua.BlockCnt;
import mnj.lua.ConsControl;
import mnj.lua.Expdesc;
import mnj.lua.FuncState;
import mnj.lua.LHSAssign;
import mnj.lua.LocVar;
import mnj.lua.Lua;
import mnj.lua.Proto;

final class Syntax {
    private static final int EOZ = -1;
    private static final int FIRST_RESERVED = 257;
    private static final int TK_AND = 257;
    private static final int TK_BREAK = 258;
    private static final int TK_DO = 259;
    private static final int TK_ELSE = 260;
    private static final int TK_ELSEIF = 261;
    private static final int TK_END = 262;
    private static final int TK_FALSE = 263;
    private static final int TK_FOR = 264;
    private static final int TK_FUNCTION = 265;
    private static final int TK_IF = 266;
    private static final int TK_IN = 267;
    private static final int TK_LOCAL = 268;
    private static final int TK_NIL = 269;
    private static final int TK_NOT = 270;
    private static final int TK_OR = 271;
    private static final int TK_REPEAT = 272;
    private static final int TK_RETURN = 273;
    private static final int TK_THEN = 274;
    private static final int TK_TRUE = 275;
    private static final int TK_UNTIL = 276;
    private static final int TK_WHILE = 277;
    private static final int TK_CONCAT = 278;
    private static final int TK_DOTS = 279;
    private static final int TK_EQ = 280;
    private static final int TK_GE = 281;
    private static final int TK_LE = 282;
    private static final int TK_NE = 283;
    private static final int TK_NUMBER = 284;
    private static final int TK_NAME = 285;
    private static final int TK_STRING = 286;
    private static final int TK_EOS = 287;
    private static final int NUM_RESERVED = 21;
    static String[] tokens = new String[]{"and", "break", "do", "else", "elseif", "end", "false", "for", "function", "if", "in", "local", "nil", "not", "or", "repeat", "return", "then", "true", "until", "while", "..", "...", "==", ">=", "<=", "~=", "<number>", "<name>", "<string>", "<eof>"};
    static Hashtable<Object, Object> reserved = new Hashtable();
    int current;
    int linenumber = 1;
    int lastline = 1;
    int token;
    double tokenR;
    String tokenS;
    int lookahead = 287;
    double lookaheadR;
    String lookaheadS;
    double semR;
    String semS;
    FuncState fs;
    Lua L;
    private Reader z;
    StringBuffer buff = new StringBuffer();
    String source;
    static final int OPR_ADD = 0;
    static final int OPR_SUB = 1;
    static final int OPR_MUL = 2;
    static final int OPR_DIV = 3;
    static final int OPR_MOD = 4;
    static final int OPR_POW = 5;
    static final int OPR_CONCAT = 6;
    static final int OPR_NE = 7;
    static final int OPR_EQ = 8;
    static final int OPR_LT = 9;
    static final int OPR_LE = 10;
    static final int OPR_GT = 11;
    static final int OPR_GE = 12;
    static final int OPR_AND = 13;
    static final int OPR_OR = 14;
    static final int OPR_NOBINOPR = 15;
    static final int OPR_MINUS = 0;
    static final int OPR_NOT = 1;
    static final int OPR_LEN = 2;
    static final int OPR_NOUNOPR = 3;
    private static final int[][] PRIORITY;
    private static final int UNARY_PRIORITY = 8;

    private Syntax(Lua lua, Reader reader, String string) throws IOException {
        this.L = lua;
        this.z = reader;
        this.source = string;
        this.next();
    }

    int lastline() {
        return this.lastline;
    }

    static boolean isalnum(int n) {
        char c = (char)n;
        return Character.isUpperCase(c) || Character.isLowerCase(c) || Character.isDigit(c);
    }

    static boolean isalpha(int n) {
        char c = (char)n;
        return Character.isUpperCase(c) || Character.isLowerCase(c);
    }

    static boolean iscntrl(int n) {
        return (char)n < ' ' || n == 127;
    }

    static boolean isdigit(int n) {
        return Character.isDigit((char)n);
    }

    static boolean islower(int n) {
        return Character.isLowerCase((char)n);
    }

    static boolean ispunct(int n) {
        return !Syntax.isalnum(n) && !Syntax.iscntrl(n) && !Syntax.isspace(n);
    }

    static boolean isspace(int n) {
        return n == 32 || n == 12 || n == 10 || n == 13 || n == 9;
    }

    static boolean isupper(int n) {
        return Character.isUpperCase((char)n);
    }

    static boolean isxdigit(int n) {
        return Character.isDigit((char)n) || 97 <= n && n <= 102 || 65 <= n && n <= 70;
    }

    private boolean check_next(String string) throws IOException {
        if (string.indexOf(this.current) < 0) {
            return false;
        }
        this.save_and_next();
        return true;
    }

    private boolean currIsNewline() {
        return this.current == 10 || this.current == 13;
    }

    private void inclinenumber() throws IOException {
        int n = this.current;
        this.next();
        if (this.currIsNewline() && this.current != n) {
            this.next();
        }
        if (++this.linenumber < 0) {
            this.xSyntaxerror("chunk has too many lines");
        }
    }

    private int skip_sep() throws IOException {
        int n = 0;
        int n2 = this.current;
        this.save_and_next();
        while (this.current == 61) {
            this.save_and_next();
            ++n;
        }
        return this.current == n2 ? n : -n - 1;
    }

    private void read_long_string(boolean bl, int n) throws IOException {
        this.save_and_next();
        if (this.currIsNewline()) {
            this.inclinenumber();
        }
        block5: while (true) {
            switch (this.current) {
                case -1: {
                    this.xLexerror(bl ? "unfinished long string" : "unfinished long comment", 287);
                    continue block5;
                }
                case 93: {
                    if (this.skip_sep() != n) continue block5;
                    this.save_and_next();
                    break block5;
                }
                case 10: 
                case 13: {
                    this.save(10);
                    this.inclinenumber();
                    if (bl) continue block5;
                    this.buff.setLength(0);
                    continue block5;
                }
                default: {
                    if (bl) {
                        this.save_and_next();
                        continue block5;
                    }
                    this.next();
                    continue block5;
                }
            }
            break;
        }
        if (bl) {
            String string = this.buff.toString();
            int n2 = 2 + n;
            this.semS = string.substring(n2, string.length() - n2);
        }
    }

    private int llex() throws IOException {
        this.buff.setLength(0);
        block12: while (true) {
            switch (this.current) {
                case 10: 
                case 13: {
                    this.inclinenumber();
                    continue block12;
                }
                case 45: {
                    int n;
                    this.next();
                    if (this.current != 45) {
                        return 45;
                    }
                    this.next();
                    if (this.current == 91) {
                        n = this.skip_sep();
                        this.buff.setLength(0);
                        if (n >= 0) {
                            this.read_long_string(false, n);
                            this.buff.setLength(0);
                            continue block12;
                        }
                    }
                    while (true) {
                        if (this.currIsNewline() || this.current == -1) continue block12;
                        this.next();
                    }
                }
                case 91: {
                    int n = this.skip_sep();
                    if (n >= 0) {
                        this.read_long_string(true, n);
                        return 286;
                    }
                    if (n == -1) {
                        return 91;
                    }
                    this.xLexerror("invalid long string delimiter", 286);
                    continue block12;
                }
                case 61: {
                    this.next();
                    if (this.current != 61) {
                        return 61;
                    }
                    this.next();
                    return 280;
                }
                case 60: {
                    this.next();
                    if (this.current != 61) {
                        return 60;
                    }
                    this.next();
                    return 282;
                }
                case 62: {
                    this.next();
                    if (this.current != 61) {
                        return 62;
                    }
                    this.next();
                    return 281;
                }
                case 126: {
                    this.next();
                    if (this.current != 61) {
                        return 126;
                    }
                    this.next();
                    return 283;
                }
                case 34: 
                case 39: {
                    this.read_string(this.current);
                    return 286;
                }
                case 46: {
                    this.save_and_next();
                    if (this.check_next(".")) {
                        if (this.check_next(".")) {
                            return 279;
                        }
                        return 278;
                    }
                    if (!Syntax.isdigit(this.current)) {
                        return 46;
                    }
                    this.read_numeral();
                    return 284;
                }
                case -1: {
                    return 287;
                }
            }
            if (!Syntax.isspace(this.current)) break;
            this.next();
        }
        if (Syntax.isdigit(this.current)) {
            this.read_numeral();
            return 284;
        }
        if (Syntax.isalpha(this.current) || this.current == 95) {
            do {
                this.save_and_next();
            } while (Syntax.isalnum(this.current) || this.current == 95);
            String string = this.buff.toString();
            Object object = reserved.get(string);
            if (object == null) {
                this.semS = string;
                return 285;
            }
            return (Integer)object;
        }
        int n = this.current;
        this.next();
        return n;
    }

    private void next() throws IOException {
        this.current = this.z.read();
    }

    private static final int hexCharValue(char c) throws NumberFormatException {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': {
                return 10;
            }
            case 'B': {
                return 11;
            }
            case 'C': {
                return 12;
            }
            case 'D': {
                return 13;
            }
            case 'E': {
                return 14;
            }
            case 'F': {
                return 15;
            }
            case 'a': {
                return 10;
            }
            case 'b': {
                return 11;
            }
            case 'c': {
                return 12;
            }
            case 'd': {
                return 13;
            }
            case 'e': {
                return 14;
            }
            case 'f': {
                return 15;
            }
        }
        throw new NumberFormatException("Bad hexadecimal digit");
    }

    private void read_numeral() throws IOException {
        do {
            this.save_and_next();
        } while (Syntax.isdigit(this.current) || this.current == 46);
        if (this.check_next("Ee")) {
            this.check_next("+-");
        }
        while (Syntax.isalnum(this.current) || this.current == 95) {
            this.save_and_next();
        }
        try {
            String string = this.buff.toString();
            if (string.length() > 2 && string.charAt(0) == '0' && string.charAt(1) == 'x') {
                double d = 0.0;
                for (int i = 2; i < string.length(); ++i) {
                    d = d * 16.0 + (double)Syntax.hexCharValue(string.charAt(i));
                }
                this.semR = d;
                return;
            }
            this.semR = Double.parseDouble(string);
            return;
        }
        catch (NumberFormatException numberFormatException) {
            this.xLexerror("malformed number", 284);
            return;
        }
    }

    private void read_string(int n) throws IOException {
        this.save_and_next();
        block16: while (this.current != n) {
            switch (this.current) {
                case -1: {
                    this.xLexerror("unfinished string", 287);
                    continue block16;
                }
                case 10: 
                case 13: {
                    this.xLexerror("unfinished string", 286);
                    continue block16;
                }
                case 92: {
                    int n2;
                    this.next();
                    switch (this.current) {
                        case 97: {
                            n2 = 7;
                            break;
                        }
                        case 98: {
                            n2 = 8;
                            break;
                        }
                        case 102: {
                            n2 = 12;
                            break;
                        }
                        case 110: {
                            n2 = 10;
                            break;
                        }
                        case 114: {
                            n2 = 13;
                            break;
                        }
                        case 116: {
                            n2 = 9;
                            break;
                        }
                        case 118: {
                            n2 = 11;
                            break;
                        }
                        case 10: 
                        case 13: {
                            this.save(10);
                            this.inclinenumber();
                            continue block16;
                        }
                        case -1: {
                            continue block16;
                        }
                        default: {
                            if (!Syntax.isdigit(this.current)) {
                                this.save_and_next();
                                continue block16;
                            }
                            int n3 = 0;
                            n2 = 0;
                            do {
                                n2 = 10 * n2 + (this.current - 48);
                                this.next();
                            } while (++n3 < 3 && Syntax.isdigit(this.current));
                            this.save(n2);
                            continue block16;
                        }
                    }
                    this.save(n2);
                    this.next();
                    continue block16;
                }
            }
            this.save_and_next();
        }
        this.save_and_next();
        String string = this.buff.toString();
        this.semS = string.substring(1, string.length() - 1);
    }

    private void save() {
        this.buff.append((char)this.current);
    }

    private void save(int n) {
        this.buff.append((char)n);
    }

    private void save_and_next() throws IOException {
        this.save();
        this.next();
    }

    String source() {
        return this.source;
    }

    private String txtToken(int n) {
        switch (n) {
            case 284: 
            case 285: 
            case 286: {
                return this.buff.toString();
            }
        }
        return Syntax.xToken2str(n);
    }

    private void xLexerror(String string, int n) {
        string = this.source + ":" + this.linenumber + ": " + string;
        if (n != 0) {
            string = string + " near '" + this.txtToken(n) + "'";
        }
        this.L.pushString(string);
        this.L.dThrow(3);
    }

    private void xNext() throws IOException {
        this.lastline = this.linenumber;
        if (this.lookahead != 287) {
            this.token = this.lookahead;
            this.tokenR = this.lookaheadR;
            this.tokenS = this.lookaheadS;
            this.lookahead = 287;
        } else {
            this.token = this.llex();
            this.tokenR = this.semR;
            this.tokenS = this.semS;
        }
    }

    void xSyntaxerror(String string) {
        this.xLexerror(string, this.token);
    }

    private static String xToken2str(int n) {
        if (n < 257) {
            if (Syntax.iscntrl(n)) {
                return "char(" + n + ")";
            }
            return new Character((char)n).toString();
        }
        return tokens[n - 257];
    }

    private static boolean block_follow(int n) {
        switch (n) {
            case 260: 
            case 261: 
            case 262: 
            case 276: 
            case 287: {
                return true;
            }
        }
        return false;
    }

    private void check(int n) {
        if (this.token != n) {
            this.error_expected(n);
        }
    }

    private void check_match(int n, int n2, int n3) throws IOException {
        if (!this.testnext(n)) {
            if (n3 == this.linenumber) {
                this.error_expected(n);
            } else {
                this.xSyntaxerror("'" + Syntax.xToken2str(n) + "' expected (to close '" + Syntax.xToken2str(n2) + "' at line " + n3 + ")");
            }
        }
    }

    private void close_func() {
        this.removevars(0);
        this.fs.kRet(0, 0);
        this.fs.close();
        this.fs = this.fs.prev;
    }

    static String opcode_name(int n) {
        switch (n) {
            case 0: {
                return "MOVE";
            }
            case 1: {
                return "LOADK";
            }
            case 2: {
                return "LOADBOOL";
            }
            case 3: {
                return "LOADNIL";
            }
            case 4: {
                return "GETUPVAL";
            }
            case 5: {
                return "GETGLOBAL";
            }
            case 6: {
                return "GETTABLE";
            }
            case 7: {
                return "SETGLOBAL";
            }
            case 8: {
                return "SETUPVAL";
            }
            case 9: {
                return "SETTABLE";
            }
            case 10: {
                return "NEWTABLE";
            }
            case 11: {
                return "SELF";
            }
            case 12: {
                return "ADD";
            }
            case 13: {
                return "SUB";
            }
            case 14: {
                return "MUL";
            }
            case 15: {
                return "DIV";
            }
            case 16: {
                return "MOD";
            }
            case 17: {
                return "POW";
            }
            case 18: {
                return "UNM";
            }
            case 19: {
                return "NOT";
            }
            case 20: {
                return "LEN";
            }
            case 21: {
                return "CONCAT";
            }
            case 22: {
                return "JMP";
            }
            case 23: {
                return "EQ";
            }
            case 24: {
                return "LT";
            }
            case 25: {
                return "LE";
            }
            case 26: {
                return "TEST";
            }
            case 27: {
                return "TESTSET";
            }
            case 28: {
                return "CALL";
            }
            case 29: {
                return "TAILCALL";
            }
            case 30: {
                return "RETURN";
            }
            case 31: {
                return "FORLOOP";
            }
            case 32: {
                return "FORPREP";
            }
            case 33: {
                return "TFORLOOP";
            }
            case 34: {
                return "SETLIST";
            }
            case 35: {
                return "CLOSE";
            }
            case 36: {
                return "CLOSURE";
            }
            case 37: {
                return "VARARG";
            }
        }
        return "??" + n;
    }

    private void codestring(Expdesc expdesc, String string) {
        expdesc.init(4, this.fs.kStringK(string));
    }

    private void checkname(Expdesc expdesc) throws IOException {
        this.codestring(expdesc, this.str_checkname());
    }

    private void enterlevel() {
        ++this.L.nCcalls;
    }

    private void error_expected(int n) {
        this.xSyntaxerror("'" + Syntax.xToken2str(n) + "' expected");
    }

    private void leavelevel() {
        --this.L.nCcalls;
    }

    static Proto parser(Lua lua, Reader reader, String string) throws IOException {
        Syntax syntax = new Syntax(lua, reader, string);
        FuncState funcState = new FuncState(syntax);
        syntax.open_func(funcState);
        funcState.f.setIsVararg();
        syntax.xNext();
        syntax.chunk();
        syntax.check(287);
        syntax.close_func();
        return funcState.f;
    }

    private void removevars(int n) {
        while (this.fs.nactvar > n) {
            this.fs.nactvar = (short)(this.fs.nactvar - 1);
            this.fs.getlocvar((int)((short)(this.fs.nactvar - 1))).endpc = this.fs.pc;
        }
    }

    private void singlevar(Expdesc expdesc) throws IOException {
        String string = this.str_checkname();
        if (this.singlevaraux(this.fs, string, expdesc, true) == 8) {
            expdesc.setInfo(this.fs.kStringK(string));
        }
    }

    private int singlevaraux(FuncState funcState, String string, Expdesc expdesc, boolean bl) {
        if (funcState == null) {
            expdesc.init(8, 255);
            return 8;
        }
        int n = funcState.searchvar(string);
        if (n >= 0) {
            expdesc.init(6, n);
            if (!bl) {
                funcState.markupval(n);
            }
            return 6;
        }
        if (this.singlevaraux(funcState.prev, string, expdesc, false) == 8) {
            return 8;
        }
        expdesc.upval(this.indexupvalue(funcState, string, expdesc));
        return 7;
    }

    private String str_checkname() throws IOException {
        this.check(285);
        String string = this.tokenS;
        this.xNext();
        return string;
    }

    private boolean testnext(int n) throws IOException {
        if (this.token == n) {
            this.xNext();
            return true;
        }
        return false;
    }

    private void chunk() throws IOException {
        boolean bl = false;
        this.enterlevel();
        while (!bl && !Syntax.block_follow(this.token)) {
            bl = this.statement();
            this.testnext(59);
            this.fs.freereg = this.fs.nactvar;
        }
        this.leavelevel();
    }

    private void constructor(Expdesc expdesc) throws IOException {
        int n = this.linenumber;
        int n2 = this.fs.kCodeABC(10, 0, 0, 0);
        ConsControl consControl = new ConsControl(expdesc);
        expdesc.init(11, n2);
        consControl.v.init(0, 0);
        this.fs.kExp2nextreg(expdesc);
        this.checknext(123);
        while (this.token != 125) {
            this.closelistfield(consControl);
            switch (this.token) {
                case 285: {
                    this.xLookahead();
                    if (this.lookahead != 61) {
                        this.listfield(consControl);
                        break;
                    }
                    this.recfield(consControl);
                    break;
                }
                case 91: {
                    this.recfield(consControl);
                    break;
                }
                default: {
                    this.listfield(consControl);
                }
            }
            if (this.testnext(44) || this.testnext(59)) continue;
        }
        this.check_match(125, 123, n);
        this.lastlistfield(consControl);
        int[] nArray = this.fs.f.code;
        nArray[n2] = Lua.SETARG_B(nArray[n2], Syntax.oInt2fb(consControl.na));
        nArray[n2] = Lua.SETARG_C(nArray[n2], Syntax.oInt2fb(consControl.nh));
    }

    private static int oInt2fb(int n) {
        int n2 = 0;
        while (n < 0 || n >= 16) {
            n = n + 1 >>> 1;
            ++n2;
        }
        return n < 8 ? n : n2 + 1 << 3 | n - 8;
    }

    private void recfield(ConsControl consControl) throws IOException {
        int n = this.fs.freereg;
        Expdesc expdesc = new Expdesc();
        Expdesc expdesc2 = new Expdesc();
        if (this.token == 285) {
            this.checkname(expdesc);
        } else {
            this.yindex(expdesc);
        }
        ++consControl.nh;
        this.checknext(61);
        this.fs.kExp2RK(expdesc);
        this.expr(expdesc2);
        this.fs.kCodeABC(9, consControl.t.info, this.fs.kExp2RK(expdesc), this.fs.kExp2RK(expdesc2));
        this.fs.freereg = n;
    }

    private void lastlistfield(ConsControl consControl) {
        if (consControl.tostore == 0) {
            return;
        }
        if (Syntax.hasmultret(consControl.v.k)) {
            this.fs.kSetmultret(consControl.v);
            this.fs.kSetlist(consControl.t.info, consControl.na, -1);
            --consControl.na;
        } else {
            if (consControl.v.k != 0) {
                this.fs.kExp2nextreg(consControl.v);
            }
            this.fs.kSetlist(consControl.t.info, consControl.na, consControl.tostore);
        }
    }

    private void closelistfield(ConsControl consControl) {
        if (consControl.v.k == 0) {
            return;
        }
        this.fs.kExp2nextreg(consControl.v);
        consControl.v.k = 0;
        if (consControl.tostore == 50) {
            this.fs.kSetlist(consControl.t.info, consControl.na, consControl.tostore);
            consControl.tostore = 0;
        }
    }

    private void expr(Expdesc expdesc) throws IOException {
        this.subexpr(expdesc, 0);
    }

    private int explist1(Expdesc expdesc) throws IOException {
        int n = 1;
        this.expr(expdesc);
        while (this.testnext(44)) {
            this.fs.kExp2nextreg(expdesc);
            this.expr(expdesc);
            ++n;
        }
        return n;
    }

    private void exprstat() throws IOException {
        LHSAssign lHSAssign = new LHSAssign();
        this.primaryexp(lHSAssign.v);
        if (lHSAssign.v.k == 13) {
            this.fs.setargc(lHSAssign.v, 1);
        } else {
            lHSAssign.prev = null;
            this.assignment(lHSAssign, 1);
        }
    }

    private void check_conflict(LHSAssign lHSAssign, Expdesc expdesc) {
        int n = this.fs.freereg;
        boolean bl = false;
        while (lHSAssign != null) {
            if (lHSAssign.v.k == 9) {
                if (lHSAssign.v.info == expdesc.info) {
                    bl = true;
                    lHSAssign.v.info = n;
                }
                if (lHSAssign.v.aux == expdesc.info) {
                    bl = true;
                    lHSAssign.v.aux = n;
                }
            }
            lHSAssign = lHSAssign.prev;
        }
        if (bl) {
            this.fs.kCodeABC(0, this.fs.freereg, expdesc.info, 0);
            this.fs.kReserveregs(1);
        }
    }

    private void assignment(LHSAssign lHSAssign, int n) throws IOException {
        Expdesc expdesc = new Expdesc();
        int n2 = lHSAssign.v.k;
        if (6 > n2 || n2 > 9) {
            this.xSyntaxerror("syntax error");
        }
        if (this.testnext(44)) {
            LHSAssign lHSAssign2 = new LHSAssign(lHSAssign);
            this.primaryexp(lHSAssign2.v);
            if (lHSAssign2.v.k == 6) {
                this.check_conflict(lHSAssign, lHSAssign2.v);
            }
            this.assignment(lHSAssign2, n + 1);
        } else {
            this.checknext(61);
            int n3 = this.explist1(expdesc);
            if (n3 != n) {
                this.adjust_assign(n, n3, expdesc);
                if (n3 > n) {
                    this.fs.freereg -= n3 - n;
                }
            } else {
                this.fs.kSetoneret(expdesc);
                this.fs.kStorevar(lHSAssign.v, expdesc);
                return;
            }
        }
        expdesc.init(12, this.fs.freereg - 1);
        this.fs.kStorevar(lHSAssign.v, expdesc);
    }

    private void funcargs(Expdesc expdesc) throws IOException {
        int n;
        Expdesc expdesc2 = new Expdesc();
        int n2 = this.linenumber;
        switch (this.token) {
            case 40: {
                if (n2 != this.lastline) {
                    this.xSyntaxerror("ambiguous syntax (function call x new statement)");
                }
                this.xNext();
                if (this.token == 41) {
                    expdesc2.setKind(0);
                } else {
                    this.explist1(expdesc2);
                    this.fs.kSetmultret(expdesc2);
                }
                this.check_match(41, 40, n2);
                break;
            }
            case 123: {
                this.constructor(expdesc2);
                break;
            }
            case 286: {
                this.codestring(expdesc2, this.tokenS);
                this.xNext();
                break;
            }
            default: {
                this.xSyntaxerror("function arguments expected");
                return;
            }
        }
        int n3 = expdesc.info();
        if (expdesc2.hasmultret()) {
            n = -1;
        } else {
            if (expdesc2.kind() != 0) {
                this.fs.kExp2nextreg(expdesc2);
            }
            n = this.fs.freereg - (n3 + 1);
        }
        expdesc.init(13, this.fs.kCodeABC(28, n3, n + 1, 2));
        this.fs.kFixline(n2);
        this.fs.freereg = n3 + 1;
    }

    private void prefixexp(Expdesc expdesc) throws IOException {
        switch (this.token) {
            case 40: {
                int n = this.linenumber;
                this.xNext();
                this.expr(expdesc);
                this.check_match(41, 40, n);
                this.fs.kDischargevars(expdesc);
                return;
            }
            case 285: {
                this.singlevar(expdesc);
                return;
            }
        }
        this.xSyntaxerror("unexpected symbol");
    }

    private void primaryexp(Expdesc expdesc) throws IOException {
        this.prefixexp(expdesc);
        block6: while (true) {
            switch (this.token) {
                case 46: {
                    this.field(expdesc);
                    continue block6;
                }
                case 91: {
                    Expdesc expdesc2 = new Expdesc();
                    this.fs.kExp2anyreg(expdesc);
                    this.yindex(expdesc2);
                    this.fs.kIndexed(expdesc, expdesc2);
                    continue block6;
                }
                case 58: {
                    Expdesc expdesc2 = new Expdesc();
                    this.xNext();
                    this.checkname(expdesc2);
                    this.fs.kSelf(expdesc, expdesc2);
                    this.funcargs(expdesc);
                    continue block6;
                }
                case 40: 
                case 123: 
                case 286: {
                    this.fs.kExp2nextreg(expdesc);
                    this.funcargs(expdesc);
                    continue block6;
                }
            }
            break;
        }
    }

    private void retstat() throws IOException {
        int n;
        this.xNext();
        int n2 = 0;
        if (Syntax.block_follow(this.token) || this.token == 59) {
            n2 = 0;
            n = 0;
        } else {
            Expdesc expdesc = new Expdesc();
            n = this.explist1(expdesc);
            if (Syntax.hasmultret(expdesc.k)) {
                this.fs.kSetmultret(expdesc);
                if (expdesc.k == 13 && n == 1) {
                    this.fs.setcode(expdesc, Lua.SET_OPCODE(this.fs.getcode(expdesc), 29));
                }
                n2 = this.fs.nactvar;
                n = -1;
            } else if (n == 1) {
                n2 = this.fs.kExp2anyreg(expdesc);
            } else {
                this.fs.kExp2nextreg(expdesc);
                n2 = this.fs.nactvar;
            }
        }
        this.fs.kRet(n2, n);
    }

    private void simpleexp(Expdesc expdesc) throws IOException {
        switch (this.token) {
            case 284: {
                expdesc.init(5, 0);
                expdesc.nval = this.tokenR;
                break;
            }
            case 286: {
                this.codestring(expdesc, this.tokenS);
                break;
            }
            case 269: {
                expdesc.init(1, 0);
                break;
            }
            case 275: {
                expdesc.init(2, 0);
                break;
            }
            case 263: {
                expdesc.init(3, 0);
                break;
            }
            case 279: {
                if (!this.fs.f.isVararg()) {
                    this.xSyntaxerror("cannot use \"...\" outside a vararg function");
                }
                expdesc.init(14, this.fs.kCodeABC(37, 0, 1, 0));
                break;
            }
            case 123: {
                this.constructor(expdesc);
                return;
            }
            case 265: {
                this.xNext();
                this.body(expdesc, false, this.linenumber);
                return;
            }
            default: {
                this.primaryexp(expdesc);
                return;
            }
        }
        this.xNext();
    }

    private boolean statement() throws IOException {
        int n = this.linenumber;
        switch (this.token) {
            case 266: {
                this.ifstat(n);
                return false;
            }
            case 277: {
                this.whilestat(n);
                return false;
            }
            case 259: {
                this.xNext();
                this.block();
                this.check_match(262, 259, n);
                return false;
            }
            case 264: {
                this.forstat(n);
                return false;
            }
            case 272: {
                this.repeatstat(n);
                return false;
            }
            case 265: {
                this.funcstat(n);
                return false;
            }
            case 268: {
                this.xNext();
                if (this.testnext(265)) {
                    this.localfunc();
                } else {
                    this.localstat();
                }
                return false;
            }
            case 273: {
                this.retstat();
                return true;
            }
            case 258: {
                this.xNext();
                this.breakstat();
                return true;
            }
        }
        this.exprstat();
        return false;
    }

    private static int getbinopr(int n) {
        switch (n) {
            case 43: {
                return 0;
            }
            case 45: {
                return 1;
            }
            case 42: {
                return 2;
            }
            case 47: {
                return 3;
            }
            case 37: {
                return 4;
            }
            case 94: {
                return 5;
            }
            case 278: {
                return 6;
            }
            case 283: {
                return 7;
            }
            case 280: {
                return 8;
            }
            case 60: {
                return 9;
            }
            case 282: {
                return 10;
            }
            case 62: {
                return 11;
            }
            case 281: {
                return 12;
            }
            case 257: {
                return 13;
            }
            case 271: {
                return 14;
            }
        }
        return 15;
    }

    private static int getunopr(int n) {
        switch (n) {
            case 270: {
                return 1;
            }
            case 45: {
                return 0;
            }
            case 35: {
                return 2;
            }
        }
        return 3;
    }

    private int subexpr(Expdesc expdesc, int n) throws IOException {
        this.enterlevel();
        int n2 = Syntax.getunopr(this.token);
        if (n2 != 3) {
            this.xNext();
            this.subexpr(expdesc, 8);
            this.fs.kPrefix(n2, expdesc);
        } else {
            this.simpleexp(expdesc);
        }
        int n3 = Syntax.getbinopr(this.token);
        while (n3 != 15 && PRIORITY[n3][0] > n) {
            Expdesc expdesc2 = new Expdesc();
            this.xNext();
            this.fs.kInfix(n3, expdesc);
            int n4 = this.subexpr(expdesc2, PRIORITY[n3][1]);
            this.fs.kPosfix(n3, expdesc, expdesc2);
            n3 = n4;
        }
        this.leavelevel();
        return n3;
    }

    private void enterblock(FuncState funcState, BlockCnt blockCnt, boolean bl) {
        blockCnt.breaklist = -1;
        blockCnt.isbreakable = bl;
        blockCnt.nactvar = funcState.nactvar;
        blockCnt.upval = false;
        blockCnt.previous = funcState.bl;
        funcState.bl = blockCnt;
    }

    private void leaveblock(FuncState funcState) {
        BlockCnt blockCnt = funcState.bl;
        funcState.bl = blockCnt.previous;
        this.removevars(blockCnt.nactvar);
        if (blockCnt.upval) {
            funcState.kCodeABC(35, blockCnt.nactvar, 0, 0);
        }
        funcState.freereg = funcState.nactvar;
        funcState.kPatchtohere(blockCnt.breaklist);
    }

    private void block() throws IOException {
        BlockCnt blockCnt = new BlockCnt();
        this.enterblock(this.fs, blockCnt, false);
        this.chunk();
        this.leaveblock(this.fs);
    }

    private void breakstat() {
        BlockCnt blockCnt = this.fs.bl;
        boolean bl = false;
        while (blockCnt != null && !blockCnt.isbreakable) {
            bl |= blockCnt.upval;
            blockCnt = blockCnt.previous;
        }
        if (blockCnt == null) {
            this.xSyntaxerror("no loop to break");
        }
        if (bl) {
            this.fs.kCodeABC(35, blockCnt.nactvar, 0, 0);
        }
        blockCnt.breaklist = this.fs.kConcat(blockCnt.breaklist, this.fs.kJump());
    }

    private void funcstat(int n) throws IOException {
        Expdesc expdesc = new Expdesc();
        Expdesc expdesc2 = new Expdesc();
        this.xNext();
        boolean bl = this.funcname(expdesc2);
        this.body(expdesc, bl, n);
        this.fs.kStorevar(expdesc2, expdesc);
        this.fs.kFixline(n);
    }

    private void checknext(int n) throws IOException {
        this.check(n);
        this.xNext();
    }

    private void parlist() throws IOException {
        Proto proto = this.fs.f;
        int n = 0;
        if (this.token != 41) {
            do {
                switch (this.token) {
                    case 285: {
                        this.new_localvar(this.str_checkname(), n++);
                        break;
                    }
                    case 279: {
                        this.xNext();
                        proto.setIsVararg();
                        break;
                    }
                    default: {
                        this.xSyntaxerror("<name> or '...' expected");
                    }
                }
            } while (!proto.isVararg() && this.testnext(44));
        }
        this.adjustlocalvars(n);
        proto.numparams = this.fs.nactvar;
        this.fs.kReserveregs(this.fs.nactvar);
    }

    private LocVar getlocvar(int n) {
        FuncState funcState = this.fs;
        return funcState.f.locvars[funcState.actvar[n]];
    }

    private void adjustlocalvars(int n) {
        this.fs.nactvar = (short)(this.fs.nactvar + n);
        while (n != 0) {
            this.getlocvar((int)(this.fs.nactvar - n)).startpc = this.fs.pc;
            --n;
        }
    }

    private void new_localvarliteral(String string, int n) {
        this.new_localvar(string, n);
    }

    private void errorlimit(int n, String string) {
        String string2 = this.fs.f.linedefined == 0 ? "main function has more than " + n + " " + string : "function at line " + this.fs.f.linedefined + " has more than " + n + " " + string;
        this.xLexerror(string2, 0);
    }

    private void yChecklimit(int n, int n2, String string) {
        if (n > n2) {
            this.errorlimit(n2, string);
        }
    }

    private void new_localvar(String string, int n) {
        this.yChecklimit(this.fs.nactvar + n + 1, 200, "local variables");
        this.fs.actvar[this.fs.nactvar + n] = (short)this.registerlocalvar(string);
    }

    private int registerlocalvar(String string) {
        Proto proto = this.fs.f;
        proto.ensureLocvars(this.L, this.fs.nlocvars, Short.MAX_VALUE);
        proto.locvars[this.fs.nlocvars].varname = string;
        short s = this.fs.nlocvars;
        this.fs.nlocvars = (short)(s + 1);
        return s;
    }

    private void body(Expdesc expdesc, boolean bl, int n) throws IOException {
        FuncState funcState = new FuncState(this);
        this.open_func(funcState);
        funcState.f.linedefined = n;
        this.checknext(40);
        if (bl) {
            this.new_localvarliteral("self", 0);
            this.adjustlocalvars(1);
        }
        this.parlist();
        this.checknext(41);
        this.chunk();
        funcState.f.lastlinedefined = this.linenumber;
        this.check_match(262, 265, n);
        this.close_func();
        this.pushclosure(funcState, expdesc);
    }

    private int UPVAL_K(int n) {
        return n >>> 8 & 0xFF;
    }

    private int UPVAL_INFO(int n) {
        return n & 0xFF;
    }

    private int UPVAL_ENCODE(int n, int n2) {
        return (n & 0xFF) << 8 | n2 & 0xFF;
    }

    private void pushclosure(FuncState funcState, Expdesc expdesc) {
        Proto proto = this.fs.f;
        proto.ensureProtos(this.L, this.fs.np);
        Proto proto2 = funcState.f;
        proto.p[this.fs.np++] = proto2;
        expdesc.init(11, this.fs.kCodeABx(36, 0, this.fs.np - 1));
        for (int i = 0; i < proto2.nups; ++i) {
            int n = funcState.upvalues[i];
            int n2 = this.UPVAL_K(n) == 6 ? 0 : 4;
            this.fs.kCodeABC(n2, 0, this.UPVAL_INFO(n), 0);
        }
    }

    private boolean funcname(Expdesc expdesc) throws IOException {
        boolean bl = false;
        this.singlevar(expdesc);
        while (this.token == 46) {
            this.field(expdesc);
        }
        if (this.token == 58) {
            bl = true;
            this.field(expdesc);
        }
        return bl;
    }

    private void field(Expdesc expdesc) throws IOException {
        Expdesc expdesc2 = new Expdesc();
        this.fs.kExp2anyreg(expdesc);
        this.xNext();
        this.checkname(expdesc2);
        this.fs.kIndexed(expdesc, expdesc2);
    }

    private void repeatstat(int n) throws IOException {
        int n2 = this.fs.kGetlabel();
        BlockCnt blockCnt = new BlockCnt();
        BlockCnt blockCnt2 = new BlockCnt();
        this.enterblock(this.fs, blockCnt, true);
        this.enterblock(this.fs, blockCnt2, false);
        this.xNext();
        this.chunk();
        this.check_match(276, 272, n);
        int n3 = this.cond();
        if (!blockCnt2.upval) {
            this.leaveblock(this.fs);
            this.fs.kPatchlist(n3, n2);
        } else {
            this.breakstat();
            this.fs.kPatchtohere(n3);
            this.leaveblock(this.fs);
            this.fs.kPatchlist(this.fs.kJump(), n2);
        }
        this.leaveblock(this.fs);
    }

    private int cond() throws IOException {
        Expdesc expdesc = new Expdesc();
        this.expr(expdesc);
        if (expdesc.k == 1) {
            expdesc.k = 3;
        }
        this.fs.kGoiftrue(expdesc);
        return expdesc.f;
    }

    private void open_func(FuncState funcState) {
        Proto proto;
        funcState.f = proto = new Proto(this.source, 2);
        funcState.ls = this;
        funcState.L = this.L;
        funcState.prev = this.fs;
        this.fs = funcState;
    }

    private void localstat() throws IOException {
        int n;
        int n2 = 0;
        Expdesc expdesc = new Expdesc();
        do {
            this.new_localvar(this.str_checkname(), n2++);
        } while (this.testnext(44));
        if (this.testnext(61)) {
            n = this.explist1(expdesc);
        } else {
            expdesc.k = 0;
            n = 0;
        }
        this.adjust_assign(n2, n, expdesc);
        this.adjustlocalvars(n2);
    }

    private void forstat(int n) throws IOException {
        BlockCnt blockCnt = new BlockCnt();
        this.enterblock(this.fs, blockCnt, true);
        this.xNext();
        String string = this.str_checkname();
        switch (this.token) {
            case 61: {
                this.fornum(string, n);
                break;
            }
            case 44: 
            case 267: {
                this.forlist(string);
                break;
            }
            default: {
                this.xSyntaxerror("\"=\" or \"in\" expected");
            }
        }
        this.check_match(262, 264, n);
        this.leaveblock(this.fs);
    }

    private void fornum(String string, int n) throws IOException {
        int n2 = this.fs.freereg;
        this.new_localvarliteral("(for index)", 0);
        this.new_localvarliteral("(for limit)", 1);
        this.new_localvarliteral("(for step)", 2);
        this.new_localvar(string, 3);
        this.checknext(61);
        this.exp1();
        this.checknext(44);
        this.exp1();
        if (this.testnext(44)) {
            this.exp1();
        } else {
            this.fs.kCodeABx(1, this.fs.freereg, this.fs.kNumberK(1.0));
            this.fs.kReserveregs(1);
        }
        this.forbody(n2, n, 1, true);
    }

    private int exp1() throws IOException {
        Expdesc expdesc = new Expdesc();
        this.expr(expdesc);
        int n = expdesc.k;
        this.fs.kExp2nextreg(expdesc);
        return n;
    }

    private void forlist(String string) throws IOException {
        Expdesc expdesc = new Expdesc();
        int n = 0;
        int n2 = this.fs.freereg;
        this.new_localvarliteral("(for generator)", n++);
        this.new_localvarliteral("(for state)", n++);
        this.new_localvarliteral("(for control)", n++);
        this.new_localvar(string, n++);
        while (this.testnext(44)) {
            this.new_localvar(this.str_checkname(), n++);
        }
        this.checknext(267);
        int n3 = this.linenumber;
        this.adjust_assign(3, this.explist1(expdesc), expdesc);
        this.fs.kCheckstack(3);
        this.forbody(n2, n3, n - 3, false);
    }

    private void forbody(int n, int n2, int n3, boolean bl) throws IOException {
        BlockCnt blockCnt = new BlockCnt();
        this.adjustlocalvars(3);
        this.checknext(259);
        int n4 = bl ? this.fs.kCodeAsBx(32, n, -1) : this.fs.kJump();
        this.enterblock(this.fs, blockCnt, false);
        this.adjustlocalvars(n3);
        this.fs.kReserveregs(n3);
        this.block();
        this.leaveblock(this.fs);
        this.fs.kPatchtohere(n4);
        int n5 = bl ? this.fs.kCodeAsBx(31, n, -1) : this.fs.kCodeABC(33, n, 0, n3);
        this.fs.kFixline(n2);
        this.fs.kPatchlist(bl ? n5 : this.fs.kJump(), n4 + 1);
    }

    private void ifstat(int n) throws IOException {
        int n2 = -1;
        int n3 = this.test_then_block();
        while (this.token == 261) {
            n2 = this.fs.kConcat(n2, this.fs.kJump());
            this.fs.kPatchtohere(n3);
            n3 = this.test_then_block();
        }
        if (this.token == 260) {
            n2 = this.fs.kConcat(n2, this.fs.kJump());
            this.fs.kPatchtohere(n3);
            this.xNext();
            this.block();
        } else {
            n2 = this.fs.kConcat(n2, n3);
        }
        this.fs.kPatchtohere(n2);
        this.check_match(262, 266, n);
    }

    private int test_then_block() throws IOException {
        this.xNext();
        int n = this.cond();
        this.checknext(274);
        this.block();
        return n;
    }

    private void whilestat(int n) throws IOException {
        BlockCnt blockCnt = new BlockCnt();
        this.xNext();
        int n2 = this.fs.kGetlabel();
        int n3 = this.cond();
        this.enterblock(this.fs, blockCnt, true);
        this.checknext(259);
        this.block();
        this.fs.kPatchlist(this.fs.kJump(), n2);
        this.check_match(262, 277, n);
        this.leaveblock(this.fs);
        this.fs.kPatchtohere(n3);
    }

    private static boolean hasmultret(int n) {
        return n == 13 || n == 14;
    }

    private void adjust_assign(int n, int n2, Expdesc expdesc) {
        int n3 = n - n2;
        if (Syntax.hasmultret(expdesc.k)) {
            if (++n3 < 0) {
                n3 = 0;
            }
            this.fs.kSetreturns(expdesc, n3);
            if (n3 > 1) {
                this.fs.kReserveregs(n3 - 1);
            }
        } else {
            if (expdesc.k != 0) {
                this.fs.kExp2nextreg(expdesc);
            }
            if (n3 > 0) {
                int n4 = this.fs.freereg;
                this.fs.kReserveregs(n3);
                this.fs.kNil(n4, n3);
            }
        }
    }

    private void localfunc() throws IOException {
        Expdesc expdesc = new Expdesc();
        this.new_localvar(this.str_checkname(), 0);
        Expdesc expdesc2 = new Expdesc(6, this.fs.freereg);
        this.fs.kReserveregs(1);
        this.adjustlocalvars(1);
        this.body(expdesc, false, this.linenumber);
        this.fs.kStorevar(expdesc2, expdesc);
        this.fs.getlocvar((int)(this.fs.nactvar - 1)).startpc = this.fs.pc;
    }

    private void yindex(Expdesc expdesc) throws IOException {
        this.xNext();
        this.expr(expdesc);
        this.fs.kExp2val(expdesc);
        this.checknext(93);
    }

    void xLookahead() throws IOException {
        this.lookahead = this.llex();
        this.lookaheadR = this.semR;
        this.lookaheadS = this.semS;
    }

    private void listfield(ConsControl consControl) throws IOException {
        this.expr(consControl.v);
        this.yChecklimit(consControl.na, 262143, "items in a constructor");
        ++consControl.na;
        ++consControl.tostore;
    }

    private int indexupvalue(FuncState funcState, String string, Expdesc expdesc) {
        Proto proto = funcState.f;
        for (int i = 0; i < proto.nups; ++i) {
            int n = funcState.upvalues[i];
            if (this.UPVAL_K(n) != expdesc.k || this.UPVAL_INFO(n) != expdesc.info) continue;
            return i;
        }
        this.yChecklimit(proto.nups + 1, 60, "upvalues");
        proto.ensureUpvals(this.L, proto.nups);
        proto.upvalues[proto.nups] = string;
        funcState.upvalues[proto.nups] = this.UPVAL_ENCODE(expdesc.k, expdesc.info);
        return proto.nups++;
    }

    static {
        for (int i = 0; i < 21; ++i) {
            reserved.put(tokens[i], new Integer(257 + i));
        }
        PRIORITY = new int[][]{{6, 6}, {6, 6}, {7, 7}, {7, 7}, {7, 7}, {10, 9}, {5, 4}, {3, 3}, {3, 3}, {3, 3}, {3, 3}, {3, 3}, {3, 3}, {2, 2}, {1, 1}};
    }
}

