/*
 * Decompiled with CFR 0.152.
 */
package org.jpc;

import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jpc.Exceptions;
import org.jpc.Revision;
import org.jpc.diskimages.ImageLibrary;
import org.jpc.jrsr.UTFInputLineStream;

public class Misc {
    private static boolean renameOverSupported;
    public static String emuname;

    public static String randomHexes(int n) {
        SecureRandom secureRandom = new SecureRandom();
        byte[] byArray = new byte[n];
        secureRandom.nextBytes(byArray);
        StringBuffer stringBuffer = new StringBuffer(2 * byArray.length);
        for (int i = 0; i < byArray.length; ++i) {
            int n2 = byArray[i] & 0xFF;
            stringBuffer.append(Character.forDigit(n2 / 16, 16));
            stringBuffer.append(Character.forDigit(n2 % 16, 16));
        }
        return stringBuffer.toString();
    }

    public static String tempname(String string) {
        return string + "." + Misc.randomHexes(12);
    }

    public static String arrayToString(byte[] byArray) throws IOException {
        if (byArray == null) {
            return null;
        }
        return new ImageLibrary.ByteArray(byArray).toString();
    }

    public static byte[] stringToArray(String string) throws IOException {
        if (string == null) {
            return null;
        }
        if (string.length() % 2 != 0) {
            throw new IOException("Trying to transform odd-length string into byte array");
        }
        int n = string.length() / 2;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)(Character.digit(string.charAt(2 * i), 16) * 16 + Character.digit(string.charAt(2 * i + 1), 16));
        }
        return byArray;
    }

    public static boolean isspace(char c) {
        if (c == '\f') {
            return true;
        }
        if (c == ' ') {
            return true;
        }
        if (c == '\t') {
            return true;
        }
        if (c == '\u1680') {
            return true;
        }
        if (c == '\u180e') {
            return true;
        }
        if (c >= '\u2000' && c <= '\u200a') {
            return true;
        }
        if (c == '\u2028') {
            return true;
        }
        if (c == '\u205f') {
            return true;
        }
        return c == '\u3000';
    }

    public static String componentEscape(String string) {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        Stack<Integer> stack = new Stack<Integer>();
        Stack stack2 = new Stack();
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            n = string.charAt(i);
            if (Misc.isspace((char)n)) {
                bl2 = true;
            }
            if (n == 92) {
                bl = true;
            }
            if (n == 40) {
                bl2 = true;
                stack.push(new Integer(i));
                continue;
            }
            if (n != 41) continue;
            if (!stack.empty()) {
                stack.pop();
                continue;
            }
            bl = true;
        }
        if (!stack.empty()) {
            bl = true;
        }
        while (!stack.empty()) {
            stack2.push(stack.pop());
        }
        if (!bl && !bl2) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (bl2) {
            stringBuilder.append('(');
        }
        if (bl) {
            n = 0;
            for (int i = 0; i < n2; ++i) {
                char c = string.charAt(i);
                if (c == '\\') {
                    stringBuilder.append("\\\\");
                    continue;
                }
                if (!stack2.empty() && (Integer)stack2.peek() == i) {
                    stringBuilder.append("\\(");
                    stack2.pop();
                    continue;
                }
                if (c == '(') {
                    stringBuilder.append("(");
                    ++n;
                    continue;
                }
                if (c == ')') {
                    if (n > 0) {
                        stringBuilder.append(")");
                        --n;
                        continue;
                    }
                    stringBuilder.append("\\)");
                    continue;
                }
                stringBuilder.append(c);
            }
        } else {
            stringBuilder.append(string);
        }
        if (bl2) {
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }

    public static String componentUnescape(String string) throws IOException {
        if (string.indexOf(92) < 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (bl) {
                stringBuilder.append(c);
                bl = false;
                continue;
            }
            if (c == '\\') {
                bl = true;
                continue;
            }
            stringBuilder.append(c);
        }
        if (bl) {
            throw new IOException("Invalid escaped string: unexpected end of string after \\");
        }
        return stringBuilder.toString();
    }

    public static String[] nextParseLine(UTFInputLineStream uTFInputLineStream) throws IOException {
        String[] stringArray = null;
        String string = "";
        while (string != null && "".equals(string)) {
            string = uTFInputLineStream.readLine();
        }
        if (string == null) {
            return null;
        }
        stringArray = Misc.parseString(string);
        if (stringArray == null) {
            return Misc.nextParseLine(uTFInputLineStream);
        }
        return stringArray;
    }

    public static String[] parseString(String string) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        if (string == null) {
            return null;
        }
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        for (int i = 0; i < n3; ++i) {
            String string2 = null;
            char c = string.charAt(i);
            if (bl) {
                bl = false;
            } else if (c == '\\') {
                bl = true;
            } else if (c == '(') {
                if (n > 0) {
                    ++n;
                } else if (n == 0) {
                    string2 = string.substring(n2, i);
                    n2 = i + 1;
                    ++n;
                }
            } else if (c == ')') {
                if (n == 0) {
                    throw new IOException("Unbalanced ) in component line \"" + string + "\".");
                }
                if (n == 1) {
                    string2 = string.substring(n2, i);
                    n2 = i + 1;
                    --n;
                } else {
                    --n;
                }
            } else if (n == 0 && Misc.isspace(c)) {
                string2 = Misc.componentUnescape(string.substring(n2, i));
                n2 = i + 1;
            }
            if (string2 == null || string2.equals("")) continue;
            arrayList.add(string2);
        }
        if (n > 0) {
            throw new IOException("Unbalanced ( in component line \"" + string + "\".");
        }
        String string3 = Misc.componentUnescape(string.substring(n2));
        if (string3 != null && !string3.equals("")) {
            arrayList.add(string3);
        }
        if (!arrayList.isEmpty()) {
            return arrayList.toArray(new String[arrayList.size()]);
        }
        return null;
    }

    public static boolean hasParensInserted(String string) {
        return string.charAt(0) == '(';
    }

    public static String encodeLine(String[] stringArray) {
        String string = "";
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = Misc.componentEscape(stringArray[i]);
            boolean bl2 = Misc.hasParensInserted(string2);
            if (!bl && !bl2) {
                string = string + " ";
            }
            string = string + string2;
            bl = bl2;
        }
        return string;
    }

    public static int callShowOptionDialog(Component component, Object object, String string, int n, int n2, Icon icon, Object[] objectArray, Object object2) {
        try {
            return JOptionPane.showOptionDialog(component, object, string, n, n2, icon, objectArray, object2);
        }
        catch (Throwable throwable) {
            System.err.println("MESSAGE: *** " + string + " ***: " + object.toString());
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] != object2) continue;
                return i;
            }
            return 0;
        }
    }

    public static String messageForException(Throwable throwable, boolean bl) {
        boolean bl2 = false;
        while (bl && throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        String string = throwable.getMessage();
        for (Class<?> clazz = throwable.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            if (!Exceptions.classes.containsKey(clazz.getName())) continue;
            string = string != null && !string.equals("") && !string.equals("null") ? Exceptions.classes.get(clazz.getName()) + " (" + string + ")" : Exceptions.classes.get(clazz.getName());
            if (clazz != throwable.getClass()) break;
            bl2 = true;
            break;
        }
        if (!bl2) {
            string = string != null && !string.equals("") && !string.equals("null") ? string + " [" + throwable.getClass().getName() + "]" : string + "<no description available> [" + throwable.getClass().getName() + "]";
        }
        return string;
    }

    public static void errorDialog(Throwable throwable, String string, Component component, String string2) {
        String string3 = Misc.messageForException(throwable, true);
        int n = Misc.callShowOptionDialog(null, string3, string, 0, 2, null, new String[]{string2, "Save stack trace"}, "Save stack Trace");
        if (n > 0) {
            Misc.saveStackTrace(throwable, null, string2);
        }
    }

    public static String formatStackTrace(StackTraceElement[] stackTraceElementArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (stackTraceElementArray != null && stackTraceElementArray.length == 0) {
            return "No Stack frame information available.\n";
        }
        if (stackTraceElementArray != null) {
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                if (stackTraceElement.getClassName().startsWith("sun.reflect.")) continue;
                if (stackTraceElement.isNativeMethod()) {
                    stringBuffer.append(stackTraceElement.getMethodName() + " of " + stackTraceElement.getClassName() + " <native>\n");
                    continue;
                }
                if (stackTraceElement.getFileName() != null) {
                    stringBuffer.append(stackTraceElement.getMethodName() + " of " + stackTraceElement.getClassName() + " <" + stackTraceElement.getFileName() + ":" + stackTraceElement.getLineNumber() + ">\n");
                    continue;
                }
                stringBuffer.append(stackTraceElement.getMethodName() + " of " + stackTraceElement.getClassName() + " <no location available>\n");
            }
        }
        return stringBuffer.toString();
    }

    public static void saveStackTrace(Throwable throwable, Component component, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Exception trace generated on '" + new Date().toString() + "' by version '" + Revision.getRevision() + "' (release " + Revision.getRelease() + ").\n\n");
        while (true) {
            stringBuffer.append(Misc.messageForException(throwable, false) + "\n");
            stringBuffer.append(Misc.formatStackTrace(throwable.getStackTrace()));
            if (throwable.getCause() == null) break;
            throwable = throwable.getCause();
            stringBuffer.append("\nCaused By:\n\n");
        }
        String string2 = stringBuffer.toString();
        try {
            ByteBuffer byteBuffer = Charset.forName("UTF-8").newEncoder().encode(CharBuffer.wrap(string2));
            byte[] byArray = new byte[byteBuffer.remaining()];
            byteBuffer.get(byArray);
            String string3 = "StackTrace-" + System.currentTimeMillis() + ".text";
            FileOutputStream fileOutputStream = new FileOutputStream(string3);
            ((OutputStream)fileOutputStream).write(byArray);
            ((OutputStream)fileOutputStream).close();
            Misc.callShowOptionDialog(component, "Stack trace saved to " + string3 + ".", "Stack trace saved", 0, 2, null, new String[]{string}, string);
        }
        catch (Exception exception) {
            Misc.callShowOptionDialog(component, throwable.getMessage(), "Saving stack trace failed", 0, 2, null, new String[]{string}, string);
        }
    }

    public static void doCrashDump(OutputStream outputStream) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Crash trace generated on '" + new Date().toString() + "' by version '" + Revision.getRevision() + "' (release " + Revision.getRelease() + ").\n\n");
        Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> object2 : map.entrySet()) {
            stringBuffer.append("Thread #" + object2.getKey().getId() + "(" + object2.getKey().getName() + "):\n");
            stringBuffer.append(Misc.formatStackTrace(object2.getValue()));
            stringBuffer.append("\n");
        }
        String string = stringBuffer.toString();
        ByteBuffer byteBuffer = Charset.forName("UTF-8").newEncoder().encode(CharBuffer.wrap(string));
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.get(byArray);
        outputStream.write(byArray);
    }

    public static Map<String, String> parseStringToComponents(String string) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while (!string.equals("")) {
            String string2;
            int n = string.indexOf(44);
            if (n < 0) {
                string2 = string;
                string = "";
            } else {
                string2 = string.substring(0, n);
                string = string.substring(n + 1);
            }
            int n2 = string2.indexOf(61);
            if (n2 < 0) {
                throw new IOException("Bad string element: \"" + string2 + "\"");
            }
            String string3 = string2.substring(0, n2);
            String string4 = string2.substring(n2 + 1);
            hashMap.put(string3, string4);
        }
        return hashMap;
    }

    public static InputStream openStream(String string, String string2) {
        InputStream inputStream = null;
        if (string != null) {
            try {
                inputStream = new FileInputStream(string);
            }
            catch (Exception exception) {
                inputStream = ClassLoader.getSystemResourceAsStream(string);
            }
            if (inputStream != null) {
                return inputStream;
            }
        }
        if (string2 != null) {
            System.err.println("Error: Can't open '" + string + "' falling back to default of '" + string2 + "'.");
            inputStream = ClassLoader.getSystemResourceAsStream(string2);
        }
        if (inputStream == null) {
            System.err.println("Error: Can't open '" + string + "' nor default fallback.");
        }
        return inputStream;
    }

    public static void renameFile(File file, File file2) throws IOException {
        if (!file.exists()) {
            return;
        }
        if (renameOverSupported) {
            System.err.println("Informational: Renaming file...");
            if (!file.renameTo(file2)) {
                throw new IOException("Failed to rename '" + file.getAbsolutePath() + "' to '" + file2.getAbsolutePath() + "'.");
            }
        } else {
            System.err.println("Informational: Copying & deleting file...");
            FileInputStream fileInputStream = new FileInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            byte[] byArray = new byte[1024];
            int n = 0;
            while ((n = fileInputStream.read(byArray)) >= 0) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileInputStream.close();
            fileOutputStream.close();
            file.delete();
        }
    }

    public static void probeRenameOver(boolean bl) {
        File file = null;
        File file2 = null;
        try {
            if (bl) {
                throw new IOException("Rename-over forced off");
            }
            String string = Misc.randomHexes(24);
            String string2 = Misc.randomHexes(24);
            RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rw");
            RandomAccessFile randomAccessFile2 = new RandomAccessFile(string2, "rw");
            randomAccessFile.close();
            randomAccessFile2.close();
            file = new File(string);
            file2 = new File(string2);
            if (!file.renameTo(file2)) {
                throw new IOException("Rename-over test failed");
            }
            file.delete();
            file2.delete();
        }
        catch (IOException iOException) {
            System.err.println("Informational: Probing if rename-over works...no: " + iOException.getMessage());
            System.err.println("Notice: Using copy & delete for file overwrites.");
            if (file != null) {
                file.delete();
            }
            if (file2 != null) {
                file2.delete();
            }
            return;
        }
        System.err.println("Informational: Probing if rename-over works...yes.");
        System.err.println("Notice: Using rename-over for file overwrites.");
        renameOverSupported = true;
    }

    public static void moveWindow(JFrame jFrame, int n, int n2, int n3, int n4) {
        final int n5 = n;
        final int n6 = n2;
        final int n7 = n3;
        final int n8 = n4;
        final JFrame jFrame2 = jFrame;
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Thread(){

                    @Override
                    public void run() {
                        jFrame2.setBounds(n5, n6, n7, n8);
                    }
                });
            }
            catch (Exception exception) {}
        } else {
            jFrame2.setBounds(n5, n6, n7, n8);
        }
    }

    public static boolean isFPUOp(int n) {
        switch (n) {
            case 506: 
            case 662: 
            case 663: 
            case 664: 
            case 665: 
            case 666: 
            case 667: 
            case 668: 
            case 669: 
            case 670: 
            case 671: 
            case 672: 
            case 673: 
            case 674: 
            case 675: 
            case 676: 
            case 677: 
            case 678: 
            case 679: 
            case 680: 
            case 681: 
            case 682: 
            case 683: 
            case 684: 
            case 685: 
            case 686: 
            case 687: 
            case 688: 
            case 689: 
            case 690: 
            case 691: 
            case 692: 
            case 693: 
            case 694: 
            case 695: 
            case 696: 
            case 697: 
            case 698: 
            case 699: 
            case 700: 
            case 701: 
            case 702: 
            case 703: 
            case 704: 
            case 705: 
            case 706: 
            case 707: 
            case 708: 
            case 709: 
            case 710: 
            case 711: 
            case 712: 
            case 713: 
            case 714: 
            case 715: 
            case 716: 
            case 717: 
            case 718: 
            case 719: 
            case 720: 
            case 721: 
            case 722: 
            case 723: 
            case 724: 
            case 725: 
            case 726: 
            case 727: 
            case 728: 
            case 729: 
            case 730: 
            case 731: 
            case 732: 
            case 733: 
            case 734: 
            case 735: 
            case 736: 
            case 737: 
            case 738: 
            case 739: 
            case 740: 
            case 741: 
            case 742: 
            case 743: 
            case 744: 
            case 745: 
            case 746: 
            case 747: 
            case 748: 
            case 749: 
            case 750: 
            case 751: 
            case 752: 
            case 753: {
                return true;
            }
        }
        return false;
    }

    static {
        emuname = "";
    }
}

