/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.diskimages;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;
import org.jpc.diskimages.RawDiskImage;

public class FileRawDiskImage
implements RawDiskImage {
    RandomAccessFile backingFile;
    int sectors;

    public FileRawDiskImage(String string) throws IOException {
        this.backingFile = new RandomAccessFile(string, "r");
        this.sectors = (int)this.backingFile.length() / 512;
        if (this.backingFile.length() % 512L != 0L) {
            throw new IOException("Raw image file length not divisible by 512.");
        }
    }

    @Override
    public int getSectorCount() throws IOException {
        return this.sectors;
    }

    @Override
    public boolean readSector(int n, byte[] byArray) throws IOException {
        if (n >= this.sectors) {
            throw new IOException("Trying to read sector out of range.");
        }
        this.backingFile.seek(512 * n);
        if (this.backingFile.read(byArray, 0, 512) < 512) {
            throw new IOException("Can't read sector " + n + " from image.");
        }
        return true;
    }

    @Override
    public boolean isSectorEmpty(int n) throws IOException {
        byte[] byArray = new byte[512];
        this.readSector(n, byArray);
        for (int i = 0; i < 512; ++i) {
            if (byArray[i] == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<String> getComments() {
        return null;
    }
}

