/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.diskimages;

import java.io.IOException;
import java.util.List;

public abstract class TreeFile {
    protected int clusterSize = 1;
    protected int startCluster = 0;
    protected int clusterZeroOffset = 0;
    protected String selfName;
    protected TreeFile parent;

    protected TreeFile(String string) {
        this.selfName = string;
        this.parent = null;
    }

    protected String getSelfName() {
        return this.selfName;
    }

    protected void parentTo(TreeFile treeFile) {
        this.parent = treeFile;
    }

    protected void doSetClusterSize(int n) {
        this.clusterSize = n;
    }

    public int getClusterSize() {
        return this.clusterSize;
    }

    protected void setStartCluster(int n) {
        this.startCluster = n;
    }

    public int getStartCluster() {
        return this.startCluster;
    }

    public int getEndCluster() {
        return this.startCluster + this.getSizeInClusters() - 1;
    }

    protected void doSetClusterZeroOffset(int n) {
        this.clusterZeroOffset = n;
    }

    public int getSizeInClusters() {
        int n = this.getSizeInSectors();
        return (n + this.clusterSize - 1) / this.clusterSize;
    }

    public int getSizeInSectors() {
        int n = this.getSize();
        return (n + 511) / 512;
    }

    public abstract void setClusterZeroOffset(int var1);

    public abstract void setClusterSize(int var1);

    public abstract void readSector(int var1, byte[] var2) throws IOException;

    public abstract void readSectorEnd();

    public abstract int assignCluster(int var1);

    public abstract TreeFile nextFile();

    protected abstract TreeFile nextFile(String var1);

    public abstract void addFile(TreeFile var1) throws Exception;

    public abstract int getSize();

    public abstract List<String> getComments(String var1, String var2);
}

