/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.diskimages;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.jpc.diskimages.ImageLibrary;
import org.jpc.diskimages.TreeFile;

public class TreeRegularFile
extends TreeFile {
    int size;
    RandomAccessFile cFile;
    String lookup;
    String md5;

    public TreeRegularFile(String string, String string2) throws IOException {
        super(string);
        File file = new File(string2);
        if (!file.isFile()) {
            throw new IOException("Expected " + string2 + " to be regular file, but it isn't.");
        }
        this.size = (int)file.length();
        this.cFile = null;
        this.lookup = string2;
    }

    @Override
    public void setClusterZeroOffset(int n) {
        this.doSetClusterZeroOffset(n);
    }

    @Override
    public void setClusterSize(int n) {
        this.doSetClusterSize(n);
    }

    @Override
    public void readSector(int n, byte[] byArray) throws IOException {
        int n2;
        if (this.cFile == null) {
            int n3;
            MessageDigest messageDigest;
            byte[] byArray2 = new byte[1024];
            n2 = 1;
            this.cFile = new RandomAccessFile(this.lookup, "r");
            try {
                messageDigest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new IOException("MD5 not supported by JRE?");
            }
            n2 = this.cFile.read(byArray2);
            for (n3 = 0; n2 > 0 && n3 < this.size; n3 += n2) {
                messageDigest.update(byArray2, 0, n2);
                n2 = this.cFile.read(byArray2);
            }
            if (n3 < this.size) {
                throw new IOException("Can't read from " + this.lookup + ".");
            }
            this.md5 = new ImageLibrary.ByteArray(messageDigest.digest()).toString();
        }
        int n4 = 512;
        if (n == this.size / 512) {
            n4 = this.size % 512;
        } else if (n > this.size / 512) {
            n4 = 0;
        }
        if (n4 > 0) {
            this.cFile.seek(512 * n);
            if (this.cFile.read(byArray, 0, n4) < n4) {
                throw new IOException("Can't read from " + this.lookup + ".");
            }
        }
        for (n2 = n4; n2 < 512; ++n2) {
            byArray[n2] = 0;
        }
    }

    @Override
    public void readSectorEnd() {
        try {
            this.cFile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.cFile = null;
    }

    @Override
    public int assignCluster(int n) {
        this.setStartCluster(n);
        return n + this.getSizeInClusters();
    }

    @Override
    public TreeFile nextFile() {
        return this.parent.nextFile(this.selfName);
    }

    @Override
    protected TreeFile nextFile(String string) {
        return null;
    }

    @Override
    public void addFile(TreeFile treeFile) throws Exception {
        throw new Exception("What you think I am? A subdirectory?");
    }

    @Override
    public int getSize() {
        return this.size;
    }

    private String nformatwidth(int n, int n2) {
        String string = new Integer(n).toString();
        while (string.length() < n2) {
            string = " " + string;
        }
        return string;
    }

    @Override
    public List<String> getComments(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Entry: " + string2 + " " + this.md5 + " " + this.nformatwidth(this.size, 10) + " " + string);
        return arrayList;
    }
}

