/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator;

import java.io.IOException;
import org.jpc.emulator.SRDumpable;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.SRLoader;
import org.jpc.emulator.StatusDumper;
import org.jpc.emulator.Timer;

public class TimerPriorityQueue
implements SRDumpable {
    private Node first;
    private Node last;

    @Override
    public void dumpSRPartial(SRDumper sRDumper) throws IOException {
        Node node = this.first;
        while (node != null) {
            sRDumper.dumpBoolean(true);
            sRDumper.dumpObject(node.timer);
            node = node.next;
        }
        sRDumper.dumpBoolean(false);
    }

    public TimerPriorityQueue(SRLoader sRLoader) throws IOException {
        sRLoader.objectCreated(this);
        boolean bl = sRLoader.loadBoolean();
        this.first = null;
        while (bl) {
            this.last = this.last != null ? (this.last.next = new Node()) : (this.first = new Node());
            this.last.timer = (Timer)sRLoader.loadObject();
            bl = sRLoader.loadBoolean();
        }
    }

    public TimerPriorityQueue() {
    }

    public void dumpStatusPartial(StatusDumper statusDumper) {
        Node node = this.first;
        while (node != null) {
            statusDumper.println("\ttimernode <object #" + statusDumper.objectNumber(node.timer) + ">");
            if (node.timer != null) {
                node.timer.dumpStatus(statusDumper);
            }
            node = node.next;
        }
    }

    public void dumpStatus(StatusDumper statusDumper) {
        if (statusDumper.dumped(this)) {
            return;
        }
        statusDumper.println("#" + statusDumper.objectNumber(this) + ": TimerPriorityQueue:");
        this.dumpStatusPartial(statusDumper);
        statusDumper.endObject();
    }

    public Timer peek() {
        if (this.first != null) {
            return this.first.timer;
        }
        return null;
    }

    public void remove(Timer timer) {
        Node node = null;
        Node node2 = this.first;
        while (node2 != null) {
            if (node2.timer == timer) {
                if (node == null) {
                    this.first = node2.next;
                } else {
                    node.next = node2.next;
                }
                if (node2 == this.last) {
                    this.last = node;
                }
                return;
            }
            node = node2;
            node2 = node2.next;
        }
    }

    public void offer(Timer timer) {
        Node node = new Node();
        node.timer = timer;
        Node node2 = null;
        Node node3 = this.first;
        while (node3 != null) {
            if (timer.compareTo(node3.timer) < 0) {
                node.next = node3;
                if (node2 == null) {
                    this.first = node;
                } else {
                    node2.next = node;
                }
                return;
            }
            node2 = node3;
            node3 = node3.next;
        }
        if (node2 != null) {
            node2.next = node;
        } else {
            this.first = node;
        }
        this.last = node;
    }

    public String toString() {
        return "Timer Event Queue";
    }

    public static class Node {
        public Timer timer;
        public Node next;
    }
}

