/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.memory;

import java.io.IOException;
import org.jpc.emulator.SRDumper;
import org.jpc.emulator.SRLoader;
import org.jpc.emulator.StatusDumper;
import org.jpc.emulator.memory.AbstractMemory;
import org.jpc.emulator.memory.LazyCodeBlockMemory;
import org.jpc.emulator.memory.Memory;
import org.jpc.emulator.memory.PhysicalAddressSpace;
import org.jpc.emulator.processor.Processor;

public abstract class AddressSpace
extends AbstractMemory {
    public static final int BLOCK_SIZE = 4096;
    public static final int BLOCK_MASK = 4095;
    public static final int INDEX_MASK = -4096;
    public static final int INDEX_SHIFT = 12;
    public static final int INDEX_SIZE = 0x100000;

    @Override
    public void dumpStatusPartial(StatusDumper statusDumper) {
        super.dumpStatusPartial(statusDumper);
    }

    @Override
    public void dumpStatus(StatusDumper statusDumper) {
        if (statusDumper.dumped(this)) {
            return;
        }
        statusDumper.println("#" + statusDumper.objectNumber(this) + ": AddressSpace:");
        this.dumpStatusPartial(statusDumper);
        statusDumper.endObject();
    }

    @Override
    public void dumpSRPartial(SRDumper sRDumper) throws IOException {
        super.dumpSRPartial(sRDumper);
    }

    public AddressSpace(SRLoader sRLoader) throws IOException {
        super(sRLoader);
    }

    public AddressSpace() {
    }

    @Override
    public final long getSize() {
        return 0x100000000L;
    }

    @Override
    public boolean isAllocated() {
        return true;
    }

    protected abstract Memory getReadMemoryBlockAt(int var1);

    protected abstract Memory getWriteMemoryBlockAt(int var1);

    @Override
    public abstract void clear();

    @Override
    public byte getByte(int n) {
        return this.getReadMemoryBlockAt(n).getByte(n & 0xFFF);
    }

    @Override
    public void setByte(int n, byte by) {
        this.getWriteMemoryBlockAt(n).setByte(n & 0xFFF, by);
    }

    @Override
    public short getWord(int n) {
        try {
            return this.getReadMemoryBlockAt(n).getWord(n & 0xFFF);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return super.getWord(n);
        }
    }

    @Override
    public int getDoubleWord(int n) {
        try {
            return this.getReadMemoryBlockAt(n).getDoubleWord(n & 0xFFF);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return super.getDoubleWord(n);
        }
    }

    @Override
    public long getQuadWord(int n) {
        try {
            return this.getReadMemoryBlockAt(n).getQuadWord(n & 0xFFF);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return super.getQuadWord(n);
        }
    }

    @Override
    public long getLowerDoubleQuadWord(int n) {
        try {
            return this.getReadMemoryBlockAt(n).getLowerDoubleQuadWord(n & 0xFFF);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return super.getLowerDoubleQuadWord(n);
        }
    }

    @Override
    public long getUpperDoubleQuadWord(int n) {
        try {
            return this.getReadMemoryBlockAt(n).getUpperDoubleQuadWord(n & 0xFFF);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return super.getUpperDoubleQuadWord(n);
        }
    }

    @Override
    public void setWord(int n, short s) {
        try {
            this.getWriteMemoryBlockAt(n).setWord(n & 0xFFF, s);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            super.setWord(n, s);
        }
    }

    @Override
    public void setDoubleWord(int n, int n2) {
        try {
            this.getWriteMemoryBlockAt(n).setDoubleWord(n & 0xFFF, n2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            super.setDoubleWord(n, n2);
        }
    }

    @Override
    public void setQuadWord(int n, long l) {
        try {
            this.getWriteMemoryBlockAt(n).setQuadWord(n & 0xFFF, l);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            super.setQuadWord(n, l);
        }
    }

    @Override
    public void setLowerDoubleQuadWord(int n, long l) {
        try {
            this.getWriteMemoryBlockAt(n).setLowerDoubleQuadWord(n & 0xFFF, l);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            super.setLowerDoubleQuadWord(n, l);
        }
    }

    @Override
    public void setUpperDoubleQuadWord(int n, long l) {
        try {
            this.getWriteMemoryBlockAt(n).setUpperDoubleQuadWord(n & 0xFFF, l);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            super.setUpperDoubleQuadWord(n, l);
        }
    }

    @Override
    public void copyArrayIntoContents(int n, byte[] byArray, int n2, int n3) {
        int n4;
        do {
            n4 = Math.min(4096 - (n & 0xFFF), n3);
            Memory memory = this.getWriteMemoryBlockAt(n);
            if (memory instanceof PhysicalAddressSpace.UnconnectedMemoryBlock && this instanceof PhysicalAddressSpace) {
                memory = new LazyCodeBlockMemory(4096, ((PhysicalAddressSpace)this).getCodeBlockManager());
                ((PhysicalAddressSpace)this).mapMemory(n, memory);
            }
            memory.copyArrayIntoContents(n & 0xFFF, byArray, n2, n4);
            n += n4;
            n2 += n4;
        } while ((n3 -= n4) > 0);
    }

    @Override
    public void copyContentsIntoArray(int n, byte[] byArray, int n2, int n3) {
        int n4;
        do {
            n4 = Math.min(4096 - (n & 0xFFF), n3);
            this.getReadMemoryBlockAt(n).copyContentsIntoArray(n & 0xFFF, byArray, n2, n4);
            n += n4;
            n2 += n4;
        } while ((n3 -= n4) > 0);
    }

    protected abstract void replaceBlocks(Memory var1, Memory var2);

    @Override
    public abstract int executeReal(Processor var1, int var2);

    @Override
    public abstract int executeProtected(Processor var1, int var2);

    @Override
    public abstract int executeVirtual8086(Processor var1, int var2);
}

