/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.memory.codeblock;

import org.jpc.emulator.memory.codeblock.InstructionSource;

public class ArrayBackedInstructionSource
implements InstructionSource {
    private int[] microcodes;
    private int[] positions;
    private int readOffset;
    private int operationEnd;
    private int operationStart;
    private int x86Start;
    private int x86End;

    public ArrayBackedInstructionSource(int[] nArray, int[] nArray2) {
        this.microcodes = nArray;
        this.positions = nArray2;
        this.x86Start = 0;
        this.x86End = 0;
    }

    @Override
    public void reset() {
        this.x86Start = 0;
        this.x86End = 0;
        this.readOffset = 0;
        this.operationEnd = 0;
        this.operationStart = 0;
    }

    @Override
    public boolean getNext() {
        if (this.operationEnd >= this.microcodes.length) {
            return false;
        }
        this.readOffset = this.operationEnd++;
        this.operationStart = this.readOffset;
        this.x86Start = this.x86End;
        while (this.operationEnd < this.microcodes.length && this.positions[this.operationEnd] == this.positions[this.operationEnd - 1]) {
            ++this.operationEnd;
        }
        this.x86End = this.positions[this.operationEnd - 1];
        return true;
    }

    @Override
    public int getMicrocode() {
        if (this.readOffset < this.operationEnd) {
            return this.microcodes[this.readOffset++];
        }
        System.err.println("Critical error: Attempting to read past end of microcode array.");
        throw new IllegalStateException("Read past end of microcode array");
    }

    @Override
    public int getLength() {
        return this.operationEnd - this.operationStart;
    }

    @Override
    public int getX86Length() {
        return this.x86End - this.x86Start;
    }
}

