/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.memory.codeblock;

import org.jpc.emulator.memory.codeblock.CodeBlock;
import org.jpc.emulator.processor.Processor;

public abstract class SpanningCodeBlock
implements CodeBlock {
    private CodeBlock lastBlock;

    @Override
    public int getX86Length() {
        return 0;
    }

    @Override
    public int getX86Count() {
        try {
            return this.lastBlock.getX86Count();
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
    }

    @Override
    public int execute(Processor processor) {
        this.lastBlock = this.decode(processor);
        return this.lastBlock.execute(processor);
    }

    protected abstract CodeBlock decode(Processor var1);

    @Override
    public boolean handleMemoryRegionChange(int n, int n2) {
        return true;
    }

    @Override
    public void invalidate() {
    }

    @Override
    public String getDisplayString() {
        if (this.lastBlock != null) {
            return this.lastBlock.getDisplayString();
        }
        return "Undecoded Spanning Block";
    }
}

