/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.memory.codeblock;

import org.jpc.emulator.memory.LinearAddressSpace;
import org.jpc.emulator.memory.codeblock.ByteSourceWrappedMemory;
import org.jpc.emulator.memory.codeblock.CodeBlock;
import org.jpc.emulator.memory.codeblock.CodeBlockFactory;
import org.jpc.emulator.memory.codeblock.SpanningCodeBlock;
import org.jpc.emulator.memory.codeblock.Virtual8086ModeCodeBlock;
import org.jpc.emulator.processor.Processor;

class SpanningVirtual8086ModeCodeBlock
extends SpanningCodeBlock
implements Virtual8086ModeCodeBlock {
    private ByteSourceWrappedMemory byteSource = new ByteSourceWrappedMemory();
    private CodeBlockFactory[] factories;

    public SpanningVirtual8086ModeCodeBlock(CodeBlockFactory[] codeBlockFactoryArray) {
        this.factories = codeBlockFactoryArray;
    }

    @Override
    protected CodeBlock decode(Processor processor) {
        Virtual8086ModeCodeBlock virtual8086ModeCodeBlock = null;
        LinearAddressSpace linearAddressSpace = processor.linearMemory;
        int n = processor.getInstructionPointer();
        for (int i = 0; i < this.factories.length && virtual8086ModeCodeBlock == null; ++i) {
            try {
                this.byteSource.set(linearAddressSpace, n);
                virtual8086ModeCodeBlock = this.factories[i].getVirtual8086ModeCodeBlock(this.byteSource);
                continue;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        this.byteSource.set(null, 0);
        return virtual8086ModeCodeBlock;
    }

    public String toString() {
        return "Spanning Virtual8086 Mode CodeBlock";
    }
}

